
'use strinct';
(function ($, window) {
    JawApp.prototype.fixedSidebars = {
        init: function () {
            var $that = this;
            

            function setBottom($sidebar, scrollTop, left) {
                    var windowHeight = $(window).height();
                    var height = $sidebar.height();
                    var top = $sidebar.parent().offset().top + 60;
                    var $box = $sidebar.closest('.jw-fixed-sidebar-box');
                    var bottom_fixed = $box.offset().top + $box.height();
                    if (scrollTop + windowHeight - 30 > bottom_fixed) { //zarazi se o spodek sidebar boxu (prostor ve kterym je sidebar fixni)
                        $sidebar.addClass('is-fixed');
                        $sidebar.css('left', 'auto');
                        $sidebar.css('position', 'absolute');
                        $sidebar.css('bottom', 0);
                    } else if (top + height < scrollTop + windowHeight) { // scroluju - aplikuje se fixed sidebar
                        $sidebar.addClass('is-fixed');
                        $sidebar.css('left', left); 
                        $sidebar.css('bottom', '30px');
                        $sidebar.css('position', 'fixed');
                    } else { //jsem uplne nahore
                        $sidebar.removeClass('is-fixed');
                        $sidebar.css('position', 'relative');
                        $sidebar.css('left', 'auto');
                        $sidebar.css('bottom', '0'); 
                    }
            }; 
            $('.jw-fixed-sidebar-box .sidebar.fixed_on').parents('.builder-section').css('position', 'static');
            $('.sidebar.fixed_on .sidebar-box, .perex-box-inner.fixed_on').each(function () {
                var $sidebar = $(this);
                $sidebar.removeClass('is-fixed');
                $sidebar.css('left', 'auto');
                var width = $sidebar.width() - 1; 
                $sidebar.width(width);  
                var left = $sidebar.offset().left;
                var allowed = ($sidebar.closest('.jw-fixed-sidebar-box').height() - ($sidebar.offset().top - $sidebar.closest('.jw-fixed-sidebar-box').offset().top)) > $sidebar.height() + 100;
                if(allowed){
                    setBottom($sidebar, window.pageYOffset, left);
                }

                $('body').on('jaw-scroll', function (e, scrollTop) {
                    if(allowed){
                        setBottom($sidebar, scrollTop, left);
                    }
                });
                $('body').on('jaw-DOMchanged jaw-IsotopeLoaded', function () {
                    //sidebar musi byt o 100px vetsi nez box
                    $sidebar.removeClass('is-fixed');
                    $sidebar.css('position', 'relative'); 
                    $sidebar.css('left', 'auto');
                    $sidebar.css('width', '100%');
                    left = $sidebar.offset().left;
                    width = $sidebar.width() - 1;
                    $sidebar.width(width);
                    allowed = ($sidebar.closest('.jw-fixed-sidebar-box').height() - ($sidebar.offset().top - $sidebar.closest('.jw-fixed-sidebar-box').offset().top)) > $sidebar.height() + 100;
                    if(allowed){
                        setBottom($sidebar, window.pageYOffset, left);
                    }
                });
            });

        }
    };
})(jQuery, window); 