
'use strinct';
(function ($, window) {
    JawApp.prototype.fixedBar = {
        init: function () {
            var $that = this;
            //fixni menu, topbar, breadcrubs
            $that.doFix('jaw-fixed-bar');
            //fixni menu, topbar,  - na telefonu
            $that.doFix('jaw-mobile-fixed-bar');
        },
        doFix: function (fixedClass) {
            var $that = this;
            if ($('.' + fixedClass).length) {
                var heights = [];
                var offsets = [];
                var oldScrollTop = 0;
                var scrollingTop = 0;
                var setFix = function (scrollTop) {
                    $('.' + fixedClass).each(function (key, element) {
                        if ((scrollTop <= offsets[key]) //pokud je "fixed" objekt jeste na normalne viditelne pozici
                            || (scrollingTop > 5 && scrollTop < offsets[key] + heights[key + 1] && $(element).hasClass('jaw-fixed-bar-smart'))) {    //pokud je "smart fixed" objekt jeste na normalne viditelne pozici
                            //zobraz ho normalne
                            $(this).removeClass('jaw-fixed-on');
                            if (!$(this).hasClass('jaw-fixed-smart-on')) {
                                $(this).addClass('jaw-fixed-smart-on');
                                countFix();
                            }
                            $(this).css('top', 0);
                            if ($(this).next().hasClass('jaw-fixed-clone')) {
                                $(this).next().remove();
                                countFix();
                            }
                        } else {
                            var height = 0;
                            for (var i = 0; i <= key; i++) {
                                height += heights[i];
                            }
                            if (scrollingTop > 5 && $(element).hasClass('jaw-fixed-bar-smart')) { //scrolluju dolu
                                //schovej "fixni" element
                                $(this).css('top', height - $(this).height() - 2);
                                if ($(this).hasClass('jaw-fixed-smart-on')) {
                                    $(this).removeClass('jaw-fixed-smart-on');
                                    countFix();
                                }
                            } else {
                                //zobraz ho fixne
                                if (!$(this).hasClass('jaw-fixed-smart-on')) {
                                    $(this).addClass('jaw-fixed-smart-on');
                                    countFix();
                                }
                                $(this).addClass('jaw-fixed-on');
                                $(this).css('top', height);
                                if (!$(this).next('.jaw-fixed-clone').length) {
                                    $(this).after($('<div class="jaw-fixed-clone ' + fixedClass + '-clone"></div>').height(heights[key + 1]));
                                    countFix();
                                }

                            }
                        }
                    });
                    // odfiltrovani nahodneho skubnuti kolecka mysi - musim scrolnout 2x nahoru aby se provedla akce
                    if (scrollTop >= oldScrollTop) {
                        scrollingTop++;
                    } else {
                        scrollingTop = 0;
                    }
                    oldScrollTop = scrollTop;
                };

                //vypocitam vysky jednotlivych elementu a zaroven i portebny offset
                var countFix = function () {
                    heights = [];
                    offsets = [];
                    //pokud je admin bar tak + vyska admin baru
                    if ($(window).width() <= 600) {
                        heights.push(0);
                    } else if ($('.admin-bar').length) {
                        heights.push($('#wpadminbar').height() - 1);
                    } else {
                        heights.push(0);
                    }
                    $('.' + fixedClass).each(function (key, element) {
                        if ($(this).hasClass('jaw-fixed-bar-smart') && !$(this).hasClass('jaw-fixed-smart-on')) {
                            heights.push(0);
                        } else {
                            heights.push($(this).height());
                        }
                        var offsetAdmin = 0;
                        for (var i = 0; i <= key; i++) {
                            offsetAdmin += heights[i];
                        }

                        if ($(this).hasClass('jaw-fixed-on')) {
                            offsetAdmin = $(this).next().offset().top - offsetAdmin;
                        } else {
                            offsetAdmin = $(this).offset().top - offsetAdmin;
                        }
                        offsets.push(offsetAdmin);
                    });
                };

                $('body').on('jaw-DOMchanged', function (e) {
                    $(this).removeClass('jaw-fixed-on');
                    if ($(this).next().hasClass('jaw-fixed-clone')) {
                        $(this).next().remove();
                    }
                    $(this).css('top', 0);
                    countFix();
                    setFix(window.pageYOffset);
                });

                $('body').on('jaw-scroll', function (e, scrollTop) {
                    setFix(scrollTop);
                });


            }
        }
    };
})(jQuery, window); 