'use strinct';
(function ($) {
    JawApp.prototype.effects = {
        init: function () {
            var $that = this;
            $that.ripple();
            $that.containerAnimation();
            $that.imageHover();
            $('body').on('jaw-scroll-optimize', function (e, scrollTop) {
                $that.scroolOnCounterContainer(scrollTop);
            });
            $('body').on('jaw-DOMchanged', $that.imageHover); // image hover for user panel
        },
        templates: {
            ripple: '<span class="jw-ripple"></span>'
        },
        ripple: function () { //po kliknuti na button
            var $that = this;
            $('.jw-effect-ripple').each(function () {
                $(this).append('<span class="jw-ripple-container"></span>');
            });
            $('.jw-effect-ripple').on('click', function (e) {
                var $item = $(this);
                $item.find('.jw-ripple-container').append($that.templates.ripple);

                $(this).find('.jw-ripple').css('left', e.pageX - $item.offset().left);
                $(this).find('.jw-ripple').css('top', e.pageY - $item.offset().top);

                setTimeout(function () {
                    $item.find('.jw-ripple').addClass('jw-ripple-in');

                    $item.find('.jw-ripple-in').one("transitionend MSTransitionEnd webkitTransitionEnd oTransitionEnd", function (e) {
                        $(this).removeClass('jw-ripple-in');
                        $(this).addClass('jw-ripple-out');

                        $item.find('.jw-ripple-out').one('webkitTransitionEnd otransitionend oTransitionEnd msTransitionEnd transitionend',
                            function (e) {
                                $(this).remove();
                            });
                    });


                }, 50);

            });

        },
        smoothAnchorScrool: function () {
            $('a[href*=#]:not([href=#])').click(function () {
                if (location.pathname.replace(/^\//, '') == this.pathname.replace(/^\//, '') && location.hostname == this.hostname) {
                    var target = $(this.hash);
                    target = target.length ? target : $('[name=' + this.hash.slice(1) + ']');
                    if (target.length) {
                        $('html,body').animate({
                            scrollTop: target.offset().top
                        }, 1000);
                        target.addClass('jaw-target');
                        return false;
                    }
                }
            });
        },
        containerAnimation: function () {
            var $that = this;
            $('body').on('jaw-scroll-optimize', function (e, scrollTop) {
                $that.scroolOnAnimatedContainer(scrollTop);
            });
        },
        scroolOnAnimatedContainer: function (scrollTop) {
            var $that = this;
            $('.jaw-container[class*=jaw-animate-] > .jaw-container-content').each(function (id, element) {
                if ($that.checkScroll(element, scrollTop)) {
                    setTimeout(function () {
                        $(element).addClass('start');
                    }, 300);
                }
            });
        },
        scroolOnCounterContainer: function (scrollTop) {
            var $that = this;
            $('.jaw-counter').not('.done').each(function (id, element) {
                if ($that.checkScroll(element, scrollTop)) {
                    setTimeout(function () {
                        $(element).addClass('done').countTo();
                    }, 300);
                }
            });
        },
        checkScroll: function (el, scrollTop) {
            var $el = $(el);
            var docViewTop = scrollTop,
                docViewBottom = docViewTop + $(window).height(),
                elemTop = $el.offset().top,
                elemBottom = elemTop + $el.height();
            // Pokud je vrchni hrana elementu (fotky) nad spodni hranou obrazovky
            // a zaroven spodni hrana elementu (fotky) je pod horni hranou obrazovky.
            // + 300 rezerva
            return ((elemTop <= docViewBottom) && (elemBottom >= docViewTop));
        },
        // JAW Image hover effect
        //jaw-hvr-zoomie
        //jaw-hvr-pulsie
        //jaw-hvr-blackie
        imageHover: function () {
            var effects = {
                type: "name",
                names: [ // effect names
                    "zoomie",
                    "pulsie",
                    "blackie"
                ],
                live: false
            };
            for (var i = 0; i < effects.names.length; i++) {
                if ($(".jaw_image_hover_type_" + effects.names[i]).length) { // exists
                    effects.type = effects.names[i];
                    effects.live = true;
                }
            }
            // jaw hover effect is active
            if (effects.live) {

                var $effectElements = $('.jaw_image_hover_type_' + effects.type + ' .slider-item-inner,' +
                    '.jaw_image_hover_type_' + effects.type + ' .jaw-user-panel-content article,' +
                    '.jaw_image_hover_type_' + effects.type + ' .jaw-slider-img-item,' +
                    '.jaw_image_hover_type_' + effects.type + ' .image')
                    .not('.gallery');
                // include     
                if (effects.type === "pulsie") {
                    //pokud zatim pred obrazkem neni jaw-image-hover-bg
                    if (!$effectElements.find('.jaw-image-hover-bg').length) {
                        $effectElements.find("img").before("<div class='jaw-image-hover-bg'></div>"); // add background color for pulsie effect
                    }
                }
                $effectElements.find("img").addClass('jaw-hvr-' + effects.type); // add class
                // exclude
                var excludeItems = new Array(
                    ".jaw_single_img",
                    ".jaw-slider_4", // jaw slider 4
                    "body.attachment .attachment" // attachment page
                );
                for (i = 0; i < excludeItems.length; i++) {
                    if ($(excludeItems[i]).length) {
                        $(excludeItems[i]).find("img").removeClass('jaw-hvr-' + effects.type);
                    }
                }
            }
        }

    };
})(jQuery); 