/* JAW Carousels */
'use strinct';
(function($) {
    JawApp.prototype.carousels = {
        init: function() {
            var $that = this;
            
            // Lets rock
            $that.carousel(".carousel");
            $that.galleryCarousel('.jaw-gallery-shortcode');
            $that.ticker();
            
            $that.sliders();
            $that.slider5();
        },

        // All carousels
        carousel: function(selector) {
            var $that = this;
            var $selector = $(selector); 
            
            // carousel stop sliding after not focusing
            $(window).blur(function(e) {
                $selector.carousel('pause');
            });
            // carousel continue sliding after focusing
            $(window).focus(function(e) {
                $selector.carousel({
                    interval: 5000
                }); 
            });
            // drag it
            $selector.each(function(key,element){
        
                var $element = $(element);
                
                $('body').on('jaw-DOMchanged',function(){
                    $that.carouselHeight(element);
                });  
                //pri initializaci  nactu vsechny fotky v carouselu podle prvni aktivni fotky (aby tam pak nedoskakovaly)
                $('body').trigger('jaw-responsiveImg',[$element.find('img'), undefined, $element.find('.active').find('img').width()]);
                
                
                $element.parent().hammer().on("swipeleft swiperight", function(ev) {
                    
                    if(!$(".ticker-switched").length) { // breaking news opened
                        switch(ev.type) {
                            case "swipeleft" :
                                $element.carousel("next");
                                break;
                            case "swiperight" :
                                $element.carousel("prev");
                                break;
                            default:
                                break;
                        } 
                    }
                });
            });
        },
        
        carouselHeight: function(element){
            var max_height_carousel = 0;
            var $items = $(element).find('.item');
            $items.each(function(k, el) {
                var el_height = $(el).height();
                if (max_height_carousel < el_height) {
                    max_height_carousel = el_height;
                }
            });
            $items.height(max_height_carousel);
        },
        
        // Gallery carousels
        galleryCarousel: function(selector) {
            $(selector).each(function(key, element){
                $(element).attr("id",'jaw-gallery-slick'+key);
                $('#jaw-gallery-slick'+key + ' .gallery-slider').slick({
                    slidesToShow: 1,
                    slidesToScroll: 1,
                    arrows: true,
                    autoplay: true,
                    centerMode: true,
                    centerPadding: 0,
                    asNavFor: '#jaw-gallery-slick'+key + ' .gallery-thumbnails',
                    prevArrow: '<div class="slick-prev"><span class="jaw-icon-sipka-gallery-left"></span></div>',
                    nextArrow: '<div class="slick-next"><span class="jaw-icon-sipka-gallery-right"></span></div>'
                });
                $('#jaw-gallery-slick'+key + ' .gallery-thumbnails').slick({
                    slidesToShow: 3, 
                    slidesToScroll: 1,
                    asNavFor: '#jaw-gallery-slick'+key + ' .gallery-slider',
                    dots: false,
                    centerMode: false,
                    focusOnSelect: true,
                    arrows: false
                });
            });
        },
        
        // Ticker - breaking news
        ticker: function() {
            var $ticker = $(".jaw-ticker.news");

            if($ticker.length) {
                $(document).click( function(){
                    $ticker.each(function(key, element){
                        var $element = $(element);
                        $element.find(".ticker-carousel-wrapper").removeClass("ticker-switched");
                        $element.find('.ticker-switcher').show();
                    });
                }); 
                $ticker.each(function(key, element){
                    var $element = $(element);
                    $element.find(".ticker-switcher").on("click",function(e){
                        $element.find(".ticker-carousel-wrapper .carousel").carousel("pause");
                        $element.find(".ticker-carousel-wrapper").addClass("ticker-switched");
                        $element.find(".ticker-switcher").hide();
                        $element.find(".item").height('100%');
                        e.stopPropagation();
                    });
                });
            }
        }, 
        
        // Sliders
        sliders: function() {
            // slider 3
            $(".slider_3_slide img").removeClass("jaw-hide-image"); // fix for slider_3 preventing img dissepear
            $('.slider_3_slide .item').each(function(){
                var next = $(this).next();
                if(!next.length) {
                    next = $(this).siblings(':first');
                }
                next.children(':first-child').clone().appendTo($(this));
                if(next.next().length>0) {
                    next.next().children(':first-child').clone().appendTo($(this));
                }
                else {
                    $(this).siblings(':first').children(':first-child').clone().appendTo($(this));
                }
            });
            //synchronize sliders 3  main and thumbnails
            $(".slider_3_main").on("slide.bs.carousel",function(e){
                // here you can change direction
                if(e.direction == "right") {
                    $(this).parents(".builder-section").find(".jaw-navigate-slider .carousel").carousel("next");
                } else {
                    $(this).parents(".builder-section").find(".jaw-navigate-slider .carousel").carousel("prev");
                }
            });
            
            $(".slider_3_slide").on("mouseenter",function(e){
                $(this).parents('.jaw-slider-3-wrapper').find('.slider_3_main').trigger('mouseenter');
            }).on('mouseleave',function(){
                $(this).parents('.jaw-slider-3-wrapper').find('.slider_3_main').trigger('mouseleave');
            });
                
            $(".blog-slider-arrows").hide();
            var content="";
            var arrowpadding = 60; // categories label - margin
            var containerbox = 200; // default height
            var additional = 0;
            $('.jaw-blog-slider.special-big').each(function(key, element) {
                var max_height_carousel = 0;
                $(element).find('.item').each(function(k, el) {
                 var el_height = $(el).height();
                 if (max_height_carousel < el_height) {
                     max_height_carousel = el_height;
                     containerbox = $(element).find(".jw-container").height();
                     additional=max_height_carousel-$(element).find("article").height();
                 }
                });
                $(element).find('.item').height(max_height_carousel);
                content = $(element).find('.content-border-wrapper').height();
                // arrows
                $(element).find(".right.special-big,.left.special-big").css({"position":"absolute","bottom":"0","width":arrowpadding,"height":containerbox+additional});
            });
            $(".blog-slider-arrows").show();
        },
        slider5: function(){
            $('.slider_5_navigate .jaw-slider-item').on('mouseenter',function(e){
                var $that = $(this);
                $that.trigger('click.bs.carousel.data-api',[e]);
                $that.parents('.slider_5_main').trigger('mouseenter');
            });              
            $('.slider_5_navigate .jaw-slider-item').on('click',function(){
                window.location.href = $(this).attr('href'); 
            });
        }
    };
})(jQuery);