/*
 * APP js
 *
 * contains the core functionalities to be used
 * inside APP
 * 
 * 
 * Triggers used in JaW scripts:
 * -----------------------------
 *  jaw-IsotopeLoaded
 *  jaw-DOMchanged
 *  jaw-scroll-optimize
 *  jaw-scroll
 *  jaw-windowResized
 * -----------------------------
 * 
 */
'use strinct';

(function ($) {
    var uniqueCntr = 0;
    $.fn.scrolled = function (waitTime, fn) {
        if (typeof waitTime === "function") {
            fn = waitTime;
            waitTime = 100;
        }
        var tag = "scrollTimer" + uniqueCntr++;
        this.scroll(function () {
            var self = $(this);
            var timer = self.data(tag);
            if (timer) {
                clearTimeout(timer);
            }
            timer = setTimeout(function () {
                self.removeData(tag);
                fn.call(self[0]);
            }, waitTime);
            self.data(tag, timer);
        });
    };
})(jQuery);

(function ($) {
    $.fn.jawOptimize = function (tag, waitTime, fn) {
        if (typeof waitTime === "function") {
            fn = waitTime;
            waitTime = 100;
        }
        tag = "scrollTimer-" + tag;
        var self = $(this);
        var timer = self.data(tag);
        if (timer) {
            clearTimeout(timer);
        }
        timer = setTimeout(function () {
            self.removeData(tag);
            fn.call(self[0]);
        }, waitTime);
        self.data(tag, timer);
    };
})(jQuery);


var JawApp = function () {
};
(function ($, window) {
    JawApp.prototype = {
        ready: function () {
            var $that = this;
            $that.utils.init();
            $that.interest.hooks($that.utils); //DI
            $that.responsive.init();
            $that.jawmenu.init();
            $that.userRating();
            $that.effects.init();
            $that.likes();
            $that.readersCount();
            $that.gallery.init();
            $that.utils.modernizr();
            $that.skyscrapper.init();
            $that.fixedSidebars.init();
            $that.fixedBar.init();
            $that.layzOpenItem.init(); 
            $('body').on('jaw-IsotopeLoaded', function () {
                $that.likes();
            });
            $('body').on('jaw-DOMchanged', $that.isotope.reLayout);
            $('body').on('jaw-DOMchanged', $that.utils.reviewFontSize); 

            // @rami 10.2.2017 - ie9 > verze opraveno pro odpaleni customeventu
            (function () {
                function CustomEvent ( event, params ) {
                    params = params || { bubbles: false, cancelable: false, detail: undefined };
                    var evt = document.createEvent( 'CustomEvent' );
                    evt.initCustomEvent( event, params.bubbles, params.cancelable, params.detail );
                    return evt;
                }

                CustomEvent.prototype = window.Event.prototype;

                window.CustomEvent = CustomEvent; 
            })
            ();

            // @rami 10.2.2017 - customevent nefunguje pro ie od 9 >
            var RunSlidersEvent = new CustomEvent("jaw-RunSliders");
            document.dispatchEvent(RunSlidersEvent);
        },
        resize: function () {
            var $that = this;
            $that.responsive.init();
            $that.utils.reviewFontSize();
            $that.utils.keepRatio();
            $that.isotope.init();
        },
        errors: []
    };
})(jQuery, window);

var jaw_theme;
var ajax_object = ajax_object || { ajax_url: '', ajax_nonce: '' };

(function ($, window, document, jaw_theme) {
    jaw_theme = new JawApp();

    //detect nojs (old IE)
    var nojs = false;
    if ($('html').is('.no-js')) {
        nojs = true;
    }
    if (!nojs) {
        $(document).ready(function () {
            jaw_theme.ready();
        });
        $(window).resize(function () {
            $(window).jawOptimize('jaw-DOMchanged', function () {
                jaw_theme.resize();
                $('body').trigger('jaw-DOMchanged');
            });
            $(window).jawOptimize('jaw-windowResized', function () {
                $('body').trigger('jaw-windowResized');
            });
        });
        window.onload = function () {
            jaw_theme.resize();
            jaw_theme.carousels.init(); // presunuto z initu sem - carousel delal bordel (natahoval) s vyskou
            $(window).jawOptimize('jaw-DOMchanged', function () {
                $('body').trigger('jaw-DOMchanged');
            });
            //po nacteni proved "scroll"
            $('body').trigger('jaw-scroll-optimize', [window.pageYOffset]);

            //pokud mam ve widgetu fb-iframe 
            if(typeof(FB) != 'undefined' && FB != null ){
                FB.Event.subscribe('xfbml.render', function (response) {
                    $('body').trigger('jaw-DOMchanged');
                });
            }
        };
        $(window).scroll(function () {
            $('body').trigger('jaw-scroll', [window.pageYOffset]);
        });
        $(window).scrolled(function () {
            $('body').trigger('jaw-scroll-optimize', [window.pageYOffset]);
        });
        window.onerror = function (err) {
            jaw_theme.errors.push(err);
        };
        $('body').on('jaw-oneIsotope', function (event, el) {
            jaw_theme.isotope.oneIsotope(el);
        });

        $('.jaw-container-content, .fixed_on').mousewheel(function (event, delta) {
            //none - musi to tu byt, aby paralaxy byly smooth
        });
    }
})(jQuery, window, document, jaw_theme);


//google maps
function JawGoogleMapLoaded() {
    jQuery("body").trigger("jaw_g_maps");
}