<!doctype html>
<!--[if lt IE 7]> <html class="no-js ie6 oldie" lang="en"> <![endif]-->
<!--[if IE 7]>    <html class="no-js ie7 oldie" lang="en"> <![endif]-->
<!--[if IE 8]>    <html class="no-js ie8 oldie" lang="en"> <![endif]-->
<!--[if gt IE 8]><!-->
<html class="no-js" <?php language_attributes(); ?> >
<!--<![endif]-->

<head>
      <?php
        wp_head();
        ?>
</head>

<body <?php body_class(); ?> >
  <!--[if lt IE 9]>
            <div class="jaw_msg jaw_msg_type_warning jaw-fixed-on">
            <?php  esc_html_e('You are using an outdated version of Internet Explorer.  For security reasons you should upgrade your browser. Please go to Windows Updates and install the latest version.','gdn-theme'); ?>
            </div>
        <![endif]-->
        <noscript>
            <div class="jaw_msg jaw_msg_type_warning jaw-fixed-on">
            <?php  esc_html_e('Please turn the Javascript on.','gdn-theme'); ?>
                </div>
        </noscript>
  <?php
        $body_content_class = array();
        $body_content_class[] = jwOpt::get_option('background_image_pattern', 'no-pattern');
        $body_content_class[] = 'jaw_image_cropping_' . jwOpt::get_option("image_cropping");
        $body_content_class[] = 'jaw_image_hover_type_' . jwOpt::get_option("image_hover_effect_type");
        $body_content_class[] = 'jaw_input_effect_'.jwOpt::get_option("input_effect_placeholder");
        $body_content_class[] = 'jaw_to_top_mobile_'.jwOpt::get_option('totop_show', '0');
        $body_content_class[] = 'jaw_prettyphoto_gallery_'.jwOpt::get_option('post_pp_galery', '0');
// 
        if(jwOpt::get_option('showup_video', '1')) { // masonry (isotop)
            $body_content_class[] = "jaw-showup-video-on";
        }
// 

        if(jwOpt::get_option('isotope_grid', '1')) { // masonry (isotop)
            $body_content_class[] = "jaw-isotop-on";
        }

// 
        if(is_single() && jwOpt::get_option("tweet_me","1") == 1) {
            $tweet_me_img = jwOpt::get_option("tweet_me_img");
            if($tweet_me_img && !empty($tweet_me_img)) {
                echo '<a id="jaw-tweet-me"><img src="'.esc_url($tweet_me_img).'" /></a>';
            }
        }
// 

        ?>
    <div class="body-content <?php echo esc_attr(implode(' ', $body_content_class)); ?>">
      <?php unset($body_content_class); ?>
        <div id="container" class="container" role="document">

        <?php
// 
        jwRender::get_banner('skyscrapper_left');
        
        jwRender::get_banner('skyscrapper_right');
// 

        if (jwOpt::get_option('totop_show', '0') !== '0') {
            echo jaw_get_template_part('to_top', 'header');
        }
        
        echo jaw_get_template_part('mobile-menu', array('header', 'menu'));

// 
        echo jaw_get_template_part('mobile-userpanel', array('header', 'menu'));
// 
        ?>

            <!-- Start the template box -->
            <div id="template-box">
              <!-- Row for blog navigation -->
              <div id="header">
                <div class="row-fullwidth jaw-head">
                <?php
                echo jaw_get_template_part('header', 'header');
                ?>
                </div>
                <?php
// 
        if ((is_front_page() && jwOpt::get_option('featured_show', 'off') == 'home') || jwOpt::get_option('featured_show', 'off') == 'all_web')  {
            echo jaw_get_template_part('featured-area', 'featured-area');
        }
// 
        echo jaw_get_template_part('page-title', 'header');
        ?>
              </div>
              <!-- Row for main content area -->
              <div id="main" class="row jw-fixed-sidebar-box">