<?php
/**
* Base loader and theme initialization
*
* @author JaW Templates <http://www.jawtemplates.com>
* @copyright (c) 2013, CCB, spol. s r.o.
* @version 1.0
*/
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
// 
/* ===========================================================================================
WPML AFFILIATE - must be placed before init event
/* ===========================================================================================*/
include get_template_directory() . '/installer/loader.php';
WP_Installer_Setup($wp_installer_instance,
    array(
        'plugins_install_tab' => 1, // optional, default value: 0
        'affiliate_id:wpml' => '162993', // optional, default value: empty
        'affiliate_key:wpml' => 'D6qDXjqye4W1', // optional, default value: empty
        'src_name' => 'GDN Magazine Theme', // optional, default value: empty, needed for coupons
        'src_author' => 'jawtemplates',// optional, default value: empty, needed for coupons
        'repositories_include' => array('wpml') // optional, default to empty (show all)
    )
);
/* ===========================================================================================*/
// 
// 

add_action('after_setup_theme', 'jaw_language');
add_action('after_setup_theme', 'jaw_theme_supports');
add_action('init', 'jaw_init', 0);
// Load admin options
if(is_admin()) {
    add_action('init', 'jaw_admin_start', 1);
}

// Goodstore Welcome Page
add_action('admin_init', 'jaw_welcome');

//We are using our own responsive images so disable WordPress solution
add_filter( 'wp_calculate_image_srcset', 'jaw_disable_srcset' );

add_action('init', 'jaw_controll_responsive');

/* ===========================================================================================
*                                          INIT THEME
* ==========================================================================================*/
function jaw_init() {
    
    // Define constants.
    jaw_constants();
    
    // Load framework.
    jaw_libs();
    
    //add hooks
    jaw_hooks();
    
    //start theme
    jaw_start();
}

function jaw_hooks(){
    // Add css
    add_action('wp_enqueue_scripts', 'jaw_css', 50);
    add_action('admin_enqueue_scripts', 'jaw_admin_css', 50);
    
    // Add js
    add_action('wp_enqueue_scripts', 'jaw_wp_scripts');
    add_action('admin_enqueue_scripts', 'jaw_admin_scripts',1);
    
    //header
    add_action('wp_head', array('jwUtils', 'get_social_meta'),5);
    add_action('wp_head', array('jwUtils', 'setTelAutodetection'),5);
    add_action('wp_head', array('jwUtils', 'header'), 0);
    add_action('admin_head', array('jwUtils', 'admin_header'), 0);    
    
    //Footer
    add_action('wp_footer', array('jwUtils', 'footer_socials'));
    add_action('wp_footer', array('jwUtils', 'footer_google_fonts'),99);
    
    //Body class
    add_filter('body_class', array('jwUtils', 'body_class'));
    
    //Post class
    add_filter('post_class', array('jwUtils', 'post_class'));
       
    //ukoncovac excerptu
    add_filter('excerpt_more', 'jaw_excerpt_more');
    
    // init cache
    if (!file_exists(WP_CONTENT_DIR . '/cache/') && function_exists('mkdir') && is_writable(WP_CONTENT_DIR . '/cache/')) {
        mkdir(WP_CONTENT_DIR . '/cache');
    }
    
// 
    //add themeoptions link to top bar
    add_action('admin_bar_menu', 'jaw_modify_admin_bar', 99);
// 

    //sidebar manager
    add_action('wp_ajax_jaw_add_sidebar', array('jwElements', 'jaw_add_sidebar'));

    //increase reader AJAX
    add_action('wp_ajax_jaw_increase_readers_count', array('jwUtils', 'increase_readers_count'),99);
    add_action('wp_ajax_nopriv_jaw_increase_readers_count', array('jwUtils', 'increase_readers_count'),99);
    
    //dulezity pro revoComposer - jinak se bude printovat i v hlavicce
    add_filter('get_the_excerpt', 'jaw_excerpt_strip_shortcodes', 5);
        
    //TINY MCE
    add_filter('mce_buttons_2', array('jwUtils', 'jaw_mce_buttons_2'));
    
    // RSS - pridani attachmentu
    add_filter('rss2_item', 'jaw_rss_post_thumbnail');
    add_filter('rss_item', 'jaw_rss_post_thumbnail');
    add_filter('the_excerpt_rss', 'jaw_rss_noi_frame');
    add_filter('the_content_feed', 'jaw_rss_noi_frame');

    // add noscript before script tag 
    add_filter( 'style_loader_tag', 'jaw_style_loader_tag', 10, 3 );

    //post boxes
    add_action("jaw_postbox_classical", array("jwRender", "postboxTitle"), 5, 1);
    add_action("jaw_postbox_classical", array("jwRender", "postboxExcerpt"), 10, 1);
    add_action("jaw_postbox_classical", array("jwRender", "postboxMeta"), 15, 1);

    add_action("jaw_postbox_simple", array("jwRender", "postboxTitle"), 5, 1);
    add_action("jaw_postbox_simple", array("jwRender", "postboxMeta"), 15, 1);

    add_action("jaw_postbox_vertical", array("jwRender", "postboxTitle"), 5, 1);
    add_action("jaw_postbox_vertical", array("jwRender", "postboxExcerpt"), 10, 1);
    add_action("jaw_postbox_vertical", array("jwRender", "postboxMeta"), 15, 1);

    add_action("jaw_postbox_vertical_small", array("jwRender", "postboxTitle"), 5, 1);
    add_action("jaw_postbox_vertical_small", array("jwRender", "postboxExcerpt"), 10, 1);
    add_action("jaw_postbox_vertical_small", array("jwRender", "postboxMeta"), 15, 1);

    add_action("jaw_postbox_vertical_big", array("jwRender", "postboxTitle"), 5, 1);
    add_action("jaw_postbox_vertical_big", array("jwRender", "postboxExcerpt"), 10, 1);
    add_action("jaw_postbox_vertical_big", array("jwRender", "postboxMeta"), 15, 1);
}


function jaw_start(){
    
    // Zavedeni optu
    new jwOpt();
    
    //INIT JAW plugins
    jaw_init_plugins();
    
    //posts likes
    new jwLikes();
    
    // register sidebar
    new jwSidebars(jwOpt::get_option('sidebars'), null);
    
    if (jwOpt::get_option('theme_revoComposer', '1') == '1') {
        // Zavedeni RevoComposeru
        new jwBuilder();
    }
    
    //jaw translation
    if(jwOpt::get_option('use_translation', '0')){
        //_x, _ex, esc_attr_x, esc_html_x to zatim neumi
        add_filter( 'gettext', array('jwUtils', 'jaw_translation'), 10, 3);
        add_filter( 'ngettext', array('jwUtils', 'jaw_ntranslation'), 10, 5);
    }
        
    //redirect after login
    if(jwOpt::get_option('user_bar_login_pageid', '_default') != '_default'){
        //redirect for subscribers
        add_filter( 'login_redirect', 'jaw_login_redirect', 10, 3 );
    }
    //redirect after WRONG login
    if(jwOpt::get_option('user_bar_wrong_login_pageid', '_default') != '_default'){
        add_action('wp_login_failed', 'jaw_redirect_login_failed');
    }

    // CUSTOMIZE theme API - color scheme
    if(function_exists('is_customize_preview') && is_customize_preview()){
        new jwCustomizer();
    }

    if (is_admin()) {
        //Check write to file
        jwUtils::check_write_to_file();
    }

    // REGISTER new user
    if (!is_admin()) {
        if (filter_input(INPUT_POST, 'jaw-register') !== null) {
            jwUtils::register_new_user();
        }
    }

    // uzvatelsky zavisly obsah
    if (is_user_logged_in()) {
        jwInterest::bootstrap();
    }

    //odstraneni spanu class="more". Kdyz byl za <more> vlozeny shortcode, zpusoboval prazdny p tag za <more>.
    add_filter('the_content', 'jaw_remove_more_span', 12);

    // Comments - Anti-spam filter
    if (jwOpt::get_option('comments_antispam_toggle', '0') == '1') {
        add_filter('preprocess_comment', array('jwUtils', 'jaw_nobot_question_filter'));
    }
    
    //cache - verions of assets
    if(jwOpt::get_option('cache', '1') === '1'){
        add_filter( 'style_loader_src', 'jaw_remove_wp_ver_css_js', 9999 );
        add_filter( 'script_loader_src', 'jaw_remove_wp_ver_css_js', 9999 );
    }

    // ???
    add_filter('tiny_mce_before_init', 'jaw_add_i_frame');
    include_once ABSPATH . '/wp-admin/includes/nav-menu.php';
    load_template(ABSPATH . 'wp-admin/includes/image.php');


    // Po instalaci sablony se nastavi zakladni parametry.
    $jaw_install = get_option('jaw_install');
    if ($jaw_install == null) {
       jaw_after_install_theme();
    }
    if ($jaw_install < 3 && is_admin()  && current_user_can('install_plugins')) {
       $jwWelcome = new jwWelcome();
    }

    if(false){
        $thumbnail = get_the_post_thumbnail('thumbnail'); //@todo odstranit
    }

    // image cropping
    // because image sizes are registered in after_setup_theme - too early for jwOpt
    update_option('img_cropping', esc_attr(jwOpt::get_option("image_cropping", 1))); 
}

// Load admin options
function jaw_admin_start(){
    //styles
    add_action('jaw_generate_styles', 'jaw_generate_styles', 10, 1);
    //pri importu dema neukladej metaboxy
    add_action('import_start', 'jaw_deregister_generate_styles',12);
     
    // Zavedeni theme optionsu
    new jwPanel();

    ///vypnuti JaW cache
    if(jwOpt::get_option( 'cache', '0' )) {
        jwOpt::update_option( 'cache', '0' );
        add_action( 'admin_notices', 'jaw_cache_turnoff' );
    }
    
    
    //Nacteni metaboxu, metapage a metacat
    load_template(JAW_ADMIN_DIR . 'options/metaboxes.php', true);
    
    // 
    load_template(JAW_ADMIN_DIR . 'options/category_preset.php', true);
    load_template(JAW_ADMIN_DIR . 'options/single_preset.php', true);
    load_template(JAW_ADMIN_DIR . 'options/export_preset.php', true);
    // 
    
    load_template(JAW_ADMIN_DIR . 'options/color_preset.php', true);
    
    global $metapost, $metacat, $metapage, $metapostformats;
    
    new jwMetabox($metapost);
    new jwMetabox($metapage);
    new jwMetabox($metapostformats);
    
    new jwMetatax($metacat, 'category');
    
    
    if (jwOpt::get_option('switch_udate', '1') == '1') {
        
        // Overeni updatu sablony
        new ThemeUpdateChecker(
        JAW_THEMESLUG, 'http://support.jawtemplates.com/info/update.php'
        );
    }
}
/*=======================================END================================================*/





/* ===========================================================================================
*                          ADD COLORS PREVIEW TO CATEGORY LIST
* ==========================================================================================*/
add_filter('manage_edit-category_columns', 'jaw_manage_my_category_columns');
add_filter('manage_category_custom_column', 'jaw_column_return_value', 10, 3);

function jaw_manage_my_category_columns($columns) {
    $columns['jaw-color'] = esc_html__('Color', "gdn-theme");
    return $columns;
}

function jaw_column_return_value($value, $columnName, $taxonomyId = 0) {
    if ($columnName == 'jaw-color') {
        $preset = jwOpt::checkDefaultPreset(array(jwOpt::get_option("content_color", "_default", "category", $taxonomyId), jwOpt::get_option("main_color")),'color');
            $presets = jwOpt::loadPreset('color', $preset);
            $finalPreset1 = '#ffffff';
            $finalPreset2 = '#000000';
            $finalPresetName = 'Please set Main Color Scheme in Theme Options -> Color Settings';
            if (isset($presets['theme1']) && isset($presets['theme3']) && isset($presets['title'])) {
                $finalPreset1 = $presets['theme1'];
                $finalPreset2 = $presets['theme3'];
                $finalPresetName = $presets['title'];
        } else {
            $presets = jwOpt::loadPreset('color', jwOpt::get_option("main_color"));
            if(isset($presets['theme1']) && isset($presets['theme3']) && isset($presets['title'])){
                $finalPreset1 = $presets['theme1'];
                $finalPreset2 = $presets['theme3'];
                $finalPresetName = $presets['title'];
            }
        }
    $value = '<div style="text-align:center;box-shadow: 0 1px 6px 0 rgba(0,0,0,.12),0 1px 6px 0 rgba(0,0,0,.12); }display: block;padding: 15px;background-color:' . $finalPreset1 . '"><a href="' . JAW_SITE_URL . '/wp-admin/edit-tags.php?action=edit&taxonomy=category&tag_ID=' . $taxonomyId . '#section-content_color"><span style="color:' . $finalPreset2 . ';">' . $finalPresetName . '</span></a></div>';
}

return $value;
}
/*=======================================END================================================*/





/* ===========================================================================================
*                          ADD COLORS PREVIEW TO PAGE LIST
* ==========================================================================================*/

add_filter('manage_edit-page_columns', 'jaw_manage_my_page_columns');
add_action('manage_pages_custom_column', 'jaw_custom_set_pages_columns_page_id', 10, 2);

function jaw_manage_my_page_columns($columns) {
    $columns['jaw-page-color'] = esc_html__('Color', "gdn-theme");
    return $columns;
}

function jaw_custom_set_pages_columns_page_id($columnName, $pageId) {
    if ($columnName == 'jaw-page-color') {
        $preset = jwOpt::checkDefaultPreset(array(get_post_meta($pageId, 'jaw_page_color', true), jwOpt::get_option("main_color")),'color');
        $presets = jwOpt::loadPreset('color', $preset);
        $finalPreset1 = '#ffffff';
        $finalPreset2 = '#000000';
        $finalPresetName = 'Please set Main Color Scheme in Theme Options -> Color Settings';
        if (isset($presets["theme1"]) && isset($presets["theme3"]) && isset($presets["title"])) {
            $finalPreset1 = $presets["theme1"];
            $finalPreset2 = $presets["theme3"];
            $finalPresetName = $presets["title"];
        } else {
            $presets = jwOpt::loadPreset('color', jwOpt::get_option("main_color"));
            if(isset($presets["theme1"]) && isset($presets["theme3"]) && isset($presets["title"])){
                $finalPreset1 = $presets["theme1"];
                $finalPreset2 = $presets["theme3"];
                $finalPresetName = $presets["title"];
            }
        }
    echo '<div style="text-align:center;box-shadow: 0 1px 6px 0 rgba(0,0,0,.12),0 1px 6px 0 rgba(0,0,0,.12); }display: block;padding: 15px;background-color:' . $finalPreset1 . '"><a href="' . JAW_SITE_URL . '/wp-admin/post.php?post=' . $pageId . '&action=edit#section-jaw_page_color"><span style="color:' . $finalPreset2 . ';">' . $finalPresetName . '</span></a></div>';
}
}

/*=======================================END================================================*/

function jaw_rss_noi_frame($content) {
    $content = preg_replace('/<iframe(.*)\/iframe>/is', '', $content);
    
    return $content;
}

function jaw_rss_post_thumbnail() {
    global $post;
    if (has_post_thumbnail($post->ID)) {
        $img = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), "jaw_blog-16_9");
        if (isset($img[0])) {
            list($width, $height, $type, $attr) = getimagesize($img[0]);
            echo '<enclosure url="' . $img[0] . '" type="' . image_type_to_mime_type($type) . '" length="1" />';
        }
    }
}

function jaw_add_i_frame($initArray) {
    $initArray['extended_valid_elements'] = "iframe[id|class|title|style|align|frameborder|height|longdesc|marginheight|marginwidth|name|scrolling|src|width]";
    return $initArray;
}

function jaw_theme_supports() {
    
    $autocrop = 0;
    if (get_option("img_cropping") == 1) {
        add_image_size('jaw_slider-square', 500, 500, true); // 1:1
        add_image_size('jaw_blog-special', 275, 275, true); // 1:1
        add_image_size('jaw_blog-16_9-big', 878, 494, true); // 16:9
        add_image_size('jaw_blog-16_9', 475, 267, true); // 16:9
        add_image_size('jaw_blog-16_9-middle', 270, 152, true); // 16:9
        add_image_size('jaw_blog-16_9-small', 170, 95, true); // 16:9
        add_image_size('jaw_blog-mini', 72, 49, true);
    } else {
        add_image_size('jaw_slider-square', 500, $autocrop, true);
        add_image_size('jaw_blog-special', 275, $autocrop, true);
        add_image_size('jaw_blog-16_9-big', 878, $autocrop, true);
        add_image_size('jaw_blog-16_9', 475, $autocrop, true);
        add_image_size('jaw_blog-16_9-middle', 270, $autocrop, true);
        add_image_size('jaw_blog-16_9-small', 170, $autocrop, true);
        add_image_size('jaw_blog-mini', 72, $autocrop, true);
    }
    
    
    
    if (function_exists('add_theme_support')) {
        
        // Add post thumbnail supports. http://codex.wordpress.org/Post_Tphumbnails
        add_theme_support('post-thumbnails');
        
        // Add post formarts supports. http://codex.wordpress.org/Post_Formats
        add_theme_support('post-formats', array('gallery', 'image', 'quote', 'video', 'link'));
        
        // Add menu supports. http://codex.wordpress.org/Function_Reference/register_nav_menus
        add_theme_support('menus');
        register_nav_menus(array(
        'primary_navigation' => esc_html__('Primary Navigation', "gdn-theme"),
        'primary_mobile_navigation' => esc_html__('Primary Mobile Navigation', "gdn-theme"),
        'top_bar_navigation' => esc_html__('Top Bar Navigation', "gdn-theme"),
        'footer_navigation' => esc_html__('Footer Navigation', "gdn-theme"),
        ));
        
        add_editor_style('/css/editor-style.css');
        
        //This enables post and comment RSS feed links to head. This should be used in place of the deprecated automatic_feed_links.
        add_theme_support('automatic-feed-links');
        
        // reference to: http://codex.wordpress.org/Function_Reference/add_editor_style
        add_theme_support('editor-style');
        
        //Themeforrest requipments
        add_theme_support('custom-header', array(
        'default-image' => '',
        'random-default' => false,
        'width' => 1040,
        'flex-height' => true,
        'flex-width' => true,
        'uploads' => true,
        'header-text' => false
        ));
        add_theme_support('custom-background');
        
        add_theme_support( "title-tag" );
    }
}

function jaw_disable_srcset( $sources ) {
    return false;
}

//PLUGINS*****************
$jawPluginName = '';

function jaw_init_plugins() {
    
    //   if (is_admin()) {
    if ($plugins = jwOpt::getXmlSpace('plugins')) {
        foreach ($plugins->children() as $plugin) {
            $name = (string) $plugin->attributes()->name;
            $theme = wp_get_theme();
            
            if (class_exists($name) && method_exists($name, 'getInstance')) {
                
                $result = call_user_func($name . '::getInstance');
                $result->init($plugin, $theme);
                
                if ($result == false) {
                    $jawPluginName = $name;
                    add_action('admin_notices', 'jaw_admin_notice');
                }
            }
        }
    }
    // }
}

function jaw_admin_notice() {
    ?>
    <div class="updated">
        <p><b><?php echo esc_html($jawPluginName); ?>:</b><?php esc_html_e(" This version of plugin is not supported for your theme",'gdn-theme'); ?></p>
    </div>
    <?php
}

//vypnuti JaW Cache
function jaw_cache_turnoff() {
    ?>
    <div class="notice notice-warning is-dismissible">
        <p><?php esc_html_e("Plugin JaW Cache has been deprecated. Please use some alternative. E.g. WP Super Cache.",'gdn-theme'); ?></p>
    </div>
    <?php
}

// SEO DUPLICITE WARNING MESSAGE
function jaw_seo_dupl_warning_msg() {
    if(function_exists("wpseo_auto_load") && jwOpt::get_option('use_jaw_seo', '1') == '1') {
        $otherseotext = '<i class="jaw-icon-warning"></i><span style="color:red">
        '.esc_html__("You have activated Another SEO Plugin. We suggest you to turn built-in SEO via Theme Options or you can disable SEO plugin",'gdn-theme').
        '<a target="_blank" href="'.admin_url('plugins.php').'">
        '.esc_html__("here",'gdn-theme').'</a> 
        '.esc_html__("Please bear in mind that for the best results we recommend use only one SEO (plugin or built-in) and not both. Thank you.",'gdn-theme').' </span>';
        $class = 'notice notice-error';
        printf( '<div class="%1$s"><p>%2$s</p></div>', $class, $otherseotext ); 
    }
}
add_action( 'admin_notices', 'jaw_seo_dupl_warning_msg' );

/*
* Load constants
*/
function jaw_constants() {
    
    $JAW_THEMEVERSION = '';
    $JAW_THEMENAME = "GDN Theme";
    
    if (function_exists('wp_get_theme')) {
        
        if (is_child_theme()) {
            $tempObj = wp_get_theme();
            $themeObj = wp_get_theme($tempObj->get('Template')); // nactu info o main theme 
        } else {
            $themeObj = wp_get_theme();
        }
        
        $JAW_THEMEVERSION = $themeObj->get('Version');
// #IF JAW_PR
        $JAW_THEMENAME = $themeObj->get('Name');
// 
    } else { // for WP < 3.4.0
        $themeData = wp_get_theme(get_template_directory() . '/style.css');
        $JAW_THEMEVERSION = $themeData['Version'];
// 
        $JAW_THEMENAME = $themeData['Name'];
// 
    }


    //PHP<5.4
    if(!defined('JSON_UNESCAPED_UNICODE')){
        define('JSON_UNESCAPED_UNICODE', 256);
    }
    
    define('JAW_SITE_URL', get_option('siteurl'));
    
    define('JAW_THEMENAME', $JAW_THEMENAME);
    define('JAW_THEMESLUG', strtolower($JAW_THEMENAME));
    define('JAW_THEMEVERSION', $JAW_THEMEVERSION);
    
    define('JAW_THEME_FRAMEWORK_DIR', get_template_directory() . '/framework');
    define('JAW_THEME_FRAMEWORK_URI', get_template_directory_uri() . '/framework');
    define('JAW_THEME_FRAMEWORK_LIB', JAW_THEME_FRAMEWORK_DIR . '/lib/');
    
    define('JAW_ADMIN_DIR', JAW_THEME_FRAMEWORK_DIR . '/admin/');
    define('JAW_ADMIN_URI', JAW_THEME_FRAMEWORK_URI . '/admin/');
    
    define('JAW_THEME_DIR', get_template_directory());
    define('JAW_THEME_URI', get_template_directory_uri());
    
    if (!defined('WP_CONTENT_DIR')) {
        define('WP_CONTENT_DIR', realpath(JAW_THEME_DIR . '/../..'));
    }
    
    /* Theme version, uri, and the author uri are not completely necessary, but may be helpful in adding functionality */
    define('JAW_CATEGORIES', JAW_THEMESLUG . '_categories');
    define('JAW_MENUS', JAW_THEMESLUG . '_menus');
    define('JAW_OPTIONS', JAW_THEMESLUG . '_options');
    define('JAW_BACKUPS', '_backups');
    
    define('JAW_COLOR_LOG', JAW_THEMESLUG . '-log');
    
    define('JAW_CHECK_UPDATE', 1209600); //86400*14 = 1209600
    define('JAW_THEME_FUNCTIONS', JAW_THEME_FRAMEWORK_DIR . '/functions');
}

/*
* Load basic classes
*/

function jaw_libs() {
    if(is_admin()){
        load_template(JAW_THEME_FRAMEWORK_LIB . 'class_builderhelper.php', true);
        load_template(JAW_THEME_FRAMEWORK_LIB . 'class_lessc.php', true);
        load_template(JAW_THEME_FRAMEWORK_LIB . 'class_styles.php', true);
    }
    if(function_exists('is_customize_preview') && is_customize_preview()){
        load_template(JAW_THEME_FRAMEWORK_LIB . 'class_customizer.php', true);
    }
    load_template(ABSPATH . 'wp-admin/includes/plugin.php'); //abych mohl pouzivat is_plugin_active
    load_template(JAW_THEME_FRAMEWORK_LIB . 'class_options.php', true);
    load_template(JAW_THEME_FRAMEWORK_LIB . 'class_layout.php', true);
    load_template(JAW_THEME_FRAMEWORK_LIB . 'class_utils.php', true);
    load_template(JAW_THEME_FRAMEWORK_LIB . 'class_sidebars.php', true);
    load_template(JAW_THEME_FRAMEWORK_LIB . 'class_render.php', true);
    load_template(JAW_THEME_FRAMEWORK_LIB . 'class_builder.php', true);
    load_template(JAW_THEME_FRAMEWORK_LIB . 'class_shortcodes.php', true);
    load_template(JAW_THEME_FRAMEWORK_LIB . 'jaw-templater.php', true);
    //locate_template(array('tmpl/template.php'), true); @rami - 13.3.2017 zruseno pro snadnejsi customizaci useru
    load_template(JAW_THEME_FRAMEWORK_LIB . 'class_media.php', true);
    load_template(JAW_THEME_FRAMEWORK_LIB . 'class_interest.php', true);
    load_template(JAW_THEME_FRAMEWORK_LIB . 'class_likes.php', true);
    
// 
    load_template(JAW_THEME_FRAMEWORK_LIB . '/rating/metaboxOptionsStore/writepanelsDataStore.php', true);
    load_template(JAW_THEME_FRAMEWORK_LIB . '/rating/metaboxOptionsStore/writepanelsDataPrinter.php', true);
    load_template(JAW_THEME_FRAMEWORK_LIB . '/rating/metaboxOptionsStore/writepanelsManager.php', true);
    load_template(JAW_THEME_FRAMEWORK_LIB . '/rating/admin.php', true);
// 
    load_template(JAW_THEME_FRAMEWORK_LIB . 'class_facebook.php', true);
    
    if (is_admin()) {
        load_template(JAW_THEME_FRAMEWORK_LIB . 'class_updatechecker.php', true);
        load_template(JAW_THEME_FRAMEWORK_LIB . 'class_elements.php', true);
        load_template(JAW_THEME_FRAMEWORK_LIB . 'class_panel.php', true);
        load_template(JAW_THEME_FRAMEWORK_LIB . 'class_demoimport.php', true);
        load_template(JAW_THEME_FRAMEWORK_LIB . 'class_metatax.php', true);
        load_template(JAW_THEME_FRAMEWORK_LIB . 'class_metabox.php', true);
        if(current_user_can('install_plugins')){
            load_template(JAW_THEME_FRAMEWORK_LIB . 'class_tgm.php', true);
            load_template(JAW_THEME_FRAMEWORK_LIB . 'class_welcome.php', true);      
        }
    }
}

/*
* Make theme available for translation
*/

function jaw_language() {
    load_theme_textdomain("gdn-theme", get_template_directory() . '/languages/');
}

function jaw_css() {
    
    wp_register_style('style', get_stylesheet_directory_uri() . '/style.css', array(), jwUtils::assetsVersion());
    wp_enqueue_style('style');
    
    wp_register_style('template_min', get_template_directory_uri() . '/css/template.min.css', array(), jwUtils::assetsVersion());
    wp_enqueue_style('template_min');


    $version = get_option('jaw_custom_css_version');
    $blogId = get_current_blog_id();
    if(function_exists('is_customize_preview') && is_customize_preview()){
        wp_register_style('themeoptions-preview', get_template_directory_uri() . '/css/themeoptions-' . $blogId . '-preview.css', array('template_min'), $version);
        wp_enqueue_style('themeoptions-preview');
    }else{
        wp_register_style('themeoptions', get_template_directory_uri() . '/css/themeoptions-' . $blogId . '.css', array('template_min'), $version);
        wp_enqueue_style('themeoptions');
    }

    //Google fonts
    wp_enqueue_style( 'jaw-google-fonts', jwUtils::loadFonts(), array(), $version );
    
    // < IE9
    wp_register_style('old-ie', get_template_directory_uri() . '/css/old-ie.min.css', array('template_min'), $version);
    wp_enqueue_style('old-ie');
    wp_style_add_data( 'old-ie', 'conditional', 'lt IE 9' );
    wp_register_style('noscript', get_template_directory_uri() . '/css/noscript.min.css', array('template_min'), $version);
    wp_enqueue_style('noscript');
    wp_style_add_data( 'noscript', 'conditional', 'lt IE 9' );
    
    //noscript
    wp_register_style('jaw_noscript', get_template_directory_uri() . '/css/noscript.min.css', array(), $version);
    wp_enqueue_style('jaw_noscript');

    //styles from /custom_styles/ folder are compiled by jwStyles (Theme Options)
}

function jaw_admin_css() {                
    wp_register_style('jaw-admin-style', JAW_ADMIN_URI . 'assets/css/admin-style.css', array(), jwUtils::assetsVersion());
    wp_enqueue_style('jaw-admin-style');
    
    wp_register_style('colorpicker', JAW_ADMIN_URI . 'assets/css/colorpicker.css', array(), jwUtils::assetsVersion());
    wp_enqueue_style('colorpicker');
    
    wp_register_style('jaw-icons', get_template_directory_uri() . '/css/icons.css', jwUtils::assetsVersion());
    wp_enqueue_style('jaw-icons');
}



function jaw_wp_scripts() {
    
    wp_register_script('jaw_all', get_template_directory_uri() . '/js/all.js', array('jquery'), jwUtils::assetsVersion(), true);
    wp_enqueue_script('jaw_all');
    
    wp_register_script('jaw_app', get_template_directory_uri() . '/js/app.min.js', array('jquery', 'jaw_all'), jwUtils::assetsVersion(), true);
    wp_enqueue_script('jaw_app');
    
    wp_localize_script('jaw_app', 'ajax_object', array('ajax_url' => admin_url('admin-ajax.php'), 'ajax_nonce' => wp_create_nonce()));
    
    if(jwOpt::get_option('preload_google_fonts', '1')){
        wp_register_script('google_webfont', '//ajax.googleapis.com/ajax/libs/webfont/1.5.18/webfont.js', false, false, true);
        wp_enqueue_script('google_webfont');
    }
    
    // Enable threaded comments
    if (is_singular() && comments_open() && get_option('thread_comments')) {
        wp_enqueue_script('comment-reply');
    }

    // < IE9
    wp_register_script('html5shim', get_template_directory_uri() . '/js/html5shiv.min.js', array(), jwUtils::assetsVersion('3.7.3'), true);
    wp_enqueue_script('html5shim');
    wp_script_add_data( 'html5shim', 'conditional', 'lt IE 9' );
}

function jaw_admin_scripts() {
    wp_enqueue_media();
    
    wp_enqueue_script('jquery-ui-core', array('jquery'));
    wp_enqueue_script('jquery-ui-sortable', array('jquery'));
    wp_enqueue_script('jquery-ui-slider', array('jquery'));
    wp_enqueue_script('jquery-ui-mouse', array('jquery'));
    wp_enqueue_script('media-upload', array('jquery'));
    wp_enqueue_script('thickbox', array('jquery'));
    
    wp_enqueue_script('ace_editor', JAW_ADMIN_URI . 'assets/js/ace_editor/ace.js', array('jquery'), jwUtils::assetsVersion());
    wp_enqueue_script('ext-language_tools', JAW_ADMIN_URI . 'assets/js/ace_editor/ext-language_tools.js', array('jquery', 'ace_editor'), jwUtils::assetsVersion());
    wp_enqueue_script('ext-emmet', JAW_ADMIN_URI . 'assets/js/ace_editor/ext-emmet.js', array('jquery', 'ace_editor'), jwUtils::assetsVersion());

    wp_enqueue_script('jawAdminApp', JAW_ADMIN_URI . 'assets/js/app.min.js', array('jquery', 'ace_editor'), jwUtils::assetsVersion()); 
     
    $jawVariables = array();
    $jawVariables['optionsframework_url'] = admin_url("?page=optionsframework");
    $jawVariables['JAW_THEME_URI'] = JAW_THEME_URI;
    if(defined('JAW_DEBUG')){
        $jawVariables['JAW_DEBUG'] = JAW_DEBUG;
    }
    wp_localize_script('jawAdminApp', 'jaw_variables', $jawVariables);

}

function jaw_style_loader_tag( $tag, $handle, $src){
    if($handle == 'jaw_noscript'){
        return '<noscript>'.$tag.'</noscript>';
    }
    return $tag;
}


//pokud bude v exceprtu (more...) tak se to muze rezat spatne - thanks to audio46
function jaw_excerpt_strip_shortcodes($content) {
    return strip_shortcodes($content);
}


function jaw_welcome() {  
    $lastVersion = get_option('jaw-theme-version');
    $currentVersion = JAW_THEMEVERSION;
    if ($lastVersion != $currentVersion) {
        update_option('jaw-theme-version', jaw_get_theme_version());
        delete_option(JAW_THEMESLUG . '_last_update_check'); //opet se zeptam na novou verzi
    }
}

// 
function jaw_modify_admin_bar($wpAdminBar) {
    if (current_user_can('edit_theme_options')) {
        $wpAdminBar->add_menu(array(
        'parent' => '',
        'id' => 'jaw_options',
        'title' => esc_html__('G`DayNews', "gdn-theme"),
        'href' => admin_url('themes.php?page=optionsframework')
        ));
        $wpAdminBar->add_group(array(
        'parent' => 'jaw_options',
        'id' => 'jaw_theme'
        ));
        
        $wpAdminBar->add_node(array(
        'parent' => 'jaw_theme',
        'id' => 'jaw_theme_options',
        'title' => esc_html__('Theme Options', "gdn-theme"),
        'href' => admin_url('themes.php?page=optionsframework')
        ));
        $wpAdminBar->add_node(array(
        'parent' => 'jaw_theme',
        'id' => 'jaw_customize_theme',
        'title' => esc_html__('Customize Theme', "gdn-theme"),
        'href' => admin_url('customize.php')
        ));
        $wpAdminBar->add_node(array(
        'parent' => 'jaw_theme',
        'id' => 'jaw_support',
        'title' => esc_html__('JaW Support', "gdn-theme"),
        'href' => 'http://support.jawtemplates.com/'
        ));
    }
}
// 

// get version of the theme
// remove this function and add constant here
function jaw_get_theme_version() {
    
    if (is_child_theme()) {
        $tempObj = wp_get_theme();
        $themeObj = wp_get_theme($tempObj->get('Template'));
    } else {
        $themeObj = wp_get_theme();
    }
    $JAW_THEMEVERSION = $themeObj->get('Version');

    return $JAW_THEMEVERSION;
}

function jaw_controll_responsive() {
    
    if (filter_input(INPUT_COOKIE, 'jaw_responsive') !== null) {
        jwOpt::set_option('responsive', esc_attr(filter_input(INPUT_COOKIE, 'jaw_responsive')));
    }
    
    if (filter_input(INPUT_GET, 'jaw_responsive') !== null) {
        if (filter_input(INPUT_GET, 'jaw_responsive') === '1') {
            $responsive = '0';
        } else {
            $responsive = '1';
        }
        jwOpt::set_option('responsive', esc_attr($responsive));
        setcookie('jaw_responsive', $responsive, time() + 3600, COOKIEPATH, COOKIE_DOMAIN);
    }
}

function jaw_excerpt_more($more) {
    return ' ';
}

function jaw_redirect_login_failed() {
    wp_redirect(get_permalink(esc_attr(jwOpt::get_option('user_bar_wrong_login_pageid', '_default'))));
        die();
}

function jaw_login_redirect( $redirectTo, $request, $user ) {
    //is there a user to check?
    global $user;
    if ( isset( $user->roles ) && is_array( $user->roles ) ) {
        //check for admins
        if ( in_array( 'administrator', $user->roles ) || in_array( 'author', $user->roles ) || in_array( 'editor', $user->roles )) {
            // redirect them to the default place
            return $redirectTo;
        } else {
            return get_permalink(jwOpt::get_option('user_bar_login_pageid', '_default'));
        }
    } else {
        return $redirectTo;
    }
}


function jaw_remove_more_span($content){
	global $post;
	if(!is_single()){
		return $content;
	}
	return str_replace('<span id="more-' . $post->ID . '"></span>', '', $content);
}

function jaw_after_install_theme(){
   
   
    // Vytvoreni termu pro hlavni MENU.
    $insertTerm = wp_insert_term(
        'Menu - Default', 
        'nav_menu', 
        array(
            'description' => 'Base menu',
            'slug' => 'jaw-default-menu',
            'parent' => ''
        )
    );
    
    $mymenu = wp_get_nav_menu_object('jaw-default-menu');
    $menuID = (int) $mymenu->term_id;

    //pokud toto menu jiz existuje - tak to vrati ERROR, a zadna polozka se neprida.
    if(!$insertTerm instanceof WP_Error ){       
        
        $customItem = array(
        'menu-item-type' => 'custom',
        'menu-item-url' => get_option('siteurl'),
        'menu-item-title' => 'Home',
        'menu-item-status' => 'publish'
        );
        
        wp_update_nav_menu_item($menuID, 0, $customItem);    
    }

    $insertMenu = array('primary_navigation' => $menuID, 'primary_mobile_navigation' => $menuID);
    register_nav_menu('primary_navigation', 'Primary Navigation');
    register_nav_menu('primary_mobile_navigation', 'Primary Mobile Navigation');
    set_theme_mod('nav_menu_locations', $insertMenu);
    
    //end MENU
    
    //defaultni options
    $defaultOptions = array();

// 

// 
    $defaultOptions['jaw_color_preset'] = 'a:11:{s:16:"ts_0000000000000";a:15:{s:5:"title";s:14:"Lifestyle main";s:10:"background";s:7:"#ffffff";s:6:"theme1";s:17:"rgba(235,80,75,1)";s:6:"theme2";s:16:"rgba(61,61,61,1)";s:6:"theme3";s:7:"#ffffff";s:6:"border";s:7:"#dcdcdc";s:4:"text";s:16:"rgba(48,48,48,1)";s:4:"meta";s:7:"#929292";s:4:"link";s:16:"rgba(61,61,61,1)";s:5:"hover";s:17:"rgba(235,80,75,1)";s:5:"input";s:7:"#444444";s:8:"input_bg";s:7:"#ffffff";s:22:"alternative_background";s:7:"#F1F1F1";s:9:"text_link";s:17:"rgba(235,80,75,1)";s:10:"text_hover";s:16:"rgba(61,61,61,1)";}s:16:"ts_0000000000020";a:15:{s:5:"title";s:14:"Lifestyle menu";s:10:"background";s:16:"rgba(61,61,61,1)";s:6:"theme1";s:17:"rgba(235,80,75,1)";s:6:"theme2";s:19:"rgba(255,255,255,1)";s:6:"theme3";s:7:"#ffffff";s:6:"border";s:7:"#dcdcdc";s:4:"text";s:19:"rgba(255,255,255,1)";s:4:"meta";s:7:"#929292";s:4:"link";s:19:"rgba(255,255,255,1)";s:5:"hover";s:17:"rgba(235,80,75,1)";s:5:"input";s:7:"#444444";s:8:"input_bg";s:7:"#ffffff";s:22:"alternative_background";s:7:"#F1F1F1";s:9:"text_link";s:17:"rgba(235,80,75,1)";s:10:"text_hover";s:19:"rgba(255,255,255,1)";}s:16:"ts_0000000000010";a:15:{s:5:"title";s:16:"Lifestyle topbar";s:10:"background";s:17:"rgba(235,80,75,1)";s:6:"theme1";s:19:"rgba(255,255,255,1)";s:6:"theme2";s:17:"rgba(235,80,75,1)";s:6:"theme3";s:17:"rgba(235,80,75,1)";s:6:"border";s:19:"rgba(255,255,255,1)";s:4:"text";s:19:"rgba(255,255,255,1)";s:4:"meta";s:19:"rgba(255,255,255,1)";s:4:"link";s:19:"rgba(255,255,255,1)";s:5:"hover";s:19:"rgba(247,247,247,1)";s:5:"input";s:19:"rgba(255,255,255,1)";s:8:"input_bg";s:7:"#ffffff";s:22:"alternative_background";s:7:"#F1F1F1";s:9:"text_link";s:7:"#444444";s:10:"text_hover";s:19:"rgba(255,255,255,1)";}s:16:"ts_0000000000040";a:15:{s:5:"title";s:17:"Lifestyle Sidebar";s:10:"background";s:19:"rgba(230,230,230,1)";s:6:"theme1";s:17:"rgba(235,80,75,1)";s:6:"theme2";s:7:"#535353";s:6:"theme3";s:7:"#ffffff";s:6:"border";s:7:"#dcdcdc";s:4:"text";s:7:"#929292";s:4:"meta";s:7:"#929292";s:4:"link";s:7:"#444444";s:5:"hover";s:7:"#535353";s:5:"input";s:7:"#444444";s:8:"input_bg";s:7:"#ffffff";s:22:"alternative_background";s:7:"#F1F1F1";s:9:"text_link";s:17:"rgba(235,80,75,1)";s:10:"text_hover";s:7:"#444444";}s:16:"ts_0000000000080";a:15:{s:5:"title";s:16:"Lifestyle footer";s:10:"background";s:16:"rgba(61,61,61,1)";s:6:"theme1";s:17:"rgba(235,80,75,1)";s:6:"theme2";s:19:"rgba(255,255,255,1)";s:6:"theme3";s:16:"rgba(61,61,61,1)";s:6:"border";s:7:"#dcdcdc";s:4:"text";s:19:"rgba(255,255,255,1)";s:4:"meta";s:19:"rgba(255,255,255,1)";s:4:"link";s:19:"rgba(255,255,255,1)";s:5:"hover";s:17:"rgba(235,80,75,1)";s:5:"input";s:7:"#444444";s:8:"input_bg";s:7:"#ffffff";s:22:"alternative_background";s:19:"rgba(122,122,122,1)";s:9:"text_link";s:19:"rgba(255,255,255,1)";s:10:"text_hover";s:17:"rgba(235,80,75,1)";}s:16:"ts_0000000000030";a:15:{s:5:"title";s:16:"Lifestyle MyNews";s:10:"background";s:19:"rgba(237,237,237,1)";s:6:"theme1";s:17:"rgba(235,80,75,1)";s:6:"theme2";s:16:"rgba(61,61,61,1)";s:6:"theme3";s:19:"rgba(255,255,255,1)";s:6:"border";s:7:"#dcdcdc";s:4:"text";s:7:"#3d3d3d";s:4:"meta";s:7:"#929292";s:4:"link";s:16:"rgba(61,61,61,1)";s:5:"hover";s:17:"rgba(235,80,75,1)";s:5:"input";s:7:"#444444";s:8:"input_bg";s:7:"#ffffff";s:22:"alternative_background";s:7:"#F1F1F1";s:9:"text_link";s:17:"rgba(235,80,75,1)";s:10:"text_hover";s:16:"rgba(61,61,61,1)";}s:16:"ts_0000000000090";a:15:{s:5:"title";s:17:"Lifestyle Gallery";s:10:"background";s:16:"rgba(31,31,31,1)";s:6:"theme1";s:17:"rgba(235,80,75,1)";s:6:"theme2";s:16:"rgba(31,31,31,1)";s:6:"theme3";s:7:"#ffffff";s:6:"border";s:7:"#dcdcdc";s:4:"text";s:16:"rgba(48,48,48,1)";s:4:"meta";s:7:"#929292";s:4:"link";s:7:"#444444";s:5:"hover";s:17:"rgba(235,80,75,1)";s:5:"input";s:7:"#444444";s:8:"input_bg";s:7:"#ffffff";s:22:"alternative_background";s:7:"#F1F1F1";s:9:"text_link";s:17:"rgba(235,80,75,1)";s:10:"text_hover";s:7:"#444444";}s:16:"ts_0000000000041";a:15:{s:5:"title";s:16:"Lifestyle Slider";s:10:"background";s:17:"rgba(235,80,75,1)";s:6:"theme1";s:19:"rgba(255,255,255,1)";s:6:"theme2";s:17:"rgba(235,80,75,1)";s:6:"theme3";s:19:"rgba(255,255,255,1)";s:6:"border";s:19:"rgba(255,255,255,1)";s:4:"text";s:19:"rgba(255,255,255,1)";s:4:"meta";s:19:"rgba(255,255,255,1)";s:4:"link";s:19:"rgba(255,255,255,1)";s:5:"hover";s:19:"rgba(247,247,247,1)";s:5:"input";s:19:"rgba(255,255,255,1)";s:8:"input_bg";s:7:"#ffffff";s:22:"alternative_background";s:7:"#F1F1F1";s:9:"text_link";s:7:"#444444";s:10:"text_hover";s:19:"rgba(255,255,255,1)";}s:16:"ts_0000000000100";a:15:{s:5:"title";s:23:"Lifestyle Blue category";s:10:"background";s:7:"#ffffff";s:6:"theme1";s:18:"rgba(58,115,224,1)";s:6:"theme2";s:16:"rgba(61,61,61,1)";s:6:"theme3";s:7:"#ffffff";s:6:"border";s:7:"#dcdcdc";s:4:"text";s:16:"rgba(48,48,48,1)";s:4:"meta";s:7:"#929292";s:4:"link";s:16:"rgba(61,61,61,1)";s:5:"hover";s:18:"rgba(58,115,224,1)";s:5:"input";s:7:"#444444";s:8:"input_bg";s:7:"#ffffff";s:22:"alternative_background";s:7:"#F1F1F1";s:9:"text_link";s:18:"rgba(58,115,224,1)";s:10:"text_hover";s:18:"rgba(58,115,224,1)";}s:16:"ts_0000000000101";a:15:{s:5:"title";s:24:"Lifestyle Green category";s:10:"background";s:7:"#ffffff";s:6:"theme1";s:17:"rgba(55,171,74,1)";s:6:"theme2";s:16:"rgba(61,61,61,1)";s:6:"theme3";s:7:"#ffffff";s:6:"border";s:7:"#dcdcdc";s:4:"text";s:16:"rgba(48,48,48,1)";s:4:"meta";s:7:"#929292";s:4:"link";s:16:"rgba(61,61,61,1)";s:5:"hover";s:17:"rgba(55,171,74,1)";s:5:"input";s:7:"#444444";s:8:"input_bg";s:7:"#ffffff";s:22:"alternative_background";s:7:"#F1F1F1";s:9:"text_link";s:17:"rgba(55,171,74,1)";s:10:"text_hover";s:17:"rgba(55,171,74,1)";}s:16:"ts_0000000000042";a:15:{s:5:"title";s:23:"Lifestyle breaking news";s:10:"background";s:19:"rgba(255,255,255,1)";s:6:"theme1";s:17:"rgba(235,80,75,1)";s:6:"theme2";s:19:"rgba(255,255,255,1)";s:6:"theme3";s:7:"#ffffff";s:6:"border";s:7:"#dcdcdc";s:4:"text";s:16:"rgba(43,43,43,1)";s:4:"meta";s:7:"#929292";s:4:"link";s:16:"rgba(43,43,43,1)";s:5:"hover";s:17:"rgba(235,80,75,1)";s:5:"input";s:7:"#444444";s:8:"input_bg";s:7:"#ffffff";s:22:"alternative_background";s:7:"#F1F1F1";s:9:"text_link";s:19:"rgba(255,255,255,1)";s:10:"text_hover";s:19:"rgba(255,255,255,1)";}}';

    $defaultOptions[JAW_OPTIONS] = 'a:8:{s:12:"header_color";s:16:"ts_0000000000000";s:10:"menu_color";s:16:"ts_0000000000020";s:17:"mobile_menu_color";s:16:"ts_0000000000020";s:12:"footer_color";s:16:"ts_0000000000080";s:13:"my_news_color";s:16:"ts_0000000000030";s:19:"media_gallery_color";s:16:"ts_0000000000090";s:10:"main_color";s:16:"ts_0000000000000";s:12:"font_manager";s:2784:"[{"id":"ts_1444990830905","family":"Roboto","name":"Click and Name it here","source":"google","weight":"400","size":"16px","lineHeight":"1.5em","websafe":"serif","places":["text_font","pagination_font","h5_font"]},{"id":"ts_1444995052171","family":"Roboto","name":"Click and Name it here","source":"google","weight":"400","size":"35px","lineHeight":"1.5em","websafe":"serif","places":["big_titles_font"]},{"id":"ts_1444995068976","family":"Roboto","name":"Click and Name it here","source":"google","weight":"400","size":"18px","lineHeight":"1.5em","websafe":"serif","places":["h4_font","post_box_classical_font","grid_small_font","slider3_small_font","blockquote_font"]},{"id":"ts_1444995081574","family":"Roboto","name":"Click and Name it here","source":"google","weight":"400","size":"14px","lineHeight":"1.5em","websafe":"serif","places":["submenu_font","mobilemenu_font","buttons_font","titles_left_boder_font","titles_middle_boder_font","titles_top_bottom_border_font","titles_background_font","breadcrumbs_font","topbar_font","footer_font","h6_font","post_box_simple_font","post_box_excerpt_font"]},{"id":"ts_1444995117839","family":"Roboto","name":"Click and Name it here","source":"google","weight":"400","size":"26px","lineHeight":"1.5em","websafe":"serif","places":["post_titles_font","h1_font","post_box_big_font","post_box_special_font","post_box_specialbig_font","grid_big_font","slider3_font","fullwidth_slider_font"]},{"id":"ts_1444995155407","family":"Roboto","name":"Click and Name it here","source":"google","weight":"400","size":"24px","lineHeight":"1.5em","websafe":"serif","places":["h2_font"]},{"id":"ts_1444995157659","family":"Roboto","name":"Click and Name it here","source":"google","weight":"400","size":"20px","lineHeight":"1.5em","websafe":"serif","places":["h3_font"]},{"id":"ts_1444995196844","family":"Roboto","name":"Click and Name it here","source":"google","weight":"400","size":"12px","lineHeight":"1.5em","websafe":"serif","places":["meta_font"]},{"id":"ts_1444995548977","family":"Roboto","name":"Click and Name it here","source":"google","weight":"400","size":"22px","lineHeight":"1.5em","websafe":"serif","places":["post_box_timeline_font","slider_2_font"]},{"id":"ts_1444995563428","family":"Roboto","name":"Click and Name it here","source":"google","weight":"400","size":"17px","lineHeight":"1.5em","websafe":"serif","places":["post_box_vertical_font"]},{"id":"ts_1444995568932","family":"Roboto","name":"Click and Name it here","source":"google","weight":"400","size":"15px","lineHeight":"1.5em","websafe":"serif","places":["post_box_vertical_small_font"]},{"id":"ts_1447234176177","family":"Roboto","name":"Click and Name it here","source":"google","weight":"400","size":"16px","lineHeight":"42px","websafe":"serif","places":["menu_font"]}]";}';
// 
    
    // pop up maker welcome page
    $defaultOptions['fs_popup-maker_activated'] = '0';
    
    // Ulozeni informace o tom ze nastaveni po prvnim stupsteni jiz probehly.
    $defaultOptions['jaw_install'] = '1';
    
    foreach($defaultOptions as $optKey => $optVal){
        if(get_option($optKey) === false){
            //pokud Optiona neni nastavena
            update_option($optKey, maybe_unserialize($optVal));
        }
    }
    jwOpt::refresh_options();
    do_action('jaw_generate_styles', 'color_preview');
    delete_transient( JAW_THEMESLUG.'_g_fonts' );
}

function jaw_remove_wp_ver_css_js( $src ) {
    if ( strpos( $src, 'ver=' ) )
        $src = remove_query_arg( 'ver', $src );
    return $src;
}

/* BBPRESS */
function jaw_get_topic_tag_list($args){
    $args['sep'] = '';
    return $args;
}
add_filter( 'bbp_before_get_topic_tag_list_parse_args', 'jaw_get_topic_tag_list' );


/* ===========================================================================================
*                                          JAW FILTERS
* ==========================================================================================*/

function jaw_crop_excerpt($content, $length = -1){
    $content = jwUtils::crop_length($content, $length);
    if(jwOpt::get_option('show_readmore',0)){
        $content = $content.' <a href="'.get_the_permalink().'">'.jwOpt::get_option('readmore_text').'</a>';
    }
    return $content;
}
add_filter('jaw_excerpt', 'jaw_crop_excerpt',10,2);

function jaw_gallery_title_name() {
    return esc_html__("gallery",'gdn-theme');
}
add_filter("jaw_gallery_box_default_name","jaw_gallery_title_name");

/* ===========================================================================================
*                                          JAW ACTIONS
* ==========================================================================================*/

function jaw_generate_styles($type = "color"){
    $jwStyle = new jwStyle();
    $jwStyle->get_static($type);
}
function jaw_deregister_generate_styles(){
    remove_action('jaw_generate_styles', 'jaw_generate_styles', 10, 1);
}
 
// php version checker
function jaw_compare_php_versions() {
    ?>
    <div class="notice notice-warning is-dismissible">
        <p><?php esc_html_e("Please contact your hosting company to update php to version 5.4 at least. Thank you. Your current version is: ",'gdn-theme'); PHP_VERSION ?> </p>
    </div>
    <?php
}
if(version_compare(PHP_VERSION, '5.4.0') < 0) {
    add_action( 'admin_notices', 'jaw_compare_php_versions' );
}


/* ===========================================================================================
*                                          JAW COMPATIBILITIES FOR 3RD PARTY PLUGINS
* ==========================================================================================*/

// MASHSHARE PLUGIN
if (class_exists('mashshare')) {
    
    add_action( 'after_setup_theme', 'jaw_mashsharer_disable_welcome_redirect' );
    add_action( 'init', 'jaw_mashsharer_register_new_networks' );
    
    add_filter( 'mashsb_array_networks', 'jaw_mashsharer_array_networks' );
    
    function jaw_mashsharer_array_networks( $array ) {
        global $mashsb_options, $post;
        $singular = isset( $mashsb_options['singular'] ) ? $singular = true : $singular = false;

        $url = $array['url'];
        $title = $array['title'];
        $whatsapp_title = str_replace('+', '%20', $title);

        
        !empty($mashsb_options['mashnet_subjecttext']) ? $subject = rawurlencode($mashsb_options['mashnet_subjecttext']) : $subject = '%20';
        !empty($mashsb_options['mashnet_bodytext']) ? $body = rawurlencode($mashsb_options['mashnet_bodytext']) : $body = '%20';

    $networkArray = array(
        'google' => 'https://plus.google.com/share?text=' . $title . '&amp;url=' . $url,
        'whatsapp' =>  'whatsapp://send?text=' . $whatsapp_title . '%20' . $url,
        'pinterest' => 'https://pinterest.com/pin/create/button/?url=' . $url . '&amp;media=' . urlencode(jaw_mashnet_get_pinterest_image()) . '&amp;description=' . urlencode(jaw_mashnet_get_pinterest_desc()),
        'digg' => 'http://digg.com/submit?phase=2%20&amp;url=' . $url . '&amp;title=' . $title,
        'linkedin' => 'https://www.linkedin.com/shareArticle?trk=' . $title . '&amp;url=' . $url,
        'linkedin ' => 'https://www.linkedin.com/shareArticle?trk=' . $title . '&amp;url=' . $url, // Blank character fix ()
        'reddit' => 'http://www.reddit.com/submit?url=' . $url . '&amp;title=' . $title, 
        'reddit ' => 'http://www.reddit.com/submit?url=' . $url . '&amp;title=' . $title, // Blank character fix ()
        'stumbleupon' => 'http://www.stumbleupon.com/submit?url=' . $url,
        'stumbleupon ' => 'http://www.stumbleupon.com/submit?url=' . $url, // Blank character fix ()
        'vk' => 'http://vkontakte.ru/share.php?url=' . $url . '&amp;item=' . $title,
        'print' => 'http://www.printfriendly.com/print/?url=' . $url . '&amp;item=' . $title,
        'delicious' => 'https://delicious.com/save?v=5&amp;noui&amp;jump=close&amp;url=' . $url . '&amp;title=' . $title,
        'buffer' => 'https://bufferapp.com/add?url=' . $url . '&amp;text=' . $title,
        'weibo' => 'http://service.weibo.com/share/share.php?url=' . $url . '&amp;title=' . $title,
        'pocket' => 'https://getpocket.com/save?title=' . $title . '&amp;url=' . $url,
        'xing' => 'https://www.xing.com/social_plugins/share?h=1;url=' . $url . '&amp;title=' . $title,
        'tumblr' => 'https://www.tumblr.com/share?v=3&amp;u='. $url . '&amp;t=' . $title,
        'mail' => 'mailto:?subject=' . $subject . '&amp;body=' . $body . $url,
        'meneame' => 'http://www.meneame.net/submit.php?url=' . $url . '&amp;title=' . $title,
        'odnoklassniki' => 'http://www.odnoklassniki.ru/dk?st.cmd=addShare&amp;st.s=1&amp;st._surl=' . $url . '&amp;title=' . $title,
        'managewp' => 'http://managewp.org/share/form?url=' . $url . '&amp;title=' . $title,
        'mailru' => 'http://connect.mail.ru/share?share_url=' . $url,
        'line' => 'http://line.me/R/msg/text/?' . $title .'%20'. $url,
        'yummly' => 'http://www.yummly.com/urb/verify?url=' . $url . '&amp;title=' . $title,
        'frype' => 'http://www.draugiem.lv/say/ext/add.php?title='. $title .'&amp;link='.$url,
        'skype' => 'https://web.skype.com/share?url='.$url.'&lang=en-en',
        'telegram' => 'https://telegram.me/share/url?url='.$url.'&text=' . $title,
        'flipboard' => 'https://share.flipboard.com/bookmarklet/popout?v=2&title=' . urlencode($title) . '&url=' . $url,
        'hackernews' => 'http://news.ycombinator.com/submitlink?u='.$url.'&t='.urlencode($title),
        );
        return array_merge($array, $networkArray); 
    }

    /**
    * Get Pinterest image
    * 
    * @global obj $mashsb_meta_tags
    * @return string
    */
    function jaw_mashnet_get_pinterest_image() {
        global $post, $mashsb_meta_tags;
        if( is_singular() && class_exists( 'MASHSB_HEADER_META_TAGS' ) && method_exists($mashsb_meta_tags, 'get_pinterest_image_url') ) {
            $image =  $mashsb_meta_tags->get_pinterest_image_url();
        }else{
            $image = function_exists( 'MASHOG' ) ? MASHOG()->MASHOG_OG_Output->_add_image() : mashsb_get_image( $post->ID );
        }
        return $image;
    }

    /**
    * Get Pinterest description
    * 
    * @global obj $mashsb_meta_tags
    * @return type
    */
    function jaw_mashnet_get_pinterest_desc() {
        global $post, $mashsb_meta_tags;
        if( is_singular() && class_exists( 'MASHSB_HEADER_META_TAGS' ) && method_exists($mashsb_meta_tags, 'get_pinterest_description') ) {
            global $mashsb_meta_tags;
            return $mashsb_meta_tags->get_pinterest_description();
        } else{
            return mashsb_get_excerpt_by_id($post);
        }
    }
    
    /**
    * Register custom networks
    */
    function jaw_mashsharer_register_new_networks() {
        $networks = get_option( 'mashsb_networks' );
        if ( ! in_array( 'Google', $networks, true ) ) {
            $networks[] = 'Google';
        }
        if ( ! in_array( 'Pinterest', $networks, true ) ) {
            $networks[] = 'Pinterest';
        }
        if ( ! in_array( 'Reddit', $networks, true ) ) {
            $networks[] = 'Reddit';
        }
        if ( ! in_array( 'Tumblr', $networks, true ) ) {
            $networks[] = 'Tumblr';
        }
        update_option( 'mashsb_networks', $networks );
    }
    
    /**
    * Class MashshareNetworks
    */
    if ( ! class_exists( 'MashshareNetworks' ) ) {
        class MashshareNetworks {
            // This class is required to enable custom networks counting.
            // It won't be used if "MashshareNetworks" add-on is installed.
        }
    }
    
    /**
    * Disable MashShare welcome page redirect.
    */
    function jaw_mashsharer_disable_welcome_redirect() {
        delete_transient( '_mashsb_activation_redirect' );
    }
    
}
/*=======================================END================================================*/

// 