<?php
if(!class_exists('jwWelcome')){

    class jwWelcome{

        private $_installPlugins = array();
            

        public function __construct(){

            $this->_installPlugins = jaw_plugins();

            add_action('admin_menu', array(&$this, 'registerWelcomePage'));
            add_action('wp_ajax_jaw_install_plugins', array(&$this, 'installPlugins'));
            add_action('wp_ajax_jaw_install_cancel', array(&$this, 'installCancel'));

        }


        public function registerWelcomePage() {
            add_theme_page(
                "Welcome To G'Day News",
                "Welcome To G'Day News",
                'read',
                'jaw-welcome-screen',
                array($this, 'welcomeScreenContent')
            );

            if(get_option('jaw_install') == 1){
                update_option('jaw_install', 2);
                wp_redirect( admin_url( 'themes.php?page=jaw-welcome-screen' ) );
            }

        }

        public function welcomeScreenContent() {

            echo "<div class='wrap' ng-controller='jwEditorController' ng-app='jwEditor'>";
                echo "<h2></h2>";   

                 $installedDemos = jwUtils::jsonEncode(array_flip(array_keys(jwDemoImport::getWholeLog())));

                echo '<jwd-welcome-guide plugins="'.jwUtils::jsonEncode($this->_installPlugins).'" nonce="'.wp_create_nonce( 'tgmpa-install' ).'" installed-demos="' . $installedDemos . '">';
            echo "</div>";

            echo '<input type="hidden" id="jaw_security" class="jaw_nonce" name="jaw_security" value="'. wp_create_nonce('of_ajax_nonce'). '" />';

        }



        public function installPlugins(){
            add_filter('tgmpa_load', array(&$this, 'tgmpaLoad'));
            jaw_register_required_plugins();
            $plugins = TGM_Plugin_Activation::get_instance();
            $plugins->init();
            if(isset($_POST['plugin'])){
                $_GET['plugin'] = $_POST['plugin'];
            }
            $_GET['tgmpa-install'] = 'install-plugin';
            $result = $plugins->do_plugin_install();
            echo $result;
            die();
        }


        public function installCancel(){
            update_option('jaw_install', 3);
            delete_option(JAW_THEMESLUG . '_last_update_check'); //opet se zeptam na novou verzi
            die();
        }

        public function tgmpaLoad(){
            return true;
        }

    }
}