<?php
/**
* Helper utils, other code
*
* @author JaW Templates <http://www.jawtemplates.com>
* @copyright (c) 2013, CCB, spol. s r.o.
* @version 1.0
*/
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

if (!class_exists('jwUtils')) {

    class jwUtils {

        const WRITE_TO_FILE_STATUS = 'jaw_write_to_file';

        public static $glob_ad;

        // pouzita pro metodu customizer_preview_preset - udava zda-li se bude stitek zobrazovat vpravo nebo vlevo
        private static $_preview_side = 'left';

        /**
        * Description
        *
        * @param type $name Description
        * @return type Description
        *
        */
        public static function get_post_number() {
            global $wp_query;
            return $wp_query->current_post;
        }

        /**
        * Description
        *
        * @param type $name Description
        * @return type Description
        *
        */
        public static function getFileExten($file) {

            $pos = strpos($file, ".");
            $fileext = substr($file, $pos, strlen($file));
            return $fileext;
        }

        /**
        * Prevede hodnotu rgba na rgb - potrebne kvuli IE.<br>
        * Osetren vstup pokud neni zadan retezec obsahujici retezec rgba, vraci vstupni parametr.
        *
        * @param string $rgba hodnota rgba
        * @return string hodnota rgb
        *
        */
        public static function rgba2rgb($rgba = '') {
            $rgb = '';
            $rgba_test = '#' . $rgba;
            if ($rgba == '' || (strpos($rgba_test, 'rgba')) || (strpos($rgba_test, 'rgb')) == false) {
                return $rgba;
            } else {
                $rgba = str_replace('rgba', '', $rgba);
                $rgba = str_replace('(', '', $rgba);
                $rgba = str_replace(')', '', $rgba);
                $rgba = explode(',', $rgba);
                $rgb = 'rgb(' . $rgba[0] . ',' . $rgba[1] . ',' . $rgba[2] . ')';
                return $rgb;
            }
        }

        /**
        * Description
        *
        * @param type $name Description
        * @return type Description
        *
        */
        public static function fileLoader($path, $ext = array(), $prepend = '') {
            $out = array();
            if (is_dir($path)) {
                if ($dir = opendir($path)) {
                    while (($file = readdir($dir)) !== false) {

                        if (in_array(jwUtils::getFileExten($file), $ext)) {
                            $out[$file] = $prepend . $file;
                        }
                    }
                } else {
                    $out = array();// 'Folder is close';
                }
            }else {
                $out = array();//'no folder';
            }
            return $out;
        }

        /**
        * Description
        *
        * @param type $name Description
        * @return type Description
        *
        */
        public static function get_url_domain($url) {

            $explode = explode(".", $url);
            $tld = $explode[0];
            $tld = explode("/", $tld);
            return $tld[2];
        }


        /**
        * Desription
        *
        * @param type $name Description
        * @return type Description
        *
        */
        public static function getHelp($title="", $description="", $imgsrc = "", $link = array()) {
            $out = '';

            $out = "<jwd-help ";
            if($title !== ""){
                $out .= 'title="'.$title.'" ';
            }
            if($description !== ""){
                $out .= 'description="'.$description.'" ';
            }
            if($imgsrc !== ""){
                $out .= 'img-src="'.$imgsrc.'" ';
            }
            if(!empty($link)){
                $jsonLink = json_encode((object) $link, JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_HEX_AMP | JSON_UNESCAPED_UNICODE); // osentreni ' v textu
                $out .= 'links="'.addslashes(str_replace('"', '\'',$jsonLink)) .'"';
            }

            $out .= '></jwd-help>';

            return $out;
        }

        /**
        * Crop the string
        * Test if mb_function support enabled
        *
        * @param string string - input string
        * @param int max_lenght - crop string length
        *
        * @return string - croped string
        */
        public static function crop_length($string = '', $max_length = 0) {
            $out = '';
            if (function_exists('mb_strlen') && function_exists('mb_substr')) {
                if (($max_length > 0) && (mb_strlen($string, 'UTF-8') > $max_length)) {
                    $out = mb_substr($string, 0, (int) $max_length, 'utf-8') . jwOpt::get_option('excerpt_text', '...');
                } else if ($max_length == 0) {
                    $out = '';
                } else {
                    $out = $string;
                }
            } else {
                if (($max_length > 0) && (strlen($string) > $max_length)) {
                    $out = substr($string, 0, (int) $max_length) . jwOpt::get_option('excerpt_text', '...');
                } else if ($max_length == 0) {
                    $out = '';
                } else {
                    $out = $string;
                }
            }
            // dropcap shortcode checker
            if(function_exists('get_the_content') && function_exists('has_shortcode') && has_shortcode(get_the_content(),"jaw_dropcap")) {
                if(preg_match('/\[jaw_dropcap](.*?)\[/', get_the_content(), $matches)) {
                    $out = $matches[1].$out; // first letter found
                }
            }
            return apply_filters('jaw_cropped_text', $out);
        }

        /**
        * Desription
        *
        * @param type $name Description
        * @return type Description
        *
        */
        public static function get_social_meta() {
            global $post;
            echo "\n <!-- Open Graph protocol by JaW -->" . "\n";
            if (jwOpt::get_option('fbcomments_appid', '') != '') {
                echo "<meta property='fb:app_id' content='" . jwOpt::get_option('fbcomments_appid') . "'>" . "\n";
            }
            if (jwOpt::get_option('use_jaw_seo', '1') == '1' && !function_exists("wpseo_auto_load")) { // pokud je aktivovany seo plugin, jaws plugin se neudela
                $url="";
                // facebook, twitter ang google plus meta
                if (is_singular()) {
                    if(get_post_type() == "jaw-gallery") { // jaw gallery
                        $jaw_gallery_items = get_post_meta(get_the_ID(), 'jaw_gallery_items', true);
                        $_gallery_items_parsed = json_decode($jaw_gallery_items, true);
                        $actual_post_id = "";
                        if(isset($_GET["poid"])) {
                            $actual_post_id = $_GET["poid"];
                        }
                        echo '<meta property="og:title" content="' . get_the_title($actual_post_id) . '">' . "\n";
                        if (isset($_gallery_items_parsed)) {
                            $parse = filter_input(INPUT_GET, 'imid');
                            if(isset($parse)) {
                                $imgid=$_gallery_items_parsed[filter_input(INPUT_GET, 'imid')-1]["id"];
                                $src = wp_get_attachment_image_src($imgid, 'post-size-big');
                                $url = get_permalink()."?poid=".filter_input(INPUT_GET, 'poid')."&amp;imid=".filter_input(INPUT_GET, 'imid');
                            }
                        }
                    } else {
                        echo '<meta property="og:title" content="' . get_the_title() . '">' . "\n";
                    }
                    if (is_page() && get_post_meta(get_the_ID(), 'jaw_pb_startup', 'true') == 'true') {
                        $content = get_bloginfo();
                    }else{
                        $content = preg_replace("/\\[.*?\\]/", "", $post->post_content);
                    }
                    echo '<meta property="og:description" content="' . str_replace('\n', '', str_replace('"', '\'', stripslashes(strip_tags(jwUtils::crop_length($content, 300))))) . '">' . "\n";
                    if (is_home() || is_front_page()) {
                        echo '<meta property="og:type" content="website" /> ' . "\n";
                    } else {
                        echo '<meta property="og:type" content="article" />' . "\n";
                    }
                    if (has_post_thumbnail()) {
                        $src = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'post-size-big');
                        $url = get_permalink();
                    }
                    if(!empty($src)){
                        echo '<meta property="og:image" content="' . $src[0] . '" />' . "\n";
                        echo '<meta property="og:image:width" content="' . $src[1] . '" />'. "\n";
                        echo '<meta property="og:image:height" content="' . $src[2] . '" />'. "\n";
                    }
                    echo '<meta property="og:url" content="' . $url . '" />' . "\n"; // je potreba dynamicky menit url (musi byt cela url), jinak errurecek
                    echo '<meta property="og:site_name" content="' . get_bloginfo('name') . '" />' . "\n";
                    echo "<!-- END OG protocol -->" . "\n";
                }
            }
        }
        /**
        * Use phone links
        *
        * @return type String
        *
        */
        public static function setTelAutodetection() {
            $set = "yes";
            if(jwOpt::get_option('use_tel_links', '1') == '1') {
                $set="no";
            }
            echo '<meta name="format-detection" content="telephone='.esc_attr($set).'">';
        }

        /**
        * Desription
        *
        * @param type $name Description
        * @return type Description
        *
        */
        public static function jaw_nobot_question_filter($x) {

            if (is_user_logged_in()) {
                return $x;
            }
            if (!array_key_exists('question', $_POST) || trim($_POST['question']) == '') {
                wp_die(esc_html__('Error: Please fill in the required question.', "gdn-theme"));
            }
            // Verify the answer.
            if ($_POST['question'] == jwOpt::get_option('comments_antispam_answer', '2')) {
                return $x;
            }
            wp_die(esc_html__('Error: Please fill in the correct answer to the question.', "gdn-theme"));
        }

        /**
        * DEPRECATED - slouzilo pro goodstore
        *
        * @deprecated since gdaynews
        *
        * @param type $name Description
        * @return type Description
        *
        */
        public static function get_size($size, $space = false) {
            return 'full';
        }

        /**
        * aasort - sortování 2rozměrnýho pole dlevnitrniho klice
        *
        * @since GoodStore
        * @param array $array -
        * @param string $key -
        * @return array - sorted array
        */
        public static function aasort($array, $key) {
            $sorter = array();
            $ret = array();
            reset($array);
            foreach ($array as $ii => $va) {
                $sorter[$ii] = $va[$key];
            }
            asort($sorter);
            foreach ($sorter as $ii => $va) {
                $ret[$ii] = $array[$ii];
            }
            return $ret;
        }

        /**
        * Retrieve stylesheet directory URI - template or child-tempalte
        *
        * @since GoodStore
        * @param string $file - path to CSS file
        * @return string URI to CSS file
        */
        public static function jaw_get_stylesheet_uri($file) {
            if (file_exists(get_stylesheet_directory() . $file) && strlen($file) > 0) {
                return get_stylesheet_directory_uri() . $file;
            } else {
                return get_template_directory_uri() . $file;
            }
        }

        // ***********************   TINY MCE EDITOR   *************************
        /**
        * jaw_mce_buttons_2
        * Callback function to insert 'styleselect' into the $buttons array
        * @since GoodStore
        *
        * @param type $name Description
        * @return type Description
        *
        */
        public static function jaw_mce_buttons_2($buttons) {
            array_unshift($buttons, 'styleselect'); //formatselect
            return $buttons;
        }


        public static function register_new_user() {
            $user_email = '';
            $errors = array();
            if (filter_input(INPUT_POST, 'user') !== null && filter_input(INPUT_POST, 'email') !== null && filter_input(INPUT_POST, 'svalue') !== null && filter_input(INPUT_POST, 'jaw-register') !== null && filter_input(INPUT_POST, 'jaw_register_nonce') !== null) {
                if (!wp_verify_nonce(filter_input(INPUT_POST, 'jaw_register_nonce'), 'jaw_register')) {
                    $errors[] = esc_html__('Sorry, your nonce did not verify.', "gdn-theme");
                } else {
                    if (filter_input(INPUT_POST, 'svalue') === filter_input(INPUT_POST, 'jaw-register')) {
                        $user_login = esc_attr(filter_input(INPUT_POST, 'user'));
                        $user_email = esc_attr(filter_input(INPUT_POST, 'email'));
                        $sanitized_user_login = sanitize_user($user_login);
                        $user_email = esc_attr(apply_filters('user_registration_email', $user_email));

                        if (!is_email($user_email)) {
                            $errors[] = esc_html__('Invalid e-mail.', "gdn-theme");
                        } elseif (email_exists($user_email)) {
                            $errors[] = esc_html__('This email is already registered.', "gdn-theme");
                        }
                        if (empty($sanitized_user_login) || !validate_username($user_login)) {
                            $errors[] = esc_html__('Invalid user name.', "gdn-theme");
                        } elseif (username_exists($sanitized_user_login)) {
                            $errors[] = esc_html__('User name already exists.', "gdn-theme");
                        }

                        if (empty($errors)) {
                            $user_pass = wp_generate_password();
                            $user_id = wp_create_user($sanitized_user_login, $user_pass, $user_email);

                            if (!$user_id) {
                                $errors[] = esc_html__('Registration failed', "gdn-theme");
                            } else {
                                update_user_option($user_id, 'default_password_nag', true, true);
                                wp_new_user_notification($user_id, $user_pass);
                            }
                        }
                    }
                }
                if (!empty($errors)) {
                    define('REGISTRATION_ERROR', serialize($errors));
                } else {
                    define('REGISTERED_A_USER', $user_email);
                }
            }
        }

        /**
        * Vytvoreni a zaspani obsahu do souboru.
        *
        * @since GDayNews
        */
        public static function write_to_file($folder = '', $file_name = '', $content = '') {
            global $wp_filesystem;

            $filePath = JAW_THEME_DIR . $folder . '/' . $file_name;
            $folderPath = JAW_THEME_DIR . $folder;

            if (!defined('FS_METHOD')) {
                define('FS_METHOD', 'direct');
            }

            WP_Filesystem(null);

            if (file_exists($filePath)) {

                $fileContent = $wp_filesystem->get_contents($filePath);

                if (!is_writable($filePath)) {
                    self::write_file_status($filePath, 'error');
                }

                if (is_writable($folderPath)) {
                    if ($fileContent != $content) {

                        $wp_filesystem->put_contents($filePath, $content);
                        self::write_file_status($filePath, 'ok');
                        return true;
                    }
                } else {
                    self::write_file_status($filePath, 'error');
                    return false;
                }
            } else {
                // file missing, save it
                if (is_writable($folderPath)) {
                    $wp_filesystem->put_contents($filePath, $content);
                    self::write_file_status($filePath, 'ok');
                    return true;
                } else {
                    self::write_file_status($filePath, 'error');
                    return false;
                }
            }
        }

        /**
        * Uklada aktualni stav moznosti ukladani do souboru
        * pro kazdy soubor zvlast
        */
        private static function write_file_status($filePath, $value) {
            $can_write = get_option(self::WRITE_TO_FILE_STATUS);
            if ($value == 'error') {
                $can_write[$filePath] = $value;
            } else {
                unset($can_write[$filePath]);
            }
            update_option(self::WRITE_TO_FILE_STATUS, $can_write);
        }

        /**
        * Vzdy kdyz jsem v Adminu (is_admin) tak se zavola tato metoda,
        * zkontroluje stav zapisovani do souboru a v pripade neuspechu se zobrazi hlaska
        */
        public static function check_write_to_file() {
            $can_write = get_option(self::WRITE_TO_FILE_STATUS);
            if (!empty($can_write)) {
                //add_action('admin_notices', array('jwUtils', 'admin_notice_file_write')); @rami - 15.3.2017 - uzivatelum se tato hlaska proste nelibi...
            }
        }

        public static function admin_notice_file_write() {
            $can_write = get_option(self::WRITE_TO_FILE_STATUS);
            echo '<div class="error">';
            echo '<p><b>Problem with writing to these files:</b></p>';
            echo '<ul>';
            foreach ((array) $can_write as $file => $value) {
                echo '<li>' . $file . '</li>';
            }
            echo '</ul>';
            echo '<p>Please check permissions for these files.</p>';
            echo '</div>';
        }

        /**
        *
        * Vraci verzi scriptu nebo stylsheetu nalinkovaneho pres wp_enqueue_xxx
        * Cte hodnotu JAW_DEBUG a JAW_DEV_TOOLS
        *
        * JAW_DEV_TOOLS == true
        * pokud pouzivam chrome developer tools + grunt s automatickym refreshem css souboru, tak nechci zadnou verzi.
        *
        * JAW_DEBUG == true
        * vraci po kazdym vyrenderovani jinou verzi - necachuje se
        *
        * nebo
        * vraci $default_version
        *
        * @param type $default_version
        * @return string
        */
        public static function assetsVersion($default_version = '') {
            if (defined('JAW_DEV_TOOLS') && JAW_DEV_TOOLS) {   //pokud pouzivam chrome developer tools + grunt s automatickym refreshem css souboru, tak nechci zadnou verzi.
                $script_version = (string) false;
            } else if (defined('JAW_DEBUG') && JAW_DEBUG) {     //vraci po kazdym vyrenderovani jinou verzi - necachuje se
                $script_version = (string) time();
            } else {    //vraci verzi z atributu
                $script_version = (string) $default_version;
            }
        }

        /**
        * Hooknuto na wp_head
        *
        * Zjistuje zda-li jsou pouzity Google fonty / Adobe typekit / nebo neco jinyho a podle toho je linkuje
        *
        */
        public static function loadFonts() {
            if(!$finalFonts = get_transient(JAW_THEMESLUG.'_g_fonts')){

                $linkFonts = array();
                $font_manager = json_decode(jwOpt::get_option('font_manager',''));
                //default (po instalaci)
                if(!isset($font_manager)){
                    $default_font = new stdClass();
                    $default_font->source = 'google';
                    $default_font->family = 'Roboto';
                    $default_font->weight = '400';
                    $font_manager = array($default_font);
                }
                foreach((array) $font_manager as $font){
                    if(isset($font->source) && isset($font->family) && isset($font->weight) && $font->source === 'google'){
                        $name = str_replace(' ', '+', $font->family);
                        if(empty($linkFonts[$name])){
                            $linkFonts[$name] = array();
                        }
                        $linkFonts[$name][$font->weight] = $font->weight;
                    }
                }
                $subsets = array();
                if(jwOpt::get_option('latin_support', '0')){
                    $subsets[] = 'latin';
                }
                if(jwOpt::get_option('latin-ext_support', '0')){
                    $subsets[] = 'latin-ext';
                }
                if(jwOpt::get_option('cyrillic_support', '0')){
                    $subsets[] = 'cyrillic';
                }
                if(jwOpt::get_option('cyrillic-ext_support', '0')){
                    $subsets[] = 'cyrillic-ext';
                }
                if(jwOpt::get_option('greek_support', '0')){
                    $subsets[] = 'greek';
                }
                if(jwOpt::get_option('greek-ext_support', '0')){
                    $subsets[] = 'greek-ext';
                }
                if(jwOpt::get_option('devanagari_support', '0')){
                    $subsets[] = 'devanagari';
                }
                if(jwOpt::get_option('vietnamese_support', '0')){
                    $subsets[] = 'vietnamese';
                }
                if(jwOpt::get_option('khemer_support', '0')){
                    $subsets[] = 'khemer';
                }

                $finalFonts = array("subsets" => array(), "fonts" => array());
                foreach($linkFonts as $fontFamily => $atts){
                    $styles = '';
                    if(!empty($atts)){
                        $styles = ':'.implode(',', $atts);
                    }
                    $finalFonts["fonts"][$fontFamily] = $fontFamily . $styles;
                }
                $finalFonts["subsets"] = $subsets;

                set_transient( JAW_THEMESLUG.'_g_fonts', $finalFonts, WEEK_IN_SECONDS );
            }

            $charsub = '';
            if(!empty($finalFonts["subsets"])){
                $charsub = '&subset=' . implode(',',$finalFonts["subsets"]);
            }

            $font_url = add_query_arg( 'family',  implode('|',$finalFonts["fonts"]) . $charsub , "//fonts.googleapis.com/css" );

            return $font_url;
        }

        /**
        * Pridava do headeru meta tagy
        */
        public static function header() {
            global $wp_session;
            $html = '' . PHP_EOL;

            $html .= '<!-- version of GoodDayNews: ' . JAW_THEMEVERSION . ' -->' . PHP_EOL;

            $html .= '<meta charset="'. get_bloginfo('charset') . '">' . PHP_EOL;

            if (esc_attr(jwOpt::get_option('responsive', '1') == '1')) {
                $html .= '<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.5, user-scalable=1" />' . PHP_EOL;
            } else {
                $html .= '<meta name="viewport" content="width=1366" />' . PHP_EOL;
            }

            $html .= '<!-- IE 8 and older -->' . PHP_EOL;
            $html .= '<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">' . PHP_EOL;


            $html .= '<!-- Enable Startup Image for iOS Home Screen Web App -->' . PHP_EOL;
                $html .= '<meta name="apple-mobile-web-app-capable" content="yes" />' . PHP_EOL;

            if(jwOpt::get_option('custom_favicon', get_template_directory_uri() . '/favicon.png') != ""){
                $html .= '<!-- Favicon -->' . PHP_EOL;
                $html .= '<link rel="shortcut icon" id="favicon" type="image/png" href="' . esc_url(jwOpt::get_option('custom_favicon', get_template_directory_uri() . '/favicon.png')) . '">' . PHP_EOL;
            }
            $html .= '<!-- Feed -->' . PHP_EOL;
            $html .= '<link rel="alternate" type="application/rss+xml" title="' . get_bloginfo('name') . 'Feed" href="' . home_url('/feed/') . '"> ' . PHP_EOL;

            if(jwOpt::get_option('custom_js_header', '') !== ''){
                $html .= '<!-- Custom Script Header start -->';
                $html .= '<script>';
                $html .= jwOpt::get_option('custom_js_header', '');
                $html .= '</script>';
            }
            if(jwOpt::get_option('custom_js_tag_header', '') !== '<script></script>'){
                $html .= '<!-- Custom Script TAG Header  -->';
                $html .= jwOpt::get_option('custom_js_tag_header', '');
            }

            echo $html;
        }

        public static function admin_header() {
            $html = '';
            $html .= '<!-- version of GoodDayNews: ' . JAW_THEMEVERSION . ' -->' . PHP_EOL;
            $html .= '<link rel="shortcut icon" id="favicon" type="image/x-icon" href="' . esc_url(jwOpt::get_option('custom_favicon', get_template_directory_uri() . '/favicon.png')) . '">' . PHP_EOL;
            echo $html;
        }

        public static function body_class($classes) {

            global $wp_query;
            $classes[] = esc_attr(jwOpt::get_option('theme_style', 'fullwidth'));

            $classes[] = esc_attr(jwOpt::get_option('wide_mode', 'no-wide'));

            switch (jwOpt::get_option('scroll_load_images', '0')) {
                case '0':
                    $classes[] = 'jaw-no-lazyload';
                    break;
                case '1':
                    $classes[] = 'jaw-hide-image';
                    $classes[] = 'jaw-image-use-placeholder';
                    break;
                case '2':
                    $classes[] = 'jaw-hide-image';
                    $classes[] = 'jaw-retina-images';
                    $classes[] = 'jaw-image-use-placeholder';
                    break;
                default;
            }

            if (is_user_logged_in()) {
                $classes[] = 'logged-in';
            } else {
                $classes[] = 'logged-out';
            }

            if (isset($wp_query->query_vars['cat'])) {
                $cat = $wp_query->query_vars['cat'];
                if(is_array($wp_query->query_vars['cat'])){
                    $cat = reset($wp_query->query_vars['cat']);
                }
                $classes[] = esc_attr(jwOpt::get_option('cat_bg_color', 'cat-default', 'category', $cat));
            }


            $classes = apply_filters( 'jaw_body_class', $classes );
            return $classes;
        }

    public static function post_class($classes) {
        global $post;
        if ((!has_post_thumbnail() && (get_post_format() == 'standart' || get_post_format() == 'image' ||  !get_post_format()) )|| get_post_format() == 'quote' || get_post_format() == 'link' ) {
            $classes[] = 'no-post-thumbnail';
        } else {
            $classes[] = 'has-post-thumbnail';
        }
        $classes[] = 'format-' . get_post_format();
        $classes[] = 'element';
        return $classes;
    }

    public static function footer_google_fonts(){
        if(jwOpt::get_option('preload_google_fonts', '1')){
            $finalFonts = get_transient(JAW_THEMESLUG.'_g_fonts');
            if(!$finalFonts){
                return;
            }

            $html_script = '';
            $html_script_array = array();

            if(!empty($finalFonts) && !empty($finalFonts['fonts'])){
                foreach ((array) $finalFonts['fonts'] as $font) {
                    $html_sub_script = "'".$font;
                    if(!empty($finalFonts["subsets"])){
                        $html_sub_script .= ":".implode(',',$finalFonts["subsets"]);
                    }
                    $html_sub_script .= "'";
                    $html_script_array[] = $html_sub_script;
                }
            }
            if(!empty($html_script_array)){
                $html_script = '<!-- Async pre-load of Google Fonts -->'. PHP_EOL;
                $html_script = '<script>'. PHP_EOL;
                $html_script .= "WebFont.load({google: {families: [". PHP_EOL;
                    $html_script .= implode(',',$html_script_array);
                $html_script .="]}});". PHP_EOL;
                $html_script .= "</script>". PHP_EOL;
            }
            echo $html_script;
        }
    }

    /**
    * footer_socials
    *
    * link scripts for social sites
    *
    * prilepeno na wp_footer
    */
    public static function footer_socials() {
        ?>
  <?php
        //FACEBOOK share
        if (jwOpt::get_option('fbcomments_appid', '') != '') {
            ?>
    <div id="fb-root"></div>
    <script>
      window.fbAsyncInit = function() {
        FB.init({
          appId: '<?php echo esc_attr(jwOpt::get_option('fbcomments_appid', ''));?>',
          xfbml: true,
          version: 'v2.0'
        });
      };
      (function(d, s, id) {
        var js, fjs = d.getElementsByTagName(s)[0];
        if (d.getElementById(id)) {
          return;
        }
        js = d.createElement(s);
        js.id = id;
        js.src = "//connect.facebook.net/en_US/sdk.js";
        fjs.parentNode.insertBefore(js, fjs);
      }(document, 'script', 'facebook-jssdk'));
    </script>
    <?php } else { ?>
        <div id="fb-root"></div>
        <script>(function(d, s, id) {
        var js, fjs = d.getElementsByTagName(s)[0];
        if (d.getElementById(id)) return;
        js = d.createElement(s); js.id = id;
        js.src = "//connect.facebook.net/en_US/sdk.js#xfbml=1&version=v2.6";
        fjs.parentNode.insertBefore(js, fjs);
        }(document, 'script', 'facebook-jssdk'));</script>
    <?php } ?>

      <?php if (is_single()) { ?>
        <script type="text/javascript">
          /* twitter share (min)*/ ! function(a, b, c) {
            var d, e = a.getElementsByTagName(b)[0];
            a.getElementById(c) || (d = a.createElement(b), d.id = c, d.src = "//platform.twitter.com/widgets.js", e.parentNode.insertBefore(d, e))
          }(document, "script", "twitter-wjs");
          /*google+ share (min)*/
          window.___gcfg = {
              lang: "<?php echo esc_attr(get_locale()); ?>"
            },
            function() {
              var a = document.createElement("script");
              a.type = "text/javascript", a.async = !0, a.src = "https://apis.google.com/js/plusone.js";
              var b = document.getElementsByTagName("script")[0];
              b.parentNode.insertBefore(a, b)
            }();
        </script>
        <?php } ?>
          <?php if (defined('DISQUS_DOMAIN')) { ?>
            <!-- disqus -->
            <script type="text/javascript">
              /* * * CONFIGURATION VARIABLES: EDIT BEFORE PASTING INTO YOUR WEBPAGE * * */
              var disqus_shortname = <?php echo get_option('disqus_forum_url'); ?>; // required: replace example with your forum shortname

              /* * * DON'T EDIT BELOW THIS LINE * * */
              (function() {
                var s = document.createElement('script');
                s.async = true;
                s.type = 'text/javascript';
                s.src = '//' + disqus_shortname + '.disqus.com/count.js';
                (document.getElementsByTagName('HEAD')[0] || document.getElementsByTagName('BODY')[0]).appendChild(s);
              }());
            </script>
            <?php
        }
    }

    /**
    * Vymzani specialnich znaku ze stringu
    *
    */
    public static function cutSpecials($string) {
        $string = str_replace(' ', '-', $string); // Replaces all spaces with hyphens.

        return preg_replace('/[^A-Za-z0-9\-]/', '', $string); // Removes special chars.
    }

    public static function sortByWidth($array) {
        if (count($array) < 2) {
            return $array;
        }
        $left = $right = array();
        reset($array);
        $pivot_key = key($array);
        $pivot = array_shift($array);
        foreach ($array as $k => $v) {
            if (isset($v['width']) && isset($pivot['width']) && ($v['width'] < $pivot['width']))
                $left[$k] = $v;
            else
                $right[$k] = $v;
        }
        return array_merge(self::sortByWidth($left), array($pivot_key => $pivot), self::sortByWidth($right));
    }

    public static function increase_readers_count() {
        $postId = filter_input(INPUT_POST, 'post_id');
        if($postId != ''){
            $count = get_post_meta($postId, 'jaw_readers', true);
            if ($count) {
                $count++;
            } else {
                $count = 1;
            }
            update_post_meta($postId, 'jaw_readers', $count);
            echo "OK " . $count;
        }
        die();
    }

    public static function get_readers_count($post_id) {
        $count = get_post_meta($post_id, 'jaw_readers', true);
        if (!$count) {
            $count = 0;
        }
        if($count > 1000){
            $count = (floor($count / 100) / 10) . esc_html__('k', "gdn-theme");
        }
        return $count;
    }

    /**
    * @name        JaW's messages
    *
    * @param $text Message
    * @return      Message
    *
    */
    public static function jaw_msg($text, $type = 'warning') {
        echo '<div class="jaw_msg jaw_msg_type_' . esc_attr($type) . '"><span>' . $text . '<span></div>';
    }

    public static function json_quote_checker($input){
        return str_replace('\'', '&quot;',str_replace('"', '&quot;', $input));
    }


    public static function join_last_comment($sql) {
        global $wpdb;

        $sql .= '
        LEFT JOIN (SELECT comment_post_ID AS post, MAX(comment_date) AS date FROM '.$wpdb->comments.' WHERE comment_approved="1" GROUP BY post) AS last_comment
        ON last_comment.post = '.$wpdb->posts.'.ID
        ';

        return $sql;
    }

    public static function orderby_last_comment($sql) {

        return 'last_comment.date DESC'.($sql ? ', '.$sql : '');

        return $sql;
    }

    /**
    * @name         customizer_preview_preset
    * @description  V customizeru zobrazuje nazev presetu
    *
    * @todo         obcas je to schovany (kvuli overflow: hidden) - header, container.
    **/
    public static function customizer_preview_preset($title, $preset, $help = array(),$position = null){
        $out = "";
        if(function_exists('is_customize_preview') && is_customize_preview()){
            if(isset($position)){
                self::$_preview_side = $position;
            }
            $presetName = jwOpt::getPresetValue('title', '-- by parent --', 'color',$preset);
            $out .= '<div class="jaw-preview-preset '.self::$_preview_side.'">';
            //typ sekce
            $out .= '<div class="jaw-preview-title">'.esc_attr($title).' color scheme</div>';
            //nazev presetu
            $out .= $presetName;

            //Help sekce
            if(sizeof($help) > 0){
                if(!isset($help['position'])){
                    $help['position'] = 'bottom';
                }
                $out .= '<div class="jaw-preview-help '.$help['position'].'">';
                $out .= '<i class="jaw-icon-question"></i>';
                $out .= '<div class="jaw-preview-help-content">';
                if(isset($help['title'])){
                    $out .= '<div class="jaw-preview-help-title">'.esc_attr($help['title']).'</div>';
                }
                if(isset($help['description'])){
                    $out .= '<div class="jaw-preview-help-description">'.esc_attr($help['description']).'</div>';
                }
                if(isset($help['image'])){
                    $out .= '<img src="'.get_template_directory_uri(). '/help/images/' . $help['image'].'">';
                }
                $out .= '</div>';
                $out .= '</div>';
            }

            $out .= '</div>';
            if(self::$_preview_side == 'left'){
                self::$_preview_side = 'right';
            }else{
                self::$_preview_side = 'left';
            }
        }
        return $out;
    }

    // Translation v TO
    public static function jaw_translation($translations, $text, $domain){
        if($domain == "gdn-theme"){
            $jaw_translation = esc_attr(jwOpt::get_option('translation'));
            if(isset($jaw_translation[$text])){
                if(isset($jaw_translation[$text]['singular'])){
                    $translations = $jaw_translation[$text]['singular'];
                }

            }
        }
        return $translations;
    }

    // Translation v TO plural
    public static function jaw_ntranslation($translations, $singular,$plural, $number, $domain){
        if($domain == "gdn-theme"){
            $jaw_translation = esc_attr(jwOpt::get_option('translation'));
            $text = esc_attr($singular);
            if(isset($jaw_translation[$text])){
                if(isset($jaw_translation[$text]['singular']) && $number == 1){
                    $translations = $jaw_translation[$text]['singular'];
                }
                if(isset($jaw_translation[$text]['plural']) ){
                    $translations = $jaw_translation[$text]['plural'];
                }
            }
        }
        return $translations;
    }

    /* STORING PREVIOUS URL */
    public static function jaw_get_previous_url() {
        return isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : '';
    }


    public static function jaw_base64_dec($hash){
        if (function_exists('jaw_decode')) {
            return jaw_decode($hash);
        } else {
            return 'For this functionality please activate JaW Shortcode Plugin';
        }
    }
    public static function jaw_base64_enc($content){
        if (function_exists('jaw_encode')) {
            return jaw_encode($content);
        } else {
            return 'For this functionality please activate JaW Shortcode Plugin';
        }
    }

    public static function jsonEncode($data){
        $json = json_encode($data);
        $json = json_decode($json);
        $json = json_encode((object) $json, JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_HEX_AMP | JSON_UNESCAPED_UNICODE);
        $json = self::sanitizeJson($json);
        return $json;
    }

    public static function sanitizeJson($json){
        $json = addslashes(str_replace('"', '\'',$json));
        return $json;
    }

    public static function defaultLocale($locale, $domain){
        return 'en_US';
    }
}
}
