<?php

/**
* Dynamic style
*
* @author JaW Templates <http://www.jawtemplates.com>
* @copyright (c) 2013, CCB, spol. s r.o.
* @version 2.0
*/
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

if (!class_exists('jwStyle')) {
    
    class jwStyle {
        
        var $cssFilePath = null;
        var $filename_min = null;
        var $css_path = null;
        private static $_compress = array();
        
        function __construct() {
            $this->css_path = JAW_THEME_DIR . '/css/';
        }
        
        /**
        * get_static
        * Get static css always when reload wp_admin
        * @since: 2
        */
        public function get_static($type = "color") {

            $less_file = '';
            
            $id = get_current_blog_id();
            
            $less = new lessc;
            
            $less_file = '';
            
            $less_file .= '@import "' . '../mixins/mixins.less";' . PHP_EOL;
            
            $less_file .= self::get_custom_styles($type) . PHP_EOL;
            
            // add files from custom_styles
            $files1 = scandir(JAW_THEME_DIR.'/css/custom_styles/');
            foreach ($files1 as $key => $file){
                if (!in_array($file,array(".","..")) && strpos($file,".less")){
                    $less_file .= '@import "' . '../../custom_styles/'.$file .'";' . PHP_EOL;
                }
            }
            
            if($type === "color"){
                $filename = 'themeoptions-' . $id;
            }else{
                $filename = 'themeoptions-' . $id . '-preview';
            }
            
            jwUtils::write_to_file('/css/less/themeoptions', $filename. '.less', $less_file);
            
            try {
                $out=$less->compileFile(JAW_THEME_DIR . '/css/less/themeoptions/'.$filename.'.less');
            } catch (Exception $ex) {
                echo "lessphp fatal error: ".$ex->getMessage().'<br /><br /> Also check your <span style="color: red">THEME JAW_OPTIONS->CUSTOM STYLESHEETS</span> for BAD CSS SYNTAXE';
                }
            
            $out = self::minify($out);
            
            if($type === "color"){
                jwUtils::write_to_file('/css/', 'themeoptions-' . $id . '.css', $out);
            }
            jwUtils::write_to_file('/css/', 'themeoptions-' . $id . '-preview.css', $out);
        }
        
        private static function get_custom_styles($type = "color") {
            $css = "";
            
            /* Width of site ************************************************************** */
            switch(esc_attr(jwOpt::get_option('wide_mode', 'wide'))){
                case 'no-wide': $width = '980';
                    break;
                case 'wide': $width = '1180';
                    break;
                case 'custom': $width = jwOpt::get_option('custom_width', '1180');
                    break;
            }
            $css .= ".width-of-theme(" .esc_attr($width) . ");". PHP_EOL;
            
            /* END Width of site ************************************************************** */
            
            /* (retina) LOGO ************************************************************** */
            $template_logo = jwOpt::get_option('custom_logo', '');
            if (strlen($template_logo) == 0) {
                $template_logo = JAW_THEME_URI . '/images/logo/logo.png';
            }
            $size = false;
            if (strlen($template_logo) > 0) {
                $size = @getimagesize($template_logo);

                /*if (empty($http_response_header)) { @rami - 17.3.2017 - uzivatelum se diky tomuto nepodari ani ukladat TO (problem je na serveru, kde maji firewall)
                    echo 'Logo - Connection failed.';
                }

                // See if the response string contains `200`. works in `HTTP/1.1` at least
                if (strpos($http_response_header[0], '200') === false) {
                    echo 'Logo - HTTP Error: ' . $http_response_header[0] . ' <br><br>Aren`t you using htpswd?<br><br>Otherwise please contact support at jaw@jawtemplates.com';
                }*/
            }
            
            
            $template_logo_mobile = jwOpt::get_option('custom_mobile_logo', '');
            if (strlen($template_logo_mobile) == 0) {
                $template_logo_mobile = $template_logo;
            }
            $size_mobile = false;
            if (strlen($template_logo_mobile) > 0) {
                $size_mobile = @getimagesize($template_logo_mobile);
            }
            
            
            $template_logo_menu = jwOpt::get_option('custom_logo_fixed_menu', '');
            if (strlen($template_logo_menu) == 0) {
                $template_logo_menu = $template_logo;
            }
            $size_menu = $size;
            if (strlen($template_logo_menu) > 0) {
                $size_menu = @getimagesize($template_logo_menu);
            }
            
            /* END (retina) LOGO ********************************************************** */
            
            /* Menu height ******************************************************** */
            if (jwOpt::get_option('logo_retina_ready', '1')) {
                $size = $size[1] / 2;
                $size_menu = $size_menu[1] / 2;
                $size_mobile = $size_mobile[1] / 2;
            }else{
                $size = $size[1];
                $size_menu = $size_menu[1];
                $size_mobile = $size_mobile[1];
            }
            $size = apply_filters( 'jaw_logo_size', $size );
            $size_menu = apply_filters( 'jaw_menu_logo_size', $size_menu );
            $size_mobile = apply_filters( 'jaw_mobile_logo_size', $size_mobile );
            if($size && $size_mobile && jwOpt::get_option('header_style', 'l-center') == 'in-menu'){
                $css .= ".menu-height(" .esc_attr($size) . ", ". esc_attr($size_mobile).");". PHP_EOL;
            }
            if($size_menu && jwOpt::get_option('logo_in_menu_bar_fix', '0') && jwOpt::get_option('menu_bar_fix','1')){
                $css .= ".menu-fixed-height(".esc_attr($size_menu).");". PHP_EOL;
            }
            if($size && $size_mobile && $size_menu){
                $css .= ".logo-retina(" .esc_attr($size) . ", ".esc_attr($size_mobile).", ".esc_attr($size_menu).");". PHP_EOL;
            }
            
            /* END Menu height ******************************************************** */
            unset($size);
            unset($size_mobile);
            unset($size_menu);
            unset($template_logo);
            unset($template_logo_mobile);
            unset($template_logo_menu);
            
            /* Background ******************************************************** */
            $body_background_color = jwOpt::get_option('body_background_clr', '#ffffff');
            $body_box_background_color = jwOpt::get_option('body_box_background_clr', '#ffffff');
            
            $css .= '.background(' . $body_background_color . ', ' . $body_box_background_color . ');' . PHP_EOL;
            $css .= "@jaw-mainbg:" . $body_box_background_color . ";" . PHP_EOL;
            $css .= '#respond .comment-reply-title small:first-of-type{background-color: '.$body_box_background_color.'}' . PHP_EOL;
            $css .= '.jaw-spoiler:hover{background-color: '.$body_box_background_color.'!important}' . PHP_EOL;
            
            unset($body_background_color);
            unset($body_box_background_color);
            /* BACKGROUND END ***************************************************** */
            
            /* background image ************************************************* */
            //init
            $background_image = array();
            $background_image_size = array();
            $background_image_repeat = array();
            $background_image_attachment = array();
            
            //pattern
            $bg_images_url = get_template_directory_uri() . '/images/bg_texture/';
            $background_texture = jwOpt::get_option('background_texture', 'none.png');
            if ($background_texture != 'none.png') {
                $background_image[] = "url(".$bg_images_url . $background_texture.")";
                $background_image_size[] = "auto";
                $background_image_repeat[] = "repeat";
                $background_image_attachment[] = "scroll";
            }
            
            //image
            $background_image_url = jwOpt::get_option('background_image', '');
            if ($background_image_url != '') { //bg image + pattern
                $background_image[] = "url(".$background_image_url.")";
                $background_image_size[] = jwOpt::get_option('background_image_size', 'cover');
                $background_image_repeat[] = jwOpt::get_option('background_image_repeat', 'no-repeat');
                $background_image_attachment[] = jwOpt::get_option('background_image_attachment', 'fixed');
            }
            
            $css .= '.background-image(\'' . implode(", ",$background_image) . '\', \'' . implode(", ",$background_image_size) . '\', \'' . implode(", ",$background_image_repeat) . '\', \'' . implode(", ",$background_image_attachment) . '\');' . PHP_EOL;
            
            unset($background_image);
            unset($background_image_size);
            unset($background_image_repeat);
            unset($background_image_attachment);
            unset($bg_images_url);
            
            /* background image END ************************************************* */
            
            /* BG banner ************************************************************** */
            
            if (jwOpt::get_option('background_banner_show', '0')) {
                $background_texture = jwOpt::get_option('background_banner', '');
                
                $background_banner_image_attachment = jwOpt::get_option('background_banner_image_attachment', 'fixed');
                
                $link_right_width = jwOpt::get_option('background_banner_link_width_right', '0');
                $link_left_width = jwOpt::get_option('background_banner_link_width_left', '0');
                
                if ($background_texture) {
                    $css .= '.background-banner(\'' . $background_texture . '\', ' . $link_right_width . ', ' . $link_left_width . ', '.$background_banner_image_attachment.');' . PHP_EOL;
                }
            }
            
            unset($background_texture);
            
            /* END BG banner ********************************************************* */
            
            /* Message box colors ************************************************* */
            
            $success_box_bg = jwOpt::get_option('success_box_bg', '#dff0d8');
            $success_box_color = jwOpt::get_option('success_box_clr', '#3c763d');
            $info_box_bg = jwOpt::get_option('info_box_bg', '#d9edf7');
            $info_box_color = jwOpt::get_option('info_box_clr', '#31708f');
            $warning_box_bg = jwOpt::get_option('warning_box_bg', '#fcf8e3');
            $warning_box_color = jwOpt::get_option('warning_box_clr', '#8a6d3b');
            $danger_box_bg = jwOpt::get_option('danger_box_bg', '#f2dede');
            $danger_box_color = jwOpt::get_option('danger_box_clr', '#a94442');
            
            $css .= '.message-box(' . $success_box_bg . ',' . $success_box_color . ',' . $info_box_bg . ',' . $info_box_color . ',' . $warning_box_bg . ',' . $warning_box_color . ',' . $danger_box_bg . ',' . $danger_box_color . ');' . PHP_EOL;
            
            
            /* END Message box colors ************************************************* */
            
            
            /* Overlay collor ********************************************************* */
            
            $overlay_upper = jwOpt::get_option('overlay_upper', 'rgba(0,0,0,0)');
            $overlay_bottom = jwOpt::get_option('overlay_bottom', 'rgba(0,0,0,0.7)');
            $overlay_text = jwOpt::get_option('overlay_text', 'rgba(255,255,255,0.7)');
            
            $css .= '.overlay-gradient-color('.$overlay_upper.','.$overlay_bottom.', '.$overlay_text.');';
            
            $overlay_color = jwOpt::get_option('overlay_color', 'rgba(0,0,0,0.7)');
            
            $css .= '.overlay-color('.$overlay_color.');';
            
            /* END Overlay collor ********************************************************* */
            
            
            
            /* Color presets ****************************************************** */
            $color_scheme_main = self::implodePreset(jwOpt::loadPreset($type, jwOpt::get_option('main_color')), jwOpt::get_option('main_color'));
            
            if ($color_scheme_main != 'error') {
                $css .= ".jaw-main-content(" . $color_scheme_main . ");" . PHP_EOL;
                //BB press is activated
                if(class_exists( 'bbPress' )){
                    $css .= ".jaw-bbpress(" . $color_scheme_main . "," . $success_box_bg . "," . $success_box_color . "," . $info_box_bg . "," . $info_box_color . "," . $warning_box_bg . "," . $warning_box_color . "," . $danger_box_bg . "," . $danger_box_color . ");" . PHP_EOL;
                }
                if(class_exists( 'BuddyPress' )){
                    $css .= ".jaw-buddypress(" . $color_scheme_main . "," . $success_box_bg . "," . $success_box_color . "," . $info_box_bg . "," . $info_box_color . "," . $warning_box_bg . "," . $warning_box_color . "," . $danger_box_bg . "," . $danger_box_color . ");" . PHP_EOL;
                }
                
            
            
            // DEFINICE BARVICKOVYCH MIXIN
            // Prvni uroven klice v array je nazev mixyny
            // Vsechny klice a hodnoty v zanorenych polich jsou nazvy optionu
            // Dalsi zanoreni predstavuje hierarchii (POSLOUPNOST) pokud je zanorenejsi option nastaven do defaultu, vygeneruje se barva z nadrazeneho prvku
            // !!! - vyssi level v POSLOUPNOSTI muze byt pouze opt- (theme option)
            //
            //
            // Pouziva se prefix
            // - opt - pro theme options
            // - tax - pro taxonomie (metatax)
            // - sng - pro single
            //
            //
            //  Priklad 1:
            //  ==========
            //
            // array( 'mixina_v_lessu' => array('opt-nazevoptionu', 'tax-nazevjinehooptionu'));
            //
            //
            //
            $preset_options = array(
            //mixina jaw-sidebars v color-presets.less
            'sidebars' => array(
            'opt-main', // sidebary v main barve
            'tax-content', // pokud nema sidebar nastavenou barvu, tak se prebira z kategorie
            'revo-sidebar', // sidebary v pagebuilderu
            'revotax-sidebar', // sidebary v pagebuilderu
            'revoopt-sidebar', // sidebary v pagebuilderu
            'opt-menu' => array('opt-submenu'), //widgety v menu //POSLOUPNOST - pouzije se menu_left preset - kdyz je nastaven na default, tak se pouzije menu preset
            'opt-mobile_menu', //widgety v mobile menu
            'categorypst-sidebar_left1',
            'categorypst-sidebar_left2',
            'categorypst-sidebar_right1',
            'categorypst-sidebar_right2',
            'singlepst-sidebar_left1',
            'singlepst-sidebar_left2',
            'singlepst-sidebar_right1',
            'singlepst-sidebar_right2',
            'opt-footer',
            'opt-header'
            ),
            //mixina jaw-header v color-presets.less
            'header' => array('opt-header'),
            //mixina jaw-top_bar v color-presets.less
            'top_bar' => array('opt-top_bar'),
            //mixina jaw-content v color-presets.less
            'content' => array(
            'sng-page', //page preset
            'opt-main', // content pro main color
            'opt-menu', //content pro userpanel
            'tax-content',
            'opt-my_news' //blog pro mynews
            ),
            //mixina jaw-single-post v color-presets.less
            'single-post' => array(
            'tax-content'
            ),
            //mixina jaw-post v color-presets.less
            'post' => array(
            'opt-top_bar'
            ),
            //mixina jaw-container v color-presets.less
            'container' => array(
            'revo-preset', // container v pagebuilderu
            'revotax-preset', // container v pagebuilderu
            'revoopt-preset' // container v pagebuilderu
            ),
            //mixina jaw-sliders-preset v color-presets.less
            'sliders-preset' => array(
            'revo-slider_preset',
            'revotax-slider_preset',
            'revoopt-slider_preset',
            ),
            //mixina jaw-ticker-helper v color-presets.less
            'ticker-helper' => array(
            'revo-ticker_preset',
            'revotax-ticker_preset',
            'revoopt-ticker_preset',
            ),
            //mixina jaw-userpanel v color-presets.less
            'userpanel' => array('opt-my_news'),
            //mixina jaw-cat_head v color-presets.less
            'cat_head' => array(// obrazkovej header
            'tax-cat_head',
            'sng-sng_head'
            ),
            //mixina jaw-media-gallery v color-presets.less
            'media-gallery' => array(
            'opt-media_gallery'
            ),
            //mixina jaw-mobile-menu v color-presets.less
            'mobile-menu' => array(
            'opt-menu' => array('opt-mobile_menu')
            ),
            //mixina jaw-footer v color-presets.less
            'footer' => array('opt-footer'),
            //mixina jaw-menu-left v color-presets.less
            'menu-left' => array(
            'opt-menu' => array('opt-menu_left') //POSLOUPNOST - pouzije se menu_left preset - kdyz je nastaven na default, tak se pouzije menu preset
            )
            );
            
            // pridani mixin pro menu (aby se negenorovaly barvy pro vsechny typy menu)
            switch (jwOpt::get_option('menu_style_type', 'classic')) {
                case 'colored': $preset_options['colored-menu'] = array('opt-menu', 'tax-content');
                    $preset_options['colored-sub-menu'] = array('opt-menu' => array('opt-submenu'));
                    $preset_options['mobile-menu-colored'] = array('tax-content');
                    break;
                case 'classic': $preset_options['classic-menu'] = array('opt-menu');
                    $preset_options['classic-sub-menu'] = array('opt-menu' => array('opt-submenu'));
                    break;
                case 'simple': $preset_options['simple-menu'] = array('opt-menu');
                    $preset_options['simple-sub-menu'] = array('opt-menu' => array('opt-submenu'));
                    break;
                }
                
                self::$_compress = array();
                $css .= self::generate_preset_mixin($preset_options, jwOpt::get_option('main_color'), false, $type);
            }else{
                echo '<strong>Please choose Main Color Scheme!</strong></p><a href="#of-option-colorcheme" class="jw-infodialog-button jaw-goto-colorsettings" data-goto="colorsettings" data-highlight="main_color" >See problem</a><br>';
            }
            unset($color_scheme_main);
            unset($preset_options);
            /* END color presets ************************************************* */
            
            /* JAW Hover Effect Background Color ************************************************* */
            
            $jaw_hover_bg = esc_attr(jwOpt::get_option('image_hover_effect_bg', '#ffffff'));
            $jaw_hover_type = jwOpt::get_option('image_hover_effect_type', 'zoomie');
            
            $css .= '.jaw-image-bg-'.$jaw_hover_type.'('.$jaw_hover_bg.');' . PHP_EOL;
            
            unset($jaw_hover_bg);
            unset($jaw_hover_type);
            /* END JAW Hover Effect Background Color ************************************************* */
            
            /* Title weight *******************************/
            
            $css .= '.title-weight('.jwOpt::get_option('big_title_line_weight','3').', '.jwOpt::get_option('title_4_line_weight','1').');' . PHP_EOL;
            
            /* END Title weight *************************** */
            
            
            
            /* FONT SETTING ***************************************************** */
            $font_manager = json_decode(jwOpt::get_option('font_manager',''));
            foreach((array)$font_manager as $font){
                if(isset($font->family) && isset($font->weight) && isset($font->size) && isset($font->lineHeight) && isset($font->websafe)){
                    
                    foreach((array) $font->places as $place){
                        $text_font = explode('&', $font->family);
                        $text_font = explode(':', $text_font[0]);
                        $text_font = $text_font[0];
                        $text_font = str_replace('+', ' ', $text_font);
                        $weight = str_replace('italic', '',$font->weight);
                        $italic = (strpos($font->weight, 'italic'))? 'italic': 'normal';
                        $css .= '.font-'.$place.'(' . $text_font . ', ' . $weight . ','.$italic.', '.$font->size.','.$font->lineHeight.','.$font->websafe.');' . PHP_EOL;
                        
                    }
                }
                
            }
            
            $css .= '.font-mobile('.jwOpt::get_option('font_mobile_paragraph','1').');' . PHP_EOL;
            /* END FONT SETTING ************************************************* */
            
            /* CUSTOM STYLTES from Theme options */
            $css .= self::get_inline();
            
            if (esc_attr(jwOpt::get_option('responsive', '1') == '0')){
                $css .= '.container{width: 1366px !important;}' . PHP_EOL;
                $css .= '@-ms-viewport{width: 1366px;}' . PHP_EOL;
            }
            
            /* Number of version of css file has to be changed */
            update_option('jaw_custom_css_version', (string) time());
            
            return $css;
        }

        public function check_is_writeable() {
            if (is_writable($this->css_path)) {
                add_action('admin_notices', array(&$this, 'error_write_folder'));
                return true;
            } else if (is_writable($this->cssFilePath)) {
                add_action('admin_notices', array(&$this, 'error_write_file'));
                return true;
            } else {
                return false;
            }
        }

        public function error_write_folder() {
            echo '<div id="message" class="updated below-h2"><p><strong>The css folder "' . get_template_directory() . '/css" is not writeable.</strong></p></div>';
        }

        public function error_write_file() {
            echo '<div id="message" class="updated below-h2"><p><strong>The css file "' . get_template_directory() . '/css/custom-styles.css" is not writeable.</strong></p></div>';
        }

        private static function generate_preset_mixin($preset_options, $default, $mixins = false, $type = "color") {
            $css = '';
            
            foreach ($preset_options as $key => $val) {
                
                if(!$mixins && is_array($val)){
                    $css .= self::generate_preset_mixin($val, $default, $key, $type);
                    continue;
                }
                
                if (is_array($val)) {
                    $option = $key;
                } else {
                    $option = $val;
                }
                //rozdeli opt-header na array(opt,header)
                $typnoption = explode('-', $option);
                
                $typ = $typnoption[0];
                $option = $typnoption[1];
                //pole, protoze se ptam napr. na revo containery - tech muze byt hodne (kazdej s jinym presetem), takze mi to vrati vsechny presety, ktery jsou nastaveny na containerech
                $custom_styles = array();
                
                if($typ == 'opt') {
                    $custom_styles = array(jwOpt::get_option($option . '_color', $default));
                    
                    //hierarchie - POSLOUPNOST
                    if (is_array($val)) { 
                        $actual_default = $custom_styles[0];
                        if ($custom_styles[0] == '_default' && $custom_styles[0] == '') {
                            $actual_default = $default;
                        }
                        $css .= self::generate_preset_mixin($val, $actual_default, $mixins, $type);
                        continue;
                    }
                    
                }else{
                    $custom_styles = jwOpt::getLogPresetValue('color',$typ, $option . '_color');
                }
                
                //pro danou mixinu ($mixins) vygeneruju volani pro vsechny vyskyty
                foreach ((array) $custom_styles as $id => $color_scheme) {
                    if ($color_scheme == '_default' || $color_scheme == '') {
                        $color_scheme = $default;
                    }
                    
                    
                    //Custom styly - nesouvisi s presety - napr.title page/cat
                    if (is_array($color_scheme) && sizeof($color_scheme)) {
                        $css .= PHP_EOL . ".jaw-" . $mixins . "(" . jwUtils::cutSpecials($id) . ',' . implode(',', $color_scheme) . ");" . PHP_EOL . "/* For " . $typ . '-' . $option . "*/" . PHP_EOL;
                        continue;
                    }
                    
                    //Redundance - stejny radek se nevygeneruje 2x
                    if (!empty(self::$_compress[$mixins]) && in_array($color_scheme, self::$_compress[$mixins])) {
                        $css .= "/* And the same for " . $typ . '-' . $option . "*/" . PHP_EOL;
                        continue;
                    }
                    
                    //vygenerovani volani mixiny
                    $styles = self::implodePreset(jwOpt::loadPreset($type, $color_scheme), $color_scheme);
                    if ($styles != 'error') {
                        $css .= PHP_EOL . ".jaw-" . $mixins . "(" . $styles . ");" . PHP_EOL . "/* For " . $typ . '-' . $option . "*/" . PHP_EOL;
                    }
                    
                    self::$_compress[$mixins][] = $color_scheme;
                }
                
                
                if (is_array($val)) {
                    $css .= self::generate_preset_mixin($val, $color_scheme, $mixins, $type);
                }
            }
            return $css;
        }



        public static function get_inline() {
            // inline for page
            $out = '';
            $css = jwOpt::get_option('custom_css', '');
            $custom_css_desktop = jwOpt::get_option('custom_css_desktop', '');
            $custom_css_tablet = jwOpt::get_option('custom_css_tablet', '');
            $custom_css_mobile = jwOpt::get_option('custom_css_mobile', '');
            $out .= '/* Custom Styles start */'. PHP_EOL;
            $out .= $css . PHP_EOL;
            if ($custom_css_desktop != '') {
                $out .= '@media (min-width: 992px) {' . PHP_EOL;
                    $out .= $custom_css_desktop . PHP_EOL;
                $out .= '}' . PHP_EOL;
            }
            if ($custom_css_tablet != '') {
                $out .= '@media (max-width: 991px) and (min-width: 768px){' . PHP_EOL;
                    $out .= $custom_css_tablet . PHP_EOL;
                $out .= '}' . PHP_EOL;
            }
            if ($custom_css_mobile != '') {
                $out .= '@media (max-width: 767px){' . PHP_EOL;
                    $out .= $custom_css_mobile . PHP_EOL;
                $out .= '}' . PHP_EOL;
            }
            $out .= '/* Custom Styles end */'. PHP_EOL;
            return $out;
        }

        public static function hex2rgb($hex) {
            $hex = str_replace("#", "", $hex);
            
            if (strlen($hex) == 3) {
                $r = hexdec(substr($hex, 0, 1) . substr($hex, 0, 1));
                $g = hexdec(substr($hex, 1, 1) . substr($hex, 1, 1));
                $b = hexdec(substr($hex, 2, 1) . substr($hex, 2, 1));
            } else {
                $r = hexdec(substr($hex, 0, 2));
                $g = hexdec(substr($hex, 2, 2));
                $b = hexdec(substr($hex, 4, 2));
            }
            $rgb = array($r, $g, $b);
            
            return $rgb; // returns an array with the rgb values
        }

        private static function implodePreset($data, $id) {
            $out = array();
            if (!empty($data)) {
                $out[] = $id;
                $out[] = $data['background'];
                $out[] = $data['alternative_background'];
                $out[] = $data['theme1'];
                $out[] = $data['theme2'];
                $out[] = $data['theme3'];
                $out[] = $data['border'];
                $out[] = $data['text'];
                $out[] = $data['meta'];
                $out[] = $data['link'];
                $out[] = $data['hover'];
                $out[] = $data['text_link'];
                $out[] = $data['text_hover'];
                $out[] = $data['input'];
                $out[] = $data['input_bg'];
            } else {
                return 'error';
            }
            return implode(',', $out);
        }


        private static function minify( $css ) {
            // Normalize whitespace
            $css = preg_replace( '/\s+/', ' ', $css );
            
            // Remove spaces before and after comment
            $css = preg_replace( '/(\s+)(\/\*(.*?)\*\/)(\s+)/', '$2', $css );
            // Remove comment blocks, everything between /* and */, unless
            // preserved with /*! ... */ or /** ... */
            $css = preg_replace( '~/\*(?![\!|\*])(.*?)\*/~', '', $css );
            // Remove ; before }
            $css = preg_replace( '/;(?=\s*})/', '', $css );
            // Remove space after , : ; { } */ >
            $css = preg_replace( '/(,|:|;|\{|}|\*\/|>) /', '$1', $css );
            // Remove space before , ; { } ( ) >
            $css = preg_replace( '/ (,|;|\{|}|\(|\)|>)/', '$1', $css );
            // Strips leading 0 on decimal values (converts 0.5px into .5px)
            $css = preg_replace( '/(:| )0\.([0-9]+)(%|em|ex|px|in|cm|mm|pt|pc)/i', '${1}.${2}${3}', $css );
            // Strips units if value is 0 (converts 0px to 0)
            $css = preg_replace( '/(:| )(\.?)0(%|em|ex|px|in|cm|mm|pt|pc)/i', '${1}0', $css );
            // Converts all zeros value into short-hand
            $css = preg_replace( '/0 0 0 0/', '0', $css );
            // Shortern 6-character hex color codes to 3-character where possible
            $css = preg_replace( '/#([a-f0-9])\\1([a-f0-9])\\2([a-f0-9])\\3/i', '#\1\2\3', $css );
            //mediaqueries - za AND a OR musi byt mezera
            $css = preg_replace( '/(and|or)\(/i', '$1 (', $css );
            return trim( $css );
        }

    }

}