<?php

/**
 * Sidebar manager
 * 
 * @author JaW Templates <http://www.jawtemplates.com>
 * @copyright (c) 2013, CCB, spol. s r.o.
 * @version 1.0
 */
/**
 * Base info:
 * 
 * sidebar model: Id, Name, description (optional), class=id
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

if (!class_exists('jwSidebars')) {

    class jwSidebars {

        private static $sidebars = array(
            'default-sidebar' => 'Default sidebar',
            'headerwidgetarea1' => 'Header Widget Area 1',
            'headerwidgetarea2' => 'Header Widget Area 2',
            'footer1' => 'Footer 1',
            'footer2' => 'Footer 2',
            'footer3' => 'Footer 3',
            'footer4' => 'Footer 4'
        );

        public function __construct($load = null, $default = null) {           
            $load = json_decode($load);
            if (!is_null($default))
                $this->defaultSidebars($default);
            $this->loadSidebars($load);
            add_action('widgets_init', array(&$this, 'registerSidebars'));
            add_action('wp_ajax_jw_check_sidebar_action', array('jwSidebars', 'exist'));
            add_action('wp_ajax_jw_check_sidebar_action', array('jwSidebars', 'exist'));
        }

        private function loadSidebars($detault) {
            if (!empty($detault)) {
                foreach ($detault as $k => $v) {
                    self::$sidebars[$k] = $v;
                }
            }
        }

        public static function exist() {

            $nonce = $_POST['security'];
            if (!wp_verify_nonce($nonce, 'of_ajax_nonce'))
                die('Security fail, Please try to refresh the page.');

            if (isset($_POST['name'])) {
                $name = self::_getIdFromName($_POST['name']);
            }
            if (isset(self::$sidebars[$id]))
                die(1);
            else
                die(0);
        }

        public function defaultSidebars($sidebars) {
            self::$sidebars = $sidebars;
        }

        public function registerSidebars() {

            foreach (self::$sidebars as $key => $sidebar) {

                register_sidebar(array(
                    'id' => $key,
                    'name' => $sidebar,
                    'description' => '',
                    'class' => $key,
                    'before_widget' => '<article id="%1$s" class="widget %2$s">',
                    'after_widget' => '</article>',
                    'before_title' => '<div class="row section-header box"><div class="'.esc_attr(jwLayout::col_class(12)).'"><div class="section_wrapper"><div class="section_bar"><h3  class="section-name">',
                    'after_title' => '</h3></div></div></div></div>'
                ));
            }

        }

        /**
         * Update sidebars info
         * @param type array $sidebar_array
         */
        function editSidebar($sidebar_array) {
            $sidebars = update_option(SIDEBARS, $sidebar_array);
        }

        function remove() {
            $sidebars = sidebars::getAll();
            if (isset($_POST['sidebar_name'])) {
                $name = str_replace(array("\n", "\r", "\t"), '', $_POST['sidebar_name']);
                $id = sidebars::getIdFromName($name);
            } else {
                die("alert('No sidebar name')");
            }
            if (!isset($sidebars[$id])) {
                die("alert('Sidebar does not exist.')");
            }
            $row_number = $_POST['row_number'];
            unset($sidebars[$id]);
            sidebars::update($sidebars);
            $js = "
			var tbl = document.getElementById('sbg_table');
			tbl.deleteRow($row_number)

		";
            die($js);
        }

        public function getSidebarName($id) {
            if ($id == 'default')
                return null;
            if (isset($this->sidebars[$id]))
                return $this->sidebars[$id];
            else
                return null;
        }

        private static function _generateName($name) {
            
        }

        public static function render($name) {

            if (isset(self::$sidebars[$name])) {
                dynamic_sidebar($name);
            }
        }

        /**
         * Build uniq id from name
         */
        private static function _getIdFromName($name) {
            $out = $name;
            $out = preg_replace('~[^\\pL0-9_]+~u', '-', $out);
            $out = trim($url, "-");
            $out = iconv("utf-8", "us-ascii//TRANSLIT", $out);
            $out = strtolower($url);
            $out = preg_replace('~[^-a-z0-9_]+~', '', $out);
            return $out;
        }

    }

}
