<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

if (!class_exists('jwShort')) {
    
    class jwShort {
        
        public static function shortcode_contact_form($attr) {
            $shortcode = '';
            $shortcode .= '[contact-form-7 ';
            foreach ((array) $attr as $index => $val) {
                $shortcode .= ' ' . $index . '="' . apply_filters('jaw_shortcode_attribute',$val) . '" ';
            }
            $shortcode .= '] ';
            return $shortcode;
        }
        
        public static function shortcode_wysija_form($attr) {
            $shortcode = '';
            $shortcode .= '[wysija_form ';
            foreach ((array) $attr as $index => $val) {
                $shortcode .= ' ' . $index . '="' . apply_filters('jaw_shortcode_attribute',$val) . '" ';
            }
            $shortcode .= '] ';
            return $shortcode;
        }
        
        public static function shortcode_mailchimp_form($attr) {
            $shortcode = '';
            $shortcode .= '[mc4wp_form ';
            foreach ((array) $attr as $index => $val) {
                $shortcode .= ' ' . $index . '="' . apply_filters('jaw_shortcode_attribute',$val) . '" ';
            }
            $shortcode .= '] ';
            return $shortcode;
        }
        
        public static function shortcode_tabs($attr) {
            $shortcode = '';
            $shortcode .= '[jaw_tabs ';
            $title = '';
            $content = '';
            $class = 'active';
            $attr = (array) $attr;
            if (isset($attr)) {
                if (isset($attr['style'])) {
                    $shortcode .= 'style="' . apply_filters('jaw_shortcode_attribute',$attr['style']) . '" ]';
                }
                
                $attr = (array) $attr;
                if (isset($attr['tabs'])) {
                    foreach ((array) $attr['tabs'] as $i => $tab) {
                        $tab = (array) $tab;
                        if (isset($tab['title']) && isset($tab['description'])) {
                            $title .= '[jaw_tabs_title class="' . apply_filters('jaw_shortcode_attribute',$class ). '" id="' . apply_filters('jaw_shortcode_attribute',$i ). '"]' . $tab['title'] . '[/jaw_tabs_title]';
                            $content .= '[jaw_tabs_content class="' . apply_filters('jaw_shortcode_attribute',$class ). '" id="' . apply_filters('jaw_shortcode_attribute',$i) . '"]' . $tab['description'] . '[/jaw_tabs_content]';
                            $class = '';
                        }
                    }
                }
            }
            $shortcode .= '[jaw_tabs_titles]' . $title . '[/jaw_tabs_titles]';
            $shortcode .= '[jaw_tabs_contents]' . $content . '[/jaw_tabs_contents]';
            $shortcode .= '[/jaw_tabs]';
            return $shortcode;
        }
        
        public static function shortcode_accordion($attr) {
            $shortcode = '';
            $shortcode .= '[jaw_accordion]';
            $item = '';
            $first = true;
            if (isset($attr['accordion'])) {
                foreach ((array) $attr['accordion'] as $i => $tab) {
                    $tab = (array) $tab;
                    if (isset($tab['title']) && isset($tab['description'])) {
                        $class = 'collapse';
                        if ($first && isset($attr['open_first']) && $attr['open_first'] == '1') {
                            $class = 'collapse in';
                            $first = false;
                        }
                        
                        $item .= '[jaw_accordion_item class="' . apply_filters('jaw_shortcode_attribute', $class) . '" title="' . apply_filters('jaw_shortcode_attribute',$tab['title']) . '" id="' . apply_filters('jaw_shortcode_attribute',$i) . '"]' . $tab['description'] . '[/jaw_accordion_item]';
                    }
                }
            }
            $shortcode .= $item;
            $shortcode .= '[/jaw_accordion]';
            return $shortcode;
        }
        
        public static function shortcode_html_carousel($attr, $nest = 0) {
            $currentLvl = $nest;
            $shortcode = '';
            $shortcode .= '[jaw_html_carousel ';
            $list = array();
            foreach ((array) $attr as $index => $val) {
                if (is_array($val) || is_object($val)) {
                    $list = $val;
                } else {
                    $shortcode .= ' ' . $index . '="' . apply_filters('jaw_shortcode_attribute',$val) . '"';
                }
            }
            $shortcode .= '] ';
            foreach ((array) $list as $li) {
                $li = (array) $li;
                if(isset($li['item'])){
                    $shortcode .= '[jaw_html_carousel_one]';
                    $shortcode .= $li['item'];
                    $shortcode .= '[/jaw_html_carousel_one]';
                }
            }
            $shortcode .= '[/jaw_html_carousel]';
            return $shortcode;
        }
        
        
        public static function shortcode_page_content($attr) {
            $shortcode = '';
            $shortcode .= '[jaw_page_content]';
            return $shortcode;
        }
        
        public static function shortcode_list($attr) {
            $shortcode = '';
            $shortcode .= '[jaw_list ';
            $list = array();
            
            foreach ((array) $attr as $index => $val) {
                if ($index  == 'list') {
                    $list = $val;
                } else {
                    $shortcode .= ' ' . $index . '="' . apply_filters('jaw_shortcode_attribute',$val) . '"';
                }
            }
            $shortcode .= '] ';
            if (isset($list)) {
                foreach ((array) $list as $li) {
                    $li = (array) $li;
                    if(isset($li['item'])){
                        $shortcode .= '[jaw_list_item]';
                        $shortcode .= $li['item'];
                        $shortcode .= '[/jaw_list_item]';
                    }
                }
            }
            
            $shortcode .= '[/jaw_list]';
            return $shortcode;
        }
        
        public static function shortcode_list_advanced($attr, $nest = 0) {
            $currentLvl = $nest;
            $shortcode = '';
            $shortcode .= '[jaw_list-' . $currentLvl . ' ';
            $list = array();
            
            foreach ((array) $attr as $index => $val) {
                if ($index == 'advanced_list') {
                    $list = $val;
                } else {
                    $shortcode .= ' ' . $index . '="' . apply_filters('jaw_shortcode_attribute',$val) . '"';
                }
            }
            $shortcode .= '] ';
            foreach ((array) $list as $li) {
                $li = (array) $li;
                $bullet = '';
                if (isset($li['bullet'])) {
                    $bullet = ' icon="' . apply_filters('jaw_shortcode_attribute',$li['bullet']) . '" ';
                }
                if(isset($li['item'])){
                    $shortcode .= '[jaw_list_item-' . $currentLvl . ' ' . $bullet . ']';
                    $shortcode .= $li['item'];
                    // zanoreny list - zatim nefunguje @todo
                    // if (!empty($li->childs)) {
                    //     $shortcode .= self::shortcode_list_advanced($li->childs, ++$nest);
                    // }
                    $shortcode .= '[/jaw_list_item-' . $currentLvl . ']';
                }
            }
            
            $shortcode .= '[/jaw_list-' . $currentLvl . ']';
            
            return $shortcode;
        }
        
        public static function shortcode_progressbar($attr) {
            $charts = array();
            $shortcode = '';
            $shortcode .= '[jaw_progressbar ';
            if(isset($attr['chart'])){
                $charts = $attr['chart'];
                unset($attr['chart']);
            }
            foreach ((array) $attr as $index => $val) {
                $shortcode .= ' ' . $index . '="' . apply_filters('jaw_shortcode_attribute',$val) . '" ';
            }
            $shortcode .= '] ';
            foreach ((array) $charts as $chart) {
                $shortcode .= '[jaw_one_progressbar ';
                foreach ((array) $chart as $index => $c) {
                    $shortcode .= ' ' . $index . '="' . apply_filters('jaw_shortcode_attribute',$c) . '" ';
                }
                $shortcode .= ' ] ';
            }
            $shortcode .= '[/jaw_progressbar] ';
            
            return $shortcode;
        }
        
        public static function shortcode_shortcode($attr) {
            $shortcode = '';
            if (isset($attr->shortcode)) {
                $shortcode .= $attr->shortcode;
            }
            return $shortcode;
        }
        
        public static function shortcode_circle_chart($attr) {
            $shortcode = '';
            $shortcode .= '[jaw_circle_chart ';
            $item = '';
            $attr = (array) $attr;
            if (isset($attr['chart'])) {
                foreach ((array) $attr['chart'] as $i => $tab) {
                    $tab = (array) $tab;
                    if (isset($tab['color']) && isset($tab['value']) && isset($tab['title'])) {
                        $item .= '[jaw_chart_item color="' .apply_filters('jaw_shortcode_attribute', $tab['color']) . '" value="' . apply_filters('jaw_shortcode_attribute',$tab['value']) . '"  title="' . apply_filters('jaw_shortcode_attribute',$tab['title']) . '" /]';
                    }
                }
                unset($attr['chart']);
            }
            
            foreach ((array) $attr as $index => $val) {
                $shortcode .= ' ' . $index . '="' . apply_filters('jaw_shortcode_attribute',$val) . '" ';
            }
            $shortcode .= ' ]';
            $shortcode .= $item;
            $shortcode .= '[/jaw_circle_chart]';
            return $shortcode;
        }
        
        public static function shortcode_pricing_table($attr) {
            $shortcode = '';
            $shortcode .= '[jaw_pricing_table ';
            $item = '';
            $attr = (array) $attr;
            if (isset($attr['pricing_table'])) {
                foreach ((array) $attr['pricing_table'] as $i => $tab) {
                    $tab = (array) $tab;
                    $item .= '[jaw_pricing_table_item ';
                    foreach ((array) $tab as $key => $val) {
                        $shortcode .= $key . '="' . apply_filters('jaw_shortcode_attribute',$val) . '" ';
                    }
                    $item .= ' /]';
                }
                unset($attr['pricing_table']);
            }
            foreach ((array) $attr as $index => $val) {
                $shortcode .= ' ' . $index . '="' . apply_filters('jaw_shortcode_attribute',$val) . '" ';
            }
            $shortcode .= ' ]';
            $shortcode .= $item;
            $shortcode .= '[/jaw_pricing_table]';
            return $shortcode;
        }
        
        public static function shortcode_gallery($attr) {
            $shortcode = '';
            $shortcode .= '[jaw_gallery ';
            if (isset($attr['gallery'])) {
                $shortcode .= ' gallery="';
                foreach ((array) $attr['gallery'] as $img) {
                    $img = (array) $img;
                    $shortcode .= $img['id'] . ',';
                }
                $shortcode .= '"';
                unset($attr['gallery']);
            }
            
            foreach ((array) $attr as $index => $val) {
                $shortcode .= ' ' . $index . '="' . $val . '" ';
            }
            
            $shortcode .= '] ';
            return $shortcode;
        }
        
        public static function shortcode_page_sidebar($attr) {
            $shortcode = '';
            $shortcode .= '[jaw_sidebar ';
            foreach ((array) $attr as $index => $val) {
                $shortcode .= ' ' . $index . '="' . apply_filters('jaw_shortcode_attribute',$val) . '" ';
            }
            $shortcode .= ']';
            return $shortcode;
        }
        
        public static function shortcode_image($attr) {
            $shortcode = '';
            $shortcode .= '[jaw_image ';
            $content = '';
            $thngsInContent = array('custom_text', 'text_content', 'message_text');
            foreach ((array) $attr as $index => $val) {
                if (in_array($index, $thngsInContent)) {
                    $content = $val;
                    continue;
                }
                if (is_array($val) && isset($val[0])) {
                    if (is_object($val[0])) {
                        //kdyz je v shortcodu obrazek (simpleimagepicker)
                        $val = (array) $val[0];
                        if (isset($val['id'])){
                            $val = (string) $val['id'];
                        }
                    } else {
                        // napr pro kategorie
                        $val = $val[0]['id']; //  implode(',', $val); - kozoval array issue
                    }
                }
                $shortcode .= ' ' . $index . '="' . apply_filters('jaw_shortcode_attribute',$val ). '" ';
            }
            $shortcode .= ']';
            if ($content != '') {
                $shortcode .= $content;
                $shortcode .= '[/jaw_image]';
            }
            return $shortcode;
        }
         
         
        // MASHARE =====================================================
        public static function shortcode_mashshare($attr) {
            $shortcode = '';
            $shortcode .= '[mashshare   ';
            foreach ((array) $attr as $index => $val) {
                $shortcode .= ' ' . $index . '="' . apply_filters('jaw_shortcode_attribute',$val) . '" ';
            }
            $shortcode .= '] ';
            return $shortcode;
        }
        
        
        //SLIDERS========================================================
        
        public static function shortcode_slider_revolution($attr) {
            $shortcode = '';
            $shortcode .= '[rev_slider  ';
            if (isset($attr['slider'])) {
                $shortcode .= $attr['slider'];
            }
            $shortcode .= '] ';
            return $shortcode;
        }
        
        public static function shortcode_essential_grid($attr) {
            $shortcode = '';
            $shortcode .= '[ess_grid ';
            foreach ((array) $attr as $index => $val) {
                $shortcode .= ' ' . $index . '="' .apply_filters('jaw_shortcode_attribute', $val) . '" ';
            }
            $shortcode .= '] ';
            return $shortcode;
        }
        
        //VIDEO PLAYER PLUGIN
        public static function shortcode_video_playlist($attr) {
            $shortcode = '';
            $shortcode .= '[videogallery ';
            if(isset($attr["id"])) {
                $shortcode .= ' id="' .apply_filters('jaw_shortcode_attribute', $attr["id"]) . '" ';
            }
            $shortcode .= '] ';
            return $shortcode;
        }
        
        //jaw grid
        public static function shortcode_grid($attr) {
            $shortcode = '';
            $shortcode .= '[jaw_grid ';
            $content = '';
            foreach ((array) $attr as $index => $val) {
                if (is_object($val)) {
                    //pokud jde o custom content
                    foreach ((array) $val as $i => $gridItem) {
                        $content .= '[jaw_grid_item ';
                        if (isset($gridItem->img[0]->id)){
                            $content .= 'img="' . $gridItem->img[0]->id . '" ';
                        }
                        if (isset($gridItem->link)){
                            $content .= 'link="' . $gridItem->link . '" ';
                        }
                        if (isset($gridItem->title)){
                            $content .= 'title="' . $gridItem->title . '" ';
                        }
                        $content .= ']';
                        if (isset($gridItem->content)){
                            $content .= $gridItem->content;
                        }
                        $content .= '[/jaw_grid_item]';
                    }
                    continue;
                }else if(is_array($val)){
                    //kategorie
                    $val = implode(',', $val);
                }
                $shortcode .= ' ' . $index . '="' . $val . '" ';
            }
            $shortcode .= ']';
            if ($content != '') {
                $shortcode .= $content;
            }
            $shortcode .= '[/jaw_grid]';
            return $shortcode;
        }
        
        //jaw google map waypoint
        public static function shortcode_google_map($attr) {
            $shortcode = '';
            $shortcode .= '[jaw_google_map ';
            $content = '';
            foreach ((array) $attr as $index => $val) {
                if (is_object($val)) {
                    if($index == "waypoints") {
                        foreach ((array) $val as $i => $gridItem) {
                            $content .= '[jaw_google_map_waypoint ';
                            if (isset($gridItem->latitude)){
                                $content .= 'latitude="' . $gridItem->latitude . '" ';
                            }
                            if (isset($gridItem->longitude)){
                                $content .= 'longitude="' . $gridItem->longitude . '" ';
                            }
                            $content .= ']';
                        }
                    } else {
                        foreach ((array) $val as $i => $gridItem) {
                            $content .= '[jaw_google_map_marker ';
                            if (isset($gridItem->latitude)){
                                $content .= 'latitude="' . $gridItem->latitude . '" ';
                            }
                            if (isset($gridItem->longitude)){
                                $content .= 'longitude="' . $gridItem->longitude . '" ';
                            }
                            if (isset($gridItem->descriptionopen)){
                                $content .= 'descriptionopen="' . $gridItem->descriptionopen . '" ';
                            }
                            $content .= ']';
                            if (isset($gridItem->description_marker)){
                                $content .= $gridItem->description_marker;
                            }
                            $content .= '[/jaw_google_map_marker]';
                        }
                    }                    
                    continue;
                }else if(is_array($val)){
                    //kategorie
                    $val = implode(',', $val);
                }
                $shortcode .= ' ' . $index . '="' . $val . '" ';
            }
            $shortcode .= ']';
            if ($content != '') {
                $shortcode .= $content;
            }
            $shortcode .= '[/jaw_google_map]';
            return $shortcode;
        }
        
        //WooCommerce========================================================
        public static function shortcode_woo_product_categories($attr) {
            $shortcode = '';
            $shortcode .= '[product_categories   ';
            foreach ((array) $attr as $index => $val) {
                if (is_array($val)) {
                    $val = implode(',', $val);
                }
                $shortcode .= ' ' . $index . '="' . apply_filters('jaw_shortcode_attribute',$val ). '" ';
            }
            $shortcode .= '] ';
            return $shortcode;
        }
        
        public static function shortcode_woo_featured_products_big($attr) {
            $shortcode = '';
            $shortcode .= '[featured_products   ';
            foreach ((array) $attr as $index => $val) {
                $shortcode .= ' ' . $index . '="' . apply_filters('jaw_shortcode_attribute',$val) . '" ';
            }
            $shortcode .= '] ';
            return $shortcode;
        }
        
        public static function shortcode_woo_featured_products_small($attr) {
            $shortcode = self::shortcode_woo_featured_products_big($attr);
            return $shortcode;
        }
        
        public static function shortcode_woo_product_by_category_big($attr) {
            $shortcode = '';
            $shortcode .= '[product_category  ';
            
            foreach ((array) $attr as $index => $val) {
                if (is_array($val)) {
                    $val = implode(',', $val);
                }
                $shortcode .= ' ' . $index . '="' . apply_filters('jaw_shortcode_attribute',$val) . '" ';
            }
            $shortcode .= '] ';
            return $shortcode;
        }
        
        public static function shortcode_woo_product_by_category_small($attr) {
            $shortcode = self::shortcode_woo_product_by_category_big($attr);
            return $shortcode;
        }
        
        public static function shortcode_woo_products_by_big($attr) {
            $shortcode = '';
            $shortcode .= '[products   ';
            foreach ((array) $attr as $index => $val) {
                if (is_array($val)) {
                    $val = implode(',', $val);
                }
                if ($val != '') {
                    $shortcode .= ' ' . $index . '="' .apply_filters('jaw_shortcode_attribute', $val) . '" ';
                }
            }
            $shortcode .= '] ';
            return $shortcode;
        }
        
        public static function shortcode_woo_products_by_small($attr) {
            $shortcode = self::shortcode_woo_products_by_big($attr);
            return $shortcode;
        }
        
        public static function shortcode_woo_recent_product_big($attr) {
            $shortcode = '';
            $shortcode .= '[recent_products ';
            foreach ((array) $attr as $index => $val) {
                $shortcode .= ' ' . $index . '="' . apply_filters('jaw_shortcode_attribute',$val ). '" ';
            }
            $shortcode .= '] ';
            return $shortcode;
        }
        
        public static function shortcode_woo_recent_product_small($attr) {
            $shortcode = self::shortcode_woo_recent_product_big($attr);
            return $shortcode;
        }
        
        public static function shortcode_woo_product_button($attr) {
            $shortcode = '';
            $shortcode .= '[add_to_cart ';
            foreach ((array) $attr as $index => $val) {
                $shortcode .= ' ' . $index . '="' .apply_filters('jaw_shortcode_attribute', $val) . '" ';
            }
            $shortcode .= '] ';
            return $shortcode;
        }
        
        public static function shortcode_woo_order_tracking($attr) {
            $shortcode = '[woocommerce_order_tracking]';
            return $shortcode;
        }
        
        public static function shortcode_woo_wishlist($attr) {
            $shortcode = '[yith_wcwl_wishlist]';
            return $shortcode;
        }
        
        public static function shortcode_woo_messages($attr) {
            $shortcode = '[woocommerce_messages]';
            return $shortcode;
        }
        
        public static function shortcode_woo_page($attr) {
            $shortcode = '';
            if (isset($attr['page'])) {
                $shortcode .= '[woocommerce_' . $attr['page'] . ']';
            }
            return $shortcode;
        }
        
        //DEFAULT========================================================
        public static function shortcode_default($name, $attr) {
            $shortcode = '';
            $shortcode .= '[' . $name . ' ';
            $content = '';
            $thngsInContent = array('custom_text', 'text_content', 'message_text');
            foreach ((array) $attr as $index => $val) {
                if (in_array($index, $thngsInContent)) {
                    $content = $val;
                    continue;
                }
                if (is_array($val) && isset($val[0])) {
                    if (is_object($val[0]) || is_array($val[0])) { //v revoComporeru je to object v shortcode generatoru array - zrejme diky AJAXu
                        //kdyz je v shortcodu obrazek (simpleimagepicker)
                        $val = (array) $val[0];
                        if (isset($val['id'])){ 
                            $val = (string) $val['id'];
                        }
                    } else {
                        // napr pro kategorie
                        $val = implode(',', $val);
                    }
                }else if(is_array($val) || is_object($val)){
                    //v revoComporeru je to object v shortcode generatoru array - zrejme diky AJAXu
                    //list (playlist youtube ...)
                    $list = array();
                    foreach((array) $val as $id => $value){
                        $value = (array) $value;
                        if(isset($value['item'])){
                            $list[] = $value['item'];
                        }
                    }
                    $val = implode(',', $list);
                }
                $shortcode .= ' ' . $index . '="' . apply_filters('jaw_shortcode_attribute',$val ). '" ';
            }
            $shortcode .= ']';
            if ($content != '') {
                $shortcode .= $content;
                $shortcode .= '[/' . $name . ']';
            }
            return $shortcode;
        }
        
    }
    
}