<?php
/**
 * This is main themplate builder class. This class render item of theme.
 * @author JaW Templates <http://www.jawtemplates.com>
 * @copyright (c) 2013, CCB, spol. s r.o.
 * @version 1.0
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

if (!class_exists('jwRender')) {

    class jwRender {

        /**
         * metaRating
         * @since 1.0
         *
         * @return string nabufferovany obsah hodnoceni.
         */
        public static function metaRating() {
            if(!class_exists('ratingManager')){
                return '';
            }
            $ratingManager = ratingManager::getInstance();
            $ratings = $ratingManager->getRatings(get_the_ID());
            $totalrat = $ratingManager->getRatingsScore($ratings);
            $ratingtype=jwOpt::get_option('rating_maximal_value');
            $ratingsCount = 0;
            $ratingmaxvalue=jwOpt::get_option('rating_maximal_value_show'); // error u timeliny
            $final_round="";
             foreach ($ratings as $oneRating) {
                 if ($oneRating->useredit != "1") {
                     $ratingsCount++;
                    $one_round="";
                    switch($ratingtype) {
                        case "100" :
                                $one_round = esc_attr(round($oneRating->finalScore, 0)).'<span>%</span>';
                        break;
                        default:
                                $one_round = esc_attr(round($oneRating->finalScore, 1));

                        break;
                    }
                 }
             }
            if ($ratingsCount > 0) {
                switch($ratingtype) {
                    case "100" :
                            $final_round = esc_attr(round($totalrat['final'], 0)).'<span>%</span>';
                    break;
                    default:
                        if($ratingmaxvalue) {
                            $final_round = esc_attr(round($totalrat['final'], 1)).'<span>/'.$ratingtype.'</span>';
                        } else {
                            $final_round = esc_attr(round($totalrat['final'], 1));
                        }
                    break;
                }
            }
            if ($totalrat['final'] > 0 && get_post_meta(get_the_ID(), 'fw_rating_position', true)) {
                return '<li class="post-meta-rating rating"><span class="rating-icon"><i class="jaw-icon-star3"></i></span>' . $final_round .'</li>';
            }
        }

        /**
         * metaReaders
         * @since 1.0
         *
         * @return string nabufferovany obsah hodnoceni.
         */
        public static function metaReaders() {
            $out = '';
            $out .= '<i class="jaw-icon-eye-trans1"></i>';
            $out .= jwUtils::get_readers_count(get_the_ID());
            return $out;
        }

        public static function metaLastComment(){
            $out = '';
            $comment = get_approved_comments(get_the_ID(),array('number' => 1, 'order' => 'DESC'));
            if(isset($comment[0]->comment_ID)){
               $out = comment_date(get_option( 'date_format' ),$comment[0]->comment_ID);
            }
            return $out;
        }


        public static function get_likes() {
            $terms = get_the_category();
            if (isset($terms[0]->term_id)) {
                $term_id = $terms[0]->term_id;
            } else {
                $term_id = 0;
            }
            $out = '';
            $use_likes = jwOpt::get_option('post_use_user_likes', '1');
            if ($use_likes == '1') {
                $ratings = maybe_unserialize(get_post_meta(get_the_ID(), 'jaw_rating', TRUE));
                $out .= '<li class="post-meta-likes">';
                if (isset($ratings['user'])) {
                    $user_rating = $ratings;
                } else {
                    $user_rating = jwLikes::getUserDefault('user');
                }
                $rating_value = 0;
                if (isset($user_rating['user']['weight'])) {
                    $rating_value = $user_rating['user']['weight'];
                }
                $out .= '<span class="jaw-like user_editable">';
                $out .= '<input type="hidden" class="jw_post_id" value="' . get_the_ID() . '" />';
                $out .= '<input type="hidden" class="jw_rating_type" value="user" />';
                $out .= '<input type="hidden" class="jw_rating_name" value="user" />';
                $out .= '<i class="jaw-icon-heart-on2 voted"></i>';
                $out .= '<i class="jaw-icon-heart-off2 non-voted"></i>';
                $out .= '<span class="rating_score">' . $rating_value . '</span>';
                $out .= '</span>';
                $out .= '</li>';
            }
            return $out;
        }

        /**
         * get_meta_date
         *
         * Vraci datum, kdy byl post vytvoren.
         * Datum nacita podle formatu, ktere je v themeoptionsu
         *
         * @since 1.0
         *
         * @return string datum.
         */
        public static function get_meta_date($post_id = NULL) {
            echo get_the_date('', $post_id);
        }

        /**
         * get_meta_image_size
         *
         * Vraci sirku a delku attachmentu
         * Nacte pole attachmentu podle jeho ID
         *
         * @since 1.0
         *
         * @return string Velikost.
         */
        public static function get_meta_image_size($ID) {
            $size = wp_get_attachment_metadata($ID);
            $out = "";
            if(is_array($size) && isset($size['width']) && isset($size['height'])) {
                $out = '<i class="jaw-icon-expand"></i>'.esc_attr($size['width']).'x'.esc_attr($size['height']);
                return $out;
            } else {
                return;
            }
        }

        /**
         * get_meta_author
         *
         * Vraci autora postu. Obsahuje i link na autora.
         *
         * @since 1.0
         *
         * @return string autora.
         */
        public static function get_meta_author() {
            $autor_link = get_author_posts_url(get_the_author_meta('ID'));
            $autor_name = get_the_author();
            return '<a href="' . $autor_link . '" ><i class="jaw-icon-author"></i>' . esc_html($autor_name) . '</a>';
        }

        /**
         * get_meta_comments
         *
         * Vraci pocet a link na komentare k danemu postu.
         *
         * @since 1.0
         *
         * @return string link a pocet komentaru.
         */
        public static function get_meta_comments($id="") {
            if(empty($id)) {
                $id = get_the_ID();
            }
            if (defined('DISQUS_DOMAIN') && get_option('disqus_active')) {
                return '<i class="jaw-icon-comment"></i><span class="disqus-comment-count" data-disqus-url="' . get_permalink($id) . '">' . esc_html__('0 Comments', "gdn-theme") . '</span>';
            } elseif (jwOpt::get_option('fbcomments_switch', '0') == '0') {
                return '<a href="' . get_permalink($id) . '#comments"><i class="jaw-icon-comment"></i><span>' . get_comments_number($id) . '</span><span class="jaw-comm-slim">' . esc_html__(' comments ', "gdn-theme") . '</span></a>';
            } else {
                return '<a href="' . get_permalink($id) . '" ><i class="jaw-icon-comment"></i><span class="fb-comments-count"></span><span class="jaw-comm-slim">' . esc_html__(' comments ', "gdn-theme") . '</span></a>';
            }
        }

        /**
         * get_meta_category
         *
         * Vraci kategorie ve kterych je post vlozen.
         *
         * @since 1.0
         *
         * @return string linky na kategorie.
         */
        public static function get_meta_category($id="") {
            if(empty($id)) {
                $terms = get_the_category();
            } else {
                $terms = get_the_category($id);
            }
            $terms = apply_filters( 'jaw_meta_categories', $terms );
            $cats = array();
            if (count($terms) > 0) {
                foreach ($terms as $term) {
                    $cats[] = '<a href="' . get_category_link($term->term_id) . '"  class="category-preset-' . jwOpt::checkDefaultPreset(array(jwOpt::get_option('content_color', '_default', 'category', $term->term_id), jwOpt::get_option('main_color', '')),'color') . '" >' . $term->name . '</a>';
                }
            }
            return implode('', $cats);
        }


        /**
         * pagination
         *
         * Vypisuje strankovani postu.
         *
         * @since 1.0
         *
         * @return string html se strankovanim.
         */
        public static function pagination($styl = 'number', $query = null, $mid_size = 3) {
            $out = '';
            global $wp_query, $paged;
            if (!isset($query)) {
                $query = $wp_query;
            }

            $paged = $query->query_vars['paged'];
            $maxpages = $query->max_num_pages;
            if ($maxpages == 0) {
                $out .= '<div id="infinite_load_' . jaw_template_get_counter('pagination') . '" class="row pagination ' . $styl . '"> ';
                $out .= '<div id="no-additional-posts" style="display: none;"><div style="opacity: 1;"><div class="text">' . esc_html__('No additional posts.', "gdn-theme") . '</div></div></div> ';
                $out .= '<div class="infinite_load_arrow"></div>';
                $out .= '</div>';
            } else if ($maxpages > 1) {
                $infinity_script = '
                    var infinite_scroll = infinite_scroll || new Array();
                    infinite_scroll.push({
                        nextSelector: "#infinite_load_' . jaw_template_get_counter('pagination') . ' #post-nav-infinite .post-previous-infinite a",
                        navSelector: "#infinite_load_' . jaw_template_get_counter('pagination') . ' #post-nav-infinite",
                        itemSelector: ".jaw_paginated_' . jaw_template_get_counter('pagination') . ' .element",
                        contentSelector: ".jaw_paginated_' . jaw_template_get_counter('pagination') . '",
                        debug        : false,
                        id: ' . jaw_template_get_counter('pagination') . ',
                        appendCallback	: true,
                        type: "' . $styl . '",
                        loading : {
				                msgText         : "<div class=\'animation\'><div id=\'circleG\'><div id=\'circleG_1\' class=\'circleG\'></div><div id=\'circleG_2\' class=\'circleG\'></div><div id=\'circleG_3\' class=\'circleG\'></div></div></div>",
                                finishedMsg     : "<div class=\'text\'>' . esc_html__('No additional posts.', "gdn-theme") . '</div>",
				                img             : null,
                                speed           : 0,
                                selector        : "#infinite_load_' . jaw_template_get_counter('pagination') . '"
                        },
                        animate      : true

                    });

                   ';

                $out .= '<div id="infinite_load_' . esc_attr(jaw_template_get_counter('pagination')) . '" class="row pagination ' . esc_attr($styl) . '"> ';
                wp_reset_query();
                // ========= NUMBER PAGINATION ===========================================
                if ($styl == 'number') {

                    $big = 999999999; // This needs to be an unlikely integer
                    // For more options and info view the docs for paginate_links()
                    // http://codex.wordpress.org/Function_Reference/paginate_links
                    $paginate_links = paginate_links(array(
                        'base' => str_replace($big, '%#%', get_pagenum_link($big)),
                        'current' => max(1, $paged),
                        'total' => $query->max_num_pages,
                        'mid_size' => $mid_size,
                        'prev_next' => True,
                        'prev_text' => '<i class="jaw-icon-arrow-slide-left"></i>',
                        'next_text' => '<i class="jaw-icon-arrow-slide-right"></i>',
                        'type' => 'list'
                    ));
                    // Display the pagination if more than one page is found
                    if ($paginate_links) {
                        $out .= '<div class="template-pagination">';
                        $out .= $paginate_links;
                        $out .= '</div><!--// end .pagination -->';
                    }
                    $out .= '</div>'; //konec infinite_load
                    // ========= WORDPRESS PAGINATION ===========================================
                } else if ($styl == 'wordpress') {
                    $out .= '<div id="post-nav" class="wordpress">';
                    if ($paged <= $maxpages) {
                       $out .= '<div class="post-previous">' . get_previous_posts_link('<i class="jaw-icon-arrow-slide-left"></i>' .esc_html__("Previous", "gdn-theme"), 99999) . '</div>';
                    }
                    if($paged != $maxpages) {
                        $out .= '<div class="post-next">' . get_next_posts_link( esc_html__("Next", "gdn-theme") . '<i class="jaw-icon-arrow-slide-right"></i>', 99999) . '</div>';
                    }
                    $out .= '<div class="clear"></div>';
                    $out .= '</div>';
                    $out .= '</div>';
                    // ========= INFINITY LIST ===========================================
                } else if ($styl == 'infinite') {
                    $out .= '<div id="post-nav-infinite">';
                    $out .= '<div class="post-previous-infinite" >';
                    $out .= get_next_posts_link(esc_html__("NEXT", "gdn-theme"), 99999);
                    $out .= '</div>';
                    $out .= '<div class="post-next-infinite">';
                    $out .= get_previous_posts_link(esc_html__("PREVIOUS", "gdn-theme"), 99999);
                    $out .= '</div>';
                    $out .= '</div>';
                    $out .= '</div>'; //konec infinite_load
                    $out .= '<script>
                    ' . $infinity_script . '
                         var type = "infinite";
                    </script>';
                    // ========= AJAX LIST ===========================================
                } else if ($styl == 'ajax') {
                    $out .= '<div id="post-nav-infinite">';
                    if ($paged < $maxpages) {
                        $out .= '<div class="post-previous-infinite" >';
                        $out .= get_next_posts_link(esc_html__(" Older posts", "gdn-theme"), 99999);
                        $out .= '</div>';
                    }
                    $out .= '<div class="post-next-infinite">';
                    $out .= get_previous_posts_link(esc_html__("Newer posts", "gdn-theme"), 99999);
                    $out .= '</div>';
                    $out .= '</div>';
                    $out .= '</div>'; //konec infinite_load
                    $out .= '<script>
                   ' . $infinity_script . '
                    var type = "ajax";
                    </script>';
                    // ========= INFINITY MORE LIST ===========================================
                } else if ($styl == 'infinitemore') {
                    $out .= '<div id="post-nav-infinite">';
                    $out .= '<div class="post-previous-infinite" >';
                    $out .= get_next_posts_link(esc_html__("Older posts", "gdn-theme"), 99999);
                    $out .= '</div>';
                    $out .= '<div class="post-next-infinite">';
                    $out .= get_previous_posts_link(esc_html__("Newer posts", "gdn-theme"), 99999);
                    $out .= '</div>';
                    $out .= '</div>';
                    $out .= '</div>'; //konec infinite_load
                    $out .= '<script>
                    ' . $infinity_script . '
                    var type = "infinitemore";
                    var more = "' . "<div class='morebutton'><div class='text'>" . esc_html__('More', 'gdn-theme') . "<i class='jaw-icon-arrow-slide-down'></i></div></div>" . '";
                    </script>';
                    $out .= '<div class="infinite_load_arrow"></div>';
                } else if ($styl == 'none') {
                    $out .= '</div>'; //konec infinite_load
                }
            }
            return $out;
        }

        public static function get_related_post($id,$numberOfPosts = 4) {

            global $post;

            $orig_post = $post;
            $tagargs = $catargs = '';
            $catnames = '';
            $tagnames = array();
            $tags = get_the_tags($id);

            if ($tags) {
                foreach ($tags as $tag) {
                    $tagnames[] = $tag->name;
                }
                $tagargs = array(
                    'ignore_sticky_posts' => 1,
                    'tag' => implode(',', $tagnames),
                    'post__not_in' => array($id),
                    'posts_per_page' => $numberOfPosts,
                    'orderby' => 'date'
                );
            }


            $post_cats = wp_get_post_categories($id);

            $catargs = array(
                'ignore_sticky_posts' => 1,
                'cat' => implode(',', $post_cats),
                'post__not_in' => array($id),
                'posts_per_page' => $numberOfPosts,
                'orderby' => 'date'
            );

            $catargs = apply_filters( 'jaw_related_posts_query_cats', $catargs );
            $tagargs = apply_filters( 'jaw_related_posts_query_tags', $tagargs );

            if(jwOpt::get_option('related_post_primary_source', 'cats') == 'cats'){
                return array($catargs, $tagargs);
            }else{
                return array($tagargs, $catargs);
            }
        }

        /**
        * @name         get_banner 
        * @description  vyprintuje Banner
        **/
        public static function get_banner($type,$width = 12) {
                if (jwOpt::get_option('banner_' . $type . '_show', 'off') == 'image') {
                    $banner_link = jwOpt::get_option('banner_' . $type . '_link', '#');
                    $image = jwOpt::get_option('banner_' . $type . '_image', '');
                    $show_on = 'show-on-'.jwOpt::get_option('banner_' . $type . '_show_on_devices', 'phone');
                    if ($image != '') {
                        if (strlen($banner_link) <= 0 || $banner_link == 'http://' || $banner_link == 'https://') {
                            ?>
                            <div class="jaw-banner jaw-banner-type-img <?php echo esc_attr('jaw-banner-' . $type); ?> <?php echo esc_attr(jwLayout::col_class($width) . ' ' . $show_on); ?>">
                                <a href="#">
                                    <img src="<?php echo esc_url(jwOpt::get_option('banner_' . $type . '_image', '')); ?>">
                                </a>
                            </div>
                        <?php } else { ?>
                            <div class="jaw-banner jaw-banner-type-img <?php echo esc_attr('jaw-banner-' . $type); ?> <?php echo esc_attr(jwLayout::col_class($width) . ' ' . $show_on); ?>">
                                <a href="<?php echo esc_url(jwOpt::get_option('banner_' . $type . '_link', '#')); ?>"  target="<?php echo esc_attr(jwOpt::get_option('banner_' . $type . '_link_target', '_blank')); ?>">
                                    <img src="<?php echo esc_url(jwOpt::get_option('banner_' . $type . '_image', '')); ?>">
                                </a>
                            </div>
                            <?php
                        }
                    }
                } else if (jwOpt::get_option('banner_' . $type . '_show', 'off') == 'google'){
                    $google_ads = jwOpt::get_option('banner_' . $type . '_google', '#');
                    if (strlen($google_ads) > 0) {
                        ?>
                        <div class="jaw-banner jaw-banner-type-google <?php echo esc_attr( 'jaw-banner-' . $type); ?> <?php echo esc_attr(jwLayout::col_class($width)); ?>">
                            <div class="google_ads">
                                <?php echo do_shortcode($google_ads); ?>
                            </div>
                        </div>
                        <?php
                    }
                }
        }


        public static function postboxTitle($format){
            switch($format){
                case 'link': 
                    echo jaw_get_template_part('title-link', array('content', 'parts'));
                    break;
                default: 
                    echo jaw_get_template_part('title', array('content', 'parts'));
                    break;
            }
        }
        public static function postboxExcerpt($format){
            switch($format){
                case 'link': //do nothing 
                    break;
                case 'quote': 
                    echo jaw_get_template_part('quote-author', array('content', 'parts'));
                    break;
                default: 
                    echo jaw_get_template_part('excerpt', array('content', 'parts'));
                    break;
            }
        }
        public static function postboxMeta($format){
            echo jaw_get_template_part('meta', 'meta');
        }

    }
}
