<?php
/**
 * Description of theme admin panel
 * @author JaW Templates <http://www.jawtemplates.com>
 * @copyright (c) 2013, CCB, spol. s r.o.
 * @version 1.0
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

if (!class_exists('jwPanel')) {

    class jwPanel {

        public static $menu = null;
        public static $hooks = array();
        private $load = array('admin');  // admin,admin_options,frontend,

        function __construct() {
            //  
            add_action('admin_menu', array(&$this, 'registerpage'));
            add_action('wp_dashboard_setup', array(&$this, 'jaw_add_dashboard_widgets'));
            //AJAX              
            add_action('wp_ajax_jaw_changelog', array(&$this, 'jaw_changelog'));
            add_action('wp_ajax_jaw_checker', array(&$this, 'jaw_checker'));
            add_action('wp_ajax_jaw_category_preset_editor', array(&$this, 'jaw_category_preset_editor'));
            add_action('wp_ajax_jaw_single_preset_editor', array(&$this, 'jaw_single_preset_editor'));
            add_action('wp_ajax_jaw_export_preset', array(&$this, 'jaw_export_preset'));
            add_action('wp_ajax_jaw_color_preset_editor', array(&$this, 'jaw_color_preset_editor'));
            add_action('wp_ajax_jaw_preset_log', array(&$this, 'jaw_preset_log'));
            add_action('wp_ajax_jaw_check_preset', array(&$this, 'jaw_check_preset'));
            add_action('wp_ajax_jaw_check_changes', array(&$this, 'jaw_check_changes'));
            // 
            add_action('wp_ajax_jaw_ajax_action', array(&$this, 'ajax_callback'));
        }

        //DASHBOARD WIDGET
        public function jaw_add_dashboard_widgets() {

            wp_add_dashboard_widget(
                    'jaw_dashboard_widget', // Widget slug.
                    '<i class="jaw-icon-support"></i> J&W Support Center', // Title.
                    array($this, 'jaw_dashboard_widget_function') // Display function.
            );
        }

        //Dashboard widget content
        public function jaw_dashboard_widget_function() {

            // Display whatever it is you want to show.
            echo "<div class='jw-support-widget'>";
            echo "<div>If you need to help with any issue, please feel free to contact us.</div>";
            echo "<br>";
            echo "<img src='" . JAW_ADMIN_URI . "assets/images/logo-jawtemplates.png'>";
            echo "<ul>";
            echo "<li><a href='" . "http://support.jawtemplates.com/goodstore/documentation/" . "' target='_blank'>Documentation</a></li>";
            echo "<li><a href='http://support.jawtemplates.com' target='_blank'>Support forum</a></li>";
            echo "<li><a href='http://support.jawtemplates.com/goodstore/web/' target='_blank'>Knowledge base</a></li>";
            echo "</ul>";
            echo "<div class='clear'></div>";
            echo "</div>";
        }

        public static function menuAndHooks() {
            $menu = '';
            $hooks = array();
            $submenu = false;

            foreach (jwOpt::getPanelMenu() as $key => $value) {
                $hooks[] = $key;

                $href = '#of-option-' . $key;
                $target = '';
                if (isset($value['link'])) {
                    $href = $value['link'];
                    $target = ' target="_blank" ';
                }
                $icon = '';
                if (isset($value['icon'])) {
                    $icon = '<i class="' . $value['icon'] . '"></i>';
                }

                if (($value['submenu'] == 0 && $submenu == false)) {
                    $menu .= '<li rel="' . $key . '" class="' . $key . '"><a title="' . $value['name'] . '" ' . $target . ' href="' . $href . '">' . $icon . $value['name'] . '</a></li>';
                } else if (($value['submenu'] == 1 && $submenu == true)) {
                    $menu .= '<li rel="' . $key . '" class="child ' . $key . '"><a title="' . $value['name'] . '" ' . $target . ' href="' . $href . '">' . $icon . $value['name'] . '</a></li>';
                } elseif ($value['submenu'] == 1 && $submenu == false) { // begin
                    $menu .= '<li rel="' . $key . '" class="parent ' . $key . '">
                     <a title="' . $value['name'] . '" ' . $target . '  href="">' . $icon . $value['name'] . '</a>';
                    $menu .='<ul class="submenu" style="display:none;">';
                    $submenu = true;
                } elseif ($value['submenu'] == -1 && $submenu == true) { // end
                    $menu .= '<li rel="' . $key . '" class="child ' . $key . '"><a title="' . $value['name'] . '" ' . $target . ' href="' . $href . '">' . $icon . $value['name'] . '</a></li>';
                    $menu .='</ul>';
                    $menu .='</li>';
                    $submenu = false;
                }
            }

            if ($submenu == true)
                $menu .='</ul></li>';


            self::$menu = $menu;
            self::$hooks = $hooks;
        }

        /**
         * Forces insert into post
         */
        public function force_send($args) {
            $args['send'] = true;
            return $args;
        }

        /**
         * Adds the Thickbox CSS file and specific loading and button images to the header
         * on the pages where this function is called.
         */
        function mlu_css() {

            $_html = '';
            $_html .= '<link rel="stylesheet" href="' . get_option('siteurl') . '/' . WPINC . '/js/thickbox/thickbox.css" type="text/css" media="screen" />' . "\n";
            $_html .= '<script type="text/javascript">
		var tb_pathToImage = "' . get_option('siteurl') . '/' . WPINC . '/js/thickbox/loadingAnimation.gif";
	    var tb_closeImage = "' . get_option('siteurl') . '/' . WPINC . '/js/thickbox/tb-close.png";
	    </script>' . "\n";

            echo $_html;
        }

        // register admin page to wp menu
        public function registerPage() {
            require JAW_ADMIN_DIR . 'options/tips.php';
            //ENVATO nechce add_menu_page ale chce add_theme_page | add_options_page
            add_theme_page(JAW_THEMENAME, 'Theme Options', 'edit_theme_options', 'optionsframework', array(&$this, 'renderAdminPage'));
            //add_menu_page(JAW_THEMENAME, 'Theme Options', 'manage_options', 'optionsframework', array($this, 'renderAdminPage'), 'none', 3);     
        }

        //todo
        public static function ajax_callback() {
            
            if(isset($_POST['security'])){
                $nonce = $_POST['security'];
            }

            if (!wp_verify_nonce($nonce, 'of_ajax_nonce'))
                die('Security fail, Please try to refresh the page.');
                
            if(!current_user_can( 'edit_theme_options' )){
                die('Security fail, Please try to refresh the page.');
            }

            //get options array from db
            $all = jwOpt::get_options();

            $save_type = $_POST['type'];

            //Uploads
            switch ($save_type) {
                case 'upload':
                    $clickedID = $_POST['data']; // Acts as the name
                    $filename = $_FILES[$clickedID];
                    $filename['name'] = preg_replace('/[^a-zA-Z0-9._\-]/', '', $filename['name']);

                    $override['test_form'] = false;
                    $override['action'] = 'wp_handle_upload';
                    $uploaded_file = wp_handle_upload($filename, $override);

                    $upload_tracking[] = $clickedID;
		  
                    $upload_image = $all; //preserve current data
                    if(isset($uploaded_file['url'])){
                        $upload_image[$clickedID] = $uploaded_file['url'];
                    }
                    if (!empty($uploaded_file['error'])) {
                        die('Upload Error: ' . $uploaded_file['error']);
                    } else {
                        die($uploaded_file['url']);
                    } // Is the Response
                    break;

                case 'image_reset':
                    $id = $_POST['data']; // Acts as the name
                    $delete_image = $all; //preserve rest of data
                    $delete_image[$id] = ''; //update array key with empty value	 
                    break;

                case 'backup_options':
                    jwOpt::update_backups();
                    die('1');
                    break;

                case 'restore_options':
                    $data = jwOpt::get_backup(JAW_OPTIONS, $_POST['name']);
                    jwOpt::update_option($data);
                    $data = jwOpt::get_backup(JAW_CATEGORIES, $_POST['name']);
                    jwOpt::update_option($data, "category");
                    
                    $data = json_encode(jwOpt::get_backup('jaw_category_preset', $_POST['name']));
                    jwOpt::savePreset($data, "category");
                    $data = json_encode(jwOpt::get_backup('jaw_single_preset', $_POST['name']));
                    jwOpt::savePreset($data, "single");
                    $data = json_encode(jwOpt::get_backup('jaw_color_preset', $_POST['name']));
                    jwOpt::savePreset($data, "color");
                    $data = json_encode(jwOpt::get_backup('jaw_revo_preset', $_POST['name']));
                    jwOpt::savePreset($data, "revo");
                    $data = json_encode(jwOpt::get_backup('jaw_revoelement_preset', $_POST['name']));
                    jwOpt::savePreset($data, "revoelement");
                    // vymaze nacachovane linkovani fontu
                    delete_transient( JAW_THEMESLUG.'_g_fonts' );
                    do_action('jaw_generate_styles', 'color');
                    die('1');
                    break;

                case 'import_options':
                    $data = $_POST['data'];
                    $target = $_POST['target'];
                    $data = unserialize(jwUtils::jaw_base64_dec($data)); //100% safe - ignore theme check nag
                    jwOpt::update_option($data, $target);
                    // vymaze nacachovane linkovani fontu
                    delete_transient( JAW_THEMESLUG.'_g_fonts' );
                    do_action('jaw_generate_styles', 'color');
                    die('1');
                    break;
                    
                case 'import_all':
                    $data = $_POST['data'];
                    $target = $_POST['target'];
                    $data = unserialize(jwUtils::jaw_base64_dec($data)); //100% safe - ignore theme check nag
                    if(isset($data['category'])){
                        jwOpt::update_option($data['category'],'category');
                    }
                    if(isset($data['jaw-menu-location'])){
                        update_option('jaw-menu-location',$data['jaw-menu-location']);
                    }
                    if(isset($data['category_preset'])){
                        jwOpt::savePreset(json_encode((array) $data['category_preset']), "category");
                    }
                    if(isset($data['single_preset'])){
                        jwOpt::savePreset(json_encode((array) $data['single_preset']), "single");
                    }
                    if(isset($data['color_preset'])){
                        jwOpt::savePreset(json_encode((array) $data['color_preset']), "color");
                    }
                    if(isset($data['revo_preset'])){
                        jwOpt::savePreset(json_encode((array) $data['revo_preset']), "revo");
                    }
                    if(isset($data['revoelement_preset'])){
                        jwOpt::savePreset(json_encode((array) $data['revoelement_preset']), "revoelement");
                    }
                    if(isset($data['options'])){
                        jwOpt::update_option($data['options'],'opt');
                    }
                    // vymaze nacachovane linkovani fontu
                    delete_transient( JAW_THEMESLUG.'_g_fonts' );
                    do_action('jaw_generate_styles', 'color');
                    die('1');
                    break;
               
                case 'import_preset':
                    $data = $_POST['data'];
                    $target = $_POST['target'];
                    $data = unserialize(jwUtils::jaw_base64_dec($data)); //100% safe - ignore theme check nag
                    jwOpt::savePreset(json_encode((array) $data),$target);
                    // vymaze nacachovane linkovani fontu
                    delete_transient( JAW_THEMESLUG.'_g_fonts' );
                    do_action('jaw_generate_styles', 'color');
                    die('1');
                    break;

                case 'save':                    
                    $data = jwOpt::beforesave($_POST['data']);
                    jwOpt::unlogPreset('color', 'opt');
                    jwOpt::unlogPreset('category', 'opt');
                    jwOpt::unlogPreset('single', 'opt');
                    if(isset($data['jaw_category_preset'])){
                        jwOpt::savePreset($data['jaw_category_preset'],'category');
                        unset($data['jaw_category_preset']);
                    }
                    if(isset($data['jaw_single_preset'])){
                        jwOpt::savePreset($data['jaw_single_preset'],'single');
                        unset($data['jaw_single_preset']);
                    }
                    if(isset($data['jaw_color_preset'])){
                        jwOpt::savePreset($data['jaw_color_preset'],'color');
                        unset($data['jaw_color_preset']);
                    }                  
                    if(isset($data['jaw_revo_preset'])){
                        jwOpt::savePreset($data['jaw_revo_preset'],'revo');
                        unset($data['jaw_revo_preset']);
                    }    
                    if(isset($data['jaw_revoelement_preset'])){
                        jwOpt::savePreset($data['jaw_revoelement_preset'],'revoelement');
                        unset($data['jaw_revoelement_preset']);
                    }                 
                    //builder in Theme options
                    jwOpt::unlogPreset('color', 'revoopt');
                    if(isset($data['featured_area_builder'])){
                        //under menu area
                        $featured_area = addslashes($data['featured_area_builder']);
                        $data['featured_area_builder_shortcodes'] =  json_decode(stripslashes($featured_area));
                        $data['featured_area_builder'] = (maybe_serialize($data['featured_area_builder_shortcodes']));
                        $data['featured_area_builder_shortcodes'] = jwBuilder::jwPbSave(json_decode(stripslashes($featured_area)),'opt','featured_area');
                    }
                    if(isset($data['header_featured_area_builder'])){
                        //above logo
                        $header_featured_area = addslashes($data['header_featured_area_builder']);
                        $data['header_featured_area_builder_shortcodes'] =  json_decode(stripslashes($header_featured_area));
                        $data['header_featured_area_builder'] = (maybe_serialize($data['header_featured_area_builder_shortcodes']));
                        $data['header_featured_area_builder_shortcodes'] = jwBuilder::jwPbSave(json_decode(stripslashes($header_featured_area)),'opt','header_featured_area');
                    }
                    
                    foreach($data as $key => $field){
                        //pokud data obsahuji '{{' tak doslo pravdepodobne k chybe javascriptu a nencetl se spravne model angularu
                        if(is_string($field) && strpos($field, '{{') !== false){
                            echo '<strong>Error while saving data (Wrong data format). <br>Please reload this page!</strong>';
                            die();
                        }
                        // loguju data o pouzitych presetech
                        if (substr($key, -6) == '_color') {
                            // zaloguju vsechny color presety
                            jwOpt::logPreset('color', 'opt',  0 ,0, $key,$field);
                        }
                        if($key === 'blog_preset' || $key === 'archive_preset'){
                            // zaloguju vsechny blog presety
                            jwOpt::logPreset('category', 'opt',  0 ,0, $key,$field);
                        }
                        if($key === 'single_preset'){
                            // zaloguju vsechny single presety
                            jwOpt::logPreset('single', 'opt',  0 ,0, $key,$field);
                        }
                    }
                    jwOpt::update_option($data);
                    // vymaze nacachovane linkovani fontu
                    delete_transient( JAW_THEMESLUG.'_g_fonts' );
                    do_action('jaw_generate_styles', 'color');
                    do_action('jaw_save_theme_options');
                    die('1');
                    break;

                case 'save_preview':
                    if(empty($_POST['data'])){
                        die('0');
                        break;
                    }
                    $data = $_POST['data'];

                    if(!isset($data['name']) || !isset($data['value'])){
                        die('0');
                        break;
                    }
                        
                    jwOpt::update_one_option($data['name'],$data['value'], 'opt',0, true);
                    do_action('jaw_generate_styles', 'color_preview');
                    do_action('jaw_save_theme_options_preview');
                    die('1');
                    break;

                case 'save_color':
                    $data = $_POST['data'];
                    if(isset($data["name"])){
                        $data["name"] = str_replace("]","",$data["name"]);
                        $name = explode("[",$data["name"]);
                        jwOpt::savePartOfPreset($data['value'],'color_preview',$name[1], $name[2] );
                        do_action('jaw_generate_styles', "color_preview");
                    }
                    die('1'); //options reset
                    break;

                case 'reset':
                    jwOpt::update_option(jwOpt::getDefaults());
                    // vymaze nacachovane linkovani fontu
                    delete_transient( JAW_THEMESLUG.'_g_fonts' );
                    do_action('jaw_generate_styles', 'color');
                    die('1'); //options reset
                    break;

                case 'import_demo':
                    if(isset($_POST['demoId'])){
                        $import = new jwDemoImport();
                        $import->install($_POST['demoId']);
                    }
                    die();
                    break;
                case 'uninstal_demo':
                    if(isset($_POST['demoId'])){
                        $import = new jwDemoImport();
                        $import->uninstall($_POST['demoId']);
                        jwOpt::refresh_options();
                        do_action('jaw_generate_styles', 'color');
                    }
                    die();
                    break;
            }
        }

        public static function renderAdminPage() {
            global $jaw_tips;
            self::menuAndHooks();
            $out = '';
            ob_start();
            ?>
                                                                                                    
            <div class="wrap adminoption" id="of_container"  ng-controller="jwEditorController" ng-app="jwEditor">

                <h2 style="padding:0px"><?php //pro wordpress errory. Pokud se to smaze, errory rozbijeji panel, najdou si prvni h2 a zaradi pod nej error box             ?></h2>
                

                <span style="display: none;" id="hooks"><?php echo json_encode(self::$hooks); ?></span>
                <input type="hidden" id="reset" value="<?php if (isset($_REQUEST['reset'])) echo esc_attr($_REQUEST['reset']); ?>" />
                <input type="hidden" id="jaw_security" name="jaw_security" value="<?php echo wp_create_nonce('of_ajax_nonce'); ?>" />
                <form id="of_form" method="post" autocomplete="off" action="<?php echo esc_attr($_SERVER['REQUEST_URI']) ?>" enctype="multipart/form-data" >

                    <div id="header">

                        <div class="logo">
                            <img src="<?php  echo esc_url(JAW_THEME_FRAMEWORK_URI . "/admin/assets/images/logo-white.png"); ?>" alt="<?php echo esc_attr(JAW_THEMENAME); ?>" />
                            <span><?php echo ('v' . JAW_THEMEVERSION); ?></span>
                        </div>

                        <div id="js-warning"><?php echo 'Warning - This options panel will not work properly without javascript!' ?></div>
                        <div class="jaw-icon-option"></div>
                        <div class="clear"></div>

                    </div>

                    <div id="info_bar">

                        <a>
                            <div id="expand_options" class="expand">Expand</div>
                        </a>

                        <img style="display:none" src="<?php echo JAW_ADMIN_URI; ?>assets/images/loading-bottom.gif" class="ajax-loading-img ajax-loading-img-bottom" alt="Working..." />
                        <button class="of_save" type="button" ng-click="saveTO()" class="button-primary">
                            <?php esc_html_e('Save All Changes','gdn-theme') ?>
                        </button>

                    </div><!--.info_bar--> 	

                    <div id="main">
                        
                        <div id="of-nav">
                            <ul>
                                <?php echo self::$menu ?>
                            </ul>
                        </div>

                        <div id="content">
                            <div class="jaw-panel-loader" ng-hide="loader['theme_options']">
                                <i  class="jaw-icon-spinner2 jaw-spinit"></i>
                                <div class="jw-to-tips">
                                    <strong>Tip:</strong> <?php echo $jaw_tips[rand(0, sizeof($jaw_tips)-1)]['text']; ?>
                                </div>
                            </div>
                            <?php
                            echo jwElements::renderPages(jwOpt::getRawOptions(), jwOpt::get_options());
                            ?> 

                        </div>

                        <div class="clear"></div>

                    </div>

                    <div class="save_bar"> 
                        <img style="display:none" src="<?php echo JAW_ADMIN_URI; ?>assets/images/loading-bottom.gif" class="ajax-loading-img ajax-loading-img-bottom" alt="Working..." />
                        <button class ="of_save" ng-click="saveTO()" type="button" class="button-primary"><?php esc_html_e('Save All Changes','gdn-theme'); ?></button>			

                        <!--<button id ="of_reset" type="button" class="button submit-button reset-button" ><?php echo 'Options Reset'; ?></button>-->
                        <a href="javascript: jaw_admin_theme.launchHelp('http://support.jawtemplates.com/gdaynews/web/documentation/');" type="button" class="button  reset-button help-button"><?php echo 'Documentation'; ?></a>
                        <a href="javascript: jaw_admin_theme.launchHelp('http://support.jawtemplates.com/');" type="button" class="button  reset-button help-button"><?php echo 'Forum'; ?></a>
                        <a href="javascript: jaw_admin_theme.launchHelp('http://support.jawtemplates.com/gdaynews/web/');" type="button" class="button  reset-button help-button"><?php echo 'Knowledgebase'; ?></a>

                        <img style="display:none" src="<?php echo JAW_ADMIN_URI; ?>assets/images/loading-bottom.gif" class="ajax-reset-loading-img ajax-loading-img-bottom" alt="Working..." />

                    </div><!--.save_bar--> 

                    <div class="jw-fixed-save">

                        <button class="of_save" type="button" ng-click="saveTO()" class="button-primary">
                            <span class="ajax-loading-img jaw-spinit" style="display:none;"><i class="jaw-icon-spinner2"></i></span>
                            <span class="ajax-loading-img-inverse" style="display:inline;"><i class="jaw-icon-disk"></i></span>
                            <div class="jaw-save-moretext"><span class="jaw-save-moretext-text"><?php esc_html_e('Save','gdn-theme'); ?></span></div>
                        </button>
                    </div>
                    
                    <jwd-check-changes 
                                    interval="5000" 
                                    class="jw-check-changes"                           
                                >
                    </jwd-check-changes>
                    <jwd-info-dialog></jwd-info-dialog>
                    
                    <?php wp_nonce_field('jaw_theme_options','jaw_theme_options_nonce'); ?>

                </form>

                <div style="clear:both;"></div>

            </div><!--wrap-->

            <?php
            $out = ob_get_clean();
            echo $out;
        }



     

        
        
        //AJAX loding of changelog to Theme Options
        public function jaw_changelog(){
            $change_log = "";
            //changelog se cachuje
            if(!$change_log = get_transient(JAW_THEMESLUG.'_cahngelog')){
                $version = str_replace('.', '_', jaw_get_theme_version());
                $change_log="<p style='color:#1E8CBE;font-weight:bold;'>What's new in current version</p>";
                $url = 'http://support.jawtemplates.com/info/changelog.txt.php?version='. JAW_THEMEVERSION;           
                $remote = wp_remote_get($url);
                if ($remote['response']['code'] == 200) {
                    $change_log .= wp_remote_retrieve_body($remote);
                } else {
                    $change_log .= 'Not available';
                }
                set_transient( JAW_THEMESLUG.'_cahngelog', $change_log, DAY_IN_SECONDS );
            }
            echo $change_log;
            die();
        }
        
        //AJAX loding of theme requirements check in Theme Options
        public function jaw_checker(){
            $out = "";
            //checker se cachuje - je mozne vyvolat jej pomoci status = "refresh"
            if(filter_input(INPUT_POST, 'status') == 'refresh' || !$out = get_transient(JAW_THEMESLUG.'_checker')){
                $out = json_encode($this->check_theme());
                set_transient( JAW_THEMESLUG.'_checker', $out,YEAR_IN_SECONDS );
            }
            echo $out;
            die();
        }
        private function check_theme() {
            global $wpdb;
            
            $memory_limit = $this->convertPHPSizeToBytes(ini_get('memory_limit'));
            $max_execution_time = $this->convertPHPSizeToBytes(ini_get('max_execution_time'));
            $upload_max_filesize = $this->convertPHPSizeToBytes(ini_get('upload_max_filesize'));
            $max_input_vars = ini_get('max_input_vars');
            $mysql = $wpdb->db_version();
            $out = array();


            // SERVER ENVIROVEMENT //
            
            // Apache Check
            $out[]=array(
                "name"=>"Server Info",
                "msg"=>esc_html( $_SERVER['SERVER_SOFTWARE'] ),
                "state"=>"info2");
                
            // MySQL Check
            $mysql_version = $mysql;
            $checked_version = "5";
            if ( version_compare( $mysql_version, $checked_version, '<' ) ) {
                $out[]=array(
                    "name"=>"MySQL Version",
                    "msg"=>"We recommend a minimum MySQL version of ".$checked_version.". Your actual version is ".esc_html( $mysql_version ).'. How to update MySQL versiom - http://dev.mysql.com/doc/refman/5.7/en/upgrading.html',
                    "state"=>"close");
            } else {
                $out[]=array(
                    "name"=>"MySQL Info",
                    "msg"=>$mysql_version,
                    "state"=>"checkmark");
            }
            
            // PHP Check
            if ( function_exists( 'phpversion' ) ) {
                $php_version = phpversion();
                $checked_version = "5.6";
                if ( version_compare( $php_version, $checked_version, '<' ) ) {
                    $out[]=array(
                    "name"=>"PHP Version",
                    "msg"=>"We recommend a minimum PHP version of ".$checked_version.". Your actual version is ".esc_html( $php_version ).'. How to update PHP versiom - http://docs.woothemes.com/document/how-to-update-your-php-version',
                    "state"=>"close");
                } else {
                    $out[]=array(
                    "name"=>"PHP Version",
                    "msg"=>esc_html( $php_version ),
                    "state"=>"checkmark");
                }
            } else {
                $out[]=array(
                "name"=>"PHP Version",
                "msg"=>"is not recognized. Function phpversion() does not exist",
                "state"=>"close");
            }
            
            // Server Compression Check        
			if ( is_callable( 'gzopen' ) ) {
                $out[]=array(
                "name"=>"gZip Compression",
                "state"=>"checkmark");
			} else {
                $out[]=array(
                "name"=>"gZip Compression",
                "msg"=>" Please contact your hosting company to enable this compression  - https://gtmetrix.com/enable-gzip-compression.html",
                "state"=>"close");
			}
            
            // PHP Values  
            if ($memory_limit < 100000000) {
                $out[]=array(
                "name"=>"PHP Value memory_limit",
                "msg"=>"In your php.ini file is too low. Please contact your hosting service to increase this value to 128MB at least. Actual value is ".size_format($memory_limit),
                "state"=>"close");
            } else {
                $out[]=array(
                "name"=>"PHP Value memory_limit (actual is ".size_format($memory_limit).')',
                "state"=>"checkmark");
            }
            if ($max_execution_time < 30) {
                if ($max_execution_time == (int)-1 || $max_execution_time == (int) 0) {
                    $out[]=array(
                    "name"=>"PHP Value max_execution_time (actual is ".$max_execution_time.')',
                    "state"=>"checkmark");
                } else {
                    $out[]=array(
                    "name"=>"PHP Value max_execution_time",
                    "msg"=>"In your php.ini file is too low. Please contact your hosting service to increase this value to 30 at least. Actual value is ".$max_execution_time,
                    "state"=>"close");
                }
            } else {
                $out[]=array(
                "name"=>"PHP Value max_execution_time (actual is ".$max_execution_time.')',
                "state"=>"checkmark");
            }
            if ($upload_max_filesize < 6000000) {
                $out[]=array(
                "name"=>"PHP Value upload_max_filesize",
                "msg"=>"In your php.ini file is too low. Please contact your hosting service to increase this value to 6MB at least. Actual value is ".size_format($upload_max_filesize),
                "state"=>"close");
            } else {
                $out[]=array(
                "name"=>"PHP Value upload_max_filesize (actual is ".size_format($upload_max_filesize).')',
                "state"=>"checkmark");
            }
            if($max_input_vars < 5000) {
                $out[]=array(
                "name"=>"PHP Value max_input_vars",
                "msg"=>"In your php.ini file is too low. Please contact your hosting service to increase this value to 5000 at least. Actual value is ".$max_input_vars,
                "state"=>"close");
            } else {
                $out[]=array(
                "name"=>"PHP Value max_input_vars (actual is ".$max_input_vars.')',
                "state"=>"checkmark");
            }
            
            return $out;
        }
        
        private function convertPHPSizeToBytes($sSize) {
            if (is_numeric($sSize)) {
                return $sSize;
            }
            $sSuffix = substr($sSize, -1);
            $iValue = substr($sSize, 0, -1);
            switch (strtoupper($sSuffix)) {
                case 'P':
                    $iValue *= 1024;
                case 'T':
                    $iValue *= 1024;
                case 'G':
                    $iValue *= 1024;
                case 'M':
                    $iValue *= 1024;
                case 'K':
                    $iValue *= 1024;
                    break;
            }
            return $iValue;
        }
        
         function jaw_category_preset_editor() {
            global $jaw_category_preset;
            ?>

            <div id="jaw-builder-popup">
                <?php
                if (!empty($jaw_category_preset) && isset($_GET['jaw_type'])) {
                    $index = jaw_template_inc_counter('wp_editor') .'_'. rand(99,9999);
                    ?>
                    <div id="header_editor" ng-init="init_editor('<?php echo esc_attr($index); ?>');">
                        <button ng-click="cancel_editor()" class="button-primary builder red jaw"  type="button"><i class="icon-white jaw-icon-close  "></i></button>
                        <button ng-click="check_blank('title', save_editor)" class="button-primary builder blue jaw"  type="button"><i class="icon-white jaw-icon-save"></i>  Done</button>
                        <?php
                        if ($_GET['jaw_type'] == 'edit') {
                            ?>
                          <!--  <button ng-click="saveas_editor()" class="button-primary builder blue jaw"  type="button"><i class="icon-white jaw-icon-save"></i>  Save as new</button>-->
                            <?php
                        }
                        ?>
                    </div>
                    <div class="editor_bookmarks"><ul><li ng-class="{active: active_bookmark == i}" ng-repeat="(i, marks) in bookmarks track by i" ng-click="switch_mark(i)">{{marks}}</li></ul></div>
                    <div id="editor_container_<?php echo esc_attr($index); ?>" class="editor_container" ng-class="{initialized: initialized}">

                        <div class="content" ng-controller="jwEditorController" >
                            <?php
                            $category_preset = $jaw_category_preset;

                            if(isset($_GET['jaw_preset'])){
                                $category_preset[] = array(
                                    "name" => "Preset Assigned In",
                                    "type" => "sectionstart");
                                $category_preset[] = array("name" => "<i class='jaw-icon-search3'></i> This preset is assigned in these places:",
                                                            "desc" => "",
                                                            "id" => "places",
                                                            "jaw_preset_type" => $_GET['jaw_preset_type'],
                                                            "jaw_preset" => $_GET['jaw_preset'],
                                                            "type" => "preset_places"); 
                                $category_preset[] = array("type" => "sectionend");
                            }
                            echo jwElements::elements_render($category_preset);
                            ?>
                        </div>
                    </div>
                    <div ng-class="{initialized: initialized}" class="jaw-editor-loading">
                            Loading...
                    </div>




                <?php } else { ?>
                    <div id="header_editor">
                        <button ng-click="cancel_editor()" class="button-primary builder red jaw"  type="button"><i class="icon-white icon-close  "></i></button>
                    </div>
                    Something wrong happened. Dialog couldn't be loaded.

                <?php } ?> 
            <div class="jw-builder-save-popup" ng-class="{initialized: initialized}" >
                <button ng-click="check_blank('title', save_editor)" class="button-primary builder blue jaw"  type="button"><i class="icon-white jaw-icon-save"></i>  Done</button>
            </div>
            </div><?php
            die();
        }

        function jaw_single_preset_editor() {
            global $jaw_single_preset;
            ?>

            <div id="jaw-builder-popup">
                <?php
                if (!empty($jaw_single_preset) && isset($_GET['jaw_type'])) {
                    $index = jaw_template_inc_counter('wp_editor') .'_'. rand(99,9999);
                    ?>
                    <div id="header_editor" ng-init="init_editor('<?php echo esc_attr($index); ?>');">
                        <button ng-click="cancel_editor()" class="button-primary builder red jaw"  type="button"><i class="icon-white jaw-icon-close  "></i></button>
                        <button ng-click="check_blank('title', save_editor)" class="button-primary builder blue jaw"  type="button"><i class="icon-white jaw-icon-save"></i>  Done</button>
                        <?php
                        if ($_GET['jaw_type'] == 'edit') {
                            ?>
                           <!-- <button ng-click="saveas_editor()" class="button-primary builder blue jaw"  type="button"><i class="icon-white jaw-icon-save"></i>  Save as new</button>-->
                            <?php
                        }
                        ?>
                    </div>

                    <div class="editor_bookmarks"><ul><li ng-class="{active: active_bookmark == i}" ng-repeat="(i, marks) in bookmarks track by i" ng-click="switch_mark(i)">{{marks}}</li></ul></div>
                    <div id="editor_container_<?php echo esc_attr($index); ?>" class="editor_container" ng-class="{initialized: initialized}">

                        <div class="content" ng-controller="jwEditorController" >
                            <?php
                            $single_preset = $jaw_single_preset;

                            if(isset($_GET['jaw_preset'])){
                                $single_preset[] = array(
                                    "name" => "Preset Assigned In",
                                    "type" => "sectionstart");
                                $single_preset[] = array("name" => "<i class='jaw-icon-search3'></i> This preset is assigned in these places:",
                                                            "desc" => "",
                                                            "id" => "places",
                                                            "jaw_preset_type" => $_GET['jaw_preset_type'],
                                                            "jaw_preset" => $_GET['jaw_preset'],
                                                            "type" => "preset_places"); 
                                $single_preset[] = array("type" => "sectionend");
                            }
                            echo jwElements::elements_render($single_preset);
                            ?>
                        </div>
                    </div>
                    <div ng-class="{initialized: initialized}" class="jaw-editor-loading">
                            Loading...
                    </div>




                <?php } else { ?>
                    <div id="header_editor">
                        <button ng-click="check_blank('title', save_editor)" class="button-primary builder blue jaw"  type="button"><i class="icon-white jaw-icon-save"></i>  Done</button>
                    </div>
                    Something wrong happened. Dialog couldn't be loaded.

                <?php } ?> 
            <div class="jw-builder-save-popup" ng-class="{initialized: initialized}" >
                <button ng-click="save_editor()" class="button-primary builder blue jaw" type="button"><i class="icon-white jaw-icon-save"></i> Done</button>
            </div>
            </div><?php
            die();
        }

        function jaw_color_preset_editor() {
            global $jaw_color_preset;
            $index = jaw_template_inc_counter('wp_editor') .'_'. rand(99,9999);
            ?>

            <div id="jaw-builder-popup">
                <div id="header_editor" ng-init="init_editor('<?php echo esc_attr($index); ?>');">
                    <button ng-click="cancel_editor()" class="button-primary builder red jaw"  type="button"><i class="icon-white jaw-icon-close  "></i></button>
                    <button ng-click="check_blank('title', save_editor)" class="button-primary builder blue jaw"  type="button"><i class="icon-white jaw-icon-save"></i>  Save</button>
                </div>

                <div class="editor_bookmarks"><ul><li ng-repeat="(i, marks) in bookmarks track by i" ng-click="switch_mark(i)">{{marks}}</li></ul></div>
                <div id="editor_container_<?php echo esc_attr($index); ?>" class="editor_container" ng-class="{initialized: initialized}">

                    <div class="content"  >
                        <?php
                        echo jwElements::elements_render($jaw_color_preset);
                        ?>
                    </div>
                </div>
                <div ng-class="{initialized: initialized}" class="jaw-editor-loading">
                    Loading...
                </div> 
                <div class="jw-builder-save-popup" ng-class="{initialized: initialized}" >
                    <button ng-click="check_blank('title', save_editor)" class="button-primary builder blue jaw"  type="button"><i class="icon-white jaw-icon-save"></i>  Done</button>
                </div>
            </div><?php
            die();
        }

        function jaw_export_preset() {
            global $jaw_export_preset;
            $index = jaw_template_inc_counter('wp_editor') .'_'. rand(99,9999);
            ?>

            <div id="jaw-builder-popup">
                <div id="header_editor" ng-init="init_editor('<?php echo esc_attr($index); ?>');">
                    <button ng-click="cancel_editor()" class="button-primary builder red jaw"  type="button"><i class="icon-white jaw-icon-close  "></i></button>
                </div>

                <div class="editor_bookmarks"><ul><li ng-repeat="(i, marks) in bookmarks track by i" ng-click="switch_mark(i)">{{marks}}</li></ul></div>
                <div id="editor_container_<?php echo esc_attr($index); ?>" class="editor_container" ng-class="{initialized: initialized}">

                    <div class="content"  >
                        <?php
                        echo jwElements::elements_render($jaw_export_preset);
                        ?>
                    </div>
                </div>
                <div ng-class="{initialized: initialized}" class="jaw-editor-loading">
                     Loading...
                </div>
            </div><?php
            die();
        }
        
        function jaw_preset_log(){
            $index = jaw_template_inc_counter('wp_editor') .'_'. rand(99,9999);
            ?>
            <div id="jaw-builder-popup">
                <div id="header_editor">
                    <button ng-click="cancel_editor()" class="button-primary builder red jaw"  type="button"><i class="icon-white jaw-icon-close  "></i></button>
                </div>

                <div id="editor_container_<?php echo esc_attr($index); ?>" class="editor_container" ng-class="{initialized: initialized}">

                    <div class="content"  >
                        <?php
                            $jaw_places[] = array("name" => "<i class='jaw-icon-search3'></i> This preset is assigned in these places:",
                                                        "desc" => "",
                                                        "id" => "places",
                                                        "jaw_preset_type" => $_GET['jaw_preset_type'],
                                                        "jaw_preset" => $_GET['jaw_preset'],
                                                        "type" => "preset_places"); 
                            echo jwElements::elements_render($jaw_places);
                            ?>
                    </div>
                </div>
                <div ng-class="{initialized: initialized}" class="jaw-editor-loading">
                     Loading...
                </div>
            </div><?php
            die();
        }
        
        /**
        *   Kontrola použití presetu
        **/
        function jaw_check_preset(){
            if(isset($_POST['jaw_pb_preset']) && isset($_POST['jaw_pb_typ'])){
                $typ = str_replace('jaw_','',str_replace('_preset','',$_POST['jaw_pb_typ']));
                if(sizeof(jwOpt::getLogPresetAddress($typ, $_POST['jaw_pb_preset']))){
                    echo '1';
                }
            }
            die();
        }
        
        /**
        *   Kontrola zmeny optionu
        **/
        function jaw_check_changes(){
            $colorPreset = jwOpt::loadAllPresets('color');
            $jsonColor = json_encode((object) $colorPreset, JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_HEX_AMP | JSON_UNESCAPED_UNICODE);
             
            $categoryPreset = jwOpt::loadAllPresets('category');
            $jsonCategory = json_encode((object) $categoryPreset, JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_HEX_AMP | JSON_UNESCAPED_UNICODE);
             
            $singlePreset = jwOpt::loadAllPresets('single');
            $jsonSingle = json_encode((object) $singlePreset, JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_HEX_AMP | JSON_UNESCAPED_UNICODE);
            
            $themeOptions = jwOpt::get_options();
            if(isset($themeOptions["youtube_token"])){
                unset($themeOptions["youtube_token"]); //youtube_token se meni kazdou polhodinu
            }
            $jsonTO = json_encode((object) $themeOptions, JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_HEX_AMP | JSON_UNESCAPED_UNICODE);

            $out = array(
                'color_preset' => $jsonColor,
                'category_preset' => $jsonCategory,
                'single_preset' => $jsonSingle, 
                'theme_options' => $jsonTO
            );
            echo json_encode($out);
            die();
        }
        
        
    }

}
