<?php
/**
 * This class is main manager for all options theme option
 *
 * @author JaW Templates <http://www.jawtemplates.com>
 * @copyright (c) 2013, CCB, spol. s r.o.
 * @version 1.0
 *
 * @todo - Spojit logiku presetů a options
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

if (!class_exists('jwOpt')) {

    class jwOpt {

        private static $_rawOptions = array(); // binds options
        private static $_options = null; // key(id) = value (value can bt array]
        private static $_categories = null;
        private static $_menus = null;
        private static $_panelmenu = null;
        private static $_xml = null;
        private static $_category_preset = null;
        private static $_single_preset = null;
        private static $_color_preset = null;
        private static $_color_preview_preset = null;
        private static $_revo_preset = null;
        private static $_revoelement_preset = null;
        private static $_log_presets = null;

        public function __construct() {

            self::_getConfig();

            self::refresh_options(function_exists('is_customize_preview') && is_customize_preview());

            if (empty(self::$_options)) {
                self::$_options = self::getRawOptions();
            }
        }

        /**
         * Docasne ulozeni/presani hodnoty. Hodnoty nejsou ulozeny do DB.
         * @param string $name variable name
         * @param mixed $value
         * @param string $type namespace
         * @param int $id (optional) 
         */
        public static function set_option($name, $value, $type = 'opt', $id = '') {
            switch ($type) {
                case 'category':
                    self::$_categories['category_' . $id][$name] = $value;
                    break;
                case 'menus':
                    self::$_menus[$id][$name] = $value;
                    break;
                default:
                    self::$_options[$name] = $value;
                    break;
            }
        }

        private static function getDefault($opt) {
            if (isset($opt['std']))
                return $opt['std'];
            else
                return null;
        }

        private static function getValue($opt, $data = null) {
            if (!is_null($data) && isset($data[$opt['id']])) {
                return $data[$opt['id']];
            } else if (isset($opt['std'])) {
                return $opt['std'];
            } else
                return null;
        }

        private static function _load_file_options() {
            if (empty(self::$_rawOptions)) {
                require JAW_ADMIN_DIR . 'options/themeoptions.php';
                self::$_panelmenu = apply_filters('jaw_themeoptions_menu', $menu);
                self::$_rawOptions = apply_filters('jaw_themeoptions', $options);
            }
        }

        public static function getRawOptions() {
            self::_load_file_options();

            return self::$_rawOptions;
        }

// get item options
        public static function get_option($name, $default = null, $type = 'opt', $id = '') {
            switch ($type) {
                case 'category':
                    if (isset(self::$_categories['category_' . $id][$name]))
                        return (self::$_categories['category_' . $id][$name]);
                    else
                        return $default;
                    break;
                case 'menus':
                    if (isset(self::$_menus[$id][$name]))
                        return (self::$_menus[$id][$name]);
                    else
                        return $default;
                    break;
                default:
                    if (isset(self::$_options[$name]))
                        return (self::$_options[$name]);
                    else
                        return $default;
                    break;
            }
        }

// get all options
        public static function get_options($type = 'opt', $preview = NULL) {
            if(empty($preview)){
                $preview = function_exists('is_customize_preview') && is_customize_preview();
            }
            $suffix = "";
            if($preview){   
                $suffix = "_preview";
            }
            switch ($type) {
                case 'category':
                    if (is_null(self::$_categories))
                        return get_option(JAW_CATEGORIES . $suffix);
                    else
                        return self::$_categories;
                    break;
                case 'menus':
                    if (is_null(self::$_menus))
                        return get_option(JAW_MENUS . $suffix);
                    else
                        return self::$_menus;
                    break;
                default:
                    if (is_null(self::$_options))
                        return get_option(JAW_OPTIONS . $suffix);
                    else
                        return self::$_options;
                    break;
            }
        }

        /**
         * ulozeni/presani hodnoty. Hodnoty JSOU ulozeny do DB.
         */
        public static function update_one_option($name, $value, $type = 'opt', $id = '', $preview = false) {
            self::refresh_options($preview);
            switch ($type) {
                case 'category':
                    self::$_categories['category_' . $id][$name] = $value;
                    self::update_option(self::$_categories, $type, $preview);
                    break;
                case 'menus':
                    self::$_menus[$id][$name] = $value;
                    self::update_option(self::$_menus, $type, $preview);
                    break;
                default:
                    self::$_options[$name] = $value;
                    self::update_option(self::$_options, $type, $preview);
                    break;
            }
        }

        // update type options
        public static function update_option($data, $type = 'opt', $preview = false) {
            $suffix = "";
            if($preview){   
                $suffix = "_preview";
            }else{
                self::update_option($data, $type, true); // pokud ukladam normalni option, tak ho zduplikuji do preview
            }
            switch ($type) {
                case 'category':
                    update_option(JAW_CATEGORIES . $suffix, $data);
                    break;
                case 'menus':
                    update_option(JAW_MENUS . $suffix, $data);
                    break;
                default:
                    update_option(JAW_OPTIONS . $suffix, $data);
                    break;
            }            
            self::refresh_options($preview);
        }

        public static function refresh_options($preview = false) {
            $suffix = "";
            if($preview){   
                $suffix = "_preview";
            }
            self::$_options = get_option(JAW_OPTIONS . $suffix);
            self::$_categories = get_option(JAW_CATEGORIES . $suffix);
            self::$_menus = get_option(JAW_MENUS . $suffix);
        }

        public static function update_backups() {
            $bck_infos = get_option(JAW_THEMENAME . JAW_BACKUPS);
            if (empty($bck_infos)) {
                $bck_infos = array();
            }
            $bck_subname = JAW_BACKUPS . '-' . sizeof($bck_infos);
            $bck_infos[] = array(
                'backup_name' => $bck_subname,
                'backup_log' => date('r')
            );

            update_option(JAW_THEMENAME . JAW_BACKUPS, $bck_infos);

            $data_opt = jwOpt::get_options();
            $data_cat = jwOpt::get_options('category');
            $data_cat_pr = self::loadAllPresets('category');
            $data_single_pr = self::loadAllPresets('single');
            $data_color_pr = self::loadAllPresets('color');
            $data_revo_pr = self::loadAllPresets('revo');
            $data_revel_pr = self::loadAllPresets('revoelement');
            
            update_option(JAW_OPTIONS . $bck_subname, $data_opt);
            update_option(JAW_CATEGORIES . $bck_subname, $data_cat);
            update_option('jaw_category_preset'.$bck_subname, $data_cat_pr );
            update_option('jaw_single_preset'.$bck_subname, $data_single_pr);
            update_option('jaw_color_preset'.$bck_subname, $data_color_pr);
            update_option('jaw_revo_preset'.$bck_subname, $data_revo_pr);
            update_option('jaw_revoelement_preset'.$bck_subname, $data_revel_pr);
            
            
        }

        public static function get_backups_info() {
            $prom = get_option(JAW_THEMENAME . JAW_BACKUPS);
            return $prom;
        }

        public static function get_backup($type, $subname) {
            $prom = get_option($type . $subname);
            return $prom;
        }

        public static function getDefaults() {
            self::_load_file_options();
            $default = array();

            if (!empty(self::$_rawOptions)) {
                foreach (self::$_rawOptions as $opt) {
                    if (isset($opt['id'])) {
                        //do $_default jsou všechny defaultní hodnoty, kromě sidebarů
                        if ($opt['id'] != 'sidebars') {
                            $default[$opt['id']] = self::getDefault($opt);
                        } else {
                            $default[$opt['id']] = self::get_option($opt['id'], null);
                        }
                    }
                }
                return $default;
            } else {
                return array();
            }
        }
        
        /*
        *   Vlozim pole a on mi vrati prvni hodnotu, ktera neni _default
        */
        public static function checkDefault($options = array()) {
            foreach ((array) $options as $option) {
                
                if (isset($option) && $option != '' && $option != '-1' && $option != '_default') {
                    return $option;
                }
            }
            return $option;
        }
        
        /*
        *   Vlozim pole a on mi vrati prvni hodnotu presetu, ktera neni _default a existuje
        */
        public static function checkDefaultPreset($options = array(), $type) {
            $presetType = '_' . $type . '_preset';
            self::loadAllPresets($type);
            
            foreach ((array) $options as $option) {
                
                if (isset($option) && $option != '' && $option != '-1' && $option != '_default' && isset(self::${$presetType}[$option])) {
                    return $option;
                }                
               
            }
            return $option;
        }

        public static function getPanelMenu() {
            self::_load_file_options();
            return self::$_panelmenu;
        }

        public static function beforeSave($data) {
            wp_parse_str(stripslashes($data), $data);
            unset($data['jaw_security']);
            unset($data['of_save']);
            return $data;
        }

        public static function is($data) {
            if (isset($data) && !empty($data))
                return true;
            else
                return false;
        }

        /*         * *********************  Presety ************************************ */

        public static function getPresetValue($optionsName, $default = '', $type = 'category', $presetName) {
            $preset = (array) self::loadPreset($type, $presetName);
            if (isset($optionsName) && isset($preset[$optionsName])) {
                return $preset[$optionsName];
            } else {
                return $default;
            }
        }

        public static function loadPreset($type = 'category', $presetName) {
            $presetType = '_' . $type . '_preset';
            if (isset($presetName) && is_string($presetName)) {
                if (isset(self::${$presetType}[$presetName])) {
                    return self::${$presetType}[$presetName];
                }
                self::loadAllPresets($type);
                if (isset(self::${$presetType}[$presetName])) {
                    return self::${$presetType}[$presetName];
                }
                return array();
            } else {
                return array();
            }
        }

        public static function loadAllPresets($type = 'category') {
            $presetType = '_' . $type . '_preset';
            if (isset(self::${$presetType})) {
                return self::${$presetType};
            }else{
                self::${$presetType} = array();
            }
            self::loadAllPresetsFromDatabase($type);
            return self::${$presetType};
        }
        
        public static function loadAllPresetsFromDatabase($type = 'category'){
            $presetType = '_' . $type . '_preset';
            $preset = get_option('jaw_' . $type . '_preset');
            if(is_array($preset)){ 
                self::${$presetType} = $preset;
            }
        }

        public static function savePreset($data , $type = 'category') {
            if(isset($data)){
                $check_data = (array) json_decode($data);
                self::unlogPreset('color', $type.'pst');
                foreach($check_data as $key => $val){
                    $val = (array) $val;
                    $keys = array_keys((array) $val);  
                    $color = preg_grep('/.*?_color/',$keys);
                    foreach((array) $color as $c){
                        self::logPreset('color', $type.'pst', $key, 0,$c, $val[$c]);
                    }
                }
                self::storePreset($data, $type);
            }
        }
        
        public static function savePartOfPreset($data , $type = 'category', $presetid, $itemid) {
            if(isset($data)){
                $presetType = '_' . $type . '_preset';
                self::loadAllPresets($type);
                self::${$presetType}[$presetid][$itemid] = $data;
                self::storePreset(json_encode(self::${$presetType}), $type);
            }
        }
        
        
        /**
        * $type - type presetu (category, single, coor, ...)
        * $name - nazev presetu (timestamp)
        * $data - polozky presetu
        */
        public static function addPreset($type, $name,  $data) {
            $presetType = '_' . $type . '_preset';
            self::loadAllPresets($type);
            self::${$presetType} = json_encode(array_merge((array)self::${$presetType} , array($name => $data)));
            self::storePreset(self::${$presetType}, $type);
        }
        
        /**
        * $type - type presetu (category, single, coor, ...)
        * $name - nazev presetu (timestamp)
        */
        public static function deletePreset($type,$name) {
            $presetType = '_' . $type . '_preset';
            self::loadAllPresets($type);
            self::unlogPreset('color', $type.'pst', $name);
            unset(self::${$presetType}[$name]);
            self::storePreset(json_encode(self::${$presetType}), $type);
        }
        
        
        private static function storePreset($data , $type = 'category') {
            if(is_string($data)){
                $check_data = (array) json_decode($data);       
            }else if(is_array($data)){
                $check_data = $data;
                
            }
            foreach($check_data as $key => $value){
                $check_data[$key] = (array) $value;
            }
            update_option('jaw_' . $type . '_preset', $check_data);
        }
        
                
        /* Log of used presets ****************************************************************************/
         
         /**
         * Pridani logu
         * $type - type presetu (category, single, coor, ...)
         * $place - misto kde byl preset pouzit (TO, single, category, ...)
         * $option - option name
         * $id - ID kategorie, postu, revo elementu
         * $presetName - id presetu
         */
         public static function logPreset($type, $place, $id, $subid,$option, $presetName) {
            $presets = self::loadLogPresets();
            $find = $presets->xpath("//type[@value='".$type."']");
            if(empty($find)){
                $element = $presets->addChild('type');               
                $element->addAttribute('value', $type);
            }
            $find = $presets->xpath("//type[@value='".$type."']//place[@value='".$place."']");
            if(empty($find)){
                $element = $presets->xpath("//type[@value='".$type."']");
                $element[0]->addChild('place')->addAttribute('value', $place);
            }
            $find = $presets->xpath("//type[@value='".$type."']//place[@value='".$place."']//id[@value='".$id."']");
            if(empty($find)){
                $element = $presets->xpath("//type[@value='".$type."']//place[@value='".$place."']");
                $element[0]->addChild('id')->addAttribute('value', $id);
            }
            $find = $presets->xpath("//type[@value='".$type."']//place[@value='".$place."']//id[@value='".$id."']//subid[@value='".$subid."']");
            if(empty($find)){
                $element = $presets->xpath("//type[@value='".$type."']//place[@value='".$place."']//id[@value='".$id."']");
                $element[0]->addChild('subid')->addAttribute('value', $subid);
            }
            //pokud hodnota existuje - smazu ji
            $find = $presets->xpath("//type[@value='".$type."']//place[@value='".$place."']//id[@value='".$id."']//subid[@value='".$subid."']//option[@value='".$option."']");
            if(!empty($find)){
                $element = $presets->xpath("//type[@value='".$type."']//place[@value='".$place."']//id[@value='".$id."']//subid[@value='".$subid."']//option[@value='".$option."']");
                if(isset($element[0])){
                    $dom=dom_import_simplexml($element[0]);
                    $dom->parentNode->removeChild($dom);
                }
            }
            //hodnotu vlozim
            $find = $presets->xpath("//type[@value='".$type."']//place[@value='".$place."']//id[@value='".$id."']//subid[@value='".$subid."']//option[@value='".$option."']");
            if(empty($find)){
                $element = $presets->xpath("//type[@value='".$type."']//place[@value='".$place."']//id[@value='".$id."']//subid[@value='".$subid."']");
                $option_element = $element[0]->addChild('option');
                $option_element->addAttribute('value', $option);
                if(is_string($presetName)){
                    $option_element->addAttribute('preset', $presetName);
                }elseif(is_array($presetName)){
                    foreach($presetName as $key => $pst){
                        if(is_string($pst)){
                             $new_element = $option_element->addChild('suboption');
                             $new_element->addAttribute('key', $key);
                             $new_element->addAttribute('value', $pst);
                        }
                    }
                    self::storeLogPresets($type, $presets);
                }
            }
            return self::storeLogPresets($type, $presets);
         }
         
         /**
         * Umazani logu
         * $type - type presetu (category, single, coor, ...)
         * $place - misto kde byl preset pouzit (TO, single, category, ...)
         * $option - option name
         * $id - ID kategorie, postu, revo elementu
         */
         public static function unlogPreset($type='color', $place=NULL, $id=NULL, $subid=NULL,$option=NULL) {
            $out = 0;
            $presets = self::loadLogPresets();
            $find = $presets->xpath("//type[@value='".$type."']");
            if(!isset($place) && !empty($find)){ 
                $element = $presets->xpath("//type[@value='".$type."']");    
            }
            $find = $presets->xpath("//type[@value='".$type."']//place[@value='".$place."']");
            if(!isset($id) && !empty($find)){
                $element = $presets->xpath("//type[@value='".$type."']//place[@value='".$place."']");   
            }
            $find = $presets->xpath("//type[@value='".$type."']//place[@value='".$place."']//id[@value='".$id."']");
            if(!isset($subid) && !empty($find)){
                $element = $presets->xpath("//type[@value='".$type."']//place[@value='".$place."']//id[@value='".$id."']");
            }
            $find = $presets->xpath("//type[@value='".$type."']//place[@value='".$place."']//id[@value='".$id."']//subid[@value='".$subid."']");
            if(!isset($option) && !empty($find)){
                $element = $presets->xpath("//type[@value='".$type."']//place[@value='".$place."']//id[@value='".$id."']//subid[@value='".$subid."']");
            }
            $find = $presets->xpath("//type[@value='".$type."']//place[@value='".$place."']//id[@value='".$id."']//subid[@value='".$subid."']//option[@value='".$option."']");
            if(!empty($find)){
                $element = $presets->xpath("//type[@value='".$type."']//place[@value='".$place."']//id[@value='".$id."']//subid[@value='".$subid."']//option[@value='".$option."']");
            }
            if(isset($element[0])){
                $dom = dom_import_simplexml($element[0]);
                $dom->parentNode->removeChild($dom);
                self::storeLogPresets($type, $presets);
            }
            return $out;
         }
         
         /**
         * Zjisteni presetu
         * $type - type presetu (category, single, coor, ...)
         * $place - misto kde byl preset pouzit (TO, single, category, ...)
         * $option - option name
         * $id - ID kategorie, postu, revo elementu
         */
         public static function getLogPreset($type, $place,  $id, $subid,$option) {
            $presets = self::loadLogPresets($type);
            $find = $presets->xpath("//type[@value='".$type."']//place[@value='".$place."']//id[@value='".$id."']//subid[@value='".$subid."']//option[@value='".$option."']");
            if (!empty($find)) {
                $element =  $presets->xpath("//type[@value='".$type."']//place[@value='".$place."']//id[@value='".$id."']//subid[@value='".$subid."']//option[@value='".$option."']");
                return (string) $element[0]['preset'];
            } else {
                return array();
            }
         }

         /**
         * Vyhledavani v presetu
         * $type - type presetu (category, single, coor, ...)
         * $presetName - id presetu
         */
         public static function getLogPresetAddress($type, $presetName) {
             $presets = self::loadLogPresets($type);
             $out = array();
             $find = $presets->xpath("//type[@value='".$type."']//option[@preset='".$presetName."']");
            if (!empty($find)) {
                $element =  $presets->xpath("//type[@value='".$type."']//option[@preset='".$presetName."']");
                foreach($element as $el){
                    $option = dom_import_simplexml($el[0]);
                    $subid = $option->parentNode;
                    $id = $subid->parentNode;
                    $place = $id->parentNode;
                    $out[] = array( 'option' => $option->getAttribute('value'), 'subid' => $subid->getAttribute('value'), 'id' => $id->getAttribute('value'), 'place' => $place->getAttribute('value'), 'type' => $type );
                }
                return $out;
            } else {
                return $out;
            }
         }
         
         
         /**
         * Data pro class styles
         * $type - type presetu (category, single, color, ...)
         * $presetName - id presetu
         */
         public static function getLogPresetValue($type, $place, $option) {
             $presets = self::loadLogPresets($type);
             $out = array();
             $find = $presets->xpath("//type[@value='".$type."']//place[@value='".$place."']//option[@value='".$option."']");
            if (!empty($find)) {
                $element = $presets->xpath("//type[@value='".$type."']//place[@value='".$place."']//option[@value='".$option."']");
                foreach($element as $el){
                    $options = dom_import_simplexml($el[0]);
                    $subid = $options->parentNode;
                    $id = $subid->parentNode;
                    if($options->getAttribute('preset') !== ''){
                        $out[$place.'-'.$id->getAttribute('value').'-'.$subid->getAttribute('value').'-'.$options->getAttribute('value')] = $options->getAttribute('preset');
                    }elseif($options->getElementsByTagName('suboption') !== null){
                        $out[$id->getAttribute('value')] = array();
                        foreach($options->getElementsByTagName('suboption') as $child){
                            $out[$id->getAttribute('value')][] = $child->getAttribute('value');
                        }
                    }
                    
                }
                return $out;
            } else {
                return $out;
            }
         }


         private static function loadLogPresets(){
            if (!isset(self::$_log_presets) && function_exists('simplexml_load_string')) {
                self::$_log_presets = simplexml_load_string(get_option(JAW_COLOR_LOG));
            }
            if(!self::$_log_presets && class_exists('SimpleXMLElement')){
                self::$_log_presets = new SimpleXMLElement('<data></data>');
            }
            return self::$_log_presets;
         }
         
         private static function storeLogPresets($type, $presets){
             update_option(JAW_COLOR_LOG, $presets->asXML());
         }
         
         
        /* ====================== CONFIG XML ===================== */

        /**
         * Load the config file theme in root direcotry theme
         */
        private function _getConfig() {
            if (is_null(self::$_options)) {

                if (function_exists('simplexml_load_file') && file_exists(locate_template('/config.xml', false, false))) {
                    self::$_xml = @simplexml_load_file(locate_template('/config.xml', false, false));
                    if (self::$_xml === false) {
                        add_action('admin_notices', array($this, 'adminNoticeXMLError'));
                    }
                    return true;
                }
                add_action('admin_notices', array($this, 'adminNoticeNoexist'));
                return false;
            }
        }

        /**
         * @param string $query xpath query
         * @return array of simplexmlelement objects 
         */
        public static function getXmlSpaceXpath($query = '//options') {
            return self::$_xml->xpath($query);
        }

        /**
         * @param string (direct access over objects) 
         * @return simplexmlelement objects 
         */
        public static function getXmlSpace($namespace) {
            if (isset(self::$_xml->$namespace))
                return self::$_xml->$namespace;
            else
                return null;
        }

        public function adminNoticeNoexist() {
            ?>
            <div class="updated">
                <p>Config file "config.xml" do not exists or SimpleXML is not configured on your server! </p>
            </div>
            <?php
        }

        public function adminNoticeXMLError() {
            ?>
            <div class="updated">
                <p>XML parse error. Please reupload config.xml file in root theme.</p>
            </div>
            <?php
        }
    }
}