<?php
/**
 * Metabox Taxonomy API
 *
 * This class loads all the methods and helpers specific to build a meta box for taxonomy (categories or tags).
 * Actual only for Category
 *
 * @author JaW Templates <http://www.jawtemplates.com>
 * @copyright (c) 2013, CCB, spol. s r.o.
 * @version 1.0
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

if (!class_exists('jwMetatax')) {

    class jwMetatax {
        /* variable to store the meta box array */

        private $meta_box;

        /**
         * PHP5 constructor method.
         *
         * This method adds other methods of the class to specific hooks within WordPress.
         *
         * @uses      add_action()
         *
         * @return    void
         *
         * @access    public
         * @since     1.0
         */
        function __construct($meta_box, $type = 'category') {
            if (!is_admin())
                return;

            $this->meta_box = $meta_box;
            add_action($type . '_edit_form_fields', array(&$this, 'build_meta_box_edit'), 10, 2);
            add_action($type . '_add_form_fields', array(&$this, 'build_meta_box_add'), 10, 2);
            add_action('edited_' . $type, array(&$this, 'save_meta_box'), 10, 2);
            add_action('create_' . $type, array(&$this, 'save_meta_box'), 10, 2);            
            add_action('delete_' . $type, array(&$this, 'delete_tax'), 10, 2);     
            
            //pri importu dema neukladej metaboxy       
            add_action('import_start', array(&$this, 'deregister_save'),12);
            
        }
        
        function deregister_save(){
            remove_action('save_post', array(&$this, 'save_meta_box'), 10, 2);
        }

        function build_meta_box_add($tag) {
            wp_nonce_field(basename(__FILE__), 'tax_meta_class_nonce');

            if (isset($tag->term_id))
                $id = $tag->term_id;
            else
                $id = 0;

            // security reason
            $outputs = '<input type="hidden" id="jaw_security" name="jaw_security" attr="false" value="' . wp_create_nonce('of_ajax_nonce') . '" />';

            foreach ($this->meta_box['fields'] as $field) {
                if (isset($field['id'])) {
                    $value = jwOpt::get_option($field['id'], null, 'category', $id);
                } else {
                    $value = '';
                }
                $outputs .= jwElements::render_metatax($field, $value, 'add');
            }
            echo $outputs;
        }

        function build_meta_box_edit($tag) {
            wp_nonce_field(basename(__FILE__), 'tax_meta_class_nonce');

            if (isset($tag->term_id))
                $id = $tag->term_id;
            else
                $id = 0;

            // security reason
            $outputs = '<input type="hidden" id="jaw_security" name="jaw_security" attr="false" value="' . wp_create_nonce('of_ajax_nonce') . '" />';

            foreach ($this->meta_box['fields'] as $field) {
                if (isset($field['id'])) {
                    $value = jwOpt::get_option($field['id'], null, 'category', $id);
                } else {
                    $value = '';
                }
                $outputs .= jwElements::render_metatax($field, $value, 'edit');
            }
            echo $outputs;
        }

        /**
         * Saves the meta box values
         *
         * @return    void
         *
         * @access    public
         * @since     1.0
         */
        function save_meta_box($term_id) {
            $cat_meta = array();
            if (isset($_POST['taxonomy'])) {
                $taxnow = $_POST['taxonomy'];


                if (!isset($term_id)       // Check Revision
                        || (!in_array($taxnow, $this->meta_box['pages']) )       // Check if current taxonomy type is supported.
                        || (!check_admin_referer(basename(__FILE__), 'tax_meta_class_nonce') )    // Check nonce - Security
                        || (!current_user_can('manage_categories') )) {   // Check permission
                    return $term_id;
                }

                if (isset($_POST) && $term_id) {
                    $t_id = $term_id;
                    $data = jwOpt::get_options('category');

                    $header = array();
                    
                    jwOpt::unlogPreset('color', 'tax', $t_id);
                    jwOpt::unlogPreset('color', 'revotax', $t_id);
                    jwOpt::unlogPreset('color', 'tax', 'tax-header-'.$t_id);
                    jwOpt::unlogPreset('category', 'tax',  $t_id );
                    jwOpt::unlogPreset('single', 'tax',  $t_id);
                    foreach ($this->meta_box['fields'] as $field) {
                        if (!isset($field['id'])) {
                            continue;
                        }
                        if (isset($_POST[$field['id']])) { // save value
                            $cat_meta[$field['id']] = stripslashes($_POST[$field['id']]);
                        } else if ($field['std']) { // save default value
                            $cat_meta[$field['id']] = $field['std'];
                        }
                        
                        if (substr($field['id'], -6) == '_color') {
                            jwOpt::logPreset('color', 'tax', $t_id ,0 ,$field['id'] ,$cat_meta[$field['id']]);
                        }

                        if ($field['type'] == 'simple_media_picker') {
                            $cat_meta[$field['id']] = stripslashes($cat_meta[$field['id']]);
                        }

                        if ((isset($cat_meta[$field['id']]) && $cat_meta[$field['id']] != '')) {
                            if ($field['id'] == 'title_text_color') {
                                $header[] = $cat_meta[$field['id']];
                            } else if ($field['id'] == 'title_bg_img') {
                                $img = json_decode($cat_meta[$field['id']]);
                                if (isset($img[0]->url)) {
                                    $header[] = '"' . $img[0]->url . '"';
                                }
                            }
                        }
                    }
                    if(isset($_POST['jaw_category_preset'])){
                        $preset = stripslashes($_POST['jaw_category_preset']);
                        jwOpt::savePreset($preset, 'category');
                        unset($_POST['jaw_category_preset']);
                    }
                    if(isset($_POST['jaw_single_preset'])){
                        $preset = stripslashes($_POST['jaw_single_preset']);
                        jwOpt::savePreset($preset, 'single');
                        unset($_POST['jaw_single_preset']);
                    }
                                       
                    if(isset($cat_meta['featured_content_revo'])){
                        $featured_content_revo = $cat_meta['featured_content_revo'];
                        $cat_meta['featured_content_revo_shortcodes'] =  json_decode($featured_content_revo);
                        $cat_meta['featured_content_revo'] = (maybe_serialize($cat_meta['featured_content_revo_shortcodes']));
                        $cat_meta['featured_content_revo_shortcodes'] = jwBuilder::jwPbSave(json_decode(stripslashes($featured_content_revo)),'tax',$t_id);                    
                    }
                    if(isset($cat_meta['featured_top_revo'])){                        
                        $featured_top_revo = $cat_meta['featured_top_revo'];
                        $cat_meta['featured_top_revo_shortcodes'] =  json_decode($featured_top_revo);
                        $cat_meta['featured_top_revo'] = (maybe_serialize($cat_meta['featured_top_revo_shortcodes']));
                        $cat_meta['featured_top_revo_shortcodes'] = jwBuilder::jwPbSave(json_decode(stripslashes($featured_top_revo)),'tax',$t_id);
                    }

                    if(isset($_POST['category_preset'])){
                        jwOpt::logPreset('category', 'tax',  $t_id ,0, 'category_preset',$_POST['category_preset']);
                    }
                    if(isset($_POST['single_preset'])){
                        jwOpt::logPreset('single', 'tax',  $t_id ,0, 'single_preset',$_POST['single_preset']);
                    }
                    
                    if (sizeof($header) == 2 && isset($_POST['cat_title_bar']) && $_POST['cat_title_bar'] == '2') {
                         jwOpt::logPreset('color', 'tax',  'tax-header-'.$t_id ,0, 'cat_head_color',$header);
                    }
                    $data['category_' . $term_id] = $cat_meta;
                    jwOpt::update_option($data, 'category');
                    //vygeerovani barvicek
                    do_action('jaw_generate_styles', 'color');
                }
            }
        }      
        
        public function delete_tax($t_id){
            jwOpt::unlogPreset('color', 'tax', 'tax-header-'.$t_id);
            jwOpt::unlogPreset('color', 'revotax', $t_id);
            jwOpt::unlogPreset('category', 'tax',  $t_id );
            jwOpt::unlogPreset('single', 'tax',  $t_id);
            jwOpt::unlogPreset('color', 'tax', $t_id);
        } 

    }

}
