<?php

/**
 * This class loads all the methods and helpers specific to build a meta box.
 * 
 * @author JaW Templates <http://www.jawtemplates.com>
 * @copyright (c) 2013, CCB, spol. s r.o.
 * @version 1.0
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

if (!class_exists('jwMetabox')) {

    class jwMetabox {
        /* variable to store the meta box array */

        private $meta_box;
        
        /**
         * PHP5 constructor method.
         *
         * This method adds other methods of the class to specific hooks within WordPress.
         * 
         * @uses      add_action()
         *
         * @return    void
         *
         * @access    public
         * @since     1.0
         */
        function __construct($meta_box) {
            if (!is_admin())
                return;

            $this->meta_box = $meta_box;
            add_action('add_meta_boxes', array(&$this, 'add_meta_boxes'));
            add_action('save_post', array(&$this, 'save_meta_box'), 10, 2);
            add_action('delete_post',  array(&$this, 'delete_post'), 10 );
            
        }
        
        
        
        /**
         * id ,title,array(pages),
         */

        /**
         * Adds meta box to any post type
         *
         * @uses      add_meta_box()
         *
         * @return    void
         *
         * @access    public
         * @since     1.0
         */
        function add_meta_boxes() {
            foreach ((array) $this->meta_box['pages'] as $page) {
                add_meta_box($this->meta_box['id'], $this->meta_box['title'], array(&$this, 'build_meta_box'), $page, $this->meta_box['context'], $this->meta_box['priority']);
            }
        }

        /**
         * Meta box view
         *
         * @return    string
         *
         * @access    public
         * @since     1.0
         */
        function build_meta_box($post, $metabox) {
            $outputs = $menu = $defaults = '';
            if (isset($this->meta_box['js']) && !empty($this->meta_box['js'])) {
                echo '<script type="text/javascript">';
                echo ($this->meta_box['js']);
                echo '</script>';
            }
            echo '<div class="ot-metabox-wrapper" id="jaw_metabox-' . $this->meta_box['id'] . '" ng-controller="jwEditorController"> ';
            /* Use nonce for verification */
            echo '<input type="hidden" name="' . $this->meta_box['id'] . '_nonce" value="' . wp_create_nonce($this->meta_box['id']) . '" />';

            /* meta box description */
            echo isset($this->meta_box['desc']) ? '<div class="description" style="padding-top:10px;">' . htmlspecialchars_decode($this->meta_box['desc']) . '</div>' : '';


            /* get the option HTML */
            /*
             * ID v metaboxes [fields] musí být s podtržítkem na začátku
             */
            foreach ($this->meta_box['fields'] as $filed) {
                if (isset($filed['id'])) {
                    $data = get_post_meta($post->ID, $filed['id'], true);
                } else {
                    $data = '';
                }
                if ($data == '')
                    $data = null;
                if (isset($filed['template']) && $filed['template'] == 'true') {
                    $layout = 'template';
                } else {
                    $layout = 'metabox';
                }
                $outputs.= jwElements::elements_machine($filed, $data, $layout);

            }
            echo '<div class="metaboxes" >';
            echo $outputs;
            echo '<div class="clear"></div>';
            echo '</div>';
            echo '<div class="clear"></div>';
            echo '</div>';
        }

        /**
         * Saves the meta box values
         *
         * @return    void
         *
         * @access    public
         * @since     1.0
         */
        function save_meta_box($post_id, $post_object) {
            global $pagenow;
            /* savng menu dont need these options */
            if($post_object->post_type == 'nav_menu_item'){
                return $post_id;
            }
            /* don't save during quick edit */
            if ($pagenow == 'admin-ajax.php')
                return $post_id;

            /* don't save during autosave */
            if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
                return $post_id;

            if (empty($_POST)) {
                return $post_id;
            }

            /* don't save if viewing a revision */
            if (isset($post_object->post_type) && $post_object->post_type == 'revision')
                return $post_id;

            /* verify nonce */
            if (isset($_POST[$this->meta_box['id'] . '_nonce']) && !wp_verify_nonce($_POST[$this->meta_box['id'] . '_nonce'], $this->meta_box['id']))
                return $post_id;

            /* check permissions */
            if (isset($_POST['post_type']) && 'page' == $_POST['post_type']) {
                if (!current_user_can('edit_page', $post_id))
                    return $post_id;
            } else {
                if (!current_user_can('edit_post', $post_id))
                    return $post_id;
            }
            $header = array();
            
            jwOpt::unlogPreset('color', 'sng', $post_id);
            jwOpt::unlogPreset('single', 'sng',  $post_id);
            
            foreach ($this->meta_box['fields'] as $field) {
                if (!isset($field['id'])) {
                    continue;
                }
                $old = get_post_meta($post_id, $field['id'], true);
                $old = '';
                $new = '';

                /* there is data to validate */
                if (isset($_POST[$field['id']])) {
                    /* set up new data with validated data */
                    $new = ($_POST[$field['id']]);
                }

                update_metadata('post',$post_id, $field['id'], $new);

                //post title==============================
                if ($field['id'] == 'jaw_page_title_text_clr') {
                    $header[] = $new;
                } else if ($field['id'] == 'jaw_page_title_bg_img') {
                    $img = json_decode(stripslashes($new));
                    if (isset($img[0]->url)) {
                         $header[] = '"' . $img[0]->url . '"';
                    }
                }
                //Post title end ==========================


                if (substr($field['id'], -6) == '_color') {
                    jwOpt::logPreset('color', 'sng',  $post_id ,0, $field['id'],$new);
                }
            }
            //color preset============================= 
            if (isset($this->meta_box['id']) && $this->meta_box['id'] == 'jawmetapage') {
                if (sizeof($header) == 2 && isset($_POST['jaw_page_title_bar']) && $_POST['jaw_page_title_bar'] == '2') {
                    jwOpt::logPreset('color', 'sng', 'sng-header-'.$post_id , 0, 'sng_head_color', $header);     
                }else{
                    jwOpt::unlogPreset('color', 'sng', 'sng-header-'.$post_id );
                }
            }
            if(isset($_POST['jaw_single_preset'])){
                $preset = stripslashes($_POST['jaw_single_preset']);
                jwOpt::savePreset($preset,'single');
                unset($_POST['jaw_single_preset']);
            }
            if(isset($_POST['jaw_single_preset_val'])){
                jwOpt::logPreset('single', 'sng',  $post_id ,0, 'jaw_single_preset_val',$_POST['jaw_single_preset_val']);
            }
            if(isset($_POST['jaw_page_color'])){
                jwOpt::logPreset('color', 'sng',  $post_id ,0, 'jaw_page_color',$_POST['jaw_page_color']);
            }
            //SAVE page builder===========
            if (isset($this->meta_box['type']) && $this->meta_box['type'] == 'page_builder') {

                if (isset($_POST['jaw_pb_startup'])) {
                    $a = update_metadata('post',$post_id, 'jaw_pb_startup', $_POST['jaw_pb_startup']);
                }

                
                $old = get_post_meta($post_id, 'jaw_pb', true);
                $jaw_pb = '';

                if (isset($_POST['jaw_pb'])) {
                    $jaw_pb = $_POST['jaw_pb'];
                    $jaw_pb_shortcode = json_decode(stripslashes($jaw_pb));
                    $jaw_pb = addslashes(maybe_serialize($jaw_pb_shortcode));  //kvuli specialnim znakum

                    jwOpt::unlogPreset('color', 'revo', $post_id);
                    $jaw_pb_shortcode = jwBuilder::jwPbSave($jaw_pb_shortcode,'', get_the_ID());
                    
                    $jaw_pb_layout = $jaw_pb_shortcode['layout'];
                    unset($jaw_pb_shortcode['layout']);
                 
                    update_metadata('post',$post_id, 'jaw_pb', $jaw_pb);
                    update_metadata('post',$post_id, 'jaw_pb_layout', $jaw_pb_layout);
                    if(isset($jaw_pb_shortcode['1_header'])){
                        update_metadata('post',$post_id, 'jaw_pb_shortcode_header', addslashes($jaw_pb_shortcode['1_header']));
                    }
                    if(isset($jaw_pb_shortcode['2_content'])){
                        update_metadata('post',$post_id, 'jaw_pb_shortcode_content', addslashes($jaw_pb_shortcode['2_content']));
                    }                    
                }
            }  
            // nerendrovat pri ukladani revize
            if (isset($post_object->post_type) && $post_object->post_type != 'revision'){
                do_action('jaw_generate_styles', 'color');        
            }
        }
        
       /**
        * Pri mazani postu se smazou logy o barvach z databaze
        *
        */
        function delete_post($id){
            jwOpt::unlogPreset('color', 'sng', 'sng-header-'.$id);
            jwOpt::unlogPreset('color', 'sng', $id );
            jwOpt::unlogPreset('single', 'sng', $id );
        }

    }
}
