<?php
if (!class_exists('jwRating')) {

    class jwLikes {

        public function __construct() {
            add_action('wp_ajax_jwlikes_vote', array(&$this, 'jwlikes_vote'));
            add_action('wp_ajax_nopriv_jwlikes_vote', array(&$this, 'jwlikes_vote'));
        }

        public function jwlikes_vote() {

            if (!isset($_POST['data']['postId']) || !isset($_POST['data']['ratingType']) || !isset($_POST['data']['ratingName']) || !isset($_POST['data']['score'])) {
                die(); //pokud nedostanu data tak vratim nic
            }

            $postId = $_POST['data']['postId'];
            $ratingType = $_POST['data']['ratingType'];
            $ratingName = $_POST['data']['ratingName'];
            $score = $_POST['data']['score']*20;


            $ratingNew = self::userVote($postId,  $ratingType, $ratingName, $score);
            echo json_encode($ratingNew[$ratingType]);

            die();  // must be used, by wordpress
        }

        public static function userVote($postId, $ratingType, $ratingName, $score) {
            $ratings = maybe_unserialize(get_post_meta($postId, 'jaw_rating', TRUE));
            if (!empty($ratings[$ratingType])) {
                $weight = $ratings[$ratingType]['weight'];
                $value = $ratings[$ratingType]['value'];

                $newValue = ($value * $weight + $score) / ($weight + 1);
                $weight++;
                $rating[$ratingType]['weight'] = $weight;
                $rating[$ratingType]['value'] = $newValue;
                $rating[$ratingType]['name'] = $newValue;
                $rating[$ratingType]['type'] = $ratingType;
            } else {
                $rating = array($ratingType => array(
                        'value' => $score,
                        'type' => $ratingType,
                        'weight' => 1,
                        'name' => $ratingName
                    )
                );
                $weight = 1;
            }
            update_post_meta($postId, 'jaw_rating', sanitize_text_field(serialize($rating)));
            update_post_meta($postId, 'jaw_rating_value', $weight);
            return($rating);
        }

        public static function getUserDefault($type = '', $name = '') {
            $out = array($type => array(
                    'type' => $type,
                    'value' => 0,
                    'weight' => 0,
                    'name' => $name
                )
            );
            return $out;
        }

    }

} 