<?php
/**
* Get layout for page/post/gallery/homepage,forntpage
*
* @author JaW Templates <http://www.jawtemplates.com>
* @copyright (c) 2013, CCB, spol. s r.o.
* @version 1.0
*/
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class jwSidebarsData {
    
    public $layout;
    public $class;
    public $sidebar;
    public $width = 3;
    
}

if (!class_exists('jwLayout')) {
    
    class jwLayout {
        
        // default initialization: fullwidth
        private static $_init = false;
        private static $_sidebars = array();
        private static $_sidebar_width = array();
        private static $_content_width = 12;
        public static $_content_layout = 'fullwidth_sidebar';
        
        function __construct() {
            self::get();
        }
        
        //============================== CONFIG ===============================¨
        
        public static function get(){
            if (is_home()) {
                self::get_layout(array('opt' => 'blog_preset'), 'category');
            } else if (function_exists('is_buddypress') && is_buddypress()) {
                self::$_content_width = 12;
                $layout = jwOpt::get_option('buddy_press_layout','fullwidth');
                if($layout == 'fullwidth'){
                    $content_layout = array('fullwidth');
                    $layout = array();
                }else{
                    $layout = explode('_',$layout);
                    $content_layout = array();        
                }
                foreach ((array) $layout as $lay) {
                    self::$_sidebars[$lay] = new jwSidebarsData();
                    $width = jwOpt::get_option('buddy_press_sidebar_'.$lay.'_size','2');
                    self::$_sidebars[$lay]->sidebar = jwOpt::get_option('buddy_press_sidebar_'.$lay,'');
                    self::$_sidebars[$lay]->layout = $lay . '-sidebar';
                    self::$_sidebars[$lay]->width = $width;

                    $class = array();
                    $class[] = esc_attr($lay . '-sidebar');
                    $class[] = esc_attr(jwOpt::get_option('fixed_sidebars', 'fixed_on'));
                    $class[] = esc_attr(self::col_class($width));
                    
                    $preset = jwOpt::get_option('buddy_press_sidebar_'.$lay.'_color','_default');
                    $class[] = esc_attr('sidebars-preset-' . jwOpt::checkDefaultPreset(array($preset, jwOpt::get_option('sidebars_color', '_default'), jwOpt::get_option('main_color', '')), 'color'));
                    
                    $bar_type = jwOpt::get_option('buddy_press_sidebar_'.$lay.'_header_style','_default');
                    $class[] = esc_attr(jwOpt::checkDefault(array($bar_type, jwOpt::get_option('sidebars_bar_type', 'bar_type_3'), jwOpt::get_option('global_header_style', ''))));
                        
                    self::$_sidebars[$lay]->class = esc_attr(implode(' ',$class));
                        
                    $content_layout[] = esc_attr($lay);
                    self::$_content_width = self::$_content_width - $width;
                }
                self::$_content_layout = implode('_', $content_layout) . '_sidebar';
            } else if (is_page()) { // post type PAGE
                // REVOCOMPOSER
                if (get_post_meta(get_the_ID(), 'jaw_pb_startup', 'true') == 'true') {
                    self::$_content_width = 12;
                    $layout = maybe_unserialize(get_post_meta(get_the_ID(), 'jaw_pb_layout', true));
                    $content_layout = array();
                    foreach ((array) $layout as $key => $l) {
                        if(isset($l->visible) && $l->visible == 'true'){
                            self::$_sidebars[$key] = new jwSidebarsData();
                            $width = $l->size;
                            if (isset($l->metabox->build_sidebar)) {
                                self::$_sidebars[$key]->sidebar = $l->metabox->build_sidebar;
                            } else {
                                self::$_sidebars[$key]->sidebar = '';
                            }
                            self::$_sidebars[$key]->layout = $key . '-sidebar';
                            
                            self::$_sidebars[$key]->width = $width;

                            $class = array();
                            $class[] = esc_attr($key . '-sidebar');
                            $class[] = esc_attr(jwOpt::get_option('fixed_sidebars', 'fixed_on'));
                            $class[] = esc_attr(self::col_class($width));
                            if (isset($l->metabox->show_on_devices)) {
                                $class[] = esc_attr('show-on-'.$l->metabox->show_on_devices);
                            }
                            $preset = '_default';
                            if (isset($l->metabox->sidebar_color)) {
                                $preset = $l->metabox->sidebar_color;
                            }
                            $class[] = esc_attr('sidebars-preset-' . jwOpt::checkDefaultPreset(array($preset, jwOpt::get_option('sidebars_color', '_default'), jwOpt::get_option('main_color', '')), 'color'));
                                
                                $bar_type = '_default';
                                if (isset($l->metabox->bar_type_widgets)) {
                                    $bar_type = $l->metabox->bar_type_widgets;
                            }
                            $class[] = esc_attr(jwOpt::checkDefault(array($bar_type, jwOpt::get_option('sidebars_bar_type', 'bar_type_3'), jwOpt::get_option('global_header_style', ''))));
                                
                                self::$_sidebars[$key]->class = esc_attr(implode(' ',$class));
                                
                                
                                $content_layout[] = $key;
                                self::$_content_width = self::$_content_width - $width;
                        }
                    }
                    self::$_content_layout = esc_attr(implode('_', $content_layout) . '_sidebar');
                    
                } else {
                    //STANDART PAGE
                    self::$_content_width = 12;
                    self::$_content_layout = 'fullwidth' . '_sidebar';
                }
            } else if (is_single()) { // all post type (post, portfolios, taxonomies and slidies....)
                // V getu je posloupnost rozhodovani, pri nacitani sidebaru
                $hierarchy = array();
                
                $hierarchy['post-' . get_the_ID()] = 'jaw_single_preset_val';
                $cat = get_the_category();
                
                if (isset($cat[0]->term_id)) {
                    $hierarchy[esc_attr('cat-' . $cat[0]->term_id)] = 'single_preset';
                }
                $hierarchy['opt'] = 'single_preset';
                self::get_layout($hierarchy, 'single');
            } else if (is_archive() || is_search() || is_date() || is_author()) {
                global $wp_query;
                // V getu je posloupnost rozhodovani, pri nacitani sidebaru
                $hierarchy = array();
                if (is_category()) {
                    if (isset($wp_query->query_vars['cat'])) {
                        $cat = $wp_query->query_vars['cat'];
                        $hierarchy[esc_attr('cat-' . $cat)] = 'category_preset';
                    }
                }
                $hierarchy['opt'] = 'archive_preset';
                self::get_layout($hierarchy, 'category');
            } else if (is_404()) {
                self::get_layout(array('opt' => 'archive_preset'), 'category');
            }
            self::$_init = true;
        }
        
        
        
        // =========================== AUTOMAT =========================================
        
        /**
        * vraci sirku contentu napr 8,9,6 ...
        */
        public static function content_width() {
            if (!self::$_init)
                self::get();
            return self::$_content_width;
        }
        
        /**
        * Vraci classy pro content napr col-lg8, col-sm-8 a col-8
        */
        public static function content_class() {
            if (!self::$_init)
                self::get();
            
            $class = '' . ' ';
            $class .= 'col-lg-' . self::$_content_width . ' ';
            $class .= 'col-md-' . self::$_content_width . ' ';
            $class .= 'col-sm-12' . ' ';
            $class .= 'col-xs-12' . ' ';
            return esc_attr($class);
        }
        
        /**
        * Vraci class s coly
        */
        public static function col_class($cols) {
            if(is_array($cols)) {
                if(count($cols) == 4) {
                    $class = '' . ' ';
                    $class .= 'col-lg-' . $cols[0] . ' ';
                    $class .= 'col-md-' . $cols[1] . ' ';
                    $class .= 'col-sm-' . $cols[2] . ' ';
                    $class .= 'col-xs-' . $cols[3] . ' ';
                } else {
                    die("You need add at least ". (4 - count($cols)).' more');
                }
            } else {
                $class = '' . ' ';
                $class .= 'col-lg-' . $cols . ' ';
                $class .= 'col-md-' . $cols . ' ';
                $class .= 'col-sm-' . 12 . ' ';
                $class .= 'col-xs-' . 12 . ' ';
            }
            return esc_attr($class);
        }
        
        /**
        * Vraci nazev layoutu napr fullwidth_sidebar nebo left1_sidebar
        */
        public static function content_layout() {
            if (!self::$_init)
                self::get();
            return self::$_content_layout;
        }
        
        public static function sidebar_width() {
            if (!self::$_init)
                self::get();
            return self::$_sidebar_width;
        }
        
        public static function sidebars() {
            if (!self::$_init)
                self::get();
            return self::$_sidebars;
        }
        
        /**
        * Zjisteni layoutu a informaci o sidebarech dle zadanych parametru
        *
        * $hierarchy = array(
        *  'typ' napr. opt, cat-15, post-158, ...
        *      =>  nazev optionu kde je ulozen nazev presetu
        * )
        */
        private static function get_layout($hierarchy = array(), $preset_type) {
            //projdu celou hierarchii - dokud nenajdu preset
            $preset = self::get_preset_for_layout($hierarchy,$preset_type);
            if(is_home()){
                $default = "right1";
            }else{
                $default = "fullwidth";
            }
            // z presetu vytahnu layout
            $layout = jwOpt::getPresetValue('layout', $default, $preset_type, $preset);
            
            //classa pro content
            self::$_content_layout = $layout . '_sidebar';
            
            //defaultni sirka contentu z ktere budu odcitat sirku sidebaru
            self::$_content_width = 12;
            
            if ($layout != 'fullwidth') {
                
                $layout = explode('_', $layout);
                
                //nactu data pro jednotlive sidebary
                foreach ((array) $layout as $key => $l) {
                    
                    self::$_sidebars[$key] = new jwSidebarsData();
                    
                    $sidebar = '';
                    $width = 3;
                    $type = key($hierarchy);
                    $name = reset($hierarchy);
                    $type = explode('-', $type);
                    $width = jwOpt::getPresetValue('sidebar_' . $l . '_size', '3', $preset_type, $preset);
                    self::$_sidebars[$key]->sidebar = jwOpt::getPresetValue('sidebar_' . $l, 'default-sidebar', $preset_type, $preset);
                    self::$_sidebars[$key]->width = $width;
                    self::$_content_width = self::$_content_width - $width;
                    self::$_sidebars[$key]->layout = $l . '-sidebar';

                    $color_dependency = array();
                    if (isset($type[0])) {
                        $color_dependency[] = jwOpt::getPresetValue('sidebar_' . $l . '_color', '', $preset_type, $preset);
                        if ($type[0] == 'cat'  && isset($type[1])) {
                            $color_dependency[] = jwOpt::get_option('content_color', '', 'category', $type[1]);
                        }
                        if ($preset_type == "single") {
                            $category_preset = array_keys($hierarchy);
                            if(!empty($category_preset[1])){
                                $category_preset = explode('-', $category_preset[1]);
                                if(!empty($category_preset[1])){
                                    $color_dependency[] = jwOpt::get_option('content_color', '', 'category', $category_preset[1]);
                                }
                            }
                        }
                        $color_dependency[] = jwOpt::get_option('main_color', '');
                        $color = jwOpt::checkDefaultPreset((array) $color_dependency, 'color');
                        $class = $l . '-sidebar' . ' ';
                        $class .= jwOpt::get_option('fixed_sidebars', 'fixed_on') . ' ';
                        $class .= self::col_class($width);
                        $class .= 'sidebars-preset-' . $color . ' ';
                        $class .= jwOpt::getPresetValue('sidebar_' . $l . '_header_style', jwOpt::checkDefault(array(jwOpt::get_option('sidebars_bar_type', 'bar_type_3'), jwOpt::get_option('global_header_style', ''))), $preset_type, $preset);
                        self::$_sidebars[$key]->class = esc_attr($class);
                        }
                    }
                }
            }
            
            private static function get_preset_for_layout(&$hierarchy, $preset_type) {
                $presets_hierarchy = array();
                
                foreach ((array) $hierarchy as $k => $name) {
                    if (isset($name)) {
                        
                        $value = '';
                        //v key je obdsazeno i ID kategorie nebo postu - proto to rozdelim
                        $type = explode('-', $k);
                        $type = explode('-', $k);
                        //Nastaveni defaultnich hodnot.
                        if (!isset($type[0])) {
                            echo 'In layout is problem. Please check your settings.';
                            $type[0] = '';
                        }
                        if (!isset($type[1])) {
                            $type[1] = 0;
                        }
                        //nactu data dle preferenci
                        switch ($type[0]) {
                            
                            case 'opt': //pokud mam cist z Theme Options
                                $value = jwOpt::get_option($name, '');
                                break;
                            case 'cat': //pokud mam cist z Category options
                                $value = jwOpt::get_option($name, '', 'category', $type[1]);
                                break;
                            case 'post': //pokud ctu ze singlu
                                $value = get_post_meta($type[1], $name, true);
                            break;
                            
                            if ($value == '') {
                                $value = '_default';
                            }
                    }
                    
                    $presets_hierarchy[] = $value;
                }
             }
        $preset = jwOpt::checkDefaultPreset($presets_hierarchy, $preset_type);
        return $preset;
    }
    
    // debug mod
    static function debug() {
        ob_start();
        ?>
        <ul>
            <li>Content width:
            <?php var_dump(self::$_content_width); ?>
            </li>
            <li>Sidebar:
            <?php var_dump(self::$_sidebars); ?>
            </li>
            <li>Sidebar width:
            <?php var_dump(self::$_sidebar_width); ?>
            </li>
            <li>Content Layout:
            <?php var_dump(self::$_content_layout); ?>
            </li>
        </ul>
        <?php
        echo ob_get_clean();
    }
    
}

}