<?php

/*
* v 1.1
* oprava list - textare
*
*/

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

if (!class_exists('jwInterest')) {
    
    class jwInterest {
        
        public static function bootstrap() {
            
            // Interest content - ajax
            add_action('wp_ajax_jaw_discussion', array('jwInterest', 'featuredDiscussion'));
            add_action('wp_ajax_nopriv_jaw_discussion', array('jwInterest', 'featuredDiscussion'));
            
            add_action('wp_ajax_jaw_comentator', array('jwInterest', 'featuredComentator'));
            add_action('wp_ajax_nopriv_jaw_comentator', array('jwInterest', 'featuredComentator'));
            
            add_action('wp_ajax_jaw_featured_post', array('jwInterest', 'featuredPost'));
            add_action('wp_ajax_nopriv_jaw_featured_post', array('jwInterest', 'featuredPost'));
                        
            add_action('wp_ajax_jaw_user_settings', array('jwInterest', 'userContentManagment'));
            add_action('wp_ajax_nopriv_jaw_user_settings', array('jwInterest', 'userContentManagment'));
            
            add_action('wp_ajax_jaw_user_clear_history', array('jwInterest', 'clearVisitedPost'));
            add_action('wp_ajax_nopriv_jaw_user_clear_history', array('jwInterest', 'clearVisitedPost'));
            
            add_action('wp_ajax_jaw_user_get_content', array('jwInterest', 'getContent'));
            add_action('wp_ajax_nopriv_jaw_user_get_content', array('jwInterest', 'getContent'));           
            
            add_action('wp', array('jwInterest', 'visitedPost'));
        }
        
        /**
        * AJAX callback - ulozeni dat o zajimavých komentářích
        *
        *
        */
        public static function featuredDiscussion() {
            $val = 'false';
            if (is_user_logged_in() && isset($_POST['interest']) && isset($_POST['value'])) {
                
                $interest = $_POST['interest'];
                $val = $_POST['value'];
                
                $userID = get_current_user_id();
                $meta = get_user_meta($userID, 'jaw_interest_comments', true);
                if (!is_array($meta)) {
                    $meta = array();
                }
                if (empty($meta['posts'])) {
                    $meta['posts']= array();
                }
                
                if ($val == 'true') {
                    array_push($meta['posts'], $interest);
                } else if (in_array($interest, $meta['posts'])) {
                    $key = array_search($interest, $meta['posts']);
                    unset($meta['posts'][$key]);
                }
                
                update_user_meta($userID, 'jaw_interest_comments', $meta);
            }
            
            echo esc_attr($val);
            die();
        }
        
        
        /**
        * AJAX callback - ulozeni dat o zajimavých komentujicich
        *
        *
        */
        public static function featuredComentator() {
            $val = 'false';
            if (is_user_logged_in() && isset($_POST['interest']) && isset($_POST['value'])) {
                
                $interest = $_POST['interest'];
                $val = $_POST['value'];
                
                $userID = get_current_user_id();
                $meta = get_user_meta($userID, 'jaw_interest_comments', true);
                if (!is_array($meta)) {
                    $meta = array();
                }
                if (empty($meta['authors'])) {
                    $meta['authors']= array();
                }
                
                if ($val == 'true') {
                    array_push($meta['authors'], $interest);
                } else if (in_array($interest, $meta['authors'])) {
                    $key = array_search($interest, $meta['authors']);
                    unset($meta['authors'][$key]);
                }
                
                update_user_meta($userID, 'jaw_interest_comments', $meta);
            }
            
            echo esc_attr($val);
            die();
        }
        
        /**
        * AJAX
        * pridani / oddelani postu z oblibenyhc
        *
        */
        public static function featuredPost() {
            $val = 'false';
            if (is_user_logged_in() && isset($_POST['interest']) && isset($_POST['value'])) {
                
                $interest = $_POST['interest'];
                $val = $_POST['value'];
                
                $userID = get_current_user_id();
                $meta = get_user_meta($userID, 'jaw_featured_posts', true);
                if (!is_array($meta)) {
                    $meta = array();
                }
                
                if ($val == 'true') {
                    array_push($meta, $interest);
                } else if (in_array($interest, $meta)) {
                    $key = array_search($interest, $meta);
                    unset($meta[$key]);
                }
                
                update_user_meta($userID, 'jaw_featured_posts', $meta);
            }
            
            echo esc_attr($val);
            die();
        }
        
        
        /**
        * ulozi user data pro cilenej obsah
        *
        * @param type $variable
        */
        public static function userContentManagment($variable) {
            if (isset($_POST)) {
                $variable = $_POST;
            }
            
            $userID = get_current_user_id();
            
            // Ulozim data o zajimavych postech
            $meta_posts = get_user_meta($userID, 'jaw_interest_posts', true);
            if (empty($meta_posts) || !is_array($meta_posts)) {
                $meta_posts = array();
            }
            
            // Ulozim data o zajimavych komentarich
            $meta_comments = get_user_meta($userID, 'jaw_interest_comments', true);
            if (empty($meta_comments) || !is_array($meta_comments)) {
                $meta_comments = array();
            }
            
            if (isset($variable['value'])) {
                
                $meta_posts['cat'] = array();
                $meta_posts['tag'] = array();
                $meta_posts['user'] = array();
                $meta_posts['posts'] = array();
                $meta_posts['authors'] = array();
                
                foreach ((array) $variable['value'] as $value) {
                    $typ = substr($value['name'], 0, 3);
                    preg_match('/(.*?)\[(.*?)\]/',$value['name'],$match);
                    if(sizeof($match) == 3){
                        switch ($match[1]) {
                            case 'cat':$meta_posts['cat'][] = $match[2];
                            break;
                            case 'tag':$meta_posts['tag'][] = $match[2];
                            break;
                            case 'usr':$meta_posts['user'][] = $match[2];
                            break;
                            case 'pst':$meta_comments['posts'][] = $match[2];
                            break;
                            case 'com':$meta_comments['authors'][] = $match[2];
                            break;
                        }
                    }
                }
            }
            
            update_user_meta($userID, 'jaw_interest_posts', $meta_posts);
            
            update_user_meta($userID, 'jaw_interest_comments', $meta_comments);
            
            die();
        }
        
        /**
        * Po navstiveni postu se post prida do navstivenych
        *
        */
        public static function visitedPost() {
            
            if (is_single()) {
                $id = get_the_ID();
                $userID = get_current_user_id();
                $meta = get_user_meta($userID, 'jaw_visited_posts', true);
                if (!is_array($meta)) {
                    $meta = array();
                }
                $newDate = date('Y-m-d'); //datum navstevy (aktualni datum)
                $newDateConverted = new DateTime($newDate);
                $newDateConverted->modify('-1 month'); //datum pro smazani stare historie (strasi jak 1 mesic)
                
                if(isset($meta[$id])){
                    unset($meta[$id]); //vymazani predesle navstevy
                }
                $meta[$id] = $newDate;
                
                // odmazavani starych dat
                foreach ($meta as $key => $date) {
                    $dateConverted = new DateTime($date);
                    
                    if ($newDateConverted > $dateConverted) {
                        unset($meta[$key]);
                    }
                }
                update_user_meta($userID, 'jaw_visited_posts', $meta);
            }
            return;
        }
        
        /**
        * It can delete information abou all visited posts
        */
        public static function clearVisitedPost(){
            $userID = get_current_user_id();
            update_user_meta($userID, 'jaw_visited_posts', array());
            die();
        }
        
        
        /*
        * Get content of my news with AJAX
        */
        public static function getContent(){
            echo jaw_get_template_part('user_panel_content', array('header', 'user_panel'));
            die();
        }
        
    }
    
}