<?php

/**
* Class for printing fecbook commnents
*
* @authors Alexmoss, Pleer
*
* @author JaW Templates <http://www.jawtemplates.com>
* @copyright (c) 2013, CCB, spol. s r.o.
* @version 1.0
*/
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

if (!class_exists('jwFacebook')) {
    class jwFacebook {
        
        public static $options;
        
        public static function get_fb_comment() {
            
            self::$options['language'] = esc_attr(get_locale());
            self::$options['num'] = jwOpt::get_option('fbcomments_nuberofcomments');
            self::$options['fbcomments_commsg'] = esc_html__('comments','gdn-theme');
            self::$options['fbcomments_title'] = esc_html__('Comments', "gdn-theme");
            self::$options['fbcomments_appid'] = jwOpt::get_option('fbcomments_appid');
            
            echo self::fbcommentbox();   
        }
        
        public static function fbcommentbox() {
            
            $content = '';
            if (is_single() || is_page() || (is_home() || is_front_page())) {
                
                
                global $content_width;
                $commentcount = "";

                $commenttitle = "<div class='comments-title'><h3>";
                
                $commenttitle .= self::$options['fbcomments_title'] . "</h3></div>";
                
                $content .= $commenttitle . $commentcount;
                
                
                $content .= "<div class=\"fb-comments\" data-href=\"" . get_permalink() . "\" data-num-posts=\"" . esc_attr(self::$options['num']) . "\" data-width=\"100%\" ></div>";
            }
            return $content;
        }
    }
}