<?php

/**
 * Library of HTML elements. Use only in admin area
 * 
 * @author JaW Templates <http://www.jawtemplates.com>
 * @copyright (c) 2013, CCB, spol. s r.o.
 * @version 1.0
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

if (!class_exists('jwElements')) {

    class jwElements {

        public static $_layout = 'options';
        private static $_instance = null;
        private static $_search_title = '';


        public static function getInstance() {
            if (self::$_instance == null) {
                self::$_instance = new jwElements();
            }


            return self::$_instance;
        }



        public static function renderPages($options, $data) {
            $pages = '';
            foreach ($options as $opt) {
                if (isset($opt['id']) && isset($data[$opt['id']]))
                    $val = $data[$opt['id']];
                else
                    $val = null;

                $pages .= self::elements_machine($opt, $val);
            }

            return $pages;
        }

        public static function elements_render($elements, $data = null, $layout = 'default') {
            $out = '';
            foreach ($elements as $element) {
                $out .= self::elements_machine($element, $data, $layout);
            }
            return $out;
        }

        /*
         * Render element for taxonomies (Category option)
         * @param $value array
         * @param $data mixed
         * $param layout mixed (add or edit)
         */

        public static function render_metatax($value, $data = null, $layout = 'default') {

            $defaults = array();
            $menu = '';
            $output = '';



            $val = '';

            if (isset($value['type']) && !in_array($value['type'], array('headingstart', 'headingend'))) {
                $class = '';
                if (isset($value['class'])) {
                    $class = $value['class'];
                }


//only show header if 'name' value exists

                if ($value['name']) {

                    if ($value['type'] == 'section') {
                        switch ($layout) {
                            case 'edit':
                                $output .= '<tr class="form-field ' . $class . '" >';
                                $output .= '<th scope="row" colspan="2" valign="top" class="tax-' . $value['type'] . '">' . "\n";
                                break;
                            default:
                                $output .= '<div class="section jw_option tax-' . $value['type'] . ' ' . $class . ' form-field">' . "\n";
                                break;
                        }
                    } else {

                        switch ($layout) {
                            case 'edit':
                                $output .= '<tr class="form-field ' . $class . '">';
                                $output .= '<th scope="row" valign="top"><label for="' . $value['id'] . '">' . $value['name'] . '</label></th>' . "\n";
                                $output .= '<td>';
                                $output .= '<div id="section-' . self::convert($value['id']) . '" class="section jw_option section-' . $value['type'] . ' ">' . "\n";
                                break;
                            default:
                                $output .= '<div id="section-' . self::convert($value['id']) . '" class="section jw_option section-' . $value['type'] . ' ' . $class . ' form-field">' . "\n";

                                $output .= '<h4 class="heading">' . $value['name'] . '</h4>' . "\n";
                                break;
                        }
                    }
                }

                if (isset($value['space']) && $value['space'])
                    $output .= '<div class="space">&nbsp;</div>';

                $output .= '<div class="option">' . "\n" . '<div class="controls">' . "\n";
            }
            $c = "element_" . $value['type'];
            if (method_exists(get_class(), $c)) {
                $output .= jwElements::$c($value, $data);
            } else {
                $output .= 'Element not found in class_elements.php';
            }


//description of each option
            if (isset($value['type']) && $value['type'] != "headingstart" && $value['type'] != "headingend") {

                if (!isset($value['desc'])) {
                    $explain_value = '';
                } else {
                    $explain_value = '<div class="explain">' . $value['desc'] . '</div>' . "\n";
                }

                $output .= '</div><!-- end controls -->' . $explain_value . "\n";

                $output .= '<div class="clear"></div>
                </div><!-- end options -->
                </div><!-- end section jw_option -->' . "\n";

                if ($value['type'] == 'section') {
                    $output .= '</th>';
                } else if ($layout == 'edit') {
                    $output .= '</div></td></tr>';
                }
            }






            return $output;
        }

        /**
         * Process options data and build option fields
         *
         * @uses get_option()
         *
         * @access public
         * @since 1.0.0
         *
         * @return array
         */
        public static function elements_machine($value, $data = null, $layout = 'default') {

            $defaults = array();
            $menu = '';
            $output = '';



            $val = '';

            if(!empty($value['hide_if_layout']) && in_array($layout, $value['hide_if_layout'])){
                return $output;
            }
            
            if (!isset($value['type'])){
                return 'Property "type" has not been set!';
            }
            
            
//Start Heading
             if (isset($value['type']) && $value['type'] != "headingstart" && $value['type'] != "headingend" && $value['type'] != "sectionstart" && $value['type'] != "sectionend") {

//only show header if 'name' value exists
                if ($value['name']) {
                    
                    $class = '';
                    if (isset($value['class'])) {
                        $class = $value['class'];
                    }
                    $angular = array();
                    if (isset($value['ng-click'])) {
                        $angular[] = 'ng-click="'.$value['ng-click'].'"';
                    }
                    if (isset($value['ng-class'])) {
                        $angular[] = 'ng-class="'.$value['ng-class'].'"';
                    }
                    if (isset($value['ng-show'])) {
                        $angular[] = 'ng-show="'.$value['ng-show'].'"';
                    }
                    if (isset($value['ng-hide'])) {
                        $angular[] = 'ng-hide="'.$value['ng-hide'].'"';
                    }

                
                    if(!isset($value['id'])){
                        $value['id'] = 'default';
                    }
                    switch ($layout) {
                        case 'metabox':
                            $output .= '<div id="section-' . self::convert($value['id']) . '" class="section jw_option section-' . $value['type'] . ' ' . $class . '" '.implode(' ', $angular).'>' . "\n";
                            if (!isset($value['header']) || $value['header'] == true) {
                                $output .= '<h4 class="heading">' . $value['name'] . '</h4>' . "\n";
                            }
                            break;
                        case 'cat':
                            $output .= '<tr class="form-field">';
                            $output .= '<th scope="row" valign="top"><label for="' . $value['id'] . '">' . $value['name'] . '</label></th>' . "\n";
                            $output .= '<td>';
                            $output .= '<div id="section-' . self::convert($value['id']) . '" class="section jw_option section-' . $value['type'] . ' ' . $class . '" '.implode(' ', $angular).'>' . "\n";

                            break;
                        case 'default':
                        default:
                            $output .= '<div id="section-' . self::convert($value['id']) . '" class="section jw_option section-' . $value['type'] . ' ' . $class . '" '.implode(' ', $angular).'>' . "\n";
                            $output .= '<h3 class="heading">' . $value['name'] . '</h3>' . "\n";
                            break;
                    }
                    if (!isset($value['type']) || $value['type'] != 'builder') {
                        if (isset($value['space']) && $value['space'])
                            $output .= '<div class="space">&nbsp;</div>';

                        $output .= '<div class="option">' . "\n" . '<div class="controls ';
                        if ($value['type'] == 'importpreset') {
                            $output .= 'control_fw';
                        }
                        $output .= '">' . "\n";
                    }
                }
            }

            $c = "element_" . $value['type'];
            if($layout == 'shortcodes' && isset($value['shortcodes'])){
                //do nothing
            } elseif (method_exists(get_class(), $c)) {
                $output .= jwElements::$c($value, $data);
            } else {
                $output .= 'Element not found in class_elements.php';
            }


//description of each option
             if (isset($value['type']) && $value['type'] != "headingstart" && $value['type'] != "headingend" && $value['type'] != "sectionstart" && $value['type'] != "sectionend") {
                if (!isset($value['desc']) || ($value['type'] == 'builder_dropdown')) {
                    $explain_value = '';
                } else {
                    if ($layout == 'cat') {
                        $explain_value = ' <p class="description">' . $value['desc'] . '</p>' . "\n";
                    } else {
                        $explain_value = '<div class="explain">' . $value['desc'] . '</div>' . "\n";
                    }
                }


                $output .= '</div><!-- end controls -->' . $explain_value . "\n";



                $output .= '<div class="clear"></div>
                </div><!-- end options -->
                </div><!-- end section jw_option -->' . "\n";

                switch ($layout) {
                    case 'cat':
                        $output .= '</div></td></tr>';
                        break;
                }
            }

            return $output;
        }

        private static function _box() {
            
        }

        private function _layout($part, $type) {
            
        }

        public static function element_headingstart($value, $data = null) {

            $output = '';
            $jquery_click_hook = str_replace(' ', '', strtolower($value['name']));
            $jquery_click_hook = "of-option-" . $jquery_click_hook;

            $output .= '<div class="group" id="' . $jquery_click_hook . '"><h2>' . $value['name'] . '</h2>' . "\n";

            return $output;
        }

        public static function element_headingend($value, $data = null) {
            return '</div>' . "\n";
        }

        public static function element_sectionstart($value, $data = null) {
            $class = '';
            if (isset($value['class'])) {
                $class = $value['class'];
            }
            $angular = array();
            if (isset($value['ng-click'])) {
                $angular[] = 'ng-click="'.$value['ng-click'].'"';
            }
            if (isset($value['ng-class'])) {
                $angular[] = 'ng-class="'.$value['ng-class'].'"';
            }
            if (isset($value['ng-show'])) {
                $angular[] = 'ng-show="'.$value['ng-show'].'"';
            }
            $output = '';
            $output .= '<div class="section sub_all ' . $class . '" '. implode(' ', $angular).' ><h3>' . $value['name'] . '</h3>';
            $output .= '<div class="section sub" >';
            return $output;
        }

        public static function element_sectionend($value, $data = null) {
            return '</div></div>';
        }


        public static function element_changelog($value, $data = null) {

            $output = '';
            $output .= '<jwd-changelog>Loading changelog...</jwd-changelog>';

            return $output;
        }
        
        public static function element_checker($value, $data = null) {

            $output = '';
            $output .= "<jwd-themereq></jwd-themereq>";

            return $output;
        }
        
        // preview advertisement
        public static function element_preview_banner($value, $data = null) {

            $output = '';
            $banner = "";
            if(isset($value["banner"])){
                $banner = $value["banner"];
            }
            $output .= '<jwd-preview-banner banner="edit[\''.$banner.'\']"></jwd-changelog>';

            return $output;
        }
        
        
         public static function element_text($value, $data = null) {
            $output = '';
            $a_default = '';
            if (isset($data)) {
                if (is_array($data)) {
                    $data = implode(',', $data); // zpetna komatibilita - nektere metaboxy jsme predelali z multidropdownu na texty - kvuli naroscnosti na memory.
                }
                $evalue = $data;
            } else if (isset($value['std'])) {
                $evalue = $value['std'];
            } else {
                $evalue = '';
            }
            $evalue = jwUtils::json_quote_checker($evalue);
            $a_default = 'init_item(\'' . $value['id'] . '\',\'' . $evalue . '\');';
            $t_value = (string) $evalue;

            $class = '';
            if (isset($value['mod'])) {
                $class .= $value['mod'];
            }
            if (isset($value['class'])) {
                $class .= ' ' . $value['class'];
            }
            if (isset($value['maxlength'])) {
                $maxlength = 'maxlength=' . $value['maxlength'];
            } else {
                $maxlength = '';
            }
            if (!isset($value['type'])) {
                $value['type'] = 'text';
            }
            $placeholder = '';
            if (isset($value['placeholder'])) {
                $placeholder = $value['placeholder'];
            }

            $output .= '<input placeholder="' . $placeholder . '" class="of-input ' . $class . '" name="' . $value['id'] . '"  ' . $maxlength . ' id="' . self::convert($value['id']) . '" type="' . $value['type'] . '" value="' . $t_value . '" ng-model="edit[\'' . $value['id'] . '\']" ng-init="' . $a_default . '"/>';
            return $output;
        }
        
        public static function element_hidden($value, $data = null) {
            $output = '';
            $a_default = '';
            if (isset($data)) {
                $evalue = $data;
            } else if (isset($value['std'])) {
                $evalue = $value['std'];
            } else {
                $evalue = '';
            }
            $evalue = jwUtils::json_quote_checker($evalue);
            $a_default = 'init_item(\'' . $value['id'] . '\',\'' . $evalue . '\');';
            $t_value = (string) $evalue;
            
            $output .= '<input class="of-input jw-hidden" name="' . $value['id'] . '" id="' . self::convert($value['id']) . '" type="hidden" value="' . $t_value . '" ng-model="edit[\'' . $value['id'] . '\']" ng-init="' . $a_default . '"/>';
            return $output;
        }

        public static function element_icon($value, $data = null) {
            $output = '';
            $a_default = '';
            if (isset($data)) {
                if (is_array($data)) {
                    $data = implode(',', $data); // zpetna komatibilita - nektere metaboxy jsme predelali z multidropdownu na texty - kvuli naroscnosti na memory.
                }
                $evalue = $data;
            } else if (isset($value['std'])) {
                $evalue = $value['std'];
            } else {
                $evalue = '';
            }
            $evalue = jwUtils::json_quote_checker($evalue);
            $a_default = 'init_item(\'' . $value['id'] . '\',\'' . $evalue . '\');';
            $t_value = (string) $evalue;

            $class = '';
            if (isset($value['mod'])) {
                $class .= $value['mod'];
            }
            if (isset($value['class'])) {
                $class .= ' ' . $value['class'];
            }
            if (isset($value['maxlength'])) {
                $maxlength = 'maxlength=' . $value['maxlength'];
            } else {
                $maxlength = '';
            }
            if (!isset($value['type'])) {
                $value['type'] = 'text';
            }
            $output .= '<div class="show-icon" ><i class="{{edit[\'' . $value['id'] . '\']}}"></i></div>';
            $output .= '<input class="show-icon-input of-input ' . $class . '" name="' . $value['id'] . '"  ' . $maxlength . ' id="' . self::convert($value['id']) . '" type="' . $value['type'] . '" value="' . $t_value . '" ng-model="edit[\'' . $value['id'] . '\']" ng-init="' . $a_default . '"/>';
            return $output;
        }

        public static function element_list($value, $data = null) {
            $output = '';
            if (isset($data))
                $evalue = $data;
            else if (isset($value['std']))
                $evalue = $value['std'];
            else
                $evalue = '{}';

            if (isset($value['mod'])) {
                $mod = $value['mod'];
            } else {
                $mod = 'text';
            }


            $output .= '<input type="hidden"  value="{{edit[\'' . $value['id'] . '\']}}"  ng-model="edit[\'' . $value['id'] . '\']"/>';
            $output .= '<div class="list-li ' . $mod . '" ng-repeat="(ied, ed) in edit[\'' . $value['id'] . '\']">';
            if ($mod == 'text') {
                $output .= '<input class="of-input" name="' . $value['id'] . '_{{ied}}" id="' . self::convert($value['id']) . '_{{ied}}" type="text" value="{{ed.item}}"  ng-model="ed.item" />';
            } else {
                $output .= '<textarea class="of-input" name="' . $value['id'] . '_{{ied}}" id="' . self::convert($value['id']) . '_{{ied}}" type="text"   ng-model="ed.item" >{{ed.item}}</textarea>';
            }
            $output .= '<button type="button" class="list_delete_button button-primary builder red jaw" ng-click="del_edit(\'' . $value['id'] . '\',ied)" ><i class="jaw-icon-white jaw-icon-remove"></i></button>';
            $output .= '</div>';
            $output .= '<a href="#" class="button-primary blue jaw add-list" ng-click="add_edit(\'' . $value['id'] . '\', {\'item\': \'\'});"><i class="jaw-icon-white jaw-icon-plus"></i></a>';
            return $output;
        }

        public static function element_advanced_list($value, $data = null) {
            $output = '';

            if (isset($data))
                $evalue = $data;
            else if (isset($value['std']))
                $evalue = $value['std'];
            else
                $evalue = '';


            $output .= '<div class="show-icon" ><i class="{{icon}}"></i></div>';
            $output .= '<input class="show-icon-input of-input" name="' . $value['id'] . '-icon" placeholder="badge-change-of-icon-class" id="' . self::convert($value['id']) . '-icon" type="text"  ng-model="icon" ng-change="badgeList(icon,edit.' . $value['id'] . ')" />';

            $output .= '<input type="hidden"  />';
            $output .= '<div class="list-li-container" ui-sortable="listSortableOptions" ng-model="edit.' . $value['id'] . '">';
            $output .= '<div ng-repeat="(ied, ed) in edit.' . $value['id'] . '">';
            $output .= '<tg-dynamic-directive ng-model="ed" tg-dynamic-directive-view="getView" tg-dynamic-directive-level="0" ></tg-dynamic-directive>';
            $output .= '</div>';
            $output .= '</div>';
            $output .= '<div class="clear"></div>';
            $output .= '<a href="#" class="button-primary blue jaw add-list" ng-click="add_edit(\'' . $value['id'] . '\', {\'item\': \'\'});"><i class="jaw-icon-white jaw-icon-plus"></i></a>';


            $output .= '<script type="text/ng-template" id="list_item.html">';
            $output .= '<div class="list-li-adv " >';
            $output .= '<div class="list-handle"><i class="jaw-icon-arrow4"></i></div>';
            $output .= '<div class="show-icon" ><i class="{{ngModelItem.bullet}}"></i></div>';
            $output .= '<input class="of-input show-icon-input list-bullet-input" placeholder="jaw-icon-class" name="bullet" id="' . self::convert($value['id']) . '-bullet" type="text"   ng-change="badgeList(ngModelItem.bullet,ngModelItem.childs)" ng-init="ngModelItem.bullet = ngModelItem.bullet || icon; ngModelItem.childs = ngModelItem.childs || [];" ng-model="ngModelItem.bullet" />';
            $output .= '<input class="of-input list-text" placeholder="Some text" name="' . $value['id'] . '" id="' . self::convert($value['id']) . '" type="text"   ng-model="ngModelItem.item" />';
            $output .= '<button type="button" class="list_delete_button button-primary builder rngModelItem jaw" ng-click="del_edit(\'' . $value['id'] . '\',ied)" ><i class="jaw-icon-white jaw-icon-remove"></i></button>';
            $output .= '<div class="clear"></div>';
            $output .= '</div>';
            $output .= '<div class="clear"></div>';
            $output .= '</script>';

            return $output;
        }
        
        public static function element_map_markers($value, $data = null) {
            $output = '';

            if (isset($data))
                $evalue = $data;
            else if (isset($value['std']))
                $evalue = $value['std'];
            else
                $evalue = '';

           
            $output .= '<div class="jw-grid-container" ui-sortable="listSortableOptions" ng-model="edit.' . $value['id'] . '">';
            $output .= '<div ng-repeat="(ied, ed) in edit.' . $value['id'] . '">';
            
            $output .= '<div class="list-li-adv " >';
            $output .= '<div class="list-handle"><i class="jaw-icon-arrow4"></i></div>';
            
            $output .= '<div class="jw-grid-content">';

            $output .= '<label>Latitude</label><input class="of-input list-text" type="text" ng-model="ed.latitude" />';
            $output .= '<label>Longitude</label><input class="of-input list-text" type="text" ng-model="ed.longitude" />';
            $output .= '<label>Description </label><textarea class="of-input list-text" ng-model="ed.description_marker" ></textarea>';
            $output .= '<label>Open Description</label>';
            $output .= '<jwd-toggle 
                options="{\'0\':\'Off\',\'1\':\'On\'}" 
                selected="ed.descriptionopen">
            </jwd-toggle>';
            $output .= '<button type="button" class="list_delete_button button-primary builder rngModelItem jaw" ng-click="del_edit(\'' . $value['id'] . '\',ied)" ><i class="jaw-icon-white jaw-icon-remove"></i></button>';

            $output .= '<div class="clear"></div>';
            $output .= '</div>';
            $output .= '</div>';
                        
            $output .= '</div>';
            $output .= '</div>';
            $output .= '<div class="clear"></div>';
            $output .= '<a href="#" class="button-primary blue jaw add-list" ng-click="add_edit(\'' . $value['id'] . '\', {\'item\': \'\'});"><i class="jaw-icon-white jaw-icon-plus"></i></a>';

            return $output;
        }
        
        public static function element_map_waypoint($value, $data = null) {
            $output = '';

            if (isset($data))
                $evalue = $data;
            else if (isset($value['std']))
                $evalue = $value['std'];
            else
                $evalue = '';

           
            $output .= '<div class="jw-grid-container" ui-sortable="listSortableOptions" ng-model="edit.' . $value['id'] . '">';
            $output .= '<div ng-repeat="(ied, ed) in edit.' . $value['id'] . '">';
            
            $output .= '<div class="list-li-adv " >';
            $output .= '<div class="list-handle"><i class="jaw-icon-arrow4"></i></div>';
            
            $output .= '<div class="jw-grid-content">';

            $output .= '<label>Latitude</label><input class="of-input list-text" type="text" ng-model="ed.latitude" />';
            $output .= '<label>Longitude</label><input class="of-input list-text" type="text" ng-model="ed.longitude" />';
            $output .= '<button type="button" class="list_delete_button button-primary builder rngModelItem jaw" ng-click="del_edit(\'' . $value['id'] . '\',ied)" ><i class="jaw-icon-white jaw-icon-remove"></i></button>';

            $output .= '<div class="clear"></div>';
            $output .= '</div>';
            $output .= '</div>';
                        
            $output .= '</div>';
            $output .= '</div>';
            $output .= '<div class="clear"></div>';
            $output .= '<a href="#" class="button-primary blue jaw add-list" ng-click="add_edit(\'' . $value['id'] . '\', {\'item\': \'\'});"><i class="jaw-icon-white jaw-icon-plus"></i></a>';

            return $output;
        }
        
        public static function element_grid_content($value, $data = null) {
            $output = '';

            if (isset($data))
                $evalue = $data;
            else if (isset($value['std']))
                $evalue = $value['std'];
            else
                $evalue = '';

           
            $output .= '<div class="jw-grid-container" ui-sortable="listSortableOptions" ng-model="edit.' . $value['id'] . '">';
            $output .= '<div ng-repeat="(ied, ed) in edit.' . $value['id'] . '">';
            
            $output .= '<div class="list-li-adv " >';
            $output .= '<div class="list-handle"><i class="jaw-icon-arrow4"></i></div>';
            
            $output .= '<div class="jw-grid-content">';
            
            $output .= "<label>Background image</label>";
            $output .= '<div simplemediapicker ng-model="ed.img" name="' . $value['id'] . '[img]" multiple="false"></div>';

            $output .= '<label>Link URL</label><input class="of-input list-text" placeholder="http://" name="' . $value['id'] . '[link]"  type="text" ng-model="ed.link" />';
            $output .= '<label>Title</label><input class="of-input list-text" placeholder="Title" name="' . $value['id'] . '[title]"  type="text" ng-model="ed.title" />';
            $output .= '<label>Description (html)</label><textarea class="of-input list-text" name="' . $value['id'] . '[content]" ng-model="ed.content" ></textarea>';
            
            $output .= '<button type="button" class="list_delete_button button-primary builder rngModelItem jaw" ng-click="del_edit(\'' . $value['id'] . '\',ied)" ><i class="jaw-icon-white jaw-icon-remove"></i></button>';

            
            $output .= '<div class="clear"></div>';
            $output .= '</div>';
            $output .= '</div>';
            
            
            $output .= '</div>';
            $output .= '</div>';
            $output .= '<div class="clear"></div>';
            $output .= '<a href="#" class="button-primary blue jaw add-list" ng-click="add_edit(\'' . $value['id'] . '\', {\'item\': \'\'});"><i class="jaw-icon-white jaw-icon-plus"></i></a>';


            

            return $output;
        }

        public static function element_circle_chart($value, $data = null) {
            $output = '';

            if (isset($data))
                $evalue = $data;
            else if (isset($value['std']))
                $evalue = $value['std'];
            else
                $evalue = '';
            $t_value = '';
            $t_value = stripslashes((string) $evalue);


            $output .= '<input type="hidden"  />';
            $output .= '<div class="chart-li section-color" ng-repeat="(ied, ed) in edit[\'' . $value['id'] . '\']">';
            $output .= '<input class="of-input"   type="text" value="' . $t_value . '"  ng-model="ed[\'title\']" placeholder="Item Name" />';
            $output .= '<input class="of-input"   type="text" value="' . $t_value . '"  ng-model="ed[\'value\']" placeholder="Value" />';
            $output .= '<div class="input-append color" data-color="rgb(128, 0, 0)" >';
            $output .= '<input type="text" colorpicker ng-model="ed[\'color\']" value="{{ed[\'color\']}}" />';
            $output .= '<span class="add-on"><i ng-style="getStyle(\'background\',ed[\'color\'])"></i></span>';
            $output .= '</div>';
            $output .= '<button type="button" class="list_delete_button button-primary builder red jaw" ng-click="del_edit(\'' . $value['id'] . '\',ied)" ><i class="jaw-icon-white jaw-icon-remove"></i></button>';
            $output .= '</div>';
            $output .= '<a href="#" class="button-primary blue jaw add-list" ng-click="add_edit(\'' . $value['id'] . '\', {\'title\': \'\', \'value\': \'\', \'color\': \'#1E8CBE\'});"><i class="jaw-icon-white jaw-icon-plus"></i></a>';
            return $output;
        }

        public static function element_select($value, $data = null, $type = 'default') {

            $output = '';
            if (isset($data)) {
                $evalue = $data;
            } else if (isset($value['std'])) {
                $evalue = $value['std'];
            } else {
                $evalue = '';
            }
            if (!isset($value['mod'])) {
                $mini = '';
            } else {
                $mini = $value['mod'];
            }
            if (!isset($value['options'])) {
                $value['options'] = '';
            }
            $output .= '<div class="' . $mini . '">';
            $output .= '<select ng-init="init_item(\'' . $value['id'] . '\',json_decode(\'' . jwUtils::json_quote_checker(json_encode($value['options'])) . '\'), \'options\'); init_item(\'' . $value['id'] . '\',\'' . $evalue . '\');" name="' . $value['id'] . '" ng-options="ip as preset for (ip,preset) in options[\'' . $value['id'] . '\']" ng-model="edit[\'' . $value['id'] . '\']">';
            $output .= '</select>';
            $output .= '</div>';            
            return $output;
        }

        public static function element_select_preset($value, $data = null, $type = 'default') {

            $output = '';
            $angualrValue = '';

            if (isset($value['target'])) {
                $target = $value['target'];
            } else {
                $target = 'category';
            }
            if (isset($value['default-opt'])) {
                $default = $value['default-opt'];
            }else{
                $default = 'Default';
            }
            
            if (isset($data)) {
                $evalue = $data;
            } else if (isset($value['std'])) {
                $evalue = $value['std'];
            } else {
                $evalue = '';
            }

            if ($evalue != '') {
                $angualrValue = 'init_item(\'' . $value['id'] . '\',\'' . $evalue . '\')';
            }

            $jaw_presets = jwOpt::loadAllPresets($target);

            if(empty($jaw_presets)){
                $output = '<div class="jaw-message success inline">You have to add a color scheme in Theme Options -> Styling Options -> Color Settings -> Color Schemes. <div class="clear"></div><div class="button jaw-goto-colorsettings" data-goto="colorsettings" data-highlight="color_presets">See problem</div></div>';
            }
                
            $json = json_encode((object) $jaw_presets, JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_HEX_AMP | JSON_UNESCAPED_UNICODE); // osentreni ' v textu 
            $target = 'jaw_' . $target . '_preset';
            $output .= '<div class="jaw-color-preset" ng-init="init_item(\'' . $target . '\',json_decode(\'' . addslashes(str_replace('"', '\'',$json))  . '\'), \'options\');' . $angualrValue . '">';
            $output .= '<select name="' . $value['id'] . '" ng-options="ip as preset.title for (ip,preset) in options[\'' . $target . '\']" ng-model="edit[\'' . $value['id'] . '\']">';
            $output .= '<option value="">-- '.$default.' --</option>';
            $output .= '</select>';
            
            $output .= '<div class="jaw-color-preview" ng-style="{\'background-color\':options[\'' . $target . '\'][edit[\'' . $value['id'] . '\']][\'theme1\']}">';
            
            //nahled presetu
            $output .= '<div class="jaw-color-rich-preview" ng-show="edit[\'' . $value['id'] . '\'] && edit[\'' . $value['id'] . '\'] !== \'_default\'">';    
            $output .= '<div><span class="jaw-color-preview-name">Background</span><span class="jaw-color-preview" ng-style="{\'background-color\':options[\'' . $target . '\'][edit[\'' . $value['id'] . '\']][\'background\']}" title="{{options[\'' . $target . '\'][edit[\'' . $value['id'] . '\']][\'background\']}} - Click to copy this to clipboard" copy-to-clipboard="{{options[\'' . $target . '\'][edit[\'' . $value['id'] . '\']][\'background\']}}"></span></div>';
            $output .= '<div><span class="jaw-color-preview-name">Alternative Background</span><span class="jaw-color-preview" ng-style="{\'background-color\':options[\'' . $target . '\'][edit[\'' . $value['id'] . '\']][\'alternative_background\']}" title="{{options[\'' . $target . '\'][edit[\'' . $value['id'] . '\']][\'alternative_background\']}} - Click to copy this to clipboard" copy-to-clipboard="{{options[\'' . $target . '\'][edit[\'' . $value['id'] . '\']][\'alternative_background\']}}"></span></div>';
            $output .= '<div><span class="jaw-color-preview-name">Theme Color 1</span><span class="jaw-color-preview" ng-style="{\'background-color\':options[\'' . $target . '\'][edit[\'' . $value['id'] . '\']][\'theme1\']}" title="{{options[\'' . $target . '\'][edit[\'' . $value['id'] . '\']][\'theme1\']}} - Click to copy this to clipboard" copy-to-clipboard="{{options[\'' . $target . '\'][edit[\'' . $value['id'] . '\']][\'theme1\']}}"></span></div>';
            $output .= '<div><span class="jaw-color-preview-name">Theme Color 2</span><span class="jaw-color-preview" ng-style="{\'background-color\':options[\'' . $target . '\'][edit[\'' . $value['id'] . '\']][\'theme2\']}" title="{{options[\'' . $target . '\'][edit[\'' . $value['id'] . '\']][\'theme2\']}} - Click to copy this to clipboard" copy-to-clipboard="{{options[\'' . $target . '\'][edit[\'' . $value['id'] . '\']][\'theme2\']}}"></span></div>';
            $output .= '<div><span class="jaw-color-preview-name">Theme Color 3</span><span class="jaw-color-preview" ng-style="{\'background-color\':options[\'' . $target . '\'][edit[\'' . $value['id'] . '\']][\'theme3\']}" title="{{options[\'' . $target . '\'][edit[\'' . $value['id'] . '\']][\'theme3\']}} - Click to copy this to clipboard" copy-to-clipboard="{{options[\'' . $target . '\'][edit[\'' . $value['id'] . '\']][\'theme3\']}}"></span></div>';
            $output .= '<div><span class="jaw-color-preview-name">Border Color</span><span class="jaw-color-preview" ng-style="{\'background-color\':options[\'' . $target . '\'][edit[\'' . $value['id'] . '\']][\'border\']}" title="{{options[\'' . $target . '\'][edit[\'' . $value['id'] . '\']][\'border\']}} - Click to copy this to clipboard" copy-to-clipboard="{{options[\'' . $target . '\'][edit[\'' . $value['id'] . '\']][\'border\']}}"></span></div>';
            $output .= '<div><span class="jaw-color-preview-name">Text Color</span><span class="jaw-color-preview" ng-style="{\'background-color\':options[\'' . $target . '\'][edit[\'' . $value['id'] . '\']][\'text\']}" title="{{options[\'' . $target . '\'][edit[\'' . $value['id'] . '\']][\'text\']}} - Click to copy this to clipboard" copy-to-clipboard="{{options[\'' . $target . '\'][edit[\'' . $value['id'] . '\']][\'text\']}}"></span></div>';
            $output .= '<div><span class="jaw-color-preview-name">Meta Color</span><span class="jaw-color-preview" ng-style="{\'background-color\':options[\'' . $target . '\'][edit[\'' . $value['id'] . '\']][\'meta\']}" title="{{options[\'' . $target . '\'][edit[\'' . $value['id'] . '\']][\'meta\']}} - Click to copy this to clipboard" copy-to-clipboard="{{options[\'' . $target . '\'][edit[\'' . $value['id'] . '\']][\'meta\']}}"></span></div>';
            $output .= '<div><span class="jaw-color-preview-name">Link Color</span><span class="jaw-color-preview" ng-style="{\'background-color\':options[\'' . $target . '\'][edit[\'' . $value['id'] . '\']][\'link\']}" title="{{options[\'' . $target . '\'][edit[\'' . $value['id'] . '\']][\'link\']}} - Click to copy this to clipboard" copy-to-clipboard="{{options[\'' . $target . '\'][edit[\'' . $value['id'] . '\']][\'link\']}}"></span></div>';
            $output .= '<div><span class="jaw-color-preview-name">Link Hover Color</span><span class="jaw-color-preview" ng-style="{\'background-color\':options[\'' . $target . '\'][edit[\'' . $value['id'] . '\']][\'hover\']}" title="{{options[\'' . $target . '\'][edit[\'' . $value['id'] . '\']][\'hover\']}} - Click to copy this to clipboard" copy-to-clipboard="{{options[\'' . $target . '\'][edit[\'' . $value['id'] . '\']][\'hover\']}}"></span></div>';
            $output .= '<div><span class="jaw-color-preview-name">Link in Content Color</span><span class="jaw-color-preview" ng-style="{\'background-color\':options[\'' . $target . '\'][edit[\'' . $value['id'] . '\']][\'text_link\']}" title="{{options[\'' . $target . '\'][edit[\'' . $value['id'] . '\']][\'text_link\']}} - Click to copy this to clipboard" copy-to-clipboard="{{options[\'' . $target . '\'][edit[\'' . $value['id'] . '\']][\'text_link\']}}"></span></div>';
            $output .= '<div><span class="jaw-color-preview-name">Link in Content Hover Color</span><span class="jaw-color-preview" ng-style="{\'background-color\':options[\'' . $target . '\'][edit[\'' . $value['id'] . '\']][\'text_hover\']}" title="{{options[\'' . $target . '\'][edit[\'' . $value['id'] . '\']][\'text_hover\']}} - Click to copy this to clipboard" copy-to-clipboard="{{options[\'' . $target . '\'][edit[\'' . $value['id'] . '\']][\'text_hover\']}}"></span></div>';
            $output .= '<div><span class="jaw-color-preview-name">Input Text Color</span><span class="jaw-color-preview" ng-style="{\'background-color\':options[\'' . $target . '\'][edit[\'' . $value['id'] . '\']][\'input\']}" title="{{options[\'' . $target . '\'][edit[\'' . $value['id'] . '\']][\'input\']}} - Click to copy this to clipboard" copy-to-clipboard="{{options[\'' . $target . '\'][edit[\'' . $value['id'] . '\']][\'input\']}}"></span></div>';
            $output .= '<div><span class="jaw-color-preview-name">Input Background Color</span><span class="jaw-color-preview" ng-style="{\'background-color\':options[\'' . $target . '\'][edit[\'' . $value['id'] . '\']][\'input_bg\']}" title="{{options[\'' . $target . '\'][edit[\'' . $value['id'] . '\']][\'input_bg\']}} - Click to copy this to clipboard" copy-to-clipboard="{{options[\'' . $target . '\'][edit[\'' . $value['id'] . '\']][\'input_bg\']}}"></span></div>';
            $output .= "<div><a href='#of-option-colorsettings---color_presets' class='button jaw-goto-colorsettings' data-goto='colorsettings' data-highlight='color_presets' ng-click='options[\"color_presets_opened\"] = edit[\"" . $value['id'] . "\"]'>Edit this scheme</a></div>";
            $output .= '</div>';
            $output .= '</div>';

            $output .= '</div>';

            return $output;
        }

        public static function element_textarea($value, $data = null) {
            $output = '';

            if (isset($data)) {
                $evalue = $data;
            } else if (isset($value['std'])) {
                $evalue = $value['std'];
            } else {
                $evalue = '';
            }
            $a_default = 'init_item(\'' . $value['id'] . '\',(\'' . addslashes(str_replace('"', '\'', $evalue)) . '\'));';

            $cols = '20';
            $rows = '4';
            $class = '';

            if (isset($value['cols'])) {
                $cols = $value['cols'];
            }
            if (isset($value['rows'])) {
                $rows = $value['rows'];
            }

            if (isset($value['style'])) {
                $class = $value['style'];
            }


            $ta_value = stripslashes($evalue);
            $output .= '<textarea class="of-input wp-editor-area ' . $class . '" name="' . $value['id'] . '" id="' . self::convert($value['id']) . '" cols="' . $cols . '" rows="' . $rows . '" ng-init="' . $a_default . '" ng-model="edit[\'' . $value['id'] . '\']" value="{{edit[\'' . $value['id'] . '\']}}">' . $ta_value . '</textarea>';
            return $output;
        }

        public static function element_ace_editor($value, $data = null) {
            $output = '';

            if (isset($data)) {
                $evalue = $data;
            } else if (isset($value['std'])) {
                $evalue = $value['std'];
            } else {
                $evalue = '';
            }
            $a_default = 'init_item(\'' . $value['id'] . '\',(\'' . addslashes(str_replace('"', '\'', $evalue)) . '\'));';

            $cols = '20';
            $rows = '4';
            $class = '';

            if (isset($value['cols'])) {
                $cols = $value['cols'];
            }
            if (isset($value['rows'])) {
                $rows = $value['rows'];
            }

            if (isset($value['style'])) {
                $class = $value['style'];
            }
            if (!isset($value['mod'])) {
                $mod = 'html';
            } else {
                $mod = $value['mod'];
            }


            $ta_value = stripslashes($evalue);
            $output .= '<div id="' . $value['id'] . '_editor" class="of-input wp-editor-area ace_editor" data-type="' . $mod . '" data-id="' . $value['id'] . '" ></div>';
            $output .= '<textarea class="of-input with_ace_editor ' . $class . '" name="' . $value['id'] . '" id="' . self::convert($value['id']) . '" cols="' . $cols . '" rows="' . $rows . '" ng-init="' . $a_default . '" ng-model="edit[\'' . $value['id'] . '\']" value="{{edit[\'' . $value['id'] . '\']}}">' . $ta_value . '</textarea>';
            return $output;
        }

        public static function element_tinymce_editor($value, $data = null) {
            $output = '';

            if (isset($data)) {
                $evalue = $data;
            } else if (isset($value['std'])) {
                $evalue = $value['std'];
            } else {
                $evalue = '';
            }
            $a_default = 'init_item(\'' . $value['id'] . '\',\'' . addslashes(str_replace('"', '\'', $evalue)) . '\');';

            $ta_value = stripslashes($evalue);
            $output .= '<a title="Add Media" copy-to-clipboard="Add Media" data-editor="' . $value['id'] . '" class="button insert-media jaw_add_media" id="insert-media-button" href="#"><span class="wp-media-buttons-icon"></span> Add Media</a>';

            $output .= '<div class = "tinymce-tabs">';
            $output .= '<a class="html ' . $value['id'] . '">HTML</a>';
            $output .= '<a class="visual ' . $value['id'] . '" class="active">Visual</a>';
            $output .= ' <div style="clear: both;"></div>';
            $output .= '</div> ';
            
            
            $output .= '<textarea ng-init="' . $a_default . '" id="' . $value['id'] . '" class="jaw-editor-area" name="' . $value['id'] . '" cols="40" rows="20" ng-model="edit[\'' . $value['id'] . '\']"></textarea>';
            
            // pro zobrazeni wpeditoru v elementu je zapotrebi naloadovat scipry. bohuzel jsou zpouzdreny ve fci wp_editor a akci admin_print_footer_scripts. Takaze vyprintuju editor a schovam ho
            $output .= '<div class="jaw-hide-tinymce" style="display:none;">';
            ob_start();
            $output .= ob_get_clean();
            ob_start();
            do_action('admin_print_footer_scripts');
            $scripts = ob_get_clean();
            //zabranim znovu-nacteni jQuery
            $scripts = preg_replace('/\<script(.*?)jquery.js(.*?)\<\/script\>/','', $scripts);
            $scripts = preg_replace('/jquery-core,/','', $scripts);
            $output .= '</div>';
            

            return $output;
        }

        public static function element_upload($value, $data = null) {
            $output = '';

            if (isset($data))
                $evalue = $data;
            else
                $evalue = '';

            if (!isset($value['mod'])) {
                $value['mod'] = '';
            }



            $output .= jwElements::elements_uploader_function($value['id'], $value['std'], $value['mod'], $evalue);


            return $output;
        }


        public static function element_google_address($value, $data = null) {
            $output = '';
            $output .= '<div id="google-map-' . $value['id'] . '">';
            $output .= '<textarea id="address-' . $value['id'] . '" ng-model="edit[\'' . $value['id'] . '\']" value="{{edit[\'' . $value['id'] . '\']}}"  name="' . $value['id'] . '">{{edit[\'' . $value['id'] . '\']}}</textarea>';
            $output .= '<div data-id="' . $value['id'] . '" class="button convert_to_gps">Convert to GPS <i class="jaw-icon-arrow-down3"></i></div>';
            $output .= '</div>';
            return $output;
        }

        public static function element_media_picker($value, $data = null) {
            $output = '';

            if (isset($data)) {
                $evalue = $data;
            } else if (isset($value['std'])) {
                $evalue = $value['std'];
            } else {
                $evalue = '';
            }
            $a_default = 'init_item(\'' . $value['id'] . '\',json_decode(\'' . addslashes(str_replace('"', '\'', $evalue)) . '\'));';
            $_id = strip_tags(strtolower($value['id']));
            if (!isset($value['mod']))
                $value['mod'] = '';

            $output .= '<span ng-init="' . $a_default . '" ></span>';
            $output .= '<div gallerypicker ng-model="edit[\'' . $value['id'] . '\']" name="' . $value['id'] . '"></div>';

            return $output;
        }

        public static function element_simple_media_picker($value, $data = null) {
            $output = '';

            if (isset($data)) {
                $evalue = $data;
            } else if (isset($value['std'])) {
                $evalue = $value['std'];
            } else {
                $evalue = '';
            }
            $a_default = 'init_item(\'' . $value['id'] . '\',json_decode(\'' . addslashes(str_replace('"', '\'', $evalue)) . '\'));';
            $_id = strip_tags(strtolower($value['id']));
            if (!isset($value['mod'])) {
                $value['mod'] = '';
            }
            $multiple = '';
            if (isset($value['multiple']) && $value['multiple']) {
                $multiple = 'multiple="' . $value['multiple'] . '"';
            }

            $output .= '<span ng-init="' . $a_default . '" ></span>';
            $output .= '<div simplemediapicker ng-model="edit[\'' . $value['id'] . '\']" name="' . $value['id'] . '" ' . $multiple . ' mod="' . $value['mod'] . '"></div>';


            return $output;
        }
        

        public static function element_color($value, $data = null) {
            $output = '';
            $a_default = '';
            if (isset($data)) {
                $evalue = $data;
            } else if (isset($value['std'])) {
                $evalue = $value['std'];
            } else {
                $evalue = '';
            }
            $a_default = 'init_item(\'' . $value['id'] . '\',\'' . $evalue . '\');';
            if (isset($value['format'])) {
                $format = $value['format'];
            } else {
                $format = 'hex';
            }
            $output .= '<div class="input-append color" data-color="rgb(0, 0, 0)"  ng-init="' . $a_default . '" >';
            $output .= '<input type="text" colorpicker="' . $format . '" ng-model="edit[\'' . $value['id'] . '\']" value="{{edit[\'' . $value['id'] . '\']}}"  name="' . $value['id'] . '"/>';
            $output .= '<span class="add-on"><i ng-style="getStyle(\'background\', edit[\'' . $value['id'] . '\'])" copy-to-clipboard="{{edit[\'' . $value['id'] . '\']}}" title="{{edit[\'' . $value['id'] . '\']}} - Click to copy this to clipboard"></i></span>';
            $output .= '</div>';
            return $output;
        }
                
           
        
        public static function element_new_typography($value, $data = null) {
            $output = '';
            
            $std = '';
            if(isset($value['std'])){
                $std = $value['std'];
            }
            
            $managermod = '';
            if(isset($value['switch_mode_toggle'])){
                $managermod = $value['switch_mode_toggle'];
            }
            
            $evalue = self::checkDefault($data, $std);
            $evalue = jwUtils::sanitizeJson($evalue);
            
            if(isset($value['places'])){
                $places = jwUtils::jsonEncode($value['places']); 
            }else{
                $places = '';
            }
            if(isset($value['structure'])){
                $structure = jwUtils::jsonEncode($value['structure']); 
            }else{
                $structure = '';
            }
            
            $output .= '<jwd-typografy 
                                places="'.$places.'"
                                structure="'.$structure.'"
                                ng-init="init_item(\'' . $value['id'] . '\',json_decode(\'' . $evalue. '\'));" 
                                typografy="edit[\'' . $value['id'] . '\']" 
                                managermod="edit[\''.$managermod.'\']">
                        </jwd-typografy>';
            $output .= '<input type="hidden" ng-model="edit[\'' . $value['id'] . '\']" value="{{edit[\'' . $value['id'] . '\']}}"  name="' . $value['id'] . '"/>';                  
                           
            return $output;
        }


        public static function element_info($value, $data = null) {
            $output = '';

            if (isset($value['message']))
                $message = $value['message'];
            else
                $message = '';

            $info_text = $value['text'];
            $output .= '<div class="jaw-message of-info ' . $message . '">' . $info_text . '</div>';

            return $output;
        }
        
        public static function element_help_image($value, $data = null) {
            $output = '';

            $src = $value['src'];
            $output .= '<img class="jaw-lazy" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7" data-src="' . JAW_THEME_URI . '/help/images/' . $src . '">';

            return $output;
        }


        

        public static function element_authors($value, $data = null) {
            $output = '';
            $attrs = array(
                'role__not_in' => array('Subscriber') //since WP 4.4
            );
            $users = get_users( $attrs );
            foreach ((array) $users as $user) {
                $value['options'][$user->ID] = $user->display_name;
            }
            $output = jwElements::element_select($value, $data);


            return $output;
        }
        
        /* SIDEBARS */
        public static function element_sidebar_select($value, $data = null) {
            $output = '';
            $sdbs = jwOpt::get_option('sidebars', '{}');
            $sdbs = jwUtils::sanitizeJson($sdbs);
                        
            $output .= '<div class="jw-select">';
            $output .= '<select 
            ng-init="init_item(\'sidebars\',json_decode(\'' . $sdbs . '\'), \'options\'); 
                     init_item(\'' . $value['id'] . '\',\'' . $data . '\');" 
            name="' . $value['id'] . '" 
            ng-options="ip as preset for (ip,preset) in options[\'sidebars\']" 
            ng-model="edit[\'' . $value['id'] . '\']">';
            $output .= '</select>';
            $output .= '</div>';        

            return $output;
        }

        public static function element_sidebars($value, $data = null) {
            $output = '';            
            
            $data = jwOpt::get_option('sidebars', '{}');
            if($data == "[]"){
                $data = '{}';
            }
            $data = jwUtils::sanitizeJson($data);
           
            $output .= '<jwd-sidebar-manager 
                                ng-init="init_item(\'sidebars\',json_decode(\'' . $data. '\'), \'options\');" 
                                sidebars="options[\'sidebars\']">
                        </jwd-sidebar-manager>';
            $output .= '<input type="hidden" ng-model="options[\'sidebars\']" value="{{options[\'sidebars\']}}"  name="sidebars"/>';                      
            return $output;
        }

        public static function jaw_add_sidebar() {
            if (isset($_POST['data'])) {
                $json = json_encode($_POST['data']);
                jwOpt::set_option('sidebars', $json);
                jwOpt::update_option(jwOpt::get_options());
            }
            die();
        }

        public static function element_layout_pb($value, $data = null) {
            $output = '';

            if (isset($data))
                $evalue = $data;
            else if (isset($value['std']))
                $evalue = $value['std'];
            else
                $evalue = '';
            $i = 0;
            foreach ($value['options'] as $key => $option) {
                $i++;

                $check = '';
                $checked = '';
                if (NULL != checked($evalue, $key, false)) {
                    $checked = checked($evalue, $key, false);
                    $check = 'check';
                }

                $output .= '<div ng-class="{layout_selected: current.layout == \'' . $key . '\'}" class="pb-settings radio-layout_pb" ng-click="change_layout(\'' . $key . '\')">';
                $output .= '<label val="' . $key . '"   for="' . $value['id'] . '-' . $key . '-sidebar">';
                $output .= '<img alt="page-option-sidebar-template" src="' . $option . '" />';
                $output .= '</label>';
                $output .= '</div>';
            }
            return $output;
        }

        public static function element_layout($value, $data = null) {
            $output = '';
            $i = 0;
            if (isset($data)) {
                $evalue = $data;
            } else if (isset($value['std'])) {
                $evalue = $value['std'];
            } else {
                $evalue = '';
            }

            $select_value = $evalue;
            if (isset($value['extend']) && !empty($value['extend'])) {
                $rel = ' rel="' . $value['extend'] . '"';
                $page = 'page_layout ';
            } else {
                $rel = '';
                $page = '';
            }

           
            $output.='<span ng-init="init_item(\'' . $value['id'] . '\',\'' . $evalue . '\');"></span>';
            
            foreach ($value['options'] as $key => $option) {
                $i++;

                $checked = '';
                $selected = '';

                $output .= '<div class="radio-layout ' . $selected . '" ng-class="{of_radio_img_selected: edit[\'' . $value['id'] . '\'] == \'' . $key . '\'}">';
                $output .= '<label val="' . $key . '" ' . $rel . '  for="' . $value['id'] . '-' . $key . '-sidebar">';
                $output .= '<img alt="page-option-sidebar-template" class="jaw-lazy" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7" data-src="' . $option . '" />';
                $output .= '</label>';
                $output .= '<input autocomplete="off" type="radio" ' . $checked . ' id="' . $value['id'] . '-' . $key . '-sidebar" ng-model="edit[\'' . $value['id'] . '\']" value="' . $key . '" name="' . $value['id'] . '"> ';
                $output .= '</div>';
            }
            return $output;
        }

        public static function element_tabs($value, $data = null) {
            $output = '';

            if (isset($data))
                $evalue = $data;
            else if (isset($value['std']))
                $evalue = $value['std'];
            else
                $evalue = '[]';
                
            if(!isset( $value['std'])){
                 $value['std'] = '[]';
            }

            $_id = strip_tags(strtolower($value['id']));
            $int = '';
            $output .= '<div class="slider"><ul id="' . $value['id'] . '" ng-init="init_item(\'' . $value['id'] . '\', '.$evalue.')" >';
            $slides = $evalue;
            $count = count($slides);
            if ($count < 2) {
                $oldorder = 1;
                $order = 1;
                $output .= jwElements::elements_tabs_function($value['id'], $value['std'], $oldorder, $order);
            } else {
                $i = 0;
                foreach ($slides as $slide) {
                    $oldorder = $slide['order'];
                    $i++;
                    $order = $i;
                    $output .= jwElements::elements_tabs_function($value['id'], $value['std'], $oldorder, $orde);
                }
            }
            $output .= '</ul>';
            $output .= '<a href="#" class="button tabs_add_button" ng-click="add_edit(\'' . $value['id'] . '\', {})" ><i class="jaw-icon-plus"></i> Add New Slide</a></div>';

            return $output;
        }

        
        
        public static function element_translation($value, $data = null) {
            $output = '';
            $translatings = get_translations_for_domain( "gdn-theme" );
            if(sizeof($translatings->entries) == 0){
                add_filter( 'theme_locale', array('jwUtils' , 'defaultLocale') , 10, 2);
                jaw_language();
                $translatings = get_translations_for_domain( "gdn-theme" );
            }
            if(sizeof($translatings->entries) == 0){
                $output .= '<div class="jw_option section-info ">
                            <div class="option">
                            <div class="controls ">
                            <div class="of-info warnings">Please re-upload en_US.po and en_US.mo files into '.get_template_directory().'/languages/ folder</div></div>
                            <div class="clear"></div>
                            </div>
                            </div>';
            }
            foreach((array) $translatings->entries as $translate_key => $translate_entry){
                if(isset($data[$translate_key]['singular'])){
                    $singular = $data[$translate_key]['singular'];
                }else{
                    $singular = $translate_entry->singular;
                }
                if(isset($data[$translate_key]['plural'])){
                    $plural = $data[$translate_key]['plural'];
                }else{
                    $plural = $translate_entry->plural;
                }
                $output .= '<div class="jw-tranlation-item" >';
                $output .= '<label class="jw-tranlation-label">';
                $output .= $translate_key;
                $output .= '</label>';      
                $output .= '<div class="jw-tranlation-item-input jw-tranlation-singular" >';
                if($translate_entry->is_plural){
                    $output .= '<span class="jw-tranlation-item-subtitle">Singular:</span>';
                }
                $output .= '<input autocomplete="off" type="text" value="' . esc_html($singular) . '"  name="' . $value['id'] . '['.htmlentities($translate_key).'][singular]" > ';
                $output .= '</div>';     
                if($translate_entry->is_plural){
                    $output .= '<div class="jw-tranlation-item-input jw-tranlation-plural" >';
                    $output .= '<span class="jw-tranlation-item-subtitle">Plural:</span><input autocomplete="off" type="text" value="' . esc_html( $plural ) . '" name="' . $value['id'] . '['.htmlentities($translate_key).'][plural]"> ';
                    $output .= '</div>';
                }
                $output .= '</div>';  
            }
            return $output;
        }
        
        
        
        
        public static function element_tiles($value, $data = null) {
            $output = '';
            $a_default = '';

            if (isset($data)) {
                $evalue = $data;
            } else if (isset($value['std'])) {
                $evalue = $value['std'];
            } else {
                $evalue = '';
            }

            $a_default = 'init_item(\'' . $value['id'] . '\',\'' . $evalue . '\');';

            $i = 0;
            $select_value = $evalue;

            if (isset($value['mod'])) {
                $mod = $value['mod'];
            } else {
                $mod = '';
            }
    
            $output .='<div class="' . $mod . '">';

            foreach ((array) $value['options'] as $key => $option) {
                $i++;
                $data_js = array();
                if (is_array($option)) {
                    $opt = $option['thumbnail'];
                    unset($option['thumbnail']);
                    foreach ((array) $option as $key => $option) {
                        $data_js[] = 'data-' . $key . '="' . $option . '"';
                    }
                } else {
                    $opt = $option;
                }
                $text = "";
                $styles = 'background: url(' . $opt . ') repeat 50% 50% rgba(0, 0, 0, 0)';
                if(strpos($opt, '.png') === false){
                    $text = $opt;
                    $opt = "";
                    $styles = "";
                }
                $checked = '';
                $selected = '';
                if (NULL != checked($select_value, $key, false)) {
                    $checked = checked($select_value, $key, false);
                    $selected = 'of-radio-tile-selected';
                }
                $output .= '<span>';
                $output .= '<input type="radio" id="of-radio-tile-' . $value['id'] . $i . '" class="checkbox of-radio-tile-radio" value="' . $key . '" name="' . $value['id'] . '" ' . $checked . ' />';
                $output .= '<div class="of-radio-tile-img ' . $selected . '" style="' . $styles . '" onClick="document.getElementById(\'of-radio-tile-' . $value['id'] . $i . '\').checked = true; " ' . implode(' ', $data_js) . '>'.$text.'</div>';
                $output .= '</span>';
            }
            $output .='</div>';

            return $output;
        }

        public static function element_load_color_presets($value, $data = null) {

            $output = '';
            if (isset($value['options'])) {
                $evalue = json_encode($value['options']);
            } else {
                $evalue = '';
            }
            if (isset($value['for'])) {
                $for = $value['for'];
            } else {
                $for = '';
            }
            
            $output .= '<span ng-init="init_item(\'' . $value['id'] . '\',json_decode(\'' . addslashes(str_replace('"', '\'', $evalue)) . '\')); hide[\'' . $value['id'] . '\'] = true"></span>';
            
            $output .= '<div class="jw-hideable-section-title" ng-click="hide[\'' . $value['id'] . '\'] = !hide[\'' . $value['id'] . '\']">';
			$output .=  $value['name'] . '<i ng-class="{\'jaw-icon-arrow-down2\': hide[\'' . $value['id'] . '\'] == true, \'jaw-icon-arrow-up2\': hide[\'' . $value['id'] . '\'] == false}"></i>';
			$output .= '</div>';

            // pridat zalozku
            $output .= '<div  
            class="jw-presets of-radio-tile-img" 
            ng-style="{\'background-color\':ed[\'theme1\'], \'color\':ed[\'theme3\']}" 
            ng-repeat="(ie, ed) in edit[\'' . $value['id'] . '\'] track by ie" 
            ng-click="add_edit(\'' . $for . '\',ed, \'options\')"  
            ng-hide="hide[\'' . $value['id'] . '\']"
            title="Click for add it into your Color Scheme" copy-to-clipboard="Click for add it into your Color Schemes" 
            >';
            
            $output .= '{{ed.title}}';
            $output .= '</div>';

            return $output;
        }

        public static function element_color_presets($value, $data = null) {
            $output = '';
            if (isset($data)) {
                $evalue = $data;
            } else if (isset($value['std'])) {
                $evalue = json_encode($value['std']);
            } else {
                $evalue = '';
            }

            $target = 'color';
            $jaw_presets = jwOpt::loadAllPresets($target);

            if (isset($value['mod'])) {
                $mod = $value['mod'];
            } else {
                $mod = '';
            }
            if (isset($value['index']) && $value['index']) {
                $index = $value['index'];
            } else {
                $index = null;
            }
            
            if(empty($jaw_presets)){
                $output = '<div class="jaw-message success inline">You have to add a color scheme. <strong>Please click the "+" button.</strong> <a hre="http://support.jawtemplates.com/gdaynews/web/?p=1013" target="_blank">More info</a></div>';
            }
            
            $json = json_encode((object) $jaw_presets, JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_HEX_AMP | JSON_UNESCAPED_UNICODE); // osentreni ' v textu 
            $target = 'jaw_' . $target . '_preset';

            $output .='<div class="jaw-color-schemes" ng-init="init_item(\'' . $target . '\',json_decode(\'' . addslashes(str_replace('"', '\'',$json)) . '\'), \'options\');options[\'' . $value['id'] . '_opened\'] = firstKey(options[\'' . $target . '\']) ">';

            // pridat zalozku
            $output .= '<div class="jw-preset-bookmark jaw-add-color-preset" ng-click="options[\'' . $value['id'] . '_opened\'] = add_edit(\'' . $target . '\',{\'title\':dialog(\'Choose name for new preset\')},\'options\')">';
            $output .= '<span class="color_preset_name add_color_preset" title="Add new scheme" copy-to-clipboard="Add new scheme" ><i class="jaw-icon-plus"></i></span>';
            $output .= '</div>';

//zalozky
            $output .= '<div  class="jw-preset-bookmark" ng-repeat="(ie, ed) in options[\''.$target.'\']" ng-class="{open: options[\'' . $value['id'] . '_opened\'] == ie}"   >';
            $output .= '<span class="clone_color_preview" ng-click="options[\'' . $value['id'] . '_opened\'] = ie" ng-style="{\'background-color\':ed[\'theme1\']}"></span>';
            $output .= '<span class="color_preset_name" ng-click="options[\'' . $value['id'] . '_opened\'] = ie" >';
            $output .= '{{ed.title}}';
            $output .= '</span>';
            //delete
            $output .= '<span class="delete_color_preset" title="Delete scheme" copy-to-clipboard="Delete scheme" ng-click="check_using(\'' . $target . '\',ie, get_callback(\'del_edit\', [\'' . $target . '\',ie,\'options\']));" ><i class="jaw-icon-close"></i></span>';
            //clone
            $output .= '<span class="clone_color_preset" title="Clone scheme" copy-to-clipboard="Clone scheme" ng-click="clone_edit(\'' . $target . '\',ie,{\'title\':dialog(\'Choose name for new preset\')},\'options\')" ><i class="jaw-icon-copy"></i></span>';
            $output .= '</div>';




//ulozeni hodnoty
            $output .= '<input name="' . $target . '" type="hidden" value="{{options[\'' . $target . '\']}}" ng-model="options[\'' . $target . '\']">';

            $output .= '<div  class="jw-preset-bookmark-content" ng-repeat="(ie, ed) in options[\'' . $target . '\']" ng-class="{open: options[\'' . $value['id'] . '_opened\'] == ie}" >';

            foreach ((array) $value['options'] as $k => $child) {

                $output .= '<span ng-init="linkVariables([\'' . $target . '\',ie,\'' . $child['id'] . '\',\'options\'],[\'' . $target . '\'+\'-\'+ie+\'-\'+\'' . $child['id'] . '\',\'edit\'])"   >{{ed[ic]}}</span>';
                $child['id'] = $target . "-'+ie+'-" . $child['id'];
                $output .= self::elements_machine($child);
            }
            
            $output .= '<div class="section jw_option jw_btn_where"><div class="button " ng-click="openDialog([ie], 0, \'?action=jaw_preset_log&jaw_preset_type='.$target.'&jaw_preset=\'+ie);"><i class="jaw-icon-search3"></i> Where is this preset assigned</div></div>';
            $output .= '</div>';
            $output .= '</div>';
            return $output;
        }
        
        public static function element_preset_places($value, $data = null){
            $output = '';
                if(isset($value['jaw_preset_type']) && $value['jaw_preset']){
                    $type = str_replace('jaw_','',str_replace('_preset','',$value['jaw_preset_type']));
                    $places = jwOpt::getLogPresetAddress($type,$value['jaw_preset']);
                    $output .= 'Preset type: ' . $type.'<br>';
                    $output .= 'Preset ID: ' . $value['jaw_preset'].'<br>';
                    if(empty($places)){
                        $output .= 'This preset wasn`t used yet';
                    }
            $output .= '<ul class="presets_places">';
                                foreach((array) $places as $place){
            $output .= '<li class="one_place">';
                                    switch($place['place']){
                                        case 'opt': $output .= 'Theme Options -> ' . $place['option'] .' <a class="button" href="'.admin_url( 'themes.php?page=optionsframework').'">Go to...</a>';
                                            break;
                                        case 'revoopt': $output .= 'Revo Composer in Theme Options -> '. $place['id'].', Element: '. $place['subid'].', '. $place['option'].' <a class="button" href="'.admin_url( 'themes.php?page=optionsframework').'">Go to...</a>';
                                            break;
                                        case 'revotax': $output .= 'Revo Composer in Category, ID: '. $place['id'].', Element: '. $place['subid'].', '. $place['option'].' <a class="button" href="'.admin_url( 'edit-tags.php?action=edit&taxonomy=category&tag_ID='.$place['id']).'">Go to...</a>';
                                            break;
                                        case 'revo': $output .= 'Revo Composer in Page, ID: '. $place['id'].', Element: '. $place['subid'].', '. $place['option'].' <a class="button" href="'.admin_url( 'post.php?post='.$place['id'].'&action=edit').'">Go to...</a>';
                                            break;
                                        case 'tax': $output .= 'Category, ID: '. $place['id'].', '. $place['option'].' <a class="button" href="'.admin_url( 'edit-tags.php?action=edit&taxonomy=category&tag_ID='.$place['id']).'">Go to...</a>';
                                            break;
                                        case 'sng': $output .= 'Single (Post, Page), ID: '. $place['id'].', '. $place['option'].' <a class="button" href="'.admin_url( 'post.php?post='.$place['id'].'&action=edit').'">Go to...</a>';
                                            break;
                                        case 'singlepst': $output .= 'Single Preset Sidebar, ID: '. $place['id'].', '. $place['option'];
                                            break;
                                        case 'categorypst': $output .= 'Category Preset Sidebar, ID: '. $place['id'].', '. $place['option'];
                                            break;
                                        default: $output .= 'Cannot recognize: '.implode(',', $place);
                                    }
            $output .= '</li>';      
                                }
           $output .= '</ul>';   
                    }
           return $output;
        }

        public static function element_options_preset($value, $data = null) {
            $output = '';
            $angualrValue = '';

            if (isset($value['target'])) {
                $target = $value['target'];
            } else {
                $target = 'category';
            }

            if (isset($data)) {
                $evalue = $data;
            } else if (isset($value['std'])) {
                $evalue = json_encode($value['std']);
            } else {
                $evalue = '';
            }
            

            if ($evalue != '') {
                $angualrValue = 'init_item(\'' . $value['id'] . '\',\'' . $evalue . '\')';
            }

            $jaw_presets = jwOpt::loadAllPresets($target);

            if(empty($jaw_presets)){
                $output = '<div class="jaw-message success inline">You have to add a preset. <strong>Just Click the "+ NEW" button.</strong></div>';
            }
            
            $json = json_encode((object) $jaw_presets, JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_HEX_AMP | JSON_UNESCAPED_UNICODE); // osentreni ' v textu 
     
            $target = 'jaw_' . $target . '_preset';
            
            $output .= '<div class="jaw-options-preset" ng-init="init_item(\'' . $target . '\',json_decode(\'' . addslashes(str_replace('"', '\'',$json))  . '\'), \'options\');' . $angualrValue . '">';
            $output .= '<select name="' . $value['id'] . '" ng-options="ip as preset.title for (ip,preset) in options[\'' . $target . '\']" ng-model="edit[\'' . $value['id'] . '\']">';
            $output .= '<option value="">-- choose preset --</option>';
            $output .= '</select>';
            //edit
            $output .= '<div class="category_preset-edit button" ng-show="edit[\'' . $value['id'] . '\'] != null" ng-click="loaderClickSet(\'' . $target . '_edit_spinner\'); openDialog(options[\'' . $target . '\'], edit[\'' . $value['id'] . '\'], \'?action=' . $target . '_editor&jaw_type=edit&jaw_preset_type='.$target.'&jaw_preset=\'+edit[\'' . $value['id'] . '\'], loaderClickOff(\'' . $target . '_edit_spinner\'));"><i class="jaw-icon-settings-new" ng-show="!loader.' . $target . '_edit_spinner"></i><i  class="jaw-icon-spinner2 jaw-spinit" ng-show="loader.' . $target . '_edit_spinner"></i></div>';
            //clone
            $output .= '<div class="category_preset-clone button" ng-show="edit[\'' . $value['id'] . '\'] != null" ng-click="
            clone_edit(\'' . $target . '\',edit[\'' . $value['id'] . '\'],{\'title\':dialog(\'Choose name for new preset\')},\'options\');
            " ><i class="jaw-icon-copy"></i></div>';
            //delete
            $output .= '<div class="category_preset-delete button" ng-show="edit[\'' . $value['id'] . '\'] != null" ng-click="check_using(\'' . $target . '\', edit[\'' . $value['id'] . '\'], get_callback(\'del_edit\', [\'' . $target . '\', edit[\'' . $value['id'] . '\'],\'options\']));" ><i class="jaw-icon-remove"></i></div>';
            //add
            $output .= '<div id="category_preset-add" ng-click="loaderClickSet(\'' . $target . '_add_spinner\'); openDialog(options[\'' . $target . '\'],add_edit(\'' . $target . '\', {} , \'options\'), \'?action=' . $target . '_editor&jaw_type=new\', add_edit_check_blank(\'' . $target . '\', loaderClickOff(\'' . $target . '_add_spinner\')));" class="button"><i class="jaw-icon-plus" ng-show="!loader.' . $target . '_add_spinner"></i><i class="jaw-icon-spinner2 jaw-spinit" ng-show="loader.' . $target . '_add_spinner"></i> NEW</div>';

            $output .= '<input name="' . $target . '" type="hidden" value="{{options[\'' . $target . '\']}}" ng-model="options[\'' . $target . '\']">';
            $output .= '</div>';

            return $output;
        }

        public static function element_options_preset_export($value, $data = null) {
            $output = '';

            if (isset($value['target'])) {
                $target = $value['target'];
            } else {
                $target = 'category';
            }

            $jaw_presets = jwOpt::loadAllPresets($target);


            $json = json_encode((object) $jaw_presets, JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_HEX_AMP | JSON_UNESCAPED_UNICODE); // osentreni ' v textu 
            $target = 'jaw_' . $target . '_preset'; 
            $output .= '<div class="jaw-options-preset a" ng-init="init_item(\'' . $target . '\',json_decode(\'' . addslashes(str_replace('"', '\'',$json))  . '\'), \'options\');' . 'init_item(\'' . $value['id'] . '\',json_decode(\'\'));' . '">';
            $output .= '<div class="jaw-one_preset" ng-repeat="(ipr,preset) in options[\'' . $target . '\']">';
            $output .= '<div class="jaw-preset_label">{{preset.title}}</div>';
            $output .= '<div ng-click="check_using(\'' . $target . '\', ipr, get_callback(\'del_edit\', [\'' . $target . '\', ipr,\'options\']));" class="button"><i class="jaw-icon-remove"></i></div>';
            $output .= '<div class="button" ng-click="openDialog([ipr], 0, \'?action=jaw_preset_log&jaw_preset_type='.$target.'&jaw_preset=\'+ipr);" title="Where is this preset assigned" copy-to-clipboard="Where is this preset assigned"><i class="jaw-icon-search3"></i></div>';
            $output .= '<div ng-click="loaderClickSet(\''.$target.'_export\'+ipr); openDialog([{\'preset\': preset}], 0, \'?action=jaw_export_preset\', loaderClickOff(\''.$target.'_export\'+ipr));" class="button">Export <i class="jaw-icon-spinner2 jaw-spinit" ng-show="loader[\''.$target.'_export\'+ipr]"></i></div>';
            $output .= '<div class="clear"></div>';
            $output .= '</div>';
            $output .= '<input name="'.$target.'" type="hidden" value="{{options[\'' . $target . '\']}}" ng-model="options[\'' . $target . '\']" />';
            $output .= '</div>';

            return $output;
        }

        public static function element_options_preset_import($value, $data = null) {
            $output = '';

            if (isset($value['target'])) {
                $target = $value['target'];
            } else {
                $target = 'jaw_category_preset';
            }

            $jaw_presets = jwOpt::loadAllPresets($target);
            
            $json = json_encode((object) $jaw_presets, JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_HEX_AMP | JSON_UNESCAPED_UNICODE); // osentreni ' v textu 
            $target = 'jaw_' . $target . '_preset';
            $output .= '<div class="jaw-options-preset b" ng-init="init_item(\'' . $target . '\',json_decode(\'' . addslashes(str_replace('"', '\'',$json)) . '\'), \'options\');' . 'init_item(\'' . $value['id'] . '\',json_decode(\'\'));' . '">';
            $output .= '<textarea ng-model="edit[\'' . $value['id'] . '\']"></textarea>';
            $output .= '<div class="button" ng-click="add_edit(\'' . $target . '\',json_decode(edit[\'' . $value['id'] . '\']), \'options\');edit[\'' . $value['id'] . '\'] = \'\'" >Import... </div>';
            $output .= '</div>';

            return $output;
        }
        
        public static function element_preset_transfer($value, $data = null) {
            $output = '';
            
            if (isset($value['target'])) {
                $target = $value['target'];
            } else {
                $target = 'category';
            }
            
            $base64_data = jwUtils::jaw_base64_enc(serialize(jwOpt::loadAllPresets($target)));

            
            $output .= '<textarea id="export_data_'.'import_preset_'.$target.'" rows="8">' . $base64_data . '</textarea>' . "\n";
            $output .= '<a href="#" class="of_import_button button" data-type="import_preset" target="'.$target.'" ng-click="show_loader(\''.$target.'\');" class="button" title="Restore Options" copy-to-clipboard="Restore Options">Import...  <i  class="jaw-icon-spinner2 jaw-spinit" ng-show="loader[\'' . $target . '\']"></i></a>';

            return $output;
        }

        public static function element_backup($value, $data = null) {
            $output = '';


            $instructions = $value['desc'];
            $backup = jwOpt::get_backups_info();

            if (empty($backup)) {
                $log = 'No backups yet';
            } else {
                $log = $backup;
            }
            $output .= '<div class="backup-box">';
            $output .= '<div class="instructions">' . $instructions . "</div>\n";
            if (is_array($log)) {
                foreach ((array) $log as $l) {
                    if (isset($l['backup_log']) && isset($l['backup_name'])) {
                        $output .= '<div class="one_bck">';
                        $output .= '<p><strong>Backup time : <span class="backup-log">' . $l['backup_log'] . '</span></strong></p>';
                        $output .= '<a href="#" id="of_restore_button" class="button" title="Restore Options" copy-to-clipboard="Restore Options" data-name="' . $l['backup_name'] . '">Restore Option</a>';
                        $output .= '<div class="clear"></div>';
                        $output .= '<hr>';
                        $output .= '</div>';
                    }
                }
            } else {
                $output .= '<div class="one_bck">';
                $output .= $log;
                $output .= '</div>';
            }
            $output .= '<a href="#" id="of_backup_button" class="button" title="Backup Options" copy-to-clipboard="Backup Options">Backup Your Options ...</a>';
            $output .= '</div>';

            return $output;
        }

        public static function element_button($value, $data = null) {
            $output = '';
            $ng_click = '';
            if (isset($value['ng-click'])) {
                $ng_click = $value['ng-click'];
            }

            $output .= '<div class="el_button">';
            $output .= '<a href="' . $value['href'] . '" target="' . $value['target'] . '" id="' . $value['id'] . 'element_button" ng-click="' . $ng_click . '" class="element_button of_link" title="' . $value['title'] . '" copy-to-clipboard="' . $value['title'] . '">' . $value['title'] . '</a>';
            $output .= '</div>';



            return $output;
        }

        public static function element_none($value, $data = null) {
            $output = '';
            return $output;
        }

        public static function element_importpreset($value, $data = null) {
            $output = '';
            if(isset($value['demos'])){
                $demos = jwUtils::jsonEncode($value['demos']);
                $installedDemos = jwUtils::jsonEncode(array_flip(array_keys(jwDemoImport::getWholeLog())));
                $output .= '<jwd-demo
                                demos="' . $demos . '"
                                installed="' . $installedDemos . '"
                                >
                            </jwd-demo>';
            }
            
            return $output;
        }

        public static function element_instagram($value, $data = null) {

            if (isset($data)) {
                $evalue = $data;
            } else if (isset($value['std'])) {
                $evalue = $value['std'];
            } else {
                $evalue = '';
            }
            $a_default = '';
            $output = '';
            if (jwOpt::get_option('i_client_id', '') != '' && jwOpt::get_option('i_client_secret', '') != '') {
                $output .= "<a href='https://api.instagram.com/oauth/authorize?client_id=" . jwOpt::get_option('i_client_id', '') . "&redirect_uri=" . JAW_SITE_URL . "/wp-admin/themes.php?page=optionsframework&response_type=code'>Get Instagram Access Token</a><div class='clear'></div>";
            } else {
                $output .= 'To make this option available, please set both the Client ID and Client Secret items above. Save and refresh this page (F5).';
            }

            if (isset($_GET['code'])) {

                $post = array(
                    'method' => 'POST',
                    'body' => array('grant_type' => "authorization_code",
                        'client_id' => jwOpt::get_option('i_client_id', ''),
                        'client_secret' => jwOpt::get_option('i_client_secret', ''),
                        'redirect_uri' => JAW_SITE_URL . "/wp-admin/themes.php?page=optionsframework",
                        'code' => $_GET['code']
                    )
                );

                $reponse = wp_remote_retrieve_body(wp_remote_request('https://api.instagram.com/oauth/access_token', $post));
                $token_info = json_decode($reponse);
            }
            if (isset($token_info) && isset($token_info->access_token)) {
                $evalue = $token_info->access_token;
            } else if (isset($token_info) && isset($token_info->error_message)){
                $output .= "ERROR: " . $token_info->error_message;
            } 
            if ($evalue != '') {
                $a_default = 'init_item(\'' . $value['id'] . '\',\'' . $evalue . '\');';
                $output .= '<input class="of-input" name="' . $value['id'] . '"   id="' . self::convert($value['id']) . '" type="text" value="' . $evalue . '" ng-model="edit[\'' . $value['id'] . '\']" ng-init="' . $a_default . '"/><br>';
                $output .= 'The string before dot is your User ID (needed in the J&W - Social Widget).';
            }
            return $output;
        }


        public static function element_youtube($value, $data = null) {

            if (isset($data)) {
                $evalue = $data;
            } else if (isset($value['std'])) {
                $evalue = $value['std'];
            } else {
                $evalue = array();
            }
            $a_default = '';
            $output = '';
            if (jwOpt::get_option('y_client_id', '') != '' && jwOpt::get_option('y_client_secret', '') != '') {
                $output .= "<a href='https://accounts.google.com/o/oauth2/auth?client_id=".jwOpt::get_option('y_client_id', '')."&redirect_uri=" . JAW_SITE_URL ."/wp-admin/themes.php?page=optionsframework&scope=https://www.googleapis.com/auth/youtube&response_type=code&access_type=offline'>Get YouTube Access Token</a><div class='clear'></div>";
            } else {
                $output .= 'To make this option available, please set both the Client ID and Client Secret items above. Save and refresh this page (F5).';
            }
            if (isset($_GET['code'])) {
                $post = array(
                    'method' => 'POST',
                    'body' => array('grant_type' => "authorization_code",
                        'client_id' => jwOpt::get_option('y_client_id', ''),
                        'client_secret' => jwOpt::get_option('y_client_secret', ''),
                        'redirect_uri' => JAW_SITE_URL . "/wp-admin/themes.php?page=optionsframework",
                        'code' => $_GET['code']
                    )
                );
                $reponse = wp_remote_retrieve_body(wp_remote_request('https://accounts.google.com/o/oauth2/token', $post));
                $token_info = json_decode($reponse);
                if (isset($token_info->access_token)) {
                    $evalue['access_token'] = $token_info->access_token;
                }
                if(isset($token_info->refresh_token)){
                    $evalue['refresh_token'] = $token_info->refresh_token;
                    jwOpt::update_one_option($value['id'],$evalue);
                    wp_redirect(JAW_SITE_URL ."/wp-admin/themes.php?page=optionsframework");
                    exit();
                }else{
                    $output .= '<i class="jaw-icon-warning"></i> <strong>Error: Cannot recieve refresh token.</strong><br>Please remove your application from <a href="https://security.google.com/settings/u/0/security/permissions" target="_blank">here</a><br>';
                }
                if(isset($token_info->error)){
                    $output .= '<i class="jaw-icon-warning"></i> <strong>Error: '.$token_info->error . '</strong><br>';
                }
                if(isset($token_info->error_description)){
                    $output .= $token_info->error_description.'<br>';
                }
            } 
            if (!empty($evalue)) {
               if (isset($evalue['access_token'] )) {
                    $a_default = 'init_item(\'' . $value['id'] . '_access_token\',\'' . $evalue['access_token'] . '\');';
                    $output .= '<input class="of-input" name="' . $value['id'] . '[access_token]"   id="' . self::convert($value['id']) . '_access_token" type="text" value="' . $evalue['access_token'] . '" ng-model="edit[\'' . $value['id'] . '_access_token\']" ng-init="' . $a_default . '"/><br>';
                }
                if (isset($evalue['refresh_token'] )) {
                    $a_default = 'init_item(\'' . $value['id'] . '_refresh_token\',\'' . $evalue['refresh_token'] . '\');';
                    $output .= '<input class="of-input" name="' . $value['id'] . '[refresh_token]"   id="' . self::convert($value['id']) . '_refresh_token" type="text" value="' . $evalue['refresh_token'] . '" ng-model="edit[\'' . $value['id'] . '_refresh_token\']" ng-init="' . $a_default . '"/><br>';           
                    
                    $output .= 'To get your YouTube Channel ID, please go <a href="https://www.youtube.com/account_advanced" target="_blank">HERE</a>.';
                }
            }

            return $output;
        }
        
          public static function element_facebook($value, $data = null) {

            if (isset($data)) {
                $evalue = $data;
            } else if (isset($value['std'])) {
                $evalue = $value['std'];
            } else {
                $evalue = '';
            }
            $a_default = '';
            $output = '';
            $reponse = '';
            if (jwOpt::get_option('fbcomments_appid', '') != '' && jwOpt::get_option('fbcomments_secret', '') != '' && $evalue == '') {      
                 $reponse = wp_remote_retrieve_body(wp_remote_request("https://graph.facebook.com/oauth/access_token?client_id=".jwOpt::get_option('fbcomments_appid', '')."&client_secret=" .jwOpt::get_option('fbcomments_secret', '')."&grant_type=client_credentials", array('method' => 'GET')));     
                if ($reponse instanceof WP_Error) {
                    $output .= 'Error';
                }
                $json_reponse = json_decode($reponse);
                if(isset($json_reponse->error)){
                    $output .= 'Error: '.$json_reponse->error->message;
                }
                if ($reponse != '' && strpos($reponse,'access_token') !== false) {
                    $evalue = substr($reponse, 13); 
                }
            }
            
            if($evalue != ''){
                $a_default = 'init_item(\'' . $value['id'] . '\',\'' . $evalue . '\');';
                $output .= '<input class="of-input large" name="' . $value['id'] . '"   id="' . self::convert($value['id']) . '" type="text" value="' . $evalue . '" ng-model="edit[\'' . $value['id'] . '\']" ng-init="' . $a_default . '"/><br>';
            }else{
                $output .= 'To make this option available, please set both the Client ID and Client Secret items above. Save and refresh this page (F5).';
            }
            
            return $output;
        }

        
        public static function element_transfer($value, $data = null) {
            $output = '';

            $instructions = $value['desc'];
            switch ($value['target']) {
                case 'themeoptions': $output .= '<textarea id="export_data_'.'import_options_'.'themeoptions" rows="8">' . jwUtils::jaw_base64_enc(serialize(jwOpt::get_options())) . '</textarea>' . "\n";
                    $output .= '<a href="#" class="of_import_button button" data-type="import_options"  target="themeoptions" title="Restore Options" copy-to-clipboard="Restore Options">Import...</a>';
                    break;
                case 'menus': $output .= '<textarea id="export_data_'.'import_options_'.'menus" rows="8">' . jwUtils::jaw_base64_enc(serialize(jwOpt::get_options('menus'))) . '</textarea>' . "\n";
                    $output .= '<a href="#" class="of_import_button button" data-type="import_options" target="menus" title="Restore Options" copy-to-clipboard="Restore Options">Import...</a>';
                    break;
                case 'category': $output .= '<textarea id="export_data_'.'import_options_'.'category" rows="8">' . jwUtils::jaw_base64_enc(serialize(jwOpt::get_options('category'))) . '</textarea>' . "\n";
                    $output .= '<a href="#" class="of_import_button button" data-type="import_options" target="category" title="Restore Options" copy-to-clipboard="Restore Options">Import...</a>';
                    break;
                case 'all': 
                $export = array(
                  'options' => jwOpt::get_options('opt'),
                  'category' => jwOpt::get_options('category'),
                  //'jaw-menu-location' => get_option('jaw-menu-location'),
                  //'jaw_color_preset' => get_option('jaw_color_preset'),
                  'category_preset' => jwOpt::loadAllPresets('category'),
                  'single_preset' => jwOpt::loadAllPresets('single'),
                  'color_preset' => jwOpt::loadAllPresets('color'),
                  'revo_preset' => jwOpt::loadAllPresets('revo'),
                  'revoelement_preset' => jwOpt::loadAllPresets('revoelement')
                );
                $output .= '<textarea id="export_data_'.'import_all_'.'all" rows="8">' . jwUtils::jaw_base64_enc(serialize($export)) . '</textarea>' . "\n";
                    $output .= '<a href="#" class="of_import_button button" data-type="import_all" target="all" title="Restore Options" copy-to-clipboard="Restore Options">Import...</a>';
                    break;
            }
            return $output;
        }

       

        public static function element_advselect($value, $data = null) {
            $output = '';

            if (isset($data)) {
                $evalue = $data;
            } else if (isset($value['std'])) {
                $evalue = $value['std'];
            } else {
                $evalue = '';
            }
            $a_default = 'init_item(\'' . $value['id'] . '\',\'' . $evalue . '\');';
            $options = array();
            if (isset($value['target']) && !is_null($value['target'])) {
                $options += jwElements::get_select_target($value['target']);
            }
            if (isset($value['chosen']) && $value['chosen'] == true) {
                $class[] = 'jaw-chosen';
            }

            $class = $class ? ' class="' . implode(' ', $class) . '"' : '';


            $output.= '<select ng-init="' . $a_default . '" ng-model="edit[\'' . $value['id'] . '\']" ' . $class . ' name="' . $value['id'] . '" id="' . self::convert($value['id']) . '">';
            if (isset($value['prompt']) && !is_null($value['prompt'])) {
                $output.= '<option value="">' . $value['prompt'] . '</option>';
            }

            if (is_array($options)) {
                foreach ($options as $key => $option) {
                    if (is_array($option)) {
                        $output.= '<optgroup label="' . $key . '">';
                        foreach ($option as $k => $o) {
                            $output.= '<option value="' . $k . '"';
                            if ($k == $evalue) {
                                $output.= ' selected="selected"';
                            }
                            $output.= '>' . $o . '</option>';
                        }
                        $output.= "</optgroup>";
                    } else {
                        $output.= '<option value="' . $key . '"';
                        if ($key == $evalue) {
                            $output.= ' selected="selected"';
                        }
                        $output.= '>' . $option . '</option>';
                    }
                }
            }
            if (isset($value['page']) && !is_null($value['page'])) {
                $depth = $value['page'];
                $args = array(
                    'depth' => $value['depth'], 'child_of' => 0,
                    'selected' => $evalue, 'echo' => 1,
                    'name' => 'page_id', 'id' => '',
                    'show_option_none' => '', 'show_option_no_change' => '',
                    'option_none_value' => ''
                );
                $pages = get_pages($args);

                $output.= walk_page_dropdown_tree($pages, $depth, $args);
            }

            $output.= '</select>';


            return $output;
        }

        public static function element_multidropdown($value, $data = null) {
            $output = '';
            $a_default = '';
            if (isset($data)) {
                $evalue = $data;
            } else if (isset($value['std'])) {
                $evalue = $value['std'];
            } else {
                $evalue = '';
            }

     
                $a_default = 'init_item(\'' . $value['id'] . '\',\'' . implode(',', (array) $evalue) . '\');';
            
            if (isset($value['options']))
                $options = $value['options'];
            else
                $options = array();
            if (isset($value['target']) && !is_null($value['target'])) {
                $options += jwElements::get_select_target($value['target']);
            }
            $class = array();
            if (isset($value['chosen']) && $value['chosen'] == true) {
                $class[] = 'jaw-chosen';
            }
            if (isset($value['mod']))
                $class[] = $value['mod'];

            $class = ' class="' . implode(' ', $class) . '"';

            if (!is_null($value['page'])) {
                $depth = $value['page'];
                $pages = get_pages();
            };
            if (!empty($value['prompt'])) {
                $value['prompt'] = 'data-placeholder="' . $value['prompt'] . '"';
            }

            if (!isset($value['size'])) {
                $value['size'] = '6';
            }
            $angular = '';
  
                $angular = 'ng-model="edit[\'' . $value['id'] . '\']" ng-init="' . $a_default . '"';
            

            $output.= '<select  ' . $class . ' ' . $value['prompt'] . '  multiple="true" size="' . $value['size'] . '" style="height:auto" name="' . $value['id'] . '[]" id="' . $value['id'] . '" ' . $angular . '>';

            foreach ($options as $key => $option) {
                if (is_array($option)) {
                    $output.= '<optgroup label="' . $key . '">';
                    foreach ($option as $k => $o) {
                        $output.= '<option value="' . $k . '"';
                        if (is_array($value) && in_array($k, $value)) {
                            $output.= ' selected="selected"';
                        }
                        $output.= '>' . $o . '</option>';
                    }
                    $output.= "</optgroup>";
                } else {
                    $output.= '<option value="' . $key . '"';
                    if (is_array($evalue) && in_array($key, $evalue)) {
                        $output.= ' selected="selected"';
                    }
                    $output.= '>' . $option . '</option>';
                }
            }
            if (!is_null($value['page'])) {
                $args = array(
                    'depth' => $value['page'], 'child_of' => 0,
                    'selected' => $evalue, 'echo' => 1,
                    'name' => 'page_id', 'id' => '',
                    'show_option_none' => '', 'show_option_no_change' => '',
                    'option_none_value' => ''
                );
                $output.= jwElements::walk_page_multi_select_tree($pages, $depth, $args);
            }
            $output.= '</select>';


            return $output;
        }

        public static function element_toggle($value, $data = null) {
            $output = '';
           
            
            $std = '';
            if(isset($value['std'])){
                $std = $value['std'];
            }
            
            $evalue = self::checkDefault($data, $std);
            $evalue = jwUtils::sanitizeJson($evalue);

            //pokud se spatne ulozi to, tak nastaveni vyresetuj
            if(is_string($evalue) && strpos($evalue, '{{') !== false){
                $evalue = $std;
            }
            
            if(isset($value['options'])){
                $options = jwUtils::jsonEncode($value['options']); 
            }else{
                $options = jwUtils::jsonEncode(array("0" => "Off", "1" => "On"));
            }
            
            $output .= '<jwd-toggle 
                            options="'.$options.'" 
                            ng-init="init_item(\'' . $value['id'] . '\',\'' . $evalue. '\');" 
                            selected="edit[\'' . $value['id'] . '\']">
                        </jwd-toggle>';
            $output.= '<input type="hidden" name="' . $value['id'] . '" value="{{edit[\'' . $value['id'] . '\']}}" ng-model="edit[\'' . $value['id'] . '\']" />';
           

            return $output;
        }

        /*
         * upravi vstupni ID elementu pro pouziti menu
         * 
         */

        public static function convert($id) {
            $id = str_replace('[', '-', $id);
            $id = str_replace(']', '', $id);

            return $id;
        }


        public static function element_range($value, $data = null) {
            $output = '';
            $a_default = '';
            if (isset($data)) {
                $evalue = $data;
            } else if (isset($value['std'])) {
                $evalue = $value['std'];
            } else {
                $evalue = '';
            }
            $a_default = 'init_item(\'' . $value['id'] . '\',\'' . $evalue . '\');';

            if (isset($value['min']) && !is_null($value['min'])) {
                $min = $value['min'];
            }
            if (isset($value['max']) && !is_null($value['max'])) {
                $max = $value['max'];
            }
            if (isset($value['step']) && !is_null($value['step'])) {
                $step = $value['step'];
            }

            $output.='<div class="slider">';
            $output.= '<div ui-slider min="' . $min . '" max="' . $max . '" step="' . $step . '" ng-model="edit[\'' . $value['id'] . '\']" ng-init="' . $a_default . '"></div>';
            $output.= '<input type="text" name="' . $value['id'] . '" id="' . self::convert($value['id']) . '"  class="regular-text" value="{{edit[\'' . $value['id'] . '\']}}" ng-model="edit[\'' . $value['id'] . '\']" />';
            if (!is_null($value['unit'])) {
                $output.= '<div class="unit">' . $value['unit'] . '</div>';
            }
            $output.='</div>';

            return $output;
        }

        public static function element_builder($value, $data = null) {
            if (!isset($value['editor'])) {
                $value['editor'] = 'true';
            }
            if (!isset($value['edit_name'])) {
                $value['edit_name'] = 'true';
            }
            if (!isset($value['img'])) {
                $value['img'] = '';
            }
            if (!isset($value['icon'])) {
                $value['icon'] = '';
            }
            $output = '';
            
            $output .= '<div class="element_button button-' . $value['id'] . '"   ng-click="add_element({type:\'' . $value['id'] . '\', size:\'' . $value['size'] . '\'},\'2_content\');" >';
            if (!empty($value['help'])) {
                $output .= '<jwd-help '; 
                if(isset($value['help'][0]) && $value['help'][0] !== ""){
                    $output .= 'title="'.$value['help'][0].'" copy-to-clipboard="'.$value['help'][0].'" ';
                }
                if(isset($value['help'][1]) && $value['help'][1] !== ""){
                    $output .= 'description="'.$value['help'][1].'" ';
                }
                if(isset($value['help'][2]) && $value['help'][2] !== ""){
                    $output .= 'img-src="'.$value['help'][2].'" ';
                }
                $output .= '>'; 
            }
            $output .= '<div class="element_button_inner">';
            $output .= '<input type="hidden" />';
            $output .= '<span class="element_icon ' . $value['icon'] . '"></span>';
            $output .= '<span class="element_text ">' . $value['name'] . '</span>';
            $output .= '</div>';
            if (isset($value['desc'])) {
                $output .= '</jwd-help>';
            }
            $output .= '</div>';

            return $output;
        }
        
        
        public static function element_jaw_builder($value, $data = null){
            $out = '';  
            if (jwOpt::get_option('theme_revoComposer', '1') == '1' && class_exists('JawShortcodes')) {

                if (isset($data)) {
                    $jaw_pb = maybe_unserialize($data);
                } else {
                    $jaw_pb = '';
                }
                $out = '';            
                $out .= '<div  class="jaw_builder_app" ng-controller="jwPbBuilderController">';
                $outputs = '';
                $revo_field = array();
                foreach((array) $value['content'] as $field){
                    $outputs.= self::elements_machine($field, $data, 'builder');
                    if (isset($field['content']) && isset($field['id']) && $field['id'] == 'build_all') {
                        $revo_field[] = $field['content'];
                    }
                }
                $out .= jwBuilder::printBuilderInMetabox($outputs);
                $out .= '<input type="hidden" name="'.$value['id'] .'" value="{{workspace}}" ng-model="workspace" ng-init="init_builder(\''.$value['id'].'\');" />';
                $out .= '<script>';
                $out .= 'var jw_pb = jw_pb || [];';
                $out .= 'jw_pb[\''.$value['id'].'\'] = '. json_encode($jaw_pb).';';
                $out .= 'var jw_fields = ' . json_encode($revo_field).';';
                $out .= 'var jw_areas = '.$value['areas'].';';
                $out .= '</script>';
                $out .= '</div>';
            } else {
                $out .= '<div class="of-info description"><p style="color:#1E8CBE;font-weight:bold;">Please activate JaW Shortcotes plugin and turn on RevoComposer in Theme Options ->General Settings -> Use RevoComposer</p></div>';
            }
            
            return $out;
        }

        public static function element_builder_bookmark($value, $data = null) {
            $output = '';
            $icon = '';
            if (isset($value['icon'])) {
                $icon = '<i class="' . $value['icon'] . '"></i>';
            }
            $output .= '<div class="builder_bookmark" >';
            $output .= '<div class="element_button" ng-class="{active: current_bookmark == \'bookmark-' . $value['id'] . '\'}"  ng-click="current_bookmark = \'bookmark-' . $value['id'] . '\'; searchText = \'\'" >' . $icon . $value['name'] . '</div>';
            if (isset($value['content'])) {
                $output .= '<script id="bookmark-' . $value['id'] . '" type="text/ng-template">';

                if (is_array($value['content'])) {
                    foreach ((array) $value['content'] as $sub) {
                        $element = 'element_' . $sub['type'];
                        $output .= '<li class="' . $sub['id'] . '" ng-show="isSearch(\'' . $sub['name'] . '\');" >' . jwElements::$element($sub) . '</li>';
                    }
                }

                $output .= '</script>';
            }
            $output .= '</div>';
            return $output;
        }

        public static function element_preset($value, $data = null) {
            $output = '';

            foreach ($value['options'] as $key => $option) {
                $output .= "<div  class='pb-settings radio-preset'  ng-click='load_preset(\"" . addslashes(json_encode($option['content'])) . "\",\"" . addslashes($option['layout']) . "\",\"" . addslashes(json_encode($option['layout-size'])) . "\")'>";
                $output .= '<label >';
                $output .= '<img alt="page-option-preset" src="' . $option['img'] . '" />';
                $output .= '</label>';
                $output .= '</div>';
            }

//CUSTOM
            $output .= "<div  class='pb-settings radio-preset' ng-repeat='(ip,preset) in presets.revo' >";
            $output .= '<label >';
            $output .= '<div class="custom_preset">';
            $output .= '<div><h5>{{preset.title}}</h5></div>';
            $output .= '<span class="load-preset" title="Load this preset" copy-to-clipboard="Load this preset" ng-click="load_preset(preset.id)"><i class="jaw-icon-folder-open" ng-show="!loader[\'load_\'+preset.id]"></i><i  class="jaw-icon-spinner2 jaw-spinit" ng-show="loader[\'load_\'+preset.id]"></i></span>';
            $output .= '<span class="save-preset" title="Save actual content into this preset" copy-to-clipboard="Save actual content into this preset" ng-click="save_preset(workspace, preset, \'revo\')"><i class="jaw-icon-disk " ng-show="!loader[\'save_\'+preset.id]"></i><i  class="jaw-icon-spinner2 jaw-spinit" ng-show="loader[\'save_\'+preset.id]"></i></span>';
            $output .= '<span class="delete-preset" title="Delete this preset" copy-to-clipboard="Delete this preset" ng-click="delete_preset(ip, preset,\'revo\')"><i class=" jaw-icon-close " ng-show="!loader[\'delete_\'+preset.id]"></i><i  class="jaw-icon-spinner2 jaw-spinit" ng-show="loader[\'delete_\'+preset.id]"></i></span>';
            $output .= '</div>';
            $output .= '</label>';
            $output .= '</div>';

//PLUS    
            $output .= '<div  class="pb-settings radio-preset" title="Create new preset from actual content" copy-to-clipboard="Create new preset from actual content" ng-click="add_preset(workspace,0,\'revo\');">';
            $output .= '<label >';
            $output .= '<img alt="page-option-preset" src="' . JAW_ADMIN_URI . 'assets/images/plus.png' . '" />';
            $output .= '</label>';
            $output .= '</div>';
            return $output;
        }

        public static function element_element_preset($value, $data = null) {
            $output = '';

//CUSTOM
            $output .= "<div ng-hide='presets.revoelement.length' >";
            $output .= jwUtils::getHelp("How to add Element Preset", "Simply click the <i class='jaw-icon-copy'></i> icon on any element", "element-presets.jpg");
            $output .= "</div>";
            $output .= "<div  class='pb-settings radio-preset' ng-repeat='(ip,preset) in presets.revoelement' >";
            $output .= '<label >';
            $output .= '<div class="custom_element_presets">';
            $output .= '<div><h5>{{preset.title}}</h5></div>';
            $output .= '<span class="load-preset" title="Insert this preset into page content" copy-to-clipboard="Insert this preset into page content" ng-click="load_element_preset(preset.id)"><i class="jaw-icon-folder-open" ng-show="!loader[\'load_\'+preset.id]"></i><i  class="jaw-icon-spinner2 jaw-spinit" ng-show="loader[\'load_\'+preset.id]"></i></span>';
            $output .= '<span class="delete-preset" title="Delete this preset" copy-to-clipboard="Delete this preset" ng-click="delete_preset(ip, preset, \'revoelement\')"><i class=" jaw-icon-close " ng-show="!loader[\'delete_\'+preset.id]"></i><i  class="jaw-icon-spinner2 jaw-spinit" ng-show="loader[\'delete_\'+preset.id]"></i></span>';
            $output .= '</div>';
            $output .= '</label>';
            $output .= '</div>';


            return $output;
        }

        /**
         * Ajax image uploader - supports various types of image types
         *
         * @uses get_option()
         *
         * @access public
         * @since 1.0.0
         *
         * @return string
         */
        public static function elements_uploader_function($id, $std, $mod, $data) {


            $uploader = '';
            $upload = $data;
            $hide = '';



            if ($upload != "") {
                $val = $upload;
            } else {
                $val = $std;
            }

            $uploader .= '<input class="' . $mod . ' upload of-input" name="' . $id . '" id="' . $id . '_upload" value="' . $val . '" />';

            $uploader .= '<div class="upload_button_div"><span class="button image_upload_button" id="' . $id . '">' . esc_html__('Upload', "gdn-theme") . '</span>';

            if (!empty($upload)) {
                $hide = '';
            } else {
                $hide = 'hide';
            }
            $uploader .= '<span class="button image_reset_button ' . $hide . '" id="reset_' . $id . '" title="' . $id . '" copy-to-clipboard="' . $id . '">' . esc_html__('Remove', "gdn-theme") . '</span>';
            $uploader .='</div>' . "\n";
            $uploader .= '<div class="clear"></div>' . "\n";
            if (!empty($upload)) {
                $uploader .= '<div class="screenshot">';
                $uploader .= '<a class="of-uploaded-image" href="' . $upload . '" target="_blank">';
                $uploader .= '<img class="of-option-image jaw-lazy" id="image_' . $id . '" src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7" data-src="' . $upload . '" />';
                $uploader .= '</a>';
                $uploader .= '</div>';
            }
            $uploader .= '<div class="clear"></div>' . "\n";

            return $uploader;
        }



        /**
         * Drag and drop slides manager
         *
         * @uses get_option()
         *
         * @access public
         * @since 1.0.0
         *
         * @return string
         */
        public static function elements_slider_function($id, $std, $oldorder, $order, $int, $data) {


            $slider = '';
            $slide = array();
            $slide = $data;

            if (isset($slide[$oldorder])) {
                $val = $slide[$oldorder];
            } else {
                $val = $std;
            }

//initialize all vars
            $slidevars = array('title', 'url', 'link', 'description');

            foreach ($slidevars as $slidevar) {
                if (!isset($val[$slidevar])) {
                    $val[$slidevar] = '';
                }
            }

//begin slider interface	
            if (!empty($val['title'])) {
                $slider .= '<li><div class="slide_header"><strong>' . stripslashes($val['title']) . '</strong>';
            } else {
                $slider .= '<li><div class="slide_header"><strong>Slide ' . $order . '</strong>';
            }

            $slider .= '<input type="hidden" class="slide of-input order" name="' . $id . '[' . $order . '][order]" id="' . $id . '_' . $order . '_slide_order" value="' . $order . '" />';

            $slider .= '<a class="slide_edit_button" href="#">Edit</a></div>';

            $slider .= '<div class="slide_body">';

            $slider .= '<label>Title</label>';
            $slider .= '<input class="slide of-input of-slider-title" name="' . $id . '[' . $order . '][title]" id="' . $id . '_' . $order . '_slide_title" value="' . stripslashes($val['title']) . '" />';

            $slider .= '<label>Image URL</label>';
            $slider .= '<input class="slide of-input" name="' . $id . '[' . $order . '][url]" id="' . $id . '_' . $order . '_slide_url" value="' . $val['url'] . '" />';

            $slider .= '<div class="upload_button_div"><span class="button media_upload_button" id="' . $id . '_' . $order . '" rel="' . $int . '">Upload</span>';

            if (!empty($val['url'])) {
                $hide = '';
            } else {
                $hide = 'hide';
            }
            $slider .= '<span class="button mlu_remove_button ' . $hide . '" id="reset_' . $id . '_' . $order . '" title="' . $id . '_' . $order . '" copy-to-clipboard="' . $id . '_' . $order . '">Remove</span>';
            $slider .='</div>' . "\n";
            $slider .= '<div class="screenshot">';
            if (!empty($val['url'])) {

                $slider .= '<a class="of-uploaded-image" href="' . $val['url'] . '" target="_blank">';
                $slider .= '<img class="of-option-image" id="image_' . $id . '_' . $order . '" src="' . $val['url'] . '" alt="" />';
                $slider .= '</a>';
            }
            $slider .= '</div>';
            $slider .= '<label>Link URL (optional)</label>';
            $slider .= '<input class="slide of-input" name="' . $id . '[' . $order . '][link]" id="' . $id . '_' . $order . '_slide_link" value="' . $val['link'] . '" />';

            $slider .= '<label>Description (optional)</label>';
            $slider .= '<textarea class="slide of-input" name="' . $id . '[' . $order . '][description]" id="' . $id . '_' . $order . '_slide_description" cols="8" rows="8">' . stripslashes($val['description']) . '</textarea>';

            $slider .= '<a class="slide_delete_button" href="#">Delete</a>';
            $slider .= '<div class="clear"></div>' . "\n";

            $slider .= '</div>';
            $slider .= '</li>';

            return $slider;
        }

        public static function elements_tabs_function($id, $std, $oldorder, $order) {

            $data = get_option(JAW_OPTIONS);
            $slider = '';
            $slide = array();
            if (isset($data[$id]))
                $slide = $data[$id];


//initialize all vars

            $slider .= '<li ng-repeat="(ide,ed) in edit.' . $id . ' track by ide"><div class="slide_header" >';
//begin slider interface	
            $slider .= '<strong>Content {{ide+1}} {{ed[\'title\']}}</strong>';

            $slider .= '<input type="hidden" class="slide of-input order" name="' . $id . '[' . $order . '][order]" id="' . $id . '_' . $order . '_slide_order" value="' . $order . '" />';

            $slider .= '<a class="slide_edit_button" href="#"></a></div>';

            $slider .= '<div class="slide_body">';

            $slider .= '<label>Title</label>';
            $slider .= '<input ng-model="ed[\'title\']" class="slide of-input of-slider-title" name="' . $id . '[' . $order . '][title]" id="' . $id . '_' . $order . '_slide_title" value="{{ed[\'title\']}}" />';

            $slider .= '<label>Description (optional)</label>';
            $slider .= '<textarea ng-model="ed[\'description\']" class="slide of-input" name="' . $id . '[' . $order . '][description]" id="' . $id . '_' . $order . '_slide_description" cols="8" rows="8"></textarea>';

            $slider .= '<a class="slide_delete_button" href="#" ng-click="del_edit(\'' . $id . '\',ide);"><i class="jaw-icon-close"></i></a>';
            $slider .= '<div class="clear"></div>' . "\n";

            $slider .= '</div>';
            $slider .= '</li>';

            return $slider;
        }

        function walk_page_multi_select_tree() {
            $args = func_get_args();
            if (empty($args[2]['walker']))
                $walker = new Walker_PageMultiSelect;
            else
                $walker = $args[2]['walker'];

            return call_user_func_array(array(&$walker, 'walk'), $args);
        }

        /**
         * Target generator
         */
        public static function get_select_target($typ) {
            $options = array();
            switch ($typ) {
                case 'cat':
                    $entries = get_categories('orderby=name&hide_empty=0');
                    foreach ($entries as $key => $entry) {
                        $options[$entry->term_id] = $entry->name;
                    }
                    break;
                case 'tag':
                    $entries = get_tags('orderby=name&hide_empty=0');
                    foreach ($entries as $key => $entry) {
                        $options[$entry->term_id] = $entry->name;
                    }
                    break;
                case 'page':
                    $entries = get_pages('title_li=&orderby=name');
                    $options["_default"] = "None";
                    foreach ($entries as $key => $entry) {
                        $options[$entry->ID] = $entry->post_title;
                    }
                    break;
                case 'post':
                    $entries = get_posts('orderby=title&numberposts=-1&order=ASC&suppress_filters=0');
                    foreach ($entries as $key => $entry) {
                        $options[$entry->ID] = $entry->post_title;
                    }
                    break;
                case 'author':
                    $attrs = array(
                        'role__not_in' => array('Subscriber') //since WP 4.4
                    );
                    $blogusers = get_users( $attrs );
                    foreach ($blogusers as $user) {
                        $options[$user->ID] = $user->display_name;
                    }
                    break;

                case 'portfolio':
                    $entries = get_posts('post_type=portfolio&orderby=title&numberposts=-1&order=ASC&suppress_filters=0');
                    foreach ($entries as $key => $entry) {
                        $options[$entry->ID] = $entry->post_title;
                    }
                    break;
                case 'gallery':
                    $options["_default"] = "None";
                    $entries = get_posts('post_type=jaw-gallery&orderby=title&numberposts=-1&order=ASC&suppress_filters=0');
                    foreach ($entries as $key => $entry) {
                        $options[$entry->ID] = $entry->post_title;
                    }
                    break;
                case 'portfolio-category':
                    $entries = get_terms('jaw-portfolio-category', 'orderby=name&hide_empty=0&suppress_filters=0');
                    foreach ((array) $entries as $key => $entry) {
                        if (isset($entry->slug) && isset($entry->name)) {
                            $options[$entry->slug] = $entry->name;
                        }
                    }
                    break;
                case 'faq-category':
                    $entries = get_terms('jaw-faq-category', 'orderby=name&hide_empty=0&suppress_filters=0');
                    foreach ((array) $entries as $key => $entry) {
                        if (isset($entry->slug) && isset($entry->name)) {
                            $options[$entry->slug] = $entry->name;
                        }
                    }
                    break;

                case 'team-category':
                    $entries = get_terms('jaw-team-category', 'orderby=name&hide_empty=0&suppress_filters=0');
                    foreach ((array) $entries as $key => $entry) {
                        if (isset($entry->slug) && isset($entry->name)) {
                            $options[$entry->slug] = $entry->name;
                        }
                    }
                    break;
                case 'testimonial-category':
                    $entries = get_terms('jaw-testimonial-category', 'orderby=name&hide_empty=0&suppress_filters=0');
                    foreach ((array) $entries as $key => $entry) {
                        if (isset($entry->slug) && isset($entry->name)) {
                            $options[$entry->slug] = $entry->name;
                        }
                    }
                    break;

                case 'post_types':
                    foreach (get_post_types(array('public' => true), 'objects') as $post_type) {
                        $options[$post_type->name] = $post_type->labels->name . ' (' . $post_type->name . ')';
                    }
                    break;
                case 'products':
                    $entries = get_posts('post_type=product&orderby=title&numberposts=-1&order=ASC&suppress_filters=0');
                    foreach ($entries as $key => $entry) {
                        $options[$entry->ID] = $entry->post_title;
                    }
                    break;
                case 'product_cat':
                    $entries = get_terms('product_cat', 'orderby=name&hide_empty=0&suppress_filters=0');
                    foreach ((array) $entries as $key => $entry) {
                        if (isset($entry->slug) && isset($entry->name)) {
                            $options[$entry->slug] = $entry->name;
                        }
                    }
                    break;

                case 'product_cat_id':
                    $entries = get_terms('product_cat', 'orderby=name&hide_empty=0&suppress_filters=0');
                    foreach ((array) $entries as $key => $entry) {
                        if (isset($entry->term_id) && isset($entry->name)) {
                            $options[$entry->term_id] = $entry->name;
                        }
                    }
                    break;
                case 'product_tag':
                    $entries = get_terms('product_tag', 'orderby=name&hide_empty=0&suppress_filters=0');
                    foreach ((array) $entries as $key => $entry) {
                        if (isset($entry->slug) && isset($entry->name)) {
                            $options[$entry->slug] = $entry->name;
                        }
                    }
                    break;
                case 'google_fonts':
                    $options = array('ABeeZee' => 'ABeeZee', 'Abel' => 'Abel', 'Abril Fatface' => 'Abril Fatface', 'Aclonica' => 'Aclonica', 'Acme' => 'Acme', 'Actor' => 'Actor', 'Adamina' => 'Adamina', 'Advent Pro' => 'Advent Pro', 'Aguafina Script' => 'Aguafina Script', 'Akronim' => 'Akronim', 'Aladin' => 'Aladin', 'Aldrich' => 'Aldrich', 'Alef' => 'Alef', 'Alegreya' => 'Alegreya', 'Alegreya SC' => 'Alegreya SC', 'Alegreya Sans' => 'Alegreya Sans', 'Alegreya Sans SC' => 'Alegreya Sans SC', 'Alex Brush' => 'Alex Brush', 'Alfa Slab One' => 'Alfa Slab One', 'Alice' => 'Alice', 'Alike' => 'Alike', 'Alike Angular' => 'Alike Angular', 'Allan' => 'Allan', 'Allerta' => 'Allerta', 'Allerta Stencil' => 'Allerta Stencil', 'Allura' => 'Allura', 'Almendra' => 'Almendra', 'Almendra Display' => 'Almendra Display', 'Almendra SC' => 'Almendra SC', 'Amarante' => 'Amarante', 'Amaranth' => 'Amaranth', 'Amatic SC' => 'Amatic SC', 'Amethysta' => 'Amethysta', 'Anaheim' => 'Anaheim', 'Andada' => 'Andada', 'Andika' => 'Andika', 'Angkor' => 'Angkor', 'Annie Use Your Telescope' => 'Annie Use Your Telescope', 'Anonymous Pro' => 'Anonymous Pro', 'Antic' => 'Antic', 'Antic Didone' => 'Antic Didone', 'Antic Slab' => 'Antic Slab', 'Anton' => 'Anton', 'Arapey' => 'Arapey', 'Arbutus' => 'Arbutus', 'Arbutus Slab' => 'Arbutus Slab', 'Architects Daughter' => 'Architects Daughter', 'Archivo Black' => 'Archivo Black', 'Archivo Narrow' => 'Archivo Narrow', 'Arimo' => 'Arimo', 'Arizonia' => 'Arizonia', 'Armata' => 'Armata', 'Artifika' => 'Artifika', 'Arvo' => 'Arvo', 'Asap' => 'Asap', 'Asset' => 'Asset', 'Astloch' => 'Astloch', 'Asul' => 'Asul', 'Atomic Age' => 'Atomic Age', 'Aubrey' => 'Aubrey', 'Audiowide' => 'Audiowide', 'Autour One' => 'Autour One', 'Average' => 'Average', 'Average Sans' => 'Average Sans', 'Averia Gruesa Libre' => 'Averia Gruesa Libre', 'Averia Libre' => 'Averia Libre', 'Averia Sans Libre' => 'Averia Sans Libre', 'Averia Serif Libre' => 'Averia Serif Libre', 'Bad Script' => 'Bad Script', 'Balthazar' => 'Balthazar', 'Bangers' => 'Bangers', 'Basic' => 'Basic', 'Battambang' => 'Battambang', 'Baumans' => 'Baumans', 'Bayon' => 'Bayon', 'Belgrano' => 'Belgrano', 'Belleza' => 'Belleza', 'BenchNine' => 'BenchNine', 'Bentham' => 'Bentham', 'Berkshire Swash' => 'Berkshire Swash', 'Bevan' => 'Bevan', 'Bigelow Rules' => 'Bigelow Rules', 'Bigshot One' => 'Bigshot One', 'Bilbo' => 'Bilbo', 'Bilbo Swash Caps' => 'Bilbo Swash Caps', 'Bitter' => 'Bitter', 'Black Ops One' => 'Black Ops One', 'Bokor' => 'Bokor', 'Bonbon' => 'Bonbon', 'Boogaloo' => 'Boogaloo', 'Bowlby One' => 'Bowlby One', 'Bowlby One SC' => 'Bowlby One SC', 'Brawler' => 'Brawler', 'Bree Serif' => 'Bree Serif', 'Bubblegum Sans' => 'Bubblegum Sans', 'Bubbler One' => 'Bubbler One', 'Buda' => 'Buda', 'Buenard' => 'Buenard', 'Butcherman' => 'Butcherman', 'Butterfly Kids' => 'Butterfly Kids', 'Cabin' => 'Cabin', 'Cabin Condensed' => 'Cabin Condensed', 'Cabin Sketch' => 'Cabin Sketch', 'Caesar Dressing' => 'Caesar Dressing', 'Cagliostro' => 'Cagliostro', 'Calligraffitti' => 'Calligraffitti', 'Cambo' => 'Cambo', 'Candal' => 'Candal', 'Cantarell' => 'Cantarell', 'Cantata One' => 'Cantata One', 'Cantora One' => 'Cantora One', 'Capriola' => 'Capriola', 'Cardo' => 'Cardo', 'Carme' => 'Carme', 'Carrois Gothic' => 'Carrois Gothic', 'Carrois Gothic SC' => 'Carrois Gothic SC', 'Carter One' => 'Carter One', 'Caudex' => 'Caudex', 'Cedarville Cursive' => 'Cedarville Cursive', 'Ceviche One' => 'Ceviche One', 'Changa One' => 'Changa One', 'Chango' => 'Chango', 'Chau Philomene One' => 'Chau Philomene One', 'Chela One' => 'Chela One', 'Chelsea Market' => 'Chelsea Market', 'Chenla' => 'Chenla', 'Cherry Cream Soda' => 'Cherry Cream Soda', 'Cherry Swash' => 'Cherry Swash', 'Chewy' => 'Chewy', 'Chicle' => 'Chicle', 'Chivo' => 'Chivo', 'Cinzel' => 'Cinzel', 'Cinzel Decorative' => 'Cinzel Decorative', 'Clicker Script' => 'Clicker Script', 'Coda' => 'Coda', 'Coda Caption' => 'Coda Caption', 'Codystar' => 'Codystar', 'Combo' => 'Combo', 'Comfortaa' => 'Comfortaa', 'Coming Soon' => 'Coming Soon', 'Concert One' => 'Concert One', 'Condiment' => 'Condiment', 'Content' => 'Content', 'Contrail One' => 'Contrail One', 'Convergence' => 'Convergence', 'Cookie' => 'Cookie', 'Copse' => 'Copse', 'Corben' => 'Corben', 'Courgette' => 'Courgette', 'Cousine' => 'Cousine', 'Coustard' => 'Coustard', 'Covered By Your Grace' => 'Covered By Your Grace', 'Crafty Girls' => 'Crafty Girls', 'Creepster' => 'Creepster', 'Crete Round' => 'Crete Round', 'Crimson Text' => 'Crimson Text', 'Croissant One' => 'Croissant One', 'Crushed' => 'Crushed', 'Cuprum' => 'Cuprum', 'Cutive' => 'Cutive', 'Cutive Mono' => 'Cutive Mono', 'Damion' => 'Damion', 'Dancing Script' => 'Dancing Script', 'Dangrek' => 'Dangrek', 'Dawning of a New Day' => 'Dawning of a New Day', 'Days One' => 'Days One', 'Delius' => 'Delius', 'Delius Swash Caps' => 'Delius Swash Caps', 'Delius Unicase' => 'Delius Unicase', 'Della Respira' => 'Della Respira', 'Denk One' => 'Denk One', 'Devonshire' => 'Devonshire', 'Didact Gothic' => 'Didact Gothic', 'Diplomata' => 'Diplomata', 'Diplomata SC' => 'Diplomata SC', 'Domine' => 'Domine', 'Donegal One' => 'Donegal One', 'Doppio One' => 'Doppio One', 'Dorsa' => 'Dorsa', 'Dosis' => 'Dosis', 'Dr Sugiyama' => 'Dr Sugiyama', 'Droid Sans' => 'Droid Sans', 'Droid Sans Mono' => 'Droid Sans Mono', 'Droid Serif' => 'Droid Serif', 'Duru Sans' => 'Duru Sans', 'Dynalight' => 'Dynalight', 'EB Garamond' => 'EB Garamond', 'Eagle Lake' => 'Eagle Lake', 'Eater' => 'Eater', 'Economica' => 'Economica', 'Ek Mukta' => 'Ek Mukta', 'Electrolize' => 'Electrolize', 'Elsie' => 'Elsie', 'Elsie Swash Caps' => 'Elsie Swash Caps', 'Emblema One' => 'Emblema One', 'Emilys Candy' => 'Emilys Candy', 'Engagement' => 'Engagement', 'Englebert' => 'Englebert', 'Enriqueta' => 'Enriqueta', 'Erica One' => 'Erica One', 'Esteban' => 'Esteban', 'Euphoria Script' => 'Euphoria Script', 'Ewert' => 'Ewert', 'Exo' => 'Exo', 'Exo 2' => 'Exo 2', 'Expletus Sans' => 'Expletus Sans', 'Fanwood Text' => 'Fanwood Text', 'Fascinate' => 'Fascinate', 'Fascinate Inline' => 'Fascinate Inline', 'Faster One' => 'Faster One', 'Fasthand' => 'Fasthand', 'Fauna One' => 'Fauna One', 'Federant' => 'Federant', 'Federo' => 'Federo', 'Felipa' => 'Felipa', 'Fenix' => 'Fenix', 'Finger Paint' => 'Finger Paint', 'Fira Mono' => 'Fira Mono', 'Fira Sans' => 'Fira Sans', 'Fjalla One' => 'Fjalla One', 'Fjord One' => 'Fjord One', 'Flamenco' => 'Flamenco', 'Flavors' => 'Flavors', 'Fondamento' => 'Fondamento', 'Fontdiner Swanky' => 'Fontdiner Swanky', 'Forum' => 'Forum', 'Francois One' => 'Francois One', 'Freckle Face' => 'Freckle Face', 'Fredericka the Great' => 'Fredericka the Great', 'Fredoka One' => 'Fredoka One', 'Freehand' => 'Freehand', 'Fresca' => 'Fresca', 'Frijole' => 'Frijole', 'Fruktur' => 'Fruktur', 'Fugaz One' => 'Fugaz One', 'GFS Didot' => 'GFS Didot', 'GFS Neohellenic' => 'GFS Neohellenic', 'Gabriela' => 'Gabriela', 'Gafata' => 'Gafata', 'Galdeano' => 'Galdeano', 'Galindo' => 'Galindo', 'Gentium Basic' => 'Gentium Basic', 'Gentium Book Basic' => 'Gentium Book Basic', 'Geo' => 'Geo', 'Geostar' => 'Geostar', 'Geostar Fill' => 'Geostar Fill', 'Germania One' => 'Germania One', 'Gilda Display' => 'Gilda Display', 'Give You Glory' => 'Give You Glory', 'Glass Antiqua' => 'Glass Antiqua', 'Glegoo' => 'Glegoo', 'Gloria Hallelujah' => 'Gloria Hallelujah', 'Goblin One' => 'Goblin One', 'Gochi Hand' => 'Gochi Hand', 'Gorditas' => 'Gorditas', 'Goudy Bookletter 1911' => 'Goudy Bookletter 1911', 'Graduate' => 'Graduate', 'Grand Hotel' => 'Grand Hotel', 'Gravitas One' => 'Gravitas One', 'Great Vibes' => 'Great Vibes', 'Griffy' => 'Griffy', 'Gruppo' => 'Gruppo', 'Gudea' => 'Gudea', 'Habibi' => 'Habibi', 'Halant' => 'Halant', 'Hammersmith One' => 'Hammersmith One', 'Hanalei' => 'Hanalei', 'Hanalei Fill' => 'Hanalei Fill', 'Handlee' => 'Handlee', 'Hanuman' => 'Hanuman', 'Happy Monkey' => 'Happy Monkey', 'Headland One' => 'Headland One', 'Henny Penny' => 'Henny Penny', 'Herr Von Muellerhoff' => 'Herr Von Muellerhoff', 'Hind' => 'Hind', 'Holtwood One SC' => 'Holtwood One SC', 'Homemade Apple' => 'Homemade Apple', 'Homenaje' => 'Homenaje', 'IM Fell DW Pica' => 'IM Fell DW Pica', 'IM Fell DW Pica SC' => 'IM Fell DW Pica SC', 'IM Fell Double Pica' => 'IM Fell Double Pica', 'IM Fell Double Pica SC' => 'IM Fell Double Pica SC', 'IM Fell English' => 'IM Fell English', 'IM Fell English SC' => 'IM Fell English SC', 'IM Fell French Canon' => 'IM Fell French Canon', 'IM Fell French Canon SC' => 'IM Fell French Canon SC', 'IM Fell Great Primer' => 'IM Fell Great Primer', 'IM Fell Great Primer SC' => 'IM Fell Great Primer SC', 'Iceberg' => 'Iceberg', 'Iceland' => 'Iceland', 'Imprima' => 'Imprima', 'Inconsolata' => 'Inconsolata', 'Inder' => 'Inder', 'Indie Flower' => 'Indie Flower', 'Inika' => 'Inika', 'Irish Grover' => 'Irish Grover', 'Istok Web' => 'Istok Web', 'Italiana' => 'Italiana', 'Italianno' => 'Italianno', 'Jacques Francois' => 'Jacques Francois', 'Jacques Francois Shadow' => 'Jacques Francois Shadow', 'Jim Nightshade' => 'Jim Nightshade', 'Jockey One' => 'Jockey One', 'Jolly Lodger' => 'Jolly Lodger', 'Josefin Sans' => 'Josefin Sans', 'Josefin Slab' => 'Josefin Slab', 'Joti One' => 'Joti One', 'Judson' => 'Judson', 'Julee' => 'Julee', 'Julius Sans One' => 'Julius Sans One', 'Junge' => 'Junge', 'Jura' => 'Jura', 'Just Another Hand' => 'Just Another Hand', 'Just Me Again Down Here' => 'Just Me Again Down Here', 'Kalam' => 'Kalam', 'Kameron' => 'Kameron', 'Kantumruy' => 'Kantumruy', 'Karla' => 'Karla', 'Karma' => 'Karma', 'Kaushan Script' => 'Kaushan Script', 'Kavoon' => 'Kavoon', 'Kdam Thmor' => 'Kdam Thmor', 'Keania One' => 'Keania One', 'Kelly Slab' => 'Kelly Slab', 'Kenia' => 'Kenia', 'Khand' => 'Khand', 'Khmer' => 'Khmer', 'Kite One' => 'Kite One', 'Knewave' => 'Knewave', 'Kotta One' => 'Kotta One', 'Koulen' => 'Koulen', 'Kranky' => 'Kranky', 'Kreon' => 'Kreon', 'Kristi' => 'Kristi', 'Krona One' => 'Krona One', 'La Belle Aurore' => 'La Belle Aurore', 'Laila' => 'Laila', 'Lancelot' => 'Lancelot', 'Lato' => 'Lato', 'League Script' => 'League Script', 'Leckerli One' => 'Leckerli One', 'Ledger' => 'Ledger', 'Lekton' => 'Lekton', 'Lemon' => 'Lemon', 'Libre Baskerville' => 'Libre Baskerville', 'Life Savers' => 'Life Savers', 'Lilita One' => 'Lilita One', 'Lily Script One' => 'Lily Script One', 'Limelight' => 'Limelight', 'Linden Hill' => 'Linden Hill', 'Lobster' => 'Lobster', 'Lobster Two' => 'Lobster Two', 'Londrina Outline' => 'Londrina Outline', 'Londrina Shadow' => 'Londrina Shadow', 'Londrina Sketch' => 'Londrina Sketch', 'Londrina Solid' => 'Londrina Solid', 'Lora' => 'Lora', 'Love Ya Like A Sister' => 'Love Ya Like A Sister', 'Loved by the King' => 'Loved by the King', 'Lovers Quarrel' => 'Lovers Quarrel', 'Luckiest Guy' => 'Luckiest Guy', 'Lusitana' => 'Lusitana', 'Lustria' => 'Lustria', 'Macondo' => 'Macondo', 'Macondo Swash Caps' => 'Macondo Swash Caps', 'Magra' => 'Magra', 'Maiden Orange' => 'Maiden Orange', 'Mako' => 'Mako', 'Marcellus' => 'Marcellus', 'Marcellus SC' => 'Marcellus SC', 'Marck Script' => 'Marck Script', 'Margarine' => 'Margarine', 'Marko One' => 'Marko One', 'Marmelad' => 'Marmelad', 'Marvel' => 'Marvel', 'Mate' => 'Mate', 'Mate SC' => 'Mate SC', 'Maven Pro' => 'Maven Pro', 'McLaren' => 'McLaren', 'Meddon' => 'Meddon', 'MedievalSharp' => 'MedievalSharp', 'Medula One' => 'Medula One', 'Megrim' => 'Megrim', 'Meie Script' => 'Meie Script', 'Merienda' => 'Merienda', 'Merienda One' => 'Merienda One', 'Merriweather' => 'Merriweather', 'Merriweather Sans' => 'Merriweather Sans', 'Metal' => 'Metal', 'Metal Mania' => 'Metal Mania', 'Metamorphous' => 'Metamorphous', 'Metrophobic' => 'Metrophobic', 'Michroma' => 'Michroma', 'Milonga' => 'Milonga', 'Miltonian' => 'Miltonian', 'Miltonian Tattoo' => 'Miltonian Tattoo', 'Miniver' => 'Miniver', 'Miss Fajardose' => 'Miss Fajardose', 'Modern Antiqua' => 'Modern Antiqua', 'Molengo' => 'Molengo', 'Molle' => 'Molle', 'Monda' => 'Monda', 'Monofett' => 'Monofett', 'Monoton' => 'Monoton', 'Monsieur La Doulaise' => 'Monsieur La Doulaise', 'Montaga' => 'Montaga', 'Montez' => 'Montez', 'Montserrat' => 'Montserrat', 'Montserrat Alternates' => 'Montserrat Alternates', 'Montserrat Subrayada' => 'Montserrat Subrayada', 'Moul' => 'Moul', 'Moulpali' => 'Moulpali', 'Mountains of Christmas' => 'Mountains of Christmas', 'Mouse Memoirs' => 'Mouse Memoirs', 'Mr Bedfort' => 'Mr Bedfort', 'Mr Dafoe' => 'Mr Dafoe', 'Mr De Haviland' => 'Mr De Haviland', 'Mrs Saint Delafield' => 'Mrs Saint Delafield', 'Mrs Sheppards' => 'Mrs Sheppards', 'Muli' => 'Muli', 'Mystery Quest' => 'Mystery Quest', 'Neucha' => 'Neucha', 'Neuton' => 'Neuton', 'New Rocker' => 'New Rocker', 'News Cycle' => 'News Cycle', 'Niconne' => 'Niconne', 'Nixie One' => 'Nixie One', 'Nobile' => 'Nobile', 'Nokora' => 'Nokora', 'Norican' => 'Norican', 'Nosifer' => 'Nosifer', 'Nothing You Could Do' => 'Nothing You Could Do', 'Noticia Text' => 'Noticia Text', 'Noto Sans' => 'Noto Sans', 'Noto Serif' => 'Noto Serif', 'Nova Cut' => 'Nova Cut', 'Nova Flat' => 'Nova Flat', 'Nova Mono' => 'Nova Mono', 'Nova Oval' => 'Nova Oval', 'Nova Round' => 'Nova Round', 'Nova Script' => 'Nova Script', 'Nova Slim' => 'Nova Slim', 'Nova Square' => 'Nova Square', 'Numans' => 'Numans', 'Nunito' => 'Nunito', 'Odor Mean Chey' => 'Odor Mean Chey', 'Offside' => 'Offside', 'Old Standard TT' => 'Old Standard TT', 'Oldenburg' => 'Oldenburg', 'Oleo Script' => 'Oleo Script', 'Oleo Script Swash Caps' => 'Oleo Script Swash Caps', 'Open Sans' => 'Open Sans', 'Open Sans Condensed' => 'Open Sans Condensed', 'Oranienbaum' => 'Oranienbaum', 'Orbitron' => 'Orbitron', 'Oregano' => 'Oregano', 'Orienta' => 'Orienta', 'Original Surfer' => 'Original Surfer', 'Oswald' => 'Oswald', 'Over the Rainbow' => 'Over the Rainbow', 'Overlock' => 'Overlock', 'Overlock SC' => 'Overlock SC', 'Ovo' => 'Ovo', 'Oxygen' => 'Oxygen', 'Oxygen Mono' => 'Oxygen Mono', 'PT Mono' => 'PT Mono', 'PT Sans' => 'PT Sans', 'PT Sans Caption' => 'PT Sans Caption', 'PT Sans Narrow' => 'PT Sans Narrow', 'PT Serif' => 'PT Serif', 'PT Serif Caption' => 'PT Serif Caption', 'Pacifico' => 'Pacifico', 'Paprika' => 'Paprika', 'Parisienne' => 'Parisienne', 'Passero One' => 'Passero One', 'Passion One' => 'Passion One', 'Pathway Gothic One' => 'Pathway Gothic One', 'Patrick Hand' => 'Patrick Hand', 'Patrick Hand SC' => 'Patrick Hand SC', 'Patua One' => 'Patua One', 'Paytone One' => 'Paytone One', 'Peralta' => 'Peralta', 'Permanent Marker' => 'Permanent Marker', 'Petit Formal Script' => 'Petit Formal Script', 'Petrona' => 'Petrona', 'Philosopher' => 'Philosopher', 'Piedra' => 'Piedra', 'Pinyon Script' => 'Pinyon Script', 'Pirata One' => 'Pirata One', 'Plaster' => 'Plaster', 'Play' => 'Play', 'Playball' => 'Playball', 'Playfair Display' => 'Playfair Display', 'Playfair Display SC' => 'Playfair Display SC', 'Podkova' => 'Podkova', 'Poiret One' => 'Poiret One', 'Poller One' => 'Poller One', 'Poly' => 'Poly', 'Pompiere' => 'Pompiere', 'Pontano Sans' => 'Pontano Sans', 'Port Lligat Sans' => 'Port Lligat Sans', 'Port Lligat Slab' => 'Port Lligat Slab', 'Prata' => 'Prata', 'Preahvihear' => 'Preahvihear', 'Press Start 2P' => 'Press Start 2P', 'Princess Sofia' => 'Princess Sofia', 'Prociono' => 'Prociono', 'Prosto One' => 'Prosto One', 'Puritan' => 'Puritan', 'Purple Purse' => 'Purple Purse', 'Quando' => 'Quando', 'Quantico' => 'Quantico', 'Quattrocento' => 'Quattrocento', 'Quattrocento Sans' => 'Quattrocento Sans', 'Questrial' => 'Questrial', 'Quicksand' => 'Quicksand', 'Quintessential' => 'Quintessential', 'Qwigley' => 'Qwigley', 'Racing Sans One' => 'Racing Sans One', 'Radley' => 'Radley', 'Rajdhani' => 'Rajdhani', 'Raleway' => 'Raleway', 'Raleway Dots' => 'Raleway Dots', 'Rambla' => 'Rambla', 'Rammetto One' => 'Rammetto One', 'Ranchers' => 'Ranchers', 'Rancho' => 'Rancho', 'Rationale' => 'Rationale', 'Redressed' => 'Redressed', 'Reenie Beanie' => 'Reenie Beanie', 'Revalia' => 'Revalia', 'Ribeye' => 'Ribeye', 'Ribeye Marrow' => 'Ribeye Marrow', 'Righteous' => 'Righteous', 'Risque' => 'Risque', 'Roboto' => 'Roboto', 'Roboto Condensed' => 'Roboto Condensed', 'Roboto Slab' => 'Roboto Slab', 'Rochester' => 'Rochester', 'Rock Salt' => 'Rock Salt', 'Rokkitt' => 'Rokkitt', 'Romanesco' => 'Romanesco', 'Ropa Sans' => 'Ropa Sans', 'Rosario' => 'Rosario', 'Rosarivo' => 'Rosarivo', 'Rouge Script' => 'Rouge Script', 'Rozha One' => 'Rozha One', 'Rubik Mono One' => 'Rubik Mono One', 'Rubik One' => 'Rubik One', 'Ruda' => 'Ruda', 'Rufina' => 'Rufina', 'Ruge Boogie' => 'Ruge Boogie', 'Ruluko' => 'Ruluko', 'Rum Raisin' => 'Rum Raisin', 'Ruslan Display' => 'Ruslan Display', 'Russo One' => 'Russo One', 'Ruthie' => 'Ruthie', 'Rye' => 'Rye', 'Sacramento' => 'Sacramento', 'Sail' => 'Sail', 'Salsa' => 'Salsa', 'Sanchez' => 'Sanchez', 'Sancreek' => 'Sancreek', 'Sansita One' => 'Sansita One', 'Sarina' => 'Sarina', 'Sarpanch' => 'Sarpanch', 'Satisfy' => 'Satisfy', 'Scada' => 'Scada', 'Schoolbell' => 'Schoolbell', 'Seaweed Script' => 'Seaweed Script', 'Sevillana' => 'Sevillana', 'Seymour One' => 'Seymour One', 'Shadows Into Light' => 'Shadows Into Light', 'Shadows Into Light Two' => 'Shadows Into Light Two', 'Shanti' => 'Shanti', 'Share' => 'Share', 'Share Tech' => 'Share Tech', 'Share Tech Mono' => 'Share Tech Mono', 'Shojumaru' => 'Shojumaru', 'Short Stack' => 'Short Stack', 'Siemreap' => 'Siemreap', 'Sigmar One' => 'Sigmar One', 'Signika' => 'Signika', 'Signika Negative' => 'Signika Negative', 'Simonetta' => 'Simonetta', 'Sintony' => 'Sintony', 'Sirin Stencil' => 'Sirin Stencil', 'Six Caps' => 'Six Caps', 'Skranji' => 'Skranji', 'Slabo 13px' => 'Slabo 13px', 'Slabo 27px' => 'Slabo 27px', 'Slackey' => 'Slackey', 'Smokum' => 'Smokum', 'Smythe' => 'Smythe', 'Sniglet' => 'Sniglet', 'Snippet' => 'Snippet', 'Snowburst One' => 'Snowburst One', 'Sofadi One' => 'Sofadi One', 'Sofia' => 'Sofia', 'Sonsie One' => 'Sonsie One', 'Sorts Mill Goudy' => 'Sorts Mill Goudy', 'Source Code Pro' => 'Source Code Pro', 'Source Sans Pro' => 'Source Sans Pro', 'Source Serif Pro' => 'Source Serif Pro', 'Special Elite' => 'Special Elite', 'Spicy Rice' => 'Spicy Rice', 'Spinnaker' => 'Spinnaker', 'Spirax' => 'Spirax', 'Squada One' => 'Squada One', 'Stalemate' => 'Stalemate', 'Stalinist One' => 'Stalinist One', 'Stardos Stencil' => 'Stardos Stencil', 'Stint Ultra Condensed' => 'Stint Ultra Condensed', 'Stint Ultra Expanded' => 'Stint Ultra Expanded', 'Stoke' => 'Stoke', 'Strait' => 'Strait', 'Sue Ellen Francisco' => 'Sue Ellen Francisco', 'Sunshiney' => 'Sunshiney', 'Supermercado One' => 'Supermercado One', 'Suwannaphum' => 'Suwannaphum', 'Swanky and Moo Moo' => 'Swanky and Moo Moo', 'Syncopate' => 'Syncopate', 'Tangerine' => 'Tangerine', 'Taprom' => 'Taprom', 'Tauri' => 'Tauri', 'Teko' => 'Teko', 'Telex' => 'Telex', 'Tenor Sans' => 'Tenor Sans', 'Text Me One' => 'Text Me One', 'The Girl Next Door' => 'The Girl Next Door', 'Tienne' => 'Tienne', 'Tinos' => 'Tinos', 'Titan One' => 'Titan One', 'Titillium Web' => 'Titillium Web', 'Trade Winds' => 'Trade Winds', 'Trocchi' => 'Trocchi', 'Trochut' => 'Trochut', 'Trykker' => 'Trykker', 'Tulpen One' => 'Tulpen One', 'Ubuntu' => 'Ubuntu', 'Ubuntu Condensed' => 'Ubuntu Condensed', 'Ubuntu Mono' => 'Ubuntu Mono', 'Ultra' => 'Ultra', 'Uncial Antiqua' => 'Uncial Antiqua', 'Underdog' => 'Underdog', 'Unica One' => 'Unica One', 'UnifrakturCook' => 'UnifrakturCook', 'UnifrakturMaguntia' => 'UnifrakturMaguntia', 'Unkempt' => 'Unkempt', 'Unlock' => 'Unlock', 'Unna' => 'Unna', 'VT323' => 'VT323', 'Vampiro One' => 'Vampiro One', 'Varela' => 'Varela', 'Varela Round' => 'Varela Round', 'Vast Shadow' => 'Vast Shadow', 'Vesper Libre' => 'Vesper Libre', 'Vibur' => 'Vibur', 'Vidaloka' => 'Vidaloka', 'Viga' => 'Viga', 'Voces' => 'Voces', 'Volkhov' => 'Volkhov', 'Vollkorn' => 'Vollkorn', 'Voltaire' => 'Voltaire', 'Waiting for the Sunrise' => 'Waiting for the Sunrise', 'Wallpoet' => 'Wallpoet', 'Walter Turncoat' => 'Walter Turncoat', 'Warnes' => 'Warnes', 'Wellfleet' => 'Wellfleet', 'Wendy One' => 'Wendy One', 'Wire One' => 'Wire One', 'Yanone Kaffeesatz' => 'Yanone Kaffeesatz', 'Yellowtail' => 'Yellowtail', 'Yeseva One' => 'Yeseva One', 'Yesteryear' => 'Yesteryear', 'Zeyada' => 'Zeyada');
                    break;
                default:
                    $entries = get_terms($typ, 'orderby=name&hide_empty=0&suppress_filters=0');
                    foreach ((array) $entries as $key => $entry) {
                        if (isset($entry->slug) && isset($entry->name)) {
                            $options[$entry->slug] = $entry->name;
                        }
                    }
                    break;
            }
            return $options;
        }

//todo
        function validate($input, $type, $field_id) {

            /* exit early if missing data */
            if (!$input || !$type || !$field_id)
                return $input;

            $input = apply_filters('validate', $input, $type, $field_id);

            if ('background' == $type) {

                $input['background-color'] = validate($input['background-color'], 'colorpicker', $field_id);

                $input['background-image'] = validate($input['background-image'], 'upload', $field_id);
            } else if ('colorpicker' == $type) {

                /* return empty & set error */
                if (0 === preg_match('/^#([a-f0-9]{6}|[a-f0-9]{3})$/i', $input)) {

                    $input = '';

                    add_settings_error('option-tree', 'invalid_hex', 'The Colorpicker only allows valid hexadecimal values.', 'error');
                }
            } else if (in_array($type, array('css', 'text', 'textarea', 'textarea-simple'))) {

                if (!current_user_can('unfiltered_html')) {

                    $input = wp_kses_post($input);
                }
            } else if ('measurement' == $type) {

                $input[0] = sanitize_text_field($input[0]);
            } else if ('typography' == $type) {

                $input['font-color'] = validate($input['font-color'], 'colorpicker', $field_id);
            } else if ('upload' == $type) {

                $input = sanitize_text_field($input);
            }

            $input = apply_filters('ot_after_validate_setting', $input, $type, $field_id);

            return $input;
        }
        
        private static function checkDefault($data, $value){
            $evalue = '';
            if (isset($data)){
                $evalue = $data;
            }else if (isset($value)){
                $evalue = $value;
            }else{
                $evalue = '';
            }
            return $evalue;
        }
        
        
        

    }

}
/**
 * Create HTML MultiSelect list of pages.
 *
 * @package WordPress
 * @since 2.1.0
 * @uses Walker
 */
if (!class_exists('Walker_PageMultiSelect')) {

    class Walker_PageMultiSelect extends Walker {

        /**
         * @see Walker::$tree_type
         * @since 2.1.0
         * @var string
         */
        var $tree_type = 'page';

        /**
         * @see Walker::$db_fields
         * @since 2.1.0
         * @todo Decouple this
         * @var array
         */
        var $db_fields = array('parent' => 'post_parent', 'id' => 'ID');

        /**
         * @see Walker::start_el()
         * @since 2.1.0
         *
         * @param string $output Passed by reference. Used to append additional content.
         * @param object $page Page data object.
         * @param int $depth Depth of page in reference to parent pages. Used for padding.
         * @param array $args Uses 'selected' argument for selected page to set selected HTML attribute for option element.
         */
        function start_el(&$output, $page, $depth = 0, $args = array(), $current_object_id = 0) {
            $pad = str_repeat('&nbsp;', $depth * 3);

            $output .= "\t<option class=\"level-$depth\" value=\"$page->ID\"";
            if (is_array($args['selected'])) {
                if (in_array($page->ID, $args['selected'])) {
                    $output .= ' selected="selected"';
                }
            } else {
                if ($page->ID == $args['selected']) {
                    $output .= ' selected="selected"';
                }
            }
            $output .= '>';
            $title = apply_filters('list_pages', $page->post_title);
            $output .= $pad . esc_html($title);
            $output .= "</option>\n";
        }

    }

}