<?php


if (!class_exists('jwDemoImport')) {
    
    class jwDemoImport {
        
        private $_debug = true;
        private $_errors = array();
        private $_info = array();
        private $_attachment_ids = array();
        private $_terms_ids = array();
        private $_posts_ids = array();
        private $_sidebars = array();
        
        

        public function install($demoname){

            if (!function_exists('jaw_encode') || !function_exists('jaw_decode')) {
                echo json_encode(array("errors" => array(esc_html__("For this functionality please activate JaW Shortcode Plugin", "gdn-theme"))));
                return;
            }
            
            //load file with base content
            $jawDemoContentBase = $this->loadFile('demo_base');

            //load file with content pro dany styl
            $jawDemoContentDemo = $this->loadFile($demoname);

            //merge
            $jawDemoContent = array_merge_recursive($jawDemoContentBase, $jawDemoContentDemo);

            //unset it - kvuli pameti
            unset($jawDemoContentBase);
            unset($jawDemoContentDemo);

            $log = $this->getLog($demoname);
            //import attachments
            if(isset($jawDemoContent['attachments'])){

                
                $importedAttachments = 0;
                if(isset($log['attachments'])){
                    $this->_attachment_ids = $log['attachments'];
                    $importedAttachments = sizeof($log['attachments']);
                }
                
                if(sizeof($jawDemoContent['attachments']) > $importedAttachments){
                    $this->importAttachment($jawDemoContent['attachments'][$importedAttachments]);
                    
                    echo json_encode(array("imported" => $importedAttachments , "numberOfAttachements" => sizeof($jawDemoContent['attachments'])+1, "done" => false, "errors" => $this->_errors, "info" => $this->_info)); //data to javascript
                    $this->saveLog($demoname);
                    return;
                } 
            }
            $this->importData($jawDemoContent);

            $this->saveLog($demoname);

            jwOpt::refresh_options();
            do_action('jaw_generate_styles', 'color');

            echo json_encode(array("done" => true, "errors" => $this->_errors)); //data to javascript
            delete_transient( JAW_THEMESLUG.'_g_fonts' );
            delete_option(JAW_THEMESLUG . '_last_update_check'); //opet se zeptam na novou verzi (odeslu data o pouzivani)
            return;
        }

        private function importData($jawDemoContent){
            //import terms
            if(isset($jawDemoContent['terms'])){
                $this->importTerms($jawDemoContent['terms']);
            }
            
            //import posts
            if(isset($jawDemoContent['posts']) && isset($jawDemoContent['posts_content'])){
                $this->importPosts($jawDemoContent['posts'], $jawDemoContent['posts_content']);
            }
            
            //import options, presets, widgets
            if(isset($jawDemoContent['options'])){
                $this->importOptions($jawDemoContent['options']);
            }
            
            //import sidebars
            if(isset($jawDemoContent['sidebars'])){
                $this->importSidebars($jawDemoContent['sidebars']);
            }
        }

        //kvuli testu
        public function fullInstallation($demoname){            
            //load file with base content
            $jawDemoContentBase = $this->loadFile('demo_base');

            //load file with content pro dany styl
            $jawDemoContentDemo = $this->loadFile($demoname);

            //merge
            $jawDemoContent = array_merge_recursive($jawDemoContentBase, $jawDemoContentDemo);

            //unset it - kvuli pameti
            unset($jawDemoContentBase);
            unset($jawDemoContentDemo);

            //import attachments
            if(isset($jawDemoContent['attachments'])){

                foreach($jawDemoContent['attachments'] as $attachment){
                    $this->importAttachment($attachment);
                }
            }

            $this->importData($jawDemoContent);

            $this->saveLog($demoname);

            echo json_encode(array("done" => true)); //data to javascript
            delete_transient( JAW_THEMESLUG.'_g_fonts' );
            return;
        }



        public function uninstall($demoname){
            
            $log = $this->getLog($demoname);

            // terms
            if(isset($log['terms'])){
                $this->uninstallTerms($log['terms']);
            }

            //posts
            if(isset($log['posts'])){
                $this->uninstallPosts($log['posts']);
            }

            //attachments
            if(isset($log['attachments'])){
                $this->uninstallAttachments($log['attachments']);
            }

            //options
            $this->uninstallOptions();
            
            //sidebars
            if(isset($log['sidebars'])){
                $this->uninstallSidebars($log['sidebars']);
            }
            //reset like after install
            jaw_after_install_theme();
            
            $this->deleteLog($demoname);

            //print logs
            if($this->_debug){
                print_r(implode('; ', $this->_errors));
            }
            
            echo 'done';
            delete_transient( JAW_THEMESLUG.'_g_fonts' );
            return 'done';
        }
        
        /**
        * @name				loadFile
        * @description		include file with demo data from /THEME/demo/ folder
        */
        private function loadFile($filename){
            $loadedFile = locate_template('demo/' . $filename . '.php', true, true);
            if($loadedFile == ''){
                throw new Exception('Cannot load file "' . 'demo/' . $filename . '.php"');
            }
            $func_name = 'jaw_demo_content_'.$filename;
            if(function_exists($func_name)){
                return $func_name();
            }
            return array();
        }
        
        
        /**
        * @name				importTerms
        * @description 		Import all terms and relationship
        * @link				https://codex.wordpress.org/Function_Reference/wp_insert_term
        */
        private function importTerms($allterms){
            foreach($allterms as $taxonomy => $terms){
                // pokud taxonomie existuje
                $this->_terms_ids[$taxonomy] = array();
                if(taxonomy_exists($taxonomy)){
                    foreach($terms as $id => $term){
                        $args = array();
                        if(isset($term['description'])){
                            $args['description'] = $term['description'];
                        }
                        if(isset($term['parent'])){
                            $args['parent'] = $term['parent'];
                        }
                        if(isset($term['slug'])){
                            $args['slug'] = $term['slug'];
                        }
                        
                        if(isset($term['name'])){
                            $termName = $term['name'];
                        }else{
                            $termName = '';
                            $this->_errors[] = 'Term doesn`t have set name. ('.$taxonomy.'->'.$id.')';
                            continue;
                        }
                        
                        $insertedTerm = wp_insert_term( $termName, $taxonomy, $args);
                        
                        if($insertedTerm instanceof WP_Error){
                            //A term already exists.'
                            $insertedTerm = get_term_by('slug', $args['slug'] , $taxonomy);
                            $insertedID = $insertedTerm->term_id;
                        }else{
                            $insertedID = $insertedTerm['term_id'];
                        }
                        
                        $this->_terms_ids[$taxonomy][$args['slug']] = $insertedID;
                    }
                }
            }
        }

        
        
        /**
        * @name				importAttachments
        * @description 		Import all atachments
        * @link				https://codex.wordpress.org/Function_Reference/wp_insert_attachment
        */
        private function importAttachment($attachment){
                
                // set fullpath
                if(isset($attachment['filename'])){
                    $fullfilename = JAW_THEME_DIR . '/demo/images/' . $attachment['filename'];
                    $fullurl = JAW_THEME_URI . '/demo/images/' . $attachment['filename'];
                }else{
                    $this->_errors[] = 'Attachment doesn`t have set url.';
                    $this->_attachment_ids[] = 0;
                    return;
                }
                //time of the upload
                if(isset($attachment['time'])){
                    $time = $attachment['time'];
                }else{
                    $time = null;
                }
                // Check the type of file. We'll use this as the 'post_mime_type'.
                $filetype = wp_check_filetype( basename( $fullfilename ), null );
                
                // Get the path to the upload directory.
                $wp_upload_dir = wp_upload_dir();

                //pokud soubor neexistuje (uploaduju po druhe)
                if(!file_exists($wp_upload_dir['basedir'] . '/' . $time .  '/' . $attachment['filename'])){
                    // Upload file
                    $upload = wp_upload_bits($attachment['filename'], 0, '', $time);
                    
                    $this->_info["File Name"] = $attachment['filename']; //added for debugging

                    //catch  upload errors
                    if($upload['error']){
                        $this->_errors[] = 'File '.$attachment['filename']. ' wasn`t uploaded. Info: ' . $upload['error'];
                        $this->_attachment_ids[] = 0;
                        return;
                    }
                    //upload
                    // fetch the remote url and write it to the placeholder file
                    $response = wp_remote_get( $fullurl, array(
                    'stream' => true,
                    'filename' => $upload['file']
                    ) );
                    
                    // request failed
                    if ( is_wp_error( $response ) ) {
                        @unlink( $upload['file'] );
                        $this->_attachment_ids[] = 0;
                        return $response;
                    }
                    
                    $code = (int) wp_remote_retrieve_response_code( $response );
                    
                    // make sure the fetch was successful
                    if ( $code !== 200 ) {
                        $this->_errors[] = 'Remote server returned '.$code.' '.get_status_header_desc( $code ).' for '.$fullurl;
                        $this->_attachment_ids[] = 0;
                        return;
                    }
                    
                    $filesize = filesize( $upload['file'] );
                    // $headers = wp_remote_retrieve_headers( $response );
                    $this->_info["File Size"] = $filesize; //added for debugging
                    // if ( isset( $headers['content-length'] ) && $filesize != $headers['content-length'] ) {
                    //     $this->_info["Header content length"] = $headers['content-length'];//added for debugging
                    //     $this->_errors[] = 'Remote file is incorrect size.';
                    //     $this->_attachment_ids[] = 0;
                    //     return;
                    // }
                    
                    if ( 0 == $filesize ) {
                        $this->_errors[] = 'Zero size file downloaded.';
                        $this->_attachment_ids[] = 0;
                        return;
                    }
                }else{
                    $upload = array();
                    $upload['file'] = $wp_upload_dir['basedir'] . '/' . $time .  '/' . $attachment['filename'];
                }

                // Prepare an array of post data for the attachment.
                $attrs = array(
                'guid'           => $wp_upload_dir['baseurl'] . '/' . $time .  '/' . $attachment['filename'],
                'post_mime_type' => $filetype['type'],
                'post_title'     => $attachment['title'],
                'post_content'   => '',
                'post_status'    => 'inherit'
                );
                
                // Insert the attachment.
                $attach_id = wp_insert_attachment( $attrs, $upload['file'] );
                if(!defined('JAW_SKIP_RESIZING_IMAGES') || JAW_SKIP_RESIZING_IMAGES == false){
                    $attach_data = wp_generate_attachment_metadata( $attach_id, $upload['file'] );
                    wp_update_attachment_metadata( $attach_id,  $attach_data );
                }
                $this->_attachment_ids[$attachment['filename']] = $attach_id;
        }
        
        
        
        /**
        * @name				importPosts
        * @description 		Import posts
        * @link				https://codex.wordpress.org/Function_Reference/wp_insert_post
        */
        private function importPosts($posts, $contents){

            foreach($posts as $id => $post){
                $post['post_status'] = 'publish';
                
                // Pokud neni u postu nastaven content, pouzije se defaultni z $contents
                if(!isset($post['post_content']) && isset($post['post_type']) && isset($contents[$post['post_type']])){
                    $post['post_content'] = $contents[$post['post_type']];
                }
                
                // Dekodovani  contentu
                if(isset($post['post_content'])){
                    $post['post_content'] = jwUtils::jaw_base64_dec($post['post_content']);
                    $post['post_content'] = $this->replaceContent($post['post_content']);
                }
                
                $taxToInput = array();
                if(isset($post['tax_input'])){
                    $taxToInput = $post['tax_input'];
                    unset($post['tax_input']);
                }
                
                // Vlozeni postu
                $insertedPost = wp_insert_post( $post, true );
                
                // Prirazeni taxonomies
                if(!empty($taxToInput)){
                    foreach($taxToInput as $taxonomy=>$terms){
                        if(taxonomy_exists($taxonomy)){
                            $taxInput = array(); 
                            foreach($terms as $key=>$term){
                                if(isset($this->_terms_ids[$taxonomy]) && isset($this->_terms_ids[$taxonomy][$term])){
                                    $taxInput[] = (int) $this->_terms_ids[$taxonomy][$term];
                                }else{
                                    $findTerm = get_term_by( 'name', $term, $taxonomy);
                                    if($findTerm){
                                        $taxInput[] = $findTerm->term_id;
                                    }
                                }
                            }
                            wp_set_post_terms( $insertedPost, $taxInput, $taxonomy, false );
                        }
                    }
                }
                
                
                if(isset($post['thumbnail'])){
                    // add featured image to post
                    if(isset($this->_attachment_ids[$post['thumbnail']])){
                        add_post_meta($insertedPost, '_thumbnail_id', $this->_attachment_ids[$post['thumbnail']]);
                    }
                }
                
                // Import metadat
                if(isset($post['metadata'])){
                    $this->importPostMeta($insertedPost, $post['metadata']);
                }
                
                if(isset($post['post_title'])){
                    //zapisu post do seznamu post; - pro pripadne pozdejsi dohledani (napr pri pridavani do menu)
                    $sanitizeName = $this->sanitizeString($post['post_title']);
                    if(isset($this->_posts_ids[$sanitizeName])){
                        $this->_posts_ids[] = $insertedPost;
                    }else{
                        $this->_posts_ids[$sanitizeName] = $insertedPost;
                    }
                }
            }
        }
        
        
        /**
        * @name				importPostMeta
        * @description 		Import meta for posts
        */
        private function importPostMeta($postid, $meta){
            foreach($meta as $metakey => $metavalue){
                $metavalue = jwUtils::jaw_base64_dec($metavalue);
                $metavalue = $this->replaceContent($metavalue);
                $metavalue = maybe_unserialize($metavalue);
                add_post_meta($postid, $metakey, $metavalue, false);
            }
        }
        
        
        /**
        * @name				importOptions
        * @description 		Import wp_options
        * @link				https://codex.wordpress.org/Function_Reference/update_option
        */
        private function importOptions($options){
            jwOpt::refresh_options();
            //sidebary musime zachovat, kdyz instalujeme dalsi demo, tak aby ty stary byly zachovany
            $sidebars = (array) json_decode(jwOpt::get_option('sidebars', '{}'));
            foreach($options as $id => $option){
                if(isset($option['name']) && isset($option['value'])){
                    if(is_string($option['value'])){
                        $option['value'] = jwUtils::jaw_base64_dec($option['value']);
                    }
                    $option['value'] = $this->replaceContent($option['value']);
                    $value = maybe_unserialize($option['value']);
                    $updated = update_option($option['name'], $value); 
                }
            }
            //sidebary musime zachovat, kdyz instalujeme dalsi demo, tak aby ty stary byly zachovany
            jwOpt::update_one_option('sidebars', json_encode($sidebars), 'opt');
        }

        /**
        * @name				importSidebars
        * @description 		Import sidebars
        */
        private function importSidebars($sidebars){
            foreach ($sidebars as $id => $value) {
                $default_sidebars = array( 'footer1', 'footer2', 'footer3', 'footer4', 'footer1', 'headerwidgetarea1', 'headerwidgetarea2', 'widget-menu-area-1', 'widget-menu-area-2', 'widget-menu-area-3', 'widget-menu-area-4');
                //pokud jde o defaultni sidebar (neni pridavan v sidebar manageru), tak ho  do Sidebarmanageru nebudu pridavat.
                if(!in_array($id, $default_sidebars)){
                    jwOpt::refresh_options();
                    $sidebars = (array) json_decode(jwOpt::get_option('sidebars', '{}'));
                    $sidebars[$id] = $value['name'];
                    jwOpt::update_one_option('sidebars', json_encode($sidebars), 'opt');
                    //save to database - for uninstalling
                    $this->_sidebars[] = $id;
                }

                $sidebars_widgets = get_option( 'sidebars_widgets', array() );
                //vymazu puvodni obsah sidebaru - aby se v tom sidebaru nekupil
                $inserted_widgets = $this->importWidgets($value['widgets']);
                $sidebars_widgets[$id] = $inserted_widgets;
                update_option( 'sidebars_widgets', $sidebars_widgets );
            }
        }


        /**
        * @name				importSidebars
        * @description 		Import sidebars
        */
        private function importWidgets($widgets){
            $inserted_widgets = array();
            foreach ($widgets as $widget) {
                if(!isset($widget['name'])){
                    continue;
                }
                $widget_name = $widget['name'];
                $saved_widgets = get_option('widget_'.$widget_name, array());
                if(empty($saved_widgets)){
                    $saved_widgets = array();
                }
                unset($widget['name']);
                foreach($widget as $key => $value){
                    $widget[$key] = $this->replaceContent($value);
                }
                $saved_widgets[] = $widget;
                update_option( 'widget_'.$widget_name, $saved_widgets );

                end($saved_widgets);
                $key = key($saved_widgets);
                $inserted_widgets[] = $widget_name . '-' . $key;
            }
            return $inserted_widgets;
        }
        
        
        
        /**
        * @name				importThemeOptions
        * @description 		Prepare ThemeOptions 
        */
        private function importThemeOptions($options){
            $outOptions = array();
            foreach ($options as $key => $value) {
                $key = $this->replaceContent($key);
                $outOptions[$key] = $this->replaceContent($value);
            }
            return $outOptions;
        }



        /**
        * @name				uninstallTerms
        * @description 		Uninstall all terms and relationship
        */
        private function uninstallTerms($allterms){
            foreach($allterms as $taxonomy => $terms){
                if(taxonomy_exists($taxonomy)){
                    foreach($terms as $termId){
                        wp_delete_term( $termId, $taxonomy );                
                    }
                }
            }
        }

        /**
        * @name				uninstallPosts
        * @description 		Uninstall all posts
        */
        private function uninstallPosts($allposts){
            foreach($allposts as $postId){
                wp_delete_post( $postId, true );
            }
        }


        /**
        * @name				uninstallAttachments
        * @description 		Uninstall all Attachments
        */
        private function uninstallAttachments($allattachments){
            foreach($allattachments as $attachementId){
                wp_delete_attachment( $attachementId, true );
            }
        }
        
        /**
        * @name				uninstallOptions
        * @description 		Uninstall all Options
        */
        private function uninstallOptions(){
            delete_option( 'theme_mods_gdaynews' );
            //delete_option( 'g-day news-log' );
        }

        /**
        * @name				uninstallSidebars
        * @description 		Uninstall all Options
        */
        private function uninstallSidebars($sidebars){
            $savedSidebars = (array) json_decode(jwOpt::get_option('sidebars',array()));
            foreach ($sidebars as $sidebar) {
                if(isset($savedSidebars[$sidebar])){
                    unset($savedSidebars[$sidebar]);
                }
            }
            jwOpt::update_one_option('sidebars', json_encode($savedSidebars), 'opt');
        }


        private function getLog($demoId){
            $log = get_option( 'jaw_demo_log', array());
            if(isset($log[$demoId])){
                return $log[$demoId];
            } else {
                return array();
            }
        }

        public static function getWholeLog(){
            $log = get_option( 'jaw_demo_log', array());
            return $log;
        }

        private function saveLog($demoId){
            $log = get_option( 'jaw_demo_log', array());
            unset($this->_terms_ids['post_format']);
            $log[$demoId] = array(
                'terms' => $this->_terms_ids,
                'attachments' => $this->_attachment_ids, 
                'posts' => $this->_posts_ids, 
                'sidebars' => $this->_sidebars
            );
            update_option( 'jaw_demo_log', $log );
        }

        private function deleteLog($demoId){
            $log = get_option( 'jaw_demo_log', array());
            if(isset($log[$demoId])){
                unset($log[$demoId]);
            }
            update_option( 'jaw_demo_log', $log );
        }
        

        private function replaceContent($content){
            //if array - call recursive
            if(is_array($content)){
                $outOptions = array();
                foreach ($content as $key => $value) {
                    $key = $this->replaceContent($key);
                    $outOptions[$key] = $this->replaceContent($value);
                }   
                return $outOptions;
            }
            //only strings
            if(!is_string($content)){
                return $content;
            }
            // Get the path to the upload directory.
            $wp_upload_dir = wp_upload_dir();
            // replace sign by upload foler URI
            $content = preg_replace('/{{WP_UPLOAD_FOLDER}}/', $wp_upload_dir['baseurl'], $content);
            // replace slug by term  ID
            $content = preg_replace_callback('/{{WP_TAXONOMY_(.*?)_TERM_(.*?)}}/', 'jwDemoImport::preqReplaceTerms', $content);
            // replace post title by post ID
            $content = preg_replace_callback('/{{WP_POST_(.*?)}}/', 'jwDemoImport::preqReplacePosts', $content);
            
            $content = preg_replace_callback('/{{WP_ATTACHMENT_(.*?)}}/','jwDemoImport::preqReplaceAttachments', $content);
            
            return $content;
        }

        private function preqReplaceTerms($m){
            if(isset($this->_terms_ids[$m[1]][$m[2]])){
                return $this->_terms_ids[$m[1]][$m[2]];
            }
        }
        private function preqReplacePosts($m){
            if(isset($this->_posts_ids[$this->sanitizeString($m[1])])){
                return $this->_posts_ids[$this->sanitizeString($m[1])];
            }
        }
        private function preqReplaceAttachments($m){
            if(isset($this->_attachment_ids[$this->sanitizeString($m[1])])){
                return $this->_attachment_ids[$this->sanitizeString($m[1])];
            }
        }

        
        private function sanitizeString($string = ''){
            if(function_exists('mb_strtolower')){
                $string = mb_strtolower($string);
            } else {
                $string = strtolower($string);
            }
            $string = str_replace(' ', '', $string);
            return $string;
        }
    }
}