<?php
if(!class_exists('jwCustomizer')){
    
    class jwCustomizer{
        
        
        private $items_in_scheme = array(
        'title' => array(
        'name' => 'Name of preset',
        'type' => 'text'
        ),
        'background' => array(
        'name' => 'Background',
        'type' => 'rgba_color'
        ),
        'alternative_background' => array(
        'name' => 'Alternative Background',
        'type' => 'rgba_color'
        ),
        'theme1' => array(
        'name' => 'Theme Color 1',
        'type' => 'rgba_color'
        ),
        'theme2' => array(
        'name' => 'Theme Color 2',
        'type' => 'rgba_color'
        ),
        'theme3' => array(
        'name' => 'Theme Color 3',
        'type' => 'rgba_color'
        ),
        'border' => array(
        'name' => 'Border Color',
        'type' => 'rgba_color'
        ),
        'text' => array(
        'name' => 'Text Color',
        'type' => 'rgba_color'
        ),
        'meta' => array(
        'name' => 'Meta Color',
        'type' => 'rgba_color'
        ),
        'link' => array(
        'name' => 'Link Color',
        'type' => 'rgba_color'
        ),
        'hover' => array(
        'name' => 'Link Hover Color',
        'type' => 'rgba_color'
        ),
        'text_link' => array(
        'name' => 'Link in Content Color',
        'type' => 'rgba_color'
        ),
        'text_hover' => array(
        'name' => 'Link in Content Hover Color',
        'type' => 'rgba_color'
        ),
        'input' => array(
        'name' => 'Input Text Color',
        'type' => 'rgba_color'
        ),
        'input_bg' => array(
        'name' => 'Input Background Color',
        'type' => 'rgba_color'
        ),
        );
        
        public function __construct(){
            add_action( 'customize_register', array( &$this, 'color_schemes' ));
            add_action( 'customize_register', array( &$this, 'theme_options' ));
            add_action( 'customize_controls_init', array( &$this, 'customize_init' ));
            add_action( 'customize_controls_enqueue_scripts', array( &$this, 'customize_controls_enqueue_scripts' ));
            add_action( 'customize_save_after', array(&$this, 'customize_save'));
            add_action( 'admin_init', array(&$this, 'customize_preview_init'));
        }
        
        
        /**
        * Aktualni barevne presety se zkopiruji do "preview" presetu
        */
        public function customize_init(){
            jwOpt::savePreset(json_encode(jwOpt::loadAllPresets('color')), 'color_preview');
            do_action('jaw_generate_styles', 'color_preview');
            
            echo '<input type="hidden" id="jaw_security" class="jaw_nonce" name="jaw_security" value="'. wp_create_nonce('of_ajax_nonce'). '" />';
        }
        
        // neni to moc uciny, ale musi to tu byt
        public function jaw_sanitize_color_preset($value){
            if ( '' === $value ) {
                return '';
            }
            
            // HEX 3 or 6 hex digits, or the empty string.
            if ( preg_match('|^#([A-Fa-f0-9]{3}){1,2}$|', $value ) ) {
                return $value;
            }
            
            // RGBA
            if ( preg_match('|^rgba\(([0-9]){1,3},([0-9]){1,3},([0-9]){1,3},([0-9][\.])?[0-9]+\)$|', $value ) ) {
                return $value;
            }
            
            // name
            if ( preg_match('|^([\s\S]*?)$|', $value ) ) {
                return $value;
            }
            
            return $value;
        }
        
        public function theme_options ( $wp_customize ) {
            
            $wp_customize->add_panel(
            "jaw_theme_options", # Section ID to use in Option Table
            array( # Arguments array
            'title' => "Theme Options", # Translatable text, change the text domain to your own
            'description' => '',
            'priority'    => 150
            )
            );
            
            $actualSubmenu = "";
            foreach(jwOpt::getRawOptions() as $option){
                
                $defaultOpt = array(
                'id' => 'id',
                'name' => 'option',
                'hide_in_customise' => false
                );
                
                $option = array_merge($defaultOpt, $option);
                
                if($option['hide_in_customise']){
                    continue;
                }
                
                if($option['type'] == 'headingstart'){
                    $actualSubmenu = 'jaw_'.str_replace(' ','_', strtolower($option['name']));
                    
                    $wp_customize->add_section(
                    $actualSubmenu, # Section ID to use in Option Table
                    array( # Arguments array
                    'title' => $option['name'], # Translatable text, change the text domain to your own
                    'capability' => 'edit_theme_options', # Permission to change option date
                    'panel' => 'jaw_theme_options'
                    )
                    );
                    continue;
                }
                
                
                $oneOption = array(
                'label' => preg_replace('/<.*/', '', $option['name']), # Label of text form
                'section' => "jaw_theme_options", # Layout Section
                'palette' => true,
                'type'     => 'text',
                );
                
                if(!empty($option['desc'])){
                    $oneOption['description'] = $option['desc'];
                }
                
                $wp_customize->add_setting(
                JAW_OPTIONS.'['.$option['id'].']',
                array(
                'capability' => 'edit_theme_options',
                'type'       => 'option',
                'default'    => "",
                'transport'  => 'postMessage', //postMessage
                'sanitize_callback' => 'esc_textarea',
                )
                );
                
                switch($option['type']){
                    case 'text':
                        $oneOption['type'] = 'text';
                        $oneOption['section'] = $actualSubmenu;
                        $wp_customize->add_control(
                        JAW_OPTIONS.'['.$option['id'].']',
                        $oneOption
                        );
                        break;
                    case 'textarea':
                        case 'ace_editor':
                            $oneOption['type'] = 'textarea';
                            $oneOption['section'] = $actualSubmenu;
                            $wp_customize->add_control(
                            JAW_OPTIONS.'['.$option['id'].']',
                            $oneOption
                            );
                            break;
                        case 'toggle':
                            case 'select':
                                if(empty($option['options'])){
                                    $option['options'] = array("0" => "Off", "1" => "On");
                            }
                            $oneOption['choices'] = $option['options'];
                            $oneOption['section'] = $actualSubmenu;
                            $wp_customize->add_control(
                            new Jaw_Toggle(
                            $wp_customize,
                            JAW_OPTIONS.'['.$option['id'].']',
                            $oneOption
                            )
                            );
                            break;
                        case 'layout':
                            $oneOption['choices'] = $option['options'];
                            $oneOption['section'] = $actualSubmenu;
                            $wp_customize->add_control(
                            new Jaw_Layout_Choose(
                            $wp_customize,
                            JAW_OPTIONS.'['.$option['id'].']',
                            $oneOption
                            )
                            );
                            break;
                        case 'upload':
                            $wp_customize->add_control(
                            new WP_Customize_Upload_Control(
                            $wp_customize,
                            JAW_OPTIONS.'['.$option['id'].']',
                            array(
                            'label'      => preg_replace('/<.*/', '', $option['name']),
                            'section'    => $actualSubmenu,
                            ) )
                            
                            );
                            break;
                        case 'lite_info':
                            $wp_customize->add_control(
                            new WP_Customize_Lite_Info(
                            $wp_customize,
                            JAW_OPTIONS.'['.$option['id'].']',
                            array(
                            'label'      => $option['name'],
                            'description'    =>  $option['text'],
                            'section'    => $actualSubmenu,
                            ) )
                            
                            );
                            break;
                        default:
                            continue 2;
                    }
                    
                }
            }
            public function color_schemes ( $wp_customize ) {
                
                
                $wp_customize->add_panel(
                'jaw_color_schemes',
                array(
                'title'       => esc_html__( 'Color Schemes' ,'gdn-theme'),
                'description' => esc_html__( 'Here you can define all colors of your site. Each scheme can be related to each part of the theme (Header, menu, category, sidebar, ...)' ,'gdn-theme'),
                'priority'    => 140,
                )
                );
                
                
                $color_schemes = jwOpt::loadAllPresets('color');
                
                
                foreach($color_schemes as $id => $scheme){
                    $wp_customize->add_section(
                    $id, # Section ID to use in Option Table
                    array( # Arguments array
                    'title' => $scheme['title'], # Translatable text, change the text domain to your own
                    'capability' => 'edit_theme_options', # Permission to change option date
                    'panel' => 'jaw_color_schemes'
                    )
                    );
                    
                    
                    foreach($this->items_in_scheme as $key => $opt){
                        $wp_customize->add_setting('jaw_color_preset['.$id.']['.$key.']', array(
                        'capability' => 'edit_theme_options',
                        'type'       => 'option',
                        'default'       => sanitize_text_field($scheme[$key]),
                        'transport'=>'postMessage', //postMessage
                        'sanitize_callback' => array(&$this, 'jaw_sanitize_color_preset'),
                        ));
                        
                        if($opt['type'] == 'rgba_color'){
                            $wp_customize->add_control(
                            new Pluto_Customize_Alpha_Color_Control(
                            $wp_customize,
                            'jaw_color_preset['.$id.']['.$key.']',
                            array(
                            'label' => $opt['name'], # Label of text form
                            'section' => $id, # Layout Section
                            'palette' => true,
                            'type' => $opt['type'], # Type of control: text input
                            )
                            )
                            );
                        }else{
                            $wp_customize->add_control(
                            'jaw_color_preset['.$id.']['.$key.']',
                            array(
                            'label' => $opt['name'], # Label of text form
                            'section' => $id, # Layout Section
                            'palette' => true,
                            'type' => $opt['type'], # Type of control: text input
                            )
                            );
                        }
                    }
                }
            }
            
            
            
            public function customize_controls_enqueue_scripts(){
                wp_enqueue_script(
                'jaw-themecustomizer',			//Give the script an ID
                get_template_directory_uri().'/framework/admin/assets/js/theme-customizer.js',//Point to file
                array( 'customize-controls', 'iris', 'underscore', 'wp-util' ),	//Define dependencies
                '0.2',						//Define a version (optional)
                true						//Put script in footer?
                );
            }
            
            
            
            public function customize_save($data){
                jwOpt::loadAllPresetsFromDatabase('color');
                do_action('jaw_generate_styles', 'color');
            }
            
            public function customize_preview_init(){
                if(function_exists('is_customize_preview') && is_customize_preview()){
                    jwOpt::refresh_options(false);
                    $options = jwOpt::get_options('opt', false);
                    jwOpt::update_option($options, 'opt', true);
                    jwOpt::refresh_options(true);
                    jwOpt::loadAllPresetsFromDatabase('color');
                    do_action('jaw_generate_styles', 'color');
                }
            }
            
            
        }
        
    }
    
    class Pluto_Customize_Alpha_Color_Control extends WP_Customize_Control {
        
        public $type = 'alphacolor';
        //public $palette = '#3FADD7,#555555,#666666, #F5f5f5,#333333,#404040,#2B4267';
        public $palette = true;
        public $default = '#3FADD7';
        
        protected function render() {
            $id = 'customize-control-' . str_replace( '[', '-', str_replace( ']', '', $this->id ) );
            $class = 'customize-control customize-control-' . $this->type; ?>
  <li id="<?php echo esc_attr( $id ); ?>" class="<?php echo esc_attr( $class ); ?>">
    <?php $this->render_content(); ?>
  </li>
  <?php }
        
        public function render_content() { ?>
    <label>
      <span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
      <input type="text" data-palette="<?php echo esc_attr($this->palette); ?>" data-default-color="<?php echo esc_attr($this->default); ?>" value="<?php echo intval( $this->value() ); ?>" class="pluto-color-control" <?php $this->link(); ?> />
    </label>
    <?php }
    }
    
    
    class Jaw_Toggle extends WP_Customize_Control {
        
        
        public function render_content() {
            if ( empty( $this->choices ) )
                return;
            
            $name = '_customize-radio-' . $this->id;
            
            if ( ! empty( $this->label ) ) : ?>
      <span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
      <?php endif;
            if ( ! empty( $this->description ) ) : ?>
        <span class="description customize-control-description"><?php echo $this->description ; ?></span>
        <?php endif;
            
            foreach ( $this->choices as $value => $label ) :
            ?>
          <label>
            <input type="radio" value="<?php echo esc_attr( $value ); ?>" name="<?php echo esc_attr( $name ); ?>" <?php $this->link(); checked( $this->value(), $value ); ?> />
            <?php echo  $label ; ?>
              <br/>
          </label>
          <?php
            endforeach;
        }
    }
    
    class Jaw_Layout_Choose extends WP_Customize_Control {
        
        public $default = '';
        
        public function render_content() {
            if ( empty( $this->choices ) )
                return;
            $name = '_customize-radio-' . $this->id;
            
            if ( ! empty( $this->label ) ) : ?>
            <span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
            <?php endif;
            if ( ! empty( $this->description ) ) : ?>
              <span class="description customize-control-description"><?php echo $this->description ; ?></span>
              <?php endif;
            
            foreach ( $this->choices as $value => $label ) :
            ?>
                <label>
                  <input type="radio" value="<?php echo esc_attr( $value ); ?>" name="<?php echo esc_attr( $name ); ?>" <?php $this->link(); checked( $this->value(), $value ); ?> />
                  <?php echo '<img src="' . $label . '" />' ; ?>
                    <br/>
                </label>
                <?php
            endforeach;
        }
    }
    class WP_Customize_Lite_Info extends WP_Customize_Control {
        
        public function render_content() {
            if ( ! empty( $this->label ) ) : ?>
                  <span class="customize-control-title customize-lite-info-title"><?php echo esc_html( $this->label ); ?></span>
                  <?php endif;
            
            if ( ! empty( $this->description ) )  :
                echo '<ul class="customize-lite-info-content">';
            echo $this->description;
            echo '</ul>';
            endif;
        }
    }