<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

if (!class_exists('jwBuilderHelper')) {

    /**
    * class jwBuilderHelper
    * Trida starajici se o vedlejsi veci builder AJAX ...
    */
    class jwBuilderHelper {

        /**
        * Registrace AJAXu
        *
        */
        public function __construct() {

            //LOAD editors
            $this->load_editors();

            add_action('wp_ajax_jaw_builder_editor', array(&$this, 'jaw_builder_editor'));

            add_action('wp_ajax_pb_add_preset', array(&$this, 'jaw_ajax_pb_add_preset'));
            add_action('wp_ajax_pb_delete_preset', array(&$this, 'jaw_ajax_pb_delete_preset'));

            add_action('wp_ajax_pb_load_preset', array(&$this, 'jaw_ajax_pb_load_preset'));
        }

        private function load_editors() {
            global $metapagebuild, $jaw_builder_options;
            if (class_exists('JawShortcodes')) {
                locate_template('framework/lib/builder/metabox-builder.php', true);
                locate_template('framework/lib/builder/metabox-builder.php', true);
                $jwMetabox = new jwMetabox($metapagebuild);
                $others_editors = array('page_sidebar', 'add_preset', 'sidebar');
                $this->problem_load = array();
                foreach ($others_editors as $editor) {
                    $loaded = locate_template('framework/lib/builder/editor-dialogs/' . $editor . '.php', true, true);
                    if (!$loaded ) {
                        $this->problem_load[] = $editor;
                    }
                }


                if (isset($metapagebuild['fields'])) {
                    $submetabuild = $metapagebuild['fields'][0];
                    if(isset($submetabuild['content'])){
                        foreach ($submetabuild['content'] as $submeta) {
                            if (isset($submeta['content']) && $submeta['id'] == 'build_all') {
                                foreach ($submeta['content'] as $key => $meta) {
                                    if (isset($meta['id']) && isset($meta['type']) && $meta['type'] == 'builder') {
                                        $name = str_replace('build_', "", $meta['id']);
                                        $loaded = locate_template('framework/lib/builder/editor-dialogs/' . $name . '.php', true, true);
                                        //pokud dialog neni nacten - zobraz hlasku (dialog muze jit i z filtru, proto tato podminka)
                                        if (empty($jaw_builder_options[$name])) {
                                            $this->problem_load[] = $name;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (!empty($this->problem_load)) {
                add_action('admin_notices', array(&$this, 'jaw_builder_admin_nodice'));
            }
        }

        /**
        * jaw_builder_admin_nodice
        * nacte iframe do ktereho se dale nacita obsah daneho elementu
        */
        function jaw_builder_admin_nodice() {
            ?>
  <div class="error">
    <p>
      <strong>RevoComposer</strong>
      <br> Dialog for <code><?php echo esc_attr(implode(', ', $this->problem_load)); ?></code> couldn't be loaded. Please contact JaW Templates team at <a href="mailto:jaw@jawtemplates.com">jaw@jawtemplates.com</a>
    </p>
  </div>
  <?php
        }





        /**
        * jaw_builder_editor
        * editor builderu
        */
        public function jaw_builder_editor() {
            global $jaw_builder_options;
            ?>

    <div id="jaw-builder-popup">
      <?php
            if(isset($_GET['layout'])){
                $layout = $_GET['layout'];
            }else{
                $layout = 'default';
            }
            if (isset($jaw_builder_options[$_GET['jaw_code']])) {
                $index = jaw_template_inc_counter('wp_editor') .'_'. rand(99,9999);
                ?>

        <div id="header_editor" ng-init="init_editor('<?php echo esc_attr($index); ?>');">
          <span><?php echo esc_attr( ucfirst(str_replace('_', ' ', $_GET['jaw_code']))); ?></span>
          <button ng-click="cancel_editor()" class="button-primary builder red jaw" type="button"><i class="icon-white jaw-icon-close  "></i></button>  
          <button ng-click="save_editor()" class="button-primary builder blue jaw" type="button"><i class="icon-white jaw-icon-save"></i> Done</button> 
        </div>
        <div class="editor_bookmarks">
          <ul>
            <li ng-class="{active: active_bookmark == i}" ng-repeat="(i, marks) in bookmarks track by i" ng-click="switch_mark(i)">{{marks}}</li>
          </ul>
        </div>
        <div id="editor_container_<?php echo esc_attr($index); ?>" class="editor_container" ng-class="{initialized: initialized}">
          <div class="content" ng-controller="jwEditorController">
            <?php
                echo jwElements::elements_render($jaw_builder_options[$_GET['jaw_code']], null, $layout);
                ?>
          </div>
        </div>
        <div ng-class="{initialized: initialized}" class="jaw-editor-loading">
          Loading...
        </div>

        <?php } else { ?>
          <div id="header_editor">
            <span><?php echo esc_attr( ucfirst(str_replace('_', ' ', $_GET['jaw_code']))); ?></span>
            <button ng-click="cancel_editor()" class="button-primary builder red jaw" type="button"><i class="icon-white icon-close  "></i></button>
          </div>
          Something wrong happened. Dialog (
          <?php echo esc_attr($_GET['jaw_code']); ?>) couldn't be loaded.

            <?php } ?>
        <div class="jw-builder-save-popup" ng-class="{initialized: initialized}" >
            <button ng-click="save_editor()" class="button-primary builder blue jaw" type="button"><i class="icon-white jaw-icon-save"></i> Done</button>
        </div>
    </div>
    <?php
            die();
        }




        /**
        * @name            jaw_ajax_pb_add_preset
        * @description     pridani presetu
        */
        public function jaw_ajax_pb_add_preset() {
            $jaw_pb_preset = '';
            $title = '';
            $typ = 'revo';
            if (isset($_POST['jaw_pb_typ'])) {
                $typ = $_POST['jaw_pb_typ'];
            }
            if (isset($_POST['jaw_pb_preset'])) {
                $preset = $_POST['jaw_pb_preset'];
                $jaw_pb_preset = json_decode(stripslashes($preset));
                if(isset($jaw_pb_preset->id)){
                    $title = $jaw_pb_preset->id;
                    unset($jaw_pb_preset->id);
                }
            }
            if ($jaw_pb_preset != '') {
                jwOpt::addPreset($typ,$title,$jaw_pb_preset);
            }
            die();
        }



        /**
        * @name            jaw_ajax_pb_load_preset
        * @description     nacteni presetu
        */
        public function jaw_ajax_pb_load_preset() {
            $jaw_pb_preset = '';
            $typ = 'revo';
            if (isset($_POST['jaw_pb_typ'])) {
                $typ = $_POST['jaw_pb_typ'];
            }
            if (isset($_POST['jaw_pb_preset_name'])) {
                echo json_encode(jwOpt::loadPreset($typ,$_POST['jaw_pb_preset_name']));
            }
            die();
        }

        /**
        * jaw_ajax_pb_delete_preset
        * smazani presetu
        */
        public function jaw_ajax_pb_delete_preset() {
            $jaw_pb_preset = '';
            $typ = 'revo';
            if (isset($_POST['jaw_pb_typ'])) {
                $typ = $_POST['jaw_pb_typ'];
            }
            if (isset($_POST['jaw_pb_preset_name'])) {
                jwOpt::deletePreset($typ,$_POST['jaw_pb_preset_name']);
            }
            die();
        }

    }

}
