<?php

/**
* Library of HTML elements. Use only in admin area
*
* @author JaW Templates <http://www.jawtemplates.com>
* @copyright (c) 2013, CCB, spol. s r.o.
* @version 1.0
*/
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

if (!class_exists('jwBuilder')) {
    
    class jwBuilder {
        
        public function __construct() {
            
            add_action('wp_ajax_generate_shortcode', array(&$this, 'generateShortcodeAjax'));
            
            if (filter_input(INPUT_POST, 'jaw_pb_startup') === 'true' && filter_input(INPUT_POST, 'wpb_vc_js_status') === null) {
                add_filter('content_save_pre', array('jwBuilder', 'jwPbGenerateContent'), 10, 1);
            }
            add_filter('jaw_shortcode_attribute', array(&$this, 'shortcodeAttributes'));
            
            if (is_admin()) {
                new jwBuilderHelper();
            }
        }
        
        
        /**
        * Printing page
        *
        * In dependence of "jaw_pb_startup" value in metabox call function with
        * printing PB elements or print classical content.
        *
        * @since GS
        * @global type $post
        * @global type $wp_query
        */
        public static function jwPbPrint($content, $type = 'content') {            
            //  wp_reset_postdata();
            
            if (get_post_meta(get_the_ID(), 'jaw_pb_startup', true) == 'true' && !(class_exists('WPBakeryVisualComposer') && get_post_meta(get_the_ID(), '_wpb_vc_js_status', true) == 'true')) {
                $content = get_post_meta(get_the_ID(), 'jaw_pb_shortcode_' . $type, true);
                $out = '';
                if (isset($content)) {
                    $out .= '<div class="row">';
                    $out .= do_shortcode($content);
                    $out .= '</div>';
                }
            } else if (is_page()) {
                $out = '';
                $size = jwLayout::col_class(12);
                
                $out .= '<div class="row">';
                $out .= '<div class="classic-page-content ' . esc_attr($size) . '">';
                $out .= do_shortcode($content);
                $out .= '</div>';
                $out .= '</div>';
            } else {
                $content = str_replace(']]>', ']]&gt;', $content);
                $out = do_shortcode($content);
            }
            apply_filters('jaw_revocomposer_content', $out);
            return $out;
        }
        
        /**
        * Saving PB elements
        *
        * @param type $content
        * @param type $postId
        * @return type
        */
        public static function jwPbSave($content,$where,$postId=0) {
            if (filter_input(INPUT_POST, 'jaw_builder_ws_index') !== null) {
                update_option('jaw_builder_ws_index', filter_input(INPUT_POST, 'jaw_builder_ws_index'));
            }
            $outShort = array();
            $contents = array('1_header', '2_content');
            foreach ((array)$contents as $c) {
                if (!empty($content->$c) && isset($content->$c->visible) && $content->$c->visible == true) {
                    $outShort[$c] = $content->$c;
                    if (isset($content->$c->childs)) {
                        $outShort[$c] = '';
                        foreach ((array) $content->$c->childs as $item) {
                            $outShort[$c] .= self::jwPbMake($item,$where,$postId);
                        }
                    }
                }
            }
            $sidebars = array('sidebar_right1', 'sidebar_right2', 'sidebar_left1', 'sidebar_left2');
            $side = array();
            foreach ((array)$sidebars as $c) {
                if (!empty($content->$c) && isset($content->$c->visible) && $content->$c->visible == true) {
                    $key = str_replace('sidebar_', '', $c);
                    $side[$key] = $content->$c;
                    if (isset($content->$c->metabox->sidebar_color)) {
                        jwOpt::logPreset('color', 'revo'.$where,  $postId , $content->$c->id,'sidebar_color', $content->$c->metabox->sidebar_color);
                    }
                }
            }
            $outShort['layout'] = $side;
            return $outShort;
        }
        
        public static function jwPbGenerateContent() {
            $outShort = array();
            $content = array();
            if (isset($_POST['jaw_pb'])) {
                $jawPb = $_POST['jaw_pb'];
                $jawPbShortcode = json_decode(stripslashes($jawPb));
            }
            if(isset($jawPbShortcode->{'1_header'}->childs))
                $content[] = $jawPbShortcode->{'1_header'}->childs;
            if(isset($jawPbShortcode->{'2_content'}->childs))
                $content[] = $jawPbShortcode->{'2_content'}->childs;
            foreach ((array) $content as $container) {
                foreach ((array) $container as $element) {
                    if(isset($element)){
                        $outShort[] = self::jwPbMake($element);
                    }
                }
            }
            $shortcodeContent = implode('', $outShort);
            return $shortcodeContent;
        }
        
        /* AJAX pro klikatko v tinyMCE */
        public function generateShortcodeAjax(){
            $shortcode = '';
            $type = '';
            $data = array();
            if(filter_input(INPUT_POST, 'type') !== null){
                $type = filter_input(INPUT_POST, 'type');
            }
            if(isset($_POST['data'])){
                $data = $_POST['data'];
            }
            $shortcodeFunction = 'shortcode_' . str_replace('jaw_', '', $type);
            if (method_exists('jwShort', $shortcodeFunction)) {
                $shortcode .= jwShort::$shortcodeFunction($data);
            } else {
                $shortcode .= jwShort::shortcode_default('jaw_'.$type, $data);
            }
            
            echo $shortcode;
            die();
        }
        
        //delani shorcodes - pri ukladani
        public static function jwPbMake($item,$where = null,$postId = null, $nesting = 0) {
            if($item->visible === false){
                return '';
            }
            
            $item->metabox = (array) $item->metabox;
            $atts = array();
            if (isset($item->type)) {
                $item->type = str_replace('build_', 'jaw_', $item->type);
            }
            if (isset($item->metabox['class'])) {
                $atts['class'] = $item->metabox['class'];
            }
            if (isset($item->metabox['el_id'])) {
                $atts['el_id'] = $item->metabox['el_id'];
            }
            if (isset($item->metabox['space_after'])) {
                $atts['space_after'] = $item->metabox['space_after'];
            }
            if (isset($item->size)) {
                $atts['size'] = $item->size;
            }
            if (isset($item->metabox['title'])) {
                $atts['box_title'] = $item->metabox['title'];
            }
            if (isset($item->metabox['bar_type'])) {
                $atts['bar_type'] = $item->metabox['bar_type'];
            }
            if (isset($item->metabox['bar_h'])) {
                $atts['bar_h'] = $item->metabox['bar_h'];
            }
            if (isset($item->metabox['custom_link'])) {
                $atts['custom_link'] = $item->metabox['custom_link'];
            }
            if (isset($item->metabox['fullwidth'])) {
                $atts['fullwidth'] = $item->metabox['fullwidth'];
            }
            if (isset($item->metabox['show_on_devices'])) {
                $atts['show_on_devices'] = $item->metabox['show_on_devices'];
            }
            
            $keys = array_keys($item->metabox);
            $color = preg_grep('/.*?_color/',$keys);
            $color = array_shift($color);
            if(isset($color) && isset($where) && isset($postId)){
                $atts['color'] = $item->metabox[$color];
                jwOpt::logPreset('color', 'revo'.$where, $postId, $item->id,$color, $item->metabox[$color]);
            }
            
            $shortcode = '';
            $shortcodeFunction = 'shortcode_' . str_replace('jaw_', '', $item->type);
            
            switch($item->type){
                case 'jaw_divider':
                    $atts = array_merge($atts, $item->metabox);
                    $shortcode .= '[jaw_divider';
                    $shortcode .= ' bar_type="space" ';
                    foreach ((array) $atts as $key => $val) {
                        $shortcode .= ' ' . $key . '="' . $val . '"';
                }
                $shortcode .= ']';
                break;
            
            case 'jaw_container':
                $atts = array_merge($atts, $item->metabox);
                $shortcode .= '[jaw_container';
                if($nesting > 0){
                    $shortcode .= '-' . $nesting;
                }
                foreach ((array) $atts as $key => $val) {
                    if (is_array($val)) {
                        //pokud je to obrazek tak vemu ID
                        if (isset($val[0]) && is_object($val[0])) {
                            if (isset($val[0]->id))
                                $val = $val[0]->id;
                    } else {
                        $val = implode(',', $val);
                    }
                }
                if(!is_object($val) && !is_array($val)){
                    $shortcode .= ' ' . $key . '="' . $val . '"';
                }
            }
            $shortcode .= ']';
            if (!empty($item->childs)) {
                foreach ((array) $item->childs as $i) {
                    $shortcode .= self::jwPbMake($i,$where,$postId, $nesting + 1 );
                }
            }
            $shortcode .= '[/jaw_container';
            if($nesting > 0){
                $shortcode .= '-' . $nesting;
            }
            $shortcode .= ']';   
            break;
        
        default:
            $shortcode .= '[jaw_section';
            foreach ((array) $atts as $key => $val) {
                if(!is_object($val)){
                    $shortcode .= ' ' . $key . '="' . $val . '"';
            }
        }
        if($item->type == 'jaw_title'){
            $shortcode .= ' bar_type="space"';
        }
        $shortcode .= ']';
        if ($item->type == 'jaw_shortcode') {
            $shortcode .= $item->metabox['shortcode'];
        } else if (method_exists('jwShort', $shortcodeFunction)) {
            $shortcode .= jwShort::$shortcodeFunction($item->metabox);
        } else {
            $shortcode .= jwShort::shortcode_default($item->type, $item->metabox);
        }
        $shortcode .= '[/jaw_section]';
    }
    return $shortcode;
}

public static function printBuilderInMetabox($outputs) {
    $out = '';
    //TOP bar
    $out .= '<div class="revo-live" >';
    $out .= '<div class="reset-content" ng-click="resetContent()" title="Delete whole content"><i class="jaw-icon-remove"></i></div>';
    $out .= '<input type="text" placeholder="Search ..." class="builder-search" ng-model="searchText" ng-change="changeSearch()"/>';
    $out .= '<div class="clear"></div>';
    $out .= '</div>';
    
    //Bookmarks
    $out .= '<div class="revo-bookmarks noselect " >';
    $out .= $outputs;
    $out .= '<div class="clear"></div>';
    $out .= '</div>';
    $out .= '<div class="section-ribbon-items noselect "  ><ul class="elements_list" ng-include src="current_bookmark"></ul></div>';
    
    
    $builderWsIndex = (int) get_option('jaw_builder_ws_index');
    
    if(!($builderWsIndex > 0)){
        $builderWsIndex = 0;
    }
    
    //CONTENT
    $out .= '<div class="revo_container noselect ">';
    $out .= '<div class="s_container">';
    $out .= '<div class="jaw-pb s_row" >';
    $out .= '<div class="s_12">';
    $out .= '<div class="jaw-metabox-workspace s_row" ng-model="workspace"  ng-class="isInitalized">';
    $out .= '<div id="item-{{entity.id}}" class="builder-element s_{{entity.size}} jb-{{entity.type}} visible-{{entity.visible}}" ng-repeat="(i,entity) in workspace" ng-include src="\'temp-jaw_build_enitiy\'"></div>';
    $out .= '<div class="clear"></div>';
    $out .= '</div>';
    
    $out .= '<input type="hidden" name="jaw_pb_startup" class="jaw_pb_startup"  value="' . get_post_meta(get_the_ID(), 'jaw_pb_startup', true) . '" />';
    $out .= '<input type="hidden" name="jaw_builder_ws_index" value="{{builder_ws_index}}" ng-init="init_index('. ++$builderWsIndex . ');" ng-model="builder_ws_index">';
    
    // PRESETS ======================================
    $loadPressets = jwOpt::loadAllPresets('revo');
    $presets = array();
    foreach((array) $loadPressets as $key => $preset){
        $preset = (array)$preset;
        if(isset($preset['title'])){
            $presets[] = array('id' => $key, 'title' => $preset['title']);
        }
    }
    
    $loadElPresets = jwOpt::loadAllPresets('revoelement');
    $presetsElements = array();
    foreach((array) $loadElPresets as $key => $preset){
        $preset = (array)$preset;
        if(isset($preset['title'])){
            $presetsElements[] = array('id' => $key, 'title' => $preset['title']);
        }
    }
    $out .= '<span ng-init=\'init_presets('. json_encode($presets).',"revo");init_presets('. json_encode($presetsElements).',"revoelement");\'></span>';
    // PRESETS END ==================================
    
    $out .= '</div>';
    $out .= '</div>';
    $out .= '<div class="clear"></div>';
    $out .= '</div>'; //Konec CONTAINERU
    $out .= '</div>'; //Konec revo_container
    
    
    
    // template of one element
    $out .= '<script id="temp-jaw_build_enitiy" type="text/ng-template">';
    $out .= ' <div class="element" ng-right-click="contextMenu(entity,$event)">';
    $out .= ' <li class="element_block" >';
    $out .= '    <div class="tools">';
    $out .= '    <div class="tool_bar">';
    $out .= '    <div class="controls size">';
    
    $out .= '        <div class="minus" ng-click="change_size(entity,false)"><i class="jaw-icon-arrow-left13"></i></div>';
    $out .= '        <div class="text" >size</div>';
    $out .= '        <div class="plus" ng-click="change_size(entity,true)"><i class="jaw-icon-arrow-right14"></i></div>';
    
    $out .= '    </div>';
    $out .= '    <div class="edit controls">';
    $out .= '        <div class="delete control_btn" title="Delete this element"  ng-click="delete_element(i, $parent.$parent.$parent.entity);"><i class="jaw-icon-cancel-circle2 "></i></div>';
    $out .= '        <div class="add_element_preset control_btn" title="Save this element as preset" ng-click="add_preset(entity,entity.id,\'revoelement\')"><i class="jaw-icon-disk" ng-show="!loader[\'add_\'+entity.id]"></i><i  class="jaw-icon-spinner2 jaw-spinit" ng-show="loader[\'add_\'+entity.id]"></i></div>';
    $out .= '        <div class="clone control_btn" title="Clone this element" ng-click="clone_element(entity, $parent.$parent.$parent.entity)"><i class="jaw-icon-copy"></i></div>';
    $out .= '        <div class="edit control_btn" title="Edit settings of this element" ng-click="edit_element(entity);"><i class="jaw-icon-wrench " ng-show="!loader[entity.id]"></i><i  class="jaw-icon-spinner2 jaw-spinit" ng-show="loader[entity.id]"></i></div>';
    $out .= '    </div>';
    $out .= '    </div>';
    $out .= '    <div class="info controls">';
    $out .= '        <i class="{{getConfig(entity.type,\'icon\')}}"></i>';
    $out .= '        <h5 class="pb_element_name">{{getConfig(entity.type,\'name\')}}</h5>';
    $out .= '        <input class="pb_element_change"  type="text" ng-model="entity.metabox.title">';
    $out .= '        <span class="jw-show-on">';
    $out .= '        <i class="jaw-icon-screen4" ng-show="entity.metabox.show_on_devices === \'all\' || entity.metabox.show_on_devices === \'desktop-tablet\' || entity.metabox.show_on_devices === \'only-desktop\'" title="Show on desktops"></i>';
    $out .= '        <i class="jaw-icon-tablet" ng-show="entity.metabox.show_on_devices === \'all\' || entity.metabox.show_on_devices === \'desktop-tablet\' ||  entity.metabox.show_on_devices === \'phone-tablet\' || entity.metabox.show_on_devices === \'only-tablet\'" title="Show on tablets"></i>';
    $out .= '        <i class="jaw-icon-mobile" ng-show="entity.metabox.show_on_devices === \'all\' || entity.metabox.show_on_devices === \'phone-tablet\' || entity.metabox.show_on_devices === \'only-phone\'" title="Show on phones"></i>';
    $out .= '    </span>';
    $out .= '    </div>';
    $out .= '    </div>';
    $out .= '    <div class="zaves"></div>';
    $out .= '    <div class="symbol_block">';
    $out .= '        <div class="builder_element_content"></div>';
    $out .= '    </div>';
    $out .= '    <ul class="jwpb-childs"  ui-sortable="sortableOptions"  ng-model="entity.childs">';
    $out .= '       <li id="item-{{entity.id}}" class="builder-element s_{{entity.size}} jb-{{entity.type}} visible-{{entity.visible}}" ng-repeat="(i,entity) in entity.childs" ng-include src="\'temp-jaw_build_enitiy\'"></li>';
    $out .= '    </ul>';
    $out .= '</li>';
    $out .= '</div>';
    $out .= '</script>';
    
    
    //DESCRIPTION
    $out .= '<div class="jw-help-content jaw-builder-description" >';
    $out .= '<div class="jw-help-title" ><strong>{{description.name}}</strong></div>';
    $out .= '<div class="jw-help-description" >{{description.desc}}</div>';
    $out .= '<div class="jw-help-img"><img ng-src="{{description.img}}" ng-show="description.img" alt="description"/></div>';
    $out .= '</div>';
    
    //RIGHTCLICK MENU
    $out .= '<div class="jaw-builder-context-menu jaw-context-menu" >';
    $out .= '<ul>';
    $out .= '<li ng-click="edit_element(contextMenuItem);">Edit</li>';
    $out .= '<li class="jw-line"></li>';
    $out .= '<li ng-click="toggle_visible_element(contextMenuItem);">Hide / Show</li>';
    $out .= '<li ng-click="set_fullwidth(contextMenuItem);">Set maximal width</li>';
    $out .= '</ul>';
    $out .= '</div>';
    
    $out .= '<div class="jaw-builder-background loading">Loading... <br><i  class="jaw-icon-spinner2 jaw-spinit"></i></div>';
    $out .= '<div class="jaw-builder-background edit" style="display:none;"></div>';
    $out .= '<div class="builder_editor" ></div>';
    return $out;
    // END template of one element
}

function shortcodeAttributes($attribute){
    if(is_numeric($attribute)){
        $attribute = (string) $attribute;
    }
    return $attribute;
}

}

}