<?php

global $metapagebuild, $jaw_builder_options, $metabuild;


// BAR TYPES
$jaw_builder_options['global_bar_type'] = array(
    'id' => 'bar_type',
    'type' => 'layout',
    'name' => 'Bar Type',
    "desc" =>  'Select this element&acute;s header type. <strong>DEFAULT: Theme Options -> General Settings -> Global Heading Style</strong>',
    'std' => '_default',
    "hide_if_layout" => array('shortcodes'),
    "options" => array(
        "_default" => JAW_ADMIN_URI . 'assets/images/default_title.png',
        "off" => JAW_ADMIN_URI . 'assets/images/title_off.png',
        "space" => JAW_ADMIN_URI . 'assets/images/title_off_without_space.png',
        'bar_type_1' => JAW_ADMIN_URI . 'assets/images/left_border.png',
        'bar_type_2' => JAW_ADMIN_URI . 'assets/images/top_bottom.png',
        'bar_type_3' => JAW_ADMIN_URI . 'assets/images/with_background.png',
        'bar_type_4' => JAW_ADMIN_URI . 'assets/images/bar_type_4.png',
        'bar_type_big_left' => JAW_ADMIN_URI . 'assets/images/title_big_left.png',
        'bar_type_big_center' => JAW_ADMIN_URI . 'assets/images/title_big_center.png',
        'bar_type_big_right' => JAW_ADMIN_URI . 'assets/images/title_big_right.png',
    )
);

$jaw_builder_options['global_bar_h'] = array(
    'id' => 'bar_h',
    'type' => 'toggle',
    'name' => 'H tag type',
    "hide_if_layout" => array('shortcodes'),
    'desc' => '',
    'std' => '3',
    "builder" => 'true',
    "options" => array("1" => "h1", "2" => "h2", "3" => "h3")
);

$jaw_builder_options['global_design_type'] = array(
    '_default' => JAW_ADMIN_URI . 'assets/images/default_title.png',
    'bar_type_1' => JAW_ADMIN_URI . 'assets/images/left_border.png',
    'bar_type_2' => JAW_ADMIN_URI . 'assets/images/top_bottom.png',
    'bar_type_3' => JAW_ADMIN_URI . 'assets/images/with_background.png',
    'bar_type_4' => JAW_ADMIN_URI . 'assets/images/bar_type_4.png',
    'bar_type_big_left' => JAW_ADMIN_URI . 'assets/images/title_big_left.png',
    'bar_type_big_center' => JAW_ADMIN_URI . 'assets/images/title_big_center.png',
    'bar_type_big_right' => JAW_ADMIN_URI . 'assets/images/title_big_right.png',
);

// CUSTOM LINKS
$jaw_builder_options['global_custom_link'] = array(
    'id' => 'custom_link',
    'type' => 'text',
    "hide_if_layout" => array('shortcodes'),
    'name' => '<i class="jaw-icon-link"></i> Custom Link',
    "desc" => 'Insert your custom link for title of this element.',
    'std' => '',
    
);

// ORDERBY
$jaw_builder_options['global_orderby'] = array(
    'id' => 'orderby_check_msg',
    "name" => "Warning Message",
    "text" => 'Please bear in mind that Posts that have 0 views will not be sorted',
    "type" => "info",
    "space" => false,
    "message" => "warnings",
    'ng-show' => 'edit[\'orderby\']==\'most_visited\' || edit[\'orderby\']==\'most_liked\''
);
$jaw_builder_options['global_orderby'] = array(
    'id' => 'orderby',
    'type' => 'select',
    'name' => 'Post Order by',
    "desc" => 'Order posts by parameters. Help on <a target="_blank" href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters">Order by Parameters</a>.',
    'std' => 'date',
    'mod' => 'medium',
    
    'options' => array(
        "date" => "Date",
        "none" => "None",
        "ID" => "ID",
        "post__in" => "By the >Post In< option",
        "author" => "Author",
        "title" => "Title",
        "modified" => "Modified",
        "parent" => "Parent",
        "rand" => "Rand",
        "comment_count" => "Comments count",
        "most_liked" => "Most Liked",
        "most_visited" => "Most Visited"
    )
);
//show on devices
$jaw_builder_options['show_on_devices'] = array(
    'id' => 'show_on_devices',
    'type' => 'toggle',
    'name' => 'Show Item on Devices',
    "desc" => 'Choose whether or not and where to show slider - either on desktop or on desktop and tablets.',
    'std' => 'all',
    "hide_if_layout" => array('shortcodes'),
    'options' => array(
        "all" => "<i class='jaw-icon-screen4'></i><i class='jaw-icon-tablet'></i><i class='jaw-icon-mobile'></i>",
        "desktop-tablet" => "<i class='jaw-icon-screen4'></i><i class='jaw-icon-tablet'></i>", 
        "phone-tablet" => "<i class='jaw-icon-tablet'></i><i class='jaw-icon-mobile'></i>",
        "only-desktop" => "<i class='jaw-icon-screen4'></i>", 
        "only-tablet" => "<i class='jaw-icon-tablet'></i>",
        "only-phone" => "<i class='jaw-icon-mobile'></i>",
    )
);
//space after element
$jaw_builder_options['space_after']  = array(
    'id' => 'space_after',
    'type' => 'toggle',
    'name' => 'Show Standart Space After',
    'desc' => 'If you don`t want to show standart 30px gap after this element',
    'std' => 'space_after',
    "options" => array("no_space_after" => "Off", "space_after" => "On")
);


//filter $jaw_builder_options
$jaw_builder_options = apply_filters('jaw_revocomposer_elements_editor',$jaw_builder_options);



//TEMPLATES ====================================================================
//HOME =========================================================================

$home[] = array(
    "name" => "Container",
    
    "id" => "build_container",
    "type" => "builder",
    
    'icon' => 'jaw-icon-insert-template',
    "size" => 12
);


$home[] = array(
    "name" => "Advanced List",
    "id" => "build_list_advanced",
    "type" => "builder",
    'icon' => 'jaw-icon-list2',
    "size" => 12
);


$home[] = array(
    "name" => "Blog",
    
    "id" => "build_blog",
    "type" => "builder",
    "icon" => 'jaw-icon-newspaper',
    "size" => 12
);

$home[] = array(
    "name" => "Button",
    
    "id" => "build_button",
    
    "type" => "builder",
    'icon' => 'jaw-icon-radio-checked ',
    "size" => 3
);

if (is_plugin_active('contact-form-7/wp-contact-form-7.php')) {
    $home[] = array(
        "name" => "Contact Form 7",
        
        "id" => "build_contact_form",
        "type" => "builder",
        'icon' => 'jaw-icon-envelope3 ',
        "size" => 12
    );
}

$home[] = array(
    "name" => "Custom Text",
    
    "id" => "build_custom_text",
    "type" => "builder",
    'icon' => 'jaw-icon-pencil2',
    "size" => 12
);

$home[] = array(
    "name" => "Divider",
    "help" => array("Divider", 'Divider line over whole page'),
    "id" => "build_divider",
    "type" => "builder",
    "size" => 12,
    'icon' => 'jaw-icon-minus',
    'edit_name' => 'false'
);

$home[] = array(
    "name" => "Image",
    
    "id" => "build_image",
    "type" => "builder",
    'icon' => 'jaw-icon-image',
    "size" => 12
);

$home[] = array(
    "name" => "Inline Sidebar",
    "help" => array("Inline Sidebar", 'With this you can put widget to page content'),
    "id" => "build_page_sidebar",
    "type" => "builder",
    'icon' => 'jaw-icon-file ',
    "size" => 4
);


$home[] = array(
    "name" => "List",
    "help" => array("List", 'Classic ul list'),
    "id" => "build_list",
    "type" => "builder",
    'icon' => 'jaw-icon-list2',
    "size" => 12
);

$home[] = array(
    "name" => "Search",
    
    "id" => "build_search",
    "type" => "builder",
    "size" => 12,
    'icon' => 'jaw-icon-search',
    'edit_name' => 'false'
);


$home[] = array(
    "name" => "Title",
    
    "id" => "build_title",
    "type" => "builder",
    "size" => 12,
    'icon' => 'jaw-icon-type ',
    'edit_name' => 'false'
);

$metabuild['build_bookmark_home'] = array(
    "name" => "Composer",
    
    "id" => "build_bookmark_home",
    "type" => "builder_bookmark",
    'content' => $home,
    "header" => false
);


//SOCIAL & MEDIA ===============================================================
$media[] = array(
    "name" => "Social Icons",
    
    "id" => "build_social_icons",
    "type" => "builder",
    
    'icon' => 'jaw-icon-facebook4',
    "size" => 12
);

if (class_exists('mashshare')) { // mashare plugin
    $media[] = array(
        "name" => "Mashshare",
        
        "id" => "build_mashshare",
        "type" => "builder",
        
        'icon' => 'jaw-icon-share2',
        "size" => 12
    );
}

$media[] = array(
    "name" => "Vimeo Video",
    
    "id" => "build_v_video",
    "type" => "builder",
    'icon' => 'jaw-icon-vimeo3',
    "size" => 12
);

$media[] = array(
    "name" => "YouTube Video",
    
    "id" => "build_y_video",
    "type" => "builder",
    'icon' => 'jaw-icon-youtube',
    "size" => 12
);

$metabuild['build_bookmark_media'] = array(
    "name" => "Social & Media",
    
    "id" => "build_bookmark_media",
    "type" => "builder_bookmark",
    'content' => $media,
    "header" => false
);

//TEXT (content) ===============================================================
$content[] = array(
    "name" => "Accordion",
    
    "id" => "build_accordion",
    "type" => "builder",
    'icon' => ' jaw-icon-stack-list ',
    "size" => 12
);

$content[] = array(
    "name" => "Blockquote",
    "help" => array("Blockquote", 'Quotation of a large section'),
    "id" => "build_quote",
    "type" => "builder",
    'icon' => 'jaw-icon-quotes-left',
    "size" => 12
);

$content[] = array(
    "name" => "Call to Action",
    
    "id" => "build_cta",
    "type" => "builder",
    'icon' => 'jaw-icon-newspaper',
    "size" => 12
);

$content[] = array(
    "name" => "Google Fonts",
    
    "id" => "build_googlefonts",
    "type" => "builder",
    'icon' => ' jaw-icon-font ',
    "size" => 12
);

$content[] = array(
    "name" => "Info Box",
    
    "id" => "build_panel_box",
    "type" => "builder",
    'icon' => ' jaw-icon-info ',
    "size" => 12
);

$content[] = array(
    "name" => "Message Text",
    
    "id" => "build_message",
    "type" => "builder",
    'icon' => 'jaw-icon-pen',
    "size" => 12
);

$content[] = array(
    "name" => "Tabs",
    
    "id" => "build_tabs",
    "type" => "builder",
    
    'icon' => 'jaw-icon-insert-template',
    "size" => 12
);

$content[] = array(
    "name" => "Table of Content",
    
    "id" => "build_table_of_content",
    "type" => "builder",
    
    'icon' => 'jaw-icon-insert-template',
    "size" => 12
);

$metabuild['build_bookmark_content'] = array(
    "name" => "Text Content",
    
    "id" => "build_bookmark_content",
    "type" => "builder_bookmark",
    'content' => $content,
    "header" => false
);

//Featured =====================================================================

$featured[] = array(
    "name" => "About Author",
    
    "id" => "build_author",
    "type" => "builder",
    
    'icon' => 'jaw-icon-user4',
    "size" => 12
);

$featured[] = array(
    "name" => "Breaking News",
    "help" => array("Breaking News", "", "breaking-news-classic.jpg"), 
    "id" => "build_ticker",
    "type" => "builder",
    'icon' => 'jaw-icon-bars2 ',
    "size" => 12
);


$featured[] = array(
    "name" => "Circle Chart",
    
    "id" => "build_circle_chart",
    "type" => "builder",
    'icon' => 'jaw-icon-pie',
    "size" => 12
);

$featured[] = array(
    "name" => "Contact",
    
    "id" => "build_contact",
    "type" => "builder",
    'icon' => 'jaw-icon-phone ',
    "size" => 12
);

$featured[] = array(
    "name" => "Countdown",
    
    "id" => "build_countdown",
    "type" => "builder",
    'icon' => 'jaw-icon-clock ',
    "size" => 6
);

$featured[] = array(
    "name" => "Counter",
    
    "id" => "build_counter",
    "type" => "builder",
    'icon' => 'jaw-icon-plus-3px',
    "size" => 4
);

$featured[] = array(
    "name" => "Custom Banner",
    
    "id" => "build_banner",
    "type" => "builder",
    'icon' => 'jaw-icon-file8 ',
    "size" => 12
);

$featured[] = array(
    "name" => "Gallery",
    
    "id" => "build_gallery",
    "type" => "builder",
    'icon' => 'jaw-icon-images2',
    "size" => 12
);

$featured[] = array(
    "name" => "JaW Gallery",
    
    "id" => "build_media_gallery",
    "type" => "builder",
    'icon' => 'jaw-icon-images2',
    "size" => 12
);

$featured[] = array(
    "name" => "Post Rating",
    
    "id" => "build_post_rating",
    "type" => "builder",
    'icon' => 'jaw-icon-star3',
    "size" => 12
);

$featured[] = array(
    "name" => "Presentation Box",
    
    "id" => "build_presentation_box",
    "type" => "builder",
    'icon' => 'jaw-icon-insert-template',
    "size" => 4
);

$featured[] = array(
    "name" => "Google Maps",
    
    "id" => "build_google_map",
    "type" => "builder",
    'icon' => 'jaw-icon-map',
    "size" => 12
);

$featured[] = array(
    "name" => "Icon",
    
    "id" => "build_icon",
    "type" => "builder",
    'icon' => 'jaw-icon-IcoMoon',
    "size" => 12
);

$featured[] = array(
    "name" => "Iframe",
    
    "id" => "build_iframe",
    "type" => "builder",
    'icon' => 'jaw-icon-file3',
    "size" => 12
);

$featured[] = array(
    "name" => "List of Authors",
    
    "id" => "build_authors",
    "type" => "builder",
    
    'icon' => 'jaw-icon-users4',
    "size" => 12
);

$featured[] = array(
    "name" => "Log In & Registration Form",
    
    "id" => "build_login",
    "type" => "builder",
    'icon' => 'jaw-icon-lock4',
    "size" => 12
);

/* 20.6.2016 - smazano
$featured[] = array(
    "name" => "Page",
    
    "id" => "build_page",
    "type" => "builder",
    'icon' => 'jaw-icon-file5',
    "size" => 12
);*/

$featured[] = array(
    "name" => "Progress Bar",
    
    "id" => "build_progressbar",
    "type" => "builder",
    'icon' => 'jaw-icon-bars2 ',
    "size" => 12
);

$featured[] = array(
    "name" => "QRcode",
    
    "id" => "build_qrcode",
    "type" => "builder",
    'icon' => 'jaw-icon-qrcode  ',
    "size" => 3
);

$featured[] = array(
    "name" => "Recent Comments",
    
    "id" => "build_recent_comments",
    "type" => "builder",
    'icon' => 'jaw-icon-bubbles5 ',
    "size" => 12
);

$featured[] = array(
    "name" => "Shortcode",
    
    "id" => "build_shortcode",
    "type" => "builder",
    'icon' => 'jaw-icon-file-css',
    "size" => 12
);

$featured[] = array(
    "name" => "Submit Message",
    
    "id" => "build_submit_message",
    "type" => "builder",
    'icon' => 'jaw-icon-newspaper',
    "size" => 12
);

if (class_exists('DZSVideoGallery')) {
    $featured[] = array(
        "name" => "Video Playlist",
        
        "id" => "build_video_playlist",
        "type" => "builder",
        'icon' => 'jaw-icon-movie',
        "size" => 12
    );
}

if (class_exists('MC4WP_Plugin')) {
    $featured[] = array(
        "name" => "MailChimp Newsletter Form",
        
        "id" => "build_mailchimp_form",
        "type" => "builder",
        'icon' => 'jaw-icon-envelope3',
        "size" => 3
    );
}

if (is_plugin_active('wysija-newsletters/index.php')) {
    $featured[] = array(
        "name" => "MailPoet (Wysija) Newsletter Form",
        
        "id" => "build_wysija_form",
        "type" => "builder",
        'icon' => 'jaw-icon-envelope3',
        "size" => 3
    );
}

$metabuild['build_bookmark_featured'] = array(
    "name" => "Features",
    
    "id" => "build_bookmark_featured",
    "type" => "builder_bookmark",
    'content' => $featured,
    "header" => false
);


// CAROUSELS ===================================================================
$carousel[] = array(
    "name" => "Custom HTML Carousel",
    
    "id" => "build_html_carousel",
    "type" => "builder",
    'icon' => 'jaw-icon-stack-picture ',
    "size" => 12
);

$carousel[] = array(
    "name" => "Blog Carousel",
    
    "id" => "build_blog_carousel",
    "type" => "builder",
    'icon' => 'jaw-icon-stack-picture ',
    "size" => 12
);

$carousel[] = array(
    "name" => "Blog Carousel Vertical",
    
    "id" => "build_blog_carousel_vertical",
    "type" => "builder",
    'icon' => 'jaw-icon-stack-picture ',
    "size" => 12
);

$metabuild['build_carousel'] = array(
    "name" => "Carousels",
    
    "id" => "build_carousel",
    "type" => "builder_bookmark",
    'content' => $carousel,
    "header" => false
);

// Slider submenu ==============================================================
$sliders[] = array(
    "name" => "Special Slider",
    "help" => array("Special Slider", "", "slider_special.jpg"),
    "id" => "build_slider_1",
    "type" => "builder",
    'icon' => 'jaw-icon-notebook',
    "size" => 12,
);

$sliders[] = array(
    "name" => "Squares Slider",
    "id" => "build_slider_2",
    "help" => array("Squares Slider", "", "slider_stripe.jpg"),
    "type" => "builder",
    'icon' => 'jaw-icon-notebook',
    "size" => 12,
);

$sliders[] = array(
    "name" => "Slider with Thumbnails",
    
    "id" => "build_slider_3",
    "help" => array("Slider with Thumbnails", "", "slider_tiles.jpg"),
    "type" => "builder",
    'icon' => 'jaw-icon-notebook',
    "size" => 12,
);

$sliders[] = array(
    "name" => "Row Slider",
    "help" => array("Row Slider", "", "slider_fullwidth_stripe.jpg"),
    "id" => "build_slider_4",
    "type" => "builder",
    'icon' => 'jaw-icon-notebook',
    "size" => 12,
);

$sliders[] = array(
    "name" => "Big Photo Slider",
    "help" => array("Big Photo Slider", "DO NOT use it inside fullwidth container !!!", "slider_fullwidth.png"),
    "id" => "build_slider_5",
    "type" => "builder",
    'icon' => 'jaw-icon-notebook',
    "size" => 12,
);


$sliders[] = array(
    "name" => "JaW Grid",
    "help" => array("JaW Grid", "", "grid.jpg"),
    "id" => "build_grid",
    "type" => "builder",
    'icon' => 'jaw-icon-ad',
    "size" => 12,
);

if (is_plugin_active('revslider/revslider.php')) {
    $sliders[] = array(
        "name" => "Revolution Slider",
        "help" => array("Revolution Slider", '3rd party plugin for creating ultimate sliders'),
        "id" => "build_slider_revolution",
        "type" => "builder",
        'icon' => 'jaw-icon-notebook',
        "size" => 12,
    );
}

if (class_exists('Essential_Grid')) {
    $sliders[] = array(
        "name" => "Essential Grid",
        "help" => array("Essential Grid", '3rd party plugin for creating grid banners'),
        "id" => "build_essential_grid",
        "type" => "builder",
        'icon' => 'jaw-icon-table2',
        "sizes" => '3,4,5,6,7,8,9,10,11,12',
        "size" => 12,
    );
}


if (isset($sliders)) {
    $metabuild['build_slider'] = array(
        "name" => "Sliders",
        
        "id" => "build_slider",
        "type" => "builder_bookmark",
        'content' => $sliders,
        "header" => false
    );
}

// WOO submenu =================================================================

//filter 
$metabuild = apply_filters('jaw_revocomposer_elements', $metabuild);


// all button ==================================================================

$all_items = array();
foreach($metabuild as $key => $meta){
    if(!empty($meta['content'])){
        $all_items = array_merge($all_items, $meta['content']);
    }
}
$metabuild['build_all'] = array(
    "name" => "All",
    
    "id" => "build_all",
    "type" => "builder_bookmark",
    'content' => jwUtils::aasort($all_items, "name"),
    "header" => false
);

// ELEMENT PRESSETS ====================================================================

$elements_presets[] = array(
    "name" => "Presets",
    
    "id" => "build_element_presets",
    "std" => 'blog',
    "type" => "element_preset",
    "extend" => 'jaw-pb-sidebar',
    "header" => false,
    "template" => 'true',
    "options" => array()
);

$metabuild['build_element_preset_bookmark'] = array(
    "name" => "Element Presets",
    
    "id" => "build_element_preset_bookmark",
    "type" => "builder_bookmark",
    'content' => $elements_presets,
    'icon' => 'jaw-icon-book2 ',
    "header" => false
);


// PRESSETS ====================================================================
$presets[] = array(
    "name" => "Presets",
    
    "id" => "build_presets",
    "std" => 'blog',
    "type" => "preset",
    "extend" => 'jaw-pb-sidebar',
    "header" => false,
    "template" => 'true',
    "options" => array()
);

$metabuild['build_preset_bookmark'] = array(
    "name" => "  Presets",
    
    "id" => "build_preset_bookmark",
    "type" => "builder_bookmark",
    'content' => $presets,
    'icon' => 'jaw-icon-book2 ',
    "header" => false
);

// LAYOUT ======================================================================
$layout[] = array(
    "name" => "Page Layout",
    
    "id" => "build_layout",
    "type" => "layout_pb",
    "extend" => 'jaw-pb-sidebar',
    "header" => false,
    "template" => 'true',
    "options" => array(
        'fullwidth' => JAW_ADMIN_URI . 'assets/images/no_sidebar.gif',
        'left1' => JAW_ADMIN_URI . 'assets/images/left_sidebar.gif',
        'right1' => JAW_ADMIN_URI . 'assets/images/right_sidebar.gif',
        'right1_left1' => JAW_ADMIN_URI . 'assets/images/right_left_sidebar.gif',
        'left1_left2' => JAW_ADMIN_URI . 'assets/images/left_left_sidebar.gif',
        'right1_right2' => JAW_ADMIN_URI . 'assets/images/right_right_sidebar.gif',
        'left1_left2_right1' => JAW_ADMIN_URI . 'assets/images/left_left_right_sidebar.gif',
        'left1_right1_right2' => JAW_ADMIN_URI . 'assets/images/left_right_right_sidebar.gif'
    )
);

$metabuild['build_layout_bookmark'] = array(
    "name" => "Page Layout",
    
    "id" => "build_layout_bookmark",
    "type" => "builder_bookmark",
    'content' => $layout,
    'icon' => 'jaw-icon-table2 ',
    "header" => false
);

$submetabuild = array();
$submetabuild[] = array(
    "name" => "Builder",
    
    "id" => "jaw_pb",
    "type" => "jaw_builder",
    "areas" => "{
                'content': [
                    {'id': '2_content', 'type': 'content', 'size': 12},
                    {'id': '1_header', 'type': 'content', 'size': 12}
                ],
                'sidebar': [
                    {'id': 'sidebar_left1', 'type': 'sidebar', 'size': 2, 'visible': false},
                    {'id': 'sidebar_left2', 'type': 'sidebar', 'size': 2, 'visible': false},
                    {'id': 'sidebar_right1', 'type': 'sidebar', 'size': 2, 'visible': false},
                    {'id': 'sidebar_right2', 'type': 'sidebar', 'size': 2, 'visible': false}
                ]
            }", 
    'content' => $metabuild
);

$metapagebuild = array(
    "id" => "jaw_page_builder",
    "type" => "page_builder",
    "title" => "RevoComposer", //"Ultra Mega Awesome Greatest Smartest Page builder",
    "pages" => array('page'),
    "context" => "normal", //Optional. The context within the page where the boxes should show ('normal', 'advanced')
    "priority" => "high", //Optional. The priority within the context where the boxes should show ('high', 'low').
    "help" => null,
    "class" => "jw-hidden", //javascript tento metabox prenasi jinam - v klasicke poloze jej chceme skryt
    "fields" => $submetabuild
);

