<?php

global $jaw_builder_options;

$of_options = array();

/* ==== CONTENT ==== */
$of_options[] = array(
    "name" => "Content",
    "type" => "sectionstart");
$of_options[] = array("name" => "Main Title",
    "desc" => "Enter a main title for ticker",
    "id" => "ticker_title",
    "std" => "Breaking News",
    "type" => "text"
);
$of_options[] = array(
    'id' => 'category__in',
    'type' => 'multidropdown',
    'name' => 'Include Blog Category',
    'desc' => '(Doesn`t include child categories)',
    "page" => null,
    "chosen" => "true",
    "target" => 'cat',
    "prompt" => "Choose category..",
    
);
$of_options[] = array(
    'id' => 'category__not_in',
    'type' => 'multidropdown',
    'name' => 'Exclude Blog Category',
    'desc' => '(Doesn`t include child categories)',
    "page" => null,
    "chosen" => "true",
    "target" => 'cat',
    "prompt" => "Choose category..",
    
);

$of_options[] = array(
    'id' => 'count',
    'type' => 'range',
    'name' => 'Number of Posts',
    'desc' => 'Set number of posts per page.',
    'std' => '6',
    'min' => '1',
    'max' => '40',
    'step' => '1',
    'unit' => ''
);
$of_options[] = array(
    'id' => 'automatic_slide',
    'type' => 'toggle',
    'name' => 'Automatic Sliding',
    'desc' => 'Decide whether or not to allow moving a content of your carousel automatically.',
    'std' => '1',
    
    "options" => array("1" => "On", "0" => "Off")
);

$of_options[] = $jaw_builder_options['global_orderby'];

$of_options[] = array(
    "type" => "sectionend");
/* ==== TEXT SETTING ==== */
$of_options[] = array(
    "name" => "Text Format",
    "type" => "sectionstart");


$of_options[] = array("name" => "Number of Characters - Post Titles",
    "desc" => "Enter a number of characters for your post titles.",
    "id" => "letter_excerpt_title",
    "std" => 60,
    "mod" => 'micro',
    'maxlength' => 4,
    "type" => "text"
);


$of_options[] = array(
    "type" => "sectionend");

/* ==== DESIGN ==== */
$of_options[] = array(
    "name" => "Design",
    "type" => "sectionstart");

$of_options[] = array(
    'id' => 'ticker_preset_color',
    'name' => '<i class="jaw-icon-palette jaw-preset-icon"></i> Color preset',
    'desc' => '',
    "std" => "_default",
    'type' => 'select_preset',
    "target" => "color"
);

$of_options[] = array(
    'id' => 'ticker_type',
    'name' => 'Breaking News Type',
    'desc' => 'Design of Breaking News.',
    'std' => 'classic',
    "type" => "layout",
    "options" => array(
        'classic' => JAW_ADMIN_URI . 'assets/images/breaking-news-classic.png',
        'news' => JAW_ADMIN_URI . 'assets/images/breaking-news-news.png'
    )
);

$of_options[] = array(
    'id' => 'ticker_direction',
    'type' => 'select',
    'name' => 'Breaking News Direction',
    'desc' => 'Animation type of Breaking News items.',
    'std' => 'horizontal',
    'mod' => 'medium',
    
    'options' => array(
        "horizontal" => "Horizontal",
        "vertical" => "Vertical",
    )
);

$of_options[] = $jaw_builder_options['show_on_devices'];

$of_options[] = array(
    'id' => 'class',
    'type' => 'text',
    "hide_if_layout" => array('shortcodes'),
    'name' => '<i class="jaw-icon-code"></i> Custom Class',
    'desc' => 'Insert your custom class for this element.',
    'std' => ''
);

$of_options[] = array(
    'id' => 'el_id',
    "hide_if_layout" => array('shortcodes'),
    'type' => 'text',
    'name' => '<i class="jaw-icon-code"></i> Custom ID',
    'desc' => 'Insert your custom ID for this element.',
    'std' => ''
);

$of_options[] = array(
    "type" => "sectionend");



/* ==== BAR ==== */
$of_options[] = array(
    "name" => "Bar",
    "hide_if_layout" => array('shortcodes'),
    "type" => "sectionstart");


// Typ baru se prejima z globalni promenne definovane v metabox-builder.php

$of_options[] = $jaw_builder_options['global_bar_type'];  $of_options[] = $jaw_builder_options['global_bar_h'];
$of_options[] = $jaw_builder_options['global_custom_link'];


$of_options[] = array(
    "hide_if_layout" => array('shortcodes'),
    "type" => "sectionend");


/* Settings */
$jaw_builder_options['ticker'] = $of_options;
