<?php

global $jaw_builder_options;
 
$of_options = array();

/* ==== CONTENT ==== */
$of_options[] = array(
    "name" => "Content",
    "type" => "sectionstart");

$of_options[] = array(
    'id' => 'use_author',
    'type' => 'toggle',
    'name' => 'Social URLs Sources',
    'desc' => 'Decide whether to use social URLs from authors/users personal options or from the settings in the Custom URLs tab.',
    'std' => '1',
    
    "options" => array("1" => "Author", "0" => "Custom")
);


$of_options[] = array(
    "name" => "Author",
    "desc" => 'Choose author.',
    "id" => "build_authors",
    "type" => "authors",
   
);


$of_options[] = array(
    "type" => "sectionend");



/* ==== Custom URLs ==== */
$of_options[] = array(
    "name" => "Custom URLs",
    "type" => "sectionstart");

$of_options[] = array(
    "name" => "<i class='icon-facebook4'></i> Facebook URL",
    "desc" => "",
    "id" => "facebook",
    "std" => "",
    "type" => "text"
);

$of_options[] = array(
    "name" => "<i class='icon-twitter3'></i> Twitter URL",
    "desc" => "",
    "id" => "twitter",
    "std" => "",
    "type" => "text"
);

$of_options[] = array(
    "name" => "<i class='icon-google-plus4'></i> Google URL",
    "desc" => "",
    "id" => "google",
    "std" => "",
    "type" => "text"
);

$of_options[] = array(
    "name" => "<i class='icon-youtube '></i> YouTube URL",
    "desc" => "",
    "id" => "youtube",
    "std" => "",
    "type" => "text"
);

$of_options[] = array(
    "name" => "<i class='icon-linkedin '></i> LinkedIn URL",
    "desc" => "",
    "id" => "linkedin",
    "std" => "",
    "type" => "text"
);

$of_options[] = array(
    "name" => "<i class='icon-vimeo3 '></i> Vimeo URL",
    "desc" => "",
    "id" => "vimeo",
    "std" => "",
    "type" => "text"
);

$of_options[] = array(
    "name" => "<i class='icon-flickr4 '></i> Flickr URL",
    "desc" => "",
    "id" => "flickr",
    "std" => "",
    "type" => "text"
);
 
$of_options[] = array(
    "name" => "<i class='icon-pinterest'></i> Pinterest URL",
    "desc" => "",
    "id" => "pinterest",
    "std" => "",
    "type" => "text"
);

$of_options[] = array(
    "name" => "<i class='icon-instagram'></i> Instagram URL",
    "desc" => "",
    "id" => "instagram",
    "std" => "",
    "type" => "text"
);
 

$of_options[] = array(
    "type" => "sectionend");


/* ==== DESIGN ==== */
$of_options[] = array(
    "name" => "Design",
    "type" => "sectionstart");

$of_options[] = array(
    'id' => 'target',
    'type' => 'select',
    'name' => 'Links Target',
    'desc' => 'Specify where to open a target link.',
    'std' => '_self',
    'mod' => 'medium',
    
    "options" => array("_blank" => "_blank", "_top" => "_top", "_parent" => "_parent", "_self" => "_self")
);


$of_options[] = array(
    'id' => 'size',
    'type' => 'range',
    'name' => 'Size',
    'desc' => 'Set size of icons.',
    'std' => '32',
    'min' => '10',
    'max' => '100',
    'step' => '1',
    'unit' => ''
);

$of_options[] = $jaw_builder_options['show_on_devices'];

$of_options[] = array(
    'id' => 'class',
    'type' => 'text',
    "hide_if_layout" => array('shortcodes'),
    'name' => '<i class="jaw-icon-code"></i> Custom Class',
    'desc' => 'Insert your custom class for this element.',
    'std' => ''
);

$of_options[] = array(
    'id' => 'el_id',
    "hide_if_layout" => array('shortcodes'),
    'type' => 'text',
    'name' => '<i class="jaw-icon-code"></i> Custom ID',
    'desc' => 'Insert your custom ID for this element.',
    'std' => ''
);

$of_options[] = array(
    "type" => "sectionend");
    

 /* ==== BAR ==== */
$of_options[] = array(
    "name" => "Bar",
    "hide_if_layout" => array('shortcodes'),
    "type" => "sectionstart");

 
// Typ baru se prejima z globalni promenne definovane v metabox-builder.php
$of_options[] = $jaw_builder_options['global_bar_type'];  $of_options[] = $jaw_builder_options['global_bar_h'];
$of_options[] = $jaw_builder_options['global_custom_link'];

$of_options[] = array(
    "hide_if_layout" => array('shortcodes'),
    "type" => "sectionend");
 
 
 /* Settings */

$jaw_builder_options['social_icons'] = $of_options;