<?php

global $jaw_builder_options;

$of_options = array();

/* ==== CONTENT ==== */
$of_options[] = array(
    "name" => "Content",
    "type" => "sectionstart"
);

$of_options[] = array(
    "name" => "Sidebar",
    "desc" => 'Choose a sidebar from the list of your custom ones.',
    "id" => "build_sidebar",
    "type" => "sidebar_select",
    'mod' => 'medium',
);

$of_options[] = array(
    'id' => 'sidebars',
    'type' => 'sidebars',
    'name' => 'Sidebar Manager',
    'desc' => 'Here you can add or remove your optional sidebars. To add new sidebar, fill in the field with a name you want and click the Add New Sidebar button.',
    'std' => null
);

$of_options[] = array(
    "type" => "sectionend"
);


/* ==== Design ==== */
$of_options[] = array(
    "name" => "Design",
    "type" => "sectionstart");


$of_options[] = array(
    "name" => "Color preset",
    "desc" => "",
    "id" => "sidebar_color",
    "std" => "_default",
    'type' => 'select_preset',
    "target" => "color"
);


$of_options[] = array(
    'id' => 'bar_type_widgets',
    'type' => 'layout',
    'name' => 'Bar Type of Widgets',
    'desc' => 'Select this element&acute;s header type.',
    'std' => '_default',
    
    "options" => $jaw_builder_options['global_design_type']
);

$of_options[] = array(
    'id' => 'fixed',
    'type' => 'toggle',
    'name' => 'Fixed Inline Sidebar when Scrolling',
    'desc' => '',
    'std' => 'off',
    "options" => array(
        'off' => 'Off',
        'on' => 'On'
    )
);

$of_options[] = $jaw_builder_options['space_after'];

$of_options[] = $jaw_builder_options['show_on_devices'];

$of_options[] = array(
    'id' => 'class',
    'type' => 'text',
    "hide_if_layout" => array('shortcodes'),
    'name' => '<i class="jaw-icon-code"></i> Custom Class',
    'desc' => 'Insert your custom class for this element.',
    'std' => ''
);

$of_options[] = array(
    'id' => 'el_id',
    "hide_if_layout" => array('shortcodes'),
    'type' => 'text',
    'name' => '<i class="jaw-icon-code"></i> Custom ID',
    'desc' => 'Insert your custom ID for this element.',
    'std' => ''
);

$of_options[] = array(
    "type" => "sectionend"
);

/* ==== BAR ==== */
$of_options[] = array(
    "name" => "Bar",
    "hide_if_layout" => array('shortcodes'),
    "type" => "sectionstart");

// Typ baru se prejima z globalni promenne definovane v metabox-builder.php
$of_options[] = $jaw_builder_options['global_bar_type'];
$of_options[] = $jaw_builder_options['global_custom_link'];

$of_options[] = array(
    "hide_if_layout" => array('shortcodes'),
    "type" => "sectionend");



/* Settings */
$jaw_builder_options['page_sidebar'] = $of_options;
