<?php

global $jaw_builder_options;

$of_options = array();


/* ==== CONTENT ==== */
$of_options[] = array(
    "name" => "Content",
    "type" => "sectionstart");

$of_options[] = array(
    "name" => "Image",
    "desc" => "Choose the image you need or remove it clicking the Remove button. ",
    "id" => "image",
    "type" => "simple_media_picker",
    'std' => '',
    'mod' => 'image',
    'multiple' => false
);


$of_options[] = array(
    'id' => 'lightbox',
    'type' => 'toggle',
    'name' => 'Lightbox',
    'desc' => 'Decide whether or not to open the image using lightbox.',
    'std' => '0',
);


$of_options[] = array(
    "name" => "Target Link",
    "desc" => "Insert a target URL of your image.<br><br><strong>Works only when the lightbox is disabled</strong>.",
    "id" => "link",
    "std" => "",
    "type" => "text"
);

$of_options[] = array(
    'id' => 'target',
    'type' => 'select',
    'name' => 'Link Target',
    'desc' => 'Specify where to open the image.<br><br><strong>Works only when the lightbox is disabled</strong>.',
    'std' => '_self',
    'mod' => 'medium',
    
    "options" => array("_blank" => "_blank", "_top" => "_top", "_parent" => "_parent", "_self" => "_self")
);

$of_options[] = array(
    "type" => "sectionend");


/* ==== Hover ==== */
$of_options[] = array(
    "name" => "Hover",
    "type" => "sectionstart");

$of_options[] = array(
    "name" => "Hover Image URL",
    "desc" => "Choose the image you want to appear when mouse is moved over the main one.",
    "id" => "hover_image",
    "type" => "simple_media_picker",
    'std' => ''
);

$of_options[] = array(
    "type" => "sectionend");


/* ==== DESIGN ==== */
$of_options[] = array(
    "name" => "Design",
    "hide_if_layout" => array('shortcodes'),
    "type" => "sectionstart");

$of_options[] = $jaw_builder_options['show_on_devices'];

$of_options[] = array(
    'id' => 'class',
    'type' => 'text',
    "hide_if_layout" => array('shortcodes'),
    'name' => '<i class="jaw-icon-code"></i> Custom Class',
    'desc' => 'Insert your custom class for this element.',
    'std' => ''
);

$of_options[] = array(
    'id' => 'el_id',
    "hide_if_layout" => array('shortcodes'),
    'type' => 'text',
    'name' => '<i class="jaw-icon-code"></i> Custom ID',
    'desc' => 'Insert your custom ID for this element.',
    'std' => ''
);

$of_options[] = array(
    "hide_if_layout" => array('shortcodes'),
    "type" => "sectionend");



/* ==== BAR ==== */
$of_options[] = array(
    "name" => "Bar",
    "hide_if_layout" => array('shortcodes'),
    "type" => "sectionstart"
);

// Typ baru se prejima z globalni promenne definovane v metabox-builder.php
$of_options[] = $jaw_builder_options['global_bar_type'];  $of_options[] = $jaw_builder_options['global_bar_h'];
$of_options[] = $jaw_builder_options['global_custom_link'];

$of_options[] = array(
    "hide_if_layout" => array('shortcodes'),
    "type" => "sectionend"
);

/* Settings */
$jaw_builder_options['image'] = $of_options;
