<?php

global $jaw_builder_options;
 
$of_options = array();

/* ==== CONTENT ==== */
$of_options[] = array(
    "name" => "Content",
    "desc" => "Insert HTML code of your carousel&acute;s item.",
    "type" => "sectionstart");

$of_options[] = array(
    "name" => "HTML Content",
    "desc" => "Click the <strong>[ + ]</strong> button to add new item to your carousel. The trash button removes the item.",
    "id" => "content",
    "std" => "",
    "mod" => "textarea",
    "type" => "list"
);

$of_options[] = array(
    'id' => 'items_in_slide',
    'type' => 'select',
    'name' => 'Number of Items in One Slide',
    'desc' => 'Set number of Items to be shown in one slide.',
    'std' => '1',
    'mod' => 'medium',
    'options' => array(
        "1" => "1",
        "2" => "2",
        "3" => "3",
        "4" => "4",
        "6" => "6"
    )
);

$of_options[] = array(
    "type" => "sectionend");


/* ==== DESIGN ==== */
$of_options[] = array(
    "name" => "Design",
    "type" => "sectionstart");

$of_options[] = array(
    'id' => 'automatic_slide',
    'type' => 'toggle',
    'name' => 'Automatic Sliding',
    'desc' => 'Decide whether or not to allow moving a content of your carousel automatically.',
    'std' => '0',
    
    "options" => array("1" => "On", "0" => "Off")
);

$of_options[] = array("name" => "Interval between slides",
    "desc" => "in ms",
    "id" => "slider_interval",
    "std" => 5000,
    "type" => "text"
);

$of_options[] = $jaw_builder_options['show_on_devices'];

$of_options[] = array(
    'id' => 'class',
    'type' => 'text',
    "hide_if_layout" => array('shortcodes'),
    'name' => '<i class="jaw-icon-code"></i> Custom Class',
    'desc' => 'Insert your custom class for this element.',
    'std' => ''
);

$of_options[] = array(
    'id' => 'el_id',
    "hide_if_layout" => array('shortcodes'),
    'type' => 'text',
    'name' => '<i class="jaw-icon-code"></i> Custom ID',
    'desc' => 'Insert your custom ID for this element.',
    'std' => ''
);

$of_options[] = array(
    "type" => "sectionend");



/* ==== BAR ==== */
$of_options[] = array(
    "name" => "Bar",
    "hide_if_layout" => array('shortcodes'),
    "type" => "sectionstart");


// Typ baru se prejima z globalni promenne definovane v metabox-builder.php
$of_options[] = $jaw_builder_options['global_bar_type'];  $of_options[] = $jaw_builder_options['global_bar_h'];
$of_options[] = $jaw_builder_options['global_custom_link'];

$of_options[] = array(
    "hide_if_layout" => array('shortcodes'),
    "type" => "sectionend");

/* Settings */
$jaw_builder_options['html_carousel'] = $of_options; 