<?php

global $jaw_builder_options;
 
$of_options = array();


/* ==== Content ==== */
$of_options[] = array(
    "name" => "Content",    
    "type" => "sectionstart");


$of_options[] = array(
    "name" => "How to Use Fonts",
    "id" => "fonts-info",
    "text" => "<h3>Google Fonts</h3><a href='http://www.google.com/webfonts'>List of all available fonts you can find here</a><br><i class='jaw-icon-warning'></i>Using many font styles can slow down your webpage.<br>",
    "type" => "info",
    "space" => false,
    "message" => "info"
);


$of_options[] = array(
    "name" => "Content",
    "desc" => "Insert a content to be shown using the Google font specified in the Design tab.",
    "id" => "content",
    "std" => "",
    "type" => "textarea"
);

$of_options[] = array(
    "type" => "sectionend");



/* ==== DESIGN ==== */
$of_options[] = array(
    "name" => "Design",
    "type" => "sectionstart");


$of_options[] = array(
    'id' => 'font_family',
    'type' => 'text',
    'name' => 'Font Family',
    'desc' => "Insert the Google font family you need. To get a complete list of fonts visit <a href='http://www.google.com/webfonts' target='_blank'>this Google page</a>.",
    'std' => ''
);

$of_options[] = array(
    'id' => 'font_size',
    'type' => 'range',
    'name' => 'Font Size',
    'desc' => 'Set font size in pixels.',
    'std' => '18',
    'min' => '1',
    'max' => '50',
    'step' => '1',
    'unit' => 'px'
);

$of_options[] = array(
    "name" => "Font Color",
    "desc" => "Pick a text color (by default: #000000).",
    "id" => "color",
    "std" => "#000000",
    "type" => "color"
);

$of_options[] = $jaw_builder_options['show_on_devices'];

$of_options[] = array(
    'id' => 'class',
    'type' => 'text',
    "hide_if_layout" => array('shortcodes'),
    'name' => '<i class="jaw-icon-code"></i> Custom Class',
    'desc' => 'Insert your custom class for this element.',
    'std' => ''
);

$of_options[] = array(
    'id' => 'el_id',
    "hide_if_layout" => array('shortcodes'),
    'type' => 'text',
    'name' => '<i class="jaw-icon-code"></i> Custom ID',
    'desc' => 'Insert your custom ID for this element.',
    'std' => ''
);

$of_options[] = array(
    "type" => "sectionend");

/* ==== BAR ==== */
$of_options[] = array(
    "name" => "Bar",
    "hide_if_layout" => array('shortcodes'),
    "type" => "sectionstart");

 
// Typ baru se prejima z globalni promenne definovane v metabox-builder.php
$of_options[] = $jaw_builder_options['global_bar_type'];  $of_options[] = $jaw_builder_options['global_bar_h'];
$of_options[] = $jaw_builder_options['global_custom_link'];

$of_options[] = array(
    "hide_if_layout" => array('shortcodes'),
    "type" => "sectionend");

 
 /* Settings */
$jaw_builder_options['googlefonts'] = $of_options; 