<?php

global $jaw_builder_options;
 
$of_options = array();


/* ==== CONTENT ==== */
$of_options[] = array(
    "name" => "Content",
    "type" => "sectionstart");


$of_options[] = array(
    "name" => '<i class="jaw-icon-location"></i> Address',
    "id" => "g_address",
    "std" => "",
    "desc" => "Enter an location address and click the button to convert it to its GPS coordinates. e.g. 'San Francisco Transamerica Pyramid'",
    "type" => "google_address"
);  
    
$of_options[] = array(
    "name" => '<i class="jaw-icon-arrow4 "></i> Latitude',
    "id" => "latitude",
    "std" => "",
    "desc" => "Enter a latitude value in decimal number (if the Address field above is empty).",
    "type" => "text"
);

$of_options[] = array(
    "name" => '<i class="jaw-icon-arrow3"></i> Longitude',
    "id" => "longitude",
    "std" => "",
    "desc" => "Enter a longitude value in decimal number (if the Address field above is empty).",
    "type" => "text"
); 

$of_options[] = array(
    'id' => 'marker',
    'type' => 'toggle',
    'name' => '<i class="jaw-icon-location"></i> Map Marker',
    'desc' => 'Decide whether or not to show marker on the map.',
    "std" => "0",
);

$of_options[] = array(
    "name" => '<i class="jaw-icon-file-xml "></i> Marker Description',
    "desc" => "Enter your marker description via HTML code.",
    "id" => "description",
    "std" => "",
    "type" => "textarea"
);
$of_options[] = array(
    'id' => 'description_open',
    'type' => 'toggle',
    'name' => '<i class="jaw-icon-info  "></i> Marker Description Opened',
    "desc" => "Decide when the marker description has to be opened.",
    "std" => "start",
    "options" => array("click"=>"After click", "start" => "On start")
);

$of_options[] = array(
    'id' => 'zoom',
    'type' => 'range',
    'name' => '<i class="jaw-icon-search3 "></i> Zoom',
    'desc' => 'Select a zoom level for the map.',
    'std' => '1',
    'value' => "1",
    'min' => '1',
    'max' => '19',
    'step' => '1',
    'unit' => ''
);

$of_options[] = array(
    'id' => 'controls',
    'type' => 'toggle',
    'name' => '<i class="jaw-icon-scale-down "></i> Map Controls',
    "desc" => "Decide whether or not to make the map control tools available.",
    "std" => "1",
);

$of_options[] = array(
    'id' => 'disabledoubleclickzoom',
    'type' => 'toggle',
    'name' => '<i class="jaw-icon-mouse3 "></i>  Disable Doubleclick Zoom',
    "desc" => "Turn this option on to disable doubleclick zoom feature.",
    "std" => "1",
);

$of_options[] = array(
    'id' => 'scrollwheel',
    'type' => 'toggle',
    'name' => '<i class="jaw-icon-mouse2 "></i>  Enable Scrool Wheel',
    "desc" => "Turn this option on to enable using of a mouse scroll wheel on the map.",
    "std" => "0",
);

$of_options[] = array(
    'id' => 'dragable',
    'type' => 'toggle',
    'name' => '<i class="jaw-icon-expand "></i> Panning Map',
    'desc' => 'Decide whether or not to allow panning the map using mouse (drag & drop).',
    "std" => "1",
);

$of_options[] = array(
    "name" => '<i class="jaw-icon-map"></i> Map Type',
    "id" => "maptype",
    "std" => "ROADMAP",
    "desc" => "Select the map type you prefer.",
    "type" => "select",
    
    "options" => array(
        "" => "Choose",
        "ROADMAP" => "Road Map",
        "SATELLITE" => "Google Earth Map",
        "HYBRID" => "Mixture of normal and satellite",
        "TERRAIN" => "Physical Map"
    )
);

$of_options[] = array(
    "type" => "sectionend");
    
/* ==== Markers ==== */
$of_options[] = array(
    "name" => "Markers",
    "type" => "sectionstart");

$of_options[] = array(
    "name" => '<i class="jaw-icon-arrow3"></i> Markers',
    "id" => "markers",
    "std" => "",
    "type" => "map_markers"
); 

$of_options[] = array(
    "type" => "sectionend");

/* ==== Waypoints ==== */
$of_options[] = array(
"name" => "Waypoints",
"type" => "sectionstart");

$of_options[] = array(
    'id' => 'waypoint',
    'type' => 'toggle',
    'name' => '<i class="jaw-icon-location"></i> Waypoint',
    'desc' => 'Decide whether or not to show your highlight road.',
    "std" => "0",
);

// Origins and Destination
$of_options[] = array(
    "name" => '<i class="jaw-icon-arrow4 "></i> Origins Latitude',
    "id" => "latitude_origins",
    "std" => "",
    "desc" => "Enter a latitude value in decimal number (if the Address field above is empty).",
    "type" => "text"
);
$of_options[] = array(
    "name" => '<i class="jaw-icon-arrow3"></i> Origins Longitude',
    "id" => "longitude_origins",
    "std" => "",
    "desc" => "Enter a longitude value in decimal number (if the Address field above is empty).",
    "type" => "text"
); 
$of_options[] = array(
    "name" => '<i class="jaw-icon-arrow4 "></i> Destination Latitude',
    "id" => "latitude_destination",
    "std" => "",
    "desc" => "Enter a latitude value in decimal number (if the Address field above is empty).",
    "type" => "text"
);
$of_options[] = array(
    "name" => '<i class="jaw-icon-arrow3"></i> Destination Longitude',
    "id" => "longitude_destination",
    "std" => "",
    "desc" => "Enter a longitude value in decimal number (if the Address field above is empty).",
    "type" => "text"
); 
  
$of_options[] = array(
    "name" => '<i class="jaw-icon-map"></i> Mode of Travel',
    "id" => "maptypetravel",
    "std" => "DRIVING",
    "desc" => "Select the map type you prefer.",
    "type" => "select",
    
    "options" => array(
        "" => "Choose",
        "DRIVING" => "Driving",
        "WALKING" => "Walking",
        "BICYCLING" => "Bicycling",
        "TRANSIT" => "Transit"
    )
);
  
// Waypoints
$of_options[] = array(
    "name" => '<i class="jaw-icon-arrow3"></i> Waypoints',
    "id" => "waypoints",
    "std" => "",
    "type" => "map_waypoint"
); 
    
$of_options[] = array(
"type" => "sectionend");


/* ==== DESIGN ==== */
$of_options[] = array(
    "name" => "Design",
    "type" => "sectionstart");

$of_options[] = array(
    'id' => 'height',
    'type' => 'range',
    'name' => 'Height',
    'desc' => 'Set height of your map.',
    'std' => '600',
    'value' => "10",
    'min' => '0',
    'max' => '960',
    'step' => '1',
    'unit' => 'px'
);
 
$of_options[] = $jaw_builder_options['show_on_devices'];

$of_options[] = array(
    'id' => 'class',
    'type' => 'text',
    "hide_if_layout" => array('shortcodes'),
    'name' => '<i class="jaw-icon-code"></i> Custom Class',
    'desc' => 'Insert your custom class for this element.',
    'std' => ''
);

$of_options[] = array(
    'id' => 'el_id',
    "hide_if_layout" => array('shortcodes'),
    'type' => 'text',
    'name' => '<i class="jaw-icon-code"></i> Custom ID',
    'desc' => 'Insert your custom ID for this element.',
    'std' => ''
);

$of_options[] = array(
    "type" => "sectionend");




/* ==== BAR ==== */
$of_options[] = array(
    "name" => "Bar",
    "hide_if_layout" => array('shortcodes'),
    "type" => "sectionstart");

 
// Typ baru se prejima z globalni promenne definovane v metabox-builder.php
$of_options[] = $jaw_builder_options['global_bar_type'];  $of_options[] = $jaw_builder_options['global_bar_h'];
$of_options[] = $jaw_builder_options['global_custom_link'];

$of_options[] = array(
    "hide_if_layout" => array('shortcodes'),
    "type" => "sectionend");
 
 /* Settings */
$jaw_builder_options['google_map'] = $of_options; 