<?php

global $jaw_builder_options;

$of_options = array();

$sliders = array();
if (class_exists('Essential_Grid')) {
    $grids = Essential_Grid::get_essential_grids();

    if (!empty($grids) && is_array($grids)) {
        foreach ($grids as $grid) {
            $sliders[$grid->handle] = $grid->name;
        }
    }
}

/* ==== CONTENT ==== */
$of_options[] = array(
    "name" => "Content",
    "type" => "sectionstart");

$of_options[] = array(
    'id' => 'alias',
    'type' => 'select',
    'name' => 'Grid',
    'desc' => 'Select one from the grid you have created in the Essential Grid settings.',
    'std' => '',
    'mod' => 'medium',
    
    'options' => $sliders
);

$of_options[] = array(
    "type" => "sectionend");


/* ==== DESIGN ==== */
$of_options[] = array(
    "name" => "Design",
    "type" => "sectionstart");



$of_options[] = $jaw_builder_options['show_on_devices'];

$of_options[] = array(
    'id' => 'class',
    'type' => 'text',
    "hide_if_layout" => array('shortcodes'),
    'name' => '<i class="jaw-icon-code"></i> Custom Class',
    'desc' => 'Insert your custom class for this element.',
    'std' => ''
);

$of_options[] = array(
    'id' => 'el_id',
    "hide_if_layout" => array('shortcodes'),
    'type' => 'text',
    'name' => '<i class="jaw-icon-code"></i> Custom ID',
    'desc' => 'Insert your custom ID for this element.',
    'std' => ''
);

$of_options[] = array(
    "type" => "sectionend");


/* ==== BAR ==== */
$of_options[] = array(
    "name" => "Bar",
    "hide_if_layout" => array('shortcodes'),
    "type" => "sectionstart");

// Typ baru se prejima z globalni promenne definovane v metabox-builder.php
$of_options[] = $jaw_builder_options['global_bar_type'];  $of_options[] = $jaw_builder_options['global_bar_h'];
$of_options[] = $jaw_builder_options['global_custom_link'];

$of_options[] = array(
    "hide_if_layout" => array('shortcodes'),
    "type" => "sectionend");

/* Settings */
global $jaw_builder_options;
$jaw_builder_options['essential_grid'] = $of_options;
