<?php

global $jaw_builder_options;

$of_options = array();



/* ==== To top ==== */
$of_options[] = array(
    "name" => "To Top",
    "type" => "sectionstart");

$of_options[] = array(
    "name" => "Back To Top Link",
    "desc" => "Decide whether or not to show the Back To Top Link above the divider.",
    "id" => "divider_totop",
    "std" => "0",
    "type" => "toggle",
    "options" => array("1" => "On", "0" => "Off")
);

$of_options[] = array(
    "name" => "Back To Top Text",
    "desc" => "Text of the &acute;Back To Top&acute; link (by default: Back To Top).",
    "id" => "divider_title",
    "ng-show" => "edit['divider_totop']=='1'",
    "std" => "Back To Top",
    "type" => "text"
);

$of_options[] = array(
    "name" => "Back To Top Text Align",
    "desc" => "Choose an alignment of the link.",
    "id" => "totop_align",
    "std" => "right",
    "type" => "toggle",
    "ng-show" => "edit['divider_totop']=='1'",
    "options" => array("left" => "Left", "right" => "Right")
);

$of_options[] = array(
    "type" => "sectionend");

/* ==== DESIGN ==== */
$of_options[] = array(
    "name" => "Design",
    "hide_if_layout" => array('shortcodes'),
    "type" => "sectionstart"
);

$of_options[] = $jaw_builder_options['show_on_devices'];

$of_options[] = array(
    'id' => 'class',
    'type' => 'text',
    "hide_if_layout" => array('shortcodes'),
    'name' => '<i class="jaw-icon-code"></i> Custom Class',
    'desc' => 'Insert your custom class for this element.',
    'std' => ''
);

$of_options[] = array(
    'id' => 'el_id',
    "hide_if_layout" => array('shortcodes'),
    'type' => 'text',
    'name' => '<i class="jaw-icon-code"></i> Custom ID',
    'desc' => 'Insert your custom ID for this element.',
    'std' => ''
);

$of_options[] = array(
    "hide_if_layout" => array('shortcodes'),
    "type" => "sectionend");

$of_options[] = array(
    "name" => "Styling",
    "type" => "sectionstart");



$of_options[] = array(
    'id' => 'divider_style',
    'type' => 'select',
    'name' => 'Line Style',
    'desc' => 'Choose the line style.',
    'std' => 'solid',
    'mod' => 'medium',
    
    'options' => array("solid" => "Solid", "dotted" => "Dotted", "dashed" => "Dashed", "none" => "none"),
);



$of_options[] = array(
    "name" => "Divider Line Color",
    "desc" => "Pick a color of the divider line (by default: #000000).",
    "id" => "color",
    "std" => "#000000",
    "type" => "color"
);

$of_options[] = array(
    'id' => 'width',
    'type' => 'range',
    'name' => 'Divider Thickness',
    'desc' => 'Set thickness of the divider.',
    'std' => '1',
    'min' => '1',
    'max' => '5',
    'step' => '1',
    'unit' => 'px'
);

$of_options[] = array(
    "name" => "Additional Space Before",
    "desc" => "Set size of the space before your divider.",
    "id" => "space_size",
    'std' => '0',
    'min' => '0',
    'max' => '100',
    'step' => '1',
    'unit' => 'px',
    'type' => 'range',
);

$of_options[] = array(
    "name" => "Additional Space After",
    "desc" => "Set size of the space after your divider.",
    "id" => "space_after_size",
    'std' => '0',
    'min' => '0',
    'max' => '100',
    'step' => '1',
    'unit' => 'px',
    'type' => 'range',
);

$of_options[] = $jaw_builder_options['space_after'];


$of_options[] = array(
    "type" => "sectionend"
);

/* Settings */
$jaw_builder_options['divider'] = $of_options;
