<?php

global $jaw_builder_options;
 
$of_options = array();

/* ==== CONTENT ==== */
$of_options[] = array(
    "name" => "Content",
    "type" => "sectionstart");


$of_options[] = array(
    "name" => "Description Text",
    "desc" => "Create your description for the Call To Action element.",
    "id" => "text_content",
    "std" => "",
    "type" => "tinymce_editor"
);



$of_options[] = array(
    "name" => "Button Label",
    "desc" => "Fill in the button label.",
    "id" => "button_text",
    "std" => "Button",
    "type" => "text"
);


$of_options[] = array(
    "name" => "Target Link",
    "desc" => "Insert a target URL for your button/icon.",
    "id" => "link",
    "std" => "#",
    "type" => "text"
);

$of_options[] = array(
    'id' => 'target',
    'type' => 'select',
    'name' => 'Link Target',
    'desc' => 'Specify where to open a target link.',
    'std' => '_self',
    'mod' => 'medium',
    
    "options" => array("_blank" => "_blank", "_top" => "_top", "_parent" => "_parent", "_self" => "_self")
);

$of_options[] = array(
    'id' => 'cta_button_possition',
    'name' => 'Button Placement',
    'desc' => 'Select a placement of a button (icon).',
    'std' => 'right',  
    'type' => 'layout',
    
    'options' => array(
        'top' => JAW_ADMIN_URI . 'assets/images/calltoa-top.png',
        'left' => JAW_ADMIN_URI . 'assets/images/calltoa-left.png',
        'bottom' => JAW_ADMIN_URI . 'assets/images/calltoa-bottom.png',
        'right' => JAW_ADMIN_URI . 'assets/images/calltoa-right.png'
    )
);

$of_options[] = array(
    "type" => "sectionend");


/* ==== DESIGN ==== */
$of_options[] = array(
    "name" => "Design",
    "type" => "sectionstart");


$of_options[] = array(
    "name" => "Background Color",
    "desc" => "Pick a color of the description&acute;s background around the button/icon.",
    "id" => "color",
    "std" => "#434343",
    "type" => "color"
);

$of_options[] = array(
    "name" => "Text Color",
    "desc" => "",
    "id" => "text_color",
    "std" => "#ffffff",
    "type" => "color"
);

$of_options[] = $jaw_builder_options['show_on_devices'];

$of_options[] = array(
    'id' => 'class',
    'type' => 'text',
    "hide_if_layout" => array('shortcodes'),
    'name' => '<i class="jaw-icon-code"></i> Custom Class',
    'desc' => 'Insert your custom class for this element.',
    'std' => ''
);

$of_options[] = array(
    'id' => 'el_id',
    "hide_if_layout" => array('shortcodes'),
    'type' => 'text',
    'name' => '<i class="jaw-icon-code"></i> Custom ID',
    'desc' => 'Insert your custom ID for this element.',
    'std' => ''
);

$of_options[] = array(
    "type" => "sectionend");

/* ==== Button DESIGN ==== */
$of_options[] = array(
    "name" => "Button Design",
    "type" => "sectionstart");


$of_options[] = array(
    'id' => 'cta_button_size',
    'type' => 'toggle',
    'name' => 'Button Size',
    'desc' => 'Select a button size.',
    'std' => 'btn',
    'mod' => 'medium',
    
    "options" => array("btn-xs" => "Extra small", "btn-sm" => "Small", "btn" => "Default", "btn-lg" => "Large")
);

$of_options[] = array(
    'id' => 'cta_button_bg_color',
    'type' => 'color',
    'name' => 'Button Background Color',
    'desc' => 'Pick a background color for the button (by default: #EFEFEF).',
    'std' => '#009de0',
    
);


$of_options[] = array(
    'id' => 'cta_button_font_color',
    'type' => 'color',
    'name' => 'Custom Button Font Color',
    'desc' => 'Pick a color of the button label text (by default: #5E605F).',
    'std' => '#ffffff',
    
);

$of_options[] = array(
    "type" => "sectionend");


/* ==== BAR ==== */
$of_options[] = array(
    "name" => "Bar",
    "hide_if_layout" => array('shortcodes'),
    "type" => "sectionstart");

// Typ baru se prejima z globalni promenne definovane v metabox-builder.php
$of_options[] = $jaw_builder_options['global_bar_type'];  $of_options[] = $jaw_builder_options['global_bar_h'];$of_options[] = $jaw_builder_options['global_custom_link'];

$of_options[] = array(
    "hide_if_layout" => array('shortcodes'),
    "type" => "sectionend");

 /* Settings */
$jaw_builder_options['cta'] = $of_options; 