<?php

global $jaw_builder_options;

$of_options = array();

/* ==== Main ==== */
$of_options[] = array(
    "name" => "Main",
    "type" => "sectionstart");


$of_options[] = array(
    'id' => 'preset_color',
    'name' => '<i class="jaw-icon-palette jaw-preset-icon"></i> Color preset',
    'desc' => '',
    'type' => 'select_preset',
    "target" => "color"
);

$of_options[] = array(
    'id' => 'fullwidth',
    'type' => 'layout',
    'name' => 'Width',
    'desc' => '',
    'std' => 'off',
    'class' => 'fullwidth-option',
    'options' => array(
        'off' => JAW_ADMIN_URI . 'assets/images/fullwidth/fullwidth-off.png',
        'boxed' => JAW_ADMIN_URI . 'assets/images/fullwidth/fullwidth-boxed.png',
        'boxed_color' => JAW_ADMIN_URI . 'assets/images/fullwidth/fullwidth-boxed_color.png',
        'fw_color' => JAW_ADMIN_URI . 'assets/images/fullwidth/fullwidth-background.png',
        'fw_content' => JAW_ADMIN_URI . 'assets/images/fullwidth/fullwidth-content.png',
        'fw_edge' => JAW_ADMIN_URI . 'assets/images/fullwidth/fullwidth-edge.png'
    )
);

$of_options[] = array(
    "type" => "sectionend");



/* ==== Background ==== */
$of_options[] = array(
    "name" => "Background",
    "type" => "sectionstart");


$of_options[] = array(
    "name" => "Container Background info",
    "id" => "bg-info",
    "text" => 'If you want to use self hosted video, please upload MP4',
    "type" => "info",
    "space" => false,
    "message" => "description"
);

$of_options[] = array(
    "name" => "Background Image",
    "desc" => "Choose the image you need or remove it clicking the Remove button. ",
    "id" => "bg_image",
    "type" => "simple_media_picker",
    'std' => '',
    'mod' => 'image',
    'multiple' => false
);


$of_options[] = array(
    "name" => "Video MP4",
    "desc" => "Choose a background video in MP4 format.",
    "id" => "bg_video_mp4",
    "type" => "simple_media_picker",
    'std' => ''
);

$of_options[] = array(
    'id' => 'bg_video_url',
    'type' => 'text',
    'name' => 'Video YouTube URL',
    'desc' => '',
    'std' => '',
);


$of_options[] = array(
    'id' => 'bg_pattern',
    'type' => 'toggle',
    'name' => 'Use Pattern',
    'desc' => 'Decide whether or not to use pattern. To set the pattern, navigate to the Theme Options.',
    'std' => 'no-pattern',
    'options' => array('no-pattern' => 'Off', 'pattern' => 'Dark Pattern', 'white-pattern' => 'Bright Pattern')
);

$of_options[] = array(
    'id' => 'bg_paralax',
    'type' => 'toggle',
    'name' => 'Paralax',
    'desc' => 'Choose the kind you prefer.',
    'std' => 'dynamic',
    "options" => array("none" => "None", "static" => "Static", "dynamic" => "Dynamic")
);



$of_options[] = array(
    "type" => "sectionend");


/* ==== BAR ==== */
$of_options[] = array(
    "name" => "Animation",
    "type" => "sectionstart");

$of_options[] = array(
    'id' => 'animation',
    'type' => 'toggle',
    'name' => 'Animation'. " " . jwUtils::getHelp("", "Animation of Container, can be used for presentation part of web.", "animate-container.gif"),
    'desc' => '',
    'std' => 'none',
    'class' => 'fullwidth-option',
    "options" => array("none" => "None", "fadeInLeft" => "FadeIn Left", "fadeInRight" => "FadeIn Right", "fadeInTop" => "FadeIn Top", "fadeInBottom" => "FadeIn Bottom", "fadeIn" => "FadeIn")
);

$of_options[] = array(
    "type" => "sectionend");
    

/* ==== DESIGN ==== */
$of_options[] = array(
    "name" => "Design",
    "type" => "sectionstart");


$of_options[] = $jaw_builder_options['show_on_devices'];

$of_options[] = array(
    'id' => 'class',
    'type' => 'text',
    "hide_if_layout" => array('shortcodes'),
    'name' => '<i class="jaw-icon-code"></i> Custom Class',
    'desc' => 'Insert your custom class for this element.',
    'std' => ''
);

$of_options[] = array(
    'id' => 'el_id',
    "hide_if_layout" => array('shortcodes'),
    'type' => 'text',
    'name' => '<i class="jaw-icon-code"></i> Custom ID',
    'desc' => 'Insert your custom ID for this element.',
    'std' => ''
);

$of_options[] = array(
    'id' => 'padding_top',
    'type' => 'text',
    'name' => 'Additional Top Space (inside container box)',
    'desc' => 'Set the padding value in pixels',
    'std' => '0',
);


$of_options[] = array(
    'id' => 'padding_bottom',
    'type' => 'text',
    'name' => 'Additional Bottom Space (inside container box)',
    'desc' => 'Set the padding value in pixels',
    'std' => '0',
);


$of_options[] = array(
    'id' => 'padding_left',
    'type' => 'text',
    'name' => 'Additional Left Space (inside container box)',
    'desc' => 'Set the padding value in pixels',
    'std' => '0',
);


$of_options[] = array(
    'id' => 'padding_right',
    'type' => 'text',
    'name' => 'Additional Right Space (inside container box)',
    'desc' => 'Set the padding value in pixels',
    'std' => '0',
);



$of_options[] = $jaw_builder_options['space_after'];


$of_options[] = array(
    "type" => "sectionend");
    
/* ==== BAR ==== */
$of_options[] = array(
    "name" => "Bar",
    "hide_if_layout" => array('shortcodes'),
    "type" => "sectionstart");

// Typ baru se prejima z globalni promenne definovane v metabox-builder.php
$of_options[] = $jaw_builder_options['global_bar_type'];
$of_options[] = $jaw_builder_options['global_custom_link'];

$of_options[] = array(
    "hide_if_layout" => array('shortcodes'),
    "type" => "sectionend");


/* Settings */
$jaw_builder_options['container'] = $of_options;
