<?php

global $jaw_builder_options;

$of_options = array();

/* ==== CONTENT ==== */
$of_options[] = array(
    "name" => "Content",
    "type" => "sectionstart");

$of_options[] = array(
    "name" => "Label",
    "desc" => "Fill in the button label.",
    "id" => "label",
    "std" => "Button",
    "type" => "text"
);

$of_options[] = array(
    "name" => "Target Link",
    "desc" => "Insert a target URL for your button.",
    "id" => "link",
    "std" => "#",
    "type" => "text"
);

$of_options[] = array(
    'id' => 'target',
    'type' => 'select',
    'name' => 'Link Target',
    'desc' => 'Specify where to open a target link.',
    'std' => '_self',
    'mod' => 'medium',
    
    "options" => array("_blank" => "_blank", "_top" => "_top", "_parent" => "_parent", "_self" => "_self")
);

$of_options[] = array(
    "type" => "sectionend");

/* ==== DESIGN ==== */
$of_options[] = array(
    "name" => "Design",
    "type" => "sectionstart");

$of_options[] = array(
    'id' => 'button_size',
    'type' => 'toggle',
    'name' => 'Button Size',
    'desc' => 'Select the button size you prefer.',
    'std' => 'default',
    'mod' => 'medium',
    
    "options" => array("btn-xs" => "Extra Small", "btn-sm" => "Small", "default" => "Default", "btn-lg" => "Large")
);

$of_options[] = array(
    'id' => 'align',//button_width
    'type' => 'layout',
    'name' => 'Align',
    'desc' => '',
    'std' => 'none',
    'class' => 'fullwidth-option',
    "options" => array(
        "none" => JAW_ADMIN_URI . 'assets/images/button/button-align-none.png',
        "center" => JAW_ADMIN_URI . 'assets/images/button/button-align-center.png',
        "left" => JAW_ADMIN_URI . 'assets/images/button/button-align-left.png',
        "right" => JAW_ADMIN_URI . 'assets/images/button/button-align-right.png',
        "fullwidth" => JAW_ADMIN_URI . 'assets/images/button/button-align-full.png',
    ),
);

$of_options[] = array(
    'id' => 'button_bg_color',
    'type' => 'color',
    'name' => 'Button Background Color',
    'desc' => 'Pick a color of the button background (by default: #EFEFEF).',
    'std' => '#EFEFEF',
    
    'format' => 'rgba'
);


$of_options[] = array(
    'id' => 'button_font_color',
    'type' => 'color',
    'name' => 'Custom Button Font Color',
    'desc' => 'Pick a color of the button label text (by default: #5E605F).',
    'std' => '#5E605F',
    
);

$of_options[] = $jaw_builder_options['show_on_devices'];

$of_options[] = array(
    'id' => 'class',
    'type' => 'text',
    "hide_if_layout" => array('shortcodes'),
    'name' => '<i class="jaw-icon-code"></i> Custom Class',
    'desc' => 'Insert your custom class for this element.',
    'std' => ''
);

$of_options[] = array(
    'id' => 'el_id',
    "hide_if_layout" => array('shortcodes'),
    'type' => 'text',
    'name' => '<i class="jaw-icon-code"></i> Custom ID',
    'desc' => 'Insert your custom ID for this element.',
    'std' => ''
);

$of_options[] = array(
    "type" => "sectionend");


/* ==== BAR ==== */
$of_options[] = array(
    "name" => "Bar",
    "hide_if_layout" => array('shortcodes'),
    "type" => "sectionstart"
);

// Typ baru se prejima z globalni promenne definovane v metabox-builder.php
$of_options[] = $jaw_builder_options['global_bar_type'];  $of_options[] = $jaw_builder_options['global_bar_h'];$of_options[] = $jaw_builder_options['global_custom_link'];

$of_options[] = array(
    "hide_if_layout" => array('shortcodes'),
    "type" => "sectionend"
);

/* Settings */
$jaw_builder_options['button'] = $of_options;
