<?php

$options = array();

$header_styles_img = array(
'bar_type_1' => JAW_ADMIN_URI . 'assets/images/left_border.png',
'bar_type_2' => JAW_ADMIN_URI . 'assets/images/top_bottom.png',
'bar_type_3' => JAW_ADMIN_URI . 'assets/images/with_background.png',
'bar_type_4' => JAW_ADMIN_URI . 'assets/images/bar_type_4.png',
'bar_type_big_left' => JAW_ADMIN_URI . 'assets/images/title_big_left.png',
'bar_type_big_center' => JAW_ADMIN_URI . 'assets/images/title_big_center.png',
'bar_type_big_right' => JAW_ADMIN_URI . 'assets/images/title_big_right.png',
);

$header_styles_img_default = array_merge(array('_default' => JAW_ADMIN_URI . 'assets/images/default_title.png'), $header_styles_img);

$sb_size = array(
'2' => 'Slim',
'3' => 'Normal',
'4' => 'Wide',
);
$post_layouts = array(
'fullwidth' => JAW_ADMIN_URI . 'assets/images/no_sidebar.gif',
'left1' => JAW_ADMIN_URI . 'assets/images/left_sidebar.gif',
'right1' => JAW_ADMIN_URI . 'assets/images/right_sidebar.gif',
'right1_left1' => JAW_ADMIN_URI . 'assets/images/right_left_sidebar.gif',
'right1_right2' => JAW_ADMIN_URI . 'assets/images/right_right_sidebar.gif',
'left1_left2' => JAW_ADMIN_URI . 'assets/images/left_left_sidebar.gif',
);

$sharing = false;
if (class_exists('mashshare')) { // mashare plugin
    $sharing = true;
}

/* Welcome ******************************************************* */
$options[] = array("name" => "Welcome",
"type" => "headingstart");

// Welcome page
$options[] = array(
"name" => "welcome",
"id" => "jaw_welcome",
"text" => "<p style='color:#1E8CBE;font-weight:bold;font-size:14px;'>Thank you</p><p>for your purchase! We were working very hard to release this awesome magazine! Enjoy :)</p><p>JaWTemplates Team</p>",
"type" => "info",
"space" => false,
"class" => "jw-welcome",
"message" => "description"
);


// Gettings start
$options[] = array(
"name" => "start",
"id" => "jaw_start",
"text" => "<p style='color:#EB504B;font-weight:bold;font-size:14px;'>Quick start</p><p>We've created for you simply step by step tutorial how to start working with this theme.</p><a href='http://support.jawtemplates.com/gdaynews/web/?p=904' target='_blank' class='of_link'>QUICK START</a>",
    "type" => "info",
"space" => false,
"class" => "jw-welcome",
"message" => "description"
);

// JaWTemplates demo
$options[] = array(
"name" => "demo",
"id" => "demo_data",
"text" => "<span rel='demodata'><p style='color:#EB504B;font-weight:bold;font-size:14px;'>Demo data</p><p>You can install demo data now with one click! It takes only a few minutes.</p><a href='#of-option-demodata' class='of_link jaw-goto-demodata' data-goto='demodata'>Install Now!</a>",
"type" => "info",
"space" => false,
"class" => "jw-welcome",
"message" => "description"
);

// JaWTemplates What's new
$options[] = array(
"name" => "What's new in this version",
"id" => "jaw_changelog",
"type" => "changelog",
"space" => false,
"class" => "jw-welcome",
"message" => "description"
);



// JaWTemplates Support
$options[] = array(
"name" => "support",
"id" => "jaw_support",
"text" => "<p style='color:#1E8CBE;font-weight:bold;font-size:14px;'>Support</p><p>Need some help? We provide excellent support to our customer. Try us!</p><a href='http://support.jawtemplates.com' class='of_link' target='_blank'>Get Support</a>",
"type" => "info",
"space" => false,
"class" => "jw-welcome",
"message" => "description"
);

// JaWTemplates Tutorial
$options[] = array(
"name" => "tutorial",
"id" => "jaw_tutorial",
"text" => "<p style='color:#1E8CBE;font-weight:bold;font-size:14px;'>Tutorials</p><p>You can do it! Try our special tutorials, it's so easy!</p><a href='http://support.jawtemplates.com/gdaynews/web/category/could-help/' class='of_link' target='_blank'>Let's do it</a>",
"type" => "info",
"space" => false,
"class" => "jw-welcome",
"message" => "description"
);

// JaWTemplates Tutorial
$options[] = array(
"name" => "documentation",
"id" => "jaw_documentation",
"text" => "<p style='color:#1E8CBE;font-weight:bold;font-size:14px;'>Documentation</p><p>Wanna see some advanced stuff?</p><a href='http://support.jawtemplates.com/gdaynews/web/' class='of_link' target='_blank'>Let me see</a>",
"type" => "info",
"space" => false,
"class" => "jw-welcome",
"message" => "description"
);

// JaWTemplates checker
$options[] = array(
"name" => "Theme Requirements",
"id" => "jaw_checker",
"type" => "checker",
"space" => false,
"class" => "jw-welcome",
"message" => "description"
);

// JaWTemplates Portfolio
$options[] = array(
"name" => "portfolio",
"id" => "portfolio",
"text" => "<p style='color:#1E8CBE;font-weight:bold;font-size:14px;'>Our Portfolio</p><p>You can simply find us here</p><a href='http://www.jawtemplates.com/wordpress-themes/gday-news-magazine/' class='of_link' target='_blank'>Portfolio</a>",
"type" => "info",
"space" => false,
"class" => "jw-welcome",
"message" => "description"
);

$options[] = array("type" => "headingend");
/* Welcome END ****************************************************** */

/* GENERAL ******************************************************* */
$options[] = array("name" => "General Settings",
"type" => "headingstart");

//  
$options[] = array(
'id' => 'wide_mode',
'type' => 'toggle',
'name' => 'Width of Site',
'desc' => 'Define width of your sites. Here are two predefined sizes + you can also choose your own custom width.',
'std' => 'no-wide',
"options" => array("no-wide" => "Slim", "wide" => "Wide", "custom" => "Custom")
);

$options[] = array(
'id' => 'custom_width',
'name' => 'Custom Width of Site',
'desc' => 'Custom width of site in px',
"std" => '1180',
'maxlength' => 4,
"ng-class" => "{'jw-disabled': edit['wide_mode']!='custom'}",
"type" => "text"
);
// 

$options[] = array(
'id' => 'responsive',
'type' => 'toggle',
'name' => 'Responsive Theme'. " " . jwUtils::getHelp("Responsive Theme", "If you turn it off, your viewers will be still able to turn it on by button in footer. (If you allow it in Theme Options -> Footer Settings -> Show Control of Responsivity)", "allowresponsivity.jpg") ,
'desc' => "Turn on or off the theme's responsivity.",
'std' => '1'
);

$options[] = array("name" => "Favicon". " " . jwUtils::getHelp("", "", "favicon-example.jpg", array(array(
'href' => 'http://www.favicon.cc/',
'title' => 'Favicon generator'
))) ,
"desc" => "Upload a 16px &times; 16px PNG/GIF image that will represent your website's favicon.",
"id" => "custom_favicon",
"std" => "",
"type" => "upload");

//  
$options[] = array(
'id' => 'global_header_style',
'type' => 'layout',
'name' => 'Global Heading Style',
'desc' => 'Select the heading style you prefer.<br><br>This setting affects look of the heading area of all the main elements on your website.',
'std' => 'bar_type_1',
"options" => $header_styles_img
);
// 

$options[] = array(
'id' => 'isotope_grid',
'type' => 'toggle',
'name' => 'Masonry Effect'. " " . jwUtils::getHelp("", "", "masonry.jpg", array(array(
'href' => 'http://support.jawtemplates.com/gdaynews/web/?p=1559',
'title' => 'Documentation'
))),
'desc' => 'Turn On/Off the masonry (isotope) effect.',
'std' => '1'
);

//  
$options[] = array(
"name" => "Image Settings",
"type" => "sectionstart");
$options[] = array(
'id' => 'image_cropping',
'type' => 'toggle',
'name' => 'Image Cropping',
'desc' => 'Decide whether or not to allow automatically cropping images (ratio 16:9) for better look.<br><br>NOTE: After you change this option, you will have to regenerate thumbnails via this plugin <a href="https://wordpress.org/plugins/simple-image-sizes/" title="WordPress.org | Simple Image Sizes plugin" target="_blank">Simple Image Sizes</a> plugin to take an effect.<br><br><strong>IMPORTANT:</strong> Do not forget to regenerate thumbnails in <strong>Settings > Media</strong>.<br />For more information, please follow this <a href="http://support.jawtemplates.com/gdaynews/web/category/for-developers/">URL</a>',
    'std' => '1',
"options" => array("0" => "Off", "1" => "On")
);


$options[] = array(
'id' => 'scroll_load_images',
'type' => 'toggle',
'name' => 'Lazyload Images',
'desc' => 'Reduces the amount of data. If turned On, images are loaded when the content is scrolled to them (works with some images only). <br><br>Option "Support HiDPI displays" load bigger images for HiDPI displays.',
'std' => '1',
"options" => array("0" => "Off", "1" => "On", "2" => "Support HiDPI displays")
);
$options[] = array(
'id' => 'image_hover_effect_type',
'type' => 'toggle',
'desc' => 'Choose the hover effect you want to apply to an image when it is hovered over, or turn off use of effects.<br><br>NOTE: The chosen effect will be applied to the post boxes only.',
'name' => 'Image Hover Effect',
'std' => '0',
'options' => array("0" => "Off", "zoomie" => "Zoomie", "pulsie" => "Pulsie", "blackie" => "B&W")
);
$options[] = array("name" => "Image Hover Effect Plusie - Background Color",
"desc" => "Enter or select the background color to be applied when an image is hovered over.",
"id" => "image_hover_effect_bg",
"std" => "#ffffff",
"ng-class" => "{'jw-disabled': edit['image_hover_effect_type']!='pulsie'}",
"type" => "color");

$options[] = array(
'id' => 'image_caption_toggle',
'type' => 'layout',
'name' => 'Image Caption Style '. " " . jwUtils::getHelp("", "", "image-caption.jpg") ,
'desc' => 'Choose whether or not and where an image caption will be displayed in a single post.<br><br>NOTE: This does not work with featured image, but with images inside post only.',
'std' => '2',
"options" => array(
    '0' => JAW_ADMIN_URI . 'assets/images/image_caption/image-capture-off.png',
    '1' => JAW_ADMIN_URI . 'assets/images/image_caption/image-capture-in-image.png',
    '2' => JAW_ADMIN_URI . 'assets/images/image_caption/image-capture-under-image.png'
));

$options[] = array(
"type" => "sectionend");

$options[] = array(
'id' => 'totop_show',
'type' => 'toggle',
'name' => 'To Top Arrow'. " " . jwUtils::getHelp("", "", "to-top-arrow.jpg", array( array(
'href' => 'http://support.jawtemplates.com/gdaynews/web/documentation/goodday-news-magazine-settings/general-settings/#toTopArrow',
'title' => 'documentation') )) ,
'desc' => 'Choose whether or not and on what kind of devices to show the "To Top" arrow.',
'std' => 'tablet',
'options' => array("0" => "Hide", "tablet" => "<i class='jaw-icon-screen4'></i><i class='jaw-icon-tablet'></i>", "phone" => "<i class='jaw-icon-screen4'></i><i class='jaw-icon-tablet'></i><i class='jaw-icon-mobile'></i>")
);

$options[] = array(
'id' => 'switch_udate',
'type' => 'toggle',
'name' => 'Notification of New Updates',
'desc' => 'Decide whether you want to be informed about new available updates.',
'std' => '1'
);

$options[] = array(
'id' => 'theme_revoComposer',
'type' => 'toggle',
'name' => 'Use RevoComposer Page Builder'. " " . jwUtils::getHelp("", "", "use-revo-composer.jpg", array( array(
'href' => 'http://support.jawtemplates.com/gdaynews/web/documentation/goodday-news-magazine-settings/general-settings#UseRevoComposer',
'title' => 'documentation') )) ,
'desc' => 'Decide whether or not to enable use of the RevoComposer page builder.',
'std' => '1',
"options" => array("0" => "Off","1" => "On")
);

$options[] = array(
"name" => "Log In / Log Out",
"type" => "sectionstart"
);

$options[] = array(
"name" => "Page After Log In (Welcome page)",
"desc" => "Select the page that will be shown after click on login in the top bar (WP admin page by default). Works for Subscribers.",
    "id" => "user_bar_login_pageid",
"std" => "_default",
"type" => "advselect",
'chosen' => 'true',
'target' => 'page'
);

$options[] = array(
"name" => "Page After Wrong Log In (Error page)",
"desc" => "Select the page that will be shown after click on login in the top bar (WP admin page by default). ",
"id" => "user_bar_wrong_login_pageid",
"std" => "_default",
"type" => "advselect",
'chosen' => 'true',
'target' => 'page'
);

$options[] = array(
"name" => "Page After Log Out (Good Bye page)",
"desc" => "Select the page that will be shown after click on logout in the top bar My Account menu (WP login page by default).",
"id" => "user_bar_logout_pageid",
"std" => "_default",
"type" => "advselect",
'chosen' => 'true',
'target' => 'page'
);

$options[] = array(
"type" => "sectionend"
);

$options[] = array(
"name" => "SEO",
"type" => "sectionstart"
);

$otherseotext="Turn the option on to use the theme built-in SEO, or turn it off if you prefer using another SEO plugin.<br><br>If turned on, meta tags for social networks will be added to your site's head.";
/*$otherseo = false; @rami - 17.3.2017 - zase to stejne, uzivatele jsou zmateni :)
 if(function_exists("wpseo_auto_load") && jwOpt::get_option('use_jaw_seo', '1') == '1') {
    $otherseo = true;
    $otherseotext = '<i class="jaw-icon-warning"></i><span style="color:red">
        '.esc_html__("You have activated Another SEO Plugin. We suggest you to turn built-in SEO via Theme Options or you can disable SEO plugin",'gdn-theme').
        '<a target="_blank" href="'.admin_url('plugins.php').'">
        '.esc_html__("here",'gdn-theme').'</a> 
        '.esc_html__("Please bear in mind that for the best results we recommend use only one SEO (plugin or built-in) and not both. Thank you.",'gdn-theme').' </span>';
 }*/
$options[] = array(
'id' => 'use_jaw_seo',
'type' => 'toggle',
'name' => 'Use Built-in SEO',
'desc' => $otherseotext,
'std' => '0'
);

$options[] = array(
'id' => 'use_jaw_seo_logo',
'type' => 'toggle',
'name' => 'Logo in H1',
'desc' => 'Choose whether or not to place your logo between <code>H1</code> HTML tags. If the Off option has been selected, the logo is placed between <code>P</code> tags.',
'std' => '1',
);

$options[] = array(
'id' => 'use_tel_links',
'type' => 'toggle',
'name' => 'Use Telephone Links',
'desc' => 'If you plan use some telephone links (e.g. on contact page), please keep turning this on. If not, the iOS can restyle your default styles',
'std' => '1'
);

$options[] = array(
"type" => "sectionend"
);
// 

// 

$options[] = array("type" => "headingend");
/* GENERAL END ****************************************************** */

/* Header Settings ************************************************** */
$options[] = array("name" => "Logo Area",
"type" => "headingstart");

//  
$options[] = array(
'id' => 'header_color',
'type' => 'select_preset',
"target" => "color",
'name' => '<i class="jaw-icon-palette jaw-preset-icon"></i> Header Color Scheme',
'desc' => "Select a color scheme from this list of those you have created in <strong>Styling Options > Main Color Scheme</strong>. Colors from the chosen color preset will be applied to the header area.<br><br>DEFAULT: <a href='#of-option-colorsettings' class='jaw-goto-colorsettings' data-goto='colorsettings' data-highlight='main_color'><strong>Theme Options -> Styling Options -> Collor Settings -> Main Color Scheme</strong></a>",
'std' => '-1',

);
$options[] = array(
'id' => 'header_fullwidth',
'name' => 'Width of Header Area',
'desc' => 'Decide whether or not to show your logo area over the entire width of page.',
'std' => 'off',
'type' => 'layout',
"options" => array(
    'boxed' => JAW_ADMIN_URI . 'assets/images/width_of_element/menu-boxed.png',
    'off' => JAW_ADMIN_URI . 'assets/images/width_of_element/menu-classical.png',
    'on' => JAW_ADMIN_URI . 'assets/images/width_of_element/menu-fullwidth.png'
)
);

// 
$options[] = array( 
'id' => 'header_style',
"type" => "layout",
'name' => 'Header Layout'. ' ' . jwUtils::getHelp("Header Layout", "<strong>In Case of IN MENU layout</strong>, bear in mind, that height of the menu is taken from height of your logo. If RETINA READY LOGO option  is set on, this logo will be displayed in its half size.", "") ,
"extend" => '',
'desc' => 'Choose a preset number of columns to be available for your widgets in the header.',
'std' => 'l-center',
'class' => 'fullwidth-option',
"options" => array(
    'l-left' => JAW_ADMIN_URI . 'assets/images/l-left.png',
    'l-center' => JAW_ADMIN_URI . 'assets/images/l-center.png',
    'l-right' => JAW_ADMIN_URI . 'assets/images/l-right.png',
    'l-a' => JAW_ADMIN_URI . 'assets/images/l-a.png',
    'a-l' => JAW_ADMIN_URI . 'assets/images/a-l.png',
    //  
    '4-l-4' => JAW_ADMIN_URI . 'assets/images/4-l-4.png',
    'l-4-4' => JAW_ADMIN_URI . 'assets/images/l-4-4.png',
    '4-4-l' => JAW_ADMIN_URI . 'assets/images/4-4-l.png',
    'in-menu' => JAW_ADMIN_URI . 'assets/images/in-menu.png',
    'under-menu' => JAW_ADMIN_URI . 'assets/images/under-menu.png',
    'no-logo' => JAW_ADMIN_URI . 'assets/images/no-logo.png',
    // 
)
);
//  
$options[] = array(
'id' => 'header_bar_type',
'type' => 'layout',
'name' => 'Widgets Title Style in Header',
'desc' => 'Select the heading style of custom widgets you prefer. <span class="jaw-default">Default: Global Settings > Global Header Style</span>',
'std' => '_default',
"options" => $header_styles_img_default
);
// 
/* * ***************** LOGO ****************** */
$options[] = array(
"name" => "Logo Settings",
"type" => "sectionstart");

$options[] = array("name" => "Logo",
"desc" => "Upload your logo or remove the uploaded one.",
"id" => "custom_logo",
"std" => "",
"type" => "upload");
//  
$options[] = array("name" => "Logo in Fixed Menu",
"desc" => 'Used only when you choosed "Header Layout" as "Logo - in menu" and "Fixed Menu bar" to ON<br><br><strong>Bear in mind, that height of the menu is taken from height of this image.</strong>',
"id" => "custom_logo_fixed_menu",
"ng-class" => "{'jw-disabled': edit['logo_in_menu_bar_fix']=='0'}",
"std" => "",
"type" => "upload");
// 

$options[] = array("name" => "Mobile Logo",
"desc" => "Upload your logo or remove the uploaded one.",
"id" => "custom_mobile_logo",
"std" => "",
"type" => "upload");

$options[] = array(
'id' => 'logo_retina_ready',
'type' => 'toggle',
'name' => 'Retina Ready Logo' . ' ' . jwUtils::getHelp("Retina resizing", "If it's set on, your logo will be displayed in its half size.", "",
array( array(
'href' => 'http://support.jawtemplates.com/gdaynews/web/documentation/goodday-news-magazine-settings/header-settings/header-area/',
'title' => 'documentation') )) ,
'desc' => 'Decide whether or not to display logo in high quality on the Retina displays.',
'std' => '1'
);

$options[] = array(
"type" => "sectionend");
/* * ***************** LOGO end ****************** */

// 
$options[] = array("type" => "headingend");

/* * ***************** topbar ****************** */

//  
$options[] = array("name" => "Top Bar",
"type" => "headingstart");



$options[] = array(
'id' => 'top_bar_show',
'type' => 'toggle',
'name' => 'Show Top Bar'. " " . jwUtils::getHelp("", "", "topbar.jpg", array( array(
'href' => 'http://support.jawtemplates.com/gdaynews/web/documentation/goodday-news-magazine-settings/header-settings/top-bar/',
'title' => 'documentation') )) ,
'desc' => 'Choose whether or not to show the top bar.',
'std' => '0'
);

$options[] = array(
'id' => 'top_bar_color',
'type' => 'select_preset',
"target" => "color",
'name' => '<i class="jaw-icon-palette jaw-preset-icon"></i> Top Bar Color Scheme',
'desc' => "Select a color scheme from this list of those you have created in <strong>Styling Options > Main Color Scheme</strong>. Colors from the chosen color preset will be applied to your top bar.<br><br>DEFAULT: <a href='#of-option-colorsettings' class='jaw-goto-colorsettings' data-goto='colorsettings' data-highlight='main_color'><strong>Theme Options -> Styling Options -> Collor Settings -> Main Color Scheme</strong></a>",
'std' => '-1',

);
$options[] = array(
'id' => 'top_bar_fullwidth',
'type' => 'layout',
'name' => 'Width of Top Bar',
'desc' => 'Decide whether or not to show your top bar over the entire width of page.',
'std' => 'on',
"options" => array(
'boxed' => JAW_ADMIN_URI . 'assets/images/width_of_element/menu-boxed.png',
'off' => JAW_ADMIN_URI . 'assets/images/width_of_element/menu-classical.png',
'on' => JAW_ADMIN_URI . 'assets/images/width_of_element/menu-fullwidth.png'
)
);

$options[] = array(
'id' => 'top_bar_fix',
'type' => 'toggle',
'name' => 'Fixed Top Bar',
'desc' => 'Turn on this option if the top bar has to be easy reachable for readers.',
'std' => '0',
'options' => array('0' => 'Off', '1' => 'Permanently visible', '2'=> 'Show when scroll up')
);

$options[] = array(
'id' => 'top_bar_date',
'type' => 'toggle',
"class" => "top-show-on-devices",
'name' => 'Show Date'. " " . jwUtils::getHelp("", "", "topbar-show-date.jpg", array( array(
'href' => 'http://support.jawtemplates.com/gdaynews/web/documentation/goodday-news-magazine-settings/header-settings/top-bar/#ShowDate',
'title' => 'documentation') )) ,
'desc' => 'Choose whether or not and where to show date in the top bar - either on desktops or on desktops and tablets.',
'std' => 'tablet',
'options' => array("0" => "Hide", "desktop" => "<i class='jaw-icon-screen4'></i>", "tablet" => "<i class='jaw-icon-screen4'></i><i class='jaw-icon-tablet'></i>")
);
$options[] = array(
'id' => 'top_bar_date_format',
'type' => 'text',
'name' => 'Date Format'. " " . jwUtils::getHelp("", "", "", array( array(
'href' => 'https://codex.wordpress.org/Formatting_Date_and_Time',
'title' => 'WordPress documentation') )) ,
'desc' => "Specify a date format using the format characters. Here is what each of them represents: <br><br>F - Full name for the month<br>j - The day of the month<br>Y - The year in 4 digits (lower-case y gives the year's last 2 digits)",
    'std' => 'F j, Y',
);
$options[] = array(
'id' => 'top_bar_text',
'type' => 'toggle',
'name' => 'Show Text'. " " . jwUtils::getHelp("", "", "topbar-show-text.jpg", array( array(
'href' => 'http://support.jawtemplates.com/gdaynews/web/documentation/goodday-news-magazine-settings/header-settings/top-bar/#ShowText',
'title' => 'documentation') )) ,
"class" => "top-show-on-devices",
'desc' => 'Choose whether or not and where to show your text in the top bar - either on desktops or on desktops and tablets.',
'std' => '0',
'options' => array("0" => "Hide", "desktop" => "<i class='jaw-icon-screen4'></i>", "tablet" => "<i class='jaw-icon-screen4'></i><i class='jaw-icon-tablet'></i>")
);
$options[] = array(
'id' => 'top_bar_text_content',
'type' => 'text',
'name' => 'Text Content',
'desc' => 'Fill the field with your text that will or will not be visible in the top bar depending on the Show Text setting above.',
'std' => ''
);
$options[] = array(
'id' => 'top_bar_menu',
'type' => 'toggle',
'name' => 'Show Menu',
"class" => "top-show-on-devices",
'desc' => 'Choose whether or not and where to show your menu in the top bar - either on desktops or on desktops and tablets. <br><br>To enable the menu, go to <strong>Appearance > Menus</strong>, choose the menu you need and tick the Top Bar Navigation option in <em>Theme locations</em> settings.',
'std' => '0',
'options' => array("0" => "Hide", "desktop" => "<i class='jaw-icon-screen4'></i>", "tablet" => "<i class='jaw-icon-screen4'></i><i class='jaw-icon-tablet'></i>")
);
$options[] = array(
'id' => 'top_bar_social',
'type' => 'toggle',
'name' => 'Show Social'. " " . jwUtils::getHelp("", "", "topbar-show-social.jpg", array( array(
'href' => 'http://support.jawtemplates.com/gdaynews/web/documentation/goodday-news-magazine-settings/header-settings/top-bar/#ShowSocial',
'title' => 'documentation') )) ,
"class" => "top-show-on-devices",
'desc' => 'Choose whether or not and where to show social icons - either on desktops or on desktops and tablets.',
'std' => 'tablet',
'options' => array("0" => "Hide", "desktop" => "<i class='jaw-icon-screen4'></i>", "tablet" => "<i class='jaw-icon-screen4'></i><i class='jaw-icon-tablet'></i>")
);

$options[] = array(
'id' => 'top_bar_social_facebook',
'type' => 'text',
'name' => 'Facebook Page URL',
'desc' => 'Insert your Facebook URL.',
'std' => '',
);
$options[] = array(
'id' => 'top_bar_social_twitter',
'type' => 'text',
'name' => 'Twitter Page URL',
'desc' => 'Insert your Twitter URL.',
'std' => '',
);
$options[] = array(
'id' => 'top_bar_social_google',
'type' => 'text',
'name' => 'Google Plus Page URL',
'desc' => 'Insert your Google Plus URL.',
'std' => '',
);
$options[] = array(
'id' => 'top_bar_social_youtube',
'type' => 'text',
'name' => 'Youtube Page URL',
'desc' => 'Insert your Youtube URL.',
'std' => '',
);
$options[] = array(
'id' => 'top_bar_social_vimeo',
'type' => 'text',
'name' => 'Vimeo Page URL',
'desc' => 'Insert your Vimeo URL.',
'std' => '',
);
$options[] = array(
'id' => 'top_bar_social_linkedin',
'type' => 'text',
'name' => 'LinkedIn Page URL',
'desc' => 'Insert your LinkedIn URL.',
'std' => '',
);
$options[] = array(
'id' => 'top_bar_social_pinterest',
'type' => 'text',
'name' => 'Pinterest Page URL',
'desc' => 'Insert your Pinterest URL.',
'std' => '',
);
$options[] = array(
'id' => 'top_bar_social_instagram',
'type' => 'text',
'name' => 'Instagram Page URL',
'desc' => 'Insert your Instagram URL.',
'std' => '',
);
$options[] = array(
'id' => 'top_bar_user_content',
'type' => 'toggle',
'name' => 'Show Log In & My News'. " " . jwUtils::getHelp("", "", "topbar-show-mynews.jpg", array( array(
'href' => 'http://support.jawtemplates.com/gdaynews/web/documentation/goodday-news-magazine-settings/header-settings/top-bar/#ShowLoginAndMyNews',
'title' => 'documentation') )) ,
'desc' => "Choose whether or not and where to show Log In & User Content - either on desktops or on desktops and tablets. Detailed settings for this area is in <a href='#of-option-mynews' class='jaw-goto-logoarea' data-goto='mynews'>Theme Options -> MyNews</a><br><br><a href='#of-option-mynews' class='jaw-goto-mynews' data-goto='user_account_pageid' data-highlight='header_style'>Check also your setting of User Account Front End Page</a>",
'std' => '0',
"class" => "top-show-on-devices",
'options' => array("0" => "Hide", "desktop" => "<i class='jaw-icon-screen4'></i>", "tablet" => "<i class='jaw-icon-screen4'></i><i class='jaw-icon-tablet'></i>")
);
$options[] = array(
'id' => 'top_bar_search',
'type' => 'toggle',
'name' => 'Show Search',
'desc' => 'Choose whether or not and where to show Search - either on desktops or on desktops and tablets.',
"class" => "top-show-on-devices",
'std' => 'tablet',
'options' => array("0" => "Hide", "desktop" => "<i class='jaw-icon-screen4'></i>", "tablet" => "<i class='jaw-icon-screen4'></i><i class='jaw-icon-tablet'></i>")
);

$options[] = array("type" => "headingend");

/* * ***************** MENU end ****************** */

$options[] = array("name" => "Under Top Bar Area",
"type" => "headingstart");

$options[] = array(
'id' => 'header_featured_show',
'type' => 'toggle',
'name' => 'Show Under Top Bar Featured Area - Homepage | All Web',
'desc' => 'Choose whether or not and on which pages to show the featured area placed above the logo area - either on the homepage only or on all your web pages.',
'std' => 'off',
'options' => array("off" => "Off","home" => "On Homepage", "all_web" => 'All Web')
);

global $metabuild;
unset($metabuild['build_layout_bookmark']);
unset($metabuild['build_preset_bookmark']);
unset($metabuild['build_element_preset_bookmark']);
$options[] = array(
"name" => "Under Top Bar Featured Area",
"desc" => 'Use it just like regular RevoComposer',
"id" => "header_featured_area_builder",
"type" => "jaw_builder",
'content' => $metabuild,
"areas" => "{
    'content': [
    {'id': '2_content', 'type': 'content', 'size': 12}
    ]
}"
);

$options[] = array("type" => "headingend");
// 

/* * ***************** MENU ****************** */
$options[] = array("name" => "Menu",
"type" => "headingstart");

$options[] = array(
"name" => "Menu",
"type" => "sectionstart");

//  
$options[] = array(
'id' => 'menu_color',
'type' => 'select_preset',
"target" => "color",
'name' => '<i class="jaw-icon-palette jaw-preset-icon"></i> Menu Color Scheme',
'desc' => "<strong>NOTE: You need to have installed JaW Menu plugin for this functionality.</strong><br><br>Select a color scheme from this list of those you have created in <strong>Styling Options > Color Schemes</strong>. Colors from the chosen color preset will be applied to your menu.<br><br>DEFAULT: <a href='#of-option-colorsettings' class='jaw-goto-colorsettings' data-goto='colorsettings' data-highlight='main_color'><strong>Theme Options -> Styling Options -> Collor Settings -> Main Color Scheme</strong></a>",
    'std' => '-1',

);
$options[] = array(
'id' => 'menu_style_type',
'type' => 'layout',
'name' => 'Menu Style',
'desc' => '<strong>NOTE: You need to have installed JaW Menu plugin for this functionality.</strong><br><br>Select the menu style you prefer.',
'std' => 'classic',
"options" => array(
'simple' => JAW_ADMIN_URI . 'assets/images/menu-simple.png',
'classic' => JAW_ADMIN_URI . 'assets/images/menu-classic.png',
'colored' => JAW_ADMIN_URI . 'assets/images/menu-classic-colored.png'
)
);

// 



$options[] = array(
'id' => 'menu_align',
'type' => 'toggle',
'name' => 'Menu Align',
'desc' => '<strong>NOTE: You need to have installed JaW Menu plugin for this functionality.</strong><br><br>Choose the way to align your menu.',
    'std' => 'left',
"options" => array(
'left' => 'Left',
'center' => 'Center',
'justify' => 'Justify',
)
);

//  
$options[] = array(
'id' => 'menu_fullwidth',
'type' => 'layout',
'name' => 'Width of Menu',
'desc' => 'Decide whether or not to show your menu bar of your page. You can choose Boxed, Classical, Fullwidth Background or Boxed with Fulwidth Background.',
'std' => 'off',
"options" => array(
'boxed' => JAW_ADMIN_URI . 'assets/images/width_of_element/menu-boxed.png',
'off' => JAW_ADMIN_URI . 'assets/images/width_of_element/menu-classical.png',
'on' => JAW_ADMIN_URI . 'assets/images/width_of_element/menu-fullwidth.png',
'on-shrinked' => JAW_ADMIN_URI . 'assets/images/width_of_element/menu-shrink-fullwidth.png'
)
);

$options[] = array(
'id' => 'menu_bar_fix',
'type' => 'toggle',
'name' => 'Fixed Menu Bar',
'desc' => 'Turn on this option if the top menu bar has to be easy reachable for readers.',
'std' => '0',
'options' => array('0' => 'Off', '1' => 'Permanently visible', '2'=> 'Show when scroll up')
);

$options[] = array(
'id' => 'logo_in_menu_bar_fix',
'type' => 'toggle',
'name' => 'Logo in Fixed Menu Bar',
'desc' => 'Please set logo in <a href="#of-option-logoarea" class="jaw-goto-logoarea" data-goto="logoarea" data-highlight="custom_logo_fixed_menu">Header Settings -> Logo Area -> Logo in Fixed Menu</a>',
'std' => '0',
'options' => array('0' => 'Off', '1'=> 'On'),
"ng-class" => "{'jw-disabled': edit['menu_bar_fix']=='0'}"
);
// 
$options[] = array(
"type" => "sectionend");


$options[] = array(
"name" => "Menu - Right area",
"type" => "sectionstart");
//  
$options[] = array(
'id' => 'menu_left_color',
'type' => 'select_preset',
"target" => "color",
'name' => '<i class="jaw-icon-palette jaw-preset-icon"></i> Menu Right Area Color Scheme',
'desc' => '<strong>NOTE: You need to have installed JaW Menu plugin for this functionality.</strong><br><br>Select a color scheme from this list of those you have created in <strong>Styling Options > Color Schemes</strong>. Colors from the chosen color preset will be applied to your menu.',
    'std' => '-1',

);

$options[] = array(
'id' => 'use_user_panel',
'type' => 'toggle',
'name' => 'Show My News Panel in Menu'. " " . jwUtils::getHelp("Show My News Panel in Menu", "", "menu-mynews.jpg", array( array(
'href' => 'http://support.jawtemplates.com/gdaynews/web/documentation/goodday-news-magazine-settings/header-settings/top-bar/#ShowMyNewsPanelinMenu',
'title' => 'documentation') )) ,
'desc' => "Decide whether or not to show My News Panel in menu. <br><br>While readers are logged in, this feature enables them to select what they are interested in, and (depending on other settings) show their favorities, recently read news etc. in well arranged groups.<br><br>Detailed settings for this area is in <a href='#of-option-mynews' class='jaw-goto-logoarea' data-goto='mynews'>Theme Options -> MyNews</a><br><br>Check also your setting of <a href='#of-option-mynews' class='jaw-goto-mynews' data-goto='mynews' data-highlight='user_account_pageid'>User Account Front End Page</a>",
'std' => '0'
);
// 

$options[] = array(
'id' => 'user-panel-search',
'type' => 'toggle',
'name' => 'Show Search in Menu'. " " . jwUtils::getHelp("", "", "menu-search.jpg", array( array(
'href' => 'http://support.jawtemplates.com/gdaynews/web/documentation/goodday-news-magazine-settings/header-settings/top-bar/#ShowSearchinMenu',
'title' => 'documentation') )) ,
'desc' => 'Decide whether or not to show search in menu. <br><br>',
'std' => '1'
);

$options[] = array(
"name" => "Submit Message Button". " " . jwUtils::getHelp("", "", "menu-submit-message.jpg", array(
        array(
    'href' => 'http://support.jawtemplates.com/gdaynews/web/documentation/goodday-news-magazine-settings/header-settings/top-bar/#ShowSubmitMessageinMenu',
    'title' => 'documentation'),
        array(
    'href' => 'http://support.jawtemplates.com/gdaynews/web/?p=1203',
    'title' => 'tutorial')

     )) ,
"type" => "sectionstart");

if (class_exists('Popup_Maker')) {


    $options[] = array(
    'id' => 'user-panel-submit-message',
    'type' => 'toggle',
    'name' => 'Show Submit Message in Menu',
    'desc' => '',
    'std' => '0'
    );

    $options[] = array(
    'id' => 'user-panel-submit-message-style',
    'type' => 'text',
    'name' => 'Submit Message Text',
    'desc' => '',
    'std' => 'Leave a Tip'
    );

    $options[] = array(
    'id' => 'user-panel-submit-message-modal_id',
    'type' => 'text',
    'name' => 'Popup Maker ID'. " " . jwUtils::getHelp("Where to get Popup Maker ID", "Go to Popup Marker -> All Popups -> and copy number from Classes. Take a look at this image:", "popupmakerid.jpg",
        array( array(
        'href' => 'http://docs.wppopupmaker.com/',
        'title' => 'plugin documentation') )
    ) ,
    'desc' => 'Go to Popup Marker -> All Popups -> and copy number from Classes',
    'std' => ''
    );
} else {
        $options[] = array(
            'id' => 'user-panel-submit-message_info',
            "name" => "Popup Maker Plugin Only",
            "text" => 'Please Activate Popup Maker Plugin <a target="_blank" href="'.admin_url('plugins.php').'">here</a>',
            "type" => "info",
            "space" => false,
            "message" => "info"
        );
}

$options[] = array(
"type" => "sectionend");

$options[] = array(
"type" => "sectionend");


$options[] = array(
"name" => "SubMenu",
"type" => "sectionstart");

$options[] = array(
'id' => 'submenu_color',
'type' => 'select_preset',
"target" => "color",
'name' => '<i class="jaw-icon-palette jaw-preset-icon"></i> SubMenu Color Scheme',
'desc' => "<strong>NOTE: You need to have installed JaW Menu plugin for this functionality.</strong><br><br>Select a color scheme from this list of those you have created in <strong>Styling Options > Color Schemes</strong>. Colors from the chosen color preset will be applied to your menu. <br><br>DEFAULT: <a href='#of-option-menu' class='jaw-goto-menu' data-goto='menu' data-highlight='menu_color'><strong>Theme Options -> Header Settings -> Menu -> Menu Color Scheme</strong></a>",
'std' => '-1',

);
$options[] = array(
"type" => "sectionend");

/* * ***************** MENU end ****************** */


/* * ***************** MOBILE MENU ****************** */
$options[] = array(
"name" => "Mobile Menu",
"type" => "sectionstart");

$options[] = array(
'id' => 'mobile_menu_color',
'type' => 'select_preset',
"target" => "color",
'name' => '<i class="jaw-icon-palette jaw-preset-icon"></i> Mobile Menu Color Scheme',
'desc' => "<strong>NOTE: You need to have installed JaW Menu plugin for this functionality.</strong><br><br>Select a color scheme from this list of those you have created in <strong>Styling Options > Main Color Scheme</strong>. Colors from the chosen color preset will be applied to your mobile menu. <br><br>DEFAULT: <a href='#of-option-menu' class='jaw-goto-menu' data-goto='menu' data-highlight='menu_color'><strong>Theme Options -> Header Settings -> Menu -> Menu Color Scheme</strong></a>",
    'std' => '-1',

);

$options[] = array(
'id' => 'mobile_menu_bar_fix',
'type' => 'toggle',
'name' => 'Fixed Mobile Menu Bar',
'desc' => 'Turn on this option if the top menu bar has to be permanently displayed, independently on scrolling the page.',
    'std' => '0'
);

//  
$options[] = array(
'id' => 'mobile_menu_show_login',
'type' => 'toggle',
'name' => 'Show Login / MyNews'. " " . jwUtils::getHelp("", "", "mobilemenu-login.jpg", array( array(
'href' => 'http://support.jawtemplates.com/gdaynews/web/documentation/goodday-news-magazine-settings/header-settings/top-bar/#MobileMenu',
'title' => 'documentation') )) ,
'desc' => 'Choose whether or not to Show Login / MyNews.',
'std' => '2',
"options" => array("0" => "Off", "1" => "Login", "2" => "Login + MyNews")
);
// 
$options[] = array(
'id' => 'mobile_menu_show_search',
'type' => 'toggle',
'name' => 'Show Search in  Mobile menu'. " " . jwUtils::getHelp("", "", "mobilemenu-search.jpg", array( array(
'href' => 'http://support.jawtemplates.com/gdaynews/web/documentation/goodday-news-magazine-settings/header-settings/top-bar/#ShowSearch',
'title' => 'documentation') )) ,
'desc' => 'Choose whether or not to show the Search bar.',
'std' => '1'
);

$options[] = array(
"type" => "sectionend");

// 

$options[] = array("type" => "headingend");
/* * **************** MOBILE MENU END ***************** */

/* * ******************* breadcrumbs **************** */
$options[] = array(
"name" => "Breadcrumbs",
"type" => "headingstart"
);
//  
$options[] = array(
'id' => 'blog_breadcrumb',
'type' => 'toggle',
'name' => 'Show Breadcrumbs',
'desc' => 'Select a way to manage displaying of breadcrumb navigation in categories, archives, tags, search results and inside posts.',
'std' => '1',
"options" => array("-1" => "Off - without gap", "0" => "Hide - keep space", "1" => "Show")
);


$options[] = array(
'id' => 'breadcrumb_bar_fix',
'type' => 'toggle',
'name' => 'Fixed Breadcrumbs',
'desc' => 'Turn on this option if the breadcrumbs bar has to be easy reachable for readers.',
'std' => '0',
'options' => array('0' => 'Off', '1' => 'Permanently visible', '2'=> 'Show when scroll up')
);

$options[] = array(
'id' => 'breadcrumb_show_home',
'type' => 'toggle',
'name' => 'Show Home Link in Breadcrumbs',
'desc' => 'Choose whether or not to show "Home" link in breadcrumbs.',
'std' => '1'
);

$options[] = array(
'id' => 'breadcrumb_show_article',
'type' => 'toggle',
'name' => 'Show Article Title in Breadcrumbs',
'desc' => 'Choose whether or not to include also a post title in the breadcrumb navigation.',
'std' => '1'
);

$options[] = array(
'id' => 'blog_cut_breadcrumb',
'name' => 'Cut Article Title in Breadcrumbs',
'desc' => 'Enter a number of characters (including spaces) in post titles / product names to be shown in the breadcrumb navigation, the rest will be replaced with "...".<br><br>To not to cut the titles, enter a negative value.',
"std" => '-1',
"mod" => 'micro',
'maxlength' => 4,
"type" => "text"
);

$options[] = array(
'id' => 'page_breadcrumbs',
'type' => 'select',
'name' => 'Show Breadcrumbs on Pages'. " " . jwUtils::getHelp("", "", "breadcrumbs-no-page.jpg"),
'desc' => 'Select a way to manage displaying of breadcrumb navigation on pages.',
'std' => '0',
"options" => array("1" => "Show", "-1" => "Off - without gap", "0" => "Hide - keep space")
);
// 

$options[] = array("type" => "headingend");
/* End Header Settings ********************************************** */

/* Featured Area Settings ******************************************* */
//background
//  
$options[] = array("name" => "Above Content Area",
"type" => "headingstart");

$options[] = array(
'id' => 'featured_show',
'type' => 'toggle',
'name' => 'Show Above Content Featured Area - Homepage | All web',
'desc' => 'Choose whether or not and on which pages to show the featured area placed under the menu - either on the homepage only or on all your web pages.
',
'std' => 'off',
'options' => array("off" => "Off","home" => "On Homepage", "all_web" => 'All Web')
);

global $metabuild;
unset($metabuild['build_layout_bookmark']);
unset($metabuild['build_preset_bookmark']);
unset($metabuild['build_element_preset_bookmark']);
$options[] = array(
"name" => "Above Content Featured Area",
"desc" => 'Use it just like regular RevoComposer',
"id" => "featured_area_builder",
"type" => "jaw_builder", //jaw_builder
'content' => $metabuild,
"areas" => "{
    'content': [
    {'id': '2_content', 'type': 'content', 'size': 12}
    ]
}"
);


$options[] = array("type" => "headingend");

// 

/* End Featured Area ************************************************ */

$options[] = array(
"name" => "Footer",
"type" => "headingstart"
);

//  
$options[] = array(
'id' => 'footer_color',
'type' => 'select_preset',
"target" => "color",
'name' => '<i class="jaw-icon-palette jaw-preset-icon"></i> Footer Color Scheme',
'desc' => "Select a color scheme from this list of those you have created in <strong>Styling Options > Main Color Scheme</strong>. Colors from the chosen color preset will be applied to the footer area.<br><br>DEFAULT: <a href='#of-option-colorsettings' class='jaw-goto-colorsettings' data-goto='colorsettings' data-highlight='main_color'><strong>Theme Options -> Styling Options -> Collor Settings -> Main Color Scheme</strong></a>",
'std' => '-1',

);

$options[] = array(
'id' => 'footer_fullwidth',
'type' => 'layout',
'name' => 'Width of Footer Area',
'desc' => 'Decide whether or not to show your footer area over the entire width of page.',
'std' => 'off',
"options" => array(
'boxed' => JAW_ADMIN_URI . 'assets/images/width_of_element/menu-boxed.png',
'off' => JAW_ADMIN_URI . 'assets/images/width_of_element/menu-classical.png',
'on' => JAW_ADMIN_URI . 'assets/images/width_of_element/menu-fullwidth.png'
)
);
// 

$options[] = array(
'id' => 'footer_style',
"type" => "layout",
'name' => 'Footer Layout',
"extend" => '',
'desc' => 'Choose a preset number of columns to be available for your widgets in the footer.',
    'std' => 'footer-3-3-3-3',
'class' => 'fullwidth-option',
"options" => array(
'footer-3-3-3-3' => JAW_ADMIN_URI . 'assets/images/f-4-4-4-4.png',
'footer-4-4-4' => JAW_ADMIN_URI . 'assets/images/f-3-3-3.png',
'footer-6-6' => JAW_ADMIN_URI . 'assets/images/f-2-2.png',
'footer-4-8' => JAW_ADMIN_URI . 'assets/images/f-3-33.png',
'footer-12' => JAW_ADMIN_URI . 'assets/images/f-1.png',
'footer-off' => JAW_ADMIN_URI . 'assets/images/no-footer.png'
)
);

//  
$options[] = array(
'id' => 'footer_bar_type',
'type' => 'layout',
'name' => 'Widgets Title Style in Footer',

'desc' => 'Select the heading style of custom widgets you prefer.<br><span class="jaw-default">Default: General Settings > Global Header Style</span>',
'std' => '_default',
"options" => $header_styles_img_default
);
// 
$options[] = array(
'id' => 'show_centered_elements',
'type' => 'toggle',
'name' => 'Center Elements',
'desc' => 'Decide whether or not to center your elements in the footer.',
'std' => 'off',
"options" => array("off" => "Off", "on" => "On")
);

$options[] = array(
'id' => 'show_copyright',
'type' => 'toggle',
'name' => 'Show Copyright',
'desc' => 'Decide whether or not to display your copyright info in the footer.',
'std' => 'on',
"options" => array("off" => "Off", "on" => "On")
);

$options[] = array(
'id' => 'show_responsive',
'type' => 'toggle',
'name' => 'Show Control of Responsivity'. " " . jwUtils::getHelp("", "", "allowresponsivity.jpg"),
'desc' => 'Choose whether or not to show option for turning on/off responsivity in the footer.',
    'std' => '1',
"options" => array("0" => "Off","1" => "On")
);

//  
$options[] = array(
'id' => 'show_footer_menu',
'type' => 'toggle',
'name' => 'Show Menu',
'desc' => 'Choose whether or not to show menu in the footer.',
'std' => '0',
"options" => array("0" => "Off","1" => "On")
);
// 

$options[] = array("name" => "Copyright Text",
"desc" => "Fill the field with your own plain or HTML tagged text to be displayed in the footer.",
"id" => "footer_text",
"std" => 'Copyright &copy; 2016 Design by <a href="http://www.jawtemplates.com/wordpress-themes/gday-news-magazine/">Jawtemplates.com</a>.',
"mod" => "html",
"type" => "ace_editor");

// 
$options[] = array("type" => "headingend");


/* My News Settings ******************************************* */

$options[] = array("name" => "My News",
"type" => "headingstart");


//  
$options[] = array(
'id' => 'use_my_news',
'type' => 'toggle',
'name' => 'Use My News',
'desc' => "Decide if you want to use this feature on your sites or not.",
'std' => '1'
);

$options[] = array(
'id' => 'my_news_color',
'type' => 'select_preset',
"target" => "color",
'name' => '<i class="jaw-icon-palette jaw-preset-icon"></i> My News Color Scheme',
'desc' => "Select a color scheme from this list of those you have created in <strong>Styling Options > Main Color Scheme</strong>. Colors from the chosen color preset will be applied to My News section.<br><br>DEFAULT: <a href='#of-option-colorsettings' class='jaw-goto-colorsettings' data-goto='colorsettings' data-highlight='main_color'><strong>Theme Options -> Styling Options -> Collor Settings -> Main Color Scheme</strong></a>",
'std' => '-1',
);

$options[] = array("name" => "Banner to Display When User is Logged off" . " " . jwUtils::getHelp("", "", "banner.jpg"),
"desc" => "Upload graphics to be displayed when user is logged off.",
"id" => "user_panel_banner",
"std" => "",
"type" => "upload");

$options[] = array(
"name" => "User Account Front End Page". " " . jwUtils::getHelp("User Account Front End Page", "Create a new page with specific template (MyNews User Manager). If you want to add different content for looged-in and logged-out, please use RevoComposer or MORE delimiter in editor.", "mynewsusermanager.jpg", array( array(
'href' => 'http://support.jawtemplates.com/gdaynews/web/documentation/goodday-news-magazine-settings/my-news/#user_account_front',
'title' => 'documentation') )) ,
"desc" => "Select a page to which the options for defining content of user's interest will be attached.<br><br>NOTE: The page you select has to have chosen the <em>User manager</em> template in <strong>Page Attributes > Template</strong>.<br><br>NOTE: If user is not logged in, the register form will be displayed instead.",
    "id" => "user_account_pageid",
"std" => "_default",
"type" => "advselect",
'chosen' => 'true',
'target' => 'page'
);


$options[] = array(
'name' => 'Interested Items Settings'. " " . jwUtils::getHelp("", "", "mynews-interest-items.jpg", array( array(
'href' => 'http://support.jawtemplates.com/gdaynews/web/documentation/goodday-news-magazine-settings/my-news#InterestedItemsSettings',
'title' => 'documentation') )) ,
"type" => "sectionstart");



$options[] = array("name" => "Number of Posts in Interested Items Section",
"desc" => "Define a number of posts to be displayed in the Interested Items section (recently viewed posts) in My News Panel.",
"id" => "user_interest_posts",
"std" => '4',
"type" => "text",
'mod' => 'small'
);


$options[] = array("name" => "Number of Columns in Interested Items Section",
"desc" => "Select a number of columns in the Interested Items section (recently viewed posts).",
"id" => "user_interest_columns",
"std" => "2",
"type" => "select",
"options" => array(
"1" => "1",
"2" => "2",
"3" => "3",
"4" => "4",
"6" => "6")
);

$options[] = array(
'id' => 'user_interest_boxes_type',
'type' => 'layout',
'name' => 'Post Boxes Type in Interested Items Section',
'desc' => 'Select size of boxes for your posts. If the Mix option is chosen, only the latest post will be boxed in the Vertical size box.',
    'std' => 'vertical',
'options' => array(
'simple' => JAW_ADMIN_URI . 'assets/images/blog_boxes/simple.png',
'vertical-small' => JAW_ADMIN_URI . 'assets/images/blog_boxes/vertical-small.png',
'vertical' => JAW_ADMIN_URI . 'assets/images/blog_boxes/vertical.png',
'mix' => JAW_ADMIN_URI . 'assets/images/blog_boxes/mix.png'
)
);

$options[] = array(
    'id' => 'user_interest_title_h',
    'type' => 'toggle',
    'name' => 'Post Titles - H tag type in Interested Items Section',
    'desc' => '',
    'std' => '3',
    "builder" => 'true',
    "options" => array("1" => "h1", "2" => "h2", "3" => "h3")
);

$options[] = array("name" => "Post Title Length - Number of Characters in Interested Items Section",
"desc" => "Enter a number of characters in post titles. <strong>Enter -1 for use of default value by Theme Options.</strong>",
    "id" => "user_interest_letter_excerpt_title",
"std" => '-1',
"mod" => 'micro',
'maxlength' => 4,
"type" => "text"
);
$options[] = array("name" => "Post Excerpt Length - Number of Characters in Interested Items Section",
"desc" => "Enter a number of characters in the preview content.  <strong>Enter -1 for use of default value by Theme Options.</strong>",
    "id" => "user_interest_letter_excerpt",
"std" => '0',
"mod" => 'micro',
'maxlength' => 4,
"type" => "text"
);



$options[] = array(
"type" => "sectionend");



$options[] = array(
'name' => 'Interested Comments'. " " . jwUtils::getHelp("", "", "mynews-interest-comments.jpg", array( array(
'href' => 'http://support.jawtemplates.com/gdaynews/web/documentation/goodday-news-magazine-settings/my-news#InterestedComments',
'title' => 'documentation') )) ,
"type" => "sectionstart");

$options[] = array("name" => "Number of Posts in Interested Comments Section",
"desc" => "Define a number of posts to be displayed in the Interested Comments section in My News Panel.",
"id" => "user_comments_number_posts",
"std" => '5',
"type" => "text",
'mod' => 'small'
);

$options[] = array(
"type" => "sectionend");


$options[] = array(
'name' => 'Reading List'. " " . jwUtils::getHelp("", "", "mynews-reading-list.jpg", array( array(
'href' => 'http://support.jawtemplates.com/gdaynews/web/documentation/goodday-news-magazine-settings/my-news#ReadingList',
'title' => 'documentation') )) ,
"type" => "sectionstart");

$options[] = array("name" => "Number of Posts in Reading List Section",
"desc" => "Define a number of posts to be displayed in the Reading List section in My News Panel.",
"id" => "user_reading_list_number_posts",
"std" => '5',
"type" => "text",
'mod' => 'small'
);

$options[] = array(
"name" => "Page with list of all posts from Reading List",
"desc" => "The Reading List shows just a number of posts you have defined in the previous option. In case of more posts added, a reader can see them on a page you select here.<br><br>NOTE: The page you select has to have chosen the <em>Reading List</em> template in <strong>Page Attributes > Template</strong>.",
"id" => "user_bar_reading_list_page",
"std" => "_default",
"type" => "advselect",
'chosen' => 'true',
'target' => 'page'
);

$options[] = array(
"type" => "sectionend");



$options[] = array(
'name' => 'History Section Settings'. " " . jwUtils::getHelp("", "", "mynews-history.jpg", array( array(
'href' => 'http://support.jawtemplates.com/gdaynews/web/documentation/goodday-news-magazine-settings/my-news#HistorySectionSettings',
'title' => 'documentation') )) ,
"type" => "sectionstart");



$options[] = array("name" => "Number of Posts in History Section",
"desc" => "Define a number of posts to be displayed in the history section (recently viewed posts) in the My News Panel.",
"id" => "user_history_posts",
"std" => '3',
"type" => "text",
'mod' => 'small'
);

$options[] = array("name" => "Number of Columns in History Section",
"desc" => "Select a number of columns in the history section (recently viewed posts).",
"id" => "user_history_columns",
"std" => "3",
"type" => "select",
"options" => array(
"1" => "1",
"2" => "2",
"3" => "3",
"4" => "4",
"6" => "6")
);

$options[] = array(
'id' => 'user_history_boxes_type',
'type' => 'layout',
'name' => 'Post Boxes Type in History Section',
'desc' => 'Select size of boxes for your posts. If the Mix option is chosen, only the latest post will be boxed in the Vertical size box.',
    'std' => 'vertical',
'options' => array(
'simple' => JAW_ADMIN_URI . 'assets/images/blog_boxes/simple.png',
'vertical' => JAW_ADMIN_URI . 'assets/images/blog_boxes/vertical.png',
'vertical-small' => JAW_ADMIN_URI . 'assets/images/blog_boxes/vertical-small.png',
'mix' => JAW_ADMIN_URI . 'assets/images/blog_boxes/mix.png'
)
);

$options[] = array(
    'id' => 'user_history_title_h',
    'type' => 'toggle',
    'name' => 'Post Titles - H tag type in History Section',
    'desc' => '',
    'std' => '3',
    "builder" => 'true',
    "options" => array("1" => "h1", "2" => "h2", "3" => "h3")
);

$options[] = array("name" => "Post Title Length - Number of Characters in History Section",
"desc" => "Enter a number of characters in post titles. <strong>Enter -1 for use of default value by Theme Options.</strong>",
    "id" => "user_history_letter_excerpt_title",
"std" => '-1',
"mod" => 'micro',
'maxlength' => 4,
"type" => "text"
);
$options[] = array("name" => "Post Excerpt Length - Number of Characters in History Section",
"desc" => "Enter a number of characters in the preview content.  <strong>Enter -1 for use of default value by Theme Options.</strong>",
    "id" => "user_history_letter_excerpt",
"std" => '-1',
"mod" => 'micro',
'maxlength' => 4,
"type" => "text"
);



$options[] = array(
"type" => "sectionend");
// 


$options[] = array("type" => "headingend");



/* End My News************************************************ */


/* Posts settings ************************************************************* */
$options[] = array(
"name" => "Posts Settings",
"type" => "headingstart"
);


$options[] = array(
'id' => 'archive_preset',
'type' => 'options_preset',
'name' => '<i class="jaw-icon-stack-list jaw-preset-icon"></i> Search/Archive/Tags/Author Preset',
'desc' => "Create new preset or select an existing one.<br><br>The preset will be applied when search, archives or tags are displayed, and will be used as default for categories (if the category does not have set any preset).",
    'target' => 'category',
);


$options[] = array("name" => "After Cut Text",
"desc" => "Enter a text to be shown after cut text (e.g. ...).",
"id" => "excerpt_text",
"std" => '...',
"type" => "text",
'mod' => 'small'
);

$options[] = array(
'id' => 'show_readmore',
'type' => 'toggle',
'name' => 'Show Readmore Link',
'desc' => '',
'std' => '0',
"options" => array("0" => "Off", "1" => "On")
);

$options[] = array("name" => "Readmore Link Text",
"desc" => "Enter a text to be shown after post excerpt (e.g. Read more).",
"id" => "readmore_text",
"std" => 'Read more',
"type" => "text",
"ng-class" => "{'jw-disabled': edit['show_readmore']=='0'}",
'mod' => 'small'
);



$options[] = array("type" => "headingend");

/* BLOG ********************************************************************* */
$options[] = array(
"name" => "Main Blog",
"type" => "headingstart"
);

//  
$options[] = array(
"name" => "Blog info",
"id" => "blog-info",
"text" => '<i class="jaw-icon-warning"></i><strong> These settings take effect just on home page and only if you have set <b>Settings > Reading > Front page displays > Your latest posts</b></strong>.',
    "type" => "info",
"space" => false,
"message" => "info"
);

$options[] = array(
'id' => 'blog_preset',
'type' => 'options_preset',
'name' => '<i class="jaw-icon-stack-list jaw-preset-icon"></i> Main Blog Preset',
'desc' => 'Create new preset or select an existing one.<br><br>The preset will be applied when search, archives and tags are displayed, and will be used as default for categories (if the category does not have set any preset).',
    'target' => 'category',
);

$options[] = array(
'id' => 'blog_cat',
'type' => 'multidropdown',
'name' => 'Include Category',
'desc' => 'Choose the post categories you want to fetch posts from.',
"std" => '',
"page" => null,
"mod" => 'big',
"chosen" => "true",
"target" => 'cat',
"prompt" => "Choose category..",
);

$options[] = array(
'id' => 'blog_order',
'type' => 'select',
'name' => 'Post Order',
'desc' => 'Posts order (ascending or descending).',
'std' => 'desc',
'mod' => 'medium',
'options' => array("desc" => "Desc", "asc" => "Asc")
);

$options[] = array(
'id' => 'blog_orderby',
'type' => 'select',
'name' => 'Post Order by',
'desc' => 'Order posts by parameters. Help on <a target="_blank" href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters">Order by Parameters</a>',
'std' => 'date',
'mod' => 'medium',
'options' => array("date" => "Date", "none" => "None", "ID" => "ID",
"author" => "Author", "title" => "Title", "modified" => "Modified",
"parent" => "Parent", "rand" => "Rand", "comment_count" => "Comments count")
);
// 

$options[] = array("type" => "headingend");
/* BLOG END ***************************************************************** */

/* SINGLE POST ************************************************************** */
$options[] = array("name" => "Single Post",
"type" => "headingstart"
);
//  
$options[] = array(
'id' => 'single_preset',
'type' => 'options_preset',
'name' => '<i class="jaw-icon-file jaw-preset-icon"></i> Single Post Preset',
'desc' => 'Create new preset or select an existing one.<br><br>The preset will be applied when search, archives or tags are displayed, and will be used as default for categories (if the category does not have set any preset).',
    'target' => 'single',
);
    $options[] = array(
    'id' => 'post_use_user_likes',
    'type' => 'toggle',
    'name' => 'Use User Likes',
    'desc' => 'Decide whether or not to use User Likes.',
    'std' => '1',
    "options" => array("0" => "Off", "1" => "On")
    );

    $options[] = array(
    'id' => 'featured_image_caption',
    'type' => 'toggle',
    'name' => 'Use Caption Below Featured Image',
    'desc' => 'Decide whether or not to use caption below featured image.',
    'std' => '0',
    "options" => array("0" => "Off", "1" => "On")
    );

    $options[] = array(
    'id' => 'showup_video',
    'type' => 'toggle',
    'name' => 'Stick Video',
    'desc' => 'Decide whether or not to use stick video after scrolling.',
    'std' => '1',
    "options" => array("0" => "Off", "1" => "On")
    );

$options[] = array(
'id' => 'related_post_primary_source',
'type' => 'toggle',
'name' => 'Primary Source for Related Posts',
    'desc' => 'Specify a primary source for related posts.<br><br><strong>Category</strong> - picks posts from those that share at least one category with a current post.<br><br><strong>Tag</strong> - picks posts from those that include at least one the same tag as a current post.',
        'std' => 'cats',
    'options' => array('cats'=> 'Category', 'tags' => 'Tag')
    );

    $options[] = array(
    'id' => 'showup_post',
    'type' => 'toggle',
    'name' => 'Show Up Advanced Post Suggestion',
    'desc' => 'Decide whether or not to use show up post suggestion at the end of the single post.',
    'std' => '0',
    "options" => array("0" => "Off", "1" => "On")
    );


    $options[] = array(
    "name" => "Previous & Next Post Navigation",
    "desc" => "Previous & Next Navigation Settings",
    "type" => "sectionstart");

    $options[] = array(
    'id' => 'prevnextnav_show',
    'type' => 'toggle',
    'name' => 'Show Previous & Next Post Navigation',
    'desc' => 'Decide whether or not to show Previous & Next Post Navigation.',
    'std' => 'true',
    "options" => array("false" => "Hide", "true" => "Show")
    );

    $options[] = array("name" => "Post Title Excerpt",
    "desc" => "Enter a number of characters for your previous & next navigation post titles.",
        "id" => "prevnextnav_excerpt_title",
    "std" => 50,
    "mod" => 'micro',
    'maxlength' => 4,
    "ng-class" => "{'jw-disabled': edit['prevnextnav_show']!='true'}",
    "type" => "text"
    );

    $options[] = array("name" => "Thumbnails",
    "desc" => "Decide whether or not to show thumbnails in previous & next navigation.",
    "id" => "prevnextnav_thumbs",
    'std' => '1',
    'mod' => 'medium',
    "ng-class" => "{'jw-disabled': edit['prevnextnav_show']!='true'}",
    "type" => "toggle"
    );

    $options[] = array("name" => "Meta",
    "desc" => "Decide whether or not to show meta in previous & next navigation.",
    "id" => "prevnextnav_meta",
    'std' => '1',
    'mod' => 'medium',
    "ng-class" => "{'jw-disabled': edit['prevnextnav_show']!='true'}",
    "type" => "toggle"
    );

    $options[] = array(
    "type" => "sectionend"
    );

    $mashare_text="";
    if($sharing) {
        $mashare_text='<i class="jaw-icon-info"></i><span style="color:red"> You have activated Mashshare Plugin. If you want use this option, please disable that plugin <a target="_blank" href="'.admin_url('plugins.php').'">here</a>.</span>';
    } else {
        $mashare_text='<i class="jaw-icon-info"></i> Select the social networks or services whose icons have to be added to the Share Post Bar.';
    }

    $options[] = array(
    "name" => "<i class='jaw-icon-share2'></i> Sharing Options",
    "desc" => $mashare_text,
    "type" => "sectionstart");

    $options[] = array(
    "name" => "Instagram info",
    "id" => "Instagram-info",
    "text" => $mashare_text,
    "type" => "info",
    "space" => false,
    "message" => "info"
    );

    $options[] = array(
    'id' => 'post_share_tw',
    'type' => 'toggle',
    'name' => '<i class="jaw-icon-twitter3"></i> Share Post on Twitter',
    'std' => '1',
    'mod' => 'medium',
    "class" => $sharing ? "jw-disabled" : ""
    );

    $options[] = array(
    'id' => 'post_share_fb',
    'type' => 'toggle',
    'name' => '<i class="jaw-icon-facebook4"></i> Share Post on Facebook',
    'std' => '1',
    'mod' => 'medium',
    "class" => $sharing ? "jw-disabled" : ""
    );

    $options[] = array(
    'id' => 'post_share_g',
    'type' => 'toggle',
    'name' => '<i class="jaw-icon-google-plus4"></i> Share Post on Google',
    'std' => '1',
    'mod' => 'medium',
    "class" => $sharing ? "jw-disabled" : ""
    );

    $options[] = array(
    'id' => 'post_share_pi',
    'type' => 'toggle',
    'name' => '<i class="jaw-icon-pinterest"></i> Share Post on Pinterest',
    'std' => '1',
    'mod' => 'medium',
    "class" => $sharing ? "jw-disabled" : ""
    );
    $options[] = array(
    'id' => 'post_share_re',
    'type' => 'toggle',
    'name' => '<i class="jaw-icon-reddit3"></i> Share Post on Reddit',
    'std' => '1',
    'mod' => 'medium',
    "class" => $sharing ? "jw-disabled" : ""
    );
    $options[] = array(
    'id' => 'post_share_mail',
    'type' => 'toggle',
    'name' => '<i class="jaw-icon-mail4"></i> Share Post via E-mail',
    'std' => '1',
    'mod' => 'medium',
    "class" => $sharing ? "jw-disabled" : ""
    );

    $options[] = array(
    'id' => 'post_share_mail_content',
    'type' => 'text',
    'name' => '<i class="jaw-icon-mail4"></i> Default email address',
    'desc' => 'Enter a default email address you want to show.',
    'std' => 'youremail@addresshere.com',
    "class" => $sharing ? "jw-disabled" : ""
    );



    $options[] = array(
    "type" => "sectionend"
    );


    /* FB comments settings */
    $options[] = array(
    "name" => "<i class='jaw-icon-facebook4'></i>  Facebook Comments",
    "type" => "sectionstart"
    );

    $options[] = array(
    "name" => "Facebook Comments",
    "id" => "info-fb",
    "text" => "<i class='jaw-icon-warning'></i> Don't forget to enter your Facebook App ID in the Theme Options -> API keys section.",
    "type" => "info",
    "space" => false,
    "message" => "info"
    );

    $options[] = array(
    'id' => 'fbcomments_switch',
    'type' => 'toggle',
    'name' => 'Facebook Comments',
    'desc' => 'Turn On the option to enable Facebook comments. If it is off, the Wordpress comments will be used.',
    'std' => '0'
    );

    $options[] = array(
    'id' => 'fbcomments_nuberofcomments',
    'type' => 'text',
    'name' => 'Number of Comments',
    'desc' => 'Enter a number of comments to be displayed.',
    'std' => "5",
    'mod' => 'mini'
    );

    $options[] = array("type" => "sectionend");


    $options[] = array(
    "name" => "Comments Antispam Question ",
    "type" => "sectionstart");


    $options[] = array(
    'id' => 'comments_antispam_toggle',
    'type' => 'toggle',
    'name' => 'Enable an Antispam Question',
    'desc' => 'Turn on this option to add an antispam question to comment box.',
    'std' => '0'
    );

    $options[] = array(
    'id' => 'comments_antispam_question',
    'type' => 'text',
    'mod' => 'large',
    'name' => 'Comments Antispam Question',
    'desc' => 'Fill in the field with a question to be answered by user before inserting comment.',
    'std' => "1+1=",
    );

    $options[] = array(
    'id' => 'comments_antispam_answer',
    'type' => 'text',
    'mod' => 'large',
    'name' => 'Comments Antispam Answer',
    'desc' => 'Insert a proper answer to the question above.',
    'std' => "2",
    );

    $options[] = array(
    "type" => "sectionend");


    $options[] = array(
    "name" => "<i class='jaw-icon-star3'></i> Rating Settings",
    "type" => "sectionstart"
    );

    $options[] = array(
    'id' => 'rating_maximal_value',
    'type' => 'toggle',
    'name' => 'Rating Values',
    'desc' => 'Select how to display ratings. You can choose from a decimal number with max. value 5 or 10, and percentage rating.<br><br><strong>IMPORTANT:</strong> In all cases, even if you have selected [0-5] or [0-10] option, it is necessary to enter values from 0 to 100 when you rate a post.<br><br><strong>NOTE:</strong> The maximum value after the slash (if [0-5] or [0-10] option selected) will or will not be displayed depending on your choice in the next option.',
        'std' => '10',
    'options' => array(
    '5' => '0 - 5',
    '10' => '0 - 10',
    '100' => '0% - 100%')
    );

    $options[] = array(
    'id' => 'rating_maximal_value_show',
    'type' => 'toggle',
    'name' => 'Show Maximal Rating Value',
    'desc' => 'Show maximal rating value after the slash, e.g. 4.2<strong>/5</strong> or 8.9<strong>/10</strong>.',
    'std' => '1',
    "ng-class" => "{'jw-disabled': edit['rating_maximal_value']=='100'}",
    'options' => array(
    '0' => 'Off',
    '1' => 'On')
    );

    $options[] = array("type" => "sectionend");

    $options[] = array(
    "name" => "<i class='jaw-icon-twitter'></i> Tweet the Content",
    "type" => "sectionstart"
    );

    $options[] = array(
    'id' => 'tweet_me',
    'type' => 'toggle',
    'name' => 'Tweet Me',
    'desc' => 'Enable or Disable to show tweet button after highlighted text in the single post content. You can use our default image located in <span style="color: red">../gdaynews/images/tweetme.jpg</span>',
    'std' => '0',
    'options' => array(
    '0' => 'Off',
    '1' => 'On')
    );

    $options[] = array(
    'id' => 'tweet_me_img',
    'name'=> "Button Image",
    "desc" => "Upload a 75px &times; 28px PNG/GIF/JPG image that will represent your tweet me button.",
    "std" => "",
    "type" => "upload",
    "ng-class" => "{'jw-disabled': edit['tweet_me']=='0'}"
    );

    $options[] = array("type" => "sectionend");
// 
    $options[] = array("type" => "headingend");
    /* SINGLE END *************************************************************** */

    /* GALLERY SETTINGS START ********************************************************** */
    if (is_plugin_active('jaw-customposts/jawcustomposts.php')) {
        $options[] = array("name" => "JaW Gallery Settings",
        "type" => "headingstart");


        $options[] = array(
        'id' => 'media_gallery_color',
        'type' => 'select_preset',
        "target" => "color",
        'name' => '<i class="jaw-icon-palette jaw-preset-icon"></i> Gallery Color Scheme' .jwUtils::getHelp("", "", "gallery.jpg"),
        'desc' => "Select a color scheme from this list of those you have created in <strong>Styling Options > Main Color Scheme</strong>.<br><br>DEFAULT: <a href='#of-option-colorsettings' class='jaw-goto-colorsettings' data-goto='colorsettings' data-highlight='main_color'><strong>Theme Options -> Styling Options -> Collor Settings -> Main Color Scheme</strong></a>",
        'std' => 'blue',
        );
        $options[] = array("name" => "Embedded Icon"." ".jwUtils::getHelp("", "", "embed_image.jpg"),
        "desc" => "Upload a square PNG/GIF icon that will represent content of the items (another than e.g. images or video) you put in your gallery via iframe.",
        "id" => "gallery_embed_pic",
        "std" => '',
        "type" => "simple_media_picker");




        $options[] = array("type" => "headingend");
    }
    /* GALLERY SETTINGS END ********************************************************** */


    /* BuddyPress SETTINGS START ********************************************************** */
    if (class_exists('BuddyPress')) {
        $options[] = array(
            "name" => "BuddyPress",
            "type" => "headingstart"
        );


        $options[] = array(
            "name" => "BuddyPress Layout",
            "desc" => "Choose one of the preset layouts for your BuddyPress. ",
            "id" => "buddy_press_layout",
            "std" => 'fullwidth',
            "type" => "layout",
            "options" => array(
            'fullwidth' => JAW_ADMIN_URI . 'assets/images/no_sidebar.gif',
            'left1' => JAW_ADMIN_URI . 'assets/images/left_sidebar.gif',
            'right1' => JAW_ADMIN_URI . 'assets/images/right_sidebar.gif',
            'right1_left1' => JAW_ADMIN_URI . 'assets/images/right_left_sidebar.gif',
            'right1_right2' => JAW_ADMIN_URI . 'assets/images/right_right_sidebar.gif',
            'left1_left2' => JAW_ADMIN_URI . 'assets/images/left_left_sidebar.gif')
        );

        $options[] = array(
            "name" => "Left sidebar",
            "type" => "sectionstart",
            "ng-show" => "edit['buddy_press_layout']=='left1_left2' || edit['buddy_press_layout']=='right1_left1' || edit['buddy_press_layout']=='left1'"
        );


        $options[] = array(
            'id' => 'buddy_press_sidebar_left1',
            'type' => 'sidebar_select',
            'name' => 'BuddyPress Left Sidebar',
            'desc' => 'Select an optional sidebar from the list of those you have created in <br>Sidebar Manager</b>.',
            'mod' => 'medium'
        );
        $options[] = array(
            'id' => 'buddy_press_sidebar_left1_size',
            'name' => 'Size',
            'desc' => '',
            "std" => '3',
            "type" => "select",
            "options" => $sb_size
        );

        $options[] = array(
            'id' => 'buddy_press_sidebar_left1_color',
            'name' => '<i class="jaw-icon-palette jaw-preset-icon"></i> Color',
            'desc' => "DEFAULT: <a href='#of-option-colorsettings' class='jaw-goto-colorsettings' data-goto='colorsettings' data-highlight='main_color'><strong>Theme Options -> Styling Options -> Collor Settings -> Main Color Scheme</strong></a>",
            'type' => 'select_preset',
            "target" => "color"
        );
        $options[] = array(
            'id' => 'buddy_press_sidebar_left1_header_style',
            'type' => 'layout',
            'name' => 'Sidebars Individual Style',
            'desc' => 'Select the heading style of custom sidebars you prefer. Click the preview icon to see where the setting appears. <span class="jaw-default">Default: Theme Options -> Posts Settings -> Search/Archive/Category Layout</span>',
            'std' => '_default',
            "options" => $header_styles_img_default
        );

        $options[] = array(
            "type" => "sectionend"
        );

        $options[] = array(
            "name" => "Left 2 sidebar",
            "type" => "sectionstart",
            "ng-show" => "edit['buddy_press_layout']=='left1_left2'"
        );

        $options[] = array(
            'id' => 'buddy_press_sidebar_left2',
            'type' => 'sidebar_select',
            'name' => 'BuddyPress Left Sidebar',
            'desc' => 'Select an optional sidebar from the list of those you have created in <br>Sidebar Manager</b>.',
            'std' => null,
            'mod' => 'medium'
        );

        $options[] = array(
            'id' => 'buddy_press_sidebar_left2_size',
            'name' => 'Size',
            'desc' => '',
            "std" => '3',
            "type" => "select",
            "options" => $sb_size
        );

        $options[] = array(
            'id' => 'buddy_press_sidebar_left2_color',
            'name' => '<i class="jaw-icon-palette jaw-preset-icon"></i> Color',
            'desc' => "DEFAULT: <a href='#of-option-colorsettings' class='jaw-goto-colorsettings' data-goto='colorsettings' data-highlight='main_color'><strong>Theme Options -> Styling Options -> Collor Settings -> Main Color Scheme</strong></a>",
            "std" => '_default',
            'type' => 'select_preset',
            "target" => "color"
        );

        $options[] = array(
            'id' => 'buddy_press_sidebar_left2_header_style',
            'type' => 'layout',
            'name' => 'Sidebars Individual Style',
            'desc' => 'Select the heading style of custom sidebars you prefer. Click the preview icon to see where the setting appears. <span class="jaw-default">Default: Theme Options -> Posts Settings -> Search/Archive/Category Layout</span>',
            'std' => '_default',
            "options" => $header_styles_img_default
        );

        $options[] = array(
            "type" => "sectionend"
        );


        $options[] = array(
            "name" => "Right sidebar",
            "type" => "sectionstart",
            "ng-show" => "edit['buddy_press_layout']=='right1_right2' || edit['buddy_press_layout']=='right1_left1' || edit['buddy_press_layout']=='right1'"
        );

        $options[] = array(
            'id' => 'buddy_press_sidebar_right1',
            'type' => 'sidebar_select',
            'name' => 'BuddyPress Right Sidebar',
            'desc' => 'Select an optional sidebar from the list of those you have created in <br>Sidebar Manager</b>.',
            'std' => null,
            'mod' => 'medium'
        );

        $options[] = array(
            'id' => 'buddy_press_sidebar_right1_size',
            'name' => 'Size',
            'desc' => '',
            "std" => '3',
            "type" => "select",
            "options" => $sb_size
        );

        $options[] = array(
            'id' => 'buddy_press_sidebar_right1_color',
            'name' => '<i class="jaw-icon-palette jaw-preset-icon"></i> Color',
            'desc' => "DEFAULT: <a href='#of-option-colorsettings' class='jaw-goto-colorsettings' data-goto='colorsettings' data-highlight='main_color'><strong>Theme Options -> Styling Options -> Collor Settings -> Main Color Scheme</strong></a>",
            "std" => '_default',
            'type' => 'select_preset',
            "target" => "color"
        );

        $options[] = array(
            'id' => 'sidebar_right1_header_style',
            'type' => 'layout',
            'name' => 'Sidebars Individual Style',
            'desc' => 'Select the heading style of custom sidebars you prefer. Click the preview icon to see where the setting appears. <span class="jaw-default">Default: Theme Options -> Posts Settings -> Search/Archive/Category Layout</span>',
            'std' => '_default',
            "options" => $header_styles_img_default
        );

        $options[] = array(
            "type" => "sectionend"
        );

        $options[] = array(
            "name" => "Right 2 sidebar",
            "type" => "sectionstart",
            "ng-show" => "edit['buddy_press_layout']=='right1_right2'"
        );


        $options[] = array(
            'id' => 'buddy_press_sidebar_right2',
            'type' => 'sidebar_select',
            'name' => 'BuddyPress Right 2 Sidebar',
            'desc' => 'Select an optional sidebar from the list of those you have created in <br>Sidebar Manager</b>.',
            'std' => null,
            'mod' => 'medium'
        );

        $options[] = array(
            'id' => 'buddy_press_sidebar_right2_size',
            'name' => 'Size',
            'desc' => '',
            "std" => '3',
            "type" => "select",
            "options" => $sb_size
        );

        $options[] = array(
            'id' => 'buddy_press_sidebar_right2_color',
            'name' => '<i class="jaw-icon-palette jaw-preset-icon"></i> Color',
            'desc' => "DEFAULT: <a href='#of-option-colorsettings' class='jaw-goto-colorsettings' data-goto='colorsettings' data-highlight='main_color'><strong>Theme Options -> Styling Options -> Collor Settings -> Main Color Scheme</strong></a>",
            "std" => '_default',
            'type' => 'select_preset',
            "target" => "color"
        );

        $options[] = array(
            'id' => 'buddy_press_sidebar_right2_header_style',
            'type' => 'layout',
            'name' => 'Sidebars Individual Style',
            'desc' => 'Select the heading style of custom sidebars you prefer. Click the preview icon to see where the setting appears. <span class="jaw-default">Default: Theme Options -> Posts Settings -> Search/Archive/Category Layout</span>',
            'std' => '_default',
            "options" => $header_styles_img_default
        );

        $options[] = array(
            "type" => "sectionend"
        );

        $options[] = array("type" => "headingend");
    }
    /* BuddyPress SETTINGS END ********************************************************** */

    /* SIDEBAR MANAGER ********************************************************** */
    $options[] = array("name" => "Sidebar Manager",
    "type" => "headingstart");
//  
    $options[] = array(
    'id' => 'sidebars',
    'type' => 'sidebars',
    'name' => 'Custom Sidebars',
    'desc' => 'Here you can add some optional sidebars.<br><br>Type the name of your new sidebar and click the Add New Sidebar. Repeat these steps as needed.',
    'std' => null
    );

    $options[] = array(
    'id' => 'sidebars_bar_type',
    'type' => 'layout',
    'name' => 'Sidebars Individual Style',
    'desc' => 'Select the heading style of custom sidebars you prefer. Click a preview icon to see where the setting appears. <span class="jaw-default">Default: General Settings > Global > Global Header Style</span>',
    'std' => 'bar_type_3',
    "options" => $header_styles_img_default
    );

    $options[] = array(
    'id' => 'fixed_sidebars',
    'type' => 'toggle',
    'name' => 'Fixed Sidebar when Scrolling',
    'desc' => 'When user scrolls down the page, the sidebar will be sticked to the bottom of a browser window.',
        'std' => 'fixed_off',
    'options' => array('fixed_off' => 'Off', 'fixed_on' => 'On')
    );
// 

    $options[] = array("type" => "headingend");
    /* SIDEBAR MANAGER END ****************************************************** */

    /* STYLING ****************************************************************** */
    $options[] = array("name" => "Background Style",
    "type" => "headingstart");

//  
    $options[] = array("name" => "Background Image",
    "desc" => "Click the Upload button to select and upload your background image.",
    "id" => "background_image",
    "std" => "",
    "mod" => "big",
    "type" => "upload");


    $options[] = array(
    'id' => 'background_image_size',
    'type' => 'toggle',
    'name' => 'Background Image Size',
    'desc' => 'Choose a way to apply a background image. <br><br>NOTE: Result will vary depending on your selection in the "Background Image Repeat".',
    'std' => 'cover',
    'options' => array('auto' => 'Original image size', 'cover' => 'Stretch to Fullscreen') //'contain' => 'Contain', - asi zbytecna moznost
    );

    $options[] = array(
    'id' => 'background_image_repeat',
    'type' => 'toggle',
    'name' => 'Background Image Repeat',
    'desc' => 'Choose whether or not to repeat a background image.',
    'std' => 'no-repeat',
    'options' => array('no-repeat' => 'No repeat', 'repeat' => 'Repeat')
    );

    $options[] = array(
    'id' => 'background_image_attachment',
    'type' => 'toggle',
    'name' => 'Background Image Style',
    'desc' => 'Choose whether to allow scrolling a background image or to set it fixed.',
    'std' => 'fixed',
    'options' => array('scroll' => 'Scroll', 'fixed' => 'Fixed')
    );

    $options[] = array(
    'id' => 'background_image_pattern',
    'type' => 'toggle',
    'name' => 'Pattern Over Background Image',
    'desc' => 'Choose a pattern to be applied over a background image, or disable any pattern.',
    'std' => 'no-pattern',
    'options' => array('no-pattern' => 'Off', 'pattern' => 'Dark Pattern', 'white-pattern' => 'Bright Pattern')
    );

    $bg_images_url = get_template_directory_uri() . '/images/bg_texture/';
    $bg_images = jwUtils::fileLoader(JAW_THEME_DIR . '/images/bg_texture/', array('.png', '.jpg'), $bg_images_url );

    $options[] = array("name" => "Background Texture",
    "desc" => "Choose a background texture. If you select the cross filled box, no texture will be used.",
    "id" => "background_texture",
    "std" => "none.png",
    "type" => "tiles",
    "options" => array_merge(array('none.png' => "No pattern"),(array) $bg_images),
    );

    $options[] = array("name" => "Background Color",
    "desc" => "Pick a custom background color for the theme.",
    "id" => "body_background_clr",
    "format" => "rgba",
    "std" => "#fafafa",
    "type" => "color");

    $options[] = array("name" => "Box Background Color",
    "desc" => "Pick a custom background color for a box with the main content.",
    "id" => "body_box_background_clr",
    "format" => "rgba",
    "std" => "#ffffff",
    "type" => "color");
// 

    $options[] = array("type" => "headingend");

//  
    $options[] = array("name" => "Color Settings",
    "type" => "headingstart");

    $options[] = array(
    "name" => "Color scheme settings",
    "id" => "color-info",
    "text" => '<h3>Color scheme settings</h3> Here you can define all colors of your site. The colors are defined by color schemes that you can manage in "Color Settings > Color Schemes" section below. Each scheme can be related to each part of the theme (Header, menu, category, sidebar, ...). You can simply recognize it by this icon: <i class="jaw-icon-palette jaw-preset-icon"></i>',
    "type" => "info",
    "space" => false,
    "message" => "info"
    );

    $options[] = array(
    'id' => 'main_color',
    'type' => 'select_preset',
    'name' => '<i class="jaw-icon-palette jaw-preset-icon"></i> Main Color Scheme',
    'desc' => 'This is the <strong>Main</strong> setting of color palette. If some part of the theme hasn`t set its color scheme, this one will be used.',
    'std' => 'blue',
    "target" => "color",
    "default-opt" => "Choose Scheme",
    );

    $options[] = array(
    "name" => "Color Settings".jwUtils::getHelp("Color Settings", "", "", array( array(
    'href' => 'http://support.jawtemplates.com/gdaynews/web/?p=1013',
    'title' => 'documentation') )),
    "type" => "sectionstart");

    $options[] = array(
    "name" => "Predefined Color Schemes",
    "text" => "<b>Open the section and click color scheme for add it into your <i class='jaw-icon-palette jaw-preset-icon'></i> Color Schemes</b>",
    "type" => "info");


    $options[] = array("name" => "Color Scheme from Lifestyle Demo",
    "id" => "template_lifestyle_main_color",
    "type" => "load_color_presets",
    "for" => "jaw_color_preset",
    "class" => "fullwidth-option hide-title",
    "options" => array(
    array(
    "title" => "Lifestyle main","background" => "#ffffff","theme1" => "rgba(235,80,75,1)","theme2" => "rgba(61,61,61,1)","theme3" => "#ffffff","border" => "#dcdcdc","text" => "rgba(48,48,48,1)","meta" => "#929292","link" => "rgba(61,61,61,1)","hover" => "rgba(235,80,75,1)","input" => "#444444","input_bg" => "#ffffff","alternative_background" => "#F1F1F1","text_link" => "rgba(235,80,75,1)","text_hover" => "rgba(61,61,61,1)"
    ),
    array(
    "title" => "Lifestyle menu","background" => "rgba(61,61,61,1)","theme1" => "rgba(235,80,75,1)","theme2" => "rgba(255,255,255,1)","theme3" => "#ffffff","border" => "#dcdcdc","text" => "rgba(255,255,255,1)","meta" => "#929292","link" => "rgba(255,255,255,1)","hover" => "rgba(235,80,75,1)","input" => "#444444","input_bg" => "#ffffff","alternative_background" => "#F1F1F1","text_link" => "rgba(235,80,75,1)","text_hover" => "rgba(255,255,255,1)"
    ),
    array(
    "title" => "Lifestyle topbar","background" => "rgba(235,80,75,1)","theme1" => "rgba(255,255,255,1)","theme2" => "rgba(235,80,75,1)","theme3" => "rgba(235,80,75,1)","border" => "rgba(255,255,255,1)","text" => "rgba(255,255,255,1)","meta" => "rgba(255,255,255,1)","link" => "rgba(255,255,255,1)","hover" => "rgba(247,247,247,1)","input" => "rgba(255,255,255,1)","input_bg" => "#ffffff","alternative_background" => "#F1F1F1","text_link" => "#444444","text_hover" => "rgba(255,255,255,1)"
    ),
    array(
    "title" => "Lifestyle Sidebar","background" => "rgba(230,230,230,1)","theme1" => "rgba(235,80,75,1)","theme2" => "#535353","theme3" => "#ffffff","border" => "#dcdcdc","text" => "#929292","meta" => "#929292","link" => "#444444","hover" => "#535353","input" => "#444444","input_bg" => "#ffffff","alternative_background" => "#F1F1F1","text_link" => "rgba(235,80,75,1)","text_hover" => "#444444"
    ),
    array(
    "title" => "Lifestyle footer","background" => "rgba(61,61,61,1)","theme1" => "rgba(235,80,75,1)","theme2" => "rgba(255,255,255,1)","theme3" => "rgba(61,61,61,1)","border" => "#dcdcdc","text" => "rgba(255,255,255,1)","meta" => "rgba(255,255,255,1)","link" => "rgba(255,255,255,1)","hover" => "rgba(235,80,75,1)","input" => "#444444","input_bg" => "#ffffff","alternative_background" => "rgba(122,122,122,1)","text_link" => "rgba(255,255,255,1)","text_hover" => "rgba(235,80,75,1)"
    ),
    array(
    "title" => "Lifestyle MyNews","background" => "rgba(237,237,237,1)","theme1" => "rgba(235,80,75,1)","theme2" => "rgba(61,61,61,1)","theme3" => "rgba(255,255,255,1)","border" => "#dcdcdc","text" => "#3d3d3d","meta" => "#929292","link" => "rgba(61,61,61,1)","hover" => "rgba(235,80,75,1)","input" => "#444444","input_bg" => "#ffffff","alternative_background" => "#F1F1F1","text_link" => "rgba(235,80,75,1)","text_hover" => "rgba(61,61,61,1)"
    ),
    array(
    "title" => "Lifestyle Gallery","background" => "rgba(31,31,31,1)","theme1" => "rgba(235,80,75,1)","theme2" => "rgba(31,31,31,1)","theme3" => "#ffffff","border" => "#dcdcdc","text" => "rgba(48,48,48,1)","meta" => "#929292","link" => "#444444","hover" => "rgba(235,80,75,1)","input" => "#444444","input_bg" => "#ffffff","alternative_background" => "#F1F1F1","text_link" => "rgba(235,80,75,1)","text_hover" => "#444444"
    ),
    array(
    "title" => "Lifestyle Slider","background" => "rgba(235,80,75,1)","theme1" => "rgba(255,255,255,1)","theme2" => "rgba(235,80,75,1)","theme3" => "rgba(255,255,255,1)","border" => "rgba(255,255,255,1)","text" => "rgba(255,255,255,1)","meta" => "rgba(255,255,255,1)","link" => "rgba(255,255,255,1)","hover" => "rgba(247,247,247,1)","input" => "rgba(255,255,255,1)","input_bg" => "#ffffff","alternative_background" => "#F1F1F1","text_link" => "#444444","text_hover" => "rgba(255,255,255,1)"
    ),
    array(
    "title" => "Lifestyle Blue category","background" => "#ffffff","theme1" => "rgba(58,115,224,1)","theme2" => "rgba(61,61,61,1)","theme3" => "#ffffff","border" => "#dcdcdc","text" => "rgba(48,48,48,1)","meta" => "#929292","link" => "rgba(61,61,61,1)","hover" => "rgba(58,115,224,1)","input" => "#444444","input_bg" => "#ffffff","alternative_background" => "#F1F1F1","text_link" => "rgba(58,115,224,1)","text_hover" => "rgba(58,115,224,1)"
    ),
    array(
    "title" => "Lifestyle Green category","background" => "#ffffff","theme1" => "rgba(55,171,74,1)","theme2" => "rgba(61,61,61,1)","theme3" => "#ffffff","border" => "#dcdcdc","text" => "rgba(48,48,48,1)","meta" => "#929292","link" => "rgba(61,61,61,1)","hover" => "rgba(55,171,74,1)","input" => "#444444","input_bg" => "#ffffff","alternative_background" => "#F1F1F1","text_link" => "rgba(55,171,74,1)","text_hover" => "rgba(55,171,74,1)"
    ),
    array(
    "title" => "Lifestyle breaking news","background" => "rgba(255,255,255,1)","theme1" => "rgba(235,80,75,1)","theme2" => "rgba(255,255,255,1)","theme3" => "#ffffff","border" => "#dcdcdc","text" => "rgba(43,43,43,1)","meta" => "#929292","link" => "rgba(43,43,43,1)","hover" => "rgba(235,80,75,1)","input" => "#444444","input_bg" => "#ffffff","alternative_background" => "#F1F1F1","text_link" => "rgba(255,255,255,1)","text_hover" => "rgba(255,255,255,1)"
    )
    ),
    );

$options[] = array("name" => "Color Scheme from Men's Maggazine Demo",
    "id" => "template_mensmag_main_color",
    "type" => "load_color_presets",
    "for" => "jaw_color_preset",
    "class" => "fullwidth-option hide-title",
    "options" => array(
    array(
    'background' => '#ffffff', 'theme1' => '#17343F', 'theme2' => '#0A242E', 'theme3' => '#ffffff', 'border' => '#dcdcdc', 'text' => '#111111', 'meta' => 'rgba(89,89,89,1)', 'link' => '#01354B', 'hover' => '#33607a', 'input' => '#0A242E', 'input_bg' => '#ffffff', 'title' => 'Men’s mag', 'alternative_background' => '#e8e8e8', 'text_link' => '#444444', 'text_hover' => '#009de0',
    ),
    array(
    'background' => 'rgba(255,255,255,0.46)', 'theme1' => 'rgba(235,76,30,1)', 'theme2' => '#ffffff', 'theme3' => '#ffffff', 'border' => 'rgba(0,0,0,1)', 'text' => '#ffffff', 'meta' => '#ffffff', 'link' => '#e7e6eb', 'hover' => 'rgba(0,0,0,1)', 'input' => '#e8e6e6', 'input_bg' => '#ffffff', 'title' => 'Men’s Mag - Slider', 'alternative_background' => '#F1F1F1', 'text_link' => '#ffffff', 'text_hover' => '#009de0',
    ),
    array(
    'background' => '#EEF3F6', 'theme1' => '#0D404F', 'theme2' => 'rgba(0,0,0,1)', 'theme3' => 'rgba(255,255,255,1)', 'border' => '#dcdcdc', 'text' => '#111111', 'meta' => 'rgba(97,97,97,1)', 'link' => '#01354B', 'hover' => '#33607a', 'input' => 'rgba(255,0,0,1)', 'input_bg' => '#ffffff', 'title' => 'Men’s Mag - sidebar', 'alternative_background' => '#ffffff', 'text_link' => '#444444', 'text_hover' => '#009de0',
    ),
    array(
    'background' => '#0A242E', 'theme1' => '#0d404f', 'theme2' => '#f0f0f0', 'theme3' => '#ffffff', 'border' => 'rgba(255,255,255,1)', 'text' => 'rgba(247,247,247,1)', 'text' => 'rgba(247,247,247,1)', 'meta' => '#ffffff', 'link' => 'rgba(255,255,255,1)', 'hover' => '#cfd4e8', 'input' => '#444444', 'input_bg' => '#ffffff', 'title' => 'Men’s Mag - menu, footer', 'alternative_background' => '#0A242E', 'text_link' => '#444444', 'text_hover' => '#009de0',
    ),
    array(
    'background' => '#ffffff', 'theme1' => '#D03322', 'theme2' => '#0A242E', 'theme3' => '#ffffff', 'border' => '#dcdcdc', 'text' => '#111111', 'meta' => 'rgba(89,89,89,1)', 'link' => '#01354B', 'hover' => '#33607a', 'input' => '#0A242E', 'input_bg' => '#ffffff', 'title' => 'Men’s Mag - The Geek', 'alternative_background' => '#e8e8e8', 'text_link' => '#444444', 'text_hover' => '#009de0',
    ),
    array(
    'background' => '#111111', 'theme1' => '#D03322', 'theme2' => '#D03322', 'theme3' => '#ffffff', 'border' => '#dcdcdc', 'text' => '#ffffff', 'meta' => 'rgba(89,89,89,1)', 'link' => '#f2f2f2', 'hover' => '#33607a', 'input' => '#0A242E', 'input_bg' => '#ffffff', 'title' => 'Men’s Mag - Gallery', 'alternative_background' => '#e8e8e8', 'text_link' => '#444444', 'text_hover' => '#009de0',
    ),
    array(
    'background' => '#ffffff', 'theme1' => '#E62117', 'theme2' => '#0A242E', 'theme3' => '#ffffff', 'border' => '#dcdcdc', 'text' => '#111111', 'meta' => 'rgba(89,89,89,1)', 'link' => '#01354B', 'hover' => '#33607a', 'input' => '#0A242E', 'input_bg' => '#ffffff', 'title' => 'Men’s Mag - YouTube', 'alternative_background' => '#e8e8e8', 'text_link' => '#444444', 'text_hover' => '#009de0',
    ),
    array(
    'background' => '#ffffff', 'theme1' => '#00ADEF', 'theme2' => '#0A242E', 'theme3' => '#ffffff', 'border' => '#dcdcdc', 'text' => '#111111', 'meta' => 'rgba(89,89,89,1)', 'link' => '#01354B', 'hover' => '#33607a', 'input' => '#0A242E', 'input_bg' => '#ffffff', 'title' => 'Men’s Mag - Vimeo', 'alternative_background' => '#e8e8e8', 'text_link' => '#444444', 'text_hover' => '#009de0',
    ),
    array(
    'background' => '#000000', 'theme1' => '#D03322', 'theme2' => '#0A242E', 'theme3' => '#ffffff', 'border' => 'rgba(255,255,255,1)', 'text' => '#ffffff', 'meta' => '#ffffff', 'link' => 'rgba(255,255,255,1)', 'hover' => '#008584', 'input' => '#444444', 'input_bg' => '#ffffff', 'title' => 'Men’s Mag - Video Channel - Grid', 'alternative_background' => '#0A242E', 'text_link' => '#444444', 'text_hover' => '#009de0',
    ),
    array(
    'background' => '#0A242E', 'theme1' => '#0d404f', 'theme2' => '#0A242E', 'theme3' => '#ffffff', 'border' => 'rgba(255,255,255,1)', 'text' => 'rgba(247,247,247,1)', 'meta' => '#ffffff', 'link' => 'rgba(255,255,255,1)', 'hover' => '#cfd4e8', 'input' => '#444444', 'input_bg' => '#ffffff', 'title' => 'Men’s Mag - Slider - submenu', 'alternative_background' => '#0A242E', 'text_link' => '#444444', 'text_hover' => '#009de0',
    ),
    ),
    );

    $options[] = array("name" => "Color Scheme from Fashion Demo",
    "id" => "template_fashion_main_color",
    "type" => "load_color_presets",
    "for" => "jaw_color_preset",
    "class" => "fullwidth-option hide-title",
    "options" => array(
    array(
    "title" => "Fashion Main","background" => "rgba(255,255,255,1)","theme1" => "#b18f6a","theme2" => "#7e664b","theme3" => "#ffffff","border" => "#dcdcdc","text" => "rgba(3,3,3,1)","meta" => "#929292","link" => "#7e664b","hover" => "#b18f6a","input" => "#444444","input_bg" => "#ffffff","alternative_background" => "#F1F1F1","text_link" => "#b18f6a","text_hover" => "#7e664b"
    ),
    array(
    "title" => "Fashion Menu","background" => "rgba(0,0,0,1)","theme1" => "#b18f6a","theme2" => "rgba(255,255,255,1)","theme3" => "rgba(255,255,255,1)","border" => "rgba(255,255,255,1)","text" => "rgba(255,255,255,1)","meta" => "#929292","link" => "rgba(255,255,255,1)","hover" => "#b18f6a","input" => "#444444","input_bg" => "#ffffff","alternative_background" => "#F1F1F1","text_link" => "#444444","text_hover" => "#b18f6a"
    ),
    array(
    "title" => "Fashion dark","background" => "#F1F1F1","theme1" => "#7e664b","theme2" => "#7e664b","theme3" => "rgba(255,255,255,1)","border" => "rgba(255,255,255,1)","text" => "rgba(3,3,3,1)","meta" => "#929292","link" => "rgba(3,3,3,1)","hover" => "#7e664b","input" => "#444444","input_bg" => "#ffffff","alternative_background" => "rgba(227,227,227,1)","text_link" => "#444444","text_hover" => "#7e664b"
    ),
    array(
    "title" => "Fashion grid","background" => "rgba(255,255,255,1)","theme1" => "#b18f6a","theme2" => "rgba(59,59,59,1)","theme3" => "#ffffff","border" => "#dcdcdc","text" => "rgba(255,255,255,1)","meta" => "rgba(242,242,242,1)","link" => "rgba(255,255,255,1)","hover" => "#b18f6a","input" => "#444444","input_bg" => "#ffffff","alternative_background" => "#F1F1F1","text_link" => "#444444","text_hover" => "#b18f6a"
    ),
    array(
    "title" => "Fashion Footer","background" => "rgba(43,43,43,1)","theme1" => "#b18f6a","theme2" => "#b18f6a","theme3" => "rgba(255,255,255,1)","border" => "rgba(255,255,255,1)","text" => "rgba(255,255,255,1)","meta" => "#929292","link" => "rgba(255,255,255,1)","hover" => "#b18f6a","input" => "rgba(255,255,255,1)","input_bg" => "#ffffff","alternative_background" => "#F1F1F1","text_link" => "#444444","text_hover" => "#b18f6a"
    ),
    array(
    "title" => "Fashion Gallery","background" => "#2b2b2b","theme1" => "#b18f6a","theme2" => "#191919","theme3" => "#ffffff","border" => "#dcdcdc","text" => "rgba(3,3,3,1)","meta" => "#929292","link" => "#7e664b","hover" => "#b18f6a","input" => "#444444","input_bg" => "#ffffff","alternative_background" => "#F1F1F1","text_link" => "#b18f6a","text_hover" => "#7e664b"
    ),
    array(
    "title" => "Fashion Breaking news","background" => "rgba(0,0,0,1)","theme1" => "#b18f6a","theme2" => "rgba(255,255,255,1)","theme3" => "rgba(255,255,255,1)","border" => "rgba(255,255,255,1)","text" => "rgba(255,255,255,1)","meta" => "#929292","link" => "rgba(255,255,255,1)","hover" => "rgba(224,224,224,1)","input" => "#444444","input_bg" => "#ffffff","alternative_background" => "#F1F1F1","text_link" => "#444444","text_hover" => "#b18f6a"
    ),
    ),
    );

    $options[] = array("name" => "Color Scheme from 27News Demo",
    "id" => "template_27news_main_color",
    "type" => "load_color_presets",
    "for" => "jaw_color_preset",
    "class" => "fullwidth-option hide-title",
    "options" => array(
    array(
    'name' => '15zine sidebar', 'background' => '#ffffff', 'theme1' => 'rgba(31,31,31,1)', 'theme2' => '#000000', 'theme3' => '#ffffff', 'border' => '#dcdcdc', 'text' => '#000000', 'meta' => '#8f8f8f', 'link' => 'rgba(31,31,31,1)', 'hover' => 'rgba(66,66,66,1)', 'input' => '#444444', 'input_bg' => '#ffffff', 'title' => '27News - main', 'alternative_background' => '#F1F1F1', 'text_link' => '#444444', 'text_hover' => '#009de0',
    ),
    array(
    'name' => '15zine sidebar', 'background' => '#ebebeb', 'theme1' => 'rgba(31,31,31,1)', 'theme2' => '#000000', 'theme3' => '#ffffff', 'border' => '#dcdcdc', 'text' => '#000000', 'meta' => '#8f8f8f', 'link' => 'rgba(31,31,31,1)', 'hover' => 'rgba(66,66,66,1)', 'input' => '#444444', 'input_bg' => '#ffffff', 'title' => '27News - sidebar', 'alternative_background' => '#F1F1F1', 'text_link' => '#444444', 'text_hover' => '#009de0',
    ),
    array(
    'name' => '15zine sidebar', 'background' => '#ffffff', 'theme1' => 'rgba(31,31,31,1)', 'theme2' => 'rgba(31,31,31,1)', 'theme3' => '#ffffff', 'border' => '#dcdcdc', 'text' => 'rgba(31,31,31,1)', 'meta' => 'rgba(31,31,31,1)', 'link' => 'rgba(31,31,31,1)', 'hover' => '#000000', 'input' => '#444444', 'input_bg' => '#ffffff', 'title' => '27News - menu', 'alternative_background' => '#F1F1F1', 'text_link' => '#444444', 'text_hover' => '#009de0',
    ),
    array(
    'name' => '15zine sidebar', 'background' => 'rgba(31,31,31,1)', 'theme1' => '#ffffff', 'theme2' => '#ffffff', 'theme3' => '#ffffff', 'border' => '#dcdcdc', 'text' => '#ffffff', 'meta' => '#ffffff', 'link' => '#ffffff', 'hover' => '#dedede', 'input' => '#444444', 'input_bg' => '#ffffff', 'title' => '27News - dark', 'alternative_background' => '#666666', 'text_link' => '#dedede', 'text_hover' => '#ffffff',
    ),
    array(
    'name' => '15zine sidebar', 'background' => 'rgba(31,31,31,1)', 'theme1' => '#ffffff', 'theme2' => '#595959', 'theme3' => '#ffffff', 'border' => '#dcdcdc', 'text' => '#ffffff', 'meta' => '#ffffff', 'link' => '#ffffff', 'hover' => '#dedede', 'input' => '#444444', 'input_bg' => '#ffffff', 'title' => '27News - Gallery', 'alternative_background' => '#666666', 'text_link' => '#dedede', 'text_hover' => '#ffffff',
    ),
    array(
    'name' => '15zine sidebar', 'background' => '#ebebeb', 'theme1' => 'rgba(31,31,31,1)', 'theme2' => '#000000', 'theme3' => '#ffffff', 'border' => '#dcdcdc', 'text' => '#000000', 'meta' => '#8f8f8f', 'link' => 'rgba(31,31,31,1)', 'hover' => '#8f8f8f', 'input' => '#444444', 'input_bg' => '#ffffff', 'title' => '27News - submenu', 'alternative_background' => '#F1F1F1', 'text_link' => '#444444', 'text_hover' => '#009de0',
    ),
    ),
    );

    $options[] = array("name" => "Color Scheme from FoodBlog Demo",
    "id" => "template_foodblog_main_color",
    "type" => "load_color_presets",
    "for" => "jaw_color_preset",
    "class" => "fullwidth-option hide-title",
    "options" => array(
    array(
    'title' => 'FoodBlog main', 'background' => 'rgba(255,255,255,1)', 'alternative_background' => '#F1F1F1', 'theme1' => 'rgba(0,0,0,1)', 'theme2' => 'rgba(0,0,0,1)', 'theme3' => '#ffffff', 'border' => '#dcdcdc', 'text' => '#2e2e2e', 'meta' => '#929292', 'link' => '#444444', 'hover' => 'rgba(194,177,62,1)', 'text_link' => 'rgba(194,177,62,1)', 'text_hover' => '#929292', 'input' => '#444444', 'input_bg' => '#ffffff',
    ),
    array(
    'title' => 'FoodBlog menu', 'background' => 'rgba(255,255,255,1)', 'alternative_background' => '#F1F1F1', 'theme1' => 'rgba(0,0,0,1)', 'theme2' => 'rgba(255,255,255,1)', 'theme3' => '#ffffff', 'border' => 'rgba(255,255,255,1)', 'text' => 'rgba(0,0,0,1)', 'meta' => '#929292', 'link' => 'rgba(0,0,0,1)', 'hover' => 'rgba(194,177,62,1)', 'text_link' => 'rgba(194,177,62,1)', 'text_hover' => 'rgba(0,0,0,1)', 'input' => '#444444', 'input_bg' => '#ffffff',
    ),
    array(
    'title' => 'FoodBlog footer', 'background' => 'rgba(0,0,0,1)', 'alternative_background' => '#9e9e9e', 'theme1' => 'rgba(255,255,255,1)', 'theme2' => '#ffffff', 'theme3' => '#000000', 'border' => 'rgba(255,255,255,1)', 'text' => '#ffffff', 'meta' => '#929292', 'link' => 'rgba(255,255,255,1)', 'hover' => 'rgba(194,177,62,1)', 'text_link' => 'rgba(194,177,62,1)', 'text_hover' => 'rgba(255,255,255,1)', 'input' => '#444444', 'input_bg' => '#ffffff',
    ),
    array(
    'title' => 'FoodBlog Sidebar', 'background' => '#e6e6e6', 'alternative_background' => '#F1F1F1', 'theme1' => 'rgba(0,0,0,1)', 'theme2' => 'rgba(0,0,0,1)', 'theme3' => '#ffffff', 'border' => '#dcdcdc', 'text' => '#929292', 'meta' => '#929292', 'link' => '#444444', 'hover' => 'rgba(194,177,62,1)', 'text_link' => 'rgba(194,177,62,1)', 'text_hover' => '#929292', 'input' => '#444444', 'input_bg' => '#ffffff',
    ),
    array(
    'title' => 'FoodBlog Gallery', 'background' => 'rgba(0,0,0,1)', 'alternative_background' => '#9e9e9e', 'theme1' => '#8f8f8f', 'theme2' => '#616161', 'theme3' => '#ffffff', 'border' => 'rgba(255,255,255,1)', 'text' => '#ffffff', 'meta' => '#929292', 'link' => 'rgba(255,255,255,1)', 'hover' => 'rgba(194,177,62,1)', 'text_link' => 'rgba(194,177,62,1)', 'text_hover' => 'rgba(255,255,255,1)', 'input' => '#444444', 'input_bg' => '#ffffff',
    ),
    array(
    'title' => 'FoodBlog submenu', 'background' => '#F1F1F1', 'alternative_background' => '#F1F1F1', 'theme1' => 'rgba(0,0,0,1)', 'theme2' => 'rgba(0,0,0,1)', 'theme3' => 'rgba(255,255,255,1)', 'border' => 'rgba(0,0,0,1)', 'text' => 'rgba(0,0,0,1)', 'meta' => '#929292', 'link' => 'rgba(0,0,0,1)', 'hover' => 'rgba(194,177,62,1)', 'text_link' => 'rgba(194,177,62,1)', 'text_hover' => 'rgba(0,0,0,1)', 'input' => '#444444', 'input_bg' => '#ffffff',
    ),
    ),
    );

    $options[] = array("name" => "Color Scheme from World News Demo",
    "id" => "template_worldnews_main_color",
    "type" => "load_color_presets",
    "for" => "jaw_color_preset",
    "class" => "fullwidth-option hide-title",
    "options" => array(
    array(
    'title' => 'WorldNews Main', 'background' => 'rgba(255,255,255,1)', 'alternative_background' => 'rgba(235,235,235,1)', 'theme1' => '#e2001a', 'theme2' => '#181818', 'theme3' => '#ffffff', 'border' => 'rgba(222,222,222,1)', 'text' => '#181818', 'meta' => '#929292', 'link' => '#181818', 'hover' => '#e2001a', 'text_link' => '#e2001a', 'text_hover' => '#181818', 'input' => '#181818', 'input_bg' => '#ffffff',
    ),
    array(
    'title' => 'WorldNews Menu', 'background' => 'rgba(255,255,255,1)', 'alternative_background' => 'rgba(235,235,235,1)', 'theme1' => '#e2001a', 'theme2' => '#181818', 'theme3' => '#ffffff', 'border' => 'rgba(222,222,222,1)', 'text' => '#181818', 'meta' => '#929292', 'link' => '#181818', 'hover' => '#e2001a', 'text_link' => '#e2001a', 'text_hover' => '#181818', 'input' => '#181818', 'input_bg' => '#ffffff',
    ),
    array(
    'title' => 'WorldNews Topbar', 'background' => '#181818', 'alternative_background' => 'rgba(235,235,235,1)', 'theme1' => '#e2001a', 'theme2' => '#181818', 'theme3' => '#ffffff', 'border' => 'rgba(222,222,222,1)', 'text' => 'rgba(255,255,255,1)', 'meta' => '#929292', 'link' => '#181818', 'hover' => '#e2001a', 'text_link' => '#e2001a', 'text_hover' => '#181818', 'input' => '#181818', 'input_bg' => '#ffffff',
    ),
    array(
    'title' => 'WorldNews Dark', 'background' => '#181818', 'alternative_background' => 'rgba(235,235,235,1)', 'theme1' => '#181818', 'theme2' => '#181818', 'theme3' => '#ffffff', 'border' => 'rgba(222,222,222,1)', 'text' => '#181818', 'meta' => '#929292', 'link' => '#181818', 'hover' => '#e2001a', 'text_link' => '#e2001a', 'text_hover' => '#181818', 'input' => '#181818', 'input_bg' => '#ffffff',
    ),
    array(
    'title' => 'WorldNews MyNews', 'background' => 'rgba(235,235,235,1)', 'alternative_background' => '#F1F1F1', 'theme1' => '#e2001a', 'theme2' => '#181818', 'theme3' => '#ffffff', 'border' => '#dcdcdc', 'text' => '#181818', 'meta' => '#929292', 'link' => '#181818', 'hover' => '#e2001a', 'text_link' => '#e2001a', 'text_hover' => '#181818', 'input' => '#444444', 'input_bg' => '#ffffff',
    ),
    array(
    'title' => 'WorldNews Footer', 'background' => '#181818', 'alternative_background' => 'rgba(89,89,89,1)', 'theme1' => '#e2001a', 'theme2' => 'rgba(255,255,255,1)', 'theme3' => '#ffffff', 'border' => 'rgba(222,222,222,1)', 'text' => 'rgba(255,255,255,1)', 'meta' => '#929292', 'link' => 'rgba(255,255,255,1)', 'hover' => '#e2001a', 'text_link' => '#e2001a', 'text_hover' => 'rgba(255,255,255,1)', 'input' => '#181818', 'input_bg' => '#ffffff',
    ),
    array(
    'title' => 'WorldNews Breaking News', 'background' => 'rgba(255,255,255,1)', 'alternative_background' => 'rgba(235,235,235,1)', 'theme1' => '#e2001a', 'theme2' => '#181818', 'theme3' => '#ffffff', 'border' => 'rgba(222,222,222,1)', 'text' => '#181818', 'meta' => '#929292', 'link' => '#181818', 'hover' => '#e2001a', 'text_link' => '#e2001a', 'text_hover' => '#181818', 'input' => '#181818', 'input_bg' => '#ffffff',
    ),
    ),
    );

    $options[] = array("name" => "Color Scheme from Traveler Demo",
    "id" => "template_traveler_main_color",
    "type" => "load_color_presets",
    "for" => "jaw_color_preset",
    "class" => "fullwidth-option hide-title",
    "options" => array(
    array(
    "title" => "Travel main","background" => "#ffffff","theme1" => "#AD6C60","theme2" => "#000000","theme3" => "#ffffff","border" => "#dcdcdc","text" => "rgba(99,99,99,1)","meta" => "#929292","link" => "rgba(61,61,61,1)","hover" => "#AD6C60","input" => "#000000","input_bg" => "#ffffff","alternative_background" => "#F1F1F1","text_link" => "#AD6C60","text_hover" => "#000000"
    ),
    array(
    "title" => "Travel menu","background" => "#000000","theme1" => "#AD6C60","theme2" => "rgba(255,255,255,1)","theme3" => "#ffffff","border" => "#dcdcdc","text" => "rgba(255,255,255,1)","meta" => "#929292","link" => "rgba(255,255,255,1)","hover" => "#AD6C60","input" => "#000000","input_bg" => "#ffffff","alternative_background" => "#F1F1F1","text_link" => "#AD6C60","text_hover" => "rgba(255,255,255,1)"
    ),
    array(
    "title" => "Travel footer","background" => "#000000","theme1" => "#AD6C60","theme2" => "rgba(255,255,255,1)","theme3" => "#000000","border" => "#000000","text" => "rgba(255,255,255,1)","meta" => "rgba(255,255,255,1)","link" => "rgba(255,255,255,1)","hover" => "#AD6C60","input" => "#000000","input_bg" => "#ffffff","alternative_background" => "#000000","text_link" => "rgba(255,255,255,1)","text_hover" => "#AD6C60"
    ),
    array(
    "title" => "Travel Gallery","background" => "#000000","theme1" => "#AD6C60","theme2" => "#000000","theme3" => "#ffffff","border" => "#dcdcdc","text" => "rgba(255,255,255,1)","meta" => "#929292","link" => "#000000","hover" => "#AD6C60","input" => "#444444","input_bg" => "#ffffff","alternative_background" => "#F1F1F1","text_link" => "#AD6C60","text_hover" => "#444444"
    ),
    ),
    );

$options[] = array("name" => "Color Scheme from Videoshannel Demo",
    "id" => "template_videoshannel_main_color",
    "type" => "load_color_presets",
    "for" => "jaw_color_preset",
    "class" => "fullwidth-option hide-title",
    "options" => array(
    array(
    'background' => '#ffffff', 'theme1' => '#D52D30', 'theme2' => '#0A242E', 'theme3' => '#ffffff', 'border' => '#dcdcdc', 'text' => '#111111', 'meta' => 'rgba(89,89,89,1)', 'link' => '#01354B', 'hover' => '#D52D30', 'input' => '#0A242E', 'input_bg' => '#ffffff', 'title' => 'VideoChannel', 'alternative_background' => '#e8e8e8', 'text_link' => '#33607a', 'text_hover' => '#009de0',
    ),
    array(
    'background' => 'rgba(255,255,255,0.46)', 'theme1' => 'rgba(235,76,30,1)', 'theme2' => '#ffffff', 'theme3' => '#ffffff', 'border' => 'rgba(0,0,0,1)', 'text' => '#ffffff', 'meta' => '#ffffff', 'link' => '#e7e6eb', 'hover' => 'rgba(0,0,0,1)', 'input' => '#e8e6e6', 'input_bg' => '#ffffff', 'title' => 'VideoChannel - Slider', 'alternative_background' => '#F1F1F1', 'text_link' => '#ffffff', 'text_hover' => '#009de0',
    ),
    array(
    'background' => '#EEF3F6', 'theme1' => '#0D404F', 'theme2' => 'rgba(0,0,0,1)', 'theme3' => 'rgba(255,255,255,1)', 'border' => '#dcdcdc', 'text' => '#111111', 'meta' => 'rgba(97,97,97,1)', 'link' => '#01354B', 'hover' => '#33607a', 'input' => 'rgba(255,0,0,1)', 'input_bg' => '#ffffff', 'title' => 'VideoChannel - sidebar', 'alternative_background' => '#ffffff', 'text_link' => '#444444', 'text_hover' => '#009de0'
    ),
    array(
    'name' => '15zine sidebar', 'background' => '#CA0000', 'theme1' => '#ffffff', 'theme2' => '#f0f0f0', 'theme3' => '#0A242E', 'border' => 'rgba(255,255,255,1)', 'text' => 'rgba(247,247,247,1)', 'meta' => '#ffffff', 'link' => 'rgba(255,255,255,1)', 'hover' => '#cfd4e8', 'input' => '#444444', 'input_bg' => '#ffffff', 'title' => 'VideoChannel - menu', 'alternative_background' => '#0A242E', 'text_link' => '#444444', 'text_hover' => '#009de0',
    ),
    array(
    'background' => '#ffffff', 'theme1' => '#064F7D', 'theme2' => '#0A242E', 'theme3' => '#ffffff', 'border' => '#dcdcdc', 'text' => '#111111', 'meta' => 'rgba(89,89,89,1)', 'link' => '#064F7D', 'hover' => '#1E87C9', 'input' => '#0A242E', 'input_bg' => '#ffffff', 'title' => 'VideoChannel - The Geek', 'alternative_background' => '#e8e8e8', 'text_link' => '#444444', 'text_hover' => '#009de0',
    ),
    array(
    'background' => '#111111', 'theme1' => '#D03322', 'theme2' => '#D03322', 'theme3' => '#ffffff', 'border' => '#dcdcdc', 'text' => '#ffffff', 'meta' => 'rgba(89,89,89,1)', 'link' => '#f2f2f2', 'hover' => '#33607a', 'input' => '#0A242E', 'input_bg' => '#ffffff', 'title' => 'VideoChannel - Gallery', 'alternative_background' => '#e8e8e8', 'text_link' => '#444444', 'text_hover' => '#009de0',
    ),
    array(
    'background' => '#ffffff', 'theme1' => '#E62117', 'theme2' => '#0A242E', 'theme3' => '#ffffff', 'border' => '#dcdcdc', 'text' => '#111111', 'meta' => 'rgba(89,89,89,1)', 'link' => '#01354B', 'hover' => '#E62117', 'input' => '#0A242E', 'input_bg' => '#ffffff', 'title' => 'VideoChannel - YouTube', 'alternative_background' => '#e8e8e8', 'text_link' => '#444444', 'text_hover' => '#009de0',
    ),
    array(
    'background' => '#ffffff', 'theme1' => '#00ADEF', 'theme2' => '#0A242E', 'theme3' => '#ffffff', 'border' => '#dcdcdc', 'text' => '#111111', 'meta' => 'rgba(89,89,89,1)', 'link' => '#01354B', 'hover' => '#00ADEF', 'input' => '#0A242E', 'input_bg' => '#ffffff', 'title' => 'VideoChannel - Vimeo', 'alternative_background' => '#e8e8e8', 'text_link' => '#444444', 'text_hover' => '#009de0',
    ),
    array(
    'background' => '#000000', 'theme1' => '#D03322', 'theme2' => '#0A242E', 'theme3' => '#ffffff', 'border' => 'rgba(255,255,255,1)', 'text' => '#ffffff', 'meta' => '#ffffff', 'link' => 'rgba(255,255,255,1)', 'hover' => '#008584', 'input' => '#444444', 'input_bg' => '#ffffff', 'title' => 'VideoChannel - Footer', 'alternative_background' => '#0A242E', 'text_link' => '#444444', 'text_hover' => '#009de0',
    ),
    array(
    'background' => '#000000', 'theme1' => '#D03322', 'theme2' => '#0A242E', 'theme3' => '#ffffff', 'border' => 'rgba(255,255,255,1)', 'text' => '#ffffff', 'meta' => '#ffffff', 'link' => 'rgba(255,255,255,1)', 'hover' => '#008584', 'input' => '#444444', 'input_bg' => '#ffffff', 'title' => 'VideoChannel - Slider-grid', 'alternative_background' => '#0A242E', 'text_link' => '#444444', 'text_hover' => '#009de0',
    ),
    array(
    'background' => '#ffffff', 'theme1' => '#D52D30', 'theme2' => '#0A242E', 'theme3' => '#ffffff', 'border' => 'rgba(255,255,255,1)', 'text' => '#01354B', 'meta' => '#01354B', 'link' => '#01354B', 'hover' => '#D52D30', 'input' => '#444444', 'input_bg' => '#ffffff', 'title' => 'VideoChannel - submenu', 'alternative_background' => '#0A242E', 'text_link' => '#444444', 'text_hover' => '#009de0',
    ),
    array(
    'background' => '#292929', 'theme1' => '#D52D30', 'theme2' => '#0A242E', 'theme3' => '#ffffff', 'border' => 'rgba(255,255,255,1)', 'text' => '#ffffff', 'meta' => '#e3e3e3', 'link' => '#ffffff', 'hover' => '#D52D30', 'input' => '#444444', 'input_bg' => '#ffffff', 'title' => 'VideoChannel - menu - mobil', 'alternative_background' => '#0A242E', 'text_link' => '#444444', 'text_hover' => '#009de0',
    ),
    ),
    );

$options[] = array("name" => "Color Scheme from Sleek mag Demo",
    "id" => "template_sleekmag_main_color",
    "type" => "load_color_presets",
    "for" => "jaw_color_preset",
    "class" => "fullwidth-option hide-title",
    "options" => array(
    array(
    'title' => 'Movies Main', 'background' => 'rgba(0,0,0,1)', 'theme1' => '#C68000', 'theme2' => '#FFA700', 'theme3' => '#ffffff', 'border' => '#dcdcdc', 'text' => '#f2f2f2', 'meta' => 'rgba(255,255,255,1)', 'link' => 'rgba(255,255,255,1)', 'hover' => 'rgb(255, 167, 0)', 'input' => '#444444', 'input_bg' => '#ffffff', 'alternative_background' => '#000000', 'text_link' => 'rgb(255, 167, 0)', 'text_hover' => 'rgba(255,255,255,1)',
    ),
    ),
    );

$options[] = array("name" => "Color Scheme from MovieNews Demo",
    "id" => "template_movienews_main_color",
    "type" => "load_color_presets",
    "for" => "jaw_color_preset",
    "class" => "fullwidth-option hide-title",
    "options" => array(
    array(
    'title' => 'Movies Main', 'background' => 'rgba(0,0,0,1)', 'theme1' => '#C68000', 'theme2' => '#FFA700', 'theme3' => '#ffffff', 'border' => '#dcdcdc', 'text' => '#f2f2f2', 'meta' => 'rgba(255,255,255,1)', 'link' => 'rgba(255,255,255,1)', 'hover' => 'rgb(255, 167, 0)', 'input' => '#444444', 'input_bg' => '#ffffff', 'alternative_background' => '#000000', 'text_link' => 'rgb(255, 167, 0)', 'text_hover' => 'rgba(255,255,255,1)',
    ),
    array(
    'title' => 'Movies Menu', 'background' => '#000000', 'theme1' => 'rgb(255, 167, 0)', 'theme2' => 'rgba(255,255,255,1)', 'theme3' => '#ffffff', 'border' => '#dcdcdc', 'text' => '#f2f2f2', 'meta' => 'rgba(255,255,255,1)', 'link' => 'rgba(255,255,255,1)', 'hover' => 'rgb(255, 167, 0)', 'input' => '#444444', 'input_bg' => '#ffffff', 'alternative_background' => '#F1F1F1', 'text_link' => 'rgb(255, 167, 0)', 'text_hover' => 'rgba(61,61,61,1)',
    ),
    array(
    'title' => 'Movies Main Slider', 'background' => '#ffffff', 'theme1' => 'rgb(255, 167, 0)', 'theme2' => 'rgba(0,0,0,0.65)', 'theme3' => '#ffffff', 'border' => '#dcdcdc', 'text' => '#f2f2f2', 'meta' => 'rgba(255,255,255,1)', 'link' => 'rgba(255,255,255,1)', 'hover' => 'rgb(255, 167, 0)', 'input' => '#444444', 'input_bg' => '#ffffff', 'alternative_background' => '#F1F1F1', 'text_link' => 'rgb(255, 167, 0)', 'text_hover' => 'rgba(61,61,61,1)',
    ),
    array(
    'title' => 'Movies Sidebar', 'background' => '#2D2D2D', 'theme1' => '#FFA700', 'theme2' => '#C68000', 'theme3' => '#ffffff', 'border' => '#dcdcdc', 'text' => '#f2f2f2', 'meta' => 'rgba(255,255,255,1)', 'link' => 'rgba(255,255,255,1)', 'hover' => 'rgb(255, 167, 0)', 'input' => '#444444', 'input_bg' => '#ffffff', 'alternative_background' => '#F1F1F1', 'text_link' => 'rgb(255, 167, 0)', 'text_hover' => 'rgba(61,61,61,1)',
    ),
    array(
    'title' => 'Movies Footer', 'background' => 'rgba(0,0,0,1)', 'theme1' => 'rgb(255, 167, 0)', 'theme2' => '#C68000', 'theme3' => '#ffffff', 'border' => '#dcdcdc', 'text' => '#f2f2f2', 'meta' => 'rgba(255,255,255,1)', 'link' => 'rgba(255,255,255,1)', 'hover' => 'rgb(255, 167, 0)', 'input' => '#444444', 'input_bg' => '#ffffff', 'alternative_background' => '#F1F1F1', 'text_link' => 'rgb(255, 167, 0)', 'text_hover' => 'rgba(61,61,61,1)',
    ),
    array(
    'title' => 'Movies Gallery', 'background' => 'rgba(0,0,0,1)', 'theme1' => 'rgb(255, 167, 0)', 'theme2' => 'rgba(0,0,0,1)', 'theme3' => '#ffffff', 'border' => '#dcdcdc', 'text' => '#f2f2f2', 'meta' => 'rgba(255,255,255,1)', 'link' => 'rgba(255,255,255,1)', 'hover' => 'rgb(255, 167, 0)', 'input' => '#444444', 'input_bg' => '#ffffff', 'alternative_background' => '#F1F1F1', 'text_link' => 'rgb(255, 167, 0)', 'text_hover' => 'rgba(61,61,61,1)',
    ),
    array(
    'title' => 'Movies Mobile Menu', 'background' => 'rgba(0,0,0,1)', 'theme1' => 'rgb(255, 167, 0)', 'theme2' => '#C68000', 'theme3' => '#ffffff', 'border' => '#dcdcdc', 'text' => '#f2f2f2', 'meta' => 'rgba(255,255,255,1)', 'link' => 'rgba(255,255,255,1)', 'hover' => 'rgb(255, 167, 0)', 'input' => '#444444', 'input_bg' => '#ffffff', 'alternative_background' => '#F1F1F1', 'text_link' => 'rgb(255, 167, 0)', 'text_hover' => 'rgba(61,61,61,1)',
    ),
    array(
    'title' => 'Movies Submenu', 'background' => '#000000', 'theme1' => 'rgb(255, 167, 0)', 'theme2' => '#ffffff', 'theme3' => '#ffffff', 'border' => '#dcdcdc', 'text' => '#f2f2f2', 'meta' => 'rgba(255,255,255,1)', 'link' => 'rgba(255,255,255,1)', 'hover' => 'rgb(255, 167, 0)', 'input' => '#444444', 'input_bg' => '#ffffff', 'alternative_background' => '#F1F1F1', 'text_link' => 'rgb(255, 167, 0)', 'text_hover' => 'rgba(61,61,61,1)',
    ),
    ),
    );

$options[] = array("name" => "Color Scheme from GEEK Demo",
    "id" => "template_geek_main_color",
    "type" => "load_color_presets",
    "for" => "jaw_color_preset",
    "class" => "fullwidth-option hide-title",
    "options" => array(
    array(
    'name' => 'Coral main', 'title' => 'GeekBlog main', 'background' => '#ffffff', 'theme1' => 'rgba(235,80,75,1)', 'theme2' => '#3D3D3D', 'theme3' => '#ffffff', 'border' => '#dcdcdc', 'text' => 'rgba(0,0,0,1)', 'meta' => '#929292', 'link' => 'rgba(61,61,61,1)', 'hover' => 'rgba(235,80,75,1)', 'input' => '#444444', 'input_bg' => '#ffffff', 'alternative_background' => '#F1F1F1', 'text_link' => 'rgba(235,80,75,1)', 'text_hover' => 'rgba(61,61,61,1)',
    ),
    array(
    'name' => 'Coral menu', 'title' => 'GeekBlog menu', 'background' => '#333333', 'theme1' => '#4f4e4e', 'theme2' => 'rgba(255,255,255,1)', 'theme3' => '#ffffff', 'border' => '#dcdcdc', 'text' => 'rgba(255,255,255,1)', 'meta' => '#929292', 'link' => 'rgba(255,255,255,1)', 'hover' => '#999999', 'input' => '#444444', 'input_bg' => '#ffffff', 'alternative_background' => '#F1F1F1', 'text_link' => 'rgba(255,255,255,1)', 'text_hover' => '#999999',
    ),
    array(
    'name' => 'Coral menu', 'title' => 'GeekBlog footer', 'background' => 'rgba(61,61,61,1)', 'theme1' => 'rgba(235,80,75,1)', 'theme2' => 'rgba(255,255,255,1)', 'theme3' => 'rgba(61,61,61,1)', 'border' => '#dcdcdc', 'text' => 'rgba(255,255,255,1)', 'meta' => 'rgba(255,255,255,1)', 'link' => 'rgba(255,255,255,1)', 'hover' => 'rgba(235,80,75,1)', 'input' => '#444444', 'input_bg' => '#ffffff', 'alternative_background' => 'rgba(122,122,122,1)', 'text_link' => 'rgba(255,255,255,1)', 'text_hover' => 'rgba(235,80,75,1)',
    ),
    array(
    'name' => 'Coral main', 'title' => 'GeekBlog MyNews', 'background' => '#FFFDFA', 'theme1' => '#4f4e4e', 'theme2' => '#333333', 'theme3' => 'rgba(255,255,255,1)', 'border' => '#dcdcdc', 'text' => '#3d3d3d', 'meta' => '#929292', 'link' => 'rgba(61,61,61,1)', 'hover' => 'rgba(235,80,75,1)', 'input' => '#444444', 'input_bg' => '#ffffff', 'alternative_background' => '#F1F1F1', 'text_link' => 'rgba(235,80,75,1)', 'text_hover' => 'rgba(61,61,61,1)',
    ),
    array(
    'name' => 'Coral main', 'title' => 'GeekBlog Gallery', 'background' => 'rgba(31,31,31,1)', 'theme1' => 'rgba(235,80,75,1)', 'theme2' => 'rgba(31,31,31,1)', 'theme3' => '#ffffff', 'border' => '#dcdcdc', 'text' => 'rgba(48,48,48,1)', 'meta' => '#929292', 'link' => '#444444', 'hover' => 'rgba(235,80,75,1)', 'input' => '#444444', 'input_bg' => '#ffffff', 'alternative_background' => '#F1F1F1', 'text_link' => 'rgba(235,80,75,1)', 'text_hover' => '#444444',
    ),
    array(
    'name' => 'Coral menu', 'title' => 'GeekBlog sidebar', 'background' => '#FAFAFA', 'theme1' => '#4f4e4e', 'theme2' => '#4F4E4E', 'theme3' => '#ffffff', 'border' => '#dcdcdc', 'text' => '#555555', 'meta' => '#929292', 'link' => 'rgba(0,0,0,1)', 'hover' => '#4F4E4E', 'input' => '#444444', 'input_bg' => '#ffffff', 'alternative_background' => '#FAFAFA', 'text_link' => 'rgba(0,0,0,1)', 'text_hover' => '#4F4E4E',
    ),
    ),
    );

$options[] = array("name" => "Color Scheme from Bussiness News Demo",
    "id" => "template_businessnews_main_color",
    "type" => "load_color_presets",
    "for" => "jaw_color_preset",
    "class" => "fullwidth-option hide-title",
    "options" => array(
    array(
    'title' => 'Money Main', 'background' => 'rgba(255,255,255,1)', 'theme1' => '#067038', 'theme2' => '#000000', 'theme3' => '#ffffff', 'border' => '#dcdcdc', 'text' => 'rgba(99,99,99,1)', 'meta' => '#929292', 'link' => '#000000', 'hover' => '#067038', 'input' => '#000000', 'input_bg' => '#ffffff', 'alternative_background' => '#F1F1F1', 'text_link' => '#067038', 'text_hover' => '#000000',
    ),
    array(
    'title' => 'Money Menu', 'background' => 'rgba(0,0,0,1)', 'theme1' => '#067038', 'theme2' => 'rgba(255,255,255,1)', 'theme3' => '#ffffff', 'border' => '#dcdcdc', 'text' => 'rgba(255,255,255,1)', 'meta' => '#929292', 'link' => 'rgba(255,255,255,1)', 'hover' => '#067038', 'input' => '#000000', 'input_bg' => '#ffffff', 'alternative_background' => '#F1F1F1', 'text_link' => 'rgba(255,255,255,1)', 'text_hover' => 'rgba(255,255,255,1)',
    ),
    array(
    'title' => 'Money Footer', 'background' => '#000000', 'theme1' => '#067038', 'theme2' => 'rgba(255,255,255,1)', 'theme3' => 'rgba(255,255,255,1)', 'border' => '#000000', 'text' => 'rgba(255,255,255,1)', 'meta' => 'rgba(255,255,255,1)', 'link' => 'rgba(255,255,255,1)', 'hover' => '#067038', 'input' => '#000000', 'input_bg' => '#ffffff', 'alternative_background' => '#000000', 'text_link' => 'rgba(255,255,255,1)', 'text_hover' => '#067038',
    ),
    array(
    'title' => 'Money Gallery', 'background' => '#000000', 'theme1' => '#067038', 'theme2' => '#000000', 'theme3' => '#ffffff', 'border' => '#dcdcdc', 'text' => 'rgba(255,255,255,1)', 'meta' => '#929292', 'link' => '#000000', 'hover' => '#067038', 'input' => '#444444', 'input_bg' => '#ffffff', 'alternative_background' => '#F1F1F1', 'text_link' => '#067038', 'text_hover' => '#444444',
    ),
    array(
    'title' => 'Money Top Bar', 'background' => 'rgba(0,0,0,1)', 'theme1' => '#067038', 'theme2' => '#000000', 'theme3' => '#ffffff', 'border' => '#dcdcdc', 'text' => 'rgba(99,99,99,1)', 'meta' => '#929292', 'link' => 'rgba(61,61,61,1)', 'hover' => '#067038', 'input' => '#000000', 'input_bg' => '#ffffff', 'alternative_background' => '#F1F1F1', 'text_link' => '#067038', 'text_hover' => '#000000',
    ),
    array(
    'title' => 'Money Highlitedbox', 'background' => '#EAEDF2', 'theme1' => '#067038', 'theme2' => '#000000', 'theme3' => '#ffffff', 'border' => '#dcdcdc', 'text' => 'rgba(99,99,99,1)', 'meta' => '#929292', 'link' => 'rgba(61,61,61,1)', 'hover' => '#067038', 'input' => '#000000', 'input_bg' => '#ffffff', 'alternative_background' => '#F1F1F1', 'text_link' => '#067038', 'text_hover' => '#000000',
    ),
    ),
    );

$options[] = array("name" => "Color Scheme from Smartness Demo",
    "id" => "template_smartness_main_color",
    "type" => "load_color_presets",
    "for" => "jaw_color_preset",
    "class" => "fullwidth-option hide-title",
    "options" => array(
    array(
    'title' => 'Smartness Main', 'background' => '#ffffff', 'alternative_background' => '#F1F1F1', 'theme1' => '#F44336', 'theme2' => 'rgba(61,61,61,1)', 'theme3' => '#ffffff', 'border' => '#dcdcdc', 'text' => 'rgba(48,48,48,1)', 'meta' => '#6b6a6a', 'link' => '#1f1f1f', 'hover' => '#F44336', 'text_link' => 'rgba(235,80,75,1)', 'text_hover' => 'rgba(61,61,61,1)', 'input' => '#444444', 'input_bg' => '#ffffff',
    ),
    array(
    'title' => 'Smartness Menu', 'background' => 'rgba(61,61,61,1)', 'alternative_background' => '#F1F1F1', 'theme1' => '#F44336', 'theme2' => 'rgba(255,255,255,1)', 'theme3' => '#ffffff', 'border' => '#dcdcdc', 'text' => 'rgba(255,255,255,1)', 'meta' => '#929292', 'link' => 'rgba(255,255,255,1)', 'hover' => 'rgba(235,80,75,1)', 'text_link' => 'rgba(235,80,75,1)', 'text_hover' => 'rgba(255,255,255,1)', 'input' => '#444444', 'input_bg' => '#ffffff',
    ),
    array(
    'title' => 'Smartness Sidebar', 'background' => 'rgba(230,230,230,1)', 'alternative_background' => '#D6D6D6', 'theme1' => '#3D3D3D', 'theme2' => '#3D3D3D', 'theme3' => '#ffffff', 'border' => '#dcdcdc', 'text' => '#929292', 'meta' => '#929292', 'link' => '#444444', 'hover' => '#535353', 'text_link' => 'rgba(235,80,75,1)', 'text_hover' => '444444', 'input' => '#444444', 'input_bg' => '#ffffff',
    ),
    array(
    'title' => 'Smartness footer', 'background' => 'rgba(61,61,61,1)', 'theme1' => 'rgba(235,80,75,1)', 'theme2' => 'rgba(255,255,255,1)', 'theme3' => 'rgba(61,61,61,1)', 'border' => '#dcdcdc', 'text' => 'rgba(255,255,255,1)', 'meta' => 'rgba(255,255,255,1)', 'link' => 'rgba(255,255,255,1)', 'hover' => 'rgba(235,80,75,1)', 'input' => '#444444', 'input_bg' => '#ffffff', 'alternative_background' => 'rgba(122,122,122,1)', 'text_link' => 'rgba(255,255,255,1)', 'text_hover' => 'rgba(235,80,75,1)',
    ),
  array(
    'title' => 'Smartness MyNews',
    'background' => 'rgba(237,237,237,1)',
    'theme1' => 'rgba(235,80,75,1)',
    'theme2' => 'rgba(61,61,61,1)',
    'theme3' => 'rgba(255,255,255,1)',
    'border' => '#dcdcdc',
    'text' => '#3d3d3d',
    'meta' => '#929292',
    'link' => 'rgba(61,61,61,1)',
    'hover' => 'rgba(235,80,75,1)',
    'input' => '#444444',
    'input_bg' => '#ffffff',
    'alternative_background' => '#F1F1F1',
    'text_link' => 'rgba(235,80,75,1)',
    'text_hover' => 'rgba(61,61,61,1)',
  ),
  array(
    'title' => 'Smartness slider',
    'background' => 'rgba(235,80,75,1)',
    'theme1' => 'rgba(255,255,255,1)',
    'theme2' => 'rgba(235,80,75,1)',
    'theme3' => 'rgba(255,255,255,1)',
    'border' => 'rgba(255,255,255,1)',
    'text' => 'rgba(255,255,255,1)',
    'meta' => 'rgba(255,255,255,1)',
    'link' => 'rgba(255,255,255,1)',
    'hover' => 'rgba(247,247,247,1)',
    'input' => 'rgba(255,255,255,1)',
    'input_bg' => '#ffffff',
    'alternative_background' => '#F1F1F1',
    'text_link' => '#444444',
    'text_hover' => 'rgba(255,255,255,1)',
  ),
  array(
    'title' => 'Smartness gallery',
    'background' => '#191919',
    'theme1' => '#F44336',
    'theme2' => 'rgba(31,31,31,1)',
    'theme3' => '#ffffff',
    'border' => '#dcdcdc',
    'text' => 'rgba(48,48,48,1)',
    'meta' => '#929292',
    'link' => '#444444',
    'hover' => 'rgba(235,80,75,1)',
    'input' => '#444444',
    'input_bg' => '#ffffff',
    'alternative_background' => '#F1F1F1',
    'text_link' => 'rgba(235,80,75,1)',
    'text_hover' => '#444444',
  ),
    ),
    );

    /*FIND AND REPLACE
    s:.*?:(.*?);s:.*?:(.*?);
    $1 => $2,
    */

    $options[] = array(
    "name" => "Color Schemes",
    "text" => 'Here you can create as many your own color schemes as you want to use on your pages. To create a new scheme, click (+), enter its name and set colors of the individual elements/items according to your ideas. Save the settings.<br><br>You can also simply clone or delete any scheme clicking the appropriate symbol in its heading bar.<br><br><i class="jaw-icon-info"></i> <b>TIP:</b> You can manage it also in Theme Customize - <a href="'.admin_url('customize.php').'">VISIT</a>',
    "type" => "info");


    /* * ********************************** PRESETS *********************************** */
    /* DEFAULT */
    $presets_options_default[] = array("name" => "Name of preset",
    "desc" => "Type the name of your new preset (Color Scheme).",
    "id" => "title",
    "std" => "new-preset",
    "type" => "text");
    $presets_options_default[] = array("name" => "Background",
    "desc" => "Set a background color for the main elements of those parts of your web, that use this color scheme.",
        "id" => "background",
    "std" => "rgba(0,0,0,0)",
    "format" => "rgba",
    "type" => "color");
    $presets_options_default[] = array("name" => "Alternative Background",
    "desc" => "Set an alternative background color for the other element of your web, e.g image placeholder, about author etc...",
        "id" => "alternative_background",
    "std" => "#F1F1F1",
    "format" => "rgba",
    "type" => "color");
    $presets_options_default[] = array("name" => "Theme Color 1",
    "desc" => "Pick the basic color 1 for the theme. This option affects a predefined set of elements, that was designed to make your site balanced and well color-coordinated if a color of your choice is applied.<br><br><strong>NOTE:</strong> It is recommended that this color is contrasting to the Theme Color 2 and 3, in order to ensure that all content and texts on your pages are well visible and readable.",
        "id" => "theme1",
    "std" => "#009de0",
    "format" => "rgba",
    "type" => "color");
    $presets_options_default[] = array("name" => "Theme Color 2",
    "desc" => "Pick the basic color 2 for the theme. This color will be used for a predefined set of other elements used on your pages.<br><br><strong>NOTE:</strong> It is recommended that this color is contrasting to the Theme Color 1 and 3.",
        "id" => "theme2",
    "std" => "#535353",
    "format" => "rgba",
    "type" => "color");
    $presets_options_default[] = array("name" => "Theme Color 3",
    "desc" => "Pick the basic color 3 for the theme. This color affects some predetermined minor elements.<br><br><strong>NOTE:</strong> It is recommended that this color is contrasting to the Theme Color 1 and 2.",
        "id" => "theme3",
    "std" => "#ffffff",
    "format" => "rgba",
    "type" => "color");
    $presets_options_default[] = array("name" => "Border Color",
    "desc" => "This color affects borders or/and background of some elements, like e.g. boxes with social icons and number values.",
    "id" => "border",
    "std" => "#dcdcdc",
    "format" => "rgba",
    "type" => "color");
    $presets_options_default[] = array("name" => "Text Color",
    "desc" => "Select a color for texts.",
        "id" => "text",
    "std" => "#929292",
    "format" => "rgba",
    "type" => "color");
    $presets_options_default[] = array("name" => "Meta Color",
    "desc" => "Select a color for meta informations.",
        "id" => "meta",
    "std" => "#929292",
    "format" => "rgba",
    "type" => "color");
    $presets_options_default[] = array("name" => "Link Color",
    "desc" => "Link at all places except in content. (titles, ",
    "id" => "link",
    "std" => "#444444",
    "format" => "rgba",
    "type" => "color");
    $presets_options_default[] = array("name" => "Link Hover Color",
    "desc" => "Link hover at all places except in content",
    "id" => "hover",
    "std" => "#009de0",
    "format" => "rgba",
    "type" => "color");
    $presets_options_default[] = array("name" => "Link in Content Color",
    "desc" => "Select a color for links in content. In text widget or single content.",
        "id" => "text_link",
    "std" => "#444444",
    "format" => "rgba",
    "type" => "color");
    $presets_options_default[] = array("name" => "Link in Content Hover Color",
    "desc" => "Select a color for links when hovered over. In text widget or single content.",
        "id" => "text_hover",
    "std" => "#009de0",
    "format" => "rgba",
    "type" => "color");
    $presets_options_default[] = array("name" => "Input Text Color",
    "desc" => "Select a color for texts in the elements that require inputting a content, like e.g. forms.",
        "id" => "input",
    "std" => "#444444",
    "format" => "rgba",
    "type" => "color");
    $presets_options_default[] = array("name" => "Input Background Color",
    "desc" => "Select a background color for the elements that require inputting a content.",
        "id" => "input_bg",
    "std" => "#ffffff",
    "format" => "rgba",
    "type" => "color");



    $options[] = array("name" => "<i class='jaw-icon-palette jaw-preset-icon'></i> Color Schemes ".jwUtils::getHelp("", "", "", array( array(
    'href' => 'http://support.jawtemplates.com/gdaynews/web/?p=1013',
    'title' => 'documentation') )),
    "desc" => "",
    "id" => "color_presets",
    "std" => array(
    array(
    "title" => "blue",
    'background' => '#ffffff',
    'theme1' => '#009de0',
    'theme2' => '#535353',
    'theme3' => '#ffffff',
    'border' => '#dcdcdc',
    'text' => '#929292',
    'meta' => '#929292',
    'link' => '#444444',
    'hover' => '#009de0',
    'input' => '#444444',
    'input_bg' => '#ffffff',
    )
    ),
    "type" => "color_presets",
    "index" => true,
    "mod" => "big",
    "options" => $presets_options_default
    );

    $options[] = array(
    "type" => "sectionend"
    );
    $options[] = array(
    "name" => "Panel Boxes Colors",
    "type" => "sectionstart");

    $options[] = array(
    "name" => "Panel Boxes Colors",
    "text" => 'Here you can set your own color for info boxes of the same names, which you can put to your content via shortcodes.',
        "type" => "info",
    );

    $options[] = array("name" => "Success Box Background",
    "desc" => "",
    "id" => "success_box_bg",
    "std" => "#dff0d8",
    "format" => "rgba",
    "type" => "color");
    $options[] = array("name" => "Success Box Text Color",
    "desc" => "",
    "id" => "success_box_clr",
    "std" => "#3c763d",
    "format" => "rgba",
    "type" => "color");

    $options[] = array("name" => "Info Box Background",
    "desc" => "",
    "id" => "info_box_bg",
    "std" => "#d9edf7",
    "format" => "rgba",
    "type" => "color");
    $options[] = array("name" => "Info Box Text Color",
    "desc" => "",
    "id" => "info_box_clr",
    "std" => "#31708f",
    "format" => "rgba",
    "type" => "color");

    $options[] = array("name" => "Warning Box Background",
    "desc" => "",
    "id" => "warning_box_bg",
    "std" => "#fcf8e3",
    "format" => "rgba",
    "type" => "color");
    $options[] = array("name" => "Warning Box Text Color",
    "desc" => "",
    "id" => "warning_box_clr",
    "std" => "#8a6d3b",
    "format" => "rgba",
    "type" => "color");

    $options[] = array("name" => "Danger Box Background",
    "desc" => "",
    "id" => "danger_box_bg",
    "std" => "#f2dede",
    "format" => "rgba",
    "type" => "color");
    $options[] = array("name" => "Danger Box Text Color",
    "desc" => "",
    "id" => "danger_box_clr",
    "std" => "#a94442",
    "format" => "rgba",
    "type" => "color");

    $options[] = array(
    "type" => "sectionend"
    );

    $options[] = array(
    "name" => "Overlay Gradient Colors" . " " . jwUtils::getHelp("", "", "gradient.jpg") ,
    "type" => "sectionstart");

    $options[] = array(
    "name" => "Overlay Gradient Colors",
    "text" => 'These colors appears on <strong>JaW Grid</strong>, <strong>Slider with thumbnails</strong> and <strong>Review Posts</strong>',
    "type" => "info",
    );

    $options[] = array("name" => "Overlay Gradient - Upper Color",
    "desc" => "",
    "id" => "overlay_upper",
    "std" => "rgba(0,0,0,0)",
    "format" => "rgba",
    "type" => "color");

    $options[] = array("name" => "Overlay Gradient - Bottom Color",
    "desc" => "",
    "id" => "overlay_bottom",
    "std" => "rgba(0,0,0,0.7)",
    "format" => "rgba",
    "type" => "color");

    $options[] = array("name" => "Text Color on Gradient Area",
    "desc" => "",
    "id" => "overlay_text",
    "std" => "rgba(255,255,255,0.7)",
    "format" => "rgba",
    "type" => "color");

    $options[] = array(
    "type" => "sectionend"
    );

    $options[] = array(
    "name" => "Overlay Colors" . " " . jwUtils::getHelp("", "", "overlay.jpg") ,
    "type" => "sectionstart");

    $options[] = array(
    "name" => "Overlay Colors",
    "text" => 'These colors appears on <strong>Row Slider</strong> and <strong>Big Photo Slider</strong>',
    "type" => "info",
    );

    $options[] = array("name" => "Overlay Color",
    "desc" => "",
    "id" => "overlay_color",
    "std" => "rgba(0,0,0,0.7)",
    "format" => "rgba",
    "type" => "color");

    $options[] = array(
    "type" => "sectionend"
    );

    $options[] = array("type" => "headingend");
// 
//  
    $options[] = array("name" => "Other Styles",
    "type" => "headingstart");


    $options[] = array(
    'name' => 'Big Title Middle Line Weight'. " " . jwUtils::getHelp("", "", "big-title-line-weight.jpg", array( array(
    'href' => 'http://support.jawtemplates.com/gdaynews/web/documentation/goodday-news-magazine-settings/my-news#BigTitleMiddleLineWeight',
    'title' => 'documentation') )) ,
    "desc" => "Set a thickness of big titles middle decorating line in pixels.",
    "id" => "big_title_line_weight",
    "std" => '3',
    "type" => "text",
    'mod' => 'small'
    );

    $options[] = array(
    'name' => 'Title Middle Line Weight'. " " . jwUtils::getHelp("", "", "middle-border-line-weight.jpg", array( array(
    'href' => 'http://support.jawtemplates.com/gdaynews/web/documentation/goodday-news-magazine-settings/my-news#TitleMiddleLineWeight',
    'title' => 'documentation') )) ,
    "desc" => "Set a thickness of normal title's middle line in pixels.",
    "id" => "title_4_line_weight",
    "std" => '1',
    "type" => "text",
    'mod' => 'small'
    );



    $options[] = array("type" => "headingend");
// 

    /* Typography Options ****************************************************************** */
    $options[] = array("name" => "Typography Options",
    "type" => "headingstart");
//  
    $options[] = array(
    "name" => "How to Use Fonts",
    "id" => "fonts-info",
    "text" => "<h3>Google Fonts</h3><a href='http://www.google.com/webfonts'>List of all available fonts you can find here</a><br><i class='jaw-icon-warning'></i> Using many font family can slow down your webpage, therefore it is recommended to set only one or two font family on your webpage.<br>
    <h3>Self Hosted Font Set</h3><i class='jaw-icon-info'></i> <a href='http://support.jawtemplates.com/gdaynews/web/?p=670#selfhostedfonts' target='_blank'>Please read this tutorial</a>.",
    "type" => "info",
    "space" => false,
    "message" => "info"
    );

    $options[] = array(
    'id' => 'font_settings_mode',
    'type' => 'toggle',
    'name' => 'Font manager mode',
    'desc' => 'Choose how do you want to edit your Typografy.',
    'std' => 'classical',
    "options" => array("classical" => "Classical", "advanced" => "Advanced")
    );

    $fonts_array = array(
        'topbar_font'=> array( 'name'=> 'Top Bar Font', 'helpImg'=>'topbar-font.jpg'),
        'topbar_menu_font'=> array( 'name'=> 'Top Bar Menu Font', 'helpImg'=>'topbar-menu-font.jpg'),
        'breadcrumbs_font'=> array( 'name'=> 'Breadcrumbs Font', 'helpImg'=>'breadcrumbs-font.jpg'),
        'menu_font'=> array( 'name'=> 'Menu Font', 'helpImg'=>'menu-font.jpg'),
        'submenu_font'=> array( 'name'=> 'Sub-Menu Font', 'helpImg'=>'submenu-font.jpg'),
        'mobilemenu_font'=> array( 'name'=> 'Mobile Menu Font', 'helpImg'=>'mobilemenu-font.jpg'),
        'big_titles_font'=> array( 'name'=> 'Big Titles Font', 'helpImg'=>'bigtitle-font.jpg'),
        'titles_left_boder_font'=> array( 'name'=> 'Titles With Left Border Font', 'helpImg'=>'left-border-font.jpg'),
        'titles_middle_boder_font'=> array( 'name'=> 'Titles With Middle Border Font', 'helpImg'=>'middle-border-font.jpg'),
        'titles_top_bottom_border_font'=> array( 'name'=> 'Titles With Top and Bottom Borders Font', 'helpImg'=>'top-bottom-border-font.jpg'),
        'titles_background_font'=> array( 'name'=> 'Titles With Background Font', 'helpImg'=>'with-background-font.jpg'),
        'text_font'=> array( 'name'=> 'Text Font', 'helpImg'=>'text-font.jpg'),
        'pagination_font'=> array( 'name'=> 'Pagination Font', 'helpImg'=>'pagination-font.jpg'),
        'buttons_font'=> array( 'name'=> 'Buttons Font', 'helpImg'=>'buttons-font.jpg'),
        'blockquote_font'=> array( 'name'=> 'BlockQuote Font', 'helpImg'=>'blockquote.jpg'),
        'post_titles_font'=> array( 'name'=> 'Post, Page and Category Title Font', 'helpImg'=>'pagetitle-font.jpg'),
        'h1_font'=> array( 'name'=> 'H1 in Post/Page Content', 'helpImg'=>'h1-font.jpg'),
        'h2_font'=> array( 'name'=> 'H2 in Post/Page Content', 'helpImg'=>'h2-font.jpg'),
        'h3_font'=> array( 'name'=> 'H3 in Post/Page Content', 'helpImg'=>'h3-font.jpg'),
        'h4_font'=> array( 'name'=> 'H4 in Post/Page Content', 'helpImg'=>'h4-font.jpg'),
        'h5_font'=> array( 'name'=> 'H5 in Post/Page Content', 'helpImg'=>'h5-font.jpg'),
        'h6_font'=> array( 'name'=> 'H6 in Post/Page Content', 'helpImg'=>'h6-font.jpg'),
        'label_font'=> array( 'name'=> 'Label', 'helpImg'=>'label-font.jpg'),
        'post_box_simple_font'=> array( 'name'=> 'Post Box Simple Title Font', 'helpImg'=>'simplel-font.jpg'),
        'post_box_vertical_small_font'=> array( 'name'=> 'Post Box Vertical Small Title Font', 'helpImg'=>'verticalsmall-font.jpg'),
        'post_box_vertical_font'=> array( 'name'=> 'Post Box Vertical Title Font', 'helpImg'=>'vertical-font.jpg'),
        'post_box_big_font'=> array( 'name'=> 'Post Box Vertical Big Title Font', 'helpImg'=>'vertical-big.jpg'),
        'post_box_special_font'=> array( 'name'=> 'Post Box Special Title Font', 'helpImg'=>'special-title.jpg'),
        'post_box_specialbig_font'=> array( 'name'=> 'Post Box Special Big Title Font', 'helpImg'=>'special-big.jpg'),
        'post_box_classical_font'=> array( 'name'=> 'Post Box Classical Title Font', 'helpImg'=>'classical.jpg'),
        'grid_big_font'=> array( 'name'=> 'JaW Grid Big Item Title Font', 'helpImg'=>'big-grid.jpg'),
        'grid_small_font'=> array( 'name'=> 'JaW Grid Small Item Title Font', 'helpImg'=>'small-grid.jpg'),
        'slider3_font'=> array( 'name'=> 'Slider with thumbnails Big Title Font', 'helpImg'=>'tiles-big-slider.jpg'),
        'slider3_small_font'=> array( 'name'=> 'Slider with thumbnails Small Title Font', 'helpImg'=>'tiles-small-slider.jpg'),
        'slider5_font'=> array( 'name'=> 'Big Photo Slider Title Font', 'helpImg' => 'fullslider-title.jpg'),
        'slider5_small_font'=> array( 'name'=> 'Big Photo Slider Navigation Title Font', 'helpImg' => 'fullslider-title-navigation.jpg'),
        'fullwidth_slider_font'=> array( 'name'=> 'Row Slider Title font', 'helpImg' => 'fullwidth-slider.jpg'),
        'slider_2_font'=> array( 'name'=> 'Squares Slider Title Font', 'helpImg'=>'stripe-slider-font.jpg'),
        'post_box_excerpt_font'=> array( 'name'=> 'Post Box Excerpt Font', 'helpImg'=>'excerpt-font.jpg'),
        'meta_font'=> array( 'name'=> 'Meta Font', 'helpImg'=>'meta-font.jpg'),
        'footer_font'=> array( 'name'=> 'Footer (copyright) Font', 'helpImg'=>'footer-font.jpg'),
        'mobile_post_box_vertical_font'=> array( 'name'=> 'Post Box Vertical (all) on Mobile Devices', 'helpImg'=>'vertical-font.jpg'),
    );
    // neni to moc pekny to delit na dve konfigurace, ale kdyz tam designeri chteji sekce a zaroven nechteji aby se jim ztratila stara data...
    $fonts_structure = array(
        'header' => array(
            'title' => 'Header Fonts',
            'items' => array('topbar_font','topbar_menu_font','menu_font', 'submenu_font', 'mobilemenu_font', 'breadcrumbs_font')
        ),
        'titles' => array(
            'title' => 'Titles Fonts',
            'items' => array('big_titles_font', 'titles_left_boder_font', 'titles_middle_boder_font', 'titles_top_bottom_border_font', 'titles_background_font' )
        ),
        'post_box_titles' => array(
            'title' => 'Post Box Fonts',
            'items' => array('post_box_simple_font', 'post_box_vertical_small_font', 'post_box_vertical_font', 'post_box_big_font', 'post_box_special_font',
            'post_box_specialbig_font',  'post_box_classical_font', 'post_box_excerpt_font', 'meta_font')
        ),
        'slider_titles' => array(
            'title' => 'Slider Fonts',
            'items' => array('grid_big_font', 'grid_small_font', 'slider3_font', 'slider3_small_font','slider5_font','slider5_small_font','fullwidth_slider_font',
            'slider_2_font')
        ),
        'content' => array(
            'title' => 'Content Fonts',
            'items' => array('text_font', 'pagination_font', 'buttons_font', 'blockquote_font', 'post_titles_font', 'h1_font', 'h2_font','h3_font','h4_font','h5_font','h6_font','label_font')
        ),
        'footer' => array(
            'title' => 'Footer Fonts',
            'items' => array('footer_font')
        ),
        'mobile' => array(
            'title' => 'Mobile Fonts (< 768px)',
            'items' => array('mobile_post_box_vertical_font')
        )
    );
    /* BB press */
    if(class_exists( 'bbPress' )){
        $fonts_array['bbpress_title_font'] = array('name' => 'BBPress Title', 'helpImg'=>'bb-title.jpg');
        $fonts_array['bbpress_text_font'] = array('name' => 'BBPress Text', 'helpImg'=>'bb-text.jpg');
        $fonts_array['bbpress_meta_font'] = array('name' => 'BBPress Meta', 'helpImg'=>'bb-meta.jpg');

        $fonts_structure['bbpress'] = array(
        'title' => 'BBPress Fonts',
        'items' => array('bbpress_title_font', 'bbpress_text_font' , 'bbpress_meta_font')
        );
    }
    /* Buddy press */
    if(class_exists( 'BuddyPress' )){
        $fonts_array['buddypress_title_font'] = array('name' => 'BuddyPress Title', 'helpImg'=>'bp-title.jpg');
        $fonts_array['buddypress_text_font'] = array('name' => 'BuddyPress Text', 'helpImg'=>'bp-text.jpg');
        $fonts_array['buddypress_meta_font'] = array('name' => 'BuddyPress Meta', 'helpImg'=>'bp-meta.jpg');

        $fonts_structure['buddypress'] = array(
        'title' => 'BuddyPress Fonts',
        'items' => array('buddypress_title_font', 'buddypress_text_font' , 'buddypress_meta_font')
        );
    }

    $options[] = array(
        'id' => 'font_manager',
        'type' => 'new_typography',
        'name' => 'Font manager',
        'desc' => '',
        'places' => $fonts_array,
        'structure' => $fonts_structure,
        'switch_mode_toggle' => 'font_settings_mode'
    );
    $options[] = array(
    "name" => "<i class='jaw-icon-mobile'></i>Font Size on Mobile Devices (0 - 768 px)",
    "type" => "sectionstart");

    $options[] = array(
        'id' => 'font_mobile_paragraph',
        'type' => 'text',
        'name' => 'Article font size multiplier' . " " . jwUtils::getHelp("", "", "font-on-mobile.jpg") ,
        'desc' => 'The font on mobile devices will be multiply by this setting.',
        'std' => '1',
        'mod' => 'small'
    );

    $options[] = array(
    "type" => "sectionend");
// 
    $options[] = array(
    "name" => "Preload google fonts",
    "type" => "sectionstart");

    $options[] = array(
    'id' => 'preload_google_fonts',
    'type' => 'toggle',
    'name' => 'Preload google fonts',
    'desc' => 'Load all selected google fonts after page load to avoid flicking fonts after hover etc..',
    'std' => '0'
    );

    $options[] = array(
    "type" => "sectionend");

    $options[] = array(
    "name" => "Character Subsets for Google Fonts",
        "type" => "sectionstart");

    $options[] = array(
    "name" => "Specifying script subsets",
    "id" => "fonts-info2",
    "text" => "<h3>Specifying script subsets</h3><i class='jaw-icon-info'></i> Some of the fonts in the Google Font Directory support multiple scripts (like Latin and Cyrillic for example). In order to specify which subsets should be downloaded, please turn on these toggles.",
        "type" => "info",
    "space" => false,
    "message" => "info"
    );

    $options[] = array(
    'id' => 'latin_support',
    'type' => 'toggle',
    'name' => 'Latin Support',
    'desc' => 'Load the font file with support for Latin charset if possible.',
        'std' => '0'
    );

    $options[] = array(
    'id' => 'latin-ext_support',
    'type' => 'toggle',
    'name' => 'Latin Extended Support',
    'desc' => 'Load the font file with support for Latin extended charset if possible.',
        'std' => '0'
    );

    $options[] = array(
    'id' => 'cyrillic_support',
    'type' => 'toggle',
    'name' => 'Cyrillic Support',
    'desc' => 'Load the font file with support for Cyrillic charset if possible.',
        'std' => '0'
    );

    $options[] = array(
    'id' => 'cyrillic-ext_support',
    'type' => 'toggle',
    'name' => 'Cyrillic Extended Support',
    'desc' => 'Load the font file with support for Cyrillic extended charset if possible.',
        'std' => '0'
    );

    $options[] = array(
    'id' => 'greek_support',
    'type' => 'toggle',
    'name' => 'Greek Support',
    'desc' => 'Load the font file with support for Greek charset if possible.',
        'std' => '0'
    );

    $options[] = array(
    'id' => 'greek-ext_support',
    'type' => 'toggle',
    'name' => 'Greek Extended Support',
    'desc' => 'Load the font file with support for Greek extended charset if possible.',
        'std' => '0'
    );

    $options[] = array(
    'id' => 'devanagari_support',
    'type' => 'toggle',
    'name' => 'Devanagari Support',
    'desc' => 'Load the font file with support for Devanagari charset if possible.',
        'std' => '0'
    );

    $options[] = array(
    'id' => 'vietnamese_support',
    'type' => 'toggle',
    'name' => 'Vietnamese Support',
    'desc' => 'Load the font file with support for Vietnamese charset if possible.',
        'std' => '0'
    );

    $options[] = array(
    'id' => 'khemer_support',
    'type' => 'toggle',
    'name' => 'Khemer Support',
    'desc' => 'Load the font file with support for Khemer charset if possible.',
        'std' => '0'
    );


// 

    $options[] = array(
    "type" => "sectionend");



    $options[] = array("type" => "headingend");
    /* STYLING END ******************************************************* */

    /* CUSTOM CSS ************************************************************* */
// 
    $options[] = array("name" => "Custom Stylesheets",
    "type" => "headingstart");

    $options[] = array("name" => "<i class='jaw-icon-file-css'></i> Custom CSS",
    "desc" => "Simply add some CSS to your theme by adding it to this field.",
    "id" => "custom_css",
    "std" => "",
    "mod" => "css",
    "class" => "fullwidth-option",
    "type" => "ace_editor");

    $options[] = array("name" => "<i class='jaw-icon-screen4'></i> Custom CSS for desktop (992 - &infin;px)",
        "desc" => "Your custom CSS styles from this box will take effect on desktops only.",
    "id" => "custom_css_desktop",
    "std" => "",
    "mod" => "css",
    "class" => "fullwidth-option",
    "type" => "ace_editor");

    $options[] = array("name" => "<i class='jaw-icon-tablet'></i> Custom CSS for tablet (768 - 991px)",
        "desc" => "Your custom CSS styles from this box will take effect on tablet PCs only.",
    "id" => "custom_css_tablet",
    "std" => "",
    "mod" => "css",
    "class" => "fullwidth-option",
    "type" => "ace_editor");

    $options[] = array("name" => "<i class='jaw-icon-mobile'></i> Custom CSS for phones (0 - 767px)",
        "desc" => "Your custom CSS styles from this box will take effect on mobile phones only.",
    "id" => "custom_css_mobile",
    "std" => "",
    "mod" => "css",
    "class" => "fullwidth-option",
    "type" => "ace_editor");

    $options[] = array("type" => "headingend");
// 
    /* CUSTOM CSS END ************************************************** */

    /* CUSTOM JS ************************************************************* */
// 
    $options[] = array("name" => "Custom Scripts",
    "type" => "headingstart");

    $options[] = array("name" => "Custom Javascript Tags in Header",
    "desc" => "Simply add some javascript to your theme by adding it to this field. For custom code add 'script' tag",
    "id" => "custom_js_tag_header",
    "std" => "<script></script>",
    "mod" => "html",
    "class" => "fullwidth-option",
    "type" => "ace_editor");
    

    $options[] = array("name" => "Custom Javascript Header",
    "desc" => "Simply add some javascript to your theme by adding it to this field.",
    "id" => "custom_js_header",
    "std" => "(function(){
        //your code
    })();",
    "mod" => "javascript",
    "class" => "fullwidth-option",
    "type" => "ace_editor");

    $options[] = array("name" => "Custom Javascript Footer",
    "desc" => "Simply add some javascript to your theme by adding it to this field.",
    "id" => "custom_js",
    "std" => "(function(){
        //your code
    })();",
    "mod" => "javascript",
    "class" => "fullwidth-option",
    "type" => "ace_editor");

    $options[] = array("type" => "headingend");
// 
    /* CUSTOM END ************************************************** */

    /* BANNERY  ********************************************************* */
// 
    //background
    $options[] = array("name" => "Background",
    "type" => "headingstart");

    $options[] = array(
    "name" => "info",
    "id" => "BG-info",
    "src" => 'background.jpg',
    "type" => "help_image",
    );

    $options[] = array(
    'id' => 'background_banner_show',
    'type' => 'toggle',
    'name' => 'Show Banner',
    'desc' => 'Choose whether or not to display banner background ads.',
    'std' => '0'
    );

    $options[] = array("name" => "Background Banner Image",
    "desc" => "Click the Upload button and select your prepared background ad.",
    "id" => "background_banner",
    "std" => "",
    "type" => "upload");

    $options[] = array(
    'id' => 'background_banner_image_attachment',
    'type' => 'toggle',
    'name' => 'Background Banner Image Style',
    'desc' => 'Choose whether to allow scrolling a background image or to set it fixed.',
    'std' => 'fixed',
    'options' => array('scroll' => 'Scroll', 'fixed' => 'Fixed')
    );


    $options[] = array("name" => "Banner Link Target",
    "desc" => "Specify where to open an advertise link.",
    "id" => "background_banner_target",
    "std" => "_blank",
    "type" => "select",
    "options" => array("_blank" => "_blank", "_top" => "_top", "_parent" => "_parent", "_self" => "_self"));

    $options[] = array(
    "name" => "Left Side Link",
    "type" => "sectionstart");

    $options[] = array("name" => "Target Link on the Left Side",
    "desc" => "Insert a target URL for the left side of your background ad.",
        "id" => "background_banner_link_left",
    "std" => "http://",
    "type" => "text"
    );

    $options[] = array("name" => "Width of Area for a Target Link on the Left Side",
        "desc" => "Enter a width of the left side banner&acute;s area which has to be an active link (in pixels, e.g. 150).",
    "id" => "background_banner_link_width_left",
    "std" => "0",
    "type" => "text",
    );

    $options[] = array(
    "type" => "sectionend");

    $options[] = array(
    "name" => "Right Side Link",
    "type" => "sectionstart");

    $options[] = array("name" => "Target Link on Right Side",
    "desc" => "Insert a target URL for the right side of your background ad.",
        "id" => "background_banner_link_right",
    "std" => "http://",
    "type" => "text"
    );

    $options[] = array("name" => "Width of Area for a Target Link on Right Side",
        "desc" => "Enter a width of the right side banner&acute;s area which has to be an active link (in pixels, e.g. 150).",
    "id" => "background_banner_link_width_right",
    "std" => "0",
    "type" => "text",

    );

    $options[] = array(
    "type" => "sectionend");


    $options[] = array("type" => "headingend");



    //leader
    $options[] = array("name" => "Leaderboard",
    "type" => "headingstart");

    $options[] = array(
    "name" => "info",
    "id" => "leader-info",
    "src" => 'leaderboard.jpg',
    "type" => "help_image",
    );

    $options[] = array(
    'id' => 'banner_leader_show',
    'type' => 'toggle',
    'name' => 'Show Banner Type',
    'desc' => 'Select a kind of source of the banner. The appropriate options appear after clicking a button.',
    'std' => '0',
    'options' => array('0' => 'Off', "image" => "Image", "google" => "Google")
    );

    $options[] = array(
    "name" => "Banner Image",
    "type" => "sectionstart",
    "ng-show" => "edit['banner_leader_show']=='image'");

    $options[] = array("name" => "Banner Image",
    "desc" => "Click the Upload button to select and upload your banner.",
    "id" => "banner_leader_image",
    "std" => "",
    "type" => "upload");

    $options[] = array("name" => "Target Link",
    "desc" => "Insert a target URL for the Leaderboard banner.",
        "id" => "banner_leader_link",
    "std" => "http://",
    "type" => "text"
    );

    $options[] = array("name" => "Banner Link Target",
    "desc" => "Specify where to open an advertise link.",
    "id" => "banner_leader_link_target",
    "std" => "_blank",
    "type" => "select",
    "options" => array("_blank" => "_blank", "_top" => "_top", "_parent" => "_parent", "_self" => "_self"));

    $options[] = array(
    "type" => "sectionend");

    $options[] = array("name" => "Google Ads Code",
    "desc" => "Insert the Google Ads Code. <b>Notice: You may have at most 3 google ads on one page.</b>",
    "id" => "banner_leader_google",
    "std" => "",
    "ng-show" => "edit['banner_leader_show']=='google'",
    "mod" => "html",
    "type" => "textarea");

    $options[] = array("type" => "headingend");



    // Skyscrapper - Right
    $options[] = array("name" => "Skyscraper Right",
    "type" => "headingstart");

    $options[] = array(
    "name" => "info",
    "id" => "leader-info",
    "src" => 'skyscrapper-right.jpg',
    "type" => "help_image",
    );

    $options[] = array(
    'id' => 'banner_skyscrapper_right_show_on_devices',
    'type' => 'toggle',
    "class" => "top-show-on-devices",
    'name' => 'Show Banner',
    'desc' => 'Choose whether or not and where to show banner - either on desktops or on desktops and tablets.',
    'std' => 'desktop',
    'options' => array("desktop" => "<i class='jaw-icon-screen4'></i>", "tablet" => "<i class='jaw-icon-screen4'></i><i class='jaw-icon-tablet'></i>")
    );

    $options[] = array(
    'id' => 'banner_skyscrapper_right_show',
    'type' => 'toggle',
    'name' => 'Show Banner Type',
    'desc' => 'Select a kind of source of the banner. The appropriate options appear after clicking a button.',
    'std' => '0',
    'options' => array('0' => 'Off', "image" => "Image", "google" => "Google")
    );

    $options[] = array(
    "name" => "Banner Image",
    "type" => "sectionstart",
    "ng-show" => "edit['banner_skyscrapper_right_show']=='image'");

    $options[] = array("name" => "Banner Image",
    "desc" => "Click the Upload button to select and upload your banner.",
    "id" => "banner_skyscrapper_right_image",
    "std" => "",
    "type" => "upload");

    $options[] = array("name" => "Target Link",
    "desc" => "Insert a target URL for the banner.",
    "id" => "banner_skyscrapper_right_link",
    "std" => "http://",
    'maxlength' => 255,
    "type" => "text"
    );
    $options[] = array("name" => "Banner Link Target",
    "desc" => "Specify where to open an advertise link.",
    "id" => "banner_skyscrapper_right_link_target",
    "std" => "_blank",
    "type" => "select",
    "options" => array("_blank" => "_blank", "_top" => "_top", "_parent" => "_parent", "_self" => "_self"));

    $options[] = array(
    "type" => "sectionend");

    $options[] = array("name" => "Google Ads Code",
    "desc" => "Insert the Google Ads Code. <b>Notice: You may have at most 3 google ads on one page.</b>",
    "id" => "banner_skyscrapper_right_google",
    "std" => "",
    "ng-show" => "edit['banner_skyscrapper_right_show']=='google'",
    "mod" => "html",
    "type" => "textarea");

    $options[] = array("type" => "headingend");


    // Skyscrapper left
    $options[] = array("name" => "Skyscraper Left",
    "type" => "headingstart");

    $options[] = array(
    "name" => "info",
    "id" => "leader-info",
    "src" => 'skyscrapper-left.jpg',
    "type" => "help_image",
    );

    $options[] = array(
    'id' => 'banner_skyscrapper_left_show_on_devices',
    'type' => 'toggle',
    "class" => "top-show-on-devices",
    'name' => 'Show Banner',
    'desc' => 'Choose whether or not and where to show banner - either on desktops or on desktops and tablets.',
    'std' => 'desktop',
    'options' => array("desktop" => "<i class='jaw-icon-screen4'></i>", "tablet" => "<i class='jaw-icon-screen4'></i><i class='jaw-icon-tablet'></i>")
    );

    $options[] = array(
    'id' => 'banner_skyscrapper_left_show',
    'type' => 'toggle',
    'name' => 'Show Banner Type',
    'desc' => 'Select a kind of source of the banner. The appropriate options appear after clicking a button.',
    'std' => '0',
    'options' => array('0' => 'Off', "image" => "Image", "google" => "Google")
    );

    $options[] = array(
    "name" => "Banner Image",
    "type" => "sectionstart",
    "ng-show" => "edit['banner_skyscrapper_left_show']=='image'");

    $options[] = array("name" => "Banner Image",
    "desc" => "Click the Upload button to select and upload your banner.",
    "id" => "banner_skyscrapper_left_image",
    "std" => "",
    "type" => "upload");

    $options[] = array("name" => "Target Link",
    "desc" => "Insert a target URL for the banner.",
        "id" => "banner_skyscrapper_left_link",
    "std" => "http://",
    'maxlength' => 255,
    "type" => "text"
    );
    $options[] = array("name" => "Banner Link Target",
    "desc" => "Specify where to open an advertise link.",
    "id" => "banner_skyscrapper_left_link_target",
    "std" => "_blank",
    "type" => "select",
    "options" => array("_blank" => "_blank", "_top" => "_top", "_parent" => "_parent", "_self" => "_self"));

    $options[] = array(
    "type" => "sectionend");

    $options[] = array("name" => "Google Ads Code",
    "desc" => "Insert the Google Ads Code. <b>Notice: You may have at most 3 google ads on one page.</b>",
    "id" => "banner_skyscrapper_left_google",
    "std" => "",
    "mod" => "html",
    "ng-show" => "edit['banner_skyscrapper_left_show']=='google'",
    "type" => "textarea");

    $options[] = array("type" => "headingend");
// 
    // HEADER banner
    $options[] = array(
    "name" => " Banner Header - Beside Logo",
// 
    "name" => "Header - Beside Logo",
// 
    "type" => "headingstart"
    );

    $options[] = array(
    "name" => "info",
    "id" => "leader-info",
    "src" => 'beside-logo.jpg',
    "type" => "help_image",
    );

    $options[] = array(
    "name" => "Header banner",
    "id" => "header-banner-info",
    "text" => "<i class='jaw-icon-warning'></i> This banner is shown only if there has been selected any of presets in <a href='#of-option-logoarea' class='jaw-goto-logoarea' data-goto='logoarea' data-highlight='header_style'><strong>Theme Options > Header Setting > Logo Area > Header Layout</strong></a>, that contain the banner position.",
        "type" => "info",
    "space" => false,
    "message" => "info"
    );

    $options[] = array(
    'id' => 'banner_in_header_show_on_devices',
    'type' => 'toggle',
    "class" => "top-show-on-devices",
    'name' => 'Show Banner',
    'desc' => 'Choose whether or not and where to show banner - either on desktops or on desktops and tablets or on desktops, tablets and phones.',
    'std' => 'phone',
    'options' => array("desktop" => "<i class='jaw-icon-screen4'></i>", "tablet" => "<i class='jaw-icon-screen4'></i><i class='jaw-icon-tablet'></i>", "phone" => "<i class='jaw-icon-screen4'></i><i class='jaw-icon-tablet'></i><i class='jaw-icon-mobile'></i>")
    );

    $options[] = array(
    'id' => 'banner_in_header_show',
    'type' => 'toggle',
    'name' => 'Show Banner Type',
    'desc' => 'Select a kind of source of the banner. The appropriate options appear after clicking a button.',
    'std' => '0',
    'options' => array('0' => 'Off', "image" => "Image", "google" => "Google")
    );

    $options[] = array(
    "name" => "Banner Image",
    "type" => "sectionstart",
    "ng-show" => "edit['banner_in_header_show']=='image'");

    $options[] = array("name" => "Banner Image",
    "desc" => "Click the Upload button to select and upload your banner.",
    "id" => "banner_in_header_image",
    "std" => "",
    "type" => "upload");

    $options[] = array("name" => "Target Link",
    "desc" => "Insert a target URL for the banner.",
        "id" => "banner_in_header_link",
    "std" => "http://",
    'maxlength' => 255,
    "type" => "text"
    );
    $options[] = array("name" => "Banner Link Target",
    "desc" => "Specify where to open an advertise link.",
    "id" => "banner_in_header_link_target",
    "std" => "_blank",
    "type" => "select",
    "options" => array("_blank" => "_blank", "_top" => "_top", "_parent" => "_parent", "_self" => "_self"));

    $options[] = array(
    "type" => "sectionend");

    $options[] = array("name" => "Google Ads Code",
    "desc" => "Insert the Google Ads Code. <b>Notice: You may have at most 3 google ads on one page.</b>",
    "id" => "banner_in_header_google",
    "std" => "",
    "mod" => "html",
    "ng-show" => "edit['banner_in_header_show']=='google'",
    "type" => "textarea");

    $options[] = array("type" => "headingend");


    // Banner IN TOP POST
    $options[] = array(
    "name" => "Banner In Post - Top",
// 
    "name" => "In Post - Top",
// 
    "type" => "headingstart");

    $options[] = array(
    "name" => "info",
    "id" => "leader-info",
    "src" => 'post-top.jpg',
    "type" => "help_image",
    );

    $options[] = array(
    'id' => 'banner_posttop_show_on_devices',
    'type' => 'toggle',
    "class" => "top-show-on-devices",
    'name' => 'Show Banner',
    'desc' => 'Choose whether or not and where to show banner - either on desktops or on desktops and tablets or on desktops, tablets and phones.',
    'std' => 'phone',
    'options' => array("desktop" => "<i class='jaw-icon-screen4'></i>", "tablet" => "<i class='jaw-icon-screen4'></i><i class='jaw-icon-tablet'></i>", "phone" => "<i class='jaw-icon-screen4'></i><i class='jaw-icon-tablet'></i><i class='jaw-icon-mobile'></i>")
    );

    $options[] = array(
    'id' => 'banner_posttop_show',
    'type' => 'toggle',
    'name' => 'Show Banner Type',
    'desc' => 'Select a kind of source of the banner. The appropriate options appear after clicking a button.',
    'std' => '0',
    'options' => array('0' => 'Off', "image" => "Image", "google" => "Google")
    );

    $options[] = array(
    "name" => "Banner Image",
    "type" => "sectionstart",
    "ng-show" => "edit['banner_posttop_show']=='image'");


    $options[] = array("name" => "Banner Image",
    "desc" => "Click the Upload button to select and upload your banner.",
    "id" => "banner_posttop_image",
    "std" => "",
    "type" => "upload");

    $options[] = array("name" => "Target Link",
    "desc" => "Insert a target URL for the banner.",
        "id" => "banner_posttop_link",
    "std" => "http://",
    'maxlength' => 255,
    "type" => "text"
    );
    $options[] = array("name" => "Banner Link Target",
    "desc" => "Specify where to open an advertise link.",
    "id" => "banner_posttop_target",
    "std" => "_blank",
    "type" => "select",
    "options" => array("_blank" => "_blank", "_top" => "_top", "_parent" => "_parent", "_self" => "_self"));

    $options[] = array(
    "type" => "sectionend");

    $options[] = array("name" => "Google Ads Code",
    "desc" => "Insert the Google Ads Code. <b>Notice: You may have at most 3 google ads on one page.</b>",
    "id" => "banner_posttop_google",
    "std" => "",
    "ng-show" => "edit['banner_posttop_show']=='google'",
    "mod" => "html",
    "type" => "textarea");

    $options[] = array("type" => "headingend");


    // Banner IN Bottom POSt
    $options[] = array(
    "name" => "Banner In Post - Bottom",
// 
    "name" => "In Post - Bottom",
// 
    "type" => "headingstart");

    $options[] = array(
    "name" => "info",
    "id" => "leader-info",
    "src" => 'post-bottom.jpg',
    "type" => "help_image",
    );

    $options[] = array(
    'id' => 'banner_postbottom_show_on_devices',
    'type' => 'toggle',
    "class" => "top-show-on-devices",
    'name' => 'Show Banner',
    'desc' => 'Choose whether or not and where to show banner - either on desktops or on desktops and tablets or on desktops, tablets and phones.',
    'std' => 'phone',
    'options' => array("desktop" => "<i class='jaw-icon-screen4'></i>", "tablet" => "<i class='jaw-icon-screen4'></i><i class='jaw-icon-tablet'></i>", "phone" => "<i class='jaw-icon-screen4'></i><i class='jaw-icon-tablet'></i><i class='jaw-icon-mobile'></i>")
    );

    $options[] = array(
    'id' => 'banner_postbottom_show',
    'type' => 'toggle',
    'name' => 'Show Banner Type',
    'desc' => 'Select a kind of source of the banner. The appropriate options appear after clicking a button.',
    'std' => '0',
    'options' => array('0' => 'Off', "image" => "Image", "google" => "Google")
    );

    $options[] = array(
    "name" => "Banner Image",
    "type" => "sectionstart",
    "ng-show" => "edit['banner_postbottom_show']=='image'");


    $options[] = array("name" => "Banner Image",
    "desc" => "Click the Upload button to select and upload your banner.",
    "id" => "banner_postbottom_image",
    "std" => "",
    "type" => "upload");

    $options[] = array("name" => "Target Link",
    "desc" => "Insert a target URL for the banner.",
        "id" => "banner_postbottom_link",
    "std" => "http://",
    'maxlength' => 255,
    "type" => "text"
    );
    $options[] = array("name" => "Banner Link Target",
    "desc" => "Specify where to open an advertise link.",
    "id" => "banner_postbottom_target",
    "std" => "_blank",
    "type" => "select",
    "options" => array("_blank" => "_blank", "_top" => "_top", "_parent" => "_parent", "_self" => "_self"));

    $options[] = array(
    "type" => "sectionend");

    $options[] = array("name" => "Google Ads Code",
    "desc" => "Insert the Google Ads Code. <b>Notice: You may have at most 3 google ads on one page.</b>",
    "id" => "banner_postbottom_google",
    "std" => "",
    "ng-show" => "edit['banner_postbottom_show']=='google'",
    "mod" => "html",
    "type" => "textarea");

    $options[] = array("type" => "headingend");

     // BANNER POST RIGHT
    $options[] = array(
    "name" => "Banner In Post - On Side",
// 
    "name" => "In Post - On Side",
// 
    "type" => "headingstart");

    $options[] = array(
    "name" => "info",
    "id" => "leader-info",
    "src" => 'post-in-side.jpg',
    "type" => "help_image",
    );

    $options[] = array(
    'id' => 'banner_postside_show_on_devices',
    'type' => 'toggle',
    "class" => "top-show-on-devices",
    'name' => 'Show Banner',
    'desc' => 'Choose whether or not and where to show banner - either on desktops or on desktops and tablets or on desktops, tablets and phones.',
    'std' => 'phone',
    'options' => array("desktop" => "<i class='jaw-icon-screen4'></i>", "tablet" => "<i class='jaw-icon-screen4'></i><i class='jaw-icon-tablet'></i>", "phone" => "<i class='jaw-icon-screen4'></i><i class='jaw-icon-tablet'></i><i class='jaw-icon-mobile'></i>")
    );

    $options[] = array(
    'id' => 'banner_postside_show',
    'type' => 'toggle',
    'name' => 'Show Banner Type',
    'desc' => 'Select a kind of source of the banner. The appropriate options appear after clicking a button.',
    'std' => '0',
    'options' => array('0' => 'Off', "image" => "Image", "google" => "Google")
    );

    $options[] = array(
    "name" => "Banner Image",
    "type" => "sectionstart",
    "ng-show" => "edit['banner_postside_show']=='image'");

    $options[] = array("name" => "Banner Image",
    "desc" => "Click the Upload button to select and upload your banner.",
    "id" => "banner_postside_image",
    "std" => "",
    "type" => "upload");

    $options[] = array("name" => "Target Link",
    "desc" => "Insert a target URL for the banner.",
        "id" => "banner_postside_link",
    "std" => "http://",
    'maxlength' => 255,
    "type" => "text"
    );
    $options[] = array("name" => "Banner Link Target",
    "desc" => "Specify where to open an advertise link.",
    "id" => "banner_postside_link_target",
    "std" => "_blank",
    "type" => "select",
    "options" => array("_blank" => "_blank", "_top" => "_top", "_parent" => "_parent", "_self" => "_self"));

    $options[] = array(
    "type" => "sectionend");

    $options[] = array("name" => "Google Ads Code",
    "desc" => "Insert the Google Ads Code. <b>Notice: You may have at most 3 google ads on one page.</b>",
    "id" => "banner_postside_google",
    "std" => "",
    "mod" => "html",
    "ng-show" => "edit['banner_postside_show']=='google'",
    "type" => "textarea");

    $options[] = array("type" => "headingend");
    // END BANNER POST RIGHT

    // Banner Custom Widget - 1
    $options[] = array("name" => "Custom Banner 1",
    "type" => "headingstart");

    $options[] = array(
    'id' => 'banner_custom_1_show_on_devices',
    'type' => 'toggle',
    "class" => "top-show-on-devices",
    'name' => 'Show Custom Banner 1 @size(729x90, 970x90)',
    'desc' => 'Choose whether or not and where to show banner - either on desktops or on desktops and tablets or on desktops, tablets and phones.',
    'std' => 'phone',
    'options' => array("desktop" => "<i class='jaw-icon-screen4'></i>", "tablet" => "<i class='jaw-icon-screen4'></i><i class='jaw-icon-tablet'></i>", "phone" => "<i class='jaw-icon-screen4'></i><i class='jaw-icon-tablet'></i><i class='jaw-icon-mobile'></i>")
    );

    $options[] = array(
    'id' => 'banner_custom_1_show',
    'type' => 'toggle',
    'name' => 'Show Banner Type',
    'desc' => 'Select a kind of source of the banner. The appropriate options appear after clicking a button.',
    'std' => '0',
    'options' => array('0' => 'Off', "image" => "Image", "google" => "Google")
    );

    $options[] = array(
    "name" => "Banner Image",
    "type" => "sectionstart",
    "ng-show" => "edit['banner_custom_1_show']=='image'");

    $options[] = array("name" => "Banner Image",
    "desc" => "Click the Upload button to select and upload your banner.",
    "id" => "banner_custom_1_image",
    "std" => "",
    "type" => "upload");

    $options[] = array("name" => "Target Link",
    "desc" => "Insert a target URL for the banner.",
    "id" => "banner_custom_1_link",
    "std" => "http://",
    'maxlength' => 255,
    "type" => "text"
    );
    $options[] = array("name" => "Banner Link Target",
    "desc" => "Specify where to open an advertise link.",
    "id" => "banner_w_1_link_target",
    "std" => "_blank",
    "type" => "select",
    "options" => array("_blank" => "_blank", "_top" => "_top", "_parent" => "_parent", "_self" => "_self"));

    $options[] = array(
    "type" => "sectionend");

    $options[] = array("name" => "Google Ads Code",
    "desc" => "Insert the Google Ads Code. <b>Notice: You may have at most 3 google ads on one page.</b>",
    "id" => "banner_custom_1_google",
    "std" => "",
    "mod" => "html",
    "ng-show" => "edit['banner_custom_1_show']=='google'",
    "type" => "textarea");

    $options[] = array("type" => "headingend");

    // Banner custom2
    $options[] = array("name" => "Custom Banner 2",
    "type" => "headingstart");

    $options[] = array(
    'id' => 'banner_custom_2_show_on_devices',
    'type' => 'toggle',
    "class" => "top-show-on-devices",
    'name' => 'Show Custom Banner 2 @size(250x250, 250x250x 300x250)',
    'desc' => 'Choose whether or not and where to show banner - either on desktops or on desktops and tablets or on desktops, tablets and phones.',
    'std' => 'phone',
    'options' => array("desktop" => "<i class='jaw-icon-screen4'></i>", "tablet" => "<i class='jaw-icon-screen4'></i><i class='jaw-icon-tablet'></i>", "phone" => "<i class='jaw-icon-screen4'></i><i class='jaw-icon-tablet'></i><i class='jaw-icon-mobile'></i>")
    );

    $options[] = array(
    'id' => 'banner_custom_2_show',
    'type' => 'toggle',
    'name' => 'Show Banner Type',
    'desc' => 'Select a kind of source of the banner. The appropriate options appear after clicking a button.',
    'std' => '0',
    'options' => array('0' => 'Off', "image" => "Image", "google" => "Google")
    );

    $options[] = array(
    "name" => "Banner Image",
    "type" => "sectionstart",
    "ng-show" => "edit['banner_custom_2_show']=='image'");

    $options[] = array("name" => "Banner Image",
    "desc" => "Click the Upload button to select and upload your banner.",
    "id" => "banner_custom_2_image",
    "std" => "",
    "type" => "upload");

    $options[] = array("name" => "Target Link",
    "desc" => "Insert a target URL for the banner.",
        "id" => "banner_custom_2_link",
    "std" => "http://",
    'maxlength' => 255,
    "type" => "text"
    );
    $options[] = array("name" => "Banner Link Target",
    "desc" => "Specify where to open an advertise link.",
    "id" => "banner_w_2_link_target",
    "std" => "_blank",
    "type" => "select",
    "options" => array("_blank" => "_blank", "_top" => "_top", "_parent" => "_parent", "_self" => "_self"));

    $options[] = array(
    "type" => "sectionend");

    $options[] = array("name" => "Google Ads Code",
    "desc" => "Insert the Google Ads Code. <b>Notice: You may have at most 3 google ads on one page.</b>",
    "id" => "banner_custom_2_google",
    "std" => "",
    "mod" => "html",
    "ng-show" => "edit['banner_custom_2_show']=='google'",
    "type" => "textarea");

    $options[] = array("type" => "headingend");

    // Banner custom 3
    $options[] = array("name" => "Custom Banner 3",
    "type" => "headingstart");

    $options[] = array(
    'id' => 'banner_custom_3_show_on_devices',
    'type' => 'toggle',
    "class" => "top-show-on-devices",
    'name' => 'Show Custom Banner 3 @size(160x600, 300x600)',
    'desc' => 'Choose whether or not and where to show banner - either on desktops or on desktops and tablets or on desktops, tablets and phones.',
    'std' => 'phone',
    'options' => array("desktop" => "<i class='jaw-icon-screen4'></i>", "tablet" => "<i class='jaw-icon-screen4'></i><i class='jaw-icon-tablet'></i>", "phone" => "<i class='jaw-icon-screen4'></i><i class='jaw-icon-tablet'></i><i class='jaw-icon-mobile'></i>")
    );

    $options[] = array(
    'id' => 'banner_custom_3_show',
    'type' => 'toggle',
    'name' => 'Show Banner Type',
    'desc' => 'Select a kind of banners to be displayed. Depending on your choice, the appropriate options will be available after clicking a button.',
    'std' => '0',
    'options' => array('0' => 'Off', "image" => "Image", "google" => "Google")
    );

    $options[] = array(
    "name" => "Banner Image",
    "type" => "sectionstart",
    "ng-show" => "edit['banner_custom_3_show']=='image'");

    $options[] = array("name" => "Banner Image",
    "desc" => "Click the Upload button to select and upload your banner.",
    "id" => "banner_custom_3_image",
    "std" => "",
    "type" => "upload");

    $options[] = array("name" => "Target Link",
    "desc" => "Insert a target URL for the banner.",
        "id" => "banner_custom_3_link",
    "std" => "http://",
    'maxlength' => 255,
    "type" => "text"
    );
    $options[] = array("name" => "Banner Link Target",
    "desc" => "Specify where to open an advertise link.",
    "id" => "banner_w_3_link_target",
    "std" => "_blank",
    "type" => "select",
    "options" => array("_blank" => "_blank", "_top" => "_top", "_parent" => "_parent", "_self" => "_self"));

    $options[] = array(
    "type" => "sectionend");

    $options[] = array("name" => "Google Ads Code",
    "desc" => "Insert the Google Ads Code. <b>Notice: You may have at most 3 google ads on one page.</b>",
    "id" => "banner_custom_3_google",
    "std" => "",
    "mod" => "html",
    "ng-show" => "edit['banner_custom_3_show']=='google'",
    "type" => "textarea");

    $options[] = array("type" => "headingend");

    // Banner custom 4
    $options[] = array("name" => "Custom Banner 4",
    "type" => "headingstart");

    $options[] = array(
    'id' => 'banner_custom_4_show_on_devices',
    'type' => 'toggle',
    "class" => "top-show-on-devices",
    'name' => 'Show Custom Banner 4 @size(970x250)',
    'desc' => 'Choose whether or not and where to show banner - either on desktops or on desktops and tablets or on desktops, tablets and phones.',
    'std' => 'phone',
    'options' => array("desktop" => "<i class='jaw-icon-screen4'></i>", "tablet" => "<i class='jaw-icon-screen4'></i><i class='jaw-icon-tablet'></i>", "phone" => "<i class='jaw-icon-screen4'></i><i class='jaw-icon-tablet'></i><i class='jaw-icon-mobile'></i>")
    );

    $options[] = array(
    'id' => 'banner_custom_4_show',
    'type' => 'toggle',
    'name' => 'Show Banner Type',
    'desc' => 'Select a kind of banners to be displayed. Depending on your choice, the appropriate options will be available after clicking a button.',
    'std' => '0',
    'options' => array('0' => 'Off', "image" => "Image", "google" => "Google")
    );

    $options[] = array(
    "name" => "Banner Image",
    "type" => "sectionstart",
    "ng-show" => "edit['banner_custom_4_show']=='image'");

    $options[] = array("name" => "Banner Image",
    "desc" => "Click the Upload button to select and upload your banner.",
    "id" => "banner_custom_4_image",
    "std" => "",
    "type" => "upload");

    $options[] = array("name" => "Target Link",
    "desc" => "Insert a target URL for the banner.",
        "id" => "banner_custom_4_link",
    "std" => "http://",
    'maxlength' => 255,
    "type" => "text"
    );
    $options[] = array("name" => "Banner Link Target",
    "desc" => "Specify where to open an advertise link.",
    "id" => "banner_w_4_link_target",
    "std" => "_blank",
    "type" => "select",
    "options" => array("_blank" => "_blank", "_top" => "_top", "_parent" => "_parent", "_self" => "_self"));

    $options[] = array(
    "type" => "sectionend");

    $options[] = array("name" => "Google Ads Code",
    "desc" => "Insert the Google Ads Code. <b>Notice: You may have at most 3 google ads on one page.</b>",
    "id" => "banner_custom_4_google",
    "std" => "",
    "mod" => "html",
    "ng-show" => "edit['banner_custom_4_show']=='google'",
    "type" => "textarea");

    $options[] = array("type" => "headingend");

    // Banner custom 5
    $options[] = array("name" => "Custom Banner 5",
    "type" => "headingstart");

    $options[] = array(
    'id' => 'banner_custom_5_show_on_devices',
    'type' => 'toggle',
    "class" => "top-show-on-devices",
    'name' => 'Show Custom Banner 5 @size(728x90 + 970x90)',
    'desc' => 'Choose whether or not and where to show banner - either on desktops or on desktops and tablets or on desktops, tablets and phones.',
    'std' => 'phone',
    'options' => array("desktop" => "<i class='jaw-icon-screen4'></i>", "tablet" => "<i class='jaw-icon-screen4'></i><i class='jaw-icon-tablet'></i>", "phone" => "<i class='jaw-icon-screen4'></i><i class='jaw-icon-tablet'></i><i class='jaw-icon-mobile'></i>")
    );

    $options[] = array(
    'id' => 'banner_custom_5_show',
    'type' => 'toggle',
    'name' => 'Show Banner Type',
    'desc' => 'Select a kind of banners to be displayed. Depending on your choice, the appropriate options will be available after clicking a button.',
    'std' => '0',
    'options' => array('0' => 'Off', "image" => "Image", "google" => "Google")
    );

    $options[] = array(
    "name" => "Banner Image",
    "type" => "sectionstart",
    "ng-show" => "edit['banner_custom_5_show']=='image'");

    $options[] = array("name" => "Banner Image",
    "desc" => "Click the Upload button to select and upload your banner.",
    "id" => "banner_custom_5_image",
    "std" => "",
    "type" => "upload");

    $options[] = array("name" => "Target Link",
    "desc" => "Insert a target URL for the banner.",
        "id" => "banner_custom_5_link",
    "std" => "http://",
    'maxlength' => 255,
    "type" => "text"
    );
    $options[] = array("name" => "Banner Link Target",
    "desc" => "Specify where to open an advertise link.",
    "id" => "banner_w_5_link_target",
    "std" => "_blank",
    "type" => "select",
    "options" => array("_blank" => "_blank", "_top" => "_top", "_parent" => "_parent", "_self" => "_self"));

    $options[] = array(
    "type" => "sectionend");

    $options[] = array("name" => "Google Ads Code",
    "desc" => "Insert the Google Ads Code. <b>Notice: You may have at most 3 google ads on one page.</b>",
    "id" => "banner_custom_5_google",
    "std" => "",
    "mod" => "html",
    "ng-show" => "edit['banner_custom_5_show']=='google'",
    "type" => "textarea");

    $options[] = array("type" => "headingend");

// 
    // Banner custom 6
    $options[] = array("name" => "Custom Banner 6",
    "type" => "headingstart");

    $options[] = array(
    'id' => 'banner_custom_6_show_on_devices',
    'type' => 'toggle',
    "class" => "top-show-on-devices",
    'name' => 'Show Custom Banner 6 @size(200x200 + 250x250 + 300x250)',
    'desc' => 'Choose whether or not and where to show banner - either on desktops or on desktops and tablets or on desktops, tablets and phones.',
    'std' => 'phone',
    'options' => array("desktop" => "<i class='jaw-icon-screen4'></i>", "tablet" => "<i class='jaw-icon-screen4'></i><i class='jaw-icon-tablet'></i>", "phone" => "<i class='jaw-icon-screen4'></i><i class='jaw-icon-tablet'></i><i class='jaw-icon-mobile'></i>")
    );

    $options[] = array(
    'id' => 'banner_custom_6_show',
    'type' => 'toggle',
    'name' => 'Show Banner Type',
    'desc' => 'Select a kind of banners to be displayed. Depending on your choice, the appropriate options will be available after clicking a button.',
    'std' => '0',
    'options' => array('0' => 'Off', "image" => "Image", "google" => "Google")
    );

    $options[] = array(
    "name" => "Banner Image",
    "type" => "sectionstart",
    "ng-show" => "edit['banner_custom_6_show']=='image'");

    $options[] = array("name" => "Banner Image",
    "desc" => "Click the Upload button to select and upload your banner.",
    "id" => "banner_custom_6_image",
    "std" => "",
    "type" => "upload");

    $options[] = array("name" => "Target Link",
    "desc" => "Insert a target URL for the banner.",
        "id" => "banner_custom_6_link",
    "std" => "http://",
    'maxlength' => 300,
    "type" => "text"
    );
    $options[] = array("name" => "Banner Link Target",
    "desc" => "Specify where to open an advertise link.",
    "id" => "banner_w_6_link_target",
    "std" => "_blank",
    "type" => "select",
    "options" => array("_blank" => "_blank", "_top" => "_top", "_parent" => "_parent", "_self" => "_self"));

    $options[] = array(
    "type" => "sectionend");

    $options[] = array("name" => "Google Ads Code",
    "desc" => "Insert the Google Ads Code. <b>Notice: You may have at most 3 google ads on one page.</b>",
    "id" => "banner_custom_6_google",
    "std" => "",
    "mod" => "html",
    "ng-show" => "edit['banner_custom_2_show']=='google'",
    "type" => "textarea");

    $options[] = array("type" => "headingend");

    // Banner custom 7
    $options[] = array("name" => "Custom Banner 7",
    "type" => "headingstart");

    $options[] = array(
    'id' => 'banner_custom_7_show_on_devices',
    'type' => 'toggle',
    "class" => "top-show-on-devices",
    'name' => 'Show Custom Banner 7 @size(160x600 + 300x600)',
    'desc' => 'Choose whether or not and where to show banner - either on desktops or on desktops and tablets or on desktops, tablets and phones.',
    'std' => 'phone',
    'options' => array("desktop" => "<i class='jaw-icon-screen4'></i>", "tablet" => "<i class='jaw-icon-screen4'></i><i class='jaw-icon-tablet'></i>", "phone" => "<i class='jaw-icon-screen4'></i><i class='jaw-icon-tablet'></i><i class='jaw-icon-mobile'></i>")
    );

    $options[] = array(
    'id' => 'banner_custom_7_show',
    'type' => 'toggle',
    'name' => 'Show Banner Type',
    'desc' => 'Select a kind of banners to be displayed. Depending on your choice, the appropriate options will be available after clicking a button.',
    'std' => '0',
    'options' => array('0' => 'Off', "image" => "Image", "google" => "Google")
    );

    $options[] = array(
    "name" => "Banner Image",
    "type" => "sectionstart",
    "ng-show" => "edit['banner_custom_7_show']=='image'");

    $options[] = array("name" => "Banner Image",
    "desc" => "Click the Upload button to select and upload your banner.",
    "id" => "banner_custom_7_image",
    "std" => "",
    "type" => "upload");

    $options[] = array("name" => "Target Link",
    "desc" => "Insert a target URL for the banner.",
        "id" => "banner_custom_7_link",
    "std" => "http://",
    'maxlength' => 300,
    "type" => "text"
    );
    $options[] = array("name" => "Banner Link Target",
    "desc" => "Specify where to open an advertise link.",
    "id" => "banner_w_7_link_target",
    "std" => "_blank",
    "type" => "select",
    "options" => array("_blank" => "_blank", "_top" => "_top", "_parent" => "_parent", "_self" => "_self"));

    $options[] = array(
    "type" => "sectionend");

    $options[] = array("name" => "Google Ads Code",
    "desc" => "Insert the Google Ads Code. <b>Notice: You may have at most 3 google ads on one page.</b>",
    "id" => "banner_custom_7_google",
    "std" => "",
    "mod" => "html",
    "ng-show" => "edit['banner_custom_2_show']=='google'",
    "type" => "textarea");

    $options[] = array("type" => "headingend");

    // Banner custom 8
    $options[] = array("name" => "Custom Banner 8",
    "type" => "headingstart");

    $options[] = array(
    'id' => 'banner_custom_8_show_on_devices',
    'type' => 'toggle',
    "class" => "top-show-on-devices",
    'name' => 'Show Custom Banner 8 @size(160x600 + 300x600)',
    'desc' => 'Choose whether or not and where to show banner - either on desktops or on desktops and tablets or on desktops, tablets and phones.',
    'std' => 'phone',
    'options' => array("desktop" => "<i class='jaw-icon-screen4'></i>", "tablet" => "<i class='jaw-icon-screen4'></i><i class='jaw-icon-tablet'></i>", "phone" => "<i class='jaw-icon-screen4'></i><i class='jaw-icon-tablet'></i><i class='jaw-icon-mobile'></i>")
    );

    $options[] = array(
    'id' => 'banner_custom_8_show',
    'type' => 'toggle',
    'name' => 'Show Banner Type',
    'desc' => 'Select a kind of banners to be displayed. Depending on your choice, the appropriate options will be available after clicking a button.',
    'std' => '0',
    'options' => array('0' => 'Off', "image" => "Image", "google" => "Google")
    );

    $options[] = array(
    "name" => "Banner Image",
    "type" => "sectionstart",
    "ng-show" => "edit['banner_custom_8_show']=='image'");

    $options[] = array("name" => "Banner Image",
    "desc" => "Click the Upload button to select and upload your banner.",
    "id" => "banner_custom_8_image",
    "std" => "",
    "type" => "upload");

    $options[] = array("name" => "Target Link",
    "desc" => "Insert a target URL for the banner.",
        "id" => "banner_custom_8_link",
    "std" => "http://",
    'maxlength' => 300,
    "type" => "text"
    );
    $options[] = array("name" => "Banner Link Target",
    "desc" => "Specify where to open an advertise link.",
    "id" => "banner_w_8_link_target",
    "std" => "_blank",
    "type" => "select",
    "options" => array("_blank" => "_blank", "_top" => "_top", "_parent" => "_parent", "_self" => "_self"));

    $options[] = array(
    "type" => "sectionend");

    $options[] = array("name" => "Google Ads Code",
    "desc" => "Insert the Google Ads Code. <b>Notice: You may have at most 3 google ads on one page.</b>",
    "id" => "banner_custom_8_google",
    "std" => "",
    "mod" => "html",
    "ng-show" => "edit['banner_custom_2_show']=='google'",
    "type" => "textarea");

    $options[] = array("type" => "headingend");

    // Banner custom 9
    $options[] = array("name" => "Custom Banner 9",
    "type" => "headingstart");

    $options[] = array(
    'id' => 'banner_custom_9_show_on_devices',
    'type' => 'toggle',
    "class" => "top-show-on-devices",
    'name' => 'Show Custom Banner 9',
    'desc' => 'Choose whether or not and where to show banner - either on desktops or on desktops and tablets or on desktops, tablets and phones.',
    'std' => 'phone',
    'options' => array("desktop" => "<i class='jaw-icon-screen4'></i>", "tablet" => "<i class='jaw-icon-screen4'></i><i class='jaw-icon-tablet'></i>", "phone" => "<i class='jaw-icon-screen4'></i><i class='jaw-icon-tablet'></i><i class='jaw-icon-mobile'></i>")
    );

    $options[] = array(
    'id' => 'banner_custom_9_show',
    'type' => 'toggle',
    'name' => 'Show Banner Type',
    'desc' => 'Select a kind of banners to be displayed. Depending on your choice, the appropriate options will be available after clicking a button.',
    'std' => '0',
    'options' => array('0' => 'Off', "image" => "Image", "google" => "Google")
    );

    $options[] = array(
    "name" => "Banner Image",
    "type" => "sectionstart",
    "ng-show" => "edit['banner_custom_9_show']=='image'");

    $options[] = array("name" => "Banner Image",
    "desc" => "Click the Upload button to select and upload your banner.",
    "id" => "banner_custom_9_image",
    "std" => "",
    "type" => "upload");

    $options[] = array("name" => "Target Link",
    "desc" => "Insert a target URL for the banner.",
        "id" => "banner_custom_9_link",
    "std" => "http://",
    'maxlength' => 300,
    "type" => "text"
    );
    $options[] = array("name" => "Banner Link Target",
    "desc" => "Specify where to open an advertise link.",
    "id" => "banner_w_9_link_target",
    "std" => "_blank",
    "type" => "select",
    "options" => array("_blank" => "_blank", "_top" => "_top", "_parent" => "_parent", "_self" => "_self"));

    $options[] = array(
    "type" => "sectionend");

    $options[] = array("name" => "Google Ads Code",
    "desc" => "Insert the Google Ads Code. <b>Notice: You may have at most 3 google ads on one page.</b>",
    "id" => "banner_custom_9_google",
    "std" => "",
    "mod" => "html",
    "ng-show" => "edit['banner_custom_2_show']=='google'",
    "type" => "textarea");

    $options[] = array("type" => "headingend");

    // Banner custom 10
    $options[] = array("name" => "Custom Banner 10",
    "type" => "headingstart");

    $options[] = array(
    'id' => 'banner_custom_10_show_on_devices',
    'type' => 'toggle',
    "class" => "top-show-on-devices",
    'name' => 'Show Custom Banner 10',
    'desc' => 'Choose whether or not and where to show banner - either on desktops or on desktops and tablets or on desktops, tablets and phones.',
    'std' => 'phone',
    'options' => array("desktop" => "<i class='jaw-icon-screen4'></i>", "tablet" => "<i class='jaw-icon-screen4'></i><i class='jaw-icon-tablet'></i>", "phone" => "<i class='jaw-icon-screen4'></i><i class='jaw-icon-tablet'></i><i class='jaw-icon-mobile'></i>")
    );

    $options[] = array(
    'id' => 'banner_custom_10_show',
    'type' => 'toggle',
    'name' => 'Show Banner Type',
    'desc' => 'Select a kind of banners to be displayed. Depending on your choice, the appropriate options will be available after clicking a button.',
    'std' => '0',
    'options' => array('0' => 'Off', "image" => "Image", "google" => "Google")
    );

    $options[] = array(
    "name" => "Banner Image",
    "type" => "sectionstart",
    "ng-show" => "edit['banner_custom_10_show']=='image'");

    $options[] = array("name" => "Banner Image",
    "desc" => "Click the Upload button to select and upload your banner.",
    "id" => "banner_custom_10_image",
    "std" => "",
    "type" => "upload");

    $options[] = array("name" => "Target Link",
    "desc" => "Insert a target URL for the banner.",
        "id" => "banner_custom_10_link",
    "std" => "http://",
    'maxlength' => 300,
    "type" => "text"
    );
    $options[] = array("name" => "Banner Link Target",
    "desc" => "Specify where to open an advertise link.",
    "id" => "banner_w_10_link_target",
    "std" => "_blank",
    "type" => "select",
    "options" => array("_blank" => "_blank", "_top" => "_top", "_parent" => "_parent", "_self" => "_self"));

    $options[] = array(
    "type" => "sectionend");

    $options[] = array("name" => "Google Ads Code",
    "desc" => "Insert the Google Ads Code. <b>Notice: You may have at most 3 google ads on one page.</b>",
    "id" => "banner_custom_10_google",
    "std" => "",
    "mod" => "html",
    "ng-show" => "edit['banner_custom_2_show']=='google'",
    "type" => "textarea");

    $options[] = array("type" => "headingend");


    // BANNER GALLERY
    $options[] = array("name" => "In Gallery",
    "type" => "headingstart");

    $options[] = array(
    "name" => "info",
    "id" => "leader-info",
    "src" => 'gallery.jpg',
    "type" => "help_image",
    );

    $options[] = array(
    'id' => 'banner_gallery_show_on_devices',
    'type' => 'toggle',
    "class" => "top-show-on-devices",
    'name' => 'Show Banner',
    'desc' => 'Choose whether or not and where to show banner - either on desktops or on desktops and tablets or on desktops, tablets and phones.',
    'std' => 'phone',
    'options' => array("desktop" => "<i class='jaw-icon-screen4'></i>", "tablet" => "<i class='jaw-icon-screen4'></i><i class='jaw-icon-tablet'></i>", "phone" => "<i class='jaw-icon-screen4'></i><i class='jaw-icon-tablet'></i><i class='jaw-icon-mobile'></i>")
    );

    $options[] = array(
    'id' => 'banner_gallery_show',
    'type' => 'toggle',
    'name' => 'Show Banner Type',
    'desc' => 'Select a kind of source of the banner. The appropriate options appear after clicking a button.',
    'std' => '0',
    'options' => array('0' => 'Off', "image" => "Image", "google" => "Google")
    );

    $options[] = array(
    'id' => 'banner_gallery_fixed',
    'type' => 'toggle',
    'name' => 'Fixed Position of Banner',
    'desc' => 'Turn on/off fixing the position of the banner.',
    'std' => '0'
    );


    $options[] = array(
    "name" => "Banner Image",
    "type" => "sectionstart",
    "ng-show" => "edit['banner_gallery_show']=='image'");


    $options[] = array("name" => "Banner Image",
    "desc" => "Click the Upload button to select and upload your banner.",
    "id" => "banner_gallery",
    "std" => "",
    "type" => "upload");

    $options[] = array("name" => "Target Link",
    "desc" => "Insert a target URL for the banner.",
        "id" => "banner_gallery_link",
    "std" => "http://",
    'maxlength' => 255,
    "type" => "text"
    );
    $options[] = array("name" => "Banner Link Target",
    "desc" => "Specify where to open an advertise link.",
    "id" => "banner_gallery_link_target",
    "std" => "_blank",
    "type" => "select",
    "options" => array("_blank" => "_blank", "_top" => "_top", "_parent" => "_parent", "_self" => "_self"));

    $options[] = array(
    "type" => "sectionend");

    $options[] = array("name" => "Google Ads Code",
    "desc" => "Insert the Google Ads Code. <b>Notice: You may have at most 3 google ads on one page.</b>",
    "id" => "banner_gallery_google",
    "std" => "",
    "ng-show" => "edit['banner_gallery_show']=='google'",
    "mod" => "html",
    "type" => "textarea");

    $options[] = array("type" => "headingend");
    // END BANNER GALLERY
// 
   

    /* END BANNERS ******************************************************* */

    /* 404  **************************************************** */
// 
    $options[] = array("name" => "Error 404",
    "type" => "headingstart");

    $options[] = array("name" => "404 HTML",
    "desc" => "Insert a HTML code of the content you want to appear instead of common browser page when the 404 error occurs.",
    "id" => "error_custom_html",
    "rows" => 20,
    "std" => '<h1>File Not Found</h1>
    <div class="error">
    <p class="bottom">The page you are looking for might have been removed, had its name changed, or is temporarily unavailable.</p>
        </div>
    <p>Please try the following:</p>
    <ul>
    <li>Return to the <a href="' . JAW_SITE_URL . '">home page</a></li>
    </ul>',
    "mod" => "html",
    "type" => "ace_editor");

    $options[] = array("type" => "headingend");



    /* BACKUP  **************************************************** */

    $options[] = array("name" => "Backup Options",
    "type" => "headingstart");

    $options[] = array("name" => "Backup and Restore Options",
    "id" => "of_backup",
    "std" => "",
    "type" => "backup",
    "desc" => 'Backup of all options and presets. <br><br>You can use the two buttons below to backup your current options, and then restore them back later. This is useful if you want to experiment with options but would like to keep the old settings in case you need it back.<br><br>You can also transfer your saved options or presets data between different installations by copying a content inside the text boxes below.',
        );

    $options[] = array("name" => "Transfer ALL Settings",
    "id" => "of_transfer",
    "std" => "",
    "type" => "transfer",
    "target" => "all",
    "desc" => "To import data from another installation, replace the data in the text box with those from another installation and click the Import button.",
    );

    $options[] = array("name" => "Transfer Theme Options Data",
    "id" => "of_transfer",
    "std" => "",
    "type" => "transfer",
    "target" => "themeoptions",
    "desc" => "To import data from another installation, replace the data in the text box with those from another installation and click the Import button.",
    );
    $options[] = array("name" => "Transfer Category Options Data",
    "id" => "of_transfer_category",
    "std" => "",
    "type" => "transfer",
    "target" => "category",
    "desc" => "To import data from another installation, replace the data in the text box with those from another installation and click the Import button.<br><br>NOTE: This pre-filled text box contains options settings data from all your categories.",
    );


    $options[] = array(
    "name" => "Category Preset Manager",
    "type" => "sectionstart");

    $options[] = array(
    'id' => 'category_preset_export',
    'type' => 'options_preset_export',
    'name' => 'Category Preset Export/Delete',
    'desc' => 'Choose the category preset you want to export (from those you have created in <strong>Posts > Categories > Category Preset</strong>) and click the Export button.<br><br>Copy and keep a content of the field, which subsequently appears, for your later use via the <strong>One Category Preset Import</strong> option below.',
        'std' => '',
    'target' => 'category'
    );
    $options[] = array(
    'id' => 'category_preset_import',
    'type' => 'options_preset_import',
    'name' => 'One Category Preset Import',
    'desc' => 'Click into the field, paste the exported data of one of your category presets above and click the Import button. <br><br><strong>NOTE: Does not forget to SAVE changes after importing the data.</strong>',
    'std' => '',
    'target' => 'category'
    );
    $options[] = array("name" => "Transfer All Categories Presets",
    "id" => "of_transfer_cat",
    "std" => "",
    "type" => "preset_transfer",
    "target" => "category",
    "desc" => "To import data from all your categories presets from another installation, replace the data in the text box with them and click the Import button.<br><br>NOTE: This pre-filled text box contains the data of all the current categories presets.",
    );
    $options[] = array(
    "type" => "sectionend");

    $options[] = array(
    "name" => "Single Post Preset Manager",
    "type" => "sectionstart");
    $options[] = array(
    'id' => 'single_preset_export',
    'type' => 'options_preset_export',
    'name' => 'Single Post Preset Export/Delete',
    'desc' => 'Choose the single post preset you want to export (from those you have created in <strong>Posts > <em>your post</em> > General Settings > Single Preset</strong>) and click the Export button.<br><br>Copy and keep a content of the field, which subsequently appears, for your later use via the <strong>One Single Post Preset Import</strong> option below.',
        'std' => '',
    'target' => 'single'
    );
    $options[] = array(
    'id' => 'single_preset_import',
    'type' => 'options_preset_import',
    'name' => 'One Single Post Preset Import',
    'desc' => 'Click into the field, paste the exported data of one of your single posts presets above and click the Import button. <br><br><strong>NOTE: Does not forget to SAVE changes after importing the data.</strong>',
    'std' => '',
    'target' => 'single'
    );
    $options[] = array("name" => "Transfer All Single Posts Presets Data",
    "id" => "of_transfer_single",
    "std" => "",
    "type" => "preset_transfer",
    "target" => "single",
    "desc" => "To import data from all your single posts presets from another installation, replace the data in the text box with them and click the Import button.<br><br>NOTE: This pre-filled text box contains the data of all the current single posts presets.",
    );

    $options[] = array(
    "type" => "sectionend");

    $options[] = array(
    "name" => "Color Scheme Manager",
    "type" => "sectionstart");
    $options[] = array(
    'id' => 'color_scheme_export',
    'type' => 'options_preset_export',
    'name' => 'Color Scheme Export/Delete',
    'desc' => 'Choose the color scheme you want to export (from those you have created in <strong>Theme Options > Styling Options > Color Settings <em>section</em></strong>) and click the Export button.<br><br>Copy and keep a content of the field, which subsequently appears, for your later use via the <strong>One Color Scheme Import</strong> option below.',
        'std' => '',
    'target' => 'color'
    );
    $options[] = array(
    'id' => 'color_scheme_import',
    'type' => 'options_preset_import',
    'name' => 'One Color Scheme Import',
    'desc' => 'Click into the field, paste the exported data of one of your color schemes above and click the Import button. <br><br><strong>NOTE: Does not forget to SAVE changes after importing the data.</strong>',
    'std' => '',
    'target' => 'color'
    );
    $options[] = array("name" => "Transfer All Color Scheme Data",
    "id" => "of_transfer_color",
    "std" => "",
    "type" => "preset_transfer",
    "target" => "color",
    "desc" => "To import settings of all your color schemes from another installation, replace the data in the text box with them and click the Import button.<br><br>NOTE: This pre-filled text box contains the data of settings of all the current color schemes.",
    );
    $options[] = array(
    "type" => "sectionend");

    $options[] = array(
    "name" => "RevoComposer Presets Manager",
    "type" => "sectionstart");
    $options[] = array(
    'id' => 'revo_presets_export',
    'type' => 'options_preset_export',
    'name' => 'RevoComposer Presets Export/Delete',
    'desc' => 'Choose the preset from the RevoComposer pagebuilder you want to export (from those you have created in <strong>Pages > <em>your page</em> > REVO</strong>ComposerII<strong>&nbsp;<em>tab</em> > Presets</strong>) and click the Export button.<br><br>Copy and keep a content of the field, which subsequently appears, for your later use via the <strong>One RevoComposer Preset Import</strong> option below.',
        'std' => '',
    'target' => 'revo'
    );
    $options[] = array(
    'id' => 'revo_presets_import',
    'type' => 'options_preset_import',
    'name' => 'One RevoComposer Preset Import',
    'desc' => 'Click into the field, paste the exported data of one of your RevoComposer presets above and click the Import button.<br><br><strong>NOTE: Does not forget to SAVE changes after importing the data.</strong>',
    'std' => '',
    'target' => 'revo'
    );
    $options[] = array("name" => "Transfer All RevoComposer Presets Data",
    "id" => "of_transfer_revo",
    "std" => "",
    "type" => "preset_transfer",
    "target" => "revo",
    "desc" => "To import all your RevoComposer presets from another installation, replace the data in the text box with them and click the Import button.<br><br>NOTE: This pre-filled text box contains the data of all the current RevoComposer presets.",
    );
    $options[] = array(
    "type" => "sectionend");

    $options[] = array(
    "name" => "RevoComposer Elements Presets Manager",
    "type" => "sectionstart");
    $options[] = array(
    'id' => 'revoelement_presets_export',
    'type' => 'options_preset_export',
    'name' => 'RevoComposer Elements Preset Export/Delete',
    'desc' => 'Choose the elements preset from the RevoComposer pagebuilder you want to export (from those you have created in <strong>Pages > <em>your page</em> > REVO</strong>ComposerII<strong>&nbsp;<em>tab</em> > Elements Presets</strong>) and click the Export button.<br><br>Copy and keep a content of the field, which subsequently appears, for your later use via the <strong>One RevoComposer Elements Preset Import</strong> option below.',
        'std' => '',
    'target' => 'revoelement'
    );
    $options[] = array(
    'id' => 'revoelement_presets_import',
    'type' => 'options_preset_import',
    'name' => 'One RevoComposer Elements Presets Import',
    'desc' => 'Click into the field, paste the exported data of one of your RevoComposer elements presets above and click the Import button.<br><br><strong>NOTE: Does not forget to SAVE changes after importing the data.</strong>',
    'std' => '',
    'target' => 'revoelement'
    );
    $options[] = array("name" => "Transfer All RevoComposer Elements Presets Data",
    "id" => "of_transfer_revoelement",
    "std" => "",
    "type" => "preset_transfer",
    "target" => "revoelement",
    "desc" => "To import all your RevoComposer elements presets from another installation, replace the data in the text box with them and click the Import button.<br><br>NOTE: This pre-filled text box contains the data of all the current RevoComposer elements presets.",
    );
    $options[] = array(
    "type" => "sectionend");

    $options[] = array("type" => "headingend");
// 

    // DEMO **********************************************************
    $options[] = array("name" => "Demo Data",
    "type" => "headingstart");

    $options[] = array(
    "name" => "Imort DEMO",
    "id" => "info-demo",
    "text" => "<h3 style=\"margin: 0 0 10px;\">Warning:</h3> Importing into a fresh Wordpress installation is recommended.<br><br>Don`t forget to install and activate all required plugins before installation of demo content.<br><br>When uploading the demo content you may lose your data. Don&acute;t forget to back-up your database before you choose this option, please.<br><br> When you import the demo at the first time, the whole data will be imported while with the next updates you will get only the presets.",
    "type" => "info",
    "space" => false,
    "message" => "warnings"
    );

    $options[] = array(
    "name" => "Imort DEMO",
    "id" => "info-demo-2",
    "text" => "The demo included in the theme is a smaller version of the official demo, we couldn`t include the whole demo because we wanted to keep the theme as small as possible.",
    "type" => "info",
    "space" => false,
    "message" => "info"
    );


    $options[] = array(
    "name" => "Import Sample Data",
    "space" => true,
    "id" => "import-sample-preset1",
    "demos" => array(
            "demo01" => "Lifestyle mag",
            "demo02" => "Men`s magazine",
            "demo03" => "Fashion mag",
            "demo04" => "27news",
            "demo05" => "Food blog",
            "demo06" => "World news",
            "demo07" => "Travel blog",
            "demo08" => "Video shannel",
            "demo10" => "Sleek Mag",
            "demo11" => "Movie news",
            "demo12" => "Geek blog",
            "demo13" => "Business Week",
            "demo14" => "Smartness"
            ),
    "type" => "importpreset",
    "class" => "fullwidth-option"
    );



    $options[] = array("type" => "headingend");




    //TRANSLATIONS ******************************************************
//  
    $options[] = array("name" => "Translations",
    "hide_in_customise" => true,
    "type" => "headingstart");

    $options[] = array(
    'id' => 'use_translation',
    'type' => 'toggle',
    'name' => 'Use This Translation',
    'desc' => '',
    'std' => '0',
    "hide_in_customise" => true,
    );

    $options[] = array(
    'id' => 'translation',
    'type' => 'translation',
    'name' => 'Translations',
    'desc' => '',
    'class' => 'fullwidth-option',
    "hide_in_customise" => true,
    );


    $options[] = array("type" => "headingend");


    // API keys **********************************************************
    $options[] = array("name" => "API Keys",
     "hide_in_customise" => true,
    "type" => "headingstart");

    //START FB
    $options[] = array(
    "name" => "<i class='jaw-icon-facebook4 '></i> Facebook API",
    "hide_in_customise" => true,
    "type" => "sectionstart");


    $options[] = array(
    "name" => "FB info",
    "id" => "fb-info",
    "text" => '<b>1.</b> Create a new application <a href="https://developers.facebook.com/apps/" target="_blank">HERE</a><br><br>
    <b>2.</b> Select "website" and name your application<br><br>
    <b>3.</b> Click "Create new Facebook APP ID"<br><br>
    <b>4.</b> Select category and click "Create App ID"<br><br>
    <b>5.</b> Click "Skip quick start" in right top corner<br><br>
    <b>6.</b> Copy App ID and App Secret<br><br>
    <strong><u>Save the Theme Options and refresh this page.</u></strong><br><br>
    <b>7.</b> Now you should see App Token here<br><br>
    <strong><u>Save the Theme Options.</u></strong>',
    "type" => "info",
    "space" => false,
    "message" => "info",
    "hide_in_customise" => true,
    );

    $options[] = array(
    'id' => 'fbcomments_appid',
    'type' => 'text',
    'mod' => 'large',
    'name' => 'Facebook App ID',
    'desc' => 'For sharing your site and create FB commentary. For more information please visit <a href="https://developers.facebook.com/apps/">HERE</a>.',
    'std' => "",
    "hide_in_customise" => true,
    );

    $options[] = array(
    'id' => 'fbcomments_secret',
    'type' => 'text',
    'mod' => 'large',
    'name' => 'Facebook App Secret',
    'desc' => 'For sharing your site and create FB commentary. For more information please visit <a href="https://developers.facebook.com/apps/">HERE</a>.',
    'std' => "",
    "hide_in_customise" => true,
    );
    $options[] = array(
    'id' => 'fb_token',
    'type' => 'facebook',
    'name' => 'Facebook App Token',
    'desc' => 'Follow the instructions in the cyan box above, please.',
    'std' => "",
    "hide_in_customise" => true,
    );

    $options[] = array(
    'id' => 'fbcomments_moderated',
    'type' => 'button',
    'name' => 'Comments Moderation Area',
    'desc' => "When you're a moderator you will see notifications within facebook.com. If you don't want to have moderator status or want to see all comments in one area, use this link.",
    'std' => '1',
    'href' => 'https://developers.facebook.com/tools/comments',
    'title' => 'Go to  Moderation Area',
    'target' => '_blank',
    "hide_in_customise" => true,
    );
    $options[] = array(
    "type" => "sectionend");
    //END FB
    //START TWITTER
    $options[] = array(
    "name" => "<i class='jaw-icon-twitter3'></i> Twitter API ",
    "type" => "sectionstart");

    $options[] = array(
    "name" => "twitter info",
    "id" => "twitter-info",
    "text" => '<b>1.</b> Create a new application <a href="https://dev.twitter.com/apps/new" target="_blank">HERE</a>.
    <br><br>
    <b>2.</b> Set the Name, Description, etc... (Callback URL keep blank)
    <br><br>
    <b>3.</b> Now click on the "Keys and Access Tokens".
    <br><br>
    <b>4.</b> Copy "Consumer Key (API Key)" and "Consumer Secret (API Secret)" and paste them into the appropriate fields below.
    <br><br>
    <b>5.</b> Underneath click "Create my access tokens".
    <br><br>
    <b>6.</b> Copy "Access Token" and "Access Token Secret" and paste them into the appropriate fields below.
    <br><br><strong><u>Save the Theme Options.</u></strong>',
    "type" => "info",
    "space" => false,
    "message" => "info",
    "hide_in_customise" => true,
    );


    $options[] = array(
    'id' => 'tw_consumer_id',
    'type' => 'text',
    'mod' => 'large',
    'name' => 'API Key',
    'desc' => 'To get this key, please go to <a href="https://dev.twitter.com/apps/new" target="_blank">HERE</a>',
    'std' => "",
    "hide_in_customise" => true,
    );
    $options[] = array(
    'id' => 'tw_consumer_secret',
    'type' => 'text',
    'mod' => 'large',
    'name' => 'API Secret',
    'desc' => 'To get this key, please go to <a href="https://dev.twitter.com/apps/new" target="_blank">HERE</a>',
    'std' => "",
    "hide_in_customise" => true,
    );
    $options[] = array(
    'id' => 'tw_access_id',
    'type' => 'text',
    'mod' => 'large',
    'name' => 'Access Token',
    'desc' => 'To get this key, please go to <a href="https://dev.twitter.com/apps/new" target="_blank">HERE</a>',
    'std' => "",
    "hide_in_customise" => true,
    );
    $options[] = array(
    'id' => 'tw_access_secret',
    'type' => 'text',
    'mod' => 'large',
    'name' => 'Access Token Secret',
    'desc' => 'To get this key, please go to <a href="https://dev.twitter.com/apps/new" target="_blank">HERE</a>',
    'std' => "",
    "hide_in_customise" => true,
    );


    $options[] = array(
    "type" => "sectionend");
    //END TWITTER
    //START INSTAGRAM
    $options[] = array(
    "name" => "<i class='jaw-icon-instagram'></i> Instagram API",
    "type" => "sectionstart");

    $options[] = array(
    "name" => "Instagram info",
    "id" => "Instagram-info",
    "text" => '<b>1.</b> Create a new application <a href="http://instagram.com/developer/clients/manage/#" target="_blank">HERE</a>.<br><br><b>Set the "Redirect URI" to "' . JAW_SITE_URL . '/wp-admin/themes.php?page=optionsframework"</b>. <br><br>Get both the "Client ID" and the "Client Secret" keys and paste them into the appropriate fields below.
    <br><br><strong><u>Save the Theme Options and refresh this page (F5).</u></strong>
    <br><br>
    <b>2.</b> Now click on the "Get Instagram Access Token".
    <br><br><strong><u>Save the Theme Options and refresh this page again.</u></strong>
    <br><br>
    <i>To get your USER ID, please click <a href="http://jelled.com/instagram/lookup-user-id">here</a> (you need this ID for setting up the J&W - Social Widget).</i>',
    "type" => "info",
    "space" => false,
    "message" => "info",
    "hide_in_customise" => true,
    );

    $options[] = array(
    'id' => 'i_client_id',
    'type' => 'text',
    'mod' => 'large',
    'name' => 'App Client ID',
    'desc' => 'To get this key, please go to <a href="http://instagram.com/developer/clients/manage/#">HERE</a>',
    'std' => "",
    "hide_in_customise" => true,
    );

    $options[] = array(
    'id' => 'i_client_secret',
    'type' => 'text',
    'mod' => 'large',
    'name' => 'App Client Secret',
    'desc' => 'To get this key, please go to <a href="http://instagram.com/developer/clients/manage/#">HERE</a>',
    'std' => "",
    "hide_in_customise" => true,
    );


    $options[] = array(
    'id' => 'instagram_token',
    'type' => 'instagram',
    'name' => 'Instagram App Token',
    'desc' => 'Follow the instructions in the cyan box above, please.',
    'std' => "",
    "hide_in_customise" => true,
    );

    $options[] = array(
    "type" => "sectionend");
    // END instagram

    //START youtube
    $options[] = array(
    "name" => "<i class='jaw-icon-instagram'></i> YouTube API",
    "type" => "sectionstart");

    $options[] = array(
    "name" => "YouTube info",
    "id" => "youtube-info",
    "text" => '<b>1.</b> Create a new project <a href="https://console.developers.google.com/project" target="_blank">HERE</a>.<br><br>
    <b>2.</b> Set the name. Click "Create"<br><br>
    <b>3.</b> Go to APIs&auth -> APIs (on the left side) and click the YouTube Data API.<br><br>
    <b>4.</b> Click the Enable API.<br><br>
    <b>5.</b> Got to APIs&auth -> Credentials -> Add credentials -> OAuth 2.0 client ID.<br><br>
    <b>6.</b> Click "Web application"<br><br>
    <b>7.</b> Set the "name".<br><br>
    <b>8.</b> Set the"Authorized redirect URIs" to "' . JAW_SITE_URL . '/wp-admin/themes.php?page=optionsframework". Click the "Create"<br><br>
    <b>9.</b> Get both the "Client ID" and the "Client Secret" keys and paste them into the appropriate fields below.
    <br><br><strong><u>Save the Theme Options and refresh this page (F5).</u></strong>
    <br><br>
    <b>10.</b> Now click on the "Get YouTube Access Token".
    <br><br><strong><u>Save the Theme Options and refresh this page again.</u></strong>
    <br><br>
    <i>To get your USER ID, please click <a href="http://jelled.com/instagram/lookup-user-id">here</a> (you need this ID for setting up the J&W - Social Widget).</i>',
    "type" => "info",
    "space" => false,
    "message" => "info",
    "hide_in_customise" => true,
    );

    $options[] = array(
    'id' => 'y_client_id',
    'type' => 'text',
    'mod' => 'large',
    'name' => 'App Client ID',
    'desc' => 'To get this key, please go to <a href="https://console.developers.google.com/project" target="_blank">HERE</a>',
    'std' => "",
    "hide_in_customise" => true,
    );

    $options[] = array(
    'id' => 'y_client_secret',
    'type' => 'text',
    'mod' => 'large',
    'name' => 'App Client Secret',
    'desc' => 'To get this key, please go to <a href="https://console.developers.google.com/project" target="_blank">HERE</a>',
    'std' => "",
    "hide_in_customise" => true,
    );


    $options[] = array(
    'id' => 'youtube_token',
    'type' => 'youtube',
    'name' => 'YouTube App Tokens',
    'desc' => 'Follow the instructions in the cyan box above, please.',
    'std' => "",
    "hide_in_customise" => true,
    );

    $options[] = array(
    "type" => "sectionend");
    // END youtube


    $options[] = array(
    "name" => "<i class='jaw-icon-tumblr2'></i> Thumblr API",
    "type" => "sectionstart");


    $options[] = array(
    "name" => "Thumblr info",
    "id" => "Thumblr-info",
    "text" => '<b>1.</b> Create a new project <a href="https://www.tumblr.com/oauth/apps" target="_blank">HERE</a>.<br><br>
    <b>2.</b> Click "Register application"<br><br>
    <b>3.</b> Set Application name, etc ... "Default callback URL" set to  "' . JAW_SITE_URL . '/wp-admin/themes.php?page=optionsframework"<br><br>
    <b>4.</b> Click "Show secret key".<br><br>
    <b>5.</b> Copy "OAuth Consumer Key" and "Secret Key" and paste them into the appropriate fields below.<br><br>',
    "type" => "info",
    "space" => false,
    "message" => "info",
    "hide_in_customise" => true,
    );

    $options[] = array(
    'id' => 't_api_key',
    'type' => 'text',
    'mod' => 'large',
    'name' => 'Api key',
    'desc' => 'To get this key, please go to <a href="https://www.tumblr.com/oauth/apps" target="_blank">HERE</a>',
    'std' => "",
    "hide_in_customise" => true,
    );

    $options[] = array(
    'id' => 't_api_secret',
    'type' => 'text',
    'mod' => 'large',
    'name' => 'Api secret',
    'desc' => 'To get this key, please go to <a href="https://www.tumblr.com/oauth/apps" target="_blank">HERE</a>',
    'std' => "",
    "hide_in_customise" => true,
    );

    $options[] = array(
    "type" => "sectionend");



    $options[] = array("type" => "headingend");

// 

// 

    /* END ************** END *************** END ******************** */

    $menu['welcome'] = array('submenu' => 0, 'name' => 'Welcome', "icon" => "jaw-icon-home2");
    $menu['generalsettings'] = array('submenu' => 0, 'name' => 'General Settings', "icon" => "jaw-icon-settings-new2");
    $menu['headersettings'] = array('submenu' => 1, 'name' => 'Header Settings', "icon" => "jaw-icon-header");
    $menu['topbar'] = array('submenu' => 1, 'name' => 'Top Bar');
    $menu['undertopbararea'] = array('submenu' => 1, 'name' => 'Under Top Bar Area');
    $menu['logoarea'] = array('submenu' => 1, 'name' => 'Logo Area');
    $menu['menu'] = array('submenu' => 1, 'name' => 'Menu');
    $menu['abovecontentarea'] = array('submenu' => 1, 'name' => 'Above Content Area');
    $menu['breadcrumbs'] = array('submenu' => -1, 'name' => 'Breadcrumbs');
    $menu['footer'] = array('submenu' => 0, 'name' => 'Footer Settings', "icon" => "jaw-icon-footer");
    $menu['mynews'] = array('submenu' => 0, 'name' => 'My News', "icon" => "jaw-icon-user");
    $menu['blogposts'] = array('submenu' => 1, 'name' => 'Blog & Posts', "icon" => "jaw-icon-blog");
    $menu['postssettings'] = array('submenu' => 1, 'name' => 'Posts Settings');
    $menu['mainblog'] = array('submenu' => -1, 'name' => 'Main Blog');
    $menu['singlepost'] = array('submenu' => 0, 'name' => 'Single Post', "icon" => "jaw-icon-post");
    if (is_plugin_active('jaw-customposts/jawcustomposts.php')) {
        $menu['jawgallerysettings'] = array('submenu' => 0, 'name' => 'JaW Gallery Settings', "icon" => "jaw-icon-images2");
    }
    if (class_exists('BuddyPress')) {
        $menu['buddypress'] = array('submenu' => 0, 'name' => 'BuddyPress', "icon" => "jaw-icon-users4");
    }
    $menu['sidebarmanager'] = array('submenu' => 0, 'name' => 'Sidebar Manager', "icon" => "jaw-icon-sidebar");
    $menu['customstylesheets'] = array('submenu' => 0, 'name' => 'Custom Stylesheets', "icon" => "jaw-icon-file-css");
    $menu['customscripts'] = array('submenu' => 0, 'name' => 'Custom Scripts', "icon" => "jaw-icon-dollar");
    $menu['stylingoptions'] = array('submenu' => 1, 'name' => 'Styling Options', "icon" => "jaw-icon-brush");
    $menu['backgroundstyle'] = array('submenu' => 1, 'name' => 'Background Style');
    $menu['colorsettings'] = array('submenu' => 1, 'name' => 'Color Settings');
    $menu['other'] = array('submenu' => -1, 'name' => 'Other');
    $menu['typographyoptions'] = array('submenu' => 0, 'name' => 'Typography Options', "icon" => "jaw-icon-font");
    $menu['advertisementd'] = array('submenu' => 1, 'name' => 'Advertisement', "icon" => "jaw-icon-ad");
    $menu['background'] = array('submenu' => 1, 'name' => 'Background');
    $menu['leaderboard'] = array('submenu' => 1, 'name' => 'Leaderboard');
    $menu['header-besidelogo'] = array('submenu' => 1, 'name' => 'Header - Beside Logo');
    $menu['skyscraperright'] = array('submenu' => 1, 'name' => 'Skyscraper Right');
    $menu['skyscraperleft'] = array('submenu' => 1, 'name' => 'Skyscraper Left');
    $menu['inpost-top'] = array('submenu' => 1, 'name' => 'In Post - Top');
    $menu['inpost-bottom'] = array('submenu' => 1, 'name' => 'In Post - Bottom');
    $menu['inpost-onside'] = array('submenu' => 1, 'name' => 'In Post - On Side');
    $menu['ingallery'] = array('submenu' => 1, 'name' => 'In Gallery');
    $menu['custombanner1'] = array('submenu' => 1, 'name' => 'Custom Banner 1');
    $menu['custombanner2'] = array('submenu' => 1, 'name' => 'Custom Banner 2');
    $menu['custombanner3'] = array('submenu' => 1, 'name' => 'Custom Banner 3');
    $menu['custombanner4'] = array('submenu' => 1, 'name' => 'Custom Banner 4');
    $menu['custombanner5'] = array('submenu' => 1, 'name' => 'Custom Banner 5');
    $menu['custombanner6'] = array('submenu' => 1, 'name' => 'Custom Banner 6');
    $menu['custombanner7'] = array('submenu' => 1, 'name' => 'Custom Banner 7');
    $menu['custombanner8'] = array('submenu' => 1, 'name' => 'Custom Banner 8');
    $menu['custombanner9'] = array('submenu' => 1, 'name' => 'Custom Banner 9');
    $menu['custombanner10'] = array('submenu' => -1, 'name' => 'Custom Banner 10');
    $menu['error404'] = array('submenu' => 0, 'name' => 'Error 404', "icon" => "jaw-icon-warning");
    $menu['backupoptions'] = array('submenu' => 0, 'name' => 'Backup', "icon" => "jaw-icon-spinner11");
    $menu['demodata'] = array('submenu' => 0, 'name' => 'Demo', "icon" => "jaw-icon-folder-download");
    $menu['translations'] = array('submenu' => 0, 'name' => 'Translations', "icon" => "jaw-icon-type");
    $menu['apikeys'] = array('submenu' => 0, 'name' => 'API Keys', "icon" => "jaw-icon-rocket");
