<?php

global $metapost, $metacat, $metapage, $metapostformats;

/**
 *  Defines metaboxes for pages and posts
 *  Warning id must prefix "_"  e.g.: id="_layout"
 * 
 * 
 */
// 
$metapost = array(
    "id" => "jawmetabox",
    "title" => "General Settings",
    "pages" => array('post'),
    "context" => "normal", //Optional. The context within the page where the boxes should show ('normal', 'advanced')
    "priority" => "high", //Optional. The priority within the context where the boxes should show ('high', 'low').
    "desc" => null,
    "fields" => array()
);
$metapost['fields'][] = array(
    'id' => 'jaw_single_preset_val',
    'type' => 'options_preset',
    'name' => '<i class="jaw-icon-file jaw-preset-icon"></i> Single Preset',
    'desc' => '',
    'target' => 'single'
);

$metapost['fields'][] = array(
    'id' => 'jaw_perex_gallery_box',
    'name' => 'Gallery ID',
    "std" => "",
    "type" => "advselect",
    'chosen' => 'true',
    'target' => 'gallery'
);
// 

$js_post_type = "jQuery(window).ready(function($){

if($('input:radio[name=post_format]:checked').val() == 'video'){
    prepinac_video(true);
    prepinac_gallery(false);
    prepinac_link(false);
    prepinac_quote(false);
}else if($('input:radio[name=post_format]:checked').val() == 'gallery'){
    prepinac_gallery(true);
    prepinac_video(false);
    prepinac_link(false);
    prepinac_quote(false);
}else if($('input:radio[name=post_format]:checked').val() == 'link'){
    prepinac_gallery(false);
    prepinac_video(false);
    prepinac_link(true);
    prepinac_quote(false);
}else if($('input:radio[name=post_format]:checked').val() == 'quote'){
    prepinac_gallery(false);
    prepinac_video(false);
    prepinac_link(false);
    prepinac_quote(true);
}else{
    prepinac_video(false);
    prepinac_gallery(false);
    prepinac_link(false);
    prepinac_quote(false);
}

jQuery('.post-format').click(function() {
    prepinac_video(false);
    prepinac_gallery(false);
    prepinac_link(false);
    prepinac_quote(false);
});

jQuery('#post-format-video').click(function() {
     prepinac_video(true);
     prepinac_gallery(false);
     prepinac_link(false);
     prepinac_quote(false);
});
jQuery('#post-format-gallery').click(function() {
     prepinac_video(false);
     prepinac_gallery(true);
     prepinac_link(false);
     prepinac_quote(false);
});
jQuery('#post-format-link').click(function() {
     prepinac_video(false);
     prepinac_gallery(false);
     prepinac_link(true);
     prepinac_quote(false);
});
jQuery('#post-format-quote').click(function() {
     prepinac_video(false);
     prepinac_gallery(false);
     prepinac_link(false);
     prepinac_quote(true);
});


function prepinac_video(sw){
    switch(sw){
    case true: $('#section-jaw_post_video_link').show(300);
        break;
    case false: $('#section-jaw_post_video_link').hide(300);
        break;   
    }
}

function prepinac_gallery(sw){
    switch(sw){
    case true: $('#section-jaw_post_gallery').show(300);
        break;
    case false: $('#section-jaw_post_gallery').hide(300);
        break;   
    }
}
function prepinac_link(sw){
    switch(sw){
    case true: $('#section-jaw_post_link').show(300);
        break;
    case false: $('#section-jaw_post_link').hide(300);
        break;   
    }
}
function prepinac_quote(sw){
    switch(sw){
    case true: $('#section-jaw_post_quote_author').show(300);
        break;
    case false: $('#section-jaw_post_quote_author').hide(300);
        break;   
    }
}

});";

$metapostformats = array(
    "id" => "jawmetaboxpostformats",
    "title" => "Post formats",
    "pages" => array('post'),
    "context" => "advanced", //Optional. The context within the page where the boxes should show ('normal', 'advanced')
    "priority" => "low", //Optional. The priority within the context where the boxes should show ('high', 'low').
    "desc" => null,
    "js" => $js_post_type, //Oprional. Insert javascript
    "fields" => array()
);

// POST FORMATS
$metapostformats['fields'][] = array(
    "name" => "Gallery - for post format gallery",
    "desc" => "",
    "id" => "jaw_post_gallery",
    "type" => "media_picker"
);

$metapostformats['fields'][] = array("name" => "Video URL - for post format video (Supported: Youtube, Vimeo, Vine, Dailymotion, Facebook, Self-hosted .mp4)",
    "desc" => "",
    "id" => "jaw_post_video_link",
    "std" => "",
    "mod" => "medium",
    "type" => "text");
$metapostformats['fields'][] = array("name" => "Link URL - for post format link",
    "desc" => "",
    "id" => "jaw_post_link",
    "std" => "",
    "mod" => "medium",
    "type" => "text");
$metapostformats['fields'][] = array("name" => "Author of quote - for post format quote",
    "desc" => "",
    "id" => "jaw_post_quote_author",
    "std" => "",
    "mod" => "medium",
    "type" => "text");
// END POST FORMATS



$metacat = array(
    "id" => "custom",
    "pages" => array("category"),
    "fields" => array()
);


global $metabuild;
unset($metabuild['build_layout_bookmark']);
unset($metabuild['build_preset_bookmark']);
unset($metabuild['build_element_preset_bookmark']);
$metacat['fields'][] = array(
    "name" => "Featured Area Above Page",
    "desc" => 'Use it just like regular RevoComposer',
    "id" => "featured_top_revo",
    "type" => "jaw_builder", //jaw_builder
    'content' => $metabuild,
    "areas" => "{
                'content': [
                    {'id': '2_content', 'type': 'content', 'size': 12}
                ]
            }"
);

global $metabuild;
unset($metabuild['build_layout_bookmark']);
unset($metabuild['build_preset_bookmark']);
unset($metabuild['build_element_preset_bookmark']);
$metacat['fields'][] = array(
    "name" => "Featured Area Under Category Title",
    "desc" => 'Use it just like regular RevoComposer',
    "id" => "featured_content_revo",
    "type" => "jaw_builder", //jaw_builder
    'content' => $metabuild,
    "areas" => "{
                'content': [
                    {'id': '2_content', 'type': 'content', 'size': 12}
                ]
            }"
);


$metacat['fields'][] = array(
    'id' => 'content_color',
    'name' => '<i class="jaw-icon-palette jaw-preset-icon"></i> Color Scheme',
    'desc' => '',
    'std' => '_default',
    'type' => 'select_preset',
    "target" => "color"
);

/* * ******************* title & description area ******************* */

$metacat['fields'][] = array(
    'id' => 'title_position',
    'type' => 'select',
    'name' => 'Where to show category title',
    'desc' => '',
    'std' => 'content',
    'options' => array('top' => 'In header', 'content' => 'Next to sidebar') //TADY TO CHCE LEPSI POPISEK
);

$metacat['fields'][] = array(
    'id' => 'cat_title_bar',
    'type' => 'select',
    'name' => 'Category Title Bar',
    'desc' => "Decide whether or not to enable the page title bar. If you want to show image please don't forget set it below",
    'std' => '1',
    "options" => array( 
        "0" => "Hide", 
        "1" => "Show",
// 
        "2" => "Show with image and color"
// 
    )
);

// 
$metacat['fields'][] = array(
    'id' => 'title_bg_img',
    'type' => 'simple_media_picker',
    'name' => 'Title Background Image',
    "ng-show" => "edit['cat_title_bar']=='2'",
    'desc' => '<span style="color: red">Works only if "Category Title Bar" is set to "Show with image and color" </span>',
);

$metacat['fields'][] = array(
    'id' => 'title_text_color',
    'type' => 'color',
    'name' => 'Title & Description Text Color',
    'desc' => '<span style="color: red">Works only if "Category Title Bar" is set to "Show with image and color" </span>',
    "ng-show" => "edit['cat_title_bar']=='2'",
    'std' => '#666666'
);
// 






/* * ******************* END title & description area ******************* */


/* * ******************* presets ******************* */

// 
$metacat['fields'][] = array(
    'id' => 'category_preset',
    'type' => 'options_preset',
    'name' => '<i class="jaw-icon-stack-list jaw-preset-icon"></i> Category Preset',
    'desc' => '',
    'target' => 'category'
);
$metacat['fields'][] = array(
    'id' => 'single_preset',
    'type' => 'options_preset',
    'name' => '<i class="jaw-icon-file jaw-preset-icon"></i> Single Preset',
    'desc' => '',
    'target' => 'single'
);
// 
/* * ******************* END presets ******************* */




$metapage = array(
    "id" => "jawmetapage",
    "title" => "General Settings",
    "pages" => array('page'),
    "context" => "normal", //Optional. The context within the page where the boxes should show ('normal', 'advanced')
    "priority" => "high", //Optional. The priority within the context where the boxes should show ('high', 'low').
    "desc" => null,
    "fields" => array()
);

// 
$metapage['fields'][] = array(
    'id' => 'jaw_page_color',
    'name' => '<i class="jaw-icon-palette jaw-preset-icon"></i> Page Color Style',
    'desc' => 'Select a style from this list of those you have created in <strong>Theme Options > Styling Options > Color Settings > Main Color Scheme</strong>.<br><br><span class="jaw-default">Default: Theme Options > Styling Options > Color Settings > Main Color Scheme</span>',
    'type' => 'select_preset',
    "target" => "color"
);
// 

$metapage['fields'][] = array(
    'id' => 'jaw_page_breadcrumbs',
    'type' => 'select',
    'name' => 'Breadcrumbs On Page'. " " . jwUtils::getHelp("", "", "breadcrumbs-no-page.jpg"),
// 
    'desc' => 'Select a way to manage displaying of breadcrumb navigation on this page. <br><strong>DEFAULT: </strong>Theme Options -> Header Settings -> Breadcrumbs -> Show Breadcrumbs on Pages',
    'std' => '_default',
// 
// 
    "options" => array(
// 
        "_default" => "Default (by Theme Options)",
//  
        "1" => "Show", 
        "-1" => "Off - without gap", 
        "0" => "Hide - keep space"
        )
);

$metapage['fields'][] = array(
    'id' => 'jaw_page_title_bar',
    'type' => 'select',
    'name' => 'Page Title Bar',
    'desc' => "Decide whether or not to enable the page title bar. If you want to show image please don't forget to set it below.",
    'std' => '1',
    "options" => array( 
        "0" => "Hide", 
        "1" => "Show",
// 
        "2" => "Show with image"
// 
        )
);

// 
$metapage['fields'][] = array(
    'id' => 'jaw_page_title_bg_img',
    'type' => 'simple_media_picker',
    "ng-show" => "edit['jaw_page_title_bar']=='2'",
    'name' => 'Title Background Image',
    'desc' => 'Choose a title background image for this page or remove the chosen one. <span style="color: red">Works only if "Category Title Bar" is set to "Show with image and color" </span>',
);

$metapage['fields'][] = array(
    'id' => 'jaw_page_title_text_clr',
    'type' => 'color',
    "ng-show" => "edit['jaw_page_title_bar']=='2'",
    'name' => 'Title & Description Text Color',
    'desc' => 'Select a background color for titles and descriptions on this page. <span style="color: red">Works only if "Category Title Bar" is set to "Show with image and color" </span>',
    'std' => '#666666'
);
// 