<?php

global $jaw_category_preset;

$jaw_category_preset = array();

$header_styles_img_default = array(
    'bar_type_1' => JAW_ADMIN_URI . 'assets/images/left_border.png',
    'bar_type_2' => JAW_ADMIN_URI . 'assets/images/top_bottom.png',
    'bar_type_3' => JAW_ADMIN_URI . 'assets/images/with_background.png',
    'bar_type_4' => JAW_ADMIN_URI . 'assets/images/bar_type_4.png',
    'bar_type_big_left' => JAW_ADMIN_URI . 'assets/images/title_big_left.png',
    'bar_type_big_center' => JAW_ADMIN_URI . 'assets/images/title_big_center.png',
    'bar_type_big_right' => JAW_ADMIN_URI . 'assets/images/title_big_right.png',
);
$sb_size = array(
    '2' => 'Slim',
    '3' => 'Normal',
    '4' => 'Wide',
);

/* ==== Category main ==== */
$jaw_category_preset[] = array(
    "name" => "Preset title",
    "type" => "sectionstart",
    "class" => "jaw-preset-title");

$jaw_category_preset[] = array(
    'id' => 'title',
    'type' => 'text',
    'name' => 'Name of your Preset',
    'std' => 'preset_' . rand(),
);


$jaw_category_preset[] = array(
    "type" => "sectionend");

/* ==== Category main ==== */
$jaw_category_preset[] = array(
    "name" => "Category Setting",
    "type" => "sectionstart");


$jaw_category_preset[] = array(
    'id' => 'blog_pagination',
    'type' => 'select',
    'name' => 'Pagination Style',
    'desc' => 'Select the pagination style you prefer.',
    'std' => 'infinitemore',
    'mod' => 'medium',
    
    'options' => array("infinite" => "infinite", "infinitemore" => "infinite with more", "none" => "none", "number" => "number", "wordpress" => "wordpress"),
);

$jaw_category_preset[] = array(
    "type" => "sectionend");



/* ==== Meta ==== */
$jaw_category_preset[] = array(
    "name" => "Meta",
    "type" => "sectionstart");


$jaw_category_preset[] = array(
    'id' => 'blog_metadate',
    'type' => 'toggle',
    
    'name' => '<i class="jaw-icon-clock"></i> Meta Date',
    'desc' => 'Choose whether or not to show date in the post preview.',
    'std' => '1',
);

$jaw_category_preset[] = array(
    'id' => 'blog_meta_author',
    'type' => 'toggle',
    
    'name' => '<i class="jaw-icon-user"></i> Meta Author',
    'desc' => 'Choose whether or not to show author&acute;s name in the post preview.',
    'std' => '0',
);


$jaw_category_preset[] = array(
    'id' => 'blog_comments_count',
    'type' => 'toggle',
    
    'name' => '<i class="jaw-icon-bubble"></i> Meta Number of Comments',
    'desc' => 'Choose whether or not to show number of comments in the post preview.',
    'std' => '0',
);

$jaw_category_preset[] = array(
    'id' => 'blog_meta_category',
    'type' => 'toggle',
    
    'name' => 'Meta Category',
    'desc' => 'Choose whether or not to show category in the post preview.',
    'std' => '0',
);

$jaw_category_preset[] = array(
    'id' => 'blog_meta_like',
    'type' => 'toggle',
    
    'name' => '<i class="jaw-icon-heart-on"></i> Meta Likes',
    'desc' => 'Choose whether or not to show icon with number of likes in the post preview.',
    'std' => '1',
);

$jaw_category_preset[] = array(
    'id' => 'blog_ratings',
    'type' => 'toggle',
    
    'name' => '<i class="jaw-icon-star3"></i> Ratings',
    'desc' => 'Choose whether or not to show ratings in the post preview.',
    'std' => '0',
);
$jaw_category_preset[] = array(
    'id' => 'blog_readers',
    'type' => 'toggle',
    
    'name' => '<i class="jaw-icon-eye"></i> Readers Count',
    'desc' => 'Choose whether or not to show icon with number of times the post has been read, in its preview.',
    'std' => '1',
);

$jaw_category_preset[] = array(
    'id' => 'blog_featured_post',
    'type' => 'toggle',
    'name' => '<i class="jaw-icon-star3"></i> Show info about Sticky post',
    'desc' => 'If the post is Sticky, in meta will be shown "Featured post"',
    'std' => '1',
);


$jaw_category_preset[] = array(
    'id' => 'blog_category_inimage',
    'type' => 'toggle',
    'name' => 'Category label in image',
    'desc' => '',
    'std' => '1'
);

$jaw_category_preset[] = array(
    'id' => 'blog_comments_inimage',
    'type' => 'toggle',
    
    'name' => 'Comments Counter in Image',
    'desc' => '',
    'std' => '1',
);

$jaw_category_preset[] = array(
    "type" => "sectionend");

/* ==== Layout ==== */
$jaw_category_preset[] = array(
    "name" => "Category Layout",
    "type" => "sectionstart");

$jaw_category_preset[] = array(
    "name" => "Category Layout",
    "desc" => "Choose one of the preset layouts for your Category. ",
    "id" => "layout",
    "std" => 'fullwidth',
    "type" => "layout",
    "options" => array(
        'fullwidth' => JAW_ADMIN_URI . 'assets/images/no_sidebar.gif',
        'left1' => JAW_ADMIN_URI . 'assets/images/left_sidebar.gif',
        'right1' => JAW_ADMIN_URI . 'assets/images/right_sidebar.gif',
        'right1_left1' => JAW_ADMIN_URI . 'assets/images/right_left_sidebar.gif',
        'right1_right2' => JAW_ADMIN_URI . 'assets/images/right_right_sidebar.gif',
        'left1_left2' => JAW_ADMIN_URI . 'assets/images/left_left_sidebar.gif')
);

$jaw_category_preset[] = array(
    "name" => "Left sidebar",
    "type" => "sectionstart",
    "ng-show" => "edit['layout']=='left1_left2' || edit['layout']=='right1_left1' || edit['layout']=='left1'");


$jaw_category_preset[] = array(
    'id' => 'sidebar_left1',
    'type' => 'sidebar_select',
    'name' => 'Category Left Sidebar',
    'desc' => 'Select an optional sidebar from the list of those you have created in <br>Sidebar Manager</b>.',
    'mod' => 'medium'
);
$jaw_category_preset[] = array(
    'id' => 'sidebar_left1_size',
    'name' => 'Size',
    
    'desc' => 'Select an optional sidebar from the list of those you have created in <br>Sidebar Manager</b>.',
    "std" => '3',
    "type" => "select",
    "options" => $sb_size
);

$jaw_category_preset[] = array(
    'id' => 'sidebar_left1_color',
    'name' => '<i class="jaw-icon-palette jaw-preset-icon"></i> Color',
    'desc' => 'Select an optional background color of sidebar from the list of those you have created in <br>Sidebar Manager</b>.',
    'type' => 'select_preset',
    "target" => "color"
);
$jaw_category_preset[] = array(
    'id' => 'sidebar_left1_header_style',
    'type' => 'layout',
    
    'name' => 'Sidebars Individual Style',
    'desc' => 'Select the heading style of custom sidebars you prefer. Click the preview icon to see where the setting appears. <span class="jaw-default">Default: Theme Options -> Posts Settings -> Search/Archive/Category Layout</span>',
    'std' => 'bar_type_1',
    "options" => $header_styles_img_default
);

$jaw_category_preset[] = array(
    "type" => "sectionend");

$jaw_category_preset[] = array(
    "name" => "Left 2 sidebar",
    "type" => "sectionstart",
    "ng-show" => "edit['layout']=='left1_left2'");


$jaw_category_preset[] = array(
    'id' => 'sidebar_left2',
    'type' => 'sidebar_select',
    
    'name' => 'Category Left Sidebar',
    'desc' => 'Select an optional sidebar from the list of those you have created in <br>Sidebar Manager</b>.',
    'std' => null,
    'mod' => 'medium'
);
$jaw_category_preset[] = array(
    'id' => 'sidebar_left2_size',
    'name' => 'Size',
    
    'desc' => 'Select an optional sidebar from the list of those you have created in <br>Sidebar Manager</b>.',
    "std" => '3',
    "type" => "select",
    "options" => $sb_size
);

$jaw_category_preset[] = array(
    'id' => 'sidebar_left2_color',
    'name' => '<i class="jaw-icon-palette jaw-preset-icon"></i> Color',
    'desc' => 'Select an optional background color of sidebar from the list of those you have created in <br>Sidebar Manager</b>.',
    "std" => '_default',
    'type' => 'select_preset',
    "target" => "color"
);
$jaw_category_preset[] = array(
    'id' => 'sidebar_left2_header_style',
    'type' => 'layout',
    
    'name' => 'Sidebars Individual Style',
    'desc' => 'Select the heading style of custom sidebars you prefer. Click the preview icon to see where the setting appears. <span class="jaw-default">Default: Theme Options -> Posts Settings -> Search/Archive/Category Layout</span>',
    'std' => 'bar_type_1',
    "options" => $header_styles_img_default
);

$jaw_category_preset[] = array(
    "type" => "sectionend");


$jaw_category_preset[] = array(
    "name" => "Right sidebar",
    "type" => "sectionstart",
    "ng-show" => "edit['layout']=='right1_right2' || edit['layout']=='right1_left1' || edit['layout']=='right1'");


$jaw_category_preset[] = array(
    'id' => 'sidebar_right1',
    'type' => 'sidebar_select',
    
    'name' => 'Category Right Sidebar',
    'desc' => 'Select an optional sidebar from the list of those you have created in <br>Sidebar Manager</b>.',
    'std' => null,
    'mod' => 'medium'
);
$jaw_category_preset[] = array(
    'id' => 'sidebar_right1_size',
    'name' => 'Size',
    
    'desc' => 'Select an optional sidebar from the list of those you have created in <br>Sidebar Manager</b>.',
    "std" => '3',
    "type" => "select",
    "options" => $sb_size
);

$jaw_category_preset[] = array(
    'id' => 'sidebar_right1_color',
    'name' => '<i class="jaw-icon-palette jaw-preset-icon"></i> Color',
    'desc' => 'Select an optional background color of sidebar from the list of those you have created in <br>Sidebar Manager</b>.',
    "std" => '_default',
    'type' => 'select_preset',
    "target" => "color"
);
$jaw_category_preset[] = array(
    'id' => 'sidebar_right1_header_style',
    'type' => 'layout',
    
    'name' => 'Sidebars Individual Style',
    'desc' => 'Select the heading style of custom sidebars you prefer. Click the preview icon to see where the setting appears. <span class="jaw-default">Default: Theme Options -> Posts Settings -> Search/Archive/Category Layout</span>',
    'std' => 'bar_type_1',
    "options" => $header_styles_img_default
);

$jaw_category_preset[] = array(
    "type" => "sectionend");

$jaw_category_preset[] = array(
    "name" => "Right 2 sidebar",
    "type" => "sectionstart",
    "ng-show" => "edit['layout']=='right1_right2'");


$jaw_category_preset[] = array(
    'id' => 'sidebar_right2',
    'type' => 'sidebar_select',
    
    'name' => 'Category Right 2 Sidebar',
    'desc' => 'Select an optional sidebar from the list of those you have created in <br>Sidebar Manager</b>.',
    'std' => null,
    'mod' => 'medium'
);
$jaw_category_preset[] = array(
    'id' => 'sidebar_right2_size',
    'name' => 'Size',
    
    'desc' => 'Select an optional sidebar from the list of those you have created in <br>Sidebar Manager</b>.',
    "std" => '3',
    "type" => "select",
    "options" => $sb_size
);

$jaw_category_preset[] = array(
    'id' => 'sidebar_right2_color',
    'name' => '<i class="jaw-icon-palette jaw-preset-icon"></i> Color',
    'desc' => 'Select an optional background color of sidebar from the list of those you have created in <br>Sidebar Manager</b>.',
    "std" => '_default',
    'type' => 'select_preset',
    "target" => "color"
);
$jaw_category_preset[] = array(
    'id' => 'sidebar_right2_header_style',
    'type' => 'layout',
    
    'name' => 'Sidebars Individual Style',
    'desc' => 'Select the heading style of custom sidebars you prefer. Click the preview icon to see where the setting appears. <span class="jaw-default">Default: Theme Options -> Posts Settings -> Search/Archive/Category Layout</span>',
    'std' => 'bar_type_1',
    "options" => $header_styles_img_default
);

$jaw_category_preset[] = array(
    "type" => "sectionend");

$jaw_category_preset[] = array(
    "type" => "sectionend");


/* ==== Post Boxes Settings ==== */
$jaw_category_preset[] = array(
    "name" => "Post Boxes Settings",
    "type" => "sectionstart");

$jaw_category_preset[] = array("name" => "Post Columns",
    "desc" => "Number of columns showed in category.",
    "id" => "posts_columns",
    "std" => "1",
    
    "type" => "select",
    "options" => array(
        "1" => "1",
        "2" => "2",
        "3" => "3",
        "4" => "4",
        "6" => "6")
);

$jaw_category_preset[] = array(
    'id' => 'boxes_type',
    'type' => 'layout',
    'name' => 'Post Boxes Type',
    'class' => 'fullwidth-option',
    'desc' => 'Select size of boxes for your posts. If the Mix option is chosen, only the latest post will be boxed in the Vertical size box.',
    'std' => 'vertical',
    'options' => array(
        'classical' => JAW_ADMIN_URI . 'assets/images/blog_boxes/classical.png',
        'special' => JAW_ADMIN_URI . 'assets/images/blog_boxes/special.png',
        'special-gallery' => JAW_ADMIN_URI . 'assets/images/blog_boxes/special-gallery.png',
        'special-big' => JAW_ADMIN_URI . 'assets/images/blog_boxes/special-big.png',
        'simple' => JAW_ADMIN_URI . 'assets/images/blog_boxes/simple.png',
        'vertical-small' => JAW_ADMIN_URI . 'assets/images/blog_boxes/vertical-small.png',
        'vertical' => JAW_ADMIN_URI . 'assets/images/blog_boxes/vertical.png',
        'vertical-big' => JAW_ADMIN_URI . 'assets/images/blog_boxes/vertical-big.png',
        'mix' => JAW_ADMIN_URI . 'assets/images/blog_boxes/mix.png',
        'full' => JAW_ADMIN_URI . 'assets/images/blog_boxes/full-content.png'
    )
);

$jaw_category_preset[] = array(
    'id' => 'title_h',
    'type' => 'toggle',
    'name' => 'Post Titles - H tag type',
    'desc' => '',
    'std' => '3',
    "builder" => 'true',
    "options" => array("1" => "h1", "2" => "h2", "3" => "h3")
);

$jaw_category_preset[] = array("name" => "Post Title Length - Number of Characters",
    "desc" => "Enter a number of characters in the preview content. <strong>Use -1 for default value by Theme Options</strong>",
    "id" => "letter_excerpt_title",
    "std" => '-1',
    "mod" => 'micro',
    'maxlength' => 4,
    "type" => "text"
);
$jaw_category_preset[] = array("name" => "Post Excerpt Length - Number of Characters",
    "desc" => "Enter a number of characters in the preview content.  <strong>Use -1 for default value by Theme Options</strong>",
    "id" => "letter_excerpt",
    "std" => '-1',
    "mod" => 'micro',
    'maxlength' => 4,
    "type" => "text"
);


$jaw_category_preset[] = array(
    'id' => 'clickable_image',
    'type' => 'toggle',
    
    'name' => 'Hyperlink Post Images',
    'desc' => 'Decide whether post images have to be hyperlinked.',
    'std' => '2',
    'options' => array('0' => 'Off', '1' => 'Hyperlink', '2' => 'PrettyPhoto')
);


$jaw_category_preset[] = array(
    "type" => "sectionend");




