/**
 * SMOF js
 *
 * contains the core functionalities to be used
 * inside SMOF
 */

jQuery.noConflict();

/** Fire up jQuery - let's dance! 
 */
jQuery(document).ready(function($) {
    

    //delays until AjaxUpload is finished loading
    //fixes bug in Safari and Mac Chrome
    if (typeof AjaxUpload != 'function') {
        return ++counter < 6 && window.setTimeout(init, counter * 500);
    }




//AJAX Upload
    function of_image_upload() {
        $('.image_upload_button').each(function() {

            var clickedObject = $(this);
            var clickedID = $(this).attr('id');

            var nonce = $('#jaw_security').val();

            new AjaxUpload(clickedID, {
                action: ajaxurl,
                name: clickedID, // File upload name
                data: {// Additional data to send
                    action: 'jaw_ajax_action',
                    type: 'upload',
                    security: nonce,
                    data: clickedID
                },
                autoSubmit: true, // Submit file after selection
                responseType: false,
                onChange: function(file, extension) {
                },
                onSubmit: function(file, extension) {
                    clickedObject.text('Uploading'); // change button text, when user selects file	
                    this.disable(); // If you want to allow uploading only 1 file at time, you can disable upload button
                    interval = window.setInterval(function() {
                        var text = clickedObject.text();
                        if (text.length < 13) {
                            clickedObject.text(text + '.');
                        }
                        else {
                            clickedObject.text('Uploading');
                        }
                    }, 200);
                },
                onComplete: function(file, response) {
                    window.clearInterval(interval);
                    clickedObject.text('Upload');
                    this.enable(); // enable upload button


                    // If nonce fails
                    if (response == -1) {
                        var fail_popup = $('#of-popup-fail');
                        fail_popup.fadeIn();
                        window.setTimeout(function() {
                            fail_popup.fadeOut();
                        }, 10000);
                    }

                    // If there was an error
                    else if (response.search('Upload Error') > -1) {
                        var buildReturn = '<span class="upload-error">' + response + '</span>';
                        $(".upload-error").remove();
                        clickedObject.parent().after(buildReturn);

                    }
                    else {
                        var buildReturn = '<div class="clear"></div><img class="hide of-option-image" id="image_' + clickedID + '" src="' + response + '" alt="" />';

                        $(".upload-error").remove();
                        $("#image_" + clickedID).remove();
                        clickedObject.parent().after(buildReturn);
                        $('img#image_' + clickedID).fadeIn();
                        clickedObject.next('span').removeClass('hide');
                        clickedObject.parent().prev('input').val(response);
                    }
                }
            });

        });

    }

    of_image_upload();


    var _TBwindow = $('#TB_window');
    _TBwindow.css('margin-left', 'auto');


    //hides warning if js is enabled			
    $('#js-warning').hide();


 


    // LISTING THEMEJAW_OPTIONS MENU ===============================================

    // //Tabify Options			
    $('.group').hide();

    $(window).on('jwTOLoadDone', function(){
        var hash = window.location.hash.substring(1).replace('/','').split('---');
        if(hash[0] !== undefined && hash[1] !== undefined){
            showTOSection(hash[0], hash[1]);
        } 
    });

    //tutorial - kdyz je nekde problem, tak tam dame link s odkazem do jine sekce TO
    jQuery('[class*=jaw-goto-]').live('click', function(){
        var goToSection = $(this).data('goto');
        var highlightSection = $(this).data('highlight');
        if(!window.location.href.match(/page=optionsframework/) && jaw_variables["optionsframework_url"] !== undefined){
            window.location.href = jaw_variables["optionsframework_url"] + "#" + goToSection + "---" + highlightSection;
        } 
        showTOSection(goToSection, highlightSection);
    });  
    //nasmerovani do prislusne sekce
    function showTOSection(section, highlited){
        changepanel('.'+section+' a');
        if(highlited !== ""){
            highlight("#section-"+highlited);
        }
    }
    //zvyrazneni sekce TO
    function highlight(element){
        if($(element).length){
            $('html,body').animate({
                scrollTop: $(element).offset().top - 200
            },'slow');
            $(element).addClass("highlighted");
            setTimeout(function(){
                $(element).removeClass("highlighted");
            }, 3000);
        }
    }

    //change menu
    function changepanel(item) {
        
        if($(item).length == 0){
            return;
        }

        var clicked_group = $(item).attr('href');
        var sev = $(item).parent().attr('rel');
        
        if(sev !== undefined){
            sev = sev.replace("#","");
        }
        
        if(sev == "customscripts" || 
            sev == "customstylesheets" || 
            sev == "footer" || 
            sev == "error404" || 
            sev == "analyticscode"){
            //pokud vlezu nekam, kde je potreba ACE editor, tak ho spustim (nespoustim ho automaticky pri startu TO, protoze to zpomalovalo nacitani)
            jaw_admin_theme.initAceEditor();
        }

        if ($(item).parent().hasClass('parent')) { // je polozka parent ?
            $('#of-nav li ul').not($(item).next()).slideUp(); // skryjeme otevrene panely
            $(item).next().stop().slideToggle();

        } else {
            if ($(item).parent().hasClass('child')) { // je polozka child?

                $(item).parent().parent().show();
                $('.group').hide();
                $(clicked_group).fadeIn('fast');
                $('#of-nav li a').removeClass('current');
                $(item).addClass('current');
                $.cookie('jaw_current_opt', sev, {expires: 7, path: '/'});
            } else { // obyc polozka
                $('.group').hide();
                $(clicked_group).fadeIn('fast');
                $.cookie('jaw_current_opt', sev, {expires: 7, path: '/'});
                $(item).next().stop().slideToggle();
                $('#of-nav li ul').slideUp(); // skryjeme otevrene panely
                $('#of-nav li a').removeClass('current');
                $(item).addClass('current');
            }
        } 
        //nactu lazyload obrazky
        $(clicked_group).find("img.jaw-lazy").trigger("unveil");
    }

    // Display last current tab	
    if ($.cookie("jaw_current_opt") === null) {
        $('.group:first').fadeIn('fast');
        $('#of-nav li:first a').addClass('current');
    } else {
        var currentOpt = $.cookie("jaw_current_opt").replace("#","");
        changepanel($('li.' + currentOpt + ' a'));
    }



    // events for menu 
    $('#of-nav li a').click(function() {
        changepanel(this);
        return false;
    });


    //Expand Options 
    var flip = 0;



    $('#expand_options').click(function() {
        if (flip == 0) {
            flip = 1;
            $('#of_container #of-nav').hide();
            $('#of_container #content').width(755);
            $('#of_container .group').add('#of_container .group h2').show();

            $(this).removeClass('expand');
            $(this).addClass('close');
            $(this).text('Close');

        } else {
            flip = 0;
            $('#of_container #of-nav').show();
            $('#of_container #content').width(574);
            $('#of_container .group').add('#of_container .group h2').hide();
            $('#of_container .group:first').show();
            $('#of_container #of-nav li').removeClass('current');
            $('#of_container #of-nav li:first').addClass('current');

            $(this).removeClass('close');
            $(this).addClass('expand');
            $(this).text('Expand');

        }

    });

    //Update Message popup
    $.fn.center = function() {
        this.animate({
            "top": ($(window).height() - this.height() - 200) / 2 + window.pageYOffset + "px"
        }, 100);
        this.css("left", 570);
        return this;
    }


    $('#of-popup-save').center();
    $('#of-popup-reset').center();
    $('#of-popup-fail').center();




    //Masked Inputs (images as radio buttons)


    //Masked Inputs (background images as radio buttons)
    $('.of-radio-tile-img').click(function() {
        $(this).parent().parent().find('.of-radio-tile-img').removeClass('of-radio-tile-selected');
        $(this).addClass('of-radio-tile-selected');
    });
    $('.of-radio-tile-label').hide();
    $('.of-radio-tile-img').show();
    $('.of-radio-tile-radio').hide();






    var _TBwindow = $('#TB_window');
    _TBwindow.css('margin-left', 'auto');


    function rewrite(obj) {

        var url = obj
                .toLowerCase() // change everything to lowercase
                .replace(/^\s+|\s+$/g, "") // trim leading and trailing spaces		
                .replace(/[_|\s]+/g, "-") // change all spaces and underscores to a hyphen
                .replace(/[^a-z0-9-]+/g, "") // remove all non-alphanumeric characters except the hyphen
                .replace(/[-]+/g, "-") // replace multiple instances of the hyphen with a single instance
                .replace(/^-+|-+$/g, ""); // trim leading and trailing hyphens				
        return url;
    }
   


    /**	Ajax Backup & Restore MOD */
    //backup button
    $('#of_backup_button').on('click', function() {

        var answer = confirm("Click OK to backup your current saved options.")

        if (answer) {
            
            $('html, body').animate({
                scrollTop: 0
            }, 350);
            $('body').prepend('<div id="cover_load"><div class="cover_load_text"><h4>Backup in progress...</h4><p>It might takes up to several seconds. Sit back and relax.</p></div></div>');
            $("#cover_load").width('100%');
            $("#cover_load").css('min-height',$('#wpwrap').height() + 50);

            var clickedObject = $(this);
            var clickedID = $(this).attr('id');

            var nonce = $('#jaw_security').val();

            var data = {
                action: 'jaw_ajax_action',
                type: 'backup_options',
                security: nonce
            };

            $.post(ajaxurl, data, function(response) {

                //check nonce
                if (response == -1) { //failed

                    var fail_popup = $('#of-popup-fail');
                    fail_popup.fadeIn();
                    window.setTimeout(function() {
                        fail_popup.fadeOut();
                    }, 10000);
                }

                else {

                    var success_popup = $('#of-popup-save');
                    success_popup.fadeIn();
                    window.setTimeout(function() {
                        location.reload();
                    }, 1000);
                }

            });

        }

        return false;

    });
  


    //restore button
    $('#of_restore_button').on('click', function() {

        var answer = confirm("'Warning: All of your current options will be replaced with the data from your last backup! Proceed?")

        if (answer) {
            
            $('html, body').animate({
                scrollTop: 0
            }, 350);
            
            $('body').prepend('<div id="cover_load"><div class="cover_load_text"><h4>Restoring your data...</h4><p>It might takes up to several seconds. Sit back and relax.</p></div></div>');
            $("#cover_load").width('100%');
            $("#cover_load").css('min-height',$('#wpwrap').height() + 50);
            
            var clickedObject = $(this);
            var clickedID = $(this).attr('id');

            var nonce = $('#jaw_security').val();

            var data = {
                action: 'jaw_ajax_action',
                type: 'restore_options',
                name: $(this).data('name'),
                security: nonce
            };

            $.post(ajaxurl, data, function(response) {

                //check nonce

                if (response == -1) { //failed

                    var fail_popup = $('#of-popup-fail');
                    fail_popup.fadeIn();
                    window.setTimeout(function() {
                        fail_popup.fadeOut();
                    }, 10000);
                }

                else {

                    var success_popup = $('#of-popup-save');
                    success_popup.fadeIn();
                    window.setTimeout(function() {
                        location.reload();
                    }, 1000);
                }

            });

        }

        return false;

    });

    /**	Ajax Transfer (Import/Export) Option */
    $('.of_import_button').on('click', function() {

        var answer = confirm("Import data rewrite actual setings. Are you really import data?")

        if (answer) {
            
            $('html, body').animate({
                scrollTop: 0
            }, 350);
            $('body').prepend('<div id="cover_load"><div class="cover_load_text"><h4>Importing...</h4><p>It might takes up to several seconds. Sit back and relax.</p></div></div>');
            $("#cover_load").width('100%');
            $("#cover_load").css('min-height',$('#wpwrap').height() + 50);
            
            var clickedObject = $(this);
            var clickedID = $(this).attr('id');
            var type = $(this).data('type');

            var nonce = $('#jaw_security').val();
            var target = jQuery(this).attr('target');

            var import_data = $('#export_data_' +type+'_'+ target).val();



            var data = {
                action: 'jaw_ajax_action',
                type: type,
                security: nonce,
                data: import_data,
                target: target
            };

            $.post(ajaxurl, data, function(response) {
                var fail_popup = $('#of-popup-fail');
                var success_popup = $('#of-popup-save');

                //check nonce
                if (response == -1) { //failed
                    fail_popup.fadeIn();
                    window.setTimeout(function() {
                        fail_popup.fadeOut();
                    }, 10000);
                }
                else
                {
                    success_popup.fadeIn();
                    window.setTimeout(function() {
                        location.reload(true);
                    }, 1000);
                }

            });

        }

        return false;

    });


    






    $(window).bind('keydown', function(event) {
        if (event.ctrlKey || event.metaKey) {
            switch (String.fromCharCode(event.which).toLowerCase()) {
                case 's':
                    event.preventDefault();
                  //  jaw_save_options();
                    break;
            }
        }
    });

    /* AJAX Options Reset */
    $('#of_reset').click(function() { 

        //confirm reset
        var answer = confirm("Click OK to reset. All settings will be lost and replaced with default settings!");

        //ajax reset
        if (answer) {

            var nonce = $('#jaw_security').val();

            $('.ajax-reset-loading-img').fadeIn();

            var data = {
                type: 'reset',
                action: 'jaw_ajax_action',
                security: nonce
            };

            $.post(ajaxurl, data, function(response) {
                var success = $('#of-popup-reset');
                var fail = $('#of-popup-fail');
                var loading = $('.ajax-reset-loading-img');
                loading.fadeOut();
                console.log(response);
                if (response == 1)
                {
                    success.fadeIn();
                    window.setTimeout(function() {
                        location.reload();
                    }, 1000);
                }
                else
                {
                    fail.fadeIn();
                    window.setTimeout(function() {
                        fail.fadeOut();
                    }, 10000);
                }


            });

        }


    });


}); //end doc ready


