(function ($, undefined) {

        JawAdminApp.prototype.tinyMCE = {
                initTinyMCE: function () {
                        var $that = this;
                        $('html,body').css('cursor', 'default');
                        $('.jaw-editor-area').each(function () {
                                if (window.tinyMCE !== undefined) {
                                        $that.init_wp_editor($(this).attr("id"));
                                        var ed_id = $(this).attr("id");
                                        var editor_visual = '.tinymce-tabs .visual.' + ed_id;
                                        var editor_html = '.tinymce-tabs .html.' + ed_id;
                                        $(editor_visual).addClass('active');
                                        $(editor_html).removeClass('active');
                                        $(editor_visual).click(function () {
                                                $that.activateTinyMCETab('visual', editor_visual, editor_html, ed_id);
                                        });
                                        $(editor_html).click(function () {
                                                $that.activateTinyMCETab('html', editor_visual, editor_html, ed_id);
                                        });
                                }
                        });
                        $('.editor_container').height($('body').height() * 0.8 - 85);
                },
                init_wp_editor: function (elementId) {
                        var $that = this;
                        if (window.tinyMCE !== undefined) {
                                window.tinyMCE.settings.wpautop = false;
                                window.tinyMCE.execCommand("mceAddEditor", false, elementId);
                                tinyMCE.settings.wpautop = wpautop;
                                wpActiveEditor = elementId;
                                jaw_editor_open = true;
                        }
                },
                cancel_wp_editor: function (elementId) {
                        var $that = $(this);
                        if (window.tinyMCE !== undefined) {
                                window.tinyMCE.settings.wpautop = false;
                                window.tinyMCE.execCommand("mceRemoveEditor", true, elementId);
                                jaw_editor_open = false;
                        }
                },
                activateTinyMCETab: function (selectedTab, visualTab, htmlTab, elementId) {
                        var $that = this;
                        if (selectedTab == 'visual') {
                                $that.init_wp_editor(elementId);
                                $(visualTab).addClass('active');
                                $(htmlTab).removeClass('active');
                                $('.jaw_add_media').show();
                        }
                        if (selectedTab == 'html') {
                                $that.cancel_wp_editor(elementId);
                                $(visualTab).removeClass('active');
                                $(htmlTab).addClass('active');
                                $('.jaw_add_media').hide();
                        }
                }
        };
})(jQuery);