(function($) {

    JawAdminApp.prototype.ajaxUpload = function() {
        
        //delays until AjaxUpload is finished loading
        //fixes bug in Safari and Mac Chrome
        if (typeof AjaxUpload != 'function') {
            return ++counter < 6 && window.setTimeout(init, counter * 500);
        }

        /* AJAX Upload ******************************************************************
         * @since FlyingNews
         */
        $(".image_upload_button").on('click', function() {
            of_image_upload(); 
        }); 
        var interval; 
        function of_image_upload() {
            $('.image_upload_button').each(function() {
                var clickedObject = $(this);
                var clickedID = $(this).attr('id');
                var save = $('#jaw_security').attr('attr');
                var nonce = $('#jaw_security').val();

                new AjaxUpload(clickedID, {
                    action: ajaxurl,
                    name: clickedID, // File upload name
                    data: {// Additional data to send
                        action: 'jaw_ajax_action',
                        type: 'upload',
                        security: nonce,
                        data: clickedID,
                        nosave: save
                    },
                    autoSubmit: true, // Submit file after selection
                    responseType: false,
                    onChange: function(file, extension) {
                    },
                    onSubmit: function(file, extension) {
                        clickedObject.text('Uploading'); // change button text, when user selects file	
                        this.disable(); // If you want to allow uploading only 1 file at time, you can disable upload button
                        interval = window.setInterval(function() {
                            var text = clickedObject.text();
                            if (text.length < 13) {
                                clickedObject.text(text + '.');
                            }
                            else {
                                clickedObject.text('Uploading');
                            }
                        }, 200);
                    },
                    onComplete: function(file, response) {
                        window.clearInterval(interval);
                        clickedObject.text('Upload Image');
                        this.enable(); // enable upload button
                        var buildReturn = '';

                        // If nonce fails
                        if (response == -1) {
                            var fail_popup = $('#of-popup-fail');
                            fail_popup.fadeIn();
                            window.setTimeout(function() {
                                fail_popup.fadeOut();
                            }, 2000);
                        }
                        // If there was an error
                        else if (response.search('Upload Error') > -1) {
                            buildReturn = '<span class="upload-error">' + response + '</span>';
                            $(".upload-error").remove();
                            clickedObject.parent().after(buildReturn);

                        } else {

                            buildReturn = '<img class="hide of-option-image" id="image_' + clickedID + '" src="' + response + '" alt="" />';

                            $(".upload-error").remove();
                            $("#image_" + clickedID).remove();
                            clickedObject.parent().after(buildReturn);
                            $('img#image_' + clickedID).fadeIn();
                            clickedObject.next('span').removeClass('hide');
                            clickedObject.parent().prev('input').val(response);
                        }
                    }
                });

            });
 
        }
        //AJAX Remove Image (clear option value)
        $('.image_reset_button').on('click', function() {

                   
            
            var clickedObject = $(this);
            var clickedID = $(this).attr('id');
            var theID = $(this).attr('title'); 

            var nonce = $('#jaw_security').val();

            var data = {
                action: 'jaw_ajax_action',
                type: 'image_reset',
                security: nonce,
                data: theID
            };

            clickedObject.text('Removing'); // change button text, when user selects file	
            var interval = window.setInterval(function() {
                var text = clickedObject.text();
                if (text.length < 12) {
                    clickedObject.text(text + '.');
                }
                else {
                    clickedObject.text('Removing');
                }
            }, 200); 
            
            $.post(ajaxurl, data, function(response) {
                
                clearInterval(interval);
                clickedObject.text('Remove');
                
                //check nonce
                if (response == -1) { //failed

                    var fail_popup = $('#of-popup-fail');
                    fail_popup.fadeIn();
                    window.setTimeout(function() {
                        fail_popup.fadeOut();
                    }, 2000);
                } else {

                    var image_to_remove = $('#image_' + theID);
                    var button_to_hide = $('#reset_' + theID);
                    image_to_remove.fadeOut(500, function() {
                        $(this).remove();
                    });
                    button_to_hide.addClass('hide');
                    clickedObject.parent().prev('input').val('');
                }
            });

        });
    };

    /* AJAX upload END **************************************************************/
})(jQuery);