var wpautop = true;
var jaw_editor_open = false;

var JawAdminApp = function() {
};
jQuery.noConflict();

(function($) {
    'use strict';

    JawAdminApp.prototype = {
        ready: function() {
 
            var $that = this;
 
            $that.convertToGps();
            $that.ajaxUpload();
            $that.multiselect();
            $that.layoutElement();
            $that.fixedSaveButton();
            $that.changePageTemplate();
            $("img.jaw-lazy").unveil(); 
            $(".jw_option input").attr("autocomplete", "off");
        },
        initAceEditor: function(){
            var $that = this;
            $('.section-ace_editor').each(function(k, val) {
                var type = $(val).find('.ace_editor').data('type');
                var id = $(val).find('.ace_editor').data('id');
                $that.aceEditor(id, 'monokai', type);
            }); 
        },
        bootstrapAngular: function() {
            $('#postdivrich').prepend($('#jaw_metabox-jawmetaboxpostformats'));
            angular.bootstrap($('#jaw_metabox-jawmetaboxpostformats'), ['jwEditor']);

            //pb v page
            angular.bootstrap($('.post-type-page .jaw_builder_app'), ['jawBuilder']);

            //angular in category    
            $('#edittag').attr('ng-controller', 'jwEditorController');
            $('#addtag').attr('ng-controller', 'jwEditorController');
            angular.bootstrap($('#edittag'), ['jwEditor']); 
            angular.bootstrap($('#addtag'), ['jwEditor']);

            //angular in page & post
            angular.bootstrap($('#jawmetapage'), ['jwEditor']);
            angular.bootstrap($('#jaw_metabox-jawmetabox'), ['jwEditor']);

            //shortcode editor
            $('#post-status-info').attr('ng-controller', 'jwEditorController');
            angular.bootstrap($('#post-status-info'), ['jwEditor']);

        },
        convertToGps: function() {

            $('.convert_to_gps').live('click', function() {
                var adr_id = $(this).attr('data-id');
                var address = $('#address-' + adr_id).val().replace(' ', '+');
                $.getJSON("http://maps.googleapis.com/maps/api/geocode/json?address=" + address + '&sensor=true', function(data) {
                    $('#latitude').val(data.results[0].geometry.location.lat);
                    $('#longitude').val(data.results[0].geometry.location.lng);
                    $('#latitude').trigger('input');
                    $('#longitude').trigger('input');
                });
            });

        },
        aceEditor: function(id, theme, mode) {
            ace.require("ace/ext/language_tools");
            ace.require("ace/ext/emmet");
            var editor = ace.edit(id + '_editor');
            editor.setTheme("ace/theme/" + theme);
            editor.getSession().setMode("ace/mode/" + mode);

            editor.setOptions({
                enableBasicAutocompletion: true,
                enableSnippets: true,
                enableLiveAutocompletion: true
            });

            var textarea = $('textarea[name="' + id + '"]').hide();
            editor.getSession().setValue(textarea.val());
            editor.getSession().on('change', function() {
                textarea.val(editor.getSession().getValue());
            });

        },
        multiselect: function() {

            $("select.jaw-chosen").each(function() {

                var $placeholder = $(this).attr('data-placeholder');

                if ($(this).parents('.postbox').is('.closed')) {
                    var chosen = $(this);
                    chosen.parents('.postbox').children('.hndle,.handlediv').bind('clickoutside', function(e) {
                        if ($placeholder !== undefined) {
                            chosen.data("placeholder", $placeholder).chosen();
                        } else {
                            chosen.chosen();
                        }
                    });
                } else {
                    if ($placeholder !== undefined) {
                        $(this).data("placeholder", $placeholder).chosen();
                    } else {
                        $(this).chosen();
                    }
                }
            });
        },
        launchHelp: function(URL) {
            var help = window.open(URL, "", "width=1200,height=800,modal=yes,alwaysRaised=yes");
            help.focus();
        },
        layoutElement: function() {
            /* LAYOUT ******************************************************************
             * @since FlyingNews
             */
            extendChange();
            //Masked Inputs (images as radio buttons)
            $('.radio-layout').click(function(event) {
                //event.preventDefault();
                $(this).parent().find('.radio-layout').removeClass('of_radio_img_selected');
                $(this).addClass('of_radio_img_selected');
                extendChange('200');
            });

            // Template Check List
            function extendChange(time, att_val) {
                $('.section-layout div.of_radio_img_selected').each(function() {
                    var val = '';
                    if (att_val === undefined) {
                        val = $(this).children().attr('val');
                    } else {
                        val = att_val;
                        $(this).parent().find('.radio-layout').removeClass('of_radio_img_selected');
                    }
                    var rel = $(this).children().attr('rel');

                    $('#section-' + rel + '_right1').hide(0);
                    $('#section-' + rel + '_left1').hide(0);
                    $('#section-' + rel + '_right2').hide(0);
                    $('#section-' + rel + '_left2').hide(0);

                    var sidebars = val.split('_');
                    if (val != "fullwidth") {
                        $.each(sidebars, function(key, value) {
                            $('#section-' + rel + '_' + value).show(0);
                        });
                    }
                });
            }
            /* LAYOUT END **************************************************************/
        },
        styleSelect: function() {
            $('.jw_option .select_wrapper').each(function() {
                $(this).prepend('<span>' + $(this).find('.select option:selected').text() + '</span>');
            });
            $('.jw_option .select').live('change', function() {
                $(this).prev('span').replaceWith('<span>' + $(this).find('option:selected').text() + '</span>');
            });
            $('.jw_option .select').bind($.browser.msie ? 'click' : 'change', function(event) {
                $(this).prev('span').replaceWith('<span>' + $(this).find('option:selected').text() + '</span>');
            });
        },

        fixedSaveButton: function() {
            if ($('#of_form').length) {
                $('.jw-fixed-save').css({
                    left: $('#of_form').offset().left + $('#of_form').width(),
                });
                
                // pri zmene velikosti okna a pri zmenseni/zvetseni bocniho menuwpseo_pre_analysis_post_content
                setInterval(function(){
                   $('.jw-fixed-save').css({
                        left: $('#of_form').offset().left + $('#of_form').width(),
                    }); 
                },2000);

                if (window.pageYOffset < $('#of_form').offset().top) {
                    $('.jw-fixed-save').css({
                        top: $('#of_form').offset().top - window.pageYOffset + 120
                    });
                }
                $(window).on('scroll', function() {
                    if (window.pageYOffset < $('#of_form').offset().top) {
                        $('.jw-fixed-save').css({
                            top: $('#of_form').offset().top - window.pageYOffset + 120
                        });
                    } else {
                        $('.jw-fixed-save').css({
                            top: 120
                        }); 
                    }
                });
            }
        },
        changePageTemplate: function() {
            if ($('#page_template').length) {
                $('body').attr('template', $('#page_template').val());
                $('#page_template').on('change', function() {
                    $('body').attr('template', $('#page_template').val());
                });
            }
        },
        errors: []
    };

})(jQuery);


var jaw_admin_theme;

(function($) {

    jaw_admin_theme = new JawAdminApp();

    angular.element(document).ready(function() {
        jaw_admin_theme.bootstrapAngular();
        jaw_admin_theme.ready();
        jaw_admin_theme.styleSelect();
    });
    $(window).scroll(function() {
        if (jaw_editor_open === true) {
            jQuery('.mce-container.mce-panel.mce-floatpanel').hide();
            jQuery('.mce-btn').removeClass('mce-active');
            jQuery('.mce-btn').attr('aria-expanded', false);
        }
    });

    window.onerror = function(args) {
        for (var i = 0; i < args.length; ++i) {
            jaw_admin_theme.errors.push(args[i]);
        }
    };

})(jQuery);