'use strict';
(function ($, angular, window, ajaxurl, jaw_variables, undefined) {
    /**
     * - Config (spec)
     * - Dialog 
     * - Element (spec)
     * - Workspace (spec)
     * - Debug
     * - Utils
     */
    var element = function (data) {
        this.id = 0;
        this.type = '';
        this.size = 12;
        this.metabox = { title: 'Title' };
        this.visible = true;
        this.childs = [];
        angular.extend(this, data);
        return this;
    };
    element.prototype = {
        edit: function () {

        },
        delete: function () {
            return {};
        }
    };
    
    
    var services = angular.module('jwPbServices', ['jwPbControllers', 'ui.bootstrap']);
    
   
   
    /** defaultni data zakladnich objektu v revoComposeru **/
    services.value('jwPbDefaultContents', {});
    
    /**
     * @name            jwPbConfig
     * @description     Uchovává informace o jednotlivých elementech (nazev ikony, max a min velikosti, ....)
     */
    services.factory('jwPbConfig', ['jwPbDebugService', function (jwPbDebugService) {
        //objekt vlastni factory
        var conFactory = {};
        //data
        var localData = {};
        
        /**
         * @name            jwPbConfig.set
         * @description     pri spusteni aplikcace se zavola tato metoda a ulozi vstupni data do lokalni promene
         */
        conFactory.set = function (data) {
            //nastavi data
            localData = data;
            jwPbDebugService('Configuration has been set');
        };
        
        /**
         * @name            jwPbConfig.get
         * @description     vraci pozadvane informace z configu
         * 
         * @param {string} itemType     typ prvku (button, blog, cta, ...)
         * @param {string} key          typ informace, kterou chci (icon, name, ...)
         */
        conFactory.get = function (itemType, key) {
            //zkontrolovani, zda-li data nejsou prazdna
            if (localData !== undefined) {
                // projdu vsechna data
                for (var i = 0; i < Object.keys(localData).length; i++) {
                    // a najdu typ prvku, ktery je pozadovany
                    if (localData[i].id == itemType) {
                        // vratim pozadovanou hodnotu
                        return localData[i][key];
                    }
                }
            } else {
                // vratim prazdny objekt
                return {};
            }
        };
        return conFactory;
    }]);


    /**
     * @name            jwPbDialogService
     * @description     zobrazuje modalni okno
     */
    services.factory('jwPbDialogService', ['$dialog', function ($dialog) {
        //objekt vlastni factory
        var diFactory = {};
        diFactory.open = function (options, item, action, callback) {
            if (!diFactory.isOpen) {
                var opts = {
                    backdrop: true,
                    keyboard: false,
                    backdropClick: false,
                    metabox: angular.copy(options[item]),
                    templateUrl: ajaxurl + action,
                    controller: 'jwPbEditorController',
                };
                var d = $dialog.dialog(opts);
                d.open().then(function (result) {
                    
                    if (result !== undefined) {
                        options[item] = result;
                    }
                    if (callback != undefined) {
                        callback(result);
                    }
                    diFactory.isOpen = false;
                    angular.element('body').removeClass('modal_open');
                });
                diFactory.isOpen = true;
            }
        };
        return diFactory;
    }]);
        
  
  
    /**
     * @name            jwPbElementService
     * @description     model elementu v revoComposeru
     */
    services.factory('jwPbElementService', ['jwPbDebugService', 'jwPbDialogService', function (jwPbDebugService, jwPbDialogService) {
        //objekt vlastni factory
        var elFactory = {};
        
        /**
         * @name            jwPbElementService.add
         * @description     vraci plnohodnotny model elementu s defaultnimi hodnotami dle vstupniho parametru 
         */
        elFactory.add = function (data) {
            jwPbDebugService('New Element ' + data.type + ' has been created (jwPbElementService.add)');
            var temp = new element(data);
            return temp;
        };
        /**
         * @name            jwPbElementService.edit
         * @description     otevre modalni okno editace
         */
        elFactory.edit = function (item, callback) {
            var type = item.type.replace('build_', '');
            jwPbDialogService.open(item, 'metabox', '?action=jaw_builder_editor&jaw_code=' + type, callback);
        };
        /**
         * @name            jwPbElementService.changeSize
         * @description     zmeni velikost prvku o 1 danym smerem
         * 
         * @param {object}  item                revoComposerElement
         * @param {boolean} scale_direction     true - up, false - down
         */
        elFactory.changeSize = function (item, scale_direction) {
            jwPbDebugService('Element ' + item.id + ' has changed his size from ' + item.size + ' by ' + (scale_direction ? 'upscale' : 'downscale') + ' direction (jwPbElementService.changeSize)');
            // pokud pracuju s pravym sidebarem, tak ten ma obracenou logiku zvetsovani.
            if (item.id.toString().search('right') >= 0) {
                scale_direction = !scale_direction;
            }
            if (scale_direction == true && item.size < 12) {
                //Upscale
                item.size++;
            } else if (scale_direction == false && item.size > 1) {
                //Downscale
                item.size--;
            }
        };
        /**
         * @name            jwPbElementService.changeSizeAt
         * @description     nastavi velikost na predem danou hodnotu
         */
        elFactory.changeSizeAt = function (item, size) {
            jwPbDebugService('Element ' + item.id + ' has changed his size from ' + item.size + ' to ' + size + ' (jwPbElementService.changeSizeAt)');
            //vetsi jak 12 nemuzu nastavit
            if (size <= 12) {
                item.size = size;
            }else{
                throw new Error("Cannot set bigger than 12");
            }
        }
        return elFactory;
    }]);
        
        
        
    /**
     * @name            jwPbWorkspaceService
     * @description     Stara se o celou workspace promenou RevoComoseru. 
     *                  Ve workspace ses nachází všechny elementy. 
     */
    services.factory('jwPbWorkspaceService', ['jwPbDebugService', 'jwPbElementService', 'jwPbDefaultContents', function (jwPbDebugService, jwPbElementService, jwPbDefaultContents) {
        var wsFactory = {};
        /** 
         * @name                jwPbWorkspaceService.init
         * @description         inicializuje workspace objekt pro revoComposer 
         *                      - nacte do nej ulozena data
         *                      - popr. (kdyz zadna ulozena nejsou) zalozi novy prazdny workspace
         * 
         * @param {object}  data    vstupni data (ulozena data revoComposeru)
         */
        wsFactory.init = function (data) {
            var workspace = {};
            if (typeof (data) === 'object' && data) {
                jwPbDebugService('RevoComposer workspace init with data (jwPbWorkspaceService.init)', 'group');
                jwPbDebugService('Data:', 'log');
                jwPbDebugService(data, 'log');
                jwPbDebugService('', 'groupEnd');
                workspace = data;
            } else {
                jwPbDebugService('Workspace init blank (jwPbWorkspaceService.init)');
                angular.forEach(jwPbDefaultContents.content, function (names, typ) {
                    angular.forEach(names, function (name, key) {
                        var new_item = {};
                        new_item[name.id] = jwPbElementService.add(name);
                        angular.extend(workspace, new_item);
                    });
                });
            }
            return workspace;
        };
        /**
         * @name                jwPbWorkspaceService.add
         * @description         prida element do workspace
         * 
         * @param {array}   weChilds     child parametr rodicovskeho objektu, do ktereho chceme vlozit novy element
         * @param {object}  data         data noveho elementu
         */
        wsFactory.add = function (parentChilds, data) {
            parentChilds.push(jwPbElementService.add(data));
            // vratim posledni (tj. pridany) element
            return (parentChilds[parentChilds.length - 1]);
        };
        /**
         * @name                jwPbWorkspaceService.delete
         * @description         odebere element z workspace
         * 
         * @param {object}  parent  rodicovsky objekt, ve kterem chceme smazat element
         * @param {int}     id      id elementu, ktery cheme smazat
         */
        wsFactory.delete = function (id, parent) {
            if(parent.childs[id] !== undefined){
                 parent.childs.splice(id, 1);
                 jwPbDebugService('Element ' + id + ' has been deleted (jwPbWorkspaceService.delete)');
                 return true;
            }
            jwPbDebugService('WRONG ID! Element ' + id + ' has not been deleted (jwPbWorkspaceService.delete)', 'error');
            return false;
        };
        return wsFactory;
    }]);
        
        
        
    /**
     * @name            jwPbDebugService
     * @description     Stara se o vypis informaci v konzoli. 
     * 
     * @param {string}  logText     Text, ktery bude vypsany v konzoli
     * @param {string}  typ         Typ konzoloveho vypisu (log, error, info, ...) [default: log] 
     */
    services.factory('jwPbDebugService', function () {
        var deFactory = {};
        deFactory.debugMode = false; //jaw_variables.JAW_DEBUG || false;
        return function (logText, typ) {
            if (deFactory.debugMode) {
                if (typ === undefined)
                    typ = 'log';
                console[typ](logText);
            }
        };
    });
    
    
    /**
     * UTILS
     */
    services.factory('jwPbUtilsService', ['jwPbDebugService', '$rootScope', function (jwPbDebugService, $rootScope) {
        var uFactory = {};
        var jaw_interval = new Number;
        var enable_save = true;
        uFactory.enable_save = function () {
            clearInterval(jaw_interval);
            jaw_interval = setInterval(function () {
                clearInterval(jaw_interval);
                enable_save = true;
                $('#publishing-action #publish.button').prop('disabled', false);
                uFactory.checkHeight();
                jwPbDebugService('Save is enabled (jwPbUtilsService.enable_save)');
            }, 500);
        };
        uFactory.disable_save = function () {
            enable_save = false;
            $('#publishing-action #publish.button').prop('disabled', true);
            jwPbDebugService('Save is disabled (jwPbUtilsService.diable_save)');
        };
        uFactory.is_save_enabled = function () {
            return enable_save;
        }
        uFactory.checkHeight = function () {
            $('.jb-sidebar').height($("#item-2_content").height());
        }
        return uFactory;
    }]);
        

})(jQuery, angular, window, ajaxurl, jaw_variables);
