'use strict';

var jawBuilderApp;

(function($, angular, window, undefined) {

    var jawBuilder = angular.module('jawBuilder', [
        'ui.bootstrap',
        'ui.sortable',
        'jwDirectives',
        'colorpicker.module',
        'jaw.gallerypicker',
        'jaw.simplemediapicker',
        'jwPbServices',
        'jwPbControllers'
    ]);

    var jaw_app = function() {
    };
    
    jaw_app.prototype = {
        init: function() {
            var $that = this; 
            $('.builder_editor').hide();
            $('.jaw-builder-background.loading').hide();
            
            //ADD REVObuilder to editor
            if ($('#jaw_page_builder').find('.jaw_builder_app').length > 0) {
                $('#jaw_page_builder').find('.jaw_builder_app').hide();
                $('#jaw_page_builder').hide();
                $('#wp-content-editor-tools')
                        .find('.wp-switch-editor')
                        .click(function() {
                            $that.switchPb(false, $(this).attr('id'));
                        }).end()
                        .prepend( 
                                $('<a id="content-composer" class="wp-switch-editor switch-revo" ><span></span></a>')
                                .click(function() {
                                    $that.switchPb(true);
                                    return false;
                                })
                                );
                if ($('.jaw_pb_startup').val() == 'true') {
                    $that.switchPb(true);
                }

                if ($(document).width() < 1024) {
                    postboxes._pb_edit(1);
                }
                
            }
            $that.resize();
            $that.moveModal();
        },
        switchPb: function(state, id) {
            var $that = this;
            if (state) {
                $('#wp-content-wrap').removeClass('tmce-active html-active');
                document.getElementById("wp-content-editor-container").style.display = "none";
                document.getElementById("content-resize-handle").style.display = "none";
                document.getElementById("post-status-info").style.display = "none";
                $('#wp-content-wrap').append($('.jaw_builder_app'));
                $('.jaw_builder_app').show();
                $('#wp-content-wrap').addClass('composer-active');
                setUserSetting('editor', 'composer');
                // Triggers full refresh
                $(window).resize(); //byl tady try/catch, ale diky optimalizaci zmizel
                $('.jaw_pb_startup').val('true');
            } else {
                $('#wp-content-wrap').removeClass('composer-active');
                $('.jaw_builder_app').hide();
                document.getElementById("wp-content-editor-container").style.display = "block";
                document.getElementById("content-resize-handle").style.display = "block";
                document.getElementById("post-status-info").style.display = "block";
                $(window).resize(); //byl tady try/catch, ale diky optimalizaci zmizel
                $('.jaw_pb_startup').val('false');
                if (id == 'content-tmce') {
                    document.getElementById("ed_toolbar").style.display = "none";
                    document.getElementById("content_parent").style.display = "block";
                    $('#wp-content-wrap').addClass('tmce-active');
                } else {
                    document.getElementById("ed_toolbar").style.display = "block";
                    document.getElementById("content_parent").style.display = "none";
                    $('#wp-content-wrap').addClass('html-active');
                }
            }
        },
        moveModal: function(){
            var $wp_link_backdrop = $("#wp-link-backdrop").clone();
            $("#wp-link-backdrop").remove();
            $("body").append($wp_link_backdrop);
            var $wp_link_wrap = $("#wp-link-wrap").clone();
            $("#wp-link-wrap").remove();
            $("body").append($wp_link_wrap);
        },
        resize: function() {
            $('.jb-sidebar').height($("#item-2_content").height());
        }
    };

    if (!Array.prototype.indexOf)
    {
        Array.prototype.indexOf = function(elt /*, from*/)
        {
            var len = this.length >>> 0;
            var from = Number(arguments[1]) || 0;
            from = (from < 0)
                    ? Math.ceil(from)
                    : Math.floor(from);
            if (from < 0)
                from += len;
            for (; from < len; from++)
            {
                if (from in this &&
                        this[from] === elt)
                    return from;
            }
            return -1;
        };
    }


    $(document).ready(function() {
        jawBuilderApp = new jaw_app();
        jawBuilderApp.init();
    });





})(jQuery, angular, window);
