'use strict';
(function (angular, window, undefined) {

    var controllers = angular.module('jwPbControllers', ['jwPbServices', 'jwServices', 'jwEditor']);

    controllers.controller('jwPbBuilderController', [
        '$scope',
        '$timeout',
        '$window',
        'jwPbDebugService',
        'jwPbWorkspaceService',
        'jwPbElementService',
        'jwPbDefaultContents',
        'jwPbConfig',
        'jwPbUtilsService',
        'jwPbDialogService',
        'jwsAjaxService',
        'jwsJson',
        'jwsUtils',
        function ($scope, $timeout, $window, jwPbDebugService, jwPbWorkspaceService, jwPbElementService, jwPbDefaultContents, jwPbConfig, jwPbUtilsService, jwPbDialogService, jwsAjaxService, jwsJson, jwsUtils) {

            // Options pro ui-sortable
            $scope.sortableOptions =
                {
                    'ui-floating': true,
                    //class placeholderu
                    placeholder: "ui-sortable-placeholder",
                    // pokud chci oprovat s elementy pres vice polí musim jej takto spojit.
                    connectWith: ".jwpb-childs",
                    //akce pri dragnuti elementu
                    start: function (e, ui) {
                        // zneaktivnim ukladani
                        jwPbUtilsService.disable_save();
                        setTimeout(function () {
                            // nastavim vysku placeholderu na vysku aktualne drzeneho eleentu
                            jQuery('.ui-sortable-placeholder').height(jQuery('.ui-sortable-helper').height());
                            jQuery('.ui-sortable-placeholder').width(jQuery('.ui-sortable-helper').width());
                        }, 100);
                    },
                    // akce pri dropnuti elementu
                    stop: function (e, ui) {
                        // povoleni ukladani
                        jwPbUtilsService.enable_save();
                    },
                    delay: 200
                };


            // DEFAULT VALUES
            // presets - ukladaji se zde jmena presetu pro cele page i pro jednotlive elementy
            $scope.presets = [];
            // current_bookmark - aktualni zobrazena zalozka (defaultne home)
            $scope.current_bookmark = 'bookmark-build_bookmark_home';
            // searchText - slouzi jako model pro vyhledavaci retezec
            $scope.searchText = "";
            // loader - slouzi jako model pro zobrazeni kolovratu (otacelicich se kolecek - loadingu)
            $scope.loader = [];
            // workspace - Zde jsou ulezana data o aktualni strace (MODEL)
            $scope.workspace = {};
            // builder_ws_index - index nasledujiciho pridaneho elementu - uklada se do databaze - mel by byt pro danou situ jedinecny
            $scope.builder_ws_index = 0;
            // isInitalized - uchovava info o tom zda-li byl revoComposer zinicializovan
            $scope.isInitalized = "";
            // pouziti v kombinaci s timerem - po kliku se spusti jen jeden vykakovaci dialog
            $scope.contextMenuTimer = false;
            // aktualni element s otevrenym kontextovym menu
            $scope.contextMenuItem = {};


            // API pro services
            // predani service config kde jsou ulozeny informace o elementech - s jejich pomoci muzeme dostat info o ikone, aniz by musela byt zkopirovana ve workspace objektu
            $scope.getConfig = jwPbConfig.get;

            // zinicializuje builder_ws_index (index nasledujicicho vlozeneho elementu) - mel by byt unikatni
            $scope.init_index = function (data) {
                if (typeof (data) === 'number')
                    $scope.builder_ws_index = data;
            };

            /****************************************************************
            * INIT Builder
            ****************************************************************/
            $scope.init_builder = function (data) {
                //default content slouzi pri prvnim nacteni revoComposeru - data se pouziji jako default pro workspace nebo se pouziji pri resetu revoComposeru
                jwPbDefaultContents.content = jw_areas;
                //do worspace predam nactena data
                $scope.workspace = angular.copy(jwPbWorkspaceService.init($window.jw_pb[data]));
                //do configu jsou ulozena data s informaci o elementech (dale si je muzeme brat napr pro info o ikone, ...)
                if (jw_fields.length > 0)
                    jwPbConfig.set(jw_fields[0]);
                // povolim ukladaci tlačítko
                jwPbUtilsService.enable_save();
                // nastavim stav initializace
                $scope.isInitalized = 'initialized';
            };


            /****************************************************************
             * CONTROL ELEMENTS
             ****************************************************************/
            //ADD element to workspace
            $scope.add_element = function (data, where) {
                // zneaktivnim ukladani
                jwPbUtilsService.disable_save();
                // pridam aktualni ID
                data = angular.extend(data, { id: $scope.builder_ws_index });
                // vlastni pridani noveho itemu
                var new_item = jwPbWorkspaceService.add($scope.workspace[where].childs, data);
                // inkrementace ID
                $scope.builder_ws_index++;
                // povoleni ukladani
                jwPbUtilsService.enable_save();
                // novy item je vrácen
                return new_item;
            };

            //DELETE element
            $scope.delete_element = function (id, parent) {
                // zneaktivnim ukladani
                jwPbUtilsService.disable_save();
                // Vlastni smazani
                jwPbWorkspaceService.delete(id, parent);
                // povoleni ukladani
                jwPbUtilsService.enable_save();
            };

            //CLONE element
            $scope.clone_element = function (item, parent) {
                // zneaktivnim ukladani
                jwPbUtilsService.disable_save();
                // vytvorim kopii aktualniho itemu s novym ID
                var new_item = angular.extend(angular.copy(item), { id: $scope.builder_ws_index });
                // pridam ho do workspace
                jwPbWorkspaceService.add(parent.childs, new_item);
                // inkrementace ID
                $scope.builder_ws_index++;
                // log
                jwPbDebugService('Element ' + item.id + ' has been cloned (jwPbControllerBuilder.clone_element)');
                // povoleni ukladani
                jwPbUtilsService.enable_save();
            };

            //RESIZE element
            $scope.change_size = function (item, scale_direction) {  //scale_direction    false - down ;  true - up
                // zneaktivnim ukladani
                jwPbUtilsService.disable_save();
                // resize
                jwPbElementService.changeSize(item, scale_direction);
                // zkontroluju sirku pro content
                $scope.check_width();
                // povoleni ukladani
                jwPbUtilsService.enable_save();
            };

            $scope.set_fullwidth = function (item) {
                // zneaktivnim ukladani
                jwPbUtilsService.disable_save();
                // resize
                jwPbElementService.changeSizeAt(item, 12);
                // zkontroluju sirku pro content
                $scope.check_width();
                // povoleni ukladani
                jwPbUtilsService.enable_save();
            }

            //EDIT element
            $scope.edit_element = function (item) {
                if (jwPbUtilsService.is_save_enabled()) {
                    $scope.loader[item.id] = true;
                    jwPbUtilsService.disable_save();
                    jwPbElementService.edit(item, function () {
                        $scope.loader[item.id] = false;
                        jwPbUtilsService.enable_save();
                    });
                    jwPbDebugService('Edit of item ' + item.id + ' has been initialized (jwPbBuilderController.edit_element)');
                }
            };

            $scope.toggle_visible_element = function (item) {
                item.visible = !item.visible;
            }

            //presunout do utils
            $scope.check_width = function () {
                var width = 12;
                angular.forEach(jwPbDefaultContents.content.sidebar, function (value, key) {
                    if ($scope.workspace[value.id] !== undefined) {
                        if ($scope.workspace[value.id].visible) {
                            width -= $scope.workspace[value.id].size;
                        }
                    }
                });
                $scope.workspace['2_content'].size = width;
            };


            //search
            $scope.isSearch = function (text) {
                return (text.toLowerCase().search($scope.searchText.toLowerCase()) > -1);
            };

            $scope.changeSearch = function () {
                $scope.current_bookmark = 'bookmark-build_all';
            };

            //reset content
            $scope.resetContent = function () {
                if (confirm('Delete Content\n\nAre you sure? All unsave actions will be lost.')) {
                    jwPbUtilsService.disable_save();
                    $scope.workspace = jwPbWorkspaceService.init(null);
                    jwPbUtilsService.enable_save();
                }
            };


            /****************************************************************
             * LAYOUTS
             ****************************************************************/



            /**
             * Stara se o zmenu layoutu
             */
            $scope.change_layout = function (new_layout) {
                jwPbDebugService('Layout has been changed to: ' + new_layout);
                var sidebars = new_layout.split('_');

                angular.forEach(jwPbDefaultContents.content.sidebar, function (value, key) {
                    if ($scope.workspace[value.id] !== undefined) {
                        $scope.workspace[value.id].visible = false;
                    }
                });

                if (sidebars != 'fullwidth') {
                    angular.forEach(sidebars, function (value, key) {
                        $scope.workspace['sidebar_' + value].visible = true;
                    });
                }

                $scope.check_width();

                //resize sidebars
                jwPbUtilsService.checkHeight();
            };



            /**
             * Meni sirku main contentu v zavislosti na layoutu
             */
            $scope.size_of_workspace = function (layout) {
                var size = 12;
                angular.forEach(layout, function (value, key) {
                    if (value.visible == true) {
                        size -= value.size;
                    }
                });
                return size;
            };




            /****************************************************************
             * PRESSETS
             ****************************************************************/



            $scope.add_preset = function (data, id, typ) {
                if (jwPbUtilsService.is_save_enabled()) {
                    $scope.loader['add_' + id] = true;
                    jwPbUtilsService.disable_save();
                    if (angular.isUndefined($scope.presets[typ]) || $scope.presets[typ].length == 0) {
                        $scope.presets[typ] = new Array;
                    }
                    jwPbDialogService.open({ metabox: { preset_name: '' } }, 'metabox', '?action=jaw_builder_editor&jaw_code=add_preset', function (result) {
                        if (result !== undefined) {
                            var uniqueID = jwsUtils.getUniqueId();
                            $scope.presets[typ].push({
                                'id': uniqueID,
                                'title': result.preset_name || uniqueID
                            });
                            var new_preset = {};
                            new_preset.id = uniqueID;
                            new_preset.title = result.preset_name || uniqueID;
                            new_preset.data = angular.copy(data);
                            var new_preset_string = JSON.stringify(new_preset);
                            new_preset_string = new_preset_string.replace(/'/ig, '`');
                            jwsAjaxService.send({
                                'action': 'pb_add_preset',
                                'jaw_pb_preset': new_preset_string,
                                'jaw_pb_typ': typ
                            }, function () {
                                $scope.loader['add_' + id] = false;
                                jwPbUtilsService.enable_save();
                            });
                        } else {
                            $scope.loader['add_' + id] = false;
                            jwPbUtilsService.enable_save();
                        }
                    });
                }
            };

            $scope.load_preset = function (id) {
                if (confirm('Load Preset\n\nAre you sure? All unsave actions will be lost.')) {
                    jwPbUtilsService.disable_save();
                    $scope.loader['load_' + id] = true;
                    jwsAjaxService.send({
                        'action': 'pb_load_preset',
                        'jaw_pb_preset_name': id,
                        'jaw_pb_typ': 'revo'
                    }, function (response) {
                        $scope.workspace = response.data;
                        $scope.loader['load_' + id] = false;
                    });
                    jwPbUtilsService.enable_save();
                }
            };
            $scope.load_element_preset = function (id) {
                if (confirm('Load Element Preset\n\nAre you sure?')) {
                    jwPbUtilsService.disable_save();
                    $scope.loader['load_' + id] = true;
                    jwsAjaxService.send({
                        'action': 'pb_load_preset',
                        'jaw_pb_preset_name': id,
                        'jaw_pb_typ': 'revoelement'
                    }, function (response) {
                        response.data.id = $scope.builder_ws_index;
                        $scope.builder_ws_index++;
                        jwPbWorkspaceService.add($scope.workspace['2_content'].childs, response.data);
                        $scope.loader['load_' + id] = false;
                    });
                    jwPbUtilsService.enable_save();
                }
            };

            $scope.delete_preset = function (id, preset,typ) {
                if (confirm('Delete Preset\n\nWarning: Really want to delete this preset: ' + preset.title)) {
                    $scope.loader['delete_' + preset.id] = true;
                    jwsAjaxService.send({
                        'action': 'pb_delete_preset',
                        'jaw_pb_preset_name': preset.id,
                        'jaw_pb_typ': typ
                    }, function () {
                        $scope.presets[typ].splice(id, 1);
                        $scope.loader['delete_' + preset.id] = false;
                    });
                }
            };

            $scope.save_preset = function (data, preset, typ) {
                if (confirm('Save Preset\n\nWarning: Old data will be rewritten')) {
                    $scope.loader['save_' + preset.id] = true;
                    var new_preset = {};
                    new_preset.id = preset.id;
                    new_preset.title = preset.title;
                    new_preset.data = angular.copy(data);
                    var new_preset_string = JSON.stringify(new_preset);
                    new_preset_string = new_preset_string.replace(/'/ig, '`');
                    jwsAjaxService.send({
                        'action': 'pb_add_preset',
                        'jaw_pb_preset': new_preset_string,
                        'jaw_pb_typ': typ
                    }, function () {
                        $scope.loader['save_' + preset.id] = false;
                    });
                }
            };

            $scope.init_presets = function (data, typ) {
                if (data != null) {
                    $scope.presets[typ] = data;
                }
            };



            /****************************************************************
             * UTILS
             ****************************************************************/
            $scope.replace_element_name = function (name) {
                if (name !== undefined) {
                    name = name.replace('build_', '');
                    return name.replace(/\_/g, ' ');
                } else {
                    return '';
                }
            };
            $scope.json_decode = jwsJson.decode;

            $scope.contextMenu = function (one, event) {
                if (!$scope.contextMenuTimer && one.id > 0) {

                    // hide context menu
                    angular.element('.jaw_builder_app').one('click', function () {
                        angular.element('.jaw-builder-context-menu').hide();
                    });
                    
                    var $element = angular.element(event.currentTarget).parents('.jaw_builder_app');

                    $scope.contextMenuItem = one;
                    $element.find('.jaw-builder-context-menu').show();
                    var _x = event.clientX - $element.offset().left;
                    var _y = event.clientY + angular.element(window).scrollTop() - $element.offset().top - 8;
                    $element.find('.jaw-builder-context-menu').css('left', _x);
                    $element.find('.jaw-builder-context-menu').css('top', _y);
                    $scope.contextMenuTimer = true;



                    setTimeout(function () {
                        $scope.contextMenuTimer = false;
                    }, 100);
                }

            };




        }]);



    controllers.controller('jwPbEditorController', [
        '$scope',
        '$timeout',
        'dialog',
        'jwPbDebugService',
        'jwPbDialogService',
        function ($scope, $timeout, dialog, jwPbDebugService, jwPbDialogService) {

            //pri otevreni EDITORU - se spusti toto prvni


            // potreba refaktoring

            //init dat
            $scope.edit = dialog.options.metabox;
            $scope.bookmarks = [];
            $scope.active_bookmark = 0;
            $scope.editor_index = 0;
            $scope.initialized = false;

            $timeout(function () {

                jaw_admin_theme.ready();
                angular.element('body').addClass('modal_open');
                jaw_admin_theme.tinyMCE.initTinyMCE();

                // vytvoreni zalozek
                if (jQuery('#editor_container_' + $scope.editor_index + ' .content > .section.sub_all').length > 0) {
                    jQuery.each(jQuery('#editor_container_' + $scope.editor_index + ' .content > .section.sub_all'), function ($entity) {
                        $scope.bookmarks.push(jQuery(this).find('h3').html());
                    });
                }
                $scope.initialized = true;
                $scope.switch_mark(0);
            });

            // nacteni indexu aktualniho modalniho okna.
            $scope.init_editor = function (index) {
                $scope.editor_index = index;
            };

            //Switch bookmarks
            $scope.switch_mark = function (i) {
                $scope.active_bookmark = i;
                jQuery('#editor_container_' + $scope.editor_index + ' .content > .section.sub_all').hide();
                jQuery('#editor_container_' + $scope.editor_index + ' .content > .section.sub_all').eq(i).show();
                jQuery('#editor_container_' + $scope.editor_index + ' .content > .section.sub_all').eq(i).find("img.jaw-lazy").trigger("unveil");
            };
            //  SAVE
            $scope.save_editor = function () {
                angular.element('body').removeClass('modal_open');
                jQuery('#editor_container_' + $scope.editor_index).find('.jaw-editor-area').each(function () {
                    if (jaw_editor_open && window.tinyMCE.get(jQuery(this).attr('id')) !== undefined) {
                        $scope.edit[jQuery(this).attr('id')] = window.tinyMCE.get(jQuery(this).attr('id')).getContent();
                        jaw_admin_theme.tinyMCE.cancel_wp_editor(jQuery(this).attr('id'));
                    }
                });
                dialog.close($scope.edit);
            };
            //  CANCEL
            $scope.cancel_editor = function () {
                angular.element('body').removeClass('modal_open');
                jQuery('#editor_container_' + $scope.editor_index).find('.jaw-editor-area').each(function () {
                    jaw_admin_theme.tinyMCE.cancel_wp_editor(jQuery(this).attr('id'));
                });
                dialog.close();
            };

            $scope.check_blank = function (item, callback) {
                if ($scope.edit[item] !== undefined && $scope.edit[item] !== '') {
                    callback();
                } else {
                    alert('Please set ' + item);
                }
            }

        }]);

    var controllersEditor = angular.module('jwEditor', [
        'ui.bootstrap',
        'ui.sortable',
        'jwDirectives',
        'jwDirectives',
        'colorpicker.module',
        'jaw.gallerypicker',
        'jaw.simplemediapicker',
        'jwPbServices',
        'jwServices'
    ]);

    controllersEditor.controller('jwEditorController', [
        '$scope',
        '$timeout',
        '$compile',
        '$rootScope',
        'jwPbDebugService',
        'jwPbDialogService',
        'jwsAjaxService',
        'jwsJson',
        'jwsEditData',
        'jwsUtils',
        function ($scope, $timeout, $compile, $rootScope, jwPbDebugService, jwPbDialogService, jwsAjaxService, jwsJson, jwsEditData, jwsUtils) {

            // Pole ve kterém jsou vsechny optiony (model)
            $scope.edit = $scope.edit || {};
            // Pole do ktereho jsou nacitany optiony selectu
            $scope.options = $scope.options || {};
            // Model starajici se o tocici se kolecko
            $scope.loader = [];
            // stara se, aby bylo jen jedno kolecko roztoceno
            $scope.isSomeLoaderOpen = false;
            // Aktualne otevrena zalozka 
            $scope.active_bookmark = 0;

            // Init editor s ID
            $scope.init_editor = function (index) {
                // ID divu editoru
                $scope.editor_index = index;
            };

            angular.element(window).load(function () {
                $timeout(function () {
                    $scope.loader['theme_options'] = true;
                    $rootScope.$broadcast('jwTOLoadDone');
                    angular.element(window).trigger('jwTOLoadDone');
                    jaw_admin_theme.ready();
                });
            });
            
            
            //  angular.element( document ).on( 'widget-added',function(e,$widget){
            //       $timeout(function() {
            //      var html = angular.element($widget).find('.jw-angular').html();
            //     console.log(html); 
            //     angular.bootstrap(angular.element($widget).find('.jw-angular'), ['jawBuilder']);
            //     $widget.find('.jw-angular').html(
            //         $compile(
            //         html
            //         )($scope)
            //         );
            //       }); 
            // });


            // Switch bookmarks
            $scope.switch_mark = function (i) {
                // nastavim aktualni zalozku
                $scope.active_bookmark = i;
                // hide vsechny sekce
                angular.element('#editor_container_' + $scope.editor_index + ' .content > .section.sub_all').hide();
                // show aktualni sekce
                angular.element('#editor_container_' + $scope.editor_index + ' .content > .section.sub_all').eq(i).show();
            };

            // pridat item do editu - pouziva se v pripade dynamickych zadavatek. napr. list, color presets ...
            $scope.add_edit = function (item, attrs, typ) {
                if (typ === undefined) {
                    typ = 'edit';
                }
                if ($scope[typ][item] === undefined) {
                    $scope[typ][item] = {};
                }
                return jwsEditData.add($scope[typ][item], attrs);
            };

            $scope.clone_edit = function (object, id, attrs, typ) {
                if (attrs != undefined && attrs.title !== undefined && attrs.title === null) {
                    return false;
                }
                if (typ === undefined) {
                    typ = 'edit';
                }

                if ($scope[typ][object][id] === undefined) {
                    $scope[typ][object][id] = [];
                }
                jwPbDebugService('clone_edit -> $scope[typ][item]: ' + $scope[typ][object][id]);
                var obj = angular.copy($scope[typ][object][id]);
                if (Object.keys(attrs).length) {
                    angular.extend(obj, attrs);
                }
                if (angular.isArray($scope[typ][object])) {
                    $scope[typ][object].push(obj);
                } else {
                    $scope[typ][object][jwsUtils.getUniqueId()] = obj;
                }
            };

            $scope.add_edit_check_blank = function (item, callback) {
                var localItem = item;
                return function (data) {
                    if (data === undefined) {
                        var newItem = Object.keys($scope.options[localItem])[Object.keys($scope.options[localItem]).length - 1];
                        $scope.del_edit(localItem, newItem, 'options');
                    }
                    if (callback !== undefined) {
                        callback();
                    }
                };
            };


            //DELETE
            $scope.del_edit = function (object, ide, typ) {
                if (typ === undefined) {
                    typ = 'edit';
                }
                jwsEditData.delete($scope[typ][object], ide);
            };


            $scope.json_decode = jwsJson.decode;

            // INIT object - aby napr. list nebyl na zacatku prazdny
            $scope.init_object = function (item) {
                if ($scope.edit[item] === undefined || ($scope.edit[item].length <= 0)) {
                    $scope.add_edit(item);
                }
                jwPbDebugService('init_object -> item: ' + item);

            };

            /* Is preset used */
            $scope.check_using = function (typ, preset, callback) {
                jwsAjaxService.send({
                    'action': 'jaw_check_preset',
                    'jaw_pb_preset': preset,
                    'jaw_pb_typ': typ
                }, function (response) {
                    if (response !== '1') {
                        callback();
                    } else {
                        if (confirm('This preset is already used!\nDo you want to delete it?')) {
                            callback();
                        }
                    }
                });
            }

            // utilita pro angular ng-styles
            $scope.getStyle = function (property, value) {
                var styles = {};
                // nastavim css property a value
                styles[property] = value;
                return styles;
            };

            /* Init edit and options value */
            $scope.init_item = function (id, std, itemType) {
                if (itemType === undefined) {
                    itemType = 'edit';
                }
                jwPbDebugService('init_item -> actual value ' + itemType + '[' + id + ']: ' + $scope[itemType][id]);
                if ($scope[itemType][id] === undefined) {
                    $scope[itemType][id] = std;
                    jwPbDebugService('init_item -> new value: ' + std);
                }
            };


            /*ADvanced list */
            $scope.listSortableOptions = {
                connectWith: ".list-li-adv"
            };
            $scope.getView = function (item) {
                if (item) {
                    return 'list_item.html';
                }
                return null;
            };
            $scope.badgeList = function (text, items) {
                angular.forEach(items, function (val, k) {
                    val.bullet = text;
                });
            };
            $scope.linkVariables = function (from, to) {
                $scope[to[1]][to[0]] = angular.copy($scope[from[3]][from[0]][from[1]][from[2]]);
                $scope.$watch(to[1] + '[\'' + to[0] + '\']', function (newValue) {
                    $scope[from[3]][from[0]][from[1]][from[2]] = newValue;
                });
            };
            $scope.dialog = function (title) {
                return prompt(title);
            };

            // vraci prvni item z pole (objektu)
            $scope.firstKey = jwsUtils.getFirstKey;


            $scope.openDialog = function (options, item, action, callback) {
                jwPbDialogService.open(options, item, action, callback);
            };

            // zobrazeni tociciho se kolecka
            $scope.loaderClickSet = function (tag) {
                //pokud se netoci jine kolecko
                if (!$scope.isSomeLoaderOpen) {
                    $scope.loader[tag] = true;
                    $scope.isSomeLoaderOpen = true;
                }
            };

            // skryti tociciho se kolecka
            $scope.loaderClickOff = function (tag) {
                var localTag = tag;
                return function () {
                    $scope.loader[localTag] = false;
                    $scope.isSomeLoaderOpen = false;
                };
            };

            $scope.get_callback = function (functionName, args) {
                var localArgs = args;
                return function () {
                    $scope[functionName].apply(null, localArgs);
                }
            }



            var compileWidgets = function (event, element) {
                var html = jQuery(element).find('.widget-content').html();
                $timeout(function () {
                    jQuery(element).find('.widget-content').html(
                        $compile(
                            html
                        )($scope));
                });
            };

            jQuery(document).bind('widget-added', compileWidgets);
            jQuery(document).bind('widget-updated', compileWidgets);

            $scope.saveTO = function () {
                $rootScope.$broadcast('jweBeforeSaveTO');

                var nonce = angular.element('#jaw_security').val();

                angular.element('.ajax-loading-img-inverse').hide();
                angular.element('.ajax-loading-img').show();

                var favicon = angular.element('#favicon').attr("href");

                if (jaw_variables != undefined && jaw_variables['JAW_THEME_URI'] != undefined) {
                    angular.element('#favicon').attr("href", jaw_variables['JAW_THEME_URI'] + "/images/favicon.ico");
                }

                //get serialized data from all our option fields			
                var serializedReturn = angular.element('#of_form :input[name][name!="jaw_security"][name!="of_reset"]').serialize();

                jwsAjaxService.send({
                    type: 'save',
                    action: 'jaw_ajax_action',
                    security: nonce,
                    cache: false,
                    data: serializedReturn
                },
                    function (response) {
                        angular.element('.ajax-loading-img').hide();
                        angular.element('.ajax-loading-img-inverse').show();
                        angular.element('#favicon').attr("href", favicon);
                        if (response == 1) {
                            $rootScope.$broadcast('jweShowInfoDialog', {
                                icon: 'thumbs-up2',
                                title: 'Options Updated',
                                description: "",
                                interval: 5000
                            });
                            $rootScope.$broadcast('jweAfterSaveTO');
                        } else {
                            $rootScope.$broadcast('jweShowInfoDialog', {
                                icon: 'warning',
                                title: 'Error',
                                description: response.substring(0, response.length - 1),
                                buttons: [{ click: "hide()", title: "Close" }],
                                interval: 30000
                            });
                        }
                    });


            };



        }]);

})(angular, window);
