'use strict';
(function (angular, window, ajaxurl, undefined) {



    var services = angular.module('jwServices', []);
    
    
    
    //angular posila AJAX data ve formatu JSON, kdežto WP je chce jako XML
    services.config(function ($httpProvider) {
        // send all requests payload as query string
        $httpProvider.defaults.transformRequest = function (data) {
            if (data === undefined) {
                return data;
            }
            return jQuery.param(data);
        };
    
        // set all post requests content type
        $httpProvider.defaults.headers.post['Content-Type'] = 'application/x-www-form-urlencoded; charset=UTF-8';
    });
    
    
    /**
     *  AJAX service
     */
    services.factory('jwsAjaxService', ['$http', 'jwPbDebugService', function ($http, jwPbDebugService) {
        var factory = {};
        factory.send = function (object, callbackSuccess, callbackError) {
            $http.post(
                ajaxurl,
                angular.extend({ security: angular.element('#_wpnonce').val() }, object)
                )
                .then(
                    //success
                    function successCallback(data, status, headers, config) {
                        if (callbackSuccess != undefined) {
                            callbackSuccess(data.data);
                        }
                    },
                    //error
                    function errorCallback(data, status, headers, config) {
                        jwPbDebugService('ERROR '+data.status+'!', 'group');
                        jwPbDebugService('ERROR '+data.status+' during AJAX: '+ data.statusText, 'error');
                        jwPbDebugService('contact jaw support at jaw(a)jawtemplates.com', 'log');
                        jwPbDebugService('', 'groupEnd');
                        if (callbackError != undefined) {
                            callbackError(data.data);
                        }
                    });
        };
        return factory;
    }]);

   
    
   
    /*
    * Work with json
    */
    services.factory('jwsJson', function () {
        var factory = {};
        factory.decode = function (json_str) {
            ret = json_str;
            if (typeof (json_str) == 'string') {

                var decode = json_str;
                decode = decode.replace(/\'/ig, '\"');
                
                var r = /\\u([\d\w]{4})/gi;
                decode = decode.replace(r, function (match, grp) {
                    return String.fromCharCode(parseInt(grp, 16));
                });

                decode = unescape(decode);
                decode = decode.replace(/\\/ig, '');
                
                var ret = '';
                if (decode != '') {
                    ret = JSON.parse(decode);
                }
            }
            return (ret);
        };
        return factory;
    });


    /* 
    * Create unique ID
    */
    services.factory('jwsUtils', function () {
        var factory = {};
        // vraci unikátní ID - timestamp
        factory.getUniqueId = function () {
            return 'ts_' + Date.now();
        };
        // vraci prvni item z pole (objektu)
        factory.getFirstKey = function (obj) {
            for (var k in obj) {
                return k;
                break;
            }
        };
        return factory;
    });

    /*
    * Context menu
    */
    services.factory('jwsContextMenu', function () {
        var factory = {};
        factory.open = function ($contextItem, $parent, event) {
            var timer = 0;
            $contextItem.show();
            var _x = event.clientX - $parent.offset().left;
            var _y = event.clientY + angular.element(window).scrollTop() - $parent.offset().top;
            $contextItem.css('left', _x);
            $contextItem.css('top', _y);

            timer = setTimeout(function () {
                factory.close($contextItem, $parent);
            }, 500);
        };
        factory.close = function ($contextItem) {
            angular.element('body').one('click', function (event) {
                $contextItem.hide();
            });
        }

        return factory;
    });
    


    services.factory('jwsEditData', ['jwPbDebugService', 'jwsUtils', function (jwPbDebugService, jwsUtils) {
        var factory = {};
        factory.add = function (where, attrs) {
            if (attrs != undefined && attrs.title !== undefined && attrs.title === null) {
                return false;
            }
            if (where === undefined) {
                where = {};
            }
            jwPbDebugService('add_edit -> where: ' + where + ' (jwsEditData.add)');
            var id = 0;
            if (angular.isArray(where)) {
                var obj = {};
                if (attrs !== undefined && Object.keys(attrs).length) {
                    angular.extend(obj, attrs);
                }
                where.push(angular.copy(attrs)); //added 02/2016 - angular.copy muze zpusobovat problemy
                id = where.length - 1;
            } else {
                //do budoucna - vse predelat na object - ale pro Customization API se to moc nehodi
                id = jwsUtils.getUniqueId();
                where[id] = angular.copy(attrs); //added 02/2016 - angular.copy muze zpusobovat problemy
            }
            return id;
        };
        factory.delete = function (where, id) {
            if (angular.isArray(where)) {
                where.splice(id, 1);
            } else {
                delete where[id];
            }
        };

        return factory;
    }]);



})(angular, window, ajaxurl);